import pygame, math, sys
from pygame.locals import *
WIDTH = 1024
HEIGHT = 768
screen = pygame.display.set_mode((WIDTH, HEIGHT))
clock = pygame.time.Clock()

class CarSprite(pygame.sprite.Sprite):
	MAX_FORWARD_SPEED = 10
	MAX_REVERSE_SPEED = 10
	ACCELERATION = 2
	TURN_SPEED = 5

	def __init__(self, image, position):
		pygame.sprite.Sprite.__init__(self)
		self.src_image = pygame.image.load(image)
		self.position = position
		self.speed = self.direction = 0
		self.k_left = self.k_right = self.k_down = self.k_up = 0

	def update(self):
		self.speed += self.k_up + self.k_down
		if self.speed > self.MAX_FORWARD_SPEED:
			self.speed = self.MAX_FORWARD_SPEED
		if self.speed < -self.MAX_FORWARD_SPEED:
			self.speed = - self.MAX_FORWARD_SPEED
		self.direction += self.k_right + self.k_left
		x, y = self.position
		rad = self.direction * math.pi / 180
		x += -self.speed * math.sin(rad)
		y += -self.speed * math.cos(rad)
		self.position = (x, y)
		self.image = pygame.transform.rotate(self.src_image, self.direction)
		self.rect = self.image.get_rect()
		self.rect.center = self.position

class PadSprite(pygame.sprite.Sprite):
	normal = pygame.image.load('pad_normal.png')
	hit = pygame.image.load('pad_hit.png')

	def __init__(self, number, position):
		pygame.sprite.Sprite.__init__(self)
		self.number = number
		self.rect = pygame.Rect(self.normal.get_rect())
		self.rect.center = position
		self.image = self.normal

	def update(self, hit_list):
		if self in hit_list:
			self.image = self.hit
		else:
			self.image = self.normal

pad_rho = 300
curr_pad_theta = 0


pads = [PadSprite(i, (WIDTH/2+pad_rho * math.cos(curr_pad_theta + (i-1)*math.pi/2),
	                  HEIGHT/2+pad_rho * math.sin(curr_pad_theta + (i-1)*math.pi/2)))
        for i in range(1, 5)]

current_pad_number = 0

pad_group = pygame.sprite.RenderPlain(*pads)

rect = screen.get_rect()
car = CarSprite('Car.png', rect.center)
car_group = pygame.sprite.RenderPlain(car)

background = pygame.image.load('track.png')
screen.blit(background, (0, 0))
while 1:
	deltat = clock.tick(30)
	for event in pygame.event.get():
		if not hasattr(event, 'key'): continue
		down = event.type == KEYDOWN
		if event.key == K_RIGHT: car.k_right = down *-5
		elif event.key == K_LEFT: car.k_left = down * 5
		elif event.key == K_UP: car.k_up = down * 2
		elif event.key == K_DOWN: car.k_down = down * -2
		elif event.key == K_ESCAPE: sys.exit(0)

	screen.fill((0, 0, 0))
	car_group.update()
	hit_pads = pygame.sprite.spritecollide(car, pad_group, False)
	if hit_pads:
		hit_pad = hit_pads[0]
		if hit_pad.number == current_pad_number + 1:
			hit_pad.image = hit_pad.hit
			current_pad_number += 1
	elif current_pad_number == 4:
		for pad in pad_group.sprites():
			pad.image = pad.normal
			current_pad_number = 0
	curr_pad_theta += .03
	for i in range(4):
		pads[i].rect.center = \
		(WIDTH/2+pad_rho * math.cos(curr_pad_theta + (i)*math.pi/2),
	                  HEIGHT/2+pad_rho * math.sin(curr_pad_theta + (i)*math.pi/2))

	pad_group.clear(screen, background)
	car_group.clear(screen, background)

	pad_group.draw(screen)
	car_group.draw(screen)
	pygame.display.flip()