(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.1'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[   3624041,      85011]*)
(*NotebookOutlinePosition[   3624812,      85038]*)
(*  CellTagsIndexPosition[   3624768,      85034]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Creazione di grafici \"efficaci\"", "Title",
  PageWidth->PaperWidth],

Cell[CellGroupData[{

Cell["Graficare delle serie temporali", "Section",
  PageWidth->PaperWidth],

Cell["\<\
La seguente cella imposta la directory corrente, assegnandovi la \
directory in cui si trova il notebook corrente:\
\>", "Text",
  PageWidth->PaperWidth],

Cell[CellGroupData[{

Cell[BoxData[
    \(SetDirectory[
      DirectoryName[
        ToFileName["\<FileName\>" /. 
            NotebookInformation[SelectedNotebook[]]]]]\)], "Input",
  CellLabel->"In[1]:=",
  PageWidth->PaperWidth],

Cell[BoxData[
    \("/Users/malchiod/Desktop/Dwnl*ads/visualizzazione"\)], "Output",
  CellLabel->"Out[1]="]
}, Open  ]],

Cell["\<\
Lettura di un dataset  il cui file \[EGrave] posizionato nella \
stessa directory del notebook corrente. I dati corrispondenti sono tratti da \
Nature 368, p. 746, 21 Aprile 1994, e indicano l'indice di gravit\[AGrave] \
dell'encefalomielite allergica sperimentale (experimental allergic \
encephalomeyelitis, EAE) misurata sia su un gruppo di ratti cui era stato \
somministrato un inibitore che su un gruppo non sottoposto a farmaci.\
\>", \
"Text",
  PageWidth->PaperWidth],

Cell[CellGroupData[{

Cell[BoxData[
    \(data = ReadList["\<EAEdata.m\>", {Number, Number, Number}]\)], "Input",
  CellLabel->"In[2]:=",
  PageWidth->PaperWidth],

Cell[BoxData[
    \({{10, 0, 0}, {11, 0, 0}, {12, 0.24`, 0.24`}, {13, 0.35`, 0.35`}, {14, 
        0.45`, 0.45`}, {15, 0.45`, 0.45`}, {16, 1.`, 1.`}, {17, 1.5`, 
        1.`}, {18, 2.35`, 1.`}, {19, 2.`, 1.15`}, {20, 1.5`, 0.825`}, {21, 
        1.35`, 0.5`}, {22, 1.35`, 0.35`}, {23, 1.35`, 0.2`}, {24, 1.35`, 
        0.2`}, {25, 1.35`, 0.2`}, {26, 1.35`, 0.2`}, {27, 1.35`, 0}, {28, 
        0.3`, 0}, {29, 0, 0}, {30, 0, 0}}\)], "Output",
  CellLabel->"Out[2]="]
}, Open  ]],

Cell["\<\
Il dataset \[EGrave] stato organizzato in sotto-liste di tre \
elementi in quanto le componenti di ogni terna di numeri indicano \
rispettivamente il numero di giorni dopo il trattamento e gli indici di \
gravit\[AGrave] della malattia nei ratti trattati e non trattati. Le seguenti \
istruzioni separano i dati per il gruppo trattato e non trattato, nella forma \
{giorno, indice di gravit\[AGrave]}.\
\>", "Text",
  PageWidth->PaperWidth],

Cell[BoxData[{
    \(\(untreated = 
        Map[Part[#, {1, 2}] &, data];\)\), "\[IndentingNewLine]", 
    \(\(treated = Map[Part[#, {1, 3}] &, data];\)\)}], "Input",
  CellLabel->"In[3]:=",
  PageWidth->PaperWidth],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(ListPlot[untreated];\)\), "\[IndentingNewLine]", 
    \(\(ListPlot[treated];\)\)}], "Input",
  CellLabel->"In[5]:=",
  PageWidth->PaperWidth],

Cell[CellGroupData[{

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.452381 0.047619 0.0147151 0.25047 [
[.2619 .00222 -6 -9 ]
[.2619 .00222 6 0 ]
[.5 .00222 -6 -9 ]
[.5 .00222 6 0 ]
[.7381 .00222 -6 -9 ]
[.7381 .00222 6 0 ]
[.97619 .00222 -6 -9 ]
[.97619 .00222 6 0 ]
[.01131 .13995 -18 -4.5 ]
[.01131 .13995 0 4.5 ]
[.01131 .26518 -6 -4.5 ]
[.01131 .26518 0 4.5 ]
[.01131 .39042 -18 -4.5 ]
[.01131 .39042 0 4.5 ]
[.01131 .51565 -6 -4.5 ]
[.01131 .51565 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.2619 .01472 m
.2619 .02097 L
s
[(15)] .2619 .00222 0 1 Mshowa
.5 .01472 m
.5 .02097 L
s
[(20)] .5 .00222 0 1 Mshowa
.7381 .01472 m
.7381 .02097 L
s
[(25)] .7381 .00222 0 1 Mshowa
.97619 .01472 m
.97619 .02097 L
s
[(30)] .97619 .00222 0 1 Mshowa
.125 Mabswid
.07143 .01472 m
.07143 .01847 L
s
.11905 .01472 m
.11905 .01847 L
s
.16667 .01472 m
.16667 .01847 L
s
.21429 .01472 m
.21429 .01847 L
s
.30952 .01472 m
.30952 .01847 L
s
.35714 .01472 m
.35714 .01847 L
s
.40476 .01472 m
.40476 .01847 L
s
.45238 .01472 m
.45238 .01847 L
s
.54762 .01472 m
.54762 .01847 L
s
.59524 .01472 m
.59524 .01847 L
s
.64286 .01472 m
.64286 .01847 L
s
.69048 .01472 m
.69048 .01847 L
s
.78571 .01472 m
.78571 .01847 L
s
.83333 .01472 m
.83333 .01847 L
s
.88095 .01472 m
.88095 .01847 L
s
.92857 .01472 m
.92857 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
.02381 .13995 m
.03006 .13995 L
s
[(0.5)] .01131 .13995 1 0 Mshowa
.02381 .26518 m
.03006 .26518 L
s
[(1)] .01131 .26518 1 0 Mshowa
.02381 .39042 m
.03006 .39042 L
s
[(1.5)] .01131 .39042 1 0 Mshowa
.02381 .51565 m
.03006 .51565 L
s
[(2)] .01131 .51565 1 0 Mshowa
.125 Mabswid
.02381 .03976 m
.02756 .03976 L
s
.02381 .06481 m
.02756 .06481 L
s
.02381 .08986 m
.02756 .08986 L
s
.02381 .1149 m
.02756 .1149 L
s
.02381 .165 m
.02756 .165 L
s
.02381 .19004 m
.02756 .19004 L
s
.02381 .21509 m
.02756 .21509 L
s
.02381 .24014 m
.02756 .24014 L
s
.02381 .29023 m
.02756 .29023 L
s
.02381 .31528 m
.02756 .31528 L
s
.02381 .34033 m
.02756 .34033 L
s
.02381 .36537 m
.02756 .36537 L
s
.02381 .41547 m
.02756 .41547 L
s
.02381 .44051 m
.02756 .44051 L
s
.02381 .46556 m
.02756 .46556 L
s
.02381 .49061 m
.02756 .49061 L
s
.02381 .5407 m
.02756 .5407 L
s
.02381 .56575 m
.02756 .56575 L
s
.02381 .5908 m
.02756 .5908 L
s
.02381 .61584 m
.02756 .61584 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.008 w
.02381 .01472 Mdot
.07143 .01472 Mdot
.11905 .07483 Mdot
.16667 .10238 Mdot
.21429 .12743 Mdot
.2619 .12743 Mdot
.30952 .26518 Mdot
.35714 .39042 Mdot
.40476 .60332 Mdot
.45238 .51565 Mdot
.5 .39042 Mdot
.54762 .35285 Mdot
.59524 .35285 Mdot
.64286 .35285 Mdot
.69048 .35285 Mdot
.7381 .35285 Mdot
.78571 .35285 Mdot
.83333 .35285 Mdot
.88095 .08986 Mdot
.92857 .01472 Mdot
.97619 .01472 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[5]:=",
  PageWidth->PaperWidth,
  ImageSize->{288, 177.938},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003ooooooolQ
ooooo`00DOooool3o`0000?ooooo0ol0000fooooo`Go00000oooool2o`0003Oooooo1Ol00002oooo
o`?o0000>?ooool3o`0000Cooooo0_l00004ooooo`00D_ooool01Ol0003ooooooooooooooooo0000
00?ooooo00?o0000ooooooooool0=?ooool01?l0003oooooooooool00002ooooo`04o`000?oooooo
ooooo`0003Oooooo00Ko0000oooooooooooo0000ooooool00003ooooo`03o`000?oooooooooo03Co
oooo00Go0000ooooooooooooooooo`000002ooooo`04o`000?ooooooooooo`0000?ooooo001Boooo
o`03o`000?oooooooooo00Gooooo00?o0000ooooooooool0=Oooool00ol0003oooooooooo`02oooo
o`04o`000?ooooooooooo`0003Sooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`0h
ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000ooooooooool00Oooool005;ooooo00?o0000
ooooooooool01Oooool00ol0003oooooooooo`0fooooo`05o`000?ooooooooooooooool000000_oo
ool00ol0003oooooooooo`0gooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool0=_oo
ool2o`0000?ooooo00Co0000oooooooooooo00000oooool005;ooooo00Co0000oooooooooooooooo
1?l0000fooooo`05o`000?ooooooooooooooool000000_ooool01?l0003oooooooooool0000foooo
o`06o`000?ooooooooooooooool0003ooooo1?l0000kooooo`04o`000?ooooooooooo`0000;ooooo
00?o0000ooooooooool00Oooool0057ooooo0_l00003ooooo`03o`000?oooooooooo03Oooooo00Go
0000ooooooooooooooooo`000002ooooo`04o`000?ooooooooooo`0003Kooooo00Oo0000oooooooo
ooooooooo`000?oooooo000003[ooooo00Go0000ooooooooooooooooo`000002ooooo`04o`000?oo
ooooooooo`0000?ooooo001Booooo`04o`000?ooooooooooooooo`Go0000=_ooool3o`0000Cooooo
0_l0000hooooo`?o00000_ooool5o`0003Oooooo0ol00004ooooo`;o00001?ooool001Gooooo00?o
0000ooooooooool0ooooool9ooooo`005Oooool00ol0003oooooooooo`3oooooo`Wooooo000Eoooo
o`03o`000?oooooooooo0?oooooo2Oooool001Gooooo00?o0000ooooooooool0ooooool9ooooo`00
3_ooooooo`0001?o0000000Dooooo`;o00002oooool2o`0000cooooo00?o0000ooooooooool02_oo
ool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_oo
ool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_oo
ool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_oo
ool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_oo
ool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_oo
ool00ol0003oooooooooo`0:ooooo`;o00002_ooool2o`0000Oooooo000Eooooo`03o`000?oooooo
oooo03kooooo00?o0000ooooooooool0?Oooool00ol0003oooooooooo`0nooooo`03o`000?oooooo
oooo03kooooo00?o0000ooooooooool01Oooool001Gooooo00?o0000ooooooooool0ooooool9oooo
o`005Oooool00ol0003oooooooooo`3oooooo`Wooooo000Eooooo`03o`000?oooooooooo0?oooooo
2Oooool001Gooooo00?o0000ooooooooool0ooooool9ooooo`005Oooool2o`000?oooooo2_ooool0
01Gooooo00?o0000ooooooooool0ooooool9ooooo`005Oooool00ol0003oooooooooo`3oooooo`Wo
oooo000Eooooo`03o`000?oooooooooo0?oooooo2Oooool001Gooooo00?o0000ooooooooool0oooo
ool9ooooo`005Oooool00ol0003oooooooooo`3oooooo`Wooooo000Eooooo`03o`000?oooooooooo
0?oooooo2Oooool001Gooooo0_l0003oooooo`[ooooo000Eooooo`03o`000?oooooooooo0?oooooo
2Oooool001Gooooo00?o0000ooooooooool05_ooool2o`000?3ooooo000Eooooo`03o`000?oooooo
oooo01Kooooo0_l0003`ooooo`005Oooool00ol0003oooooooooo`3oooooo`Wooooo000Eooooo`03
o`000?oooooooooo0?oooooo2Oooool001Gooooo00?o0000ooooooooool0i_ooool2o`00023ooooo
000Eooooo`;o0000ioooool2o`00023ooooo000Eooooo`03o`000?oooooooooo0?oooooo2Oooool0
01Gooooo00?o0000ooooooooool0ooooool9ooooo`005Oooool00ol0003oooooooooo`0Sooooo`;o
0000hoooool001Gooooo00?o0000ooooooooool08oooool2o`000>?ooooo000Eooooo`03o`000?oo
oooooooo0?oooooo2Oooool001Gooooo0_l0003oooooo`[ooooo000Eooooo`03o`000?oooooooooo
0?oooooo2Oooool001Gooooo00?o0000ooooooooool0ooooool9ooooo`005Oooool00ol0003ooooo
ooooo`0`ooooo`;o00002oooool2o`000<Wooooo000Eooooo`03o`000?oooooooooo033ooooo0_l0
000;ooooo`;o0000bOooool000;ooooo0_l00004ooooo`03o`000?oooooooooo00;ooooo0ol00005
ooooo`03o`000?oooooooooo0?oooooo2Oooool00005ooooool0003oooooooooool000001oooool0
1Ol0003ooooooooooooooooo000000Cooooo00?o0000ooooooooool0ooooool9ooooo`0000Gooooo
o`000?ooooooooooo`00000;ooooo`03o`000?oooooooooo00;ooooo0ol0003oooooo`Wooooo0000
1Ooooooo0000oooooooooooo000000_ooooo00?o0000ooooooooool00_ooool00ol0003ooooooooo
o`3oooooo`Wooooo00001Ooooooo0000oooooooooooo000000Oooooo1?l00005ooooo`03o`000?oo
oooooooo0?oooooo2Oooool00005ooooool0003oooooooooool000001oooool00ol0003ooooooooo
o`06ooooo`03o`000?oooooooooo0?oooooo2Oooool000;ooooo0_l00008ooooo`Go00001?ooool0
0ol0003oooooooooo`3oooooo`Wooooo000Eooooo`03o`000?oooooooooo0?oooooo2Oooool001Go
oooo00?o0000ooooooooool0ooooool9ooooo`005Oooool2o`000?oooooo2_ooool001Gooooo00?o
0000ooooooooool0ooooool9ooooo`005Oooool00ol0003oooooooooo`3oooooo`Wooooo000Eoooo
o`03o`000?oooooooooo0?oooooo2Oooool001Gooooo00?o0000ooooooooool0ooooool9ooooo`00
5Oooool00ol0003oooooooooo`3oooooo`Wooooo000Eooooo`03o`000?oooooooooo0?oooooo2Ooo
ool001Gooooo0_l0003oooooo`[ooooo000Eooooo`03o`000?oooooooooo0?oooooo2Oooool001Go
oooo00?o0000ooooooooool0ooooool9ooooo`005Oooool00ol0003oooooooooo`3oooooo`Wooooo
000Eooooo`03o`000?oooooooooo0?oooooo2Oooool001Gooooo00?o0000ooooooooool0ooooool9
ooooo`005Oooool00ol0003oooooooooo`3oooooo`Wooooo000Eooooo`;o0000ooooool:ooooo`00
5Oooool00ol0003oooooooooo`3oooooo`Wooooo000Eooooo`03o`000?oooooooooo0?oooooo2Ooo
ool001Gooooo00?o0000ooooooooool0ooooool9ooooo`005Oooool00ol0003oooooooooo`3ooooo
o`Wooooo000Eooooo`03o`000?oooooooooo0?oooooo2Oooool001Gooooo0_l0003oooooo`[ooooo
000Eooooo`03o`000?oooooooooo0?oooooo2Oooool001Gooooo00?o0000ooooooooool0ooooool9
ooooo`005Oooool00ol0003oooooooooo`3oooooo`Wooooo000Eooooo`03o`000?oooooooooo0?oo
oooo2Oooool000gooooo0ol00005ooooo`03o`000?oooooooooo0?oooooo2Oooool000kooooo00?o
0000ooooooooool01?ooool00ol0003oooooooooo`3oooooo`Wooooo000>ooooo`03o`000?oooooo
oooo00Cooooo0ol0001:ooooo`;o0000_?ooool000kooooo00?o0000ooooooooool01?ooool00ol0
003oooooooooo`1:ooooo`;o0000_?ooool000kooooo00?o0000ooooooooool01?ooool00ol0003o
ooooooooo`3oooooo`Wooooo000=ooooo`;o00001_ooool00ol0003oooooooooo`3oooooo`Wooooo
000>ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool0ooooool9ooooo`005Oooool0
0ol0003oooooooooo`3oooooo`Wooooo000Eooooo`03o`000?oooooooooo0?oooooo2Oooool001Go
oooo0_l0003oooooo`[ooooo000Eooooo`03o`000?oooooooooo0?oooooo2Oooool001Gooooo00?o
0000ooooooooool0ooooool9ooooo`005Oooool00ol0003oooooooooo`3oooooo`Wooooo000Eoooo
o`03o`000?oooooooooo0?oooooo2Oooool001Gooooo00?o0000ooooooooool0ooooool9ooooo`00
5Oooool00ol0003oooooooooo`3oooooo`Wooooo000Eooooo`;o0000ooooool:ooooo`005Oooool0
0ol0003oooooooooo`3oooooo`Wooooo000Eooooo`03o`000?oooooooooo0?oooooo2Oooool001Go
oooo00?o0000ooooooooool0ooooool9ooooo`005Oooool00ol0003oooooooooo`3oooooo`Wooooo
000Eooooo`03o`000?oooooooooo0?oooooo2Oooool001Gooooo00?o0000ooooooooool0ooooool9
ooooo`005Oooool2o`000?oooooo2_ooool001Gooooo00?o0000ooooooooool0ooooool9ooooo`00
5Oooool00ol0003oooooooooo`3oooooo`Wooooo000Eooooo`03o`000?oooooooooo08_ooooo0_l0
000;ooooo`;o00002oooool2o`0000_ooooo0_l0000;ooooo`;o00002oooool2o`0000_ooooo0_l0
000]ooooo`005Oooool00ol0003oooooooooo`2;ooooo`;o00002oooool2o`0000_ooooo0_l0000;
ooooo`;o00002oooool2o`0000_ooooo0_l0000;ooooo`;o0000;Oooool001Gooooo00?o0000oooo
ooooool0ooooool9ooooo`005Oooool00ol0003oooooooooo`3oooooo`Wooooo000Eooooo`;o0000
ooooool:ooooo`005Oooool00ol0003oooooooooo`3oooooo`Wooooo000Eooooo`03o`000?oooooo
oooo0?oooooo2Oooool001Gooooo00?o0000ooooooooool0ooooool9ooooo`0000Coooooo`000?l0
003o00001?ooool00ol0003oooooooooo`02ooooo`?o00001Oooool00ol0003oooooooooo`3ooooo
o`Wooooo0002ooooo`03o`000?oooooooooo00Oooooo00Go0000ooooooooooooooooo`000004oooo
o`03o`000?oooooooooo0?oooooo2Oooool000;ooooo00?o0000ooooooooool02oooool00ol0003o
ooooooooo`02ooooo`?o0000Eoooool2o`0002Gooooo0_l00028ooooo`000_ooool00ol0003ooooo
ooooo`0;ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0Eoooool2o`0002Gooooo
0_l00028ooooo`000_ooool00ol0003oooooooooo`07ooooo`Co00001Oooool00ol0003ooooooooo
o`3oooooo`Wooooo00000ooooooo0000o`000009ooooo`03o`000?oooooooooo00Kooooo00?o0000
ooooooooool0ooooool9ooooo`000_ooool00ol0003oooooooooo`07ooooo`Go00001?ooool00ol0
003oooooooooo`3oooooo`Wooooo000Eooooo`03o`000?oooooooooo0?oooooo2Oooool001Gooooo
00?o0000ooooooooool0ooooool9ooooo`005Oooool2o`000?oooooo2_ooool001Gooooo00?o0000
ooooooooool0ooooool9ooooo`005Oooool00ol0003oooooooooo`3oooooo`Wooooo000Eooooo`03
o`000?oooooooooo0?oooooo2Oooool001Gooooo00?o0000ooooooooool0ooooool9ooooo`005Ooo
ool00ol0003oooooooooo`3oooooo`Wooooo000Eooooo`03o`000?oooooooooo0?oooooo2Oooool0
01Gooooo0_l0003oooooo`[ooooo000Eooooo`03o`000?oooooooooo0?oooooo2Oooool001Gooooo
00?o0000ooooooooool0ooooool9ooooo`005Oooool00ol0003oooooooooo`3oooooo`Wooooo000E
ooooo`03o`000?oooooooooo0?oooooo2Oooool001Gooooo00?o0000ooooooooool0ooooool9oooo
o`005Oooool00ol0003oooooooooo`3oooooo`Wooooo000Eooooo`;o0000ooooool:ooooo`005Ooo
ool00ol0003oooooooooo`3oooooo`Wooooo000Eooooo`03o`000?oooooooooo0?oooooo2Oooool0
01Gooooo00?o0000ooooooooool0ooooool9ooooo`005Oooool00ol0003oooooooooo`3oooooo`Wo
oooo000Eooooo`03o`000?oooooooooo0?oooooo2Oooool001Gooooo00?o0000ooooooooool0oooo
ool9ooooo`005Oooool2o`000?oooooo2_ooool001Gooooo00?o0000ooooooooool0ooooool9oooo
o`005Oooool00ol0003oooooooooo`3oooooo`Wooooo000Eooooo`03o`000?oooooooooo0?oooooo
2Oooool000cooooo1Ol00004ooooo`03o`000?oooooooooo0?oooooo2Oooool000gooooo00Co0000
oooooooooooo00001?ooool00ol0003oooooooooo`3oooooo`Wooooo000>ooooo`03o`000?oooooo
oooo00Cooooo0ol0001aooooo`;o0000UOooool000oooooo00?o0000ooooooooool00oooool00ol0
003oooooooooo`1aooooo`;o0000UOooool000cooooo00Go0000ooooooooooooooooo`000004oooo
o`03o`000?oooooooooo0?oooooo2Oooool000cooooo00Go0000ooooooooooooooooo`000004oooo
o`03o`000?oooooooooo0?oooooo2Oooool000gooooo0ol00005ooooo`03o`000?oooooooooo0?oo
oooo2Oooool001Gooooo00?o0000ooooooooool0ooooool9ooooo`005Oooool00ol0003ooooooooo
o`3oooooo`Wooooo000Eooooo`;o0000ooooool:ooooo`005Oooool00ol0003oooooooooo`3ooooo
o`Wooooo000Eooooo`03o`000?oooooooooo0?oooooo2Oooool001Gooooo00?o0000ooooooooool0
ooooool9ooooo`005Oooool00ol0003oooooooooo`3oooooo`Wooooo000Eooooo`03o`000?oooooo
oooo0?oooooo2Oooool001Gooooo00?o0000ooooooooool0ooooool9ooooo`005Oooool2o`000?oo
oooo2_ooool001Gooooo00?o0000ooooooooool0ooooool9ooooo`005Oooool00ol0003ooooooooo
o`3oooooo`Wooooo000Eooooo`03o`000?oooooooooo0?oooooo2Oooool001Gooooo00?o0000oooo
ooooool0ooooool9ooooo`005Oooool00ol0003oooooooooo`3oooooo`Wooooo000Eooooo`03o`00
0?oooooooooo0?oooooo2Oooool001Gooooo0_l0003oooooo`[ooooo000Eooooo`03o`000?oooooo
oooo0?oooooo2Oooool001Gooooo00?o0000ooooooooool0ooooool9ooooo`005Oooool00ol0003o
ooooooooo`1Tooooo`;o0000X_ooool001Gooooo00?o0000ooooooooool0I?ooool2o`000:;ooooo
000Eooooo`03o`000?oooooooooo0?oooooo2Oooool001Gooooo00?o0000ooooooooool0ooooool9
ooooo`005Oooool2o`000?oooooo2_ooool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {8.34809, -0.184826, \
0.0771848, 0.0146743}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.452381 0.047619 0.0147151 0.511829 [
[.2619 .00222 -6 -9 ]
[.2619 .00222 6 0 ]
[.5 .00222 -6 -9 ]
[.5 .00222 6 0 ]
[.7381 .00222 -6 -9 ]
[.7381 .00222 6 0 ]
[.97619 .00222 -6 -9 ]
[.97619 .00222 6 0 ]
[.01131 .11708 -18 -4.5 ]
[.01131 .11708 0 4.5 ]
[.01131 .21945 -18 -4.5 ]
[.01131 .21945 0 4.5 ]
[.01131 .32181 -18 -4.5 ]
[.01131 .32181 0 4.5 ]
[.01131 .42418 -18 -4.5 ]
[.01131 .42418 0 4.5 ]
[.01131 .52654 -6 -4.5 ]
[.01131 .52654 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.2619 .01472 m
.2619 .02097 L
s
[(15)] .2619 .00222 0 1 Mshowa
.5 .01472 m
.5 .02097 L
s
[(20)] .5 .00222 0 1 Mshowa
.7381 .01472 m
.7381 .02097 L
s
[(25)] .7381 .00222 0 1 Mshowa
.97619 .01472 m
.97619 .02097 L
s
[(30)] .97619 .00222 0 1 Mshowa
.125 Mabswid
.07143 .01472 m
.07143 .01847 L
s
.11905 .01472 m
.11905 .01847 L
s
.16667 .01472 m
.16667 .01847 L
s
.21429 .01472 m
.21429 .01847 L
s
.30952 .01472 m
.30952 .01847 L
s
.35714 .01472 m
.35714 .01847 L
s
.40476 .01472 m
.40476 .01847 L
s
.45238 .01472 m
.45238 .01847 L
s
.54762 .01472 m
.54762 .01847 L
s
.59524 .01472 m
.59524 .01847 L
s
.64286 .01472 m
.64286 .01847 L
s
.69048 .01472 m
.69048 .01847 L
s
.78571 .01472 m
.78571 .01847 L
s
.83333 .01472 m
.83333 .01847 L
s
.88095 .01472 m
.88095 .01847 L
s
.92857 .01472 m
.92857 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
.02381 .11708 m
.03006 .11708 L
s
[(0.2)] .01131 .11708 1 0 Mshowa
.02381 .21945 m
.03006 .21945 L
s
[(0.4)] .01131 .21945 1 0 Mshowa
.02381 .32181 m
.03006 .32181 L
s
[(0.6)] .01131 .32181 1 0 Mshowa
.02381 .42418 m
.03006 .42418 L
s
[(0.8)] .01131 .42418 1 0 Mshowa
.02381 .52654 m
.03006 .52654 L
s
[(1)] .01131 .52654 1 0 Mshowa
.125 Mabswid
.02381 .04031 m
.02756 .04031 L
s
.02381 .0659 m
.02756 .0659 L
s
.02381 .09149 m
.02756 .09149 L
s
.02381 .14267 m
.02756 .14267 L
s
.02381 .16826 m
.02756 .16826 L
s
.02381 .19386 m
.02756 .19386 L
s
.02381 .24504 m
.02756 .24504 L
s
.02381 .27063 m
.02756 .27063 L
s
.02381 .29622 m
.02756 .29622 L
s
.02381 .3474 m
.02756 .3474 L
s
.02381 .373 m
.02756 .373 L
s
.02381 .39859 m
.02756 .39859 L
s
.02381 .44977 m
.02756 .44977 L
s
.02381 .47536 m
.02756 .47536 L
s
.02381 .50095 m
.02756 .50095 L
s
.02381 .55214 m
.02756 .55214 L
s
.02381 .57773 m
.02756 .57773 L
s
.02381 .60332 m
.02756 .60332 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.008 w
.02381 .01472 Mdot
.07143 .01472 Mdot
.11905 .13755 Mdot
.16667 .19386 Mdot
.21429 .24504 Mdot
.2619 .24504 Mdot
.30952 .52654 Mdot
.35714 .52654 Mdot
.40476 .52654 Mdot
.45238 .60332 Mdot
.5 .43697 Mdot
.54762 .27063 Mdot
.59524 .19386 Mdot
.64286 .11708 Mdot
.69048 .11708 Mdot
.7381 .11708 Mdot
.78571 .11708 Mdot
.83333 .01472 Mdot
.88095 .01472 Mdot
.92857 .01472 Mdot
.97619 .01472 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[5]:=",
  PageWidth->PaperWidth,
  ImageSize->{288, 177.938},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003ooooooolQ
ooooo`00DOooool3o`0000?ooooo0ol0000fooooo`Go00000oooool2o`0003Oooooo1Ol00002oooo
o`?o0000>?ooool3o`0000Cooooo0_l00004ooooo`00D_ooool01Ol0003ooooooooooooooooo0000
00?ooooo00?o0000ooooooooool0=?ooool01?l0003oooooooooool00002ooooo`04o`000?oooooo
ooooo`0003Oooooo00Ko0000oooooooooooo0000ooooool00003ooooo`03o`000?oooooooooo03Co
oooo00Go0000ooooooooooooooooo`000002ooooo`04o`000?ooooooooooo`0000?ooooo001Boooo
o`03o`000?oooooooooo00Gooooo00?o0000ooooooooool0=Oooool00ol0003oooooooooo`02oooo
o`04o`000?ooooooooooo`0003Sooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`0h
ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000ooooooooool00Oooool005;ooooo00?o0000
ooooooooool01Oooool00ol0003oooooooooo`0fooooo`05o`000?ooooooooooooooool000000_oo
ool00ol0003oooooooooo`0gooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool0=_oo
ool2o`0000?ooooo00Co0000oooooooooooo00000oooool005;ooooo00Co0000oooooooooooooooo
1?l0000fooooo`05o`000?ooooooooooooooool000000_ooool01?l0003oooooooooool0000foooo
o`06o`000?ooooooooooooooool0003ooooo1?l0000kooooo`04o`000?ooooooooooo`0000;ooooo
00?o0000ooooooooool00Oooool0057ooooo0_l00003ooooo`03o`000?oooooooooo03Oooooo00Go
0000ooooooooooooooooo`000002ooooo`04o`000?ooooooooooo`0003Kooooo00Oo0000oooooooo
ooooooooo`000?oooooo000003[ooooo00Go0000ooooooooooooooooo`000002ooooo`04o`000?oo
ooooooooo`0000?ooooo001Booooo`04o`000?ooooooooooooooo`Go0000=_ooool3o`0000Cooooo
0_l0000hooooo`?o00000_ooool5o`0003Oooooo0ol00004ooooo`;o00001?ooool001Gooooo00?o
0000ooooooooool0ooooool9ooooo`005Oooool00ol0003oooooooooo`3oooooo`Wooooo000Eoooo
o`03o`000?oooooooooo0?oooooo2Oooool001Gooooo00?o0000ooooooooool0ooooool9ooooo`00
3_ooooooo`0001?o0000000Dooooo`;o00002oooool2o`0000cooooo00?o0000ooooooooool02_oo
ool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_oo
ool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_oo
ool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_oo
ool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_oo
ool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo0_l0000;ooooo`;o00002ooo
ool2o`0000[ooooo0_l00007ooooo`005Oooool00ol0003oooooooooo`0nooooo`03o`000?oooooo
oooo03gooooo00?o0000ooooooooool0?_ooool00ol0003oooooooooo`0nooooo`03o`000?oooooo
oooo00Gooooo000Eooooo`03o`000?oooooooooo0?oooooo2Oooool001Gooooo00?o0000oooooooo
ool0ooooool9ooooo`005Oooool00ol0003oooooooooo`3oooooo`Wooooo000Eooooo`03o`000?oo
oooooooo0?oooooo2Oooool001Gooooo0_l0003oooooo`[ooooo000Eooooo`03o`000?oooooooooo
0?oooooo2Oooool001Gooooo00?o0000ooooooooool0ooooool9ooooo`005Oooool00ol0003ooooo
ooooo`3oooooo`Wooooo000Eooooo`03o`000?oooooooooo0?oooooo2Oooool001Gooooo00?o0000
ooooooooool0ooooool9ooooo`005Oooool00ol0003oooooooooo`3oooooo`Wooooo000Eooooo`;o
0000ooooool:ooooo`005Oooool00ol0003oooooooooo`3oooooo`Wooooo000Eooooo`03o`000?oo
oooooooo0?oooooo2Oooool001Gooooo00?o0000ooooooooool0ooooool9ooooo`005Oooool00ol0
003oooooooooo`3oooooo`Wooooo000Eooooo`03o`000?oooooooooo0?oooooo2Oooool001Gooooo
00?o0000ooooooooool0ooooool9ooooo`005Oooool2o`000?oooooo2_ooool001Gooooo00?o0000
ooooooooool0ooooool9ooooo`005Oooool00ol0003oooooooooo`3oooooo`Wooooo000Eooooo`03
o`000?oooooooooo0?oooooo2Oooool001Gooooo00?o0000ooooooooool0ooooool9ooooo`000_oo
ool2o`0000Cooooo00Co0000oooooooooooooooo1Ol00004ooooo`03o`000?oooooooooo0?oooooo
2Oooool00005ooooool0003oooooooooool000002?ooool01?l0003oooooooooool00004ooooo`03
o`000?oooooooooo0?oooooo2Oooool00005ooooool0003oooooooooool000002Oooool00ol0003o
ooooooooo`04ooooo`?o0000YOooool2o`0000_ooooo0_l0000;ooooo`;o00002oooool2o`0003[o
oooo00001Ooooooo0000oooooooooooo000000[ooooo00?o0000ooooooooool00oooool00ol0003o
ooooooooo`2Uooooo`;o00002oooool2o`0000_ooooo0_l0000;ooooo`;o0000>_ooool00005oooo
ool0003oooooooooool000001oooool01Ol0003ooooooooooooooooo000000Cooooo00?o0000oooo
ooooool0ooooool9ooooo`0000Goooooo`000?ooooooooooo`000007ooooo`05o`000?oooooooooo
ooooool000001?ooool00ol0003oooooooooo`3oooooo`Wooooo0002ooooo`;o00002Oooool3o`00
00Gooooo00?o0000ooooooooool0ooooool9ooooo`005Oooool00ol0003oooooooooo`0Fooooo`;o
0000l?ooool001Gooooo00?o0000ooooooooool05_ooool2o`000?3ooooo000Eooooo`;o0000oooo
ool:ooooo`005Oooool00ol0003oooooooooo`3oooooo`Wooooo000Eooooo`03o`000?oooooooooo
0?oooooo2Oooool001Gooooo00?o0000ooooooooool0ooooool9ooooo`005Oooool00ol0003ooooo
ooooo`3oooooo`Wooooo000Eooooo`03o`000?oooooooooo0?oooooo2Oooool001Gooooo00?o0000
ooooooooool0ooooool9ooooo`005Oooool2o`000?oooooo2_ooool001Gooooo00?o0000oooooooo
ool0ooooool9ooooo`005Oooool00ol0003oooooooooo`3oooooo`Wooooo000Eooooo`03o`000?oo
oooooooo0?oooooo2Oooool001Gooooo00?o0000ooooooooool0ooooool9ooooo`005Oooool00ol0
003oooooooooo`3oooooo`Wooooo000Eooooo`03o`000?oooooooooo02?ooooo0_l0001cooooo`;o
0000K_ooool001Gooooo0_l0000Tooooo`;o0000Loooool2o`0006kooooo000Eooooo`03o`000?oo
oooooooo0?oooooo2Oooool001Gooooo00?o0000ooooooooool0ooooool9ooooo`005Oooool00ol0
003oooooooooo`3oooooo`Wooooo0002ooooo`;o00001?ooool00ol0003oooooooooo`03ooooo`?o
00001?ooool00ol0003oooooooooo`3oooooo`Wooooo00001Ooooooo0000oooooooooooo000000[o
oooo00?o0000ooooooooool00oooool00ol0003oooooooooo`3oooooo`Wooooo00001Ooooooo0000
oooooooooooo000000Oooooo1Ol00004ooooo`03o`000?oooooooooo0?oooooo2Oooool00005oooo
ool0003oooooooooool000001oooool01?l0003oooooooooool00005ooooo`?o0000ooooool9oooo
o`0000Goooooo`000?ooooooooooo`000008ooooo`03o`000?oooooo000000Gooooo00?o0000oooo
ooooool0ooooool9ooooo`0000Goooooo`000?ooooooooooo`000009ooooo`;o00001Oooool00ol0
003oooooooooo`3oooooo`Wooooo0002ooooo`;o00002oooool00ol0003oooooooooo`03ooooo`03
o`000?oooooooooo0?oooooo2Oooool001Gooooo00?o0000ooooooooool0ooooool9ooooo`005Ooo
ool00ol0003oooooooooo`3oooooo`Wooooo000Eooooo`03o`000?oooooooooo033ooooo0_l0000;
ooooo`;o0000bOooool001Gooooo0_l0000aooooo`;o00002oooool2o`000<Wooooo000Eooooo`03
o`000?oooooooooo0?oooooo2Oooool001Gooooo00?o0000ooooooooool0ooooool9ooooo`005Ooo
ool00ol0003oooooooooo`3oooooo`Wooooo000Eooooo`03o`000?oooooooooo0?oooooo2Oooool0
01Gooooo00?o0000ooooooooool0ooooool9ooooo`005Oooool00ol0003oooooooooo`2;ooooo`;o
0000Noooool001Gooooo0_l0002<ooooo`;o0000Noooool001Gooooo00?o0000ooooooooool0oooo
ool9ooooo`005Oooool00ol0003oooooooooo`3oooooo`Wooooo000Eooooo`03o`000?oooooooooo
0?oooooo2Oooool001Gooooo00?o0000ooooooooool0ooooool9ooooo`005Oooool00ol0003ooooo
ooooo`3oooooo`Wooooo000Eooooo`03o`000?oooooooooo0?oooooo2Oooool001Gooooo0_l0003o
ooooo`[ooooo000Eooooo`03o`000?oooooooooo0?oooooo2Oooool001Gooooo00?o0000oooooooo
ool0ooooool9ooooo`005Oooool00ol0003oooooooooo`3oooooo`Wooooo0002ooooo`;o00001?oo
ool00ol0003oooooooooo`02ooooo`?o00001Oooool00ol0003oooooooooo`3oooooo`Wooooo0000
1Ooooooo0000oooooooooooo000000Oooooo00Go0000ooooooooooooooooo`000004ooooo`03o`00
0?oooooooooo0?oooooo2Oooool00005ooooool0003oooooooooool000001oooool01Ol0003ooooo
oooooooooooo000000Cooooo00?o0000ooooooooool0ooooool9ooooo`0000Goooooo`000?oooooo
ooooo`000007ooooo`Co00001Oooool3o`000?oooooo2Oooool00005ooooool0003oooooooooool0
00001oooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo0?oooooo2Oooool00005oooo
ool0003oooooooooool000002?ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo0?oo
oooo2Oooool000;ooooo0_l0000:ooooo`;o00001Oooool00ol0003oooooooooo`3oooooo`Wooooo
000Eooooo`03o`000?oooooooooo0?oooooo2Oooool001Gooooo00?o0000ooooooooool0ooooool9
ooooo`005Oooool00ol0003oooooooooo`3oooooo`Wooooo000Eooooo`;o0000ooooool:ooooo`00
5Oooool00ol0003oooooooooo`3oooooo`Wooooo000Eooooo`03o`000?oooooooooo0?oooooo2Ooo
ool001Gooooo00?o0000ooooooooool0ooooool9ooooo`005Oooool00ol0003oooooooooo`3ooooo
o`Wooooo000Eooooo`03o`000?oooooooooo0?oooooo2Oooool001Gooooo00?o0000ooooooooool0
ooooool9ooooo`005Oooool2o`000?oooooo2_ooool001Gooooo00?o0000ooooooooool0ooooool9
ooooo`005Oooool00ol0003oooooooooo`3oooooo`Wooooo000Eooooo`03o`000?oooooooooo0?oo
oooo2Oooool001Gooooo00?o0000ooooooooool0ooooool9ooooo`005Oooool00ol0003ooooooooo
o`3oooooo`Wooooo000Eooooo`03o`000?oooooooooo0?oooooo2Oooool001Gooooo0_l0003ooooo
o`[ooooo000Eooooo`03o`000?oooooooooo0?oooooo2Oooool001Gooooo00?o0000ooooooooool0
ooooool9ooooo`005Oooool00ol0003oooooooooo`3oooooo`Wooooo0002ooooo`;o00001?ooool0
0ol0003oooooooooo`02ooooo`?o00001Oooool00ol0003oooooooooo`3oooooo`Wooooo00001Ooo
oooo0000oooooooooooo000000Oooooo00Go0000ooooooooooooooooo`000004ooooo`03o`000?oo
oooooooo0?oooooo2Oooool00005ooooool0003oooooooooool000001oooool01Ol0003ooooooooo
oooooooo000000Cooooo00?o0000ooooooooool0ooooool9ooooo`0000Goooooo`000?oooooooooo
o`000008ooooo`?o00001Oooool3o`000?oooooo2Oooool00005ooooool0003oooooooooool00000
1oooool01Ol0003ooooooooooooooooo000000Cooooo00?o0000ooooooooool0ooooool9ooooo`00
00Goooooo`000?ooooooooooo`000007ooooo`05o`000?ooooooooooooooool000001?ooool00ol0
003oooooooooo`3oooooo`Wooooo0002ooooo`;o00002Oooool3o`0000Gooooo00?o0000oooooooo
ool0O_ooool2o`0008Sooooo000Eooooo`03o`000?oooooooooo07kooooo0_l00028ooooo`005Ooo
ool00ol0003oooooooooo`3oooooo`Wooooo000Eooooo`03o`000?oooooooooo0?oooooo2Oooool0
01Gooooo0_l0003oooooo`[ooooo000Eooooo`03o`000?oooooooooo0?oooooo2Oooool001Gooooo
00?o0000ooooooooool0ooooool9ooooo`005Oooool00ol0003oooooooooo`3oooooo`Wooooo000E
ooooo`03o`000?oooooooooo0?oooooo2Oooool001Gooooo00?o0000ooooooooool0ooooool9oooo
o`005Oooool2o`000?oooooo2_ooool001Gooooo00?o0000ooooooooool0ooooool9ooooo`005Ooo
ool00ol0003oooooooooo`3oooooo`Wooooo000Eooooo`03o`000?oooooooooo0?oooooo2Oooool0
01Gooooo00?o0000ooooooooool0ooooool9ooooo`005Oooool00ol0003oooooooooo`3oooooo`Wo
oooo000Eooooo`03o`000?oooooooooo0?oooooo2Oooool001Gooooo0_l0003oooooo`[ooooo000E
ooooo`03o`000?oooooooooo0?oooooo2Oooool001Gooooo00?o0000ooooooooool0ooooool9oooo
o`005Oooool00ol0003oooooooooo`3oooooo`Wooooo000Eooooo`03o`000?oooooooooo0?oooooo
2Oooool000gooooo0ol00005ooooo`03o`000?oooooooooo0?oooooo2Oooool000kooooo00?o0000
ooooooooool01?ooool00ol0003oooooooooo`3oooooo`Wooooo000>ooooo`03o`000?oooooooooo
00Cooooo0ol0001:ooooo`;o00002oooool2o`0000_ooooo0_l0002Rooooo`003_ooool00ol0003o
ooooooooo`04ooooo`03o`000?oooooooooo04[ooooo0_l0000;ooooo`;o00002oooool2o`000:;o
oooo000>ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool0ooooool9ooooo`003Ooo
ool2o`0000Kooooo00?o0000ooooooooool0ooooool9ooooo`003_ooool00ol0003oooooooooo`04
ooooo`03o`000?oooooooooo0?oooooo2Oooool001Gooooo00?o0000ooooooooool0ooooool9oooo
o`005Oooool00ol0003oooooooooo`3oooooo`Wooooo000Eooooo`;o0000ooooool:ooooo`005Ooo
ool00ol0003oooooooooo`3oooooo`Wooooo000Eooooo`03o`000?oooooooooo0?oooooo2Oooool0
01Gooooo00?o0000ooooooooool0ooooool9ooooo`005Oooool00ol0003oooooooooo`3oooooo`Wo
oooo000Eooooo`03o`000?oooooooooo0?oooooo2Oooool001Gooooo00?o0000ooooooooool0oooo
ool9ooooo`005Oooool2o`000?oooooo2_ooool001Gooooo00?o0000ooooooooool0ooooool9oooo
o`005Oooool00ol0003oooooooooo`3oooooo`Wooooo000Eooooo`03o`000?oooooooooo0?oooooo
2Oooool001Gooooo00?o0000ooooooooool0ooooool9ooooo`005Oooool00ol0003oooooooooo`3o
ooooo`Wooooo000Eooooo`03o`000?oooooooooo0?oooooo2Oooool001Gooooo0_l0001booooo`;o
0000UOooool001Gooooo00?o0000ooooooooool0LOooool2o`0009Gooooo000Eooooo`03o`000?oo
oooooooo0?oooooo2Oooool001Gooooo00?o0000ooooooooool0ooooool9ooooo`005Oooool00ol0
003oooooooooo`3oooooo`Wooooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {8.34809, -0.090447, \
0.0771848, 0.00718104}}]
}, Open  ]]
}, Open  ]],

Cell[TextData[{
  "Ingrandiamo le dimensioni di default dei grafici prodotti da ",
  StyleBox["ListPlot", "Input"],
  ":"
}], "Text",
  PageWidth->PaperWidth],

Cell[CellGroupData[{

Cell[BoxData[
    \(SetOptions[ListPlot, ImageSize \[Rule] 400]\)], "Input",
  CellLabel->"In[7]:=",
  PageWidth->PaperWidth],

Cell[BoxData[
    \({AspectRatio \[Rule] 1\/GoldenRatio, Axes \[Rule] Automatic, 
      AxesLabel \[Rule] None, AxesOrigin \[Rule] Automatic, 
      AxesStyle \[Rule] Automatic, Background \[Rule] Automatic, 
      ColorOutput \[Rule] Automatic, DefaultColor \[Rule] Automatic, 
      DefaultFont \[RuleDelayed] $DefaultFont, 
      DisplayFunction \[RuleDelayed] $DisplayFunction, Epilog \[Rule] {}, 
      FormatType \[RuleDelayed] $FormatType, Frame \[Rule] False, 
      FrameLabel \[Rule] None, FrameStyle \[Rule] Automatic, 
      FrameTicks \[Rule] Automatic, GridLines \[Rule] None, 
      ImageSize \[Rule] 400, PlotJoined \[Rule] False, 
      PlotLabel \[Rule] None, PlotRange \[Rule] Automatic, 
      PlotRegion \[Rule] Automatic, PlotStyle \[Rule] Automatic, 
      Prolog \[Rule] {}, RotateLabel \[Rule] True, 
      TextStyle \[RuleDelayed] $TextStyle, 
      Ticks \[Rule] Automatic}\)], "Output",
  CellLabel->"Out[7]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(ListPlot[untreated];\)\), "\[IndentingNewLine]", 
    \(\(ListPlot[treated];\)\)}], "Input",
  CellLabel->"In[8]:=",
  PageWidth->PaperWidth],

Cell[CellGroupData[{

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
%%ImageSize: 400 247.214 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.452381 0.047619 0.0147151 0.25047 [
[.2619 .00222 -6 -9 ]
[.2619 .00222 6 0 ]
[.5 .00222 -6 -9 ]
[.5 .00222 6 0 ]
[.7381 .00222 -6 -9 ]
[.7381 .00222 6 0 ]
[.97619 .00222 -6 -9 ]
[.97619 .00222 6 0 ]
[.01131 .13995 -18 -4.5 ]
[.01131 .13995 0 4.5 ]
[.01131 .26518 -6 -4.5 ]
[.01131 .26518 0 4.5 ]
[.01131 .39042 -18 -4.5 ]
[.01131 .39042 0 4.5 ]
[.01131 .51565 -6 -4.5 ]
[.01131 .51565 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.2619 .01472 m
.2619 .02097 L
s
[(15)] .2619 .00222 0 1 Mshowa
.5 .01472 m
.5 .02097 L
s
[(20)] .5 .00222 0 1 Mshowa
.7381 .01472 m
.7381 .02097 L
s
[(25)] .7381 .00222 0 1 Mshowa
.97619 .01472 m
.97619 .02097 L
s
[(30)] .97619 .00222 0 1 Mshowa
.125 Mabswid
.07143 .01472 m
.07143 .01847 L
s
.11905 .01472 m
.11905 .01847 L
s
.16667 .01472 m
.16667 .01847 L
s
.21429 .01472 m
.21429 .01847 L
s
.30952 .01472 m
.30952 .01847 L
s
.35714 .01472 m
.35714 .01847 L
s
.40476 .01472 m
.40476 .01847 L
s
.45238 .01472 m
.45238 .01847 L
s
.54762 .01472 m
.54762 .01847 L
s
.59524 .01472 m
.59524 .01847 L
s
.64286 .01472 m
.64286 .01847 L
s
.69048 .01472 m
.69048 .01847 L
s
.78571 .01472 m
.78571 .01847 L
s
.83333 .01472 m
.83333 .01847 L
s
.88095 .01472 m
.88095 .01847 L
s
.92857 .01472 m
.92857 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
.02381 .13995 m
.03006 .13995 L
s
[(0.5)] .01131 .13995 1 0 Mshowa
.02381 .26518 m
.03006 .26518 L
s
[(1)] .01131 .26518 1 0 Mshowa
.02381 .39042 m
.03006 .39042 L
s
[(1.5)] .01131 .39042 1 0 Mshowa
.02381 .51565 m
.03006 .51565 L
s
[(2)] .01131 .51565 1 0 Mshowa
.125 Mabswid
.02381 .03976 m
.02756 .03976 L
s
.02381 .06481 m
.02756 .06481 L
s
.02381 .08986 m
.02756 .08986 L
s
.02381 .1149 m
.02756 .1149 L
s
.02381 .165 m
.02756 .165 L
s
.02381 .19004 m
.02756 .19004 L
s
.02381 .21509 m
.02756 .21509 L
s
.02381 .24014 m
.02756 .24014 L
s
.02381 .29023 m
.02756 .29023 L
s
.02381 .31528 m
.02756 .31528 L
s
.02381 .34033 m
.02756 .34033 L
s
.02381 .36537 m
.02756 .36537 L
s
.02381 .41547 m
.02756 .41547 L
s
.02381 .44051 m
.02756 .44051 L
s
.02381 .46556 m
.02756 .46556 L
s
.02381 .49061 m
.02756 .49061 L
s
.02381 .5407 m
.02756 .5407 L
s
.02381 .56575 m
.02756 .56575 L
s
.02381 .5908 m
.02756 .5908 L
s
.02381 .61584 m
.02756 .61584 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.008 w
.02381 .01472 Mdot
.07143 .01472 Mdot
.11905 .07483 Mdot
.16667 .10238 Mdot
.21429 .12743 Mdot
.2619 .12743 Mdot
.30952 .26518 Mdot
.35714 .39042 Mdot
.40476 .60332 Mdot
.45238 .51565 Mdot
.5 .39042 Mdot
.54762 .35285 Mdot
.59524 .35285 Mdot
.64286 .35285 Mdot
.69048 .35285 Mdot
.7381 .35285 Mdot
.78571 .35285 Mdot
.83333 .35285 Mdot
.88095 .08986 Mdot
.92857 .01472 Mdot
.97619 .01472 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[8]:=",
  ImageSize->{400, 247.188},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006@0000mb000`400?l00000o`00003ooooooonA
ooooo`00KOooool3o`0000?ooooo0ol0001Booooo`Go00000oooool2o`0005;ooooo1Ol00002oooo
o`?o0000D_ooool3o`0000Cooooo0_l00007ooooo`00K_ooool01Ol0003ooooooooooooooooo0000
00?ooooo00?o0000ooooooooool0D?ooool01?l0003oooooooooool00002ooooo`04o`000?oooooo
ooooo`0005;ooooo00Ko0000oooooooooooo0000ooooool00003ooooo`03o`000?oooooooooo04ko
oooo00Go0000ooooooooooooooooo`000002ooooo`04o`000?ooooooooooo`0000Kooooo001^oooo
o`03o`000?oooooooooo00Gooooo00?o0000ooooooooool0DOooool00ol0003oooooooooo`02oooo
o`04o`000?ooooooooooo`0005?ooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`1B
ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000ooooooooool01?ooool006kooooo00?o0000
ooooooooool01Oooool00ol0003oooooooooo`1Booooo`05o`000?ooooooooooooooool000000_oo
ool00ol0003oooooooooo`1Booooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool0D?oo
ool2o`0000?ooooo00Co0000oooooooooooo00001_ooool006kooooo00Co0000oooooooooooooooo
1?l0001Booooo`05o`000?ooooooooooooooool000000_ooool01?l0003oooooooooool0001Aoooo
o`06o`000?ooooooooooooooool0003ooooo1?l0001Eooooo`04o`000?ooooooooooo`0000;ooooo
00?o0000ooooooooool01?ooool006gooooo0_l00003ooooo`03o`000?oooooooooo05?ooooo00Go
0000ooooooooooooooooo`000002ooooo`04o`000?ooooooooooo`00057ooooo00Oo0000oooooooo
ooooooooo`000?oooooo000005Cooooo00Go0000ooooooooooooooooo`000002ooooo`04o`000?oo
ooooooooo`0000Kooooo001^ooooo`04o`000?ooooooooooooooo`Go0000D_ooool3o`0000Cooooo
0_l0001Cooooo`?o00000_ooool5o`00057ooooo0ol00004ooooo`;o00001oooool001Kooooo00?o
0000ooooooooool0oooooomhooooo`005_ooool00ol0003oooooooooo`3oooooogSooooo000Foooo
o`03o`000?oooooooooo0?ooooooN?ooool001Kooooo00?o0000ooooooooool0oooooomhooooo`00
5_ooool00ol0003oooooooooo`3oooooogSooooo000Eooooo`?o00004?ooool3o`000?ooooooB?oo
ool3o`0000oooooo0ol00009ooooo`003Oooooooo`0008?o00000Oooool001Gooooo0ol0000@oooo
o`?o00004?ooool00ol0003oooooooooo`0?ooooo`03o`000?oooooooooo013ooooo00?o0000oooo
ooooool03oooool00ol0003oooooooooo`0?ooooo`03o`000?oooooooooo013ooooo00?o0000oooo
ooooool03oooool00ol0003oooooooooo`0?ooooo`03o`000?oooooooooo013ooooo00?o0000oooo
ooooool03oooool00ol0003oooooooooo`0@ooooo`03o`000?oooooooooo00oooooo00?o0000oooo
ooooool03oooool00ol0003oooooooooo`0@ooooo`03o`000?oooooooooo00oooooo00?o0000oooo
ooooool03oooool00ol0003oooooooooo`0@ooooo`03o`000?oooooooooo00kooooo0ol0000?oooo
o`?o00002Oooool001Kooooo00?o0000ooooooooool04?ooool00ol0003oooooooooo`0?ooooo`03
o`000?oooooooooo00oooooo00?o0000ooooooooool04?ooool00ol0003oooooooooo`0?ooooo`03
o`000?oooooooooo00oooooo00?o0000ooooooooool04?ooool00ol0003oooooooooo`0?ooooo`03
o`000?oooooooooo00oooooo00?o0000ooooooooool04?ooool00ol0003oooooooooo`0?ooooo`03
o`000?oooooooooo013ooooo00?o0000ooooooooool03oooool00ol0003oooooooooo`0?ooooo`03
o`000?oooooooooo013ooooo00?o0000ooooooooool03oooool00ol0003oooooooooo`0?ooooo`03
o`000?oooooooooo013ooooo00?o0000ooooooooool03oooool00ol0003oooooooooo`0?ooooo`03
o`000?oooooooooo00Sooooo000Fooooo`03o`000?oooooooooo05Wooooo00?o0000ooooooooool0
FOooool00ol0003oooooooooo`1Iooooo`03o`000?oooooooooo05Sooooo00?o0000ooooooooool0
2?ooool001Kooooo00?o0000ooooooooool0oooooomhooooo`005_ooool00ol0003oooooooooo`3o
ooooogSooooo000Fooooo`03o`000?oooooooooo0?ooooooN?ooool001Kooooo00?o0000oooooooo
ool0oooooomhooooo`005_ooool00ol0003oooooooooo`3oooooogSooooo000Fooooo`03o`000?oo
oooooooo0?ooooooN?ooool001Kooooo0ol0003oooooogSooooo000Fooooo`03o`000?oooooooooo
0?ooooooN?ooool001Kooooo00?o0000ooooooooool0oooooomhooooo`005_ooool00ol0003ooooo
ooooo`3oooooogSooooo000Fooooo`03o`000?oooooooooo0?ooooooN?ooool001Kooooo00?o0000
ooooooooool0oooooomhooooo`005_ooool00ol0003oooooooooo`3oooooogSooooo000Fooooo`03
o`000?oooooooooo0?ooooooN?ooool001Kooooo00?o0000ooooooooool0oooooomhooooo`005_oo
ool3o`000?ooooooN?ooool001Kooooo00?o0000ooooooooool0oooooomhooooo`005_ooool00ol0
003oooooooooo`3oooooogSooooo000Fooooo`03o`000?oooooooooo027ooooo0ol0003ooooooeCo
oooo000Fooooo`03o`000?oooooooooo027ooooo0ol0003ooooooeCooooo000Fooooo`03o`000?oo
oooooooo027ooooo0ol0003ooooooeCooooo000Fooooo`03o`000?oooooooooo0?ooooooN?ooool0
01Kooooo00?o0000ooooooooool0oooooomhooooo`005_ooool00ol0003oooooooooo`3oooooogSo
oooo000Fooooo`03o`000?oooooooooo0?ooooooB?ooool3o`0002gooooo000Fooooo`?o0000oooo
oom8ooooo`?o0000;Oooool001Kooooo00?o0000ooooooooool0oooooom8ooooo`?o0000;Oooool0
01Kooooo00?o0000ooooooooool0oooooomhooooo`005_ooool00ol0003oooooooooo`3oooooogSo
oooo000Fooooo`03o`000?oooooooooo03?ooooo0ol0003ooooood;ooooo000Fooooo`03o`000?oo
oooooooo03?ooooo0ol0003ooooood;ooooo000Fooooo`03o`000?oooooooooo03?ooooo0ol0003o
oooood;ooooo000Fooooo`03o`000?oooooooooo0?ooooooN?ooool001Kooooo00?o0000oooooooo
ool0oooooomhooooo`005_ooool00ol0003oooooooooo`3oooooogSooooo000Fooooo`?o0000oooo
oomhooooo`005_ooool00ol0003oooooooooo`3oooooogSooooo000Fooooo`03o`000?oooooooooo
0?ooooooN?ooool001Kooooo00?o0000ooooooooool0oooooomhooooo`005_ooool00ol0003ooooo
ooooo`16ooooo`?o00003oooool3o`000?oooooo7Oooool001Kooooo00?o0000ooooooooool0A_oo
ool3o`0000oooooo0ol0003ooooooagooooo000Fooooo`03o`000?oooooooooo04Kooooo0ol0000?
ooooo`?o0000oooooolMooooo`000_ooool2o`0000Cooooo00?o0000ooooooooool00_ooool3o`00
00Kooooo00?o0000ooooooooool0oooooomhooooo`0000Goooooo`000?ooooooooooo`000007oooo
o`05o`000?ooooooooooooooool000001Oooool00ol0003oooooooooo`3oooooogSooooo00001Ooo
oooo0000oooooooooooo000000_ooooo00?o0000ooooooooool00oooool4o`000?ooooooMoooool0
0005ooooool0003oooooooooool000002oooool00ol0003oooooooooo`03ooooo`03o`000?oooooo
oooo0?ooooooN?ooool00005ooooool0003oooooooooool000001oooool4o`0000Kooooo00?o0000
ooooooooool0oooooomhooooo`0000Goooooo`000?ooooooooooo`000007ooooo`03o`000?oooooo
oooo00Oooooo00?o0000ooooooooool0oooooomhooooo`000_ooool2o`0000Sooooo1Ol00005oooo
o`03o`000?oooooooooo0?ooooooN?ooool001Kooooo00?o0000ooooooooool0oooooomhooooo`00
5_ooool00ol0003oooooooooo`3oooooogSooooo000Fooooo`03o`000?oooooooooo0?ooooooN?oo
ool001Kooooo00?o0000ooooooooool0oooooomhooooo`005_ooool00ol0003oooooooooo`3ooooo
ogSooooo000Fooooo`?o0000oooooomhooooo`005_ooool00ol0003oooooooooo`3oooooogSooooo
000Fooooo`03o`000?oooooooooo0?ooooooN?ooool001Kooooo00?o0000ooooooooool0oooooomh
ooooo`005_ooool00ol0003oooooooooo`3oooooogSooooo000Fooooo`03o`000?oooooooooo0?oo
ooooN?ooool001Kooooo00?o0000ooooooooool0oooooomhooooo`005_ooool00ol0003ooooooooo
o`3oooooogSooooo000Fooooo`03o`000?oooooooooo0?ooooooN?ooool001Kooooo00?o0000oooo
ooooool0oooooomhooooo`005_ooool3o`000?ooooooN?ooool001Kooooo00?o0000ooooooooool0
oooooomhooooo`005_ooool00ol0003oooooooooo`3oooooogSooooo000Fooooo`03o`000?oooooo
oooo0?ooooooN?ooool001Kooooo00?o0000ooooooooool0oooooomhooooo`005_ooool00ol0003o
ooooooooo`3oooooogSooooo000Fooooo`03o`000?oooooooooo0?ooooooN?ooool001Kooooo00?o
0000ooooooooool0oooooomhooooo`005_ooool00ol0003oooooooooo`3oooooogSooooo000Foooo
o`?o0000oooooomhooooo`005_ooool00ol0003oooooooooo`3oooooogSooooo000Fooooo`03o`00
0?oooooooooo0?ooooooN?ooool001Kooooo00?o0000ooooooooool0oooooomhooooo`005_ooool0
0ol0003oooooooooo`3oooooogSooooo000Fooooo`03o`000?oooooooooo0?ooooooN?ooool001Ko
oooo00?o0000ooooooooool0oooooomhooooo`005_ooool00ol0003oooooooooo`3oooooogSooooo
000Fooooo`03o`000?oooooooooo0?ooooooN?ooool001Kooooo00?o0000ooooooooool0oooooomh
ooooo`005_ooool3o`000?ooooooN?ooool001Kooooo00?o0000ooooooooool0oooooomhooooo`00
5_ooool00ol0003oooooooooo`3oooooogSooooo000Fooooo`03o`000?oooooooooo0?ooooooN?oo
ool001Kooooo00?o0000ooooooooool0oooooomhooooo`005_ooool00ol0003oooooooooo`3ooooo
ogSooooo000Fooooo`03o`000?oooooooooo0?ooooooN?ooool000gooooo0ol00006ooooo`03o`00
0?oooooooooo0?ooooooN?ooool000kooooo00?o0000ooooooooool01Oooool00ol0003ooooooooo
o`3oooooogSooooo000>ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool0J_ooool3
o`000?oooooo2oooool000kooooo00?o0000ooooooooool01Oooool4o`0006Wooooo0ol0003ooooo
o`_ooooo000>ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool0J_ooool3o`000?oo
oooo2oooool000gooooo0_l00007ooooo`03o`000?oooooooooo0?ooooooN?ooool000kooooo00?o
0000ooooooooool01Oooool00ol0003oooooooooo`3oooooogSooooo000Fooooo`03o`000?oooooo
oooo0?ooooooN?ooool001Kooooo00?o0000ooooooooool0oooooomhooooo`005_ooool00ol0003o
ooooooooo`3oooooogSooooo000Fooooo`03o`000?oooooooooo0?ooooooN?ooool001Kooooo00?o
0000ooooooooool0oooooomhooooo`005_ooool3o`000?ooooooN?ooool001Kooooo00?o0000oooo
ooooool0oooooomhooooo`005_ooool00ol0003oooooooooo`3oooooogSooooo000Fooooo`03o`00
0?oooooooooo0?ooooooN?ooool001Kooooo00?o0000ooooooooool0oooooomhooooo`005_ooool0
0ol0003oooooooooo`3oooooogSooooo000Fooooo`03o`000?oooooooooo0?ooooooN?ooool001Ko
oooo00?o0000ooooooooool0oooooomhooooo`005_ooool00ol0003oooooooooo`3oooooogSooooo
000Fooooo`03o`000?oooooooooo0?ooooooN?ooool001Kooooo0ol0003oooooogSooooo000Foooo
o`03o`000?oooooooooo0?ooooooN?ooool001Kooooo00?o0000ooooooooool0oooooomhooooo`00
5_ooool00ol0003oooooooooo`3oooooogSooooo000Fooooo`03o`000?oooooooooo0?ooooooN?oo
ool001Kooooo00?o0000ooooooooool0oooooomhooooo`005_ooool00ol0003oooooooooo`3ooooo
ogSooooo000Fooooo`03o`000?oooooooooo0?ooooooN?ooool001Kooooo00?o0000ooooooooool0
oooooomhooooo`005_ooool00ol0003oooooooooo`3oooooogSooooo000Fooooo`?o0000oooooomh
ooooo`005_ooool00ol0003oooooooooo`3oooooogSooooo000Fooooo`03o`000?oooooooooo0?oo
ooooN?ooool001Kooooo00?o0000ooooooooool0a_ooool3o`00013ooooo0ol0000?ooooo`?o0000
3oooool3o`00013ooooo0ol0000?ooooo`?o00003oooool3o`00043ooooo000Fooooo`03o`000?oo
oooooooo0<Kooooo0ol0000@ooooo`?o00003oooool3o`0000oooooo0ol0000@ooooo`?o00003ooo
ool3o`0000oooooo0ol00010ooooo`005_ooool00ol0003oooooooooo`36ooooo`?o00004?ooool3
o`0000oooooo0ol0000?ooooo`?o00004?ooool3o`0000oooooo0ol0000?ooooo`?o0000@?ooool0
01Kooooo00?o0000ooooooooool0oooooomhooooo`005_ooool00ol0003oooooooooo`3oooooogSo
oooo000Fooooo`03o`000?oooooooooo0?ooooooN?ooool001Kooooo0ol0003oooooogSooooo000F
ooooo`03o`000?oooooooooo0?ooooooN?ooool001Kooooo00?o0000ooooooooool0oooooomhoooo
o`005_ooool00ol0003oooooooooo`3oooooogSooooo000Fooooo`03o`000?oooooooooo0?oooooo
N?ooool001Kooooo00?o0000ooooooooool0oooooomhooooo`005_ooool00ol0003oooooooooo`3o
ooooogSooooo00001?oooooo0000o`000?l00004ooooo`03o`000?oooooooooo00;ooooo0ol00006
ooooo`03o`000?oooooooooo0?ooooooN?ooool000;ooooo00?o0000ooooooooool01oooool01Ol0
003ooooooooooooooooo000000Gooooo00?o0000ooooooooool0oooooomhooooo`000_ooool00ol0
003oooooooooo`0;ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool0OOooool3o`00
03Cooooo0ol00030ooooo`000_ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00?o
oooo1?l0001looooo`?o0000=?ooool3o`000<3ooooo0002ooooo`03o`000?oooooooooo00Oooooo
1?l00006ooooo`03o`000?oooooooooo07gooooo0ol0000dooooo`?o0000`?ooool00003ooooool0
003o000000Wooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`3oooooogSooooo0002
ooooo`03o`000?oooooooooo00Oooooo1Ol00005ooooo`03o`000?oooooooooo0?ooooooN?ooool0
01Kooooo00?o0000ooooooooool0oooooomhooooo`005_ooool00ol0003oooooooooo`3oooooogSo
oooo000Fooooo`03o`000?oooooooooo0?ooooooN?ooool001Kooooo00?o0000ooooooooool0oooo
oomhooooo`005_ooool00ol0003oooooooooo`3oooooogSooooo000Fooooo`?o0000oooooomhoooo
o`005_ooool00ol0003oooooooooo`3oooooogSooooo000Fooooo`03o`000?oooooooooo0?oooooo
N?ooool001Kooooo00?o0000ooooooooool0oooooomhooooo`005_ooool00ol0003oooooooooo`3o
ooooogSooooo000Fooooo`03o`000?oooooooooo0?ooooooN?ooool001Kooooo00?o0000oooooooo
ool0oooooomhooooo`005_ooool00ol0003oooooooooo`3oooooogSooooo000Fooooo`03o`000?oo
oooooooo0?ooooooN?ooool001Kooooo00?o0000ooooooooool0oooooomhooooo`005_ooool3o`00
0?ooooooN?ooool001Kooooo00?o0000ooooooooool0oooooomhooooo`005_ooool00ol0003ooooo
ooooo`3oooooogSooooo000Fooooo`03o`000?oooooooooo0?ooooooN?ooool001Kooooo00?o0000
ooooooooool0oooooomhooooo`005_ooool00ol0003oooooooooo`3oooooogSooooo000Fooooo`03
o`000?oooooooooo0?ooooooN?ooool001Kooooo00?o0000ooooooooool0oooooomhooooo`005_oo
ool00ol0003oooooooooo`3oooooogSooooo000Fooooo`03o`000?oooooooooo0?ooooooN?ooool0
01Kooooo0ol0003oooooogSooooo000Fooooo`03o`000?oooooooooo0?ooooooN?ooool001Kooooo
00?o0000ooooooooool0oooooomhooooo`005_ooool00ol0003oooooooooo`3oooooogSooooo000F
ooooo`03o`000?oooooooooo0?ooooooN?ooool001Kooooo00?o0000ooooooooool0oooooomhoooo
o`005_ooool00ol0003oooooooooo`3oooooogSooooo000Fooooo`03o`000?oooooooooo0?oooooo
N?ooool001Kooooo00?o0000ooooooooool0oooooomhooooo`005_ooool3o`000?ooooooN?ooool0
01Kooooo00?o0000ooooooooool0oooooomhooooo`005_ooool00ol0003oooooooooo`3oooooogSo
oooo000Fooooo`03o`000?oooooooooo0?ooooooN?ooool001Kooooo00?o0000ooooooooool0oooo
oomhooooo`005_ooool00ol0003oooooooooo`3oooooogSooooo000Fooooo`03o`000?oooooooooo
0?ooooooN?ooool001Kooooo00?o0000ooooooooool0oooooomhooooo`003?ooool5o`0000Gooooo
00?o0000ooooooooool0oooooomhooooo`003Oooool01?l0003oooooooooool00005ooooo`03o`00
0?oooooooooo0:7ooooo0ol0003Cooooo`003_ooool00ol0003oooooooooo`05ooooo`Co0000X?oo
ool3o`000=?ooooo000?ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool0XOooool3
o`000=?ooooo000<ooooo`05o`000?ooooooooooooooool000001Oooool00ol0003oooooooooo`3o
ooooogSooooo000<ooooo`05o`000?ooooooooooooooool000001Oooool00ol0003oooooooooo`3o
ooooogSooooo000=ooooo`?o00001_ooool00ol0003oooooooooo`3oooooogSooooo000Fooooo`03
o`000?oooooooooo0?ooooooN?ooool001Kooooo00?o0000ooooooooool0oooooomhooooo`005_oo
ool00ol0003oooooooooo`3oooooogSooooo000Fooooo`03o`000?oooooooooo0?ooooooN?ooool0
01Kooooo00?o0000ooooooooool0oooooomhooooo`005_ooool3o`000?ooooooN?ooool001Kooooo
00?o0000ooooooooool0oooooomhooooo`005_ooool00ol0003oooooooooo`3oooooogSooooo000F
ooooo`03o`000?oooooooooo0?ooooooN?ooool001Kooooo00?o0000ooooooooool0oooooomhoooo
o`005_ooool00ol0003oooooooooo`3oooooogSooooo000Fooooo`03o`000?oooooooooo0?oooooo
N?ooool001Kooooo00?o0000ooooooooool0oooooomhooooo`005_ooool00ol0003oooooooooo`3o
ooooogSooooo000Fooooo`?o0000oooooomhooooo`005_ooool00ol0003oooooooooo`3oooooogSo
oooo000Fooooo`03o`000?oooooooooo0?ooooooN?ooool001Kooooo00?o0000ooooooooool0oooo
oomhooooo`005_ooool00ol0003oooooooooo`3oooooogSooooo000Fooooo`03o`000?oooooooooo
0?ooooooN?ooool001Kooooo00?o0000ooooooooool0oooooomhooooo`005_ooool00ol0003ooooo
ooooo`3oooooogSooooo000Fooooo`03o`000?oooooooooo0?ooooooN?ooool001Kooooo00?o0000
ooooooooool0oooooomhooooo`005_ooool3o`000?ooooooN?ooool001Kooooo00?o0000oooooooo
ool0oooooomhooooo`005_ooool00ol0003oooooooooo`3oooooogSooooo000Fooooo`03o`000?oo
oooooooo0?ooooooN?ooool001Kooooo00?o0000ooooooooool0Soooool3o`000>Gooooo000Foooo
o`03o`000?oooooooooo08oooooo0ol0003Uooooo`005_ooool00ol0003oooooooooo`2?ooooo`?o
0000iOooool001Kooooo00?o0000ooooooooool0oooooomhooooo`005_ooool00ol0003ooooooooo
o`3oooooogSooooo000Fooooo`03o`000?oooooooooo0?ooooooN?ooool001Kooooo0ol0003ooooo
ogSooooo0000\
\>"],
  ImageRangeCache->{{{0, 399}, {246.188, 0}} -> {8.75075, -0.143191, \
0.0545229, 0.0103658}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
%%ImageSize: 400 247.214 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.452381 0.047619 0.0147151 0.511829 [
[.2619 .00222 -6 -9 ]
[.2619 .00222 6 0 ]
[.5 .00222 -6 -9 ]
[.5 .00222 6 0 ]
[.7381 .00222 -6 -9 ]
[.7381 .00222 6 0 ]
[.97619 .00222 -6 -9 ]
[.97619 .00222 6 0 ]
[.01131 .11708 -18 -4.5 ]
[.01131 .11708 0 4.5 ]
[.01131 .21945 -18 -4.5 ]
[.01131 .21945 0 4.5 ]
[.01131 .32181 -18 -4.5 ]
[.01131 .32181 0 4.5 ]
[.01131 .42418 -18 -4.5 ]
[.01131 .42418 0 4.5 ]
[.01131 .52654 -6 -4.5 ]
[.01131 .52654 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.2619 .01472 m
.2619 .02097 L
s
[(15)] .2619 .00222 0 1 Mshowa
.5 .01472 m
.5 .02097 L
s
[(20)] .5 .00222 0 1 Mshowa
.7381 .01472 m
.7381 .02097 L
s
[(25)] .7381 .00222 0 1 Mshowa
.97619 .01472 m
.97619 .02097 L
s
[(30)] .97619 .00222 0 1 Mshowa
.125 Mabswid
.07143 .01472 m
.07143 .01847 L
s
.11905 .01472 m
.11905 .01847 L
s
.16667 .01472 m
.16667 .01847 L
s
.21429 .01472 m
.21429 .01847 L
s
.30952 .01472 m
.30952 .01847 L
s
.35714 .01472 m
.35714 .01847 L
s
.40476 .01472 m
.40476 .01847 L
s
.45238 .01472 m
.45238 .01847 L
s
.54762 .01472 m
.54762 .01847 L
s
.59524 .01472 m
.59524 .01847 L
s
.64286 .01472 m
.64286 .01847 L
s
.69048 .01472 m
.69048 .01847 L
s
.78571 .01472 m
.78571 .01847 L
s
.83333 .01472 m
.83333 .01847 L
s
.88095 .01472 m
.88095 .01847 L
s
.92857 .01472 m
.92857 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
.02381 .11708 m
.03006 .11708 L
s
[(0.2)] .01131 .11708 1 0 Mshowa
.02381 .21945 m
.03006 .21945 L
s
[(0.4)] .01131 .21945 1 0 Mshowa
.02381 .32181 m
.03006 .32181 L
s
[(0.6)] .01131 .32181 1 0 Mshowa
.02381 .42418 m
.03006 .42418 L
s
[(0.8)] .01131 .42418 1 0 Mshowa
.02381 .52654 m
.03006 .52654 L
s
[(1)] .01131 .52654 1 0 Mshowa
.125 Mabswid
.02381 .04031 m
.02756 .04031 L
s
.02381 .0659 m
.02756 .0659 L
s
.02381 .09149 m
.02756 .09149 L
s
.02381 .14267 m
.02756 .14267 L
s
.02381 .16826 m
.02756 .16826 L
s
.02381 .19386 m
.02756 .19386 L
s
.02381 .24504 m
.02756 .24504 L
s
.02381 .27063 m
.02756 .27063 L
s
.02381 .29622 m
.02756 .29622 L
s
.02381 .3474 m
.02756 .3474 L
s
.02381 .373 m
.02756 .373 L
s
.02381 .39859 m
.02756 .39859 L
s
.02381 .44977 m
.02756 .44977 L
s
.02381 .47536 m
.02756 .47536 L
s
.02381 .50095 m
.02756 .50095 L
s
.02381 .55214 m
.02756 .55214 L
s
.02381 .57773 m
.02756 .57773 L
s
.02381 .60332 m
.02756 .60332 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.008 w
.02381 .01472 Mdot
.07143 .01472 Mdot
.11905 .13755 Mdot
.16667 .19386 Mdot
.21429 .24504 Mdot
.2619 .24504 Mdot
.30952 .52654 Mdot
.35714 .52654 Mdot
.40476 .52654 Mdot
.45238 .60332 Mdot
.5 .43697 Mdot
.54762 .27063 Mdot
.59524 .19386 Mdot
.64286 .11708 Mdot
.69048 .11708 Mdot
.7381 .11708 Mdot
.78571 .11708 Mdot
.83333 .01472 Mdot
.88095 .01472 Mdot
.92857 .01472 Mdot
.97619 .01472 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[8]:=",
  ImageSize->{400, 247.188},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006@0000mb000`400?l00000o`00003ooooooonA
ooooo`00KOooool3o`0000?ooooo0ol0001Booooo`Go00000oooool2o`0005;ooooo1Ol00002oooo
o`?o0000D_ooool3o`0000Cooooo0_l00007ooooo`00K_ooool01Ol0003ooooooooooooooooo0000
00?ooooo00?o0000ooooooooool0D?ooool01?l0003oooooooooool00002ooooo`04o`000?oooooo
ooooo`0005;ooooo00Ko0000oooooooooooo0000ooooool00003ooooo`03o`000?oooooooooo04ko
oooo00Go0000ooooooooooooooooo`000002ooooo`04o`000?ooooooooooo`0000Kooooo001^oooo
o`03o`000?oooooooooo00Gooooo00?o0000ooooooooool0DOooool00ol0003oooooooooo`02oooo
o`04o`000?ooooooooooo`0005?ooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`1B
ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000ooooooooool01?ooool006kooooo00?o0000
ooooooooool01Oooool00ol0003oooooooooo`1Booooo`05o`000?ooooooooooooooool000000_oo
ool00ol0003oooooooooo`1Booooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool0D?oo
ool2o`0000?ooooo00Co0000oooooooooooo00001_ooool006kooooo00Co0000oooooooooooooooo
1?l0001Booooo`05o`000?ooooooooooooooool000000_ooool01?l0003oooooooooool0001Aoooo
o`06o`000?ooooooooooooooool0003ooooo1?l0001Eooooo`04o`000?ooooooooooo`0000;ooooo
00?o0000ooooooooool01?ooool006gooooo0_l00003ooooo`03o`000?oooooooooo05?ooooo00Go
0000ooooooooooooooooo`000002ooooo`04o`000?ooooooooooo`00057ooooo00Oo0000oooooooo
ooooooooo`000?oooooo000005Cooooo00Go0000ooooooooooooooooo`000002ooooo`04o`000?oo
ooooooooo`0000Kooooo001^ooooo`04o`000?ooooooooooooooo`Go0000D_ooool3o`0000Cooooo
0_l0001Cooooo`?o00000_ooool5o`00057ooooo0ol00004ooooo`;o00001oooool001Kooooo00?o
0000ooooooooool0oooooomhooooo`005_ooool00ol0003oooooooooo`3oooooogSooooo000Foooo
o`03o`000?oooooooooo0?ooooooN?ooool001Kooooo00?o0000ooooooooool0oooooomhooooo`00
5_ooool00ol0003oooooooooo`3oooooogSooooo000Eooooo`?o00004?ooool3o`000?oooooo8ooo
ool3o`00013ooooo0ol0000?ooooo`?o00003oooool3o`0000Wooooo000=oooooooo0000Pol00001
ooooo`005Oooool3o`00013ooooo0ol0000@ooooo`03o`000?oooooooooo00oooooo00?o0000oooo
ooooool04?ooool00ol0003oooooooooo`0?ooooo`03o`000?oooooooooo00oooooo00?o0000oooo
ooooool04?ooool00ol0003oooooooooo`0?ooooo`03o`000?oooooooooo00oooooo00?o0000oooo
ooooool04?ooool00ol0003oooooooooo`0?ooooo`03o`000?oooooooooo013ooooo00?o0000oooo
ooooool03oooool00ol0003oooooooooo`0?ooooo`03o`000?oooooooooo013ooooo00?o0000oooo
ooooool03oooool00ol0003oooooooooo`0>ooooo`?o00004?ooool3o`0000oooooo0ol0000?oooo
o`?o00002Oooool001Kooooo00?o0000ooooooooool04?ooool00ol0003oooooooooo`0?ooooo`03
o`000?oooooooooo00oooooo00?o0000ooooooooool04?ooool00ol0003oooooooooo`0?ooooo`03
o`000?oooooooooo00oooooo00?o0000ooooooooool04?ooool00ol0003oooooooooo`0?ooooo`03
o`000?oooooooooo00oooooo00?o0000ooooooooool04?ooool00ol0003oooooooooo`0?ooooo`03
o`000?oooooooooo013ooooo00?o0000ooooooooool03oooool00ol0003oooooooooo`0?ooooo`03
o`000?oooooooooo013ooooo00?o0000ooooooooool03oooool00ol0003oooooooooo`0?ooooo`03
o`000?oooooooooo013ooooo00?o0000ooooooooool03oooool00ol0003oooooooooo`0?ooooo`03
o`000?oooooooooo00Sooooo000Fooooo`03o`000?oooooooooo05Wooooo00?o0000ooooooooool0
FOooool00ol0003oooooooooo`1Iooooo`03o`000?oooooooooo05Sooooo00?o0000ooooooooool0
2?ooool001Kooooo00?o0000ooooooooool0oooooomhooooo`005_ooool00ol0003oooooooooo`3o
ooooogSooooo000Fooooo`03o`000?oooooooooo0?ooooooN?ooool001Kooooo00?o0000oooooooo
ool0oooooomhooooo`005_ooool00ol0003oooooooooo`3oooooogSooooo000Fooooo`03o`000?oo
oooooooo0?ooooooN?ooool001Kooooo0ol0003oooooogSooooo000Fooooo`03o`000?oooooooooo
0?ooooooN?ooool001Kooooo00?o0000ooooooooool0oooooomhooooo`005_ooool00ol0003ooooo
ooooo`3oooooogSooooo000Fooooo`03o`000?oooooooooo0?ooooooN?ooool001Kooooo00?o0000
ooooooooool0oooooomhooooo`005_ooool00ol0003oooooooooo`3oooooogSooooo000Fooooo`03
o`000?oooooooooo0?ooooooN?ooool001Kooooo00?o0000ooooooooool0oooooomhooooo`005_oo
ool00ol0003oooooooooo`3oooooogSooooo000Fooooo`?o0000oooooomhooooo`005_ooool00ol0
003oooooooooo`3oooooogSooooo000Fooooo`03o`000?oooooooooo0?ooooooN?ooool001Kooooo
00?o0000ooooooooool0oooooomhooooo`005_ooool00ol0003oooooooooo`3oooooogSooooo000F
ooooo`03o`000?oooooooooo0?ooooooN?ooool001Kooooo00?o0000ooooooooool0oooooomhoooo
o`005_ooool00ol0003oooooooooo`3oooooogSooooo000Fooooo`03o`000?oooooooooo0?oooooo
N?ooool001Kooooo00?o0000ooooooooool0oooooomhooooo`005_ooool3o`000?ooooooN?ooool0
01Kooooo00?o0000ooooooooool0oooooomhooooo`005_ooool00ol0003oooooooooo`3oooooogSo
oooo000Fooooo`03o`000?oooooooooo0?ooooooN?ooool001Kooooo00?o0000ooooooooool0oooo
oomhooooo`005_ooool00ol0003oooooooooo`3oooooogSooooo000Fooooo`03o`000?oooooooooo
0?ooooooN?ooool000;ooooo0_l00004ooooo`04o`000?ooooooooooooooo`Go00001Oooool00ol0
003oooooooooo`3oooooogSooooo00001Ooooooo0000oooooooooooo000000Sooooo00Co0000oooo
oooooooo00001Oooool00ol0003oooooooooo`3oooooogSooooo00001Ooooooo0000oooooooooooo
000000Wooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`3[ooooo`?o00003oooool3
o`00013ooooo0ol0000?ooooo`?o0000D_ooool00005ooooool0003oooooooooool000002_ooool0
0ol0003oooooooooo`04ooooo`Co0000j_ooool3o`0000oooooo0ol0000@ooooo`?o00003oooool3
o`0005;ooooo00001Ooooooo0000oooooooooooo000000Oooooo00Go0000ooooooooooooooooo`00
0005ooooo`03o`000?oooooooooo0>_ooooo0ol0000?ooooo`?o00004?ooool3o`0000oooooo0ol0
001Booooo`0000Goooooo`000?ooooooooooo`000007ooooo`05o`000?ooooooooooooooool00000
1Oooool00ol0003oooooooooo`3oooooogSooooo0002ooooo`;o00002Oooool3o`0000Kooooo00?o
0000ooooooooool0oooooomhooooo`005_ooool00ol0003oooooooooo`3oooooogSooooo000Foooo
o`03o`000?oooooooooo0?ooooooN?ooool001Kooooo00?o0000ooooooooool08Oooool3o`000?oo
ooooE?ooool001Kooooo00?o0000ooooooooool08Oooool3o`000?ooooooE?ooool001Kooooo00?o
0000ooooooooool08Oooool3o`000?ooooooE?ooool001Kooooo0ol0003oooooogSooooo000Foooo
o`03o`000?oooooooooo0?ooooooN?ooool001Kooooo00?o0000ooooooooool0oooooomhooooo`00
5_ooool00ol0003oooooooooo`3oooooogSooooo000Fooooo`03o`000?oooooooooo0?ooooooN?oo
ool001Kooooo00?o0000ooooooooool0oooooomhooooo`005_ooool00ol0003oooooooooo`3ooooo
ogSooooo000Fooooo`03o`000?oooooooooo0?ooooooN?ooool001Kooooo00?o0000ooooooooool0
oooooomhooooo`005_ooool00ol0003oooooooooo`3oooooogSooooo000Fooooo`?o0000oooooomh
ooooo`005_ooool00ol0003oooooooooo`3oooooogSooooo000Fooooo`03o`000?oooooooooo0?oo
ooooN?ooool001Kooooo00?o0000ooooooooool0oooooomhooooo`005_ooool00ol0003ooooooooo
o`3oooooogSooooo000Fooooo`03o`000?oooooooooo0?ooooooN?ooool001Kooooo00?o0000oooo
ooooool0oooooomhooooo`005_ooool00ol0003oooooooooo`3oooooogSooooo000Fooooo`03o`00
0?oooooooooo0?ooooooN?ooool001Kooooo00?o0000ooooooooool0<oooool3o`000:?ooooo0ol0
002Kooooo`005_ooool3o`0003?ooooo0ol0002Sooooo`?o0000Voooool001Kooooo00?o0000oooo
ooooool0<oooool3o`000:?ooooo0ol0002Kooooo`005_ooool00ol0003oooooooooo`3oooooogSo
oooo000Fooooo`03o`000?oooooooooo0?ooooooN?ooool001Kooooo00?o0000ooooooooool0oooo
oomhooooo`005_ooool00ol0003oooooooooo`3oooooogSooooo000Fooooo`03o`000?oooooooooo
0?ooooooN?ooool000;ooooo0_l00004ooooo`03o`000?oooooooooo00?ooooo0ol00005ooooo`03
o`000?oooooooooo0?ooooooN?ooool00005ooooool0003oooooooooool000002_ooool00ol0003o
ooooooooo`04ooooo`03o`000?oooooooooo0?ooooooN?ooool00005ooooool0003oooooooooool0
00001oooool5o`0000Gooooo00?o0000ooooooooool0oooooomhooooo`0000Goooooo`000?oooooo
ooooo`000007ooooo`04o`000?ooooooooooo`0000Kooooo1?l0003oooooogOooooo00001Ooooooo
0000oooooooooooo000000Sooooo00?o0000ooooool000001_ooool00ol0003oooooooooo`3ooooo
ogSooooo00001Ooooooo0000oooooooooooo000000Wooooo0_l00006ooooo`03o`000?oooooooooo
0?ooooooN?ooool000;ooooo0_l0000;ooooo`03o`000?oooooooooo00Cooooo00?o0000oooooooo
ool0oooooomhooooo`005_ooool00ol0003oooooooooo`3oooooogSooooo000Fooooo`03o`000?oo
oooooooo0?ooooooN?ooool001Kooooo00?o0000ooooooooool0oooooomhooooo`005_ooool00ol0
003oooooooooo`3oooooogSooooo000Fooooo`03o`000?oooooooooo0?ooooooN?ooool001Kooooo
00?o0000ooooooooool0A_ooool3o`0000oooooo0ol0003ooooooagooooo000Fooooo`?o0000A_oo
ool3o`0000oooooo0ol0003ooooooagooooo000Fooooo`03o`000?oooooooooo04Kooooo0ol0000?
ooooo`?o0000oooooolMooooo`005_ooool00ol0003oooooooooo`3oooooogSooooo000Fooooo`03
o`000?oooooooooo0?ooooooN?ooool001Kooooo00?o0000ooooooooool0oooooomhooooo`005_oo
ool00ol0003oooooooooo`3oooooogSooooo000Fooooo`03o`000?oooooooooo0?ooooooN?ooool0
01Kooooo00?o0000ooooooooool0oooooomhooooo`005_ooool00ol0003oooooooooo`3oooooogSo
oooo000Fooooo`03o`000?oooooooooo0<Kooooo0ol0002^ooooo`005_ooool3o`000<Kooooo0ol0
002^ooooo`005_ooool00ol0003oooooooooo`36ooooo`?o0000[_ooool001Kooooo00?o0000oooo
ooooool0oooooomhooooo`005_ooool00ol0003oooooooooo`3oooooogSooooo000Fooooo`03o`00
0?oooooooooo0?ooooooN?ooool001Kooooo00?o0000ooooooooool0oooooomhooooo`005_ooool0
0ol0003oooooooooo`3oooooogSooooo000Fooooo`03o`000?oooooooooo0?ooooooN?ooool001Ko
oooo00?o0000ooooooooool0oooooomhooooo`005_ooool00ol0003oooooooooo`3oooooogSooooo
000Fooooo`?o0000oooooomhooooo`005_ooool00ol0003oooooooooo`3oooooogSooooo000Foooo
o`03o`000?oooooooooo0?ooooooN?ooool001Kooooo00?o0000ooooooooool0oooooomhooooo`00
5_ooool00ol0003oooooooooo`3oooooogSooooo000Fooooo`03o`000?oooooooooo0?ooooooN?oo
ool001Kooooo00?o0000ooooooooool0oooooomhooooo`000_ooool2o`0000Cooooo00?o0000oooo
ooooool00_ooool3o`0000Kooooo00?o0000ooooooooool0oooooomhooooo`0000Goooooo`000?oo
ooooooooo`000007ooooo`05o`000?ooooooooooooooool000001Oooool00ol0003oooooooooo`3o
ooooogSooooo00001Ooooooo0000oooooooooooo000000Oooooo00Go0000ooooooooooooooooo`00
0005ooooo`Co0000oooooomgooooo`0000Goooooo`000?ooooooooooo`000007ooooo`Co00001_oo
ool00ol0003oooooooooo`3oooooogSooooo00001Ooooooo0000oooooooooooo000000Oooooo00?o
0000ooooooooool01oooool00ol0003oooooooooo`3oooooogSooooo00001Ooooooo0000oooooooo
oooo000000Sooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`3oooooogSooooo0002
ooooo`;o00002_ooool2o`0000Kooooo00?o0000ooooooooool0oooooomhooooo`005_ooool00ol0
003oooooooooo`3oooooogSooooo000Fooooo`03o`000?oooooooooo0?ooooooN?ooool001Kooooo
00?o0000ooooooooool0oooooomhooooo`005_ooool00ol0003oooooooooo`3oooooogSooooo000F
ooooo`03o`000?oooooooooo0?ooooooN?ooool001Kooooo0ol0003oooooogSooooo000Fooooo`03
o`000?oooooooooo0?ooooooN?ooool001Kooooo00?o0000ooooooooool0oooooomhooooo`005_oo
ool00ol0003oooooooooo`3oooooogSooooo000Fooooo`03o`000?oooooooooo0?ooooooN?ooool0
01Kooooo00?o0000ooooooooool0oooooomhooooo`005_ooool00ol0003oooooooooo`3oooooogSo
oooo000Fooooo`03o`000?oooooooooo0?ooooooN?ooool001Kooooo00?o0000ooooooooool0oooo
oomhooooo`005_ooool00ol0003oooooooooo`3oooooogSooooo000Fooooo`?o0000oooooomhoooo
o`005_ooool00ol0003oooooooooo`3oooooogSooooo000Fooooo`03o`000?oooooooooo0?oooooo
N?ooool001Kooooo00?o0000ooooooooool0oooooomhooooo`005_ooool00ol0003oooooooooo`3o
ooooogSooooo000Fooooo`03o`000?oooooooooo0?ooooooN?ooool001Kooooo00?o0000oooooooo
ool0oooooomhooooo`005_ooool00ol0003oooooooooo`3oooooogSooooo000Fooooo`03o`000?oo
oooooooo0?ooooooN?ooool001Kooooo00?o0000ooooooooool0oooooomhooooo`005_ooool3o`00
0?ooooooN?ooool001Kooooo00?o0000ooooooooool0oooooomhooooo`005_ooool00ol0003ooooo
ooooo`3oooooogSooooo000Fooooo`03o`000?oooooooooo0?ooooooN?ooool001Kooooo00?o0000
ooooooooool0oooooomhooooo`005_ooool00ol0003oooooooooo`3oooooogSooooo000Fooooo`03
o`000?oooooooooo0?ooooooN?ooool000;ooooo0_l00004ooooo`03o`000?oooooooooo00;ooooo
0ol00006ooooo`03o`000?oooooooooo0?ooooooN?ooool00005ooooool0003oooooooooool00000
1oooool01Ol0003ooooooooooooooooo000000Gooooo00?o0000ooooooooool0oooooomhooooo`00
00Goooooo`000?ooooooooooo`000007ooooo`05o`000?ooooooooooooooool000001Oooool00ol0
003oooooooooo`3oooooogSooooo00001Ooooooo0000oooooooooooo000000Sooooo0ol00006oooo
o`Co0000oooooomgooooo`0000Goooooo`000?ooooooooooo`000007ooooo`05o`000?oooooooooo
ooooool000001Oooool00ol0003oooooooooo`3oooooogSooooo00001Ooooooo0000oooooooooooo
000000Oooooo00Go0000ooooooooooooooooo`000005ooooo`03o`000?oooooooooo0?ooooooN?oo
ool000;ooooo0_l00009ooooo`?o00001_ooool00ol0003oooooooooo`3oooooogSooooo000Foooo
o`03o`000?oooooooooo0;Cooooo0ol00030ooooo`005_ooool00ol0003oooooooooo`2dooooo`?o
0000`?ooool001Kooooo00?o0000ooooooooool0]?ooool3o`000<3ooooo000Fooooo`03o`000?oo
oooooooo0?ooooooN?ooool001Kooooo00?o0000ooooooooool0oooooomhooooo`005_ooool00ol0
003oooooooooo`3oooooogSooooo000Fooooo`?o0000oooooomhooooo`005_ooool00ol0003ooooo
ooooo`3oooooogSooooo000Fooooo`03o`000?oooooooooo0?ooooooN?ooool001Kooooo00?o0000
ooooooooool0oooooomhooooo`005_ooool00ol0003oooooooooo`3oooooogSooooo000Fooooo`03
o`000?oooooooooo0?ooooooN?ooool001Kooooo00?o0000ooooooooool0oooooomhooooo`005_oo
ool00ol0003oooooooooo`3oooooogSooooo000Fooooo`03o`000?oooooooooo0?ooooooN?ooool0
01Kooooo00?o0000ooooooooool0oooooomhooooo`005_ooool3o`000?ooooooN?ooool001Kooooo
00?o0000ooooooooool0oooooomhooooo`005_ooool00ol0003oooooooooo`3oooooogSooooo000F
ooooo`03o`000?oooooooooo0?ooooooN?ooool001Kooooo00?o0000ooooooooool0oooooomhoooo
o`005_ooool00ol0003oooooooooo`3oooooogSooooo000Fooooo`03o`000?oooooooooo0?oooooo
N?ooool001Kooooo00?o0000ooooooooool0oooooomhooooo`005_ooool00ol0003oooooooooo`3o
ooooogSooooo000Fooooo`?o0000oooooomhooooo`005_ooool00ol0003oooooooooo`3oooooogSo
oooo000Fooooo`03o`000?oooooooooo0?ooooooN?ooool001Kooooo00?o0000ooooooooool0oooo
oomhooooo`005_ooool00ol0003oooooooooo`3oooooogSooooo000Fooooo`03o`000?oooooooooo
0?ooooooN?ooool001Kooooo00?o0000ooooooooool0oooooomhooooo`005_ooool00ol0003ooooo
ooooo`3oooooogSooooo000=ooooo`?o00001_ooool00ol0003oooooooooo`3oooooogSooooo000>
ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool0J_ooool3o`00013ooooo0ol0000?
ooooo`?o0000iOooool000kooooo00?o0000ooooooooool01Oooool4o`0006Wooooo0ol0000@oooo
o`?o00003oooool3o`000>Gooooo000>ooooo`03o`000?oooooooooo00Gooooo00?o0000oooooooo
ool0J_ooool3o`00013ooooo0ol0000?ooooo`?o0000iOooool000kooooo00?o0000ooooooooool0
1Oooool00ol0003oooooooooo`3oooooogSooooo000=ooooo`;o00001oooool00ol0003ooooooooo
o`3oooooogSooooo000>ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool0oooooomh
ooooo`005_ooool00ol0003oooooooooo`3oooooogSooooo000Fooooo`03o`000?oooooooooo0?oo
ooooN?ooool001Kooooo00?o0000ooooooooool0oooooomhooooo`005_ooool00ol0003ooooooooo
o`3oooooogSooooo000Fooooo`03o`000?oooooooooo0?ooooooN?ooool001Kooooo0ol0003ooooo
ogSooooo000Fooooo`03o`000?oooooooooo0?ooooooN?ooool001Kooooo00?o0000ooooooooool0
oooooomhooooo`005_ooool00ol0003oooooooooo`3oooooogSooooo000Fooooo`03o`000?oooooo
oooo0?ooooooN?ooool001Kooooo00?o0000ooooooooool0oooooomhooooo`005_ooool00ol0003o
ooooooooo`3oooooogSooooo000Fooooo`03o`000?oooooooooo0?ooooooN?ooool001Kooooo00?o
0000ooooooooool0oooooomhooooo`005_ooool00ol0003oooooooooo`3oooooogSooooo000Foooo
o`?o0000oooooomhooooo`005_ooool00ol0003oooooooooo`3oooooogSooooo000Fooooo`03o`00
0?oooooooooo0?ooooooN?ooool001Kooooo00?o0000ooooooooool0oooooomhooooo`005_ooool0
0ol0003oooooooooo`3oooooogSooooo000Fooooo`03o`000?oooooooooo0?ooooooN?ooool001Ko
oooo00?o0000ooooooooool0oooooomhooooo`005_ooool00ol0003oooooooooo`3oooooogSooooo
000Fooooo`03o`000?oooooooooo0?ooooooN?ooool001Kooooo00?o0000ooooooooool0XOooool3
o`000=?ooooo000Fooooo`?o0000XOooool3o`000=?ooooo000Fooooo`03o`000?oooooooooo0:7o
oooo0ol0003Cooooo`005_ooool00ol0003oooooooooo`3oooooogSooooo000Fooooo`03o`000?oo
oooooooo0?ooooooN?ooool001Kooooo00?o0000ooooooooool0oooooomhooooo`005_ooool00ol0
003oooooooooo`3oooooogSooooo0000\
\>"],
  ImageRangeCache->{{{0, 399}, {246.188, 0}} -> {8.75075, -0.0700725, \
0.0545229, 0.00507264}}]
}, Open  ]]
}, Open  ]],

Cell[TextData[{
  "Utilizziamo la funzione ",
  StyleBox["MultipleListPlot", "Input"],
  ", incorporata nel package ",
  StyleBox["Graphics", "Input"],
  ", per disegnare entrambe le serie su uno stesso grafico:"
}], "Text",
  PageWidth->PaperWidth],

Cell[CellGroupData[{

Cell[BoxData[{
    \(<< Graphics`MultipleListPlot`\), "\[IndentingNewLine]", 
    \(\(MultipleListPlot[untreated, treated];\)\)}], "Input",
  CellLabel->"In[10]:=",
  PageWidth->PaperWidth],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
%%ImageSize: 400 247.214 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.452381 0.047619 0.0147151 0.25047 [
[.2619 .00222 -6 -9 ]
[.2619 .00222 6 0 ]
[.5 .00222 -6 -9 ]
[.5 .00222 6 0 ]
[.7381 .00222 -6 -9 ]
[.7381 .00222 6 0 ]
[.97619 .00222 -6 -9 ]
[.97619 .00222 6 0 ]
[.01131 .13995 -18 -4.5 ]
[.01131 .13995 0 4.5 ]
[.01131 .26518 -6 -4.5 ]
[.01131 .26518 0 4.5 ]
[.01131 .39042 -18 -4.5 ]
[.01131 .39042 0 4.5 ]
[.01131 .51565 -6 -4.5 ]
[.01131 .51565 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.2619 .01472 m
.2619 .02097 L
s
[(15)] .2619 .00222 0 1 Mshowa
.5 .01472 m
.5 .02097 L
s
[(20)] .5 .00222 0 1 Mshowa
.7381 .01472 m
.7381 .02097 L
s
[(25)] .7381 .00222 0 1 Mshowa
.97619 .01472 m
.97619 .02097 L
s
[(30)] .97619 .00222 0 1 Mshowa
.125 Mabswid
.07143 .01472 m
.07143 .01847 L
s
.11905 .01472 m
.11905 .01847 L
s
.16667 .01472 m
.16667 .01847 L
s
.21429 .01472 m
.21429 .01847 L
s
.30952 .01472 m
.30952 .01847 L
s
.35714 .01472 m
.35714 .01847 L
s
.40476 .01472 m
.40476 .01847 L
s
.45238 .01472 m
.45238 .01847 L
s
.54762 .01472 m
.54762 .01847 L
s
.59524 .01472 m
.59524 .01847 L
s
.64286 .01472 m
.64286 .01847 L
s
.69048 .01472 m
.69048 .01847 L
s
.78571 .01472 m
.78571 .01847 L
s
.83333 .01472 m
.83333 .01847 L
s
.88095 .01472 m
.88095 .01847 L
s
.92857 .01472 m
.92857 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
.02381 .13995 m
.03006 .13995 L
s
[(0.5)] .01131 .13995 1 0 Mshowa
.02381 .26518 m
.03006 .26518 L
s
[(1)] .01131 .26518 1 0 Mshowa
.02381 .39042 m
.03006 .39042 L
s
[(1.5)] .01131 .39042 1 0 Mshowa
.02381 .51565 m
.03006 .51565 L
s
[(2)] .01131 .51565 1 0 Mshowa
.125 Mabswid
.02381 .03976 m
.02756 .03976 L
s
.02381 .06481 m
.02756 .06481 L
s
.02381 .08986 m
.02756 .08986 L
s
.02381 .1149 m
.02756 .1149 L
s
.02381 .165 m
.02756 .165 L
s
.02381 .19004 m
.02756 .19004 L
s
.02381 .21509 m
.02756 .21509 L
s
.02381 .24014 m
.02756 .24014 L
s
.02381 .29023 m
.02756 .29023 L
s
.02381 .31528 m
.02756 .31528 L
s
.02381 .34033 m
.02756 .34033 L
s
.02381 .36537 m
.02756 .36537 L
s
.02381 .41547 m
.02756 .41547 L
s
.02381 .44051 m
.02756 .44051 L
s
.02381 .46556 m
.02756 .46556 L
s
.02381 .49061 m
.02756 .49061 L
s
.02381 .5407 m
.02756 .5407 L
s
.02381 .56575 m
.02756 .56575 L
s
.02381 .5908 m
.02756 .5908 L
s
.02381 .61584 m
.02756 .61584 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.0001 w
.02381 .01472 -1.875 0 Mabsadd m
.02381 .01472 0 2.5 Mabsadd L
.02381 .01472 1.875 0 Mabsadd L
.02381 .01472 0 -2.5 Mabsadd L
.02381 .01472 -1.875 0 Mabsadd L closepath F
.07143 .01472 -1.875 0 Mabsadd m
.07143 .01472 0 2.5 Mabsadd L
.07143 .01472 1.875 0 Mabsadd L
.07143 .01472 0 -2.5 Mabsadd L
.07143 .01472 -1.875 0 Mabsadd L closepath F
.11905 .07483 -1.875 0 Mabsadd m
.11905 .07483 0 2.5 Mabsadd L
.11905 .07483 1.875 0 Mabsadd L
.11905 .07483 0 -2.5 Mabsadd L
.11905 .07483 -1.875 0 Mabsadd L closepath F
.16667 .10238 -1.875 0 Mabsadd m
.16667 .10238 0 2.5 Mabsadd L
.16667 .10238 1.875 0 Mabsadd L
.16667 .10238 0 -2.5 Mabsadd L
.16667 .10238 -1.875 0 Mabsadd L closepath F
.21429 .12743 -1.875 0 Mabsadd m
.21429 .12743 0 2.5 Mabsadd L
.21429 .12743 1.875 0 Mabsadd L
.21429 .12743 0 -2.5 Mabsadd L
.21429 .12743 -1.875 0 Mabsadd L closepath F
.2619 .12743 -1.875 0 Mabsadd m
.2619 .12743 0 2.5 Mabsadd L
.2619 .12743 1.875 0 Mabsadd L
.2619 .12743 0 -2.5 Mabsadd L
.2619 .12743 -1.875 0 Mabsadd L closepath F
.30952 .26518 -1.875 0 Mabsadd m
.30952 .26518 0 2.5 Mabsadd L
.30952 .26518 1.875 0 Mabsadd L
.30952 .26518 0 -2.5 Mabsadd L
.30952 .26518 -1.875 0 Mabsadd L closepath F
.35714 .39042 -1.875 0 Mabsadd m
.35714 .39042 0 2.5 Mabsadd L
.35714 .39042 1.875 0 Mabsadd L
.35714 .39042 0 -2.5 Mabsadd L
.35714 .39042 -1.875 0 Mabsadd L closepath F
.40476 .60332 -1.875 0 Mabsadd m
.40476 .60332 0 2.5 Mabsadd L
.40476 .60332 1.875 0 Mabsadd L
.40476 .60332 0 -2.5 Mabsadd L
.40476 .60332 -1.875 0 Mabsadd L closepath F
.45238 .51565 -1.875 0 Mabsadd m
.45238 .51565 0 2.5 Mabsadd L
.45238 .51565 1.875 0 Mabsadd L
.45238 .51565 0 -2.5 Mabsadd L
.45238 .51565 -1.875 0 Mabsadd L closepath F
.5 .39042 -1.875 0 Mabsadd m
.5 .39042 0 2.5 Mabsadd L
.5 .39042 1.875 0 Mabsadd L
.5 .39042 0 -2.5 Mabsadd L
.5 .39042 -1.875 0 Mabsadd L closepath F
.54762 .35285 -1.875 0 Mabsadd m
.54762 .35285 0 2.5 Mabsadd L
.54762 .35285 1.875 0 Mabsadd L
.54762 .35285 0 -2.5 Mabsadd L
.54762 .35285 -1.875 0 Mabsadd L closepath F
.59524 .35285 -1.875 0 Mabsadd m
.59524 .35285 0 2.5 Mabsadd L
.59524 .35285 1.875 0 Mabsadd L
.59524 .35285 0 -2.5 Mabsadd L
.59524 .35285 -1.875 0 Mabsadd L closepath F
.64286 .35285 -1.875 0 Mabsadd m
.64286 .35285 0 2.5 Mabsadd L
.64286 .35285 1.875 0 Mabsadd L
.64286 .35285 0 -2.5 Mabsadd L
.64286 .35285 -1.875 0 Mabsadd L closepath F
.69048 .35285 -1.875 0 Mabsadd m
.69048 .35285 0 2.5 Mabsadd L
.69048 .35285 1.875 0 Mabsadd L
.69048 .35285 0 -2.5 Mabsadd L
.69048 .35285 -1.875 0 Mabsadd L closepath F
.7381 .35285 -1.875 0 Mabsadd m
.7381 .35285 0 2.5 Mabsadd L
.7381 .35285 1.875 0 Mabsadd L
.7381 .35285 0 -2.5 Mabsadd L
.7381 .35285 -1.875 0 Mabsadd L closepath F
.78571 .35285 -1.875 0 Mabsadd m
.78571 .35285 0 2.5 Mabsadd L
.78571 .35285 1.875 0 Mabsadd L
.78571 .35285 0 -2.5 Mabsadd L
.78571 .35285 -1.875 0 Mabsadd L closepath F
.83333 .35285 -1.875 0 Mabsadd m
.83333 .35285 0 2.5 Mabsadd L
.83333 .35285 1.875 0 Mabsadd L
.83333 .35285 0 -2.5 Mabsadd L
.83333 .35285 -1.875 0 Mabsadd L closepath F
.88095 .08986 -1.875 0 Mabsadd m
.88095 .08986 0 2.5 Mabsadd L
.88095 .08986 1.875 0 Mabsadd L
.88095 .08986 0 -2.5 Mabsadd L
.88095 .08986 -1.875 0 Mabsadd L closepath F
.92857 .01472 -1.875 0 Mabsadd m
.92857 .01472 0 2.5 Mabsadd L
.92857 .01472 1.875 0 Mabsadd L
.92857 .01472 0 -2.5 Mabsadd L
.92857 .01472 -1.875 0 Mabsadd L closepath F
.97619 .01472 -1.875 0 Mabsadd m
.97619 .01472 0 2.5 Mabsadd L
.97619 .01472 1.875 0 Mabsadd L
.97619 .01472 0 -2.5 Mabsadd L
.97619 .01472 -1.875 0 Mabsadd L closepath F
.02381 .01472 0 2.5 Mabsadd m
.02381 .01472 -0.56518 .7779 Mabsadd L
.02381 .01472 -2.37764 .77254 Mabsadd L
.02381 .01472 -0.91448 -0.29713 Mabsadd L
.02381 .01472 -1.46946 -2.02254 Mabsadd L
.02381 .01472 0 -0.96154 Mabsadd L
.02381 .01472 1.46946 -2.02254 Mabsadd L
.02381 .01472 .91448 -0.29713 Mabsadd L
.02381 .01472 2.37764 .77254 Mabsadd L
.02381 .01472 .56518 .7779 Mabsadd L
.02381 .01472 0 2.5 Mabsadd L closepath F
.07143 .01472 0 2.5 Mabsadd m
.07143 .01472 -0.56518 .7779 Mabsadd L
.07143 .01472 -2.37764 .77254 Mabsadd L
.07143 .01472 -0.91448 -0.29713 Mabsadd L
.07143 .01472 -1.46946 -2.02254 Mabsadd L
.07143 .01472 0 -0.96154 Mabsadd L
.07143 .01472 1.46946 -2.02254 Mabsadd L
.07143 .01472 .91448 -0.29713 Mabsadd L
.07143 .01472 2.37764 .77254 Mabsadd L
.07143 .01472 .56518 .7779 Mabsadd L
.07143 .01472 0 2.5 Mabsadd L closepath F
.11905 .07483 0 2.5 Mabsadd m
.11905 .07483 -0.56518 .7779 Mabsadd L
.11905 .07483 -2.37764 .77254 Mabsadd L
.11905 .07483 -0.91448 -0.29713 Mabsadd L
.11905 .07483 -1.46946 -2.02254 Mabsadd L
.11905 .07483 0 -0.96154 Mabsadd L
.11905 .07483 1.46946 -2.02254 Mabsadd L
.11905 .07483 .91448 -0.29713 Mabsadd L
.11905 .07483 2.37764 .77254 Mabsadd L
.11905 .07483 .56518 .7779 Mabsadd L
.11905 .07483 0 2.5 Mabsadd L closepath F
.16667 .10238 0 2.5 Mabsadd m
.16667 .10238 -0.56518 .7779 Mabsadd L
.16667 .10238 -2.37764 .77254 Mabsadd L
.16667 .10238 -0.91448 -0.29713 Mabsadd L
.16667 .10238 -1.46946 -2.02254 Mabsadd L
.16667 .10238 0 -0.96154 Mabsadd L
.16667 .10238 1.46946 -2.02254 Mabsadd L
.16667 .10238 .91448 -0.29713 Mabsadd L
.16667 .10238 2.37764 .77254 Mabsadd L
.16667 .10238 .56518 .7779 Mabsadd L
.16667 .10238 0 2.5 Mabsadd L closepath F
.21429 .12743 0 2.5 Mabsadd m
.21429 .12743 -0.56518 .7779 Mabsadd L
.21429 .12743 -2.37764 .77254 Mabsadd L
.21429 .12743 -0.91448 -0.29713 Mabsadd L
.21429 .12743 -1.46946 -2.02254 Mabsadd L
.21429 .12743 0 -0.96154 Mabsadd L
.21429 .12743 1.46946 -2.02254 Mabsadd L
.21429 .12743 .91448 -0.29713 Mabsadd L
.21429 .12743 2.37764 .77254 Mabsadd L
.21429 .12743 .56518 .7779 Mabsadd L
.21429 .12743 0 2.5 Mabsadd L closepath F
.2619 .12743 0 2.5 Mabsadd m
.2619 .12743 -0.56518 .7779 Mabsadd L
.2619 .12743 -2.37764 .77254 Mabsadd L
.2619 .12743 -0.91448 -0.29713 Mabsadd L
.2619 .12743 -1.46946 -2.02254 Mabsadd L
.2619 .12743 0 -0.96154 Mabsadd L
.2619 .12743 1.46946 -2.02254 Mabsadd L
.2619 .12743 .91448 -0.29713 Mabsadd L
.2619 .12743 2.37764 .77254 Mabsadd L
.2619 .12743 .56518 .7779 Mabsadd L
.2619 .12743 0 2.5 Mabsadd L closepath F
.30952 .26518 0 2.5 Mabsadd m
.30952 .26518 -0.56518 .7779 Mabsadd L
.30952 .26518 -2.37764 .77254 Mabsadd L
.30952 .26518 -0.91448 -0.29713 Mabsadd L
.30952 .26518 -1.46946 -2.02254 Mabsadd L
.30952 .26518 0 -0.96154 Mabsadd L
.30952 .26518 1.46946 -2.02254 Mabsadd L
.30952 .26518 .91448 -0.29713 Mabsadd L
.30952 .26518 2.37764 .77254 Mabsadd L
.30952 .26518 .56518 .7779 Mabsadd L
.30952 .26518 0 2.5 Mabsadd L closepath F
.35714 .26518 0 2.5 Mabsadd m
.35714 .26518 -0.56518 .7779 Mabsadd L
.35714 .26518 -2.37764 .77254 Mabsadd L
.35714 .26518 -0.91448 -0.29713 Mabsadd L
.35714 .26518 -1.46946 -2.02254 Mabsadd L
.35714 .26518 0 -0.96154 Mabsadd L
.35714 .26518 1.46946 -2.02254 Mabsadd L
.35714 .26518 .91448 -0.29713 Mabsadd L
.35714 .26518 2.37764 .77254 Mabsadd L
.35714 .26518 .56518 .7779 Mabsadd L
.35714 .26518 0 2.5 Mabsadd L closepath F
.40476 .26518 0 2.5 Mabsadd m
.40476 .26518 -0.56518 .7779 Mabsadd L
.40476 .26518 -2.37764 .77254 Mabsadd L
.40476 .26518 -0.91448 -0.29713 Mabsadd L
.40476 .26518 -1.46946 -2.02254 Mabsadd L
.40476 .26518 0 -0.96154 Mabsadd L
.40476 .26518 1.46946 -2.02254 Mabsadd L
.40476 .26518 .91448 -0.29713 Mabsadd L
.40476 .26518 2.37764 .77254 Mabsadd L
.40476 .26518 .56518 .7779 Mabsadd L
.40476 .26518 0 2.5 Mabsadd L closepath F
.45238 .30276 0 2.5 Mabsadd m
.45238 .30276 -0.56518 .7779 Mabsadd L
.45238 .30276 -2.37764 .77254 Mabsadd L
.45238 .30276 -0.91448 -0.29713 Mabsadd L
.45238 .30276 -1.46946 -2.02254 Mabsadd L
.45238 .30276 0 -0.96154 Mabsadd L
.45238 .30276 1.46946 -2.02254 Mabsadd L
.45238 .30276 .91448 -0.29713 Mabsadd L
.45238 .30276 2.37764 .77254 Mabsadd L
.45238 .30276 .56518 .7779 Mabsadd L
.45238 .30276 0 2.5 Mabsadd L closepath F
.5 .22135 0 2.5 Mabsadd m
.5 .22135 -0.56518 .7779 Mabsadd L
.5 .22135 -2.37764 .77254 Mabsadd L
.5 .22135 -0.91448 -0.29713 Mabsadd L
.5 .22135 -1.46946 -2.02254 Mabsadd L
.5 .22135 0 -0.96154 Mabsadd L
.5 .22135 1.46946 -2.02254 Mabsadd L
.5 .22135 .91448 -0.29713 Mabsadd L
.5 .22135 2.37764 .77254 Mabsadd L
.5 .22135 .56518 .7779 Mabsadd L
.5 .22135 0 2.5 Mabsadd L closepath F
.54762 .13995 0 2.5 Mabsadd m
.54762 .13995 -0.56518 .7779 Mabsadd L
.54762 .13995 -2.37764 .77254 Mabsadd L
.54762 .13995 -0.91448 -0.29713 Mabsadd L
.54762 .13995 -1.46946 -2.02254 Mabsadd L
.54762 .13995 0 -0.96154 Mabsadd L
.54762 .13995 1.46946 -2.02254 Mabsadd L
.54762 .13995 .91448 -0.29713 Mabsadd L
.54762 .13995 2.37764 .77254 Mabsadd L
.54762 .13995 .56518 .7779 Mabsadd L
.54762 .13995 0 2.5 Mabsadd L closepath F
.59524 .10238 0 2.5 Mabsadd m
.59524 .10238 -0.56518 .7779 Mabsadd L
.59524 .10238 -2.37764 .77254 Mabsadd L
.59524 .10238 -0.91448 -0.29713 Mabsadd L
.59524 .10238 -1.46946 -2.02254 Mabsadd L
.59524 .10238 0 -0.96154 Mabsadd L
.59524 .10238 1.46946 -2.02254 Mabsadd L
.59524 .10238 .91448 -0.29713 Mabsadd L
.59524 .10238 2.37764 .77254 Mabsadd L
.59524 .10238 .56518 .7779 Mabsadd L
.59524 .10238 0 2.5 Mabsadd L closepath F
.64286 .06481 0 2.5 Mabsadd m
.64286 .06481 -0.56518 .7779 Mabsadd L
.64286 .06481 -2.37764 .77254 Mabsadd L
.64286 .06481 -0.91448 -0.29713 Mabsadd L
.64286 .06481 -1.46946 -2.02254 Mabsadd L
.64286 .06481 0 -0.96154 Mabsadd L
.64286 .06481 1.46946 -2.02254 Mabsadd L
.64286 .06481 .91448 -0.29713 Mabsadd L
.64286 .06481 2.37764 .77254 Mabsadd L
.64286 .06481 .56518 .7779 Mabsadd L
.64286 .06481 0 2.5 Mabsadd L closepath F
.69048 .06481 0 2.5 Mabsadd m
.69048 .06481 -0.56518 .7779 Mabsadd L
.69048 .06481 -2.37764 .77254 Mabsadd L
.69048 .06481 -0.91448 -0.29713 Mabsadd L
.69048 .06481 -1.46946 -2.02254 Mabsadd L
.69048 .06481 0 -0.96154 Mabsadd L
.69048 .06481 1.46946 -2.02254 Mabsadd L
.69048 .06481 .91448 -0.29713 Mabsadd L
.69048 .06481 2.37764 .77254 Mabsadd L
.69048 .06481 .56518 .7779 Mabsadd L
.69048 .06481 0 2.5 Mabsadd L closepath F
.7381 .06481 0 2.5 Mabsadd m
.7381 .06481 -0.56518 .7779 Mabsadd L
.7381 .06481 -2.37764 .77254 Mabsadd L
.7381 .06481 -0.91448 -0.29713 Mabsadd L
.7381 .06481 -1.46946 -2.02254 Mabsadd L
.7381 .06481 0 -0.96154 Mabsadd L
.7381 .06481 1.46946 -2.02254 Mabsadd L
.7381 .06481 .91448 -0.29713 Mabsadd L
.7381 .06481 2.37764 .77254 Mabsadd L
.7381 .06481 .56518 .7779 Mabsadd L
.7381 .06481 0 2.5 Mabsadd L closepath F
.78571 .06481 0 2.5 Mabsadd m
.78571 .06481 -0.56518 .7779 Mabsadd L
.78571 .06481 -2.37764 .77254 Mabsadd L
.78571 .06481 -0.91448 -0.29713 Mabsadd L
.78571 .06481 -1.46946 -2.02254 Mabsadd L
.78571 .06481 0 -0.96154 Mabsadd L
.78571 .06481 1.46946 -2.02254 Mabsadd L
.78571 .06481 .91448 -0.29713 Mabsadd L
.78571 .06481 2.37764 .77254 Mabsadd L
.78571 .06481 .56518 .7779 Mabsadd L
.78571 .06481 0 2.5 Mabsadd L closepath F
.83333 .01472 0 2.5 Mabsadd m
.83333 .01472 -0.56518 .7779 Mabsadd L
.83333 .01472 -2.37764 .77254 Mabsadd L
.83333 .01472 -0.91448 -0.29713 Mabsadd L
.83333 .01472 -1.46946 -2.02254 Mabsadd L
.83333 .01472 0 -0.96154 Mabsadd L
.83333 .01472 1.46946 -2.02254 Mabsadd L
.83333 .01472 .91448 -0.29713 Mabsadd L
.83333 .01472 2.37764 .77254 Mabsadd L
.83333 .01472 .56518 .7779 Mabsadd L
.83333 .01472 0 2.5 Mabsadd L closepath F
.88095 .01472 0 2.5 Mabsadd m
.88095 .01472 -0.56518 .7779 Mabsadd L
.88095 .01472 -2.37764 .77254 Mabsadd L
.88095 .01472 -0.91448 -0.29713 Mabsadd L
.88095 .01472 -1.46946 -2.02254 Mabsadd L
.88095 .01472 0 -0.96154 Mabsadd L
.88095 .01472 1.46946 -2.02254 Mabsadd L
.88095 .01472 .91448 -0.29713 Mabsadd L
.88095 .01472 2.37764 .77254 Mabsadd L
.88095 .01472 .56518 .7779 Mabsadd L
.88095 .01472 0 2.5 Mabsadd L closepath F
.92857 .01472 0 2.5 Mabsadd m
.92857 .01472 -0.56518 .7779 Mabsadd L
.92857 .01472 -2.37764 .77254 Mabsadd L
.92857 .01472 -0.91448 -0.29713 Mabsadd L
.92857 .01472 -1.46946 -2.02254 Mabsadd L
.92857 .01472 0 -0.96154 Mabsadd L
.92857 .01472 1.46946 -2.02254 Mabsadd L
.92857 .01472 .91448 -0.29713 Mabsadd L
.92857 .01472 2.37764 .77254 Mabsadd L
.92857 .01472 .56518 .7779 Mabsadd L
.92857 .01472 0 2.5 Mabsadd L closepath F
.97619 .01472 0 2.5 Mabsadd m
.97619 .01472 -0.56518 .7779 Mabsadd L
.97619 .01472 -2.37764 .77254 Mabsadd L
.97619 .01472 -0.91448 -0.29713 Mabsadd L
.97619 .01472 -1.46946 -2.02254 Mabsadd L
.97619 .01472 0 -0.96154 Mabsadd L
.97619 .01472 1.46946 -2.02254 Mabsadd L
.97619 .01472 .91448 -0.29713 Mabsadd L
.97619 .01472 2.37764 .77254 Mabsadd L
.97619 .01472 .56518 .7779 Mabsadd L
.97619 .01472 0 2.5 Mabsadd L closepath F
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[10]:=",
  ImageSize->{400, 247.188},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006@0000mb000`400?l00000o`00003ooooooonA
ooooo`00KOooool3o`0000?ooooo0ol0001Booooo`Go00000oooool2o`0005;ooooo1Ol00002oooo
o`?o0000D_ooool3o`0000Cooooo0_l00007ooooo`00K_ooool01Ol0003ooooooooooooooooo0000
00?ooooo00?o0000ooooooooool0D?ooool01?l0003oooooooooool00002ooooo`04o`000?oooooo
ooooo`0005;ooooo00Ko0000oooooooooooo0000ooooool00003ooooo`03o`000?oooooooooo04ko
oooo00Go0000ooooooooooooooooo`000002ooooo`04o`000?ooooooooooo`0000Kooooo001^oooo
o`03o`000?oooooooooo00Gooooo00?o0000ooooooooool0DOooool00ol0003oooooooooo`02oooo
o`04o`000?ooooooooooo`0005?ooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`1B
ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000ooooooooool01?ooool006kooooo00?o0000
ooooooooool01Oooool00ol0003oooooooooo`1Booooo`05o`000?ooooooooooooooool000000_oo
ool00ol0003oooooooooo`1Booooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool0D?oo
ool2o`0000?ooooo00Co0000oooooooooooo00001_ooool006kooooo00Co0000oooooooooooooooo
1?l0001Booooo`05o`000?ooooooooooooooool000000_ooool01?l0003oooooooooool0001Aoooo
o`06o`000?ooooooooooooooool0003ooooo1?l0001Eooooo`04o`000?ooooooooooo`0000;ooooo
00?o0000ooooooooool01?ooool006gooooo0_l00003ooooo`03o`000?oooooooooo05?ooooo00Go
0000ooooooooooooooooo`000002ooooo`04o`000?ooooooooooo`00057ooooo00Oo0000oooooooo
ooooooooo`000?oooooo000005Cooooo00Go0000ooooooooooooooooo`000002ooooo`04o`000?oo
ooooooooo`0000Kooooo001^ooooo`04o`000?ooooooooooooooo`Go0000D_ooool3o`0000Cooooo
0_l0001Cooooo`?o00000_ooool5o`00057ooooo0ol00004ooooo`;o00001oooool001Kooooo00?o
0000ooooooooool0oooooomhooooo`005_ooool00ol0003oooooooooo`3oooooogSooooo000Foooo
o`03o`000?oooooooooo0?ooooooN?ooool001Kooooo00?o0000ooooooooool0oooooomhooooo`00
5_ooool00ol0003oooooooooo`3oooooogSooooo000Eooooo`?o00003oooool3o`000?oooooo9?oo
ool00ol0003oooooo`00000?ooooo`;o00004?ooool3o`00013ooooo0ol00009ooooo`003Ooooooo
o`0008?o00000Oooool001Gooooo1?l0000>ooooo`Co00004?ooool00ol0003oooooooooo`0?oooo
o`03o`000?oooooooooo013ooooo00?o0000ooooooooool03oooool00ol0003oooooooooo`0?oooo
o`03o`000?oooooooooo013ooooo00?o0000ooooooooool03oooool00ol0003oooooooooo`0?oooo
o`03o`000?oooooooooo013ooooo00?o0000ooooooooool03oooool00ol0003oooooooooo`0@oooo
o`03o`000?oooooooooo00oooooo00?o0000ooooooooool03oooool00ol0003oooooooooo`0@oooo
o`03o`000?oooooooooo00oooooo00?o0000ooooooooool03_ooool4o`0000kooooo1?l0000>oooo
o`Co00003_ooool5o`0000Sooooo000Fooooo`;o00004?ooool3o`00013ooooo00?o0000oooooooo
ool03oooool00ol0003oooooooooo`0@ooooo`03o`000?oooooooooo00oooooo00?o0000oooooooo
ool03oooool00ol0003oooooooooo`0@ooooo`03o`000?oooooooooo00oooooo00?o0000oooooooo
ool03oooool00ol0003oooooooooo`0@ooooo`03o`000?oooooooooo00oooooo00?o0000oooooooo
ool04?ooool00ol0003oooooooooo`0?ooooo`03o`000?oooooooooo00oooooo00?o0000oooooooo
ool04?ooool00ol0003oooooooooo`0?ooooo`03o`000?oooooooooo00oooooo00?o0000oooooooo
ool03oooool2o`00013ooooo0ol0000?ooooo`?o00002Oooool001Kooooo00?o0000ooooooooool0
4?ooool00ol0003oooooooooo`16ooooo`03o`000?oooooooooo05Wooooo00?o0000ooooooooool0
FOooool00ol0003oooooooooo`0Qooooo`03o`000?oooooooooo02;ooooo00?o0000ooooooooool0
3oooool00ol0003oooooooooo`08ooooo`005_ooool00ol0003oooooooooo`3oooooogSooooo000F
ooooo`03o`000?oooooooooo0?ooooooN?ooool001Kooooo00?o0000ooooooooool0oooooomhoooo
o`005_ooool00ol0003oooooooooo`3oooooogSooooo000Fooooo`03o`000?oooooooooo0?oooooo
N?ooool001Kooooo00?o0000ooooooooool0oooooomhooooo`005_ooool3o`000?ooooooN?ooool0
01Kooooo00?o0000ooooooooool0oooooomhooooo`005_ooool00ol0003oooooooooo`3oooooogSo
oooo000Fooooo`03o`000?oooooooooo0?ooooooN?ooool001Kooooo00?o0000ooooooooool0oooo
oomhooooo`005_ooool00ol0003oooooooooo`3oooooogSooooo000Fooooo`03o`000?oooooooooo
0?ooooooN?ooool001Kooooo00?o0000ooooooooool0oooooomhooooo`005_ooool00ol0003ooooo
ooooo`3Zooooo`;o00004Oooool00ol0003oooooo`00000?ooooo`;o00004?ooool2o`0005Cooooo
000Fooooo`?o0000joooool2o`00013ooooo0ol0000@ooooo`;o00004?ooool2o`0005?ooooo000F
ooooo`03o`000?oooooooooo0>[ooooo1?l0000?ooooo`Co00003_ooool4o`0000kooooo1?l0001B
ooooo`005_ooool00ol0003oooooooooo`3[ooooo`03o`000?oooooooooo013ooooo00?o0000oooo
ooooool03oooool00ol0003oooooooooo`0?ooooo`03o`000?oooooooooo05;ooooo000Fooooo`03
o`000?oooooooooo027ooooo0ol0003Jooooo`03o`000?oooooooooo07Kooooo000Fooooo`03o`00
0?oooooooooo027ooooo0ol0003ooooooeCooooo000Fooooo`03o`000?oooooooooo023ooooo1?l0
003ooooooeCooooo000Fooooo`03o`000?oooooooooo027ooooo0ol0003ooooooeCooooo000Foooo
o`03o`000?oooooooooo02;ooooo00?o0000ooooooooool0oooooomCooooo`005_ooool00ol0003o
ooooooooo`3oooooogSooooo000Fooooo`03o`000?oooooooooo0?ooooooN?ooool001Kooooo0ol0
003oooooodSooooo0_l0000^ooooo`005_ooool00ol0003oooooooooo`3oooooodOooooo0ol0000^
ooooo`005_ooool00ol0003oooooooooo`3oooooodSooooo0_l0000^ooooo`005_ooool00ol0003o
ooooooooo`3oooooogSooooo000Fooooo`03o`000?oooooooooo03?ooooo0ol0002Rooooo`;o0000
WOooool001Kooooo00?o0000ooooooooool0<oooool3o`000:?ooooo0_l0002Looooo`005_ooool0
0ol0003oooooooooo`0cooooo`Co0000XOooool4o`0009_ooooo000Fooooo`03o`000?oooooooooo
03Cooooo00?o0000ooooooooool0oooooom1ooooo`005_ooool00ol0003oooooooooo`3oooooogSo
oooo000Fooooo`03o`000?oooooooooo0?ooooooN?ooool001Kooooo0ol0003oooooogSooooo000F
ooooo`03o`000?oooooooooo0?ooooooN?ooool001Kooooo00?o0000ooooooooool0oooooomhoooo
o`005_ooool00ol0003oooooooooo`3oooooogSooooo000Fooooo`03o`000?oooooooooo04Kooooo
0_l0000@ooooo`?o0000oooooolMooooo`005_ooool00ol0003oooooooooo`15ooooo`Co00003ooo
ool3o`000?oooooo7Oooool001Kooooo00?o0000ooooooooool0A_ooool3o`0000oooooo0ol0003o
oooooagooooo0002ooooo`;o00001?ooool00ol0003oooooooooo`02ooooo`?o00001_ooool00ol0
003oooooooooo`17ooooo`03o`000?oooooooooo00oooooo00?o0000ooooooooool0oooooolLoooo
o`0000Goooooo`000?ooooooooooo`000007ooooo`05o`000?ooooooooooooooool000001Oooool0
0ol0003oooooooooo`36ooooo`03o`000?oooooo00000:kooooo00001Ooooooo0000oooooooooooo
000000_ooooo00?o0000ooooooooool00oooool4o`000<Gooooo0ol0002^ooooo`0000Goooooo`00
0?ooooooooooo`00000;ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool0a_ooool4
o`000:gooooo00001Ooooooo0000oooooooooooo000000Oooooo1?l00006ooooo`03o`000?oooooo
oooo0<Oooooo00?o0000ooooooooool0[Oooool00005ooooool0003oooooooooool000001oooool0
0ol0003oooooooooo`07ooooo`03o`000?oooooooooo0<Oooooo00?o0000ooooooooool0[Oooool0
00;ooooo0_l00008ooooo`Go00001Oooool00ol0003oooooooooo`3oooooogSooooo000Fooooo`03
o`000?oooooooooo0?ooooooN?ooool001Kooooo00?o0000ooooooooool0oooooomhooooo`005_oo
ool00ol0003oooooooooo`3oooooogSooooo000Fooooo`03o`000?oooooooooo0?ooooooN?ooool0
01Kooooo00?o0000ooooooooool0oooooomhooooo`005_ooool3o`000?ooooooN?ooool001Kooooo
00?o0000ooooooooool0oooooomhooooo`005_ooool00ol0003oooooooooo`3oooooogSooooo000F
ooooo`03o`000?oooooooooo0?ooooooN?ooool001Kooooo00?o0000ooooooooool0oooooomhoooo
o`005_ooool00ol0003oooooooooo`3oooooogSooooo000Fooooo`03o`000?oooooooooo0?oooooo
N?ooool001Kooooo00?o0000ooooooooool0oooooomhooooo`005_ooool00ol0003oooooooooo`3o
ooooogSooooo000Fooooo`03o`000?oooooooooo0?ooooooN?ooool001Kooooo0ol0003oooooogSo
oooo000Fooooo`03o`000?oooooooooo0?ooooooN?ooool001Kooooo00?o0000ooooooooool0oooo
oomhooooo`005_ooool00ol0003oooooooooo`3oooooogSooooo000Fooooo`03o`000?oooooooooo
0?ooooooN?ooool001Kooooo00?o0000ooooooooool0oooooomhooooo`005_ooool00ol0003ooooo
ooooo`3oooooogSooooo000Fooooo`03o`000?oooooooooo0?ooooooN?ooool001Kooooo00?o0000
ooooooooool0oooooomhooooo`005_ooool3o`000?ooooooN?ooool001Kooooo00?o0000oooooooo
ool0oooooomhooooo`005_ooool00ol0003oooooooooo`2dooooo`03o`000?oooooooooo0<3ooooo
000Fooooo`03o`000?oooooooooo0;?ooooo1?l00030ooooo`005_ooool00ol0003oooooooooo`2d
ooooo`03o`000?oooooooooo0<3ooooo000Fooooo`03o`000?oooooooooo0?ooooooN?ooool001Ko
oooo00?o0000ooooooooool0oooooomhooooo`005_ooool00ol0003oooooooooo`3oooooogSooooo
000Fooooo`03o`000?oooooooooo0?ooooooN?ooool001Kooooo00?o0000ooooooooool0oooooomh
ooooo`005_ooool3o`000?ooooooN?ooool001Kooooo00?o0000ooooooooool0oooooomhooooo`00
5_ooool00ol0003oooooooooo`3oooooogSooooo000Fooooo`03o`000?oooooooooo0?ooooooN?oo
ool001Kooooo00?o0000ooooooooool0oooooomhooooo`005_ooool00ol0003oooooooooo`3ooooo
ogSooooo000Fooooo`03o`000?oooooooooo0?ooooooN?ooool000gooooo0ol00006ooooo`03o`00
0?oooooooooo0?ooooooN?ooool000kooooo00?o0000ooooooooool01Oooool00ol0003ooooooooo
o`3oooooogSooooo000>ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool0Joooool2
o`00013ooooo00?o0000ooooooooool03oooool00ol0003oooooo`00003Uooooo`003_ooool00ol0
003oooooooooo`05ooooo`Co0000JOooool4o`0000kooooo1?l0000?ooooo`Co0000i?ooool000ko
oooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`1Zooooo`?o00004?ooool00ol0003o
ooooooooo`0@ooooo`03o`000?oooooooooo0>Cooooo000=ooooo`;o00001oooool00ol0003ooooo
ooooo`1[ooooo`03o`000?oooooooooo02;ooooo00?o0000ooooooooool0i?ooool000kooooo00?o
0000ooooooooool01Oooool00ol0003oooooooooo`3oooooogSooooo000Fooooo`03o`000?oooooo
oooo0?ooooooN?ooool001Kooooo00?o0000ooooooooool0oooooomhooooo`005_ooool00ol0003o
ooooooooo`3oooooogSooooo000Fooooo`03o`000?oooooooooo0?ooooooN?ooool001Kooooo00?o
0000ooooooooool0oooooomhooooo`005_ooool3o`000?ooooooN?ooool001Kooooo00?o0000oooo
ooooool0oooooomhooooo`005_ooool00ol0003oooooooooo`3oooooogSooooo000Fooooo`03o`00
0?oooooooooo0?ooooooN?ooool001Kooooo00?o0000ooooooooool0XOooool00ol0003oooooo`00
003Cooooo`005_ooool00ol0003oooooooooo`2Rooooo`;o0000doooool001Kooooo00?o0000oooo
ooooool0XOooool4o`000=;ooooo000Fooooo`03o`000?oooooooooo0:;ooooo00?o0000oooooooo
ool0d_ooool001Kooooo00?o0000ooooooooool0X_ooool00ol0003oooooooooo`3Booooo`005_oo
ool00ol0003oooooooooo`3oooooogSooooo000Fooooo`?o0000oooooomhooooo`005_ooool00ol0
003oooooooooo`3oooooogSooooo000Fooooo`03o`000?oooooooooo0?ooooooN?ooool001Kooooo
00?o0000ooooooooool0oooooomhooooo`005_ooool00ol0003oooooooooo`3oooooogSooooo000F
ooooo`03o`000?oooooooooo0?ooooooN?ooool001Kooooo00?o0000ooooooooool0oooooomhoooo
o`005_ooool00ol0003oooooooooo`3oooooogSooooo000Fooooo`03o`000?oooooooooo0?oooooo
N?ooool001Kooooo00?o0000ooooooooool0oooooomhooooo`005_ooool3o`000?ooooooN?ooool0
01Kooooo00?o0000ooooooooool0oooooomhooooo`005_ooool00ol0003oooooooooo`3oooooogSo
oooo000Fooooo`03o`000?oooooooooo0<Oooooo00?o0000ooooooooool08_ooool00ol0003ooooo
ooooo`0?ooooo`03o`000?oooooooooo02;ooooo00?o0000ooooooooool03oooool00ol0003ooooo
ooooo`0oooooo`005_ooool00ol0003oooooooooo`36ooooo`?o00004?ooool2o`00013ooooo0ol0
000?ooooo`?o00004?ooool2o`00013ooooo0ol0000?ooooo`?o0000@?ooool001Kooooo00?o0000
ooooooooool0aOooool4o`0000oooooo0ol0000?ooooo`Co00003_ooool4o`0000oooooo0ol0000?
ooooo`Co00003_ooool4o`00043ooooo000Fooooo`03o`000?oooooooooo0<Kooooo0ol0000@oooo
o`;o00004?ooool3o`0000oooooo0ol0000@ooooo`;o00004?ooool3o`0000oooooo0ol00010oooo
o`005_ooool00ol0003oooooooooo`37ooooo`03o`000?oooooooooo02;ooooo00?o0000oooooooo
ool03oooool00ol0003oooooooooo`0Rooooo`03o`000?oooooooooo00oooooo00?o0000oooooooo
ool0?oooool001Kooooo00?o0000ooooooooool0oooooomhooooo`005_ooool3o`000?ooooooN?oo
ool001Kooooo00?o0000ooooooooool0oooooomhooooo`005_ooool00ol0003oooooooooo`3ooooo
ogSooooo000Fooooo`03o`000?oooooooooo0?ooooooN?ooool001Kooooo00?o0000ooooooooool0
oooooomhooooo`005_ooool00ol0003oooooooooo`3oooooogSooooo000Fooooo`03o`000?oooooo
oooo0?ooooooN?ooool00004ooooool0003o0000o`0000Cooooo00?o0000ooooooooool00_ooool3
o`0000Kooooo00?o0000ooooooooool0oooooomhooooo`000_ooool00ol0003oooooooooo`07oooo
o`05o`000?ooooooooooooooool000001Oooool00ol0003oooooooooo`3oooooogSooooo0002oooo
o`03o`000?oooooooooo00_ooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`1noooo
o`03o`000?oooooooooo03Cooooo00?o0000ooooooooool0_oooool000;ooooo00?o0000oooooooo
ool02oooool00ol0003oooooooooo`03ooooo`Co0000O?ooool3o`0003Cooooo0ol00030ooooo`00
0_ooool00ol0003oooooooooo`07ooooo`Co00001_ooool00ol0003oooooooooo`1mooooo`?o0000
=?ooool3o`000<3ooooo00000ooooooo0000o`000009ooooo`03o`000?oooooooooo00Oooooo00?o
0000ooooooooool0O_ooool00ol0003oooooooooo`0dooooo`03o`000?oooooooooo0;oooooo0002
ooooo`03o`000?oooooooooo00Oooooo1Ol00005ooooo`03o`000?oooooooooo0?ooooooN?ooool0
01Kooooo00?o0000ooooooooool0oooooomhooooo`005_ooool00ol0003oooooooooo`3oooooogSo
oooo000Fooooo`03o`000?oooooooooo0?ooooooN?ooool001Kooooo00?o0000ooooooooool0oooo
oomhooooo`005_ooool00ol0003oooooooooo`3oooooogSooooo000Fooooo`?o0000oooooomhoooo
o`005_ooool00ol0003oooooooooo`3oooooogSooooo000Fooooo`03o`000?oooooooooo0?oooooo
N?ooool001Kooooo00?o0000ooooooooool0oooooomhooooo`005_ooool00ol0003oooooooooo`3o
ooooogSooooo000Fooooo`03o`000?oooooooooo0?ooooooN?ooool001Kooooo00?o0000oooooooo
ool0oooooomhooooo`005_ooool00ol0003oooooooooo`3oooooogSooooo000Fooooo`03o`000?oo
oooooooo0?ooooooN?ooool001Kooooo00?o0000ooooooooool0oooooomhooooo`005_ooool3o`00
0?ooooooN?ooool001Kooooo00?o0000ooooooooool0oooooomhooooo`005_ooool00ol0003ooooo
ooooo`3oooooogSooooo000Fooooo`03o`000?oooooooooo0?ooooooN?ooool001Kooooo00?o0000
ooooooooool0oooooomhooooo`005_ooool00ol0003oooooooooo`3oooooogSooooo000Fooooo`03
o`000?oooooooooo0?ooooooN?ooool001Kooooo00?o0000ooooooooool0oooooomhooooo`005_oo
ool00ol0003oooooooooo`3oooooogSooooo000Fooooo`03o`000?oooooooooo0?ooooooN?ooool0
01Kooooo0ol0003oooooogSooooo000Fooooo`03o`000?oooooooooo0?ooooooN?ooool001Kooooo
00?o0000ooooooooool0oooooomhooooo`005_ooool00ol0003oooooooooo`3oooooogSooooo000F
ooooo`03o`000?oooooooooo0?ooooooN?ooool001Kooooo00?o0000ooooooooool0oooooomhoooo
o`005_ooool00ol0003oooooooooo`3oooooogSooooo000Fooooo`03o`000?oooooooooo0?oooooo
N?ooool001Kooooo00?o0000ooooooooool0oooooomhooooo`005_ooool3o`000?ooooooN?ooool0
01Kooooo00?o0000ooooooooool0oooooomhooooo`005_ooool00ol0003oooooooooo`3oooooogSo
oooo000Fooooo`03o`000?oooooooooo0?ooooooN?ooool001Kooooo00?o0000ooooooooool0oooo
oomhooooo`005_ooool00ol0003oooooooooo`3oooooogSooooo000Fooooo`03o`000?oooooooooo
0?ooooooN?ooool001Kooooo00?o0000ooooooooool0oooooomhooooo`003?ooool5o`0000Gooooo
00?o0000ooooooooool0oooooomhooooo`003Oooool01?l0003oooooooooool00005ooooo`03o`00
0?oooooooooo0:;ooooo00?o0000ooooooooool0d_ooool000kooooo00?o0000ooooooooool01Ooo
ool4o`000:7ooooo0_l0003Cooooo`003oooool00ol0003oooooooooo`04ooooo`03o`000?oooooo
oooo0:7ooooo0ol0003Cooooo`003?ooool01Ol0003ooooooooooooooooo000000Gooooo00?o0000
ooooooooool0X_ooool2o`000=?ooooo000<ooooo`05o`000?ooooooooooooooool000001Oooool0
0ol0003oooooooooo`2Rooooo`03o`000?oooooooooo0=;ooooo000=ooooo`?o00001_ooool00ol0
003oooooooooo`3oooooogSooooo000Fooooo`03o`000?oooooooooo0?ooooooN?ooool001Kooooo
00?o0000ooooooooool0oooooomhooooo`005_ooool00ol0003oooooooooo`3oooooogSooooo000F
ooooo`03o`000?oooooooooo0?ooooooN?ooool001Kooooo00?o0000ooooooooool0oooooomhoooo
o`005_ooool3o`000?ooooooN?ooool001Kooooo00?o0000ooooooooool0oooooomhooooo`005_oo
ool00ol0003oooooooooo`3oooooogSooooo000Fooooo`03o`000?oooooooooo0?ooooooN?ooool0
01Kooooo00?o0000ooooooooool0oooooomhooooo`005_ooool00ol0003oooooooooo`3oooooogSo
oooo000Fooooo`03o`000?oooooooooo0?ooooooN?ooool001Kooooo00?o0000ooooooooool0oooo
oomhooooo`005_ooool00ol0003oooooooooo`3oooooogSooooo000Fooooo`?o0000oooooomhoooo
o`005_ooool00ol0003oooooooooo`3oooooogSooooo000Fooooo`03o`000?oooooooooo0?oooooo
N?ooool001Kooooo00?o0000ooooooooool0oooooomhooooo`005_ooool00ol0003oooooooooo`3o
ooooogSooooo000Fooooo`03o`000?oooooooooo0?ooooooN?ooool001Kooooo00?o0000oooooooo
ool0oooooomhooooo`005_ooool00ol0003oooooooooo`3oooooogSooooo000Fooooo`03o`000?oo
oooooooo0?ooooooN?ooool001Kooooo00?o0000ooooooooool0oooooomhooooo`005_ooool3o`00
0?ooooooN?ooool001Kooooo00?o0000ooooooooool0oooooomhooooo`005_ooool00ol0003ooooo
ooooo`3oooooogSooooo000Fooooo`03o`000?oooooooooo0?ooooooN?ooool001Kooooo00?o0000
ooooooooool0T?ooool00ol0003oooooooooo`3Tooooo`005_ooool00ol0003oooooooooo`2?oooo
o`?o0000iOooool001Kooooo00?o0000ooooooooool0Soooool3o`000>Gooooo000Fooooo`03o`00
0?oooooooooo093ooooo00?o0000ooooooooool0i?ooool001Kooooo00?o0000ooooooooool0oooo
oomhooooo`005_ooool00ol0003oooooooooo`3oooooogSooooo000Fooooo`?o0000oooooomhoooo
o`00\
\>"],
  ImageRangeCache->{{{0, 399}, {246.188, 0}} -> {8.75075, -0.143191, \
0.0545229, 0.0103658}}]
}, Open  ]],

Cell[TextData[{
  "Le due serie sono state visualizzate utilizzando simboli differenti (nella \
fattispecie, un triangolo e una stella), ma sono troppo piccoli per poter \
essere distinti: il codice seguente definisce una nuova funzione ",
  StyleBox["enlarge", "Input"],
  " che permette di espandere un oggetto grafico secondo un fattore di scala \
definibile a piacere. Unitamente all'utilizzo dell'opzione ",
  StyleBox["SymbolShape", "Input"],
  ", ci\[OGrave] permette di ingrandire i simboli usati da ",
  StyleBox["MultipleListPlot", "Input"],
  ":"
}], "Text",
  PageWidth->PaperWidth],

Cell[CellGroupData[{

Cell[BoxData[{
    \(enlarge[obj_, factor_] := 
      obj /. {x_, y_} \[Rule] {x, y} factor\), "\[IndentingNewLine]", 
    \(\(MultipleListPlot[untreated, treated, 
        SymbolShape \[Rule] {enlarge[PlotSymbol[Triangle], 2], 
            enlarge[PlotSymbol[Star], 2.5]}];\)\)}], "Input",
  CellLabel->"In[12]:=",
  PageWidth->PaperWidth],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
%%ImageSize: 400 247.214 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.452381 0.047619 0.0147151 0.25047 [
[.2619 .00222 -6 -9 ]
[.2619 .00222 6 0 ]
[.5 .00222 -6 -9 ]
[.5 .00222 6 0 ]
[.7381 .00222 -6 -9 ]
[.7381 .00222 6 0 ]
[.97619 .00222 -6 -9 ]
[.97619 .00222 6 0 ]
[.01131 .13995 -18 -4.5 ]
[.01131 .13995 0 4.5 ]
[.01131 .26518 -6 -4.5 ]
[.01131 .26518 0 4.5 ]
[.01131 .39042 -18 -4.5 ]
[.01131 .39042 0 4.5 ]
[.01131 .51565 -6 -4.5 ]
[.01131 .51565 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.2619 .01472 m
.2619 .02097 L
s
[(15)] .2619 .00222 0 1 Mshowa
.5 .01472 m
.5 .02097 L
s
[(20)] .5 .00222 0 1 Mshowa
.7381 .01472 m
.7381 .02097 L
s
[(25)] .7381 .00222 0 1 Mshowa
.97619 .01472 m
.97619 .02097 L
s
[(30)] .97619 .00222 0 1 Mshowa
.125 Mabswid
.07143 .01472 m
.07143 .01847 L
s
.11905 .01472 m
.11905 .01847 L
s
.16667 .01472 m
.16667 .01847 L
s
.21429 .01472 m
.21429 .01847 L
s
.30952 .01472 m
.30952 .01847 L
s
.35714 .01472 m
.35714 .01847 L
s
.40476 .01472 m
.40476 .01847 L
s
.45238 .01472 m
.45238 .01847 L
s
.54762 .01472 m
.54762 .01847 L
s
.59524 .01472 m
.59524 .01847 L
s
.64286 .01472 m
.64286 .01847 L
s
.69048 .01472 m
.69048 .01847 L
s
.78571 .01472 m
.78571 .01847 L
s
.83333 .01472 m
.83333 .01847 L
s
.88095 .01472 m
.88095 .01847 L
s
.92857 .01472 m
.92857 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
.02381 .13995 m
.03006 .13995 L
s
[(0.5)] .01131 .13995 1 0 Mshowa
.02381 .26518 m
.03006 .26518 L
s
[(1)] .01131 .26518 1 0 Mshowa
.02381 .39042 m
.03006 .39042 L
s
[(1.5)] .01131 .39042 1 0 Mshowa
.02381 .51565 m
.03006 .51565 L
s
[(2)] .01131 .51565 1 0 Mshowa
.125 Mabswid
.02381 .03976 m
.02756 .03976 L
s
.02381 .06481 m
.02756 .06481 L
s
.02381 .08986 m
.02756 .08986 L
s
.02381 .1149 m
.02756 .1149 L
s
.02381 .165 m
.02756 .165 L
s
.02381 .19004 m
.02756 .19004 L
s
.02381 .21509 m
.02756 .21509 L
s
.02381 .24014 m
.02756 .24014 L
s
.02381 .29023 m
.02756 .29023 L
s
.02381 .31528 m
.02756 .31528 L
s
.02381 .34033 m
.02756 .34033 L
s
.02381 .36537 m
.02756 .36537 L
s
.02381 .41547 m
.02756 .41547 L
s
.02381 .44051 m
.02756 .44051 L
s
.02381 .46556 m
.02756 .46556 L
s
.02381 .49061 m
.02756 .49061 L
s
.02381 .5407 m
.02756 .5407 L
s
.02381 .56575 m
.02756 .56575 L
s
.02381 .5908 m
.02756 .5908 L
s
.02381 .61584 m
.02756 .61584 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.0001 w
.02381 .01472 0 5 Mabsadd m
.02381 .01472 -4.33 -2.5 Mabsadd L
.02381 .01472 4.33 -2.5 Mabsadd L
.02381 .01472 0 5 Mabsadd L closepath F
.07143 .01472 0 5 Mabsadd m
.07143 .01472 -4.33 -2.5 Mabsadd L
.07143 .01472 4.33 -2.5 Mabsadd L
.07143 .01472 0 5 Mabsadd L closepath F
.11905 .07483 0 5 Mabsadd m
.11905 .07483 -4.33 -2.5 Mabsadd L
.11905 .07483 4.33 -2.5 Mabsadd L
.11905 .07483 0 5 Mabsadd L closepath F
.16667 .10238 0 5 Mabsadd m
.16667 .10238 -4.33 -2.5 Mabsadd L
.16667 .10238 4.33 -2.5 Mabsadd L
.16667 .10238 0 5 Mabsadd L closepath F
.21429 .12743 0 5 Mabsadd m
.21429 .12743 -4.33 -2.5 Mabsadd L
.21429 .12743 4.33 -2.5 Mabsadd L
.21429 .12743 0 5 Mabsadd L closepath F
.2619 .12743 0 5 Mabsadd m
.2619 .12743 -4.33 -2.5 Mabsadd L
.2619 .12743 4.33 -2.5 Mabsadd L
.2619 .12743 0 5 Mabsadd L closepath F
.30952 .26518 0 5 Mabsadd m
.30952 .26518 -4.33 -2.5 Mabsadd L
.30952 .26518 4.33 -2.5 Mabsadd L
.30952 .26518 0 5 Mabsadd L closepath F
.35714 .39042 0 5 Mabsadd m
.35714 .39042 -4.33 -2.5 Mabsadd L
.35714 .39042 4.33 -2.5 Mabsadd L
.35714 .39042 0 5 Mabsadd L closepath F
.40476 .60332 0 5 Mabsadd m
.40476 .60332 -4.33 -2.5 Mabsadd L
.40476 .60332 4.33 -2.5 Mabsadd L
.40476 .60332 0 5 Mabsadd L closepath F
.45238 .51565 0 5 Mabsadd m
.45238 .51565 -4.33 -2.5 Mabsadd L
.45238 .51565 4.33 -2.5 Mabsadd L
.45238 .51565 0 5 Mabsadd L closepath F
.5 .39042 0 5 Mabsadd m
.5 .39042 -4.33 -2.5 Mabsadd L
.5 .39042 4.33 -2.5 Mabsadd L
.5 .39042 0 5 Mabsadd L closepath F
.54762 .35285 0 5 Mabsadd m
.54762 .35285 -4.33 -2.5 Mabsadd L
.54762 .35285 4.33 -2.5 Mabsadd L
.54762 .35285 0 5 Mabsadd L closepath F
.59524 .35285 0 5 Mabsadd m
.59524 .35285 -4.33 -2.5 Mabsadd L
.59524 .35285 4.33 -2.5 Mabsadd L
.59524 .35285 0 5 Mabsadd L closepath F
.64286 .35285 0 5 Mabsadd m
.64286 .35285 -4.33 -2.5 Mabsadd L
.64286 .35285 4.33 -2.5 Mabsadd L
.64286 .35285 0 5 Mabsadd L closepath F
.69048 .35285 0 5 Mabsadd m
.69048 .35285 -4.33 -2.5 Mabsadd L
.69048 .35285 4.33 -2.5 Mabsadd L
.69048 .35285 0 5 Mabsadd L closepath F
.7381 .35285 0 5 Mabsadd m
.7381 .35285 -4.33 -2.5 Mabsadd L
.7381 .35285 4.33 -2.5 Mabsadd L
.7381 .35285 0 5 Mabsadd L closepath F
.78571 .35285 0 5 Mabsadd m
.78571 .35285 -4.33 -2.5 Mabsadd L
.78571 .35285 4.33 -2.5 Mabsadd L
.78571 .35285 0 5 Mabsadd L closepath F
.83333 .35285 0 5 Mabsadd m
.83333 .35285 -4.33 -2.5 Mabsadd L
.83333 .35285 4.33 -2.5 Mabsadd L
.83333 .35285 0 5 Mabsadd L closepath F
.88095 .08986 0 5 Mabsadd m
.88095 .08986 -4.33 -2.5 Mabsadd L
.88095 .08986 4.33 -2.5 Mabsadd L
.88095 .08986 0 5 Mabsadd L closepath F
.92857 .01472 0 5 Mabsadd m
.92857 .01472 -4.33 -2.5 Mabsadd L
.92857 .01472 4.33 -2.5 Mabsadd L
.92857 .01472 0 5 Mabsadd L closepath F
.97619 .01472 0 5 Mabsadd m
.97619 .01472 -4.33 -2.5 Mabsadd L
.97619 .01472 4.33 -2.5 Mabsadd L
.97619 .01472 0 5 Mabsadd L closepath F
.02381 .01472 0 6.25 Mabsadd m
.02381 .01472 -1.41294 1.94475 Mabsadd L
.02381 .01472 -5.94411 1.93136 Mabsadd L
.02381 .01472 -2.28619 -0.74283 Mabsadd L
.02381 .01472 -3.67366 -5.05636 Mabsadd L
.02381 .01472 0 -2.40384 Mabsadd L
.02381 .01472 3.67366 -5.05636 Mabsadd L
.02381 .01472 2.28619 -0.74283 Mabsadd L
.02381 .01472 5.94411 1.93136 Mabsadd L
.02381 .01472 1.41294 1.94475 Mabsadd L
.02381 .01472 0 6.25 Mabsadd L closepath F
.07143 .01472 0 6.25 Mabsadd m
.07143 .01472 -1.41294 1.94475 Mabsadd L
.07143 .01472 -5.94411 1.93136 Mabsadd L
.07143 .01472 -2.28619 -0.74283 Mabsadd L
.07143 .01472 -3.67366 -5.05636 Mabsadd L
.07143 .01472 0 -2.40384 Mabsadd L
.07143 .01472 3.67366 -5.05636 Mabsadd L
.07143 .01472 2.28619 -0.74283 Mabsadd L
.07143 .01472 5.94411 1.93136 Mabsadd L
.07143 .01472 1.41294 1.94475 Mabsadd L
.07143 .01472 0 6.25 Mabsadd L closepath F
.11905 .07483 0 6.25 Mabsadd m
.11905 .07483 -1.41294 1.94475 Mabsadd L
.11905 .07483 -5.94411 1.93136 Mabsadd L
.11905 .07483 -2.28619 -0.74283 Mabsadd L
.11905 .07483 -3.67366 -5.05636 Mabsadd L
.11905 .07483 0 -2.40384 Mabsadd L
.11905 .07483 3.67366 -5.05636 Mabsadd L
.11905 .07483 2.28619 -0.74283 Mabsadd L
.11905 .07483 5.94411 1.93136 Mabsadd L
.11905 .07483 1.41294 1.94475 Mabsadd L
.11905 .07483 0 6.25 Mabsadd L closepath F
.16667 .10238 0 6.25 Mabsadd m
.16667 .10238 -1.41294 1.94475 Mabsadd L
.16667 .10238 -5.94411 1.93136 Mabsadd L
.16667 .10238 -2.28619 -0.74283 Mabsadd L
.16667 .10238 -3.67366 -5.05636 Mabsadd L
.16667 .10238 0 -2.40384 Mabsadd L
.16667 .10238 3.67366 -5.05636 Mabsadd L
.16667 .10238 2.28619 -0.74283 Mabsadd L
.16667 .10238 5.94411 1.93136 Mabsadd L
.16667 .10238 1.41294 1.94475 Mabsadd L
.16667 .10238 0 6.25 Mabsadd L closepath F
.21429 .12743 0 6.25 Mabsadd m
.21429 .12743 -1.41294 1.94475 Mabsadd L
.21429 .12743 -5.94411 1.93136 Mabsadd L
.21429 .12743 -2.28619 -0.74283 Mabsadd L
.21429 .12743 -3.67366 -5.05636 Mabsadd L
.21429 .12743 0 -2.40384 Mabsadd L
.21429 .12743 3.67366 -5.05636 Mabsadd L
.21429 .12743 2.28619 -0.74283 Mabsadd L
.21429 .12743 5.94411 1.93136 Mabsadd L
.21429 .12743 1.41294 1.94475 Mabsadd L
.21429 .12743 0 6.25 Mabsadd L closepath F
.2619 .12743 0 6.25 Mabsadd m
.2619 .12743 -1.41294 1.94475 Mabsadd L
.2619 .12743 -5.94411 1.93136 Mabsadd L
.2619 .12743 -2.28619 -0.74283 Mabsadd L
.2619 .12743 -3.67366 -5.05636 Mabsadd L
.2619 .12743 0 -2.40384 Mabsadd L
.2619 .12743 3.67366 -5.05636 Mabsadd L
.2619 .12743 2.28619 -0.74283 Mabsadd L
.2619 .12743 5.94411 1.93136 Mabsadd L
.2619 .12743 1.41294 1.94475 Mabsadd L
.2619 .12743 0 6.25 Mabsadd L closepath F
.30952 .26518 0 6.25 Mabsadd m
.30952 .26518 -1.41294 1.94475 Mabsadd L
.30952 .26518 -5.94411 1.93136 Mabsadd L
.30952 .26518 -2.28619 -0.74283 Mabsadd L
.30952 .26518 -3.67366 -5.05636 Mabsadd L
.30952 .26518 0 -2.40384 Mabsadd L
.30952 .26518 3.67366 -5.05636 Mabsadd L
.30952 .26518 2.28619 -0.74283 Mabsadd L
.30952 .26518 5.94411 1.93136 Mabsadd L
.30952 .26518 1.41294 1.94475 Mabsadd L
.30952 .26518 0 6.25 Mabsadd L closepath F
.35714 .26518 0 6.25 Mabsadd m
.35714 .26518 -1.41294 1.94475 Mabsadd L
.35714 .26518 -5.94411 1.93136 Mabsadd L
.35714 .26518 -2.28619 -0.74283 Mabsadd L
.35714 .26518 -3.67366 -5.05636 Mabsadd L
.35714 .26518 0 -2.40384 Mabsadd L
.35714 .26518 3.67366 -5.05636 Mabsadd L
.35714 .26518 2.28619 -0.74283 Mabsadd L
.35714 .26518 5.94411 1.93136 Mabsadd L
.35714 .26518 1.41294 1.94475 Mabsadd L
.35714 .26518 0 6.25 Mabsadd L closepath F
.40476 .26518 0 6.25 Mabsadd m
.40476 .26518 -1.41294 1.94475 Mabsadd L
.40476 .26518 -5.94411 1.93136 Mabsadd L
.40476 .26518 -2.28619 -0.74283 Mabsadd L
.40476 .26518 -3.67366 -5.05636 Mabsadd L
.40476 .26518 0 -2.40384 Mabsadd L
.40476 .26518 3.67366 -5.05636 Mabsadd L
.40476 .26518 2.28619 -0.74283 Mabsadd L
.40476 .26518 5.94411 1.93136 Mabsadd L
.40476 .26518 1.41294 1.94475 Mabsadd L
.40476 .26518 0 6.25 Mabsadd L closepath F
.45238 .30276 0 6.25 Mabsadd m
.45238 .30276 -1.41294 1.94475 Mabsadd L
.45238 .30276 -5.94411 1.93136 Mabsadd L
.45238 .30276 -2.28619 -0.74283 Mabsadd L
.45238 .30276 -3.67366 -5.05636 Mabsadd L
.45238 .30276 0 -2.40384 Mabsadd L
.45238 .30276 3.67366 -5.05636 Mabsadd L
.45238 .30276 2.28619 -0.74283 Mabsadd L
.45238 .30276 5.94411 1.93136 Mabsadd L
.45238 .30276 1.41294 1.94475 Mabsadd L
.45238 .30276 0 6.25 Mabsadd L closepath F
.5 .22135 0 6.25 Mabsadd m
.5 .22135 -1.41294 1.94475 Mabsadd L
.5 .22135 -5.94411 1.93136 Mabsadd L
.5 .22135 -2.28619 -0.74283 Mabsadd L
.5 .22135 -3.67366 -5.05636 Mabsadd L
.5 .22135 0 -2.40384 Mabsadd L
.5 .22135 3.67366 -5.05636 Mabsadd L
.5 .22135 2.28619 -0.74283 Mabsadd L
.5 .22135 5.94411 1.93136 Mabsadd L
.5 .22135 1.41294 1.94475 Mabsadd L
.5 .22135 0 6.25 Mabsadd L closepath F
.54762 .13995 0 6.25 Mabsadd m
.54762 .13995 -1.41294 1.94475 Mabsadd L
.54762 .13995 -5.94411 1.93136 Mabsadd L
.54762 .13995 -2.28619 -0.74283 Mabsadd L
.54762 .13995 -3.67366 -5.05636 Mabsadd L
.54762 .13995 0 -2.40384 Mabsadd L
.54762 .13995 3.67366 -5.05636 Mabsadd L
.54762 .13995 2.28619 -0.74283 Mabsadd L
.54762 .13995 5.94411 1.93136 Mabsadd L
.54762 .13995 1.41294 1.94475 Mabsadd L
.54762 .13995 0 6.25 Mabsadd L closepath F
.59524 .10238 0 6.25 Mabsadd m
.59524 .10238 -1.41294 1.94475 Mabsadd L
.59524 .10238 -5.94411 1.93136 Mabsadd L
.59524 .10238 -2.28619 -0.74283 Mabsadd L
.59524 .10238 -3.67366 -5.05636 Mabsadd L
.59524 .10238 0 -2.40384 Mabsadd L
.59524 .10238 3.67366 -5.05636 Mabsadd L
.59524 .10238 2.28619 -0.74283 Mabsadd L
.59524 .10238 5.94411 1.93136 Mabsadd L
.59524 .10238 1.41294 1.94475 Mabsadd L
.59524 .10238 0 6.25 Mabsadd L closepath F
.64286 .06481 0 6.25 Mabsadd m
.64286 .06481 -1.41294 1.94475 Mabsadd L
.64286 .06481 -5.94411 1.93136 Mabsadd L
.64286 .06481 -2.28619 -0.74283 Mabsadd L
.64286 .06481 -3.67366 -5.05636 Mabsadd L
.64286 .06481 0 -2.40384 Mabsadd L
.64286 .06481 3.67366 -5.05636 Mabsadd L
.64286 .06481 2.28619 -0.74283 Mabsadd L
.64286 .06481 5.94411 1.93136 Mabsadd L
.64286 .06481 1.41294 1.94475 Mabsadd L
.64286 .06481 0 6.25 Mabsadd L closepath F
.69048 .06481 0 6.25 Mabsadd m
.69048 .06481 -1.41294 1.94475 Mabsadd L
.69048 .06481 -5.94411 1.93136 Mabsadd L
.69048 .06481 -2.28619 -0.74283 Mabsadd L
.69048 .06481 -3.67366 -5.05636 Mabsadd L
.69048 .06481 0 -2.40384 Mabsadd L
.69048 .06481 3.67366 -5.05636 Mabsadd L
.69048 .06481 2.28619 -0.74283 Mabsadd L
.69048 .06481 5.94411 1.93136 Mabsadd L
.69048 .06481 1.41294 1.94475 Mabsadd L
.69048 .06481 0 6.25 Mabsadd L closepath F
.7381 .06481 0 6.25 Mabsadd m
.7381 .06481 -1.41294 1.94475 Mabsadd L
.7381 .06481 -5.94411 1.93136 Mabsadd L
.7381 .06481 -2.28619 -0.74283 Mabsadd L
.7381 .06481 -3.67366 -5.05636 Mabsadd L
.7381 .06481 0 -2.40384 Mabsadd L
.7381 .06481 3.67366 -5.05636 Mabsadd L
.7381 .06481 2.28619 -0.74283 Mabsadd L
.7381 .06481 5.94411 1.93136 Mabsadd L
.7381 .06481 1.41294 1.94475 Mabsadd L
.7381 .06481 0 6.25 Mabsadd L closepath F
.78571 .06481 0 6.25 Mabsadd m
.78571 .06481 -1.41294 1.94475 Mabsadd L
.78571 .06481 -5.94411 1.93136 Mabsadd L
.78571 .06481 -2.28619 -0.74283 Mabsadd L
.78571 .06481 -3.67366 -5.05636 Mabsadd L
.78571 .06481 0 -2.40384 Mabsadd L
.78571 .06481 3.67366 -5.05636 Mabsadd L
.78571 .06481 2.28619 -0.74283 Mabsadd L
.78571 .06481 5.94411 1.93136 Mabsadd L
.78571 .06481 1.41294 1.94475 Mabsadd L
.78571 .06481 0 6.25 Mabsadd L closepath F
.83333 .01472 0 6.25 Mabsadd m
.83333 .01472 -1.41294 1.94475 Mabsadd L
.83333 .01472 -5.94411 1.93136 Mabsadd L
.83333 .01472 -2.28619 -0.74283 Mabsadd L
.83333 .01472 -3.67366 -5.05636 Mabsadd L
.83333 .01472 0 -2.40384 Mabsadd L
.83333 .01472 3.67366 -5.05636 Mabsadd L
.83333 .01472 2.28619 -0.74283 Mabsadd L
.83333 .01472 5.94411 1.93136 Mabsadd L
.83333 .01472 1.41294 1.94475 Mabsadd L
.83333 .01472 0 6.25 Mabsadd L closepath F
.88095 .01472 0 6.25 Mabsadd m
.88095 .01472 -1.41294 1.94475 Mabsadd L
.88095 .01472 -5.94411 1.93136 Mabsadd L
.88095 .01472 -2.28619 -0.74283 Mabsadd L
.88095 .01472 -3.67366 -5.05636 Mabsadd L
.88095 .01472 0 -2.40384 Mabsadd L
.88095 .01472 3.67366 -5.05636 Mabsadd L
.88095 .01472 2.28619 -0.74283 Mabsadd L
.88095 .01472 5.94411 1.93136 Mabsadd L
.88095 .01472 1.41294 1.94475 Mabsadd L
.88095 .01472 0 6.25 Mabsadd L closepath F
.92857 .01472 0 6.25 Mabsadd m
.92857 .01472 -1.41294 1.94475 Mabsadd L
.92857 .01472 -5.94411 1.93136 Mabsadd L
.92857 .01472 -2.28619 -0.74283 Mabsadd L
.92857 .01472 -3.67366 -5.05636 Mabsadd L
.92857 .01472 0 -2.40384 Mabsadd L
.92857 .01472 3.67366 -5.05636 Mabsadd L
.92857 .01472 2.28619 -0.74283 Mabsadd L
.92857 .01472 5.94411 1.93136 Mabsadd L
.92857 .01472 1.41294 1.94475 Mabsadd L
.92857 .01472 0 6.25 Mabsadd L closepath F
.97619 .01472 0 6.25 Mabsadd m
.97619 .01472 -1.41294 1.94475 Mabsadd L
.97619 .01472 -5.94411 1.93136 Mabsadd L
.97619 .01472 -2.28619 -0.74283 Mabsadd L
.97619 .01472 -3.67366 -5.05636 Mabsadd L
.97619 .01472 0 -2.40384 Mabsadd L
.97619 .01472 3.67366 -5.05636 Mabsadd L
.97619 .01472 2.28619 -0.74283 Mabsadd L
.97619 .01472 5.94411 1.93136 Mabsadd L
.97619 .01472 1.41294 1.94475 Mabsadd L
.97619 .01472 0 6.25 Mabsadd L closepath F
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[12]:=",
  ImageSize->{400, 247.188},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006@0000mb000`400?l00000o`00003ooooooonA
ooooo`00KOooool3o`0000?ooooo0ol0001Booooo`Go00000oooool2o`0005;ooooo1Ol00002oooo
o`?o0000D_ooool3o`0000Cooooo0_l00007ooooo`00K_ooool01Ol0003ooooooooooooooooo0000
00?ooooo00?o0000ooooooooool0D?ooool01?l0003oooooooooool00002ooooo`04o`000?oooooo
ooooo`0005;ooooo00Ko0000oooooooooooo0000ooooool00003ooooo`03o`000?oooooooooo04ko
oooo00Go0000ooooooooooooooooo`000002ooooo`04o`000?ooooooooooo`0000Kooooo001^oooo
o`03o`000?oooooooooo00Gooooo00?o0000ooooooooool0DOooool00ol0003oooooooooo`02oooo
o`04o`000?ooooooooooo`0005?ooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`1B
ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000ooooooooool01?ooool006kooooo00?o0000
ooooooooool01Oooool00ol0003oooooooooo`1Booooo`05o`000?ooooooooooooooool000000_oo
ool00ol0003oooooooooo`1Booooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool0D?oo
ool2o`0000?ooooo00Co0000oooooooooooo00001_ooool006kooooo00Co0000oooooooooooooooo
1?l0001Booooo`05o`000?ooooooooooooooool000000_ooool01?l0003oooooooooool0001Aoooo
o`06o`000?ooooooooooooooool0003ooooo1?l0001Eooooo`04o`000?ooooooooooo`0000;ooooo
00?o0000ooooooooool01?ooool006gooooo0_l00003ooooo`03o`000?oooooooooo05?ooooo00Go
0000ooooooooooooooooo`000002ooooo`04o`000?ooooooooooo`00057ooooo00Oo0000oooooooo
ooooooooo`000?oooooo000005Cooooo00Go0000ooooooooooooooooo`000002ooooo`04o`000?oo
ooooooooo`0000Kooooo001^ooooo`04o`000?ooooooooooooooo`Go0000D_ooool3o`0000Cooooo
0_l0001Cooooo`?o00000_ooool5o`00057ooooo0ol00004ooooo`;o00001oooool001Kooooo00?o
0000ooooooooool0oooooomhooooo`005_ooool00ol0003oooooooooo`3oooooogSooooo000Coooo
o`04o`000?ooooooooooo`0000;ooooo00?o0000ooooooooool02Oooool2o`000?oooooo9Oooool0
0ol0003oooooooooo`03ooooo`03o`000?oooooooooo00Wooooo0_l0000@ooooo`;o00001Oooool0
0ol0003oooooooooo`09ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool01Oooool0
01?ooooo0_l000000ooooooo0000ooooo`02o`0000_ooooo0ol00003ooooo`03o`000?oooooooooo
0?oooooo7_ooool2o`0000?ooooo0_l0000;ooooo`?o00000oooool00ol0003oooooooooo`0:oooo
o`;o00000oooool2o`0000_ooooo0_l00003ooooo`;o00001oooool001Cooooo1_l0000<ooooo`?o
000000?oooooo`000?l00000oooooolQooooo`;o000000?oooooo`000?l000003Oooool3o`000003
ooooool0003o000000cooooo0ol000000ooooooo0000o`00000=ooooo`;o000000Coooooo`000?l0
003o00001oooool001;ooooo2Ol00009ooooo`Wo0000oooooolPooooo`Go00003Oooool5o`0000co
oooo2?l0000:ooooo`Wo00001_ooool000goooooool00023o`00007ooooo000Booooo`Wo00002_oo
ool9o`0000gooooo00?o0000ooooooooool03oooool00ol0003oooooooooo`0@ooooo`03o`000?oo
oooooooo00oooooo00?o0000ooooooooool03oooool00ol0003oooooooooo`0@ooooo`03o`000?oo
oooooooo00oooooo00?o0000ooooooooool03oooool00ol0003oooooooooo`0@ooooo`03o`000?oo
oooooooo00oooooo00?o0000ooooooooool04?ooool00ol0003oooooooooo`0?ooooo`03o`000?oo
oooooooo00oooooo00?o0000ooooooooool04?ooool00ol0003oooooooooo`0?ooooo`03o`000?oo
oooooooo00_ooooo2Ol0000:ooooo`So00002_ooool9o`0000Wooooo2Ol00006ooooo`004Oooool;
o`0000Sooooo2ol0000<ooooo`03o`000?oooooooooo00oooooo00?o0000ooooooooool04?ooool0
0ol0003oooooooooo`0?ooooo`03o`000?oooooooooo00oooooo00?o0000ooooooooool04?ooool0
0ol0003oooooooooo`0?ooooo`03o`000?oooooooooo00oooooo00?o0000ooooooooool04?ooool0
0ol0003oooooooooo`0?ooooo`03o`000?oooooooooo013ooooo00?o0000ooooooooool03oooool0
0ol0003oooooooooo`0?ooooo`03o`000?oooooooooo013ooooo00?o0000ooooooooool03oooool0
0ol0003oooooooooo`0:ooooo`_o00002?ooool:o`0000Sooooo2ol00007ooooo`_o00001Oooool0
01Gooooo0ol0000?ooooo`Co0000Aoooool00ol0003oooooooooo`1Iooooo`03o`000?oooooooooo
05Wooooo00?o0000ooooooooool08?ooool3o`0000oooooo0ol0000?ooooo`Co00003oooool3o`00
00Wooooo000Eooooo`?o00004?ooool2o`000?oooooo9?ooool3o`00013ooooo0_l0000@ooooo`;o
00004?ooool3o`0000Wooooo000Fooooo`03o`000?oooooooooo00oooooo0_l0003oooooobGooooo
00?o0000ooooooooool03oooool2o`00013ooooo0_l0000Aooooo`03o`000?oooooooooo00Sooooo
000Fooooo`03o`000?oooooooooo0?oooooo=_ooool00ol0003oooooooooo`0dooooo`03o`000?oo
oooooooo00Sooooo000Fooooo`03o`000?oooooooooo0?ooooooN?ooool001Kooooo00?o0000oooo
ooooool0oooooomhooooo`005_ooool00ol0003oooooooooo`3oooooogSooooo000Fooooo`?o0000
oooooomhooooo`005_ooool00ol0003oooooooooo`3oooooogSooooo000Fooooo`03o`000?oooooo
oooo0?ooooooN?ooool001Kooooo00?o0000ooooooooool0oooooomhooooo`005_ooool00ol0003o
ooooooooo`3oooooogSooooo000Fooooo`03o`000?oooooooooo0>Sooooo0_l00005ooooo`03o`00
0?oooooooooo00Wooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`09ooooo`;o0000
4?ooool2o`0000Gooooo00?o0000ooooooooool0C_ooool001Kooooo00?o0000ooooooooool0jOoo
ool2o`0000?ooooo0_l0000;ooooo`;o00000oooool2o`0000_ooooo0ol00003ooooo`03o`000?oo
oooooooo00[ooooo0_l00003ooooo`;o0000D?ooool001Kooooo00?o0000ooooooooool0jOooool3
o`000003ooooool0003o000000gooooo0_l000000ooooooo0000o`00000=ooooo`?o000000?ooooo
o`000?l000003?ooool3o`000003ooooool0003o0000057ooooo000Fooooo`03o`000?oooooooooo
0>Wooooo1_l0000=ooooo`Go00003Oooool5o`0000gooooo1_l0001Aooooo`005_ooool3o`0001ko
oooo0_l00005ooooo`03o`000?oooooooooo0<;ooooo1Ol0000=ooooo`Go00003Oooool5o`0000ko
oooo1Ol0001Aooooo`005_ooool00ol0003oooooooooo`0Oooooo`;o00000oooool2o`000<?ooooo
1ol0000;ooooo`Oo00002oooool8o`0000_ooooo1ol0001@ooooo`005_ooool00ol0003ooooooooo
o`0Oooooo`?o000000?oooooo`000?l00000`_ooool;o`0000Oooooo2ol00008ooooo`[o00002?oo
ool;o`0004kooooo000Fooooo`03o`000?oooooooooo01kooooo2?l00034ooooo`?o00004?ooool3
o`0000oooooo0ol0000?ooooo`?o0000Doooool001Kooooo00?o0000ooooooooool07oooool7o`00
0<Gooooo0_l0000@ooooo`?o00004?ooool2o`00013ooooo0_l0001Cooooo`005_ooool00ol0003o
ooooooooo`0Oooooo`Oo0000aOooool2o`00017ooooo00?o0000ooooooooool03oooool2o`00013o
oooo0_l0001Cooooo`005_ooool00ol0003oooooooooo`0Mooooo`_o0000`oooool00ol0003ooooo
ooooo`0@ooooo`03o`000?oooooooooo00oooooo00?o0000ooooooooool03oooool00ol0003ooooo
ooooo`1Booooo`005_ooool00ol0003oooooooooo`0Qooooo`?o0000f_ooool00ol0003ooooooooo
o`1fooooo`005_ooool00ol0003oooooooooo`0Qooooo`?o0000oooooomDooooo`005_ooool00ol0
003oooooooooo`0Rooooo`03o`000?oooooooooo0?oooooo7oooool9o`0002_ooooo000Fooooo`?o
00008_ooool00ol0003oooooooooo`3oooooob3ooooo2?l0000[ooooo`005_ooool00ol0003ooooo
ooooo`0Rooooo`03o`000?oooooooooo00cooooo0_l00004ooooo`03o`000?oooooooooo09cooooo
0_l00004ooooo`03o`000?oooooooooo06Kooooo1_l0000/ooooo`005_ooool00ol0003ooooooooo
o`0aooooo`?o000000Coooooo`000?l0003o0000W_ooool4o`000003ooooool0003o000006Wooooo
1Ol0000/ooooo`005_ooool00ol0003oooooooooo`0`ooooo`Wo0000W_ooool6o`0006Wooooo1?l0
000]ooooo`005_ooool00ol0003oooooooooo`0aooooo`So0000W_ooool5o`0006_ooooo0_l0000^
ooooo`005_ooool00ol0003oooooooooo`0aooooo`Oo0000Woooool6o`0006_ooooo00?o0000oooo
ooooool0;?ooool001Kooooo00?o0000ooooooooool0<?ooool9o`0009gooooo2?l0002Iooooo`00
5_ooool00ol0003oooooooooo`0_ooooo`_o0000Voooool:o`0009Sooooo000Fooooo`03o`000?oo
oooooooo03?ooooo0ol0002Rooooo`?o0000W?ooool001Kooooo00?o0000ooooooooool0<oooool3
o`000:?ooooo0_l0002Looooo`005_ooool3o`0003Cooooo00?o0000ooooooooool03?ooool2o`00
013ooooo0_l00005ooooo`03o`000?oooooooooo07[ooooo0_l0002Looooo`005_ooool00ol0003o
ooooooooo`0dooooo`03o`000?oooooooooo00cooooo0ol00003ooooo`03o`000?oooooooooo00[o
oooo0_l00003ooooo`;o0000oooooolKooooo`005_ooool00ol0003oooooooooo`14ooooo`?o0000
00?oooooo`000?l000003?ooool3o`000003ooooool0003o00000?oooooo7?ooool001Kooooo00?o
0000ooooooooool0@_ooool9o`0000[ooooo2?l0003ooooooa_ooooo000Fooooo`03o`000?oooooo
oooo04?ooooo2?l0000;ooooo`Oo0000oooooolKooooo`005_ooool00ol0003oooooooooo`13oooo
o`So00002oooool7o`0006Kooooo0_l00005ooooo`03o`000?oooooooooo0:[ooooo000Fooooo`03
o`000?oooooooooo04;ooooo2ol00007ooooo`_o0000IOooool2o`0000?ooooo0_l0002/ooooo`00
0_ooool2o`0000Cooooo00?o0000ooooooooool00_ooool3o`0000Kooooo00?o0000ooooooooool0
AOooool4o`0000kooooo1?l0001Yooooo`?o000000?oooooo`000?l00000[Oooool00005ooooool0
003oooooooooool000001oooool01Ol0003ooooooooooooooooo000000Gooooo00?o0000oooooooo
ool0AOooool4o`0000oooooo0ol0001Yooooo`Ko0000[Oooool00005ooooool0003oooooooooool0
00002oooool00ol0003oooooooooo`03ooooo`Co0000AOooool2o`00013ooooo0_l0001[ooooo`Go
0000[Oooool00005ooooool0003oooooooooool000002oooool00ol0003oooooooooo`03ooooo`03
o`000?oooooooooo04Kooooo0_l0000Aooooo`03o`000?oooooooooo06Sooooo1ol0002/ooooo`00
00Goooooo`000?ooooooooooo`000007ooooo`Co00001_ooool00ol0003oooooooooo`1Iooooo`03
o`000?oooooooooo06Kooooo2ol0002Zooooo`0000Goooooo`000?ooooooooooo`000007ooooo`03
o`000?oooooooooo00Oooooo00?o0000ooooooooool0a_ooool3o`000:kooooo0002ooooo`;o0000
2?ooool5o`0000Gooooo00?o0000ooooooooool0a_ooool3o`000:kooooo000Fooooo`03o`000?oo
oooooooo0<Oooooo00?o0000ooooooooool0[Oooool001Kooooo00?o0000ooooooooool0aoooool0
0ol0003oooooooooo`2]ooooo`005_ooool00ol0003oooooooooo`37ooooo`03o`000?oooooooooo
0:gooooo000Fooooo`03o`000?oooooooooo0?ooooooN?ooool001Kooooo00?o0000ooooooooool0
oooooomhooooo`005_ooool3o`000?ooooooN?ooool001Kooooo00?o0000ooooooooool0oooooomh
ooooo`005_ooool00ol0003oooooooooo`3oooooogSooooo000Fooooo`03o`000?oooooooooo0?oo
ooooN?ooool001Kooooo00?o0000ooooooooool0oooooomhooooo`005_ooool00ol0003ooooooooo
o`3oooooogSooooo000Fooooo`03o`000?oooooooooo0?ooooooN?ooool001Kooooo00?o0000oooo
ooooool0oooooomhooooo`005_ooool00ol0003oooooooooo`3oooooogSooooo000Fooooo`03o`00
0?oooooooooo0?ooooooN?ooool001Kooooo0ol0003oooooogSooooo000Fooooo`03o`000?oooooo
oooo0?ooooooN?ooool001Kooooo00?o0000ooooooooool0oooooomhooooo`005_ooool00ol0003o
ooooooooo`3oooooogSooooo000Fooooo`03o`000?oooooooooo0?ooooooN?ooool001Kooooo00?o
0000ooooooooool0oooooomhooooo`005_ooool00ol0003oooooooooo`3oooooogSooooo000Foooo
o`03o`000?oooooooooo0?ooooooN?ooool001Kooooo00?o0000ooooooooool0/Oooool2o`0000Co
oooo00?o0000ooooooooool0_Oooool001Kooooo0ol0002booooo`?o000000?oooooo`000?l00000
_oooool001Kooooo00?o0000ooooooooool0/_ooool6o`000;oooooo000Fooooo`03o`000?oooooo
oooo0;?ooooo1?l00030ooooo`005_ooool00ol0003oooooooooo`2booooo`Oo0000__ooool001Ko
oooo00?o0000ooooooooool0/Oooool9o`000;gooooo000Fooooo`03o`000?oooooooooo0;3ooooo
2ol0002looooo`005_ooool00ol0003oooooooooo`2cooooo`?o0000`Oooool001Kooooo00?o0000
ooooooooool0]?ooool2o`000<7ooooo000Fooooo`03o`000?oooooooooo0;Cooooo0_l00031oooo
o`005_ooool00ol0003oooooooooo`3oooooogSooooo000Fooooo`?o0000oooooomhooooo`005_oo
ool00ol0003oooooooooo`3oooooogSooooo000Fooooo`03o`000?oooooooooo0?ooooooN?ooool0
01Kooooo00?o0000ooooooooool0oooooomhooooo`005_ooool00ol0003oooooooooo`3oooooogSo
oooo000Fooooo`03o`000?oooooooooo0?ooooooN?ooool001Kooooo00?o0000ooooooooool0J?oo
ool2o`0000Cooooo00?o0000ooooooooool02Oooool2o`0000Cooooo00?o0000ooooooooool02Ooo
ool2o`0000Gooooo00?o0000ooooooooool0hOooool000gooooo0ol00006ooooo`03o`000?oooooo
oooo06Sooooo0ol000001?oooooo0000o`000?l0000<ooooo`?o000000?oooooo`000?l000003?oo
ool3o`000004ooooool0003o0000o`000>?ooooo000>ooooo`03o`000?oooooooooo00Gooooo00?o
0000ooooooooool0Ioooool9o`0000_ooooo1_l0000<ooooo`Ko0000i?ooool000kooooo00?o0000
ooooooooool01Oooool00ol0003oooooooooo`1Xooooo`So00003?ooool4o`0000kooooo1Ol0003T
ooooo`003_ooool00ol0003oooooooooo`05ooooo`Co0000Ioooool7o`0000cooooo1ol0000;oooo
o`Oo0000hoooool000kooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`1Xooooo`So
00002_ooool9o`0000Wooooo2Ol0003Rooooo`003Oooool2o`0000Oooooo00?o0000ooooooooool0
Ioooool:o`0000Sooooo2ol00007ooooo`_o0000hOooool000kooooo00?o0000ooooooooool01Ooo
ool00ol0003oooooooooo`1Zooooo`?o00003oooool3o`00013ooooo0ol0003Uooooo`005_ooool0
0ol0003oooooooooo`1Zooooo`?o00004?ooool2o`00013ooooo0ol0003Uooooo`005_ooool00ol0
003oooooooooo`1[ooooo`03o`000?oooooooooo00oooooo0_l0000Aooooo`03o`000?oooooooooo
0>Cooooo000Fooooo`03o`000?oooooooooo06_ooooo00?o0000ooooooooool08_ooool00ol0003o
ooooooooo`3Tooooo`005_ooool00ol0003oooooooooo`3oooooogSooooo000Fooooo`03o`000?oo
oooooooo0?ooooooN?ooool001Kooooo0ol0003oooooogSooooo000Fooooo`03o`000?oooooooooo
09oooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`3?ooooo`005_ooool00ol0003o
ooooooooo`2Oooooo`;o00000oooool2o`000=7ooooo000Fooooo`03o`000?oooooooooo0:3ooooo
0_l000001?oooooo0000o`000?l0003Aooooo`005_ooool00ol0003oooooooooo`2Pooooo`Go0000
d_ooool001Kooooo00?o0000ooooooooool0X?ooool6o`000=7ooooo000Fooooo`03o`000?oooooo
oooo09oooooo2?l0003@ooooo`005_ooool00ol0003oooooooooo`2Nooooo`[o0000coooool001Ko
oooo00?o0000ooooooooool0XOooool3o`000=?ooooo000Fooooo`03o`000?oooooooooo0:7ooooo
0ol0003Cooooo`005_ooool3o`000:;ooooo00?o0000ooooooooool0d_ooool001Kooooo00?o0000
ooooooooool0X_ooool00ol0003oooooooooo`3Booooo`005_ooool00ol0003oooooooooo`3ooooo
ogSooooo000Fooooo`03o`000?oooooooooo0?ooooooN?ooool001Kooooo00?o0000ooooooooool0
oooooomhooooo`005_ooool00ol0003oooooooooo`3oooooogSooooo000Fooooo`03o`000?oooooo
oooo0?ooooooN?ooool001Kooooo00?o0000ooooooooool0oooooomhooooo`005_ooool00ol0003o
ooooooooo`3oooooogSooooo000Fooooo`03o`000?oooooooooo0?ooooooN?ooool001Kooooo0ol0
003oooooogSooooo000Fooooo`03o`000?oooooooooo0?ooooooN?ooool001Kooooo00?o0000oooo
ooooool0oooooomhooooo`005_ooool00ol0003oooooooooo`33ooooo`So00002_ooool9o`0000[o
oooo2?l0000:ooooo`Wo00002Oooool9o`0000[ooooo2?l0000:ooooo`Wo0000?Oooool001Kooooo
00?o0000ooooooooool0a?ooool7o`0000_ooooo2?l0000;ooooo`Oo00002oooool8o`0000[ooooo
2?l0000;ooooo`Oo00002oooool8o`0003gooooo000Fooooo`03o`000?oooooooooo0<Cooooo1_l0
000=ooooo`Ko00003?ooool6o`0000cooooo1ol0000<ooooo`Ko00003?ooool6o`0000cooooo1ol0
000nooooo`005_ooool00ol0003oooooooooo`35ooooo`Go00003_ooool5o`0000gooooo1Ol0000=
ooooo`Go00003_ooool5o`0000gooooo1Ol0000=ooooo`Go0000?oooool001Kooooo00?o0000oooo
ooooool0a_ooool3o`0000oooooo1?l0000?ooooo`?o00003oooool3o`0000oooooo1?l0000?oooo
o`?o00003oooool3o`00043ooooo000Fooooo`03o`000?oooooooooo0<Kooooo0_l0000Aooooo`;o
00004?ooool2o`00013ooooo0ol0000@ooooo`;o00004?ooool2o`00013ooooo0ol00010ooooo`00
5_ooool3o`000<Oooooo00?o0000ooooooooool04?ooool00ol0003oooooooooo`0?ooooo`03o`00
0?oooooooooo00oooooo00?o0000ooooooooool04?ooool00ol0003oooooooooo`0?ooooo`03o`00
0?oooooooooo00oooooo00?o0000ooooooooool0?oooool001Kooooo00?o0000ooooooooool0oooo
oomhooooo`005_ooool00ol0003oooooooooo`3oooooogSooooo000Fooooo`03o`000?oooooooooo
0?ooooooN?ooool001Kooooo00?o0000ooooooooool0oooooomhooooo`005_ooool00ol0003ooooo
ooooo`3oooooogSooooo000Fooooo`03o`000?oooooooooo0?ooooooN?ooool00004ooooool0003o
0000o`0000Cooooo00?o0000ooooooooool00_ooool3o`0000Kooooo00?o0000ooooooooool0oooo
oomhooooo`000_ooool00ol0003oooooooooo`07ooooo`05o`000?ooooooooooooooool000001Ooo
ool00ol0003oooooooooo`1iooooo`Wo0000;_ooool9o`000;kooooo0002ooooo`03o`000?oooooo
oooo00_ooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`1jooooo`So0000;oooool8
o`000;kooooo0002ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool00oooool4o`00
07[ooooo1_l0000aooooo`Ko0000_oooool000;ooooo00?o0000ooooooooool01oooool4o`0000Ko
oooo00?o0000ooooooooool0Noooool6o`00037ooooo1_l0002oooooo`0000?oooooo`000?l00000
2Oooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo07cooooo1?l0000cooooo`Co0000
`?ooool000;ooooo00?o0000ooooooooool01oooool5o`0000Gooooo00?o0000ooooooooool0O?oo
ool4o`0003?ooooo1?l00030ooooo`005_ooool00ol0003oooooooooo`1mooooo`;o0000=Oooool2
o`000<7ooooo000Fooooo`03o`000?oooooooooo07kooooo00?o0000ooooooooool0=?ooool00ol0
003oooooooooo`2oooooo`005_ooool00ol0003oooooooooo`3oooooogSooooo000Fooooo`03o`00
0?oooooooooo0?ooooooN?ooool001Kooooo00?o0000ooooooooool0oooooomhooooo`005_ooool3
o`000?ooooooN?ooool001Kooooo00?o0000ooooooooool0oooooomhooooo`005_ooool00ol0003o
ooooooooo`3oooooogSooooo000Fooooo`03o`000?oooooooooo0?ooooooN?ooool001Kooooo00?o
0000ooooooooool0oooooomhooooo`005_ooool00ol0003oooooooooo`3oooooogSooooo000Foooo
o`03o`000?oooooooooo0?ooooooN?ooool001Kooooo00?o0000ooooooooool0oooooomhooooo`00
5_ooool00ol0003oooooooooo`3oooooogSooooo000Fooooo`03o`000?oooooooooo0?ooooooN?oo
ool001Kooooo0ol0003oooooogSooooo000Fooooo`03o`000?oooooooooo0?ooooooN?ooool001Ko
oooo00?o0000ooooooooool0oooooomhooooo`005_ooool00ol0003oooooooooo`3oooooogSooooo
000Fooooo`03o`000?oooooooooo0?ooooooN?ooool001Kooooo00?o0000ooooooooool0oooooomh
ooooo`005_ooool00ol0003oooooooooo`3oooooogSooooo000Fooooo`03o`000?oooooooooo0?oo
ooooN?ooool001Kooooo00?o0000ooooooooool0oooooomhooooo`005_ooool00ol0003ooooooooo
o`3oooooogSooooo000Fooooo`?o0000oooooomhooooo`005_ooool00ol0003oooooooooo`3ooooo
ogSooooo000Fooooo`03o`000?oooooooooo0?ooooooN?ooool001Kooooo00?o0000ooooooooool0
oooooomhooooo`005_ooool00ol0003oooooooooo`3oooooogSooooo000Fooooo`03o`000?oooooo
oooo0?ooooooN?ooool001Kooooo00?o0000ooooooooool0oooooomhooooo`005_ooool00ol0003o
ooooooooo`3oooooogSooooo000Fooooo`03o`000?oooooooooo0?ooooooN?ooool001Kooooo0ol0
003oooooogSooooo000Fooooo`03o`000?oooooooooo0?ooooooN?ooool001Kooooo00?o0000oooo
ooooool0oooooomhooooo`005_ooool00ol0003oooooooooo`3oooooogSooooo000Fooooo`03o`00
0?oooooooooo0?ooooooN?ooool001Kooooo00?o0000ooooooooool0oooooomhooooo`005_ooool0
0ol0003oooooooooo`3oooooogSooooo000Fooooo`03o`000?oooooooooo0?ooooooN?ooool000co
oooo1Ol00005ooooo`03o`000?oooooooooo0?ooooooN?ooool000gooooo00Co0000oooooooooooo
00001Oooool00ol0003oooooooooo`2Nooooo`Wo0000d?ooool000kooooo00?o0000ooooooooool0
1Oooool4o`0009kooooo2?l0003@ooooo`003oooool00ol0003oooooooooo`04ooooo`03o`000?oo
oooooooo09oooooo1ol0003Aooooo`003?ooool01Ol0003ooooooooooooooooo000000Gooooo00?o
0000ooooooooool0X?ooool5o`000=;ooooo000<ooooo`05o`000?ooooooooooooooool000001Ooo
ool00ol0003oooooooooo`2Qooooo`?o0000doooool000gooooo0ol00006ooooo`03o`000?oooooo
oooo0:7ooooo0ol0003Cooooo`005_ooool00ol0003oooooooooo`2Rooooo`03o`000?oooooooooo
0=;ooooo000Fooooo`03o`000?oooooooooo0?ooooooN?ooool001Kooooo00?o0000ooooooooool0
oooooomhooooo`005_ooool00ol0003oooooooooo`3oooooogSooooo000Fooooo`03o`000?oooooo
oooo0?ooooooN?ooool001Kooooo0ol0003oooooogSooooo000Fooooo`03o`000?oooooooooo0?oo
ooooN?ooool001Kooooo00?o0000ooooooooool0oooooomhooooo`005_ooool00ol0003ooooooooo
o`3oooooogSooooo000Fooooo`03o`000?oooooooooo0?ooooooN?ooool001Kooooo00?o0000oooo
ooooool0oooooomhooooo`005_ooool00ol0003oooooooooo`3oooooogSooooo000Fooooo`03o`00
0?oooooooooo0?ooooooN?ooool001Kooooo00?o0000ooooooooool0oooooomhooooo`005_ooool3
o`000?ooooooN?ooool001Kooooo00?o0000ooooooooool0oooooomhooooo`005_ooool00ol0003o
ooooooooo`3oooooogSooooo000Fooooo`03o`000?oooooooooo0?ooooooN?ooool001Kooooo00?o
0000ooooooooool0oooooomhooooo`005_ooool00ol0003oooooooooo`3oooooogSooooo000Foooo
o`03o`000?oooooooooo0?ooooooN?ooool001Kooooo00?o0000ooooooooool0oooooomhooooo`00
5_ooool00ol0003oooooooooo`3oooooogSooooo000Fooooo`03o`000?oooooooooo0?ooooooN?oo
ool001Kooooo0ol0003oooooogSooooo000Fooooo`03o`000?oooooooooo0?ooooooN?ooool001Ko
oooo00?o0000ooooooooool0oooooomhooooo`005_ooool00ol0003oooooooooo`2<ooooo`So0000
hoooool001Kooooo00?o0000ooooooooool0SOooool7o`000>?ooooo000Fooooo`03o`000?oooooo
oooo08gooooo1_l0003Tooooo`005_ooool00ol0003oooooooooo`2>ooooo`Go0000i?ooool001Ko
oooo00?o0000ooooooooool0S_ooool4o`000>Gooooo000Fooooo`03o`000?oooooooooo08oooooo
0ol0003Uooooo`005_ooool00ol0003oooooooooo`2?ooooo`;o0000i_ooool001Kooooo0ol0002@
ooooo`03o`000?oooooooooo0>Cooooo0000\
\>"],
  ImageRangeCache->{{{0, 399}, {246.188, 0}} -> {8.75075, -0.143191, \
0.0545229, 0.0103658}}]
}, Open  ]],

Cell["\<\
La leggibilit\[AGrave] del grafico migliora aggiungendo una \
descrizione degli assi e se i simboli che si riferiscono a una stessa serie \
vengono uniti da una linea (notare che a simboli differenti corrisponde uno \
stile differente usato per tracciare questa linea), in modo da evidenziare \
l'andamento temporale dell'indice di gravit\[AGrave] nei due gruppi:\
\>", \
"Text",
  PageWidth->PaperWidth],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(MultipleListPlot[untreated, treated, PlotJoined \[Rule] True, 
        SymbolShape \[Rule] {enlarge[PlotSymbol[Triangle], 2], 
            enlarge[PlotSymbol[Star], 2.5]}, 
        AxesLabel \[Rule] {"\<Days\>", "\<EAE severity index\>"}];\)\)], \
"Input",
  CellLabel->"In[14]:=",
  PageWidth->PaperWidth],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
%%ImageSize: 400 247.214 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.452381 0.047619 0.0147151 0.25047 [
[.2619 .00222 -6 -9 ]
[.2619 .00222 6 0 ]
[.5 .00222 -6 -9 ]
[.5 .00222 6 0 ]
[.7381 .00222 -6 -9 ]
[.7381 .00222 6 0 ]
[.97619 .00222 -6 -9 ]
[.97619 .00222 6 0 ]
[1.025 .01472 0 -6 ]
[1.025 .01472 28 6 ]
[.01131 .13995 -18 -4.5 ]
[.01131 .13995 0 4.5 ]
[.01131 .26518 -6 -4.5 ]
[.01131 .26518 0 4.5 ]
[.01131 .39042 -18 -4.5 ]
[.01131 .39042 0 4.5 ]
[.01131 .51565 -6 -4.5 ]
[.01131 .51565 0 4.5 ]
[.02381 .64303 -56 0 ]
[.02381 .64303 56 12 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.2619 .01472 m
.2619 .02097 L
s
[(15)] .2619 .00222 0 1 Mshowa
.5 .01472 m
.5 .02097 L
s
[(20)] .5 .00222 0 1 Mshowa
.7381 .01472 m
.7381 .02097 L
s
[(25)] .7381 .00222 0 1 Mshowa
.97619 .01472 m
.97619 .02097 L
s
[(30)] .97619 .00222 0 1 Mshowa
.125 Mabswid
.07143 .01472 m
.07143 .01847 L
s
.11905 .01472 m
.11905 .01847 L
s
.16667 .01472 m
.16667 .01847 L
s
.21429 .01472 m
.21429 .01847 L
s
.30952 .01472 m
.30952 .01847 L
s
.35714 .01472 m
.35714 .01847 L
s
.40476 .01472 m
.40476 .01847 L
s
.45238 .01472 m
.45238 .01847 L
s
.54762 .01472 m
.54762 .01847 L
s
.59524 .01472 m
.59524 .01847 L
s
.64286 .01472 m
.64286 .01847 L
s
.69048 .01472 m
.69048 .01847 L
s
.78571 .01472 m
.78571 .01847 L
s
.83333 .01472 m
.83333 .01847 L
s
.88095 .01472 m
.88095 .01847 L
s
.92857 .01472 m
.92857 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
gsave
1.025 .01472 -61 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Days) show
87.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.02381 .13995 m
.03006 .13995 L
s
[(0.5)] .01131 .13995 1 0 Mshowa
.02381 .26518 m
.03006 .26518 L
s
[(1)] .01131 .26518 1 0 Mshowa
.02381 .39042 m
.03006 .39042 L
s
[(1.5)] .01131 .39042 1 0 Mshowa
.02381 .51565 m
.03006 .51565 L
s
[(2)] .01131 .51565 1 0 Mshowa
.125 Mabswid
.02381 .03976 m
.02756 .03976 L
s
.02381 .06481 m
.02756 .06481 L
s
.02381 .08986 m
.02756 .08986 L
s
.02381 .1149 m
.02756 .1149 L
s
.02381 .165 m
.02756 .165 L
s
.02381 .19004 m
.02756 .19004 L
s
.02381 .21509 m
.02756 .21509 L
s
.02381 .24014 m
.02756 .24014 L
s
.02381 .29023 m
.02756 .29023 L
s
.02381 .31528 m
.02756 .31528 L
s
.02381 .34033 m
.02756 .34033 L
s
.02381 .36537 m
.02756 .36537 L
s
.02381 .41547 m
.02756 .41547 L
s
.02381 .44051 m
.02756 .44051 L
s
.02381 .46556 m
.02756 .46556 L
s
.02381 .49061 m
.02756 .49061 L
s
.02381 .5407 m
.02756 .5407 L
s
.02381 .56575 m
.02756 .56575 L
s
.02381 .5908 m
.02756 .5908 L
s
.02381 .61584 m
.02756 .61584 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
gsave
.02381 .64303 -117 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(EAE) show
87.000 13.000 moveto
(severity) show
141.000 13.000 moveto
(index) show
171.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.001 w
.02381 .01472 m
.07143 .01472 L
.11905 .07483 L
.16667 .10238 L
.21429 .12743 L
.2619 .12743 L
.30952 .26518 L
.35714 .39042 L
.40476 .60332 L
.45238 .51565 L
.5 .39042 L
.54762 .35285 L
.59524 .35285 L
.64286 .35285 L
.69048 .35285 L
.7381 .35285 L
.78571 .35285 L
.83333 .35285 L
.88095 .08986 L
.92857 .01472 L
.97619 .01472 L
s
.0001 w
.02381 .01472 0 5 Mabsadd m
.02381 .01472 -4.33 -2.5 Mabsadd L
.02381 .01472 4.33 -2.5 Mabsadd L
.02381 .01472 0 5 Mabsadd L closepath F
.07143 .01472 0 5 Mabsadd m
.07143 .01472 -4.33 -2.5 Mabsadd L
.07143 .01472 4.33 -2.5 Mabsadd L
.07143 .01472 0 5 Mabsadd L closepath F
.11905 .07483 0 5 Mabsadd m
.11905 .07483 -4.33 -2.5 Mabsadd L
.11905 .07483 4.33 -2.5 Mabsadd L
.11905 .07483 0 5 Mabsadd L closepath F
.16667 .10238 0 5 Mabsadd m
.16667 .10238 -4.33 -2.5 Mabsadd L
.16667 .10238 4.33 -2.5 Mabsadd L
.16667 .10238 0 5 Mabsadd L closepath F
.21429 .12743 0 5 Mabsadd m
.21429 .12743 -4.33 -2.5 Mabsadd L
.21429 .12743 4.33 -2.5 Mabsadd L
.21429 .12743 0 5 Mabsadd L closepath F
.2619 .12743 0 5 Mabsadd m
.2619 .12743 -4.33 -2.5 Mabsadd L
.2619 .12743 4.33 -2.5 Mabsadd L
.2619 .12743 0 5 Mabsadd L closepath F
.30952 .26518 0 5 Mabsadd m
.30952 .26518 -4.33 -2.5 Mabsadd L
.30952 .26518 4.33 -2.5 Mabsadd L
.30952 .26518 0 5 Mabsadd L closepath F
.35714 .39042 0 5 Mabsadd m
.35714 .39042 -4.33 -2.5 Mabsadd L
.35714 .39042 4.33 -2.5 Mabsadd L
.35714 .39042 0 5 Mabsadd L closepath F
.40476 .60332 0 5 Mabsadd m
.40476 .60332 -4.33 -2.5 Mabsadd L
.40476 .60332 4.33 -2.5 Mabsadd L
.40476 .60332 0 5 Mabsadd L closepath F
.45238 .51565 0 5 Mabsadd m
.45238 .51565 -4.33 -2.5 Mabsadd L
.45238 .51565 4.33 -2.5 Mabsadd L
.45238 .51565 0 5 Mabsadd L closepath F
.5 .39042 0 5 Mabsadd m
.5 .39042 -4.33 -2.5 Mabsadd L
.5 .39042 4.33 -2.5 Mabsadd L
.5 .39042 0 5 Mabsadd L closepath F
.54762 .35285 0 5 Mabsadd m
.54762 .35285 -4.33 -2.5 Mabsadd L
.54762 .35285 4.33 -2.5 Mabsadd L
.54762 .35285 0 5 Mabsadd L closepath F
.59524 .35285 0 5 Mabsadd m
.59524 .35285 -4.33 -2.5 Mabsadd L
.59524 .35285 4.33 -2.5 Mabsadd L
.59524 .35285 0 5 Mabsadd L closepath F
.64286 .35285 0 5 Mabsadd m
.64286 .35285 -4.33 -2.5 Mabsadd L
.64286 .35285 4.33 -2.5 Mabsadd L
.64286 .35285 0 5 Mabsadd L closepath F
.69048 .35285 0 5 Mabsadd m
.69048 .35285 -4.33 -2.5 Mabsadd L
.69048 .35285 4.33 -2.5 Mabsadd L
.69048 .35285 0 5 Mabsadd L closepath F
.7381 .35285 0 5 Mabsadd m
.7381 .35285 -4.33 -2.5 Mabsadd L
.7381 .35285 4.33 -2.5 Mabsadd L
.7381 .35285 0 5 Mabsadd L closepath F
.78571 .35285 0 5 Mabsadd m
.78571 .35285 -4.33 -2.5 Mabsadd L
.78571 .35285 4.33 -2.5 Mabsadd L
.78571 .35285 0 5 Mabsadd L closepath F
.83333 .35285 0 5 Mabsadd m
.83333 .35285 -4.33 -2.5 Mabsadd L
.83333 .35285 4.33 -2.5 Mabsadd L
.83333 .35285 0 5 Mabsadd L closepath F
.88095 .08986 0 5 Mabsadd m
.88095 .08986 -4.33 -2.5 Mabsadd L
.88095 .08986 4.33 -2.5 Mabsadd L
.88095 .08986 0 5 Mabsadd L closepath F
.92857 .01472 0 5 Mabsadd m
.92857 .01472 -4.33 -2.5 Mabsadd L
.92857 .01472 4.33 -2.5 Mabsadd L
.92857 .01472 0 5 Mabsadd L closepath F
.97619 .01472 0 5 Mabsadd m
.97619 .01472 -4.33 -2.5 Mabsadd L
.97619 .01472 4.33 -2.5 Mabsadd L
.97619 .01472 0 5 Mabsadd L closepath F
.001 w
[ .5 3 ] 0 Mabsdash
.02381 .01472 m
.07143 .01472 L
.11905 .07483 L
.16667 .10238 L
.21429 .12743 L
.2619 .12743 L
.30952 .26518 L
.35714 .26518 L
.40476 .26518 L
.45238 .30276 L
.5 .22135 L
.54762 .13995 L
.59524 .10238 L
.64286 .06481 L
.69048 .06481 L
.7381 .06481 L
.78571 .06481 L
.83333 .01472 L
.88095 .01472 L
.92857 .01472 L
.97619 .01472 L
s
.0001 w
[ ] 0 setdash
.02381 .01472 0 6.25 Mabsadd m
.02381 .01472 -1.41294 1.94475 Mabsadd L
.02381 .01472 -5.94411 1.93136 Mabsadd L
.02381 .01472 -2.28619 -0.74283 Mabsadd L
.02381 .01472 -3.67366 -5.05636 Mabsadd L
.02381 .01472 0 -2.40384 Mabsadd L
.02381 .01472 3.67366 -5.05636 Mabsadd L
.02381 .01472 2.28619 -0.74283 Mabsadd L
.02381 .01472 5.94411 1.93136 Mabsadd L
.02381 .01472 1.41294 1.94475 Mabsadd L
.02381 .01472 0 6.25 Mabsadd L closepath F
.07143 .01472 0 6.25 Mabsadd m
.07143 .01472 -1.41294 1.94475 Mabsadd L
.07143 .01472 -5.94411 1.93136 Mabsadd L
.07143 .01472 -2.28619 -0.74283 Mabsadd L
.07143 .01472 -3.67366 -5.05636 Mabsadd L
.07143 .01472 0 -2.40384 Mabsadd L
.07143 .01472 3.67366 -5.05636 Mabsadd L
.07143 .01472 2.28619 -0.74283 Mabsadd L
.07143 .01472 5.94411 1.93136 Mabsadd L
.07143 .01472 1.41294 1.94475 Mabsadd L
.07143 .01472 0 6.25 Mabsadd L closepath F
.11905 .07483 0 6.25 Mabsadd m
.11905 .07483 -1.41294 1.94475 Mabsadd L
.11905 .07483 -5.94411 1.93136 Mabsadd L
.11905 .07483 -2.28619 -0.74283 Mabsadd L
.11905 .07483 -3.67366 -5.05636 Mabsadd L
.11905 .07483 0 -2.40384 Mabsadd L
.11905 .07483 3.67366 -5.05636 Mabsadd L
.11905 .07483 2.28619 -0.74283 Mabsadd L
.11905 .07483 5.94411 1.93136 Mabsadd L
.11905 .07483 1.41294 1.94475 Mabsadd L
.11905 .07483 0 6.25 Mabsadd L closepath F
.16667 .10238 0 6.25 Mabsadd m
.16667 .10238 -1.41294 1.94475 Mabsadd L
.16667 .10238 -5.94411 1.93136 Mabsadd L
.16667 .10238 -2.28619 -0.74283 Mabsadd L
.16667 .10238 -3.67366 -5.05636 Mabsadd L
.16667 .10238 0 -2.40384 Mabsadd L
.16667 .10238 3.67366 -5.05636 Mabsadd L
.16667 .10238 2.28619 -0.74283 Mabsadd L
.16667 .10238 5.94411 1.93136 Mabsadd L
.16667 .10238 1.41294 1.94475 Mabsadd L
.16667 .10238 0 6.25 Mabsadd L closepath F
.21429 .12743 0 6.25 Mabsadd m
.21429 .12743 -1.41294 1.94475 Mabsadd L
.21429 .12743 -5.94411 1.93136 Mabsadd L
.21429 .12743 -2.28619 -0.74283 Mabsadd L
.21429 .12743 -3.67366 -5.05636 Mabsadd L
.21429 .12743 0 -2.40384 Mabsadd L
.21429 .12743 3.67366 -5.05636 Mabsadd L
.21429 .12743 2.28619 -0.74283 Mabsadd L
.21429 .12743 5.94411 1.93136 Mabsadd L
.21429 .12743 1.41294 1.94475 Mabsadd L
.21429 .12743 0 6.25 Mabsadd L closepath F
.2619 .12743 0 6.25 Mabsadd m
.2619 .12743 -1.41294 1.94475 Mabsadd L
.2619 .12743 -5.94411 1.93136 Mabsadd L
.2619 .12743 -2.28619 -0.74283 Mabsadd L
.2619 .12743 -3.67366 -5.05636 Mabsadd L
.2619 .12743 0 -2.40384 Mabsadd L
.2619 .12743 3.67366 -5.05636 Mabsadd L
.2619 .12743 2.28619 -0.74283 Mabsadd L
.2619 .12743 5.94411 1.93136 Mabsadd L
.2619 .12743 1.41294 1.94475 Mabsadd L
.2619 .12743 0 6.25 Mabsadd L closepath F
.30952 .26518 0 6.25 Mabsadd m
.30952 .26518 -1.41294 1.94475 Mabsadd L
.30952 .26518 -5.94411 1.93136 Mabsadd L
.30952 .26518 -2.28619 -0.74283 Mabsadd L
.30952 .26518 -3.67366 -5.05636 Mabsadd L
.30952 .26518 0 -2.40384 Mabsadd L
.30952 .26518 3.67366 -5.05636 Mabsadd L
.30952 .26518 2.28619 -0.74283 Mabsadd L
.30952 .26518 5.94411 1.93136 Mabsadd L
.30952 .26518 1.41294 1.94475 Mabsadd L
.30952 .26518 0 6.25 Mabsadd L closepath F
.35714 .26518 0 6.25 Mabsadd m
.35714 .26518 -1.41294 1.94475 Mabsadd L
.35714 .26518 -5.94411 1.93136 Mabsadd L
.35714 .26518 -2.28619 -0.74283 Mabsadd L
.35714 .26518 -3.67366 -5.05636 Mabsadd L
.35714 .26518 0 -2.40384 Mabsadd L
.35714 .26518 3.67366 -5.05636 Mabsadd L
.35714 .26518 2.28619 -0.74283 Mabsadd L
.35714 .26518 5.94411 1.93136 Mabsadd L
.35714 .26518 1.41294 1.94475 Mabsadd L
.35714 .26518 0 6.25 Mabsadd L closepath F
.40476 .26518 0 6.25 Mabsadd m
.40476 .26518 -1.41294 1.94475 Mabsadd L
.40476 .26518 -5.94411 1.93136 Mabsadd L
.40476 .26518 -2.28619 -0.74283 Mabsadd L
.40476 .26518 -3.67366 -5.05636 Mabsadd L
.40476 .26518 0 -2.40384 Mabsadd L
.40476 .26518 3.67366 -5.05636 Mabsadd L
.40476 .26518 2.28619 -0.74283 Mabsadd L
.40476 .26518 5.94411 1.93136 Mabsadd L
.40476 .26518 1.41294 1.94475 Mabsadd L
.40476 .26518 0 6.25 Mabsadd L closepath F
.45238 .30276 0 6.25 Mabsadd m
.45238 .30276 -1.41294 1.94475 Mabsadd L
.45238 .30276 -5.94411 1.93136 Mabsadd L
.45238 .30276 -2.28619 -0.74283 Mabsadd L
.45238 .30276 -3.67366 -5.05636 Mabsadd L
.45238 .30276 0 -2.40384 Mabsadd L
.45238 .30276 3.67366 -5.05636 Mabsadd L
.45238 .30276 2.28619 -0.74283 Mabsadd L
.45238 .30276 5.94411 1.93136 Mabsadd L
.45238 .30276 1.41294 1.94475 Mabsadd L
.45238 .30276 0 6.25 Mabsadd L closepath F
.5 .22135 0 6.25 Mabsadd m
.5 .22135 -1.41294 1.94475 Mabsadd L
.5 .22135 -5.94411 1.93136 Mabsadd L
.5 .22135 -2.28619 -0.74283 Mabsadd L
.5 .22135 -3.67366 -5.05636 Mabsadd L
.5 .22135 0 -2.40384 Mabsadd L
.5 .22135 3.67366 -5.05636 Mabsadd L
.5 .22135 2.28619 -0.74283 Mabsadd L
.5 .22135 5.94411 1.93136 Mabsadd L
.5 .22135 1.41294 1.94475 Mabsadd L
.5 .22135 0 6.25 Mabsadd L closepath F
.54762 .13995 0 6.25 Mabsadd m
.54762 .13995 -1.41294 1.94475 Mabsadd L
.54762 .13995 -5.94411 1.93136 Mabsadd L
.54762 .13995 -2.28619 -0.74283 Mabsadd L
.54762 .13995 -3.67366 -5.05636 Mabsadd L
.54762 .13995 0 -2.40384 Mabsadd L
.54762 .13995 3.67366 -5.05636 Mabsadd L
.54762 .13995 2.28619 -0.74283 Mabsadd L
.54762 .13995 5.94411 1.93136 Mabsadd L
.54762 .13995 1.41294 1.94475 Mabsadd L
.54762 .13995 0 6.25 Mabsadd L closepath F
.59524 .10238 0 6.25 Mabsadd m
.59524 .10238 -1.41294 1.94475 Mabsadd L
.59524 .10238 -5.94411 1.93136 Mabsadd L
.59524 .10238 -2.28619 -0.74283 Mabsadd L
.59524 .10238 -3.67366 -5.05636 Mabsadd L
.59524 .10238 0 -2.40384 Mabsadd L
.59524 .10238 3.67366 -5.05636 Mabsadd L
.59524 .10238 2.28619 -0.74283 Mabsadd L
.59524 .10238 5.94411 1.93136 Mabsadd L
.59524 .10238 1.41294 1.94475 Mabsadd L
.59524 .10238 0 6.25 Mabsadd L closepath F
.64286 .06481 0 6.25 Mabsadd m
.64286 .06481 -1.41294 1.94475 Mabsadd L
.64286 .06481 -5.94411 1.93136 Mabsadd L
.64286 .06481 -2.28619 -0.74283 Mabsadd L
.64286 .06481 -3.67366 -5.05636 Mabsadd L
.64286 .06481 0 -2.40384 Mabsadd L
.64286 .06481 3.67366 -5.05636 Mabsadd L
.64286 .06481 2.28619 -0.74283 Mabsadd L
.64286 .06481 5.94411 1.93136 Mabsadd L
.64286 .06481 1.41294 1.94475 Mabsadd L
.64286 .06481 0 6.25 Mabsadd L closepath F
.69048 .06481 0 6.25 Mabsadd m
.69048 .06481 -1.41294 1.94475 Mabsadd L
.69048 .06481 -5.94411 1.93136 Mabsadd L
.69048 .06481 -2.28619 -0.74283 Mabsadd L
.69048 .06481 -3.67366 -5.05636 Mabsadd L
.69048 .06481 0 -2.40384 Mabsadd L
.69048 .06481 3.67366 -5.05636 Mabsadd L
.69048 .06481 2.28619 -0.74283 Mabsadd L
.69048 .06481 5.94411 1.93136 Mabsadd L
.69048 .06481 1.41294 1.94475 Mabsadd L
.69048 .06481 0 6.25 Mabsadd L closepath F
.7381 .06481 0 6.25 Mabsadd m
.7381 .06481 -1.41294 1.94475 Mabsadd L
.7381 .06481 -5.94411 1.93136 Mabsadd L
.7381 .06481 -2.28619 -0.74283 Mabsadd L
.7381 .06481 -3.67366 -5.05636 Mabsadd L
.7381 .06481 0 -2.40384 Mabsadd L
.7381 .06481 3.67366 -5.05636 Mabsadd L
.7381 .06481 2.28619 -0.74283 Mabsadd L
.7381 .06481 5.94411 1.93136 Mabsadd L
.7381 .06481 1.41294 1.94475 Mabsadd L
.7381 .06481 0 6.25 Mabsadd L closepath F
.78571 .06481 0 6.25 Mabsadd m
.78571 .06481 -1.41294 1.94475 Mabsadd L
.78571 .06481 -5.94411 1.93136 Mabsadd L
.78571 .06481 -2.28619 -0.74283 Mabsadd L
.78571 .06481 -3.67366 -5.05636 Mabsadd L
.78571 .06481 0 -2.40384 Mabsadd L
.78571 .06481 3.67366 -5.05636 Mabsadd L
.78571 .06481 2.28619 -0.74283 Mabsadd L
.78571 .06481 5.94411 1.93136 Mabsadd L
.78571 .06481 1.41294 1.94475 Mabsadd L
.78571 .06481 0 6.25 Mabsadd L closepath F
.83333 .01472 0 6.25 Mabsadd m
.83333 .01472 -1.41294 1.94475 Mabsadd L
.83333 .01472 -5.94411 1.93136 Mabsadd L
.83333 .01472 -2.28619 -0.74283 Mabsadd L
.83333 .01472 -3.67366 -5.05636 Mabsadd L
.83333 .01472 0 -2.40384 Mabsadd L
.83333 .01472 3.67366 -5.05636 Mabsadd L
.83333 .01472 2.28619 -0.74283 Mabsadd L
.83333 .01472 5.94411 1.93136 Mabsadd L
.83333 .01472 1.41294 1.94475 Mabsadd L
.83333 .01472 0 6.25 Mabsadd L closepath F
.88095 .01472 0 6.25 Mabsadd m
.88095 .01472 -1.41294 1.94475 Mabsadd L
.88095 .01472 -5.94411 1.93136 Mabsadd L
.88095 .01472 -2.28619 -0.74283 Mabsadd L
.88095 .01472 -3.67366 -5.05636 Mabsadd L
.88095 .01472 0 -2.40384 Mabsadd L
.88095 .01472 3.67366 -5.05636 Mabsadd L
.88095 .01472 2.28619 -0.74283 Mabsadd L
.88095 .01472 5.94411 1.93136 Mabsadd L
.88095 .01472 1.41294 1.94475 Mabsadd L
.88095 .01472 0 6.25 Mabsadd L closepath F
.92857 .01472 0 6.25 Mabsadd m
.92857 .01472 -1.41294 1.94475 Mabsadd L
.92857 .01472 -5.94411 1.93136 Mabsadd L
.92857 .01472 -2.28619 -0.74283 Mabsadd L
.92857 .01472 -3.67366 -5.05636 Mabsadd L
.92857 .01472 0 -2.40384 Mabsadd L
.92857 .01472 3.67366 -5.05636 Mabsadd L
.92857 .01472 2.28619 -0.74283 Mabsadd L
.92857 .01472 5.94411 1.93136 Mabsadd L
.92857 .01472 1.41294 1.94475 Mabsadd L
.92857 .01472 0 6.25 Mabsadd L closepath F
.97619 .01472 0 6.25 Mabsadd m
.97619 .01472 -1.41294 1.94475 Mabsadd L
.97619 .01472 -5.94411 1.93136 Mabsadd L
.97619 .01472 -2.28619 -0.74283 Mabsadd L
.97619 .01472 -3.67366 -5.05636 Mabsadd L
.97619 .01472 0 -2.40384 Mabsadd L
.97619 .01472 3.67366 -5.05636 Mabsadd L
.97619 .01472 2.28619 -0.74283 Mabsadd L
.97619 .01472 5.94411 1.93136 Mabsadd L
.97619 .01472 1.41294 1.94475 Mabsadd L
.97619 .01472 0 6.25 Mabsadd L closepath F
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[14]:=",
  ImageSize->{400, 247.188},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006@0000mb000`400?l00000o`00003ooooooonA
ooooo`00oooooonAooooo`00oooooonAooooo`00oooooonAooooo`00oooooonAooooo`00oooooonA
ooooo`00oooooonAooooo`00oooooonAooooo`00oooooonAooooo`00oooooonAooooo`00oooooonA
ooooo`00oooooonAooooo`00oooooonAooooo`00OOooool3o`0000?ooooo0ol00011ooooo`Go0000
0oooool2o`00047ooooo1Ol00002ooooo`?o0000@_ooool3o`0000Cooooo0_l0000Yooooo`00O_oo
ool01Ol0003ooooooooooooooooo000000?ooooo00?o0000ooooooooool0?oooool01?l0003ooooo
ooooool00002ooooo`04o`000?ooooooooooo`00047ooooo00Ko0000oooooooooooo0000ooooool0
0003ooooo`03o`000?oooooooooo03kooooo00Go0000ooooooooooooooooo`000002ooooo`04o`00
0?ooooooooooo`0002Sooooo001nooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool0
@?ooool00ol0003oooooooooo`02ooooo`04o`000?ooooooooooo`0004;ooooo00?o0000oooooooo
ool01Oooool00ol0003oooooooooo`12ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000oooo
ooooool09_ooool007kooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`11ooooo`05
o`000?ooooooooooooooool000000_ooool00ol0003oooooooooo`11ooooo`03o`000?oooooooooo
00Cooooo00?o0000ooooooooool0@?ooool2o`0000?ooooo00Co0000oooooooooooo0000:?ooool0
07kooooo00Co0000oooooooooooooooo1?l00011ooooo`05o`000?ooooooooooooooool000000_oo
ool01?l0003oooooooooool00010ooooo`06o`000?ooooooooooooooool0003ooooo1?l00015oooo
o`04o`000?ooooooooooo`0000;ooooo00?o0000ooooooooool09_ooool007gooooo0_l00003oooo
o`03o`000?oooooooooo04;ooooo00Go0000ooooooooooooooooo`000002ooooo`04o`000?oooooo
ooooo`00043ooooo00Oo0000ooooooooooooooooo`000?oooooo000004Cooooo00Go0000oooooooo
ooooooooo`000002ooooo`04o`000?ooooooooooo`0002Sooooo001nooooo`04o`000?oooooooooo
ooooo`Go0000@Oooool3o`0000Cooooo0_l00012ooooo`?o00000_ooool5o`00047ooooo0ol00004
ooooo`;o0000:Oooool003Sooooo00?o0000ooooooooool0oooooomFooooo`00=?ooool2o`0000;o
oooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo0>Oo
oooo00?o0000ooooooooool00oooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo00?o
oooo00?o0000ooooooooool01Oooool2o`0000Gooooo00?o0000ooooooooool01Oooool2o`0000Go
oooo00?o0000ooooooooool06?ooool3o`0000cooooo000dooooo`?o000000Coooooo`000?oooooo
00002?ooool2o`0000?ooooo0_l0003Yooooo`;o00000oooool2o`0000Sooooo0_l00003ooooo`;o
00002?ooool2o`0000?ooooo0_l00008ooooo`;o00000oooool2o`0001_ooooo00?o0000oooooooo
ool02oooool003Gooooo1_l00009ooooo`;o000000Coooooo`000?l0003o0000j_ooool2o`000003
ooooool0003o000000[ooooo0_l000000ooooooo0000o`000009ooooo`?o000000?oooooo`000?l0
00002Oooool3o`000003ooooool0003o000000oooooo1?l00003ooooo`Co00000oooool01?l0003o
ooooooooooooool4o`0000Gooooo000cooooo`Wo00001_ooool9o`000>Wooooo1Ol0000:ooooo`Go
00002?ooool8o`0000Oooooo2?l0000?ooooo`06o`000?ooooooooooo`000?oooooo00000_ooool0
0ol0003oooooooooo`02ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool00_ooool0
033oooooool0000mo`0000[ooooo00Co0000oooooooooooo00000_ooool3o`0000?ooooo00?o0000
ooooool000000oooool3o`0000Gooooo000dooooo`So00001oooool8o`0000[ooooo00?o0000oooo
ooooool03?ooool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo00cooooo00?o0000oooo
ooooool03?ooool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo00cooooo00?o0000oooo
ooooool03?ooool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo00cooooo00?o0000oooo
ooooool03?ooool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo00cooooo00?o0000oooo
ooooool03?ooool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo00Sooooo2Ol00006oooo
o`Wo00001_ooool9o`0000Kooooo2Ol0000>ooooo`06o`000?ooooooooooo`000?oooooo00000_oo
ool01ol0003ooooooooooooooooo0000ooooool000000_ooool00ol0003oooooooooo`06ooooo`00
<oooool:o`0000Gooooo2_l0000fooooo`03o`000?oooooooooo04Sooooo00?o0000ooooooooool0
B?ooool00ol0003oooooooooo`0Fooooo`_o00001?ooool;o`0000Cooooo2ol00004ooooo`_o0000
3Oooool01?l0003oooooooooool00002ooooo`;o00000oooool2o`000003ooooool0003o000000;o
oooo1?l00004ooooo`00=_ooool4o`0000_ooooo1?l0003Zooooo`03o`000?oooooo000000;o0000
3?ooool3o`0000_ooooo1?l0000<ooooo`?o00004Oooool01?l0003oooooooooool0000Fooooo`00
=oooool2o`0000cooooo0ol000000ooooooo0000ooooo`3Zooooo`?o00003?ooool3o`0000_ooooo
1?l0000<ooooo`?o00004?ooool4o`0001Oooooo000gooooo`;o00003Oooool01?l0003ooooooooo
ooooool2o`000>Gooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`0<ooooo`03o`00
0?oooooooooo00Wooooo00Co0000oooooooooooo00003_ooool00ol0003oooooooooo`0Zooooo`00
>?ooool00ol0003oooooooooo`0;ooooo`05o`000?ooooooooooooooool00000i_ooool00ol0003o
ooooooooo`02ooooo`03o`000?oooooooooo00cooooo00?o0000ooooooooool02Oooool01?l0003o
ooooooooool0000>ooooo`03o`000?oooooooooo02[ooooo000hooooo`03o`000?oooooooooo013o
oooo00?o0000ooooooooool0ooooool3ooooo`03o`000?oooooooooo03gooooo000hooooo`;o0000
4_ooool2o`000>3ooooo0_l0000Oooooo`03o`000?oooooooooo03kooooo000hooooo`03o`000?oo
oooooooo01;ooooo00?o0000ooooooooool0ooooool00ol0003oooooooooo`0nooooo`00>?ooool0
0ol0003oooooooooo`0Cooooo`;o0000o_ooool00ol0003oooooooooo`0oooooo`00>?ooool00ol0
003oooooooooo`0Cooooo`;o0000g?ooool00ol0003oooooooooo`0Nooooo`03o`000?oooooooooo
043ooooo000hooooo`03o`000?oooooooooo01Cooooo00?o0000ooooooooool0YOooool2o`0000Co
oooo00?o0000ooooooooool01_ooool2o`0000Cooooo00?o0000ooooooooool01_ooool2o`0000Co
oooo00?o0000ooooooooool01_ooool2o`0000Cooooo00?o0000ooooooooool08?ooool00ol0003o
ooooooooo`10ooooo`00>?ooool00ol0003oooooooooo`0Eooooo`;o0000YOooool3o`000004oooo
ool0003o0000o`0000Sooooo0ol000001?oooooo0000o`000?l00008ooooo`?o000000Coooooo`00
0?l0003o00002?ooool3o`000004ooooool0003o0000o`00027ooooo00?o0000ooooooooool0@Ooo
ool003Sooooo00?o0000ooooooooool05_ooool00ol0003oooooooooo`2Tooooo`Ko00002Oooool6
o`0000Wooooo1_l00009ooooo`Ko00008Oooool00ol0003oooooooooo`11ooooo`00>?ooool00ol0
003oooooooooo`0Fooooo`;o00001Oooool00ol0003oooooooooo`2Mooooo`Go00002_ooool5o`00
00[ooooo1Ol0000:ooooo`Go00008Oooool00ol0003oooooooooo`12ooooo`00>?ooool2o`0001So
oooo0_l00003ooooo`;o0000W_ooool8o`0000;ooooo00?o0000ooooooooool02Ol00002ooooo`03
o`000?oooooooooo00;o000000?oooooo`000?l000001Ol000001?oooooo0000ooooooooool2o`00
00;ooooo1ol0000Oooooo`03o`000?oooooooooo04?ooooo000hooooo`03o`000?oooooooooo01Ko
oooo2Ol0002Looooo`Wo00001_ooool9o`0000Kooooo2Ol00006ooooo`Wo00007_ooool00ol0003o
ooooooooo`13ooooo`00>?ooool00ol0003oooooooooo`0Gooooo`So0000Voooool;o`0000Cooooo
2ol00004ooooo`_o00001?ooool;o`0001cooooo00?o0000ooooooooool0A?ooool003Sooooo00?o
0000ooooooooool05oooool7o`000:3ooooo0ol0000<ooooo`?o00003?ooool3o`0000cooooo0ol0
000Oooooo`03o`000?oooooooooo04Gooooo000hooooo`03o`000?oooooooooo01Oooooo2?l0002K
ooooo`04o`000?ooooooooooooooo`?o00003?ooool3o`0000cooooo0ol0000<ooooo`?o00007ooo
ool00ol0003oooooooooo`15ooooo`00>?ooool00ol0003oooooooooo`0Fooooo`[o0000VOooool0
0ol0003oooooooooo`03ooooo`03o`000?oooooooooo00cooooo00?o0000ooooooooool03?ooool0
0ol0003oooooooooo`0<ooooo`03o`000?oooooooooo01gooooo00?o0000ooooooooool0A_ooool0
03Sooooo00?o0000ooooooooool06Oooool3o`0000?ooooo0_l0002Fooooo`03o`000?oooooooooo
00Gooooo00?o0000ooooooooool03?ooool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo
00cooooo00?o0000ooooooooool05oooool9o`0004Kooooo000hooooo`03o`000?oooooooooo01Wo
oooo0ol00005ooooo`;o0000Toooool00ol0003oooooooooo`1>ooooo`So0000A_ooool003Sooooo
0_l0000Kooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool00_l00004ooooo`03o`00
0?oooooooooo07kooooo0_l00004ooooo`03o`000?oooooooooo057ooooo1ol00017ooooo`00>?oo
ool00ol0003oooooooooo`0Jooooo`03o`000?oooooooooo00Oooooo1Ol000001?oooooo0000o`00
0?l00020ooooo`?o000000?oooooo`000?l000000_l0001Cooooo`Go0000B?ooool003Sooooo00?o
0000ooooooooool09Oooool9o`00083ooooo1_l0001Dooooo`Go0000B?ooool003Sooooo00?o0000
ooooooooool09_ooool8o`00083ooooo1Ol0001Fooooo`?o0000BOooool003Sooooo00?o0000oooo
ooooool09_ooool7o`00083ooooo1ol0001Eooooo`?o0000BOooool003Sooooo00?o0000oooooooo
ool09_ooool8o`0007kooooo2Ol0001Dooooo`;o0000B_ooool003Sooooo00?o0000ooooooooool0
9Oooool:o`0007cooooo2ol0001Cooooo`03o`000?oooooooooo04Wooooo000hooooo`03o`000?oo
oooooooo02Sooooo0ol00004ooooo`?o00000oooool00ol0003oooooooooo`03ooooo`03o`000?oo
oooooooo00Kooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`1Nooooo`;o00000_oo
ool3o`0005Oooooo00?o0000ooooooooool0BOooool003Sooooo0_l0000Yooooo`?o00001oooool2
o`000003ooooool0003o000000?ooooo0_l00008ooooo`;o00000oooool2o`0006Cooooo0ol0001G
ooooo`03o`000?oooooooooo04Wooooo000hooooo`03o`000?oooooooooo02Wooooo00?o0000oooo
ooooool01oooool5o`000004ooooool0003o0000o`0000Wooooo0_l000001?oooooo0000o`000?l0
001Nooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool0EOooool00ol0003ooooooooo
o`1:ooooo`00>?ooool00ol0003oooooooooo`0Yooooo`03o`000?oooooooooo00Sooooo2Ol00006
ooooo`Wo0000GOooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo05Gooooo00?o0000
ooooooooool0B_ooool003Sooooo00?o0000ooooooooool0=OoooolGo`0005;ooooo00?o0000oooo
ooooool00oooool00ol0003oooooo`00001Qooooo`03o`000?oooooooooo04[ooooo000hooooo`03
o`000?oooooooooo03Gooooo2?l00007ooooo`So0000D_ooool2o`0000?ooooo0_l000000ooooooo
0000ooooo`1Pooooo`03o`000?oooooooooo04[ooooo000Tooooo`;o00001?ooool00ol0003ooooo
ooooo`02ooooo`?o00001_ooool00ol0003oooooooooo`0cooooo`_o00001?ooool;o`0005;ooooo
0_l000001?oooooo0000o`000?l0001Sooooo`03o`000?oooooooooo04[ooooo000Sooooo`04o`00
0?ooooooooooo`0000Oooooo00Go0000ooooooooooooooooo`000005ooooo`03o`000?oooooooooo
03Oooooo0ol0000<ooooo`?o0000E_ooool6o`0006?ooooo00?o0000ooooooooool0B_ooool002?o
oooo00Co0000oooooooooooo00002oooool00ol0003oooooooooo`03ooooo`;o0000>?ooool3o`00
00cooooo0ol0001Fooooo`Go0000Hoooool00ol0003oooooooooo`1;ooooo`008oooool01?l0003o
ooooooooool0000;ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool0>?ooool00ol0
003oooooooooo`0<ooooo`03o`000?oooooo000005Cooooo2?l0001Qooooo`03o`000?oooooooooo
04_ooooo000Sooooo`04o`000?ooooooooooo`0000Oooooo1?l00006ooooo`03o`000?oooooooooo
03Sooooo00?o0000ooooooooool03?ooool00ol0003oooooo`00001Booooo`_o0000H?ooool00ol0
003oooooooooo`1;ooooo`008oooool01?l0003oooooooooool00007ooooo`03o`000?oooooooooo
00Oooooo00?o0000ooooooooool0>?ooool00ol0003oooooooooo`0<ooooo`04o`000?oooooo0000
o`0005Gooooo0ol0001Tooooo`03o`000?oooooooooo04_ooooo000Tooooo`;o00002?ooool5o`00
00Gooooo00?o0000ooooooooool0B_ooool00ol0003oooooooooo`1Booooo`Co0000I?ooool00ol0
003oooooooooo`1;ooooo`00>?ooool00ol0003oooooooooo`1:ooooo`03o`000?oooooooooo05Co
oooo00?o0000ooooooooool0H_ooool00ol0003oooooooooo`1<ooooo`00>?ooool00ol0003ooooo
ooooo`1:ooooo`;o0000EOooool00ol0003oooooooooo`1Rooooo`03o`000?oooooooooo04cooooo
000hooooo`03o`000?oooooooooo04_ooooo00?o0000ooooooooool0Coooool01Ol0003ooooooooo
oooooooo000006Cooooo00?o0000ooooooooool0C?ooool003Sooooo0_l0001<ooooo`03o`000?oo
oooooooo0;Sooooo00?o0000ooooooooool0C?ooool003Sooooo00?o0000ooooooooool0Boooool2
o`000;Wooooo00?o0000ooooooooool0C?ooool003Sooooo00?o0000ooooooooool0C?ooool00ol0
003oooooooooo`1<ooooo`;o0000JOooool00ol0003oooooooooo`1<ooooo`00>?ooool00ol0003o
ooooooooo`1<ooooo`03o`000?oooooooooo0;Kooooo00?o0000ooooooooool0COooool003Sooooo
00?o0000ooooooooool0C?ooool2o`000;Oooooo00?o0000ooooooooool0COooool003Sooooo00?o
0000ooooooooool0COooool00ol0003oooooooooo`1:ooooo`03o`000?oooooooooo06Sooooo00?o
0000ooooooooool0COooool003Sooooo00?o0000ooooooooool0COooool00ol0003oooooooooo`2e
ooooo`03o`000?oooooooooo04gooooo000hooooo`03o`000?oooooooooo04gooooo00?o0000oooo
ooooool0]Oooool00ol0003oooooooooo`1=ooooo`00>?ooool2o`0004oooooo00?o0000oooooooo
ool0Aoooool00ol0003oooooooooo`1Yooooo`03o`000?oooooooooo04kooooo000hooooo`03o`00
0?oooooooooo04kooooo00?o0000ooooooooool0/oooool00ol0003oooooooooo`1>ooooo`00>?oo
ool00ol0003oooooooooo`1>ooooo`03o`000?oooooooooo0;?ooooo00?o0000ooooooooool0C_oo
ool003Sooooo00?o0000ooooooooool0Coooool00ol0003oooooooooo`14ooooo`03o`000?oooooo
oooo06_ooooo00?o0000ooooooooool0C_ooool003Sooooo00?o0000ooooooooool0Coooool00ol0
003oooooooooo`2booooo`03o`000?oooooooooo04kooooo000hooooo`03o`000?oooooooooo04oo
oooo00?o0000ooooooooool0/_ooool00ol0003oooooooooo`1>ooooo`00>?ooool00ol0003ooooo
ooooo`1@ooooo`03o`000?oooooooooo03cooooo00?o0000ooooooooool00oooool00ol0003ooooo
ooooo`1[ooooo`03o`000?oooooooooo04oooooo000hooooo`03o`000?oooooooooo053ooooo00?o
0000ooooooooool0??ooool2o`0000?ooooo0_l0001]ooooo`03o`000?oooooooooo04oooooo000h
ooooo`;o0000DOooool00ol0003oooooooooo`0mooooo`;o000000Coooooo`000?l0003o0000KOoo
ool00ol0003oooooooooo`1?ooooo`00>?ooool00ol0003oooooooooo`1Aooooo`03o`000?oooooo
oooo03cooooo1Ol0001^ooooo`03o`000?oooooooooo04oooooo000hooooo`03o`000?oooooooooo
057ooooo0_l0000looooo`Oo0000KOooool00ol0003oooooooooo`1?ooooo`00>?ooool00ol0003o
ooooooooo`1Aooooo`03o`000?oooooooooo03[ooooo2Ol0001[ooooo`03o`000?oooooooooo053o
oooo000hooooo`03o`000?oooooooooo05;ooooo00?o0000ooooooooool0>?ooool;o`0006[ooooo
00?o0000ooooooooool0D?ooool003Sooooo00?o0000ooooooooool0D_ooool2o`0003gooooo0ol0
001^ooooo`03o`000?oooooooooo053ooooo000hooooo`03o`000?oooooooooo05;ooooo00?o0000
ooooooooool0??ooool3o`0006kooooo00?o0000ooooooooool0D?ooool003Sooooo00?o0000oooo
ooooool0Doooool00ol0003oooooooooo`0iooooo`04o`000?ooooooooooo`0006oooooo00?o0000
ooooooooool0D?ooool003Sooooo0_l0001Dooooo`;o0000>_ooool01?l0003oooooooooool0001^
ooooo`03o`000?oooooooooo057ooooo000hooooo`03o`000?oooooooooo05?ooooo0_l0002/oooo
o`03o`000?oooooooooo057ooooo000hooooo`03o`000?oooooooooo05Cooooo00?o0000oooooooo
ool0=oooool00ol0003oooooooooo`1`ooooo`03o`000?oooooooooo057ooooo000hooooo`03o`00
0?oooooooooo05Cooooo0_l0000gooooo`03o`000?oooooooooo077ooooo00?o0000ooooooooool0
DOooool003Sooooo00?o0000ooooooooool0Doooool3o`0000?ooooo00?o0000ooooooooool01_oo
ool2o`0000Cooooo00?o0000ooooooooool01_ooool2o`0000Cooooo00?o0000ooooooooool0Qooo
ool00ol0003oooooooooo`1Aooooo`00;oooool3o`0000Kooooo00?o0000ooooooooool0Doooool3
o`000004ooooool0003o0000o`0000Sooooo0ol000001?oooooo0000o`000?l00008ooooo`?o0000
00Coooooo`000?l0003o00005?ooool00ol0003oooooooooo`1booooo`03o`000?oooooooooo057o
oooo000`ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool0D_ooool9o`0000Sooooo
1_l00009ooooo`Ko00005?ooool00ol0003oooooooooo`1aooooo`03o`000?oooooooooo05;ooooo
000`ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool0Doooool8o`0000Sooooo1Ol0
000:ooooo`Go0000ROooool00ol0003oooooooooo`1Booooo`00<?ooool00ol0003oooooooooo`05
ooooo`;o0000E?ooool7o`0000;ooooo0_l00002ooooo`03o`000?oooooo000000Ko000000?ooooo
o`000?l000000_ooool00ol0003oooooooooo`07o`0001;ooooo00?o0000ooooooooool0Loooool0
0ol0003oooooooooo`1Booooo`00<?ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo
05;ooooo2Ol00006ooooo`Wo00001_ooool9o`00017ooooo00?o0000ooooooooool0Loooool00ol0
003oooooooooo`1Booooo`00;oooool2o`0000Oooooo00?o0000ooooooooool0DOooool;o`0000Co
oooo2ol00004ooooo`_o0000Q_ooool00ol0003oooooooooo`1Booooo`00<?ooool00ol0003ooooo
ooooo`05ooooo`03o`000?oooooooooo05Gooooo0ol0000<ooooo`?o00003?ooool3o`0000;ooooo
00?o0000ooooooooool03Oooool00ol0003oooooooooo`1dooooo`03o`000?oooooooooo05?ooooo
000hooooo`03o`000?oooooooooo05Gooooo0ol0000<ooooo`?o00003?ooool3o`0000Cooooo00?o
0000ooooooooool02oooool00ol0003oooooooooo`1dooooo`03o`000?oooooooooo05?ooooo000h
ooooo`03o`000?oooooooooo05Kooooo00?o0000ooooool000003?ooool00ol0003oooooooooo`0<
ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool0POooool00ol0003oooooooooo`1C
ooooo`00>?ooool00ol0003oooooooooo`1Fooooo`03o`000?oooooo000000cooooo00?o0000oooo
ooooool03?ooool00ol0003oooooooooo`0?ooooo`03o`000?oooooooooo07Kooooo00?o0000oooo
ooooool0Doooool003Sooooo00?o0000ooooooooool0FOooool00ol0003oooooooooo`0Qooooo`03
o`000?oooooooooo00Kooooo00?o0000ooooooooool0M_ooool00ol0003oooooooooo`1Cooooo`00
>?ooool2o`0005[ooooo00?o0000ooooooooool09?ooool2o`0000Cooooo00?o0000ooooooooool0
M_ooool00ol0003oooooooooo`1Cooooo`00>?ooool00ol0003oooooooooo`1Iooooo`03o`000?oo
oooooooo02Cooooo0ol000001?oooooo0000o`000?l0001gooooo`03o`000?oooooooooo05Cooooo
000hooooo`03o`000?oooooooooo05[ooooo00?o0000ooooooooool09?ooool6o`0007Oooooo00?o
0000ooooooooool0E?ooool003Sooooo00?o0000ooooooooool0F_ooool00ol0003oooooooooo`0T
ooooo`Go0000N?ooool00ol0003oooooooooo`1Dooooo`00>?ooool00ol0003oooooooooo`1Joooo
o`03o`000?oooooooooo02?ooooo1ol0001gooooo`03o`000?oooooooooo05Cooooo000hooooo`03
o`000?oooooooooo05_ooooo00?o0000ooooooooool08Oooool9o`0007Kooooo00?o0000oooooooo
ool0E?ooool003Sooooo00?o0000ooooooooool0Foooool00ol0003oooooooooo`0Pooooo`_o0000
M?ooool00ol0003oooooooooo`1Eooooo`00>?ooool00ol0003oooooooooo`1Looooo`03o`000?oo
oooooooo02?ooooo0ol0001hooooo`03o`000?oooooooooo05Gooooo000hooooo`;o0000GOooool0
0ol0003oooooooooo`0Sooooo`?o0000N?ooool00ol0003oooooooooo`1Eooooo`00>?ooool00ol0
003oooooooooo`1Looooo`03o`000?oooooooooo02Cooooo00?o0000ooooooooool0Moooool00ol0
003oooooooooo`1Eooooo`00>?ooool00ol0003oooooooooo`1Mooooo`03o`000?oooooooooo02?o
oooo00?o0000ooooooooool0Moooool00ol0003oooooooooo`1Eooooo`00>?ooool00ol0003ooooo
ooooo`1Mooooo`03o`000?oooooooooo09gooooo00?o0000ooooooooool0EOooool003Sooooo00?o
0000ooooooooool0G_ooool00ol0003oooooooooo`2Kooooo`03o`000?oooooooooo05Kooooo000h
ooooo`03o`000?oooooooooo05kooooo00?o0000ooooooooool0Voooool00ol0003oooooooooo`1F
ooooo`00>?ooool00ol0003oooooooooo`1Nooooo`03o`000?oooooooooo09_ooooo00?o0000oooo
ooooool0E_ooool003Sooooo0_l0001Pooooo`03o`000?oooooooooo09[ooooo00?o0000oooooooo
ool0E_ooool003Sooooo00?o0000ooooooooool0Goooool00ol0003oooooooooo`2Jooooo`03o`00
0?oooooooooo05Kooooo000hooooo`03o`000?oooooooooo05oooooo00?o0000ooooooooool0VOoo
ool00ol0003oooooooooo`1Gooooo`00>?ooool00ol0003oooooooooo`1Pooooo`03o`000?oooooo
oooo03[ooooo2Ol00006ooooo`Wo00001_ooool9o`0000Kooooo2Ol00006ooooo`Wo00001_ooool9
o`0000Kooooo2Ol0001Eooooo`00>?ooool00ol0003oooooooooo`1Pooooo`03o`000?oooooooooo
03_oooooH_l0001Eooooo`00>?ooool00ol0003oooooooooo`1Qooooo`03o`000?oooooooooo03[o
oooo1ol00008ooooo`Oo00002?ooool7o`0000Sooooo1ol00008ooooo`Oo00002?ooool7o`0000So
oooo1ol0001Fooooo`00>?ooool00ol0003oooooooooo`1Qooooo`03o`000?oooooooooo03[ooooo
1_l0000:ooooo`Go00002_ooool5o`0000[ooooo1Ol0000:ooooo`Go00002_ooool5o`0000[ooooo
1Ol0001Gooooo`00>?ooool00ol0003oooooooooo`1Qooooo`03o`000?oooooooooo03Wooooo00?o
0000ooooooooool00ol0000<ooooo`?o00003?ooool3o`0000cooooo0ol0000<ooooo`?o00003?oo
ool3o`0000cooooo0ol0001Hooooo`00>?ooool2o`0006?ooooo00?o0000ooooooooool0=_ooool2
o`0000?ooooo0ol0000<ooooo`?o00003?ooool3o`0000cooooo0ol0000<ooooo`?o00003?ooool3
o`0000cooooo0ol0001Hooooo`00>?ooool00ol0003oooooooooo`1Rooooo`03o`000?oooooooooo
03Gooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo
00cooooo00?o0000ooooooooool03?ooool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo
00cooooo00?o0000ooooooooool03?ooool00ol0003oooooooooo`1Gooooo`00>?ooool00ol0003o
ooooooooo`1Sooooo`03o`000?oooooooooo03?ooooo00?o0000ooooooooool0^Oooool003Sooooo
00?o0000ooooooooool0Hoooool00ol0003oooooooooo`0booooo`03o`000?oooooooooo0;[ooooo
000hooooo`03o`000?oooooooooo06?ooooo00?o0000ooooooooool0<?ooool2o`000;gooooo000h
ooooo`03o`000?oooooooooo06Cooooo00?o0000ooooooooool0;_ooool00ol0003oooooooooo`2m
ooooo`008oooool3o`0000Cooooo00?o0000ooooooooool00_ooool3o`0000Kooooo00?o0000oooo
ooooool0I?ooool00ol0003oooooooooo`0]ooooo`03o`000?oooooooooo0;kooooo000Tooooo`03
o`000?oooooooooo00Oooooo00Go0000ooooooooooooooooo`000005ooooo`03o`000?oooooooooo
067ooooo2Ol0000Tooooo`Wo0000__ooool002Cooooo00?o0000ooooooooool02oooool00ol0003o
ooooooooo`03ooooo`;o0000Hoooool8o`0002Gooooo2?l0002nooooo`009?ooool00ol0003ooooo
ooooo`0;ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool0H_ooool7o`0002Kooooo
1ol0002oooooo`009?ooool00ol0003oooooooooo`07ooooo`Co00001_ooool00ol0003ooooooooo
o`1Sooooo`Go0000:?ooool5o`000<3ooooo000Sooooo`;o00002Oooool00ol0003oooooooooo`07
ooooo`03o`000?oooooooooo06Cooooo0ol0000Zooooo`?o0000`Oooool002Cooooo00?o0000oooo
ooooool01oooool5o`0000Gooooo00?o0000ooooooooool0I?ooool3o`0002[ooooo0ol00031oooo
o`00>?ooool00ol0003oooooooooo`1Uooooo`;o0000:Oooool00ol0003oooooo`000032ooooo`00
>?ooool00ol0003oooooooooo`1Vooooo`03o`000?oooooooooo02Oooooo00?o0000ooooooooool0
`_ooool003Sooooo00?o0000ooooooooool0I_ooool00ol0003oooooooooo`0Wooooo`03o`000?oo
oooooooo0<;ooooo000hooooo`;o0000J?ooool00ol0003oooooooooo`0Uooooo`03o`000?oooooo
oooo0<?ooooo000hooooo`03o`000?oooooooooo06Oooooo00?o0000ooooooooool09Oooool00ol0
003oooooooooo`33ooooo`00>?ooool00ol0003oooooooooo`1Wooooo`03o`000?oooooooooo02Co
oooo00?o0000ooooooooool0a?ooool003Sooooo00?o0000ooooooooool0Ioooool00ol0003ooooo
ooooo`0Tooooo`03o`000?oooooooooo0<Cooooo000hooooo`03o`000?oooooooooo06Sooooo00?o
0000ooooooooool08oooool00ol0003oooooooooo`34ooooo`00>?ooool00ol0003oooooooooo`1X
ooooo`03o`000?oooooooooo02;ooooo00?o0000ooooooooool0aOooool003Sooooo00?o0000oooo
ooooool0J?ooool00ol0003oooooooooo`0Rooooo`03o`000?oooooooooo0<Gooooo000hooooo`03
o`000?oooooooooo06Sooooo00?o0000ooooooooool08_ooool00ol0003oooooooooo`35ooooo`00
>?ooool2o`0006Wooooo00?o0000ooooooooool08Oooool00ol0003oooooooooo`36ooooo`00>?oo
ool00ol0003oooooooooo`1Yooooo`03o`000?oooooooooo023ooooo00?o0000ooooooooool0a_oo
ool003Sooooo00?o0000ooooooooool0JOooool00ol0003oooooooooo`0Oooooo`03o`000?oooooo
oooo0<Oooooo000hooooo`03o`000?oooooooooo06Wooooo00?o0000ooooooooool07oooool00ol0
003oooooooooo`37ooooo`00>?ooool00ol0003oooooooooo`1Yooooo`03o`000?oooooooooo01oo
oooo00?o0000ooooooooool0aoooool003Sooooo00?o0000ooooooooool0J_ooool00ol0003ooooo
ooooo`0Mooooo`03o`000?oooooooooo0<Sooooo000hooooo`03o`000?oooooooooo06[ooooo00?o
0000ooooooooool07Oooool00ol0003oooooooooo`38ooooo`00>?ooool00ol0003oooooooooo`1Z
ooooo`03o`000?oooooooooo01gooooo00?o0000ooooooooool0b?ooool003Sooooo0_l0001[oooo
o`03o`000?oooooooooo01cooooo00?o0000ooooooooool0bOooool003Sooooo00?o0000oooooooo
ool0J_ooool00ol0003oooooooooo`0Looooo`03o`000?oooooooooo0<Wooooo000hooooo`03o`00
0?oooooooooo06_ooooo00?o0000ooooooooool06_ooool00ol0003oooooooooo`3:ooooo`00>?oo
ool00ol0003oooooooooo`1[ooooo`03o`000?oooooooooo01[ooooo00?o0000ooooooooool0b_oo
ool003Sooooo00?o0000ooooooooool0Joooool00ol0003oooooooooo`0Jooooo`03o`000?oooooo
oooo0<[ooooo000hooooo`03o`000?oooooooooo06_ooooo00?o0000ooooooooool06Oooool00ol0
003oooooooooo`3;ooooo`00>?ooool00ol0003oooooooooo`1/ooooo`03o`000?oooooooooo01So
oooo00?o0000ooooooooool0boooool003Sooooo00?o0000ooooooooool0K?ooool00ol0003ooooo
ooooo`0Hooooo`03o`000?oooooooooo0<_ooooo000hooooo`;o0000KOooool00ol0003ooooooooo
o`0Gooooo`03o`000?oooooooooo0<cooooo000hooooo`03o`000?oooooooooo06cooooo00?o0000
ooooooooool05oooool00ol0003oooooooooo`3<ooooo`00>?ooool00ol0003oooooooooo`1]oooo
o`03o`000?oooooooooo01Gooooo00?o0000ooooooooool0cOooool003Sooooo00?o0000oooooooo
ool0KOooool00ol0003oooooooooo`0Eooooo`03o`000?oooooooooo0<gooooo000hooooo`03o`00
0?oooooooooo06gooooo00?o0000ooooooooool05Oooool00ol0003oooooooooo`3=ooooo`00;_oo
ool5o`0000Gooooo00?o0000ooooooooool0KOooool00ol0003oooooooooo`0Dooooo`03o`000?oo
oooooooo0<kooooo000_ooooo`04o`000?ooooooooooo`0000Gooooo00?o0000ooooooooool0KOoo
ool00ol0003oooooooooo`0?ooooo`Wo0000cOooool0033ooooo00?o0000ooooooooool01Oooool0
0ol0003oooooooooo`1^ooooo`03o`000?oooooooooo00oooooo2?l0003=ooooo`00<Oooool00ol0
003oooooooooo`04ooooo`;o0000Koooool00ol0003oooooooooo`0?ooooo`Oo0000c_ooool002ko
oooo00Go0000ooooooooooooooooo`000005ooooo`03o`000?oooooooooo06kooooo00?o0000oooo
ooooool04?ooool5o`000<oooooo000^ooooo`05o`000?ooooooooooooooool000001Oooool00ol0
003oooooooooo`1^ooooo`03o`000?oooooooooo013ooooo1Ol0003?ooooo`00;oooool3o`0000Ko
oooo00?o0000ooooooooool0Koooool00ol0003oooooooooo`0@ooooo`?o0000d?ooool003Sooooo
00?o0000ooooooooool0Koooool00ol0003oooooooooo`0?ooooo`Co0000d?ooool003Sooooo00?o
0000ooooooooool0Koooool00ol0003oooooooooo`0>ooooo`04o`000?ooooooooooo`000=7ooooo
000hooooo`03o`000?oooooooooo06oooooo00?o0000ooooooooool03_ooool00ol0003ooooooooo
o`3Booooo`00>?ooool00ol0003oooooooooo`1_ooooo`03o`000?oooooooooo00gooooo00?o0000
ooooooooool0doooool003Sooooo0_l0001aooooo`03o`000?oooooooooo00cooooo00?o0000oooo
ooooool0doooool003Sooooo00?o0000ooooooooool0L?ooool00ol0003oooooooooo`0;ooooo`03
o`000?oooooooooo0=Cooooo000hooooo`03o`000?oooooooooo073ooooo00?o0000ooooooooool0
2oooool00ol0003oooooooooo`3Dooooo`00>?ooool00ol0003oooooooooo`1`ooooo`03o`000?oo
oooooooo00[ooooo00?o0000ooooooooool0eOooool003Sooooo00?o0000ooooooooool0LOooool0
0ol0003oooooooooo`09ooooo`03o`000?oooooooooo0=Gooooo000hooooo`03o`000?oooooooooo
077ooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`3Fooooo`00>?ooool00ol0003o
ooooooooo`1aooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool0eoooool003Sooooo
0_l0001booooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool0eoooool003Sooooo00?o
0000ooooooooool0LOooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo0=Sooooo000h
ooooo`03o`000?oooooooooo07;ooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`3H
ooooo`00>?ooool00ol0003oooooooooo`1booooo`03o`000?oooooooooo00Cooooo00?o0000oooo
ooooool0fOooool003Sooooo00?o0000ooooooooool0L_ooool00ol0003oooooooooo`04ooooo`03
o`000?oooooooooo0=Wooooo000hooooo`03o`000?oooooooooo07;ooooo00?o0000ooooooooool0
0oooool00ol0003oooooooooo`3Jooooo`00>?ooool00ol0003oooooooooo`1cooooo`03o`000?oo
oooooooo00;ooooo00?o0000ooooooooool0f_ooool003Sooooo00?o0000ooooooooool0Loooool0
1Ol0003ooooooooooooooooo00000=gooooo000hooooo`;o0000M?ooool01?l0003oooooooooool0
003Nooooo`00>?ooool00ol0003oooooooooo`1cooooo`04o`000?ooooooooooo`000=kooooo000h
ooooo`03o`000?oooooooooo07?ooooo00?o0000ooooool00000goooool003Sooooo00?o0000oooo
ooooool0L?ooool9o`000=cooooo000hooooo`03o`000?oooooooooo077ooooo2?l0003Looooo`00
>?ooool00ol0003oooooooooo`1aooooo`Oo0000gOooool003Sooooo00?o0000ooooooooool0L_oo
ool5o`000=kooooo000hooooo`03o`000?oooooooooo07?ooooo0ol0003Oooooo`00>?ooool2o`00
07Cooooo0ol0003Oooooo`00>?ooool00ol0003oooooooooo`1dooooo`03o`000?oooooooooo0=ko
oooo003ooooooi7ooooo003ooooooi7ooooo003ooooooi7ooooo003ooooooi7ooooo003ooooooi7o
oooo003ooooooi7ooooo003ooooooi7ooooo003ooooooi7ooooo003ooooooi7ooooo0014ooooo`?o
0000oooooom:ooooo`00AOooool00ol0003oooooooooo`3oooooodWooooo0002ooooo`Go000000Co
ooooo`000?l0003ooooo2?l00007ooooo`Co00000oooool3o`0000Cooooo00?o0000ooooooooool0
0_ooool3o`0000;ooooo0ol00003ooooo`Go00000oooool2o`0000Cooooo00?o0000ooooooooool0
1oooool5o`000005ooooool0003o0000o`000?ooool00_l000000ooooooo0000o`000002o`0000;o
oooo0ol00002ooooo`;o000000?oooooo`000?l00000oooooolTooooo`000oooool01_l0003ooooo
ooooool0003oooooo`0000?ooooo00Co0000oooooooooooo00000_ooool00ol0003oooooooooo`09
ooooo`03o`000?oooooo000000Oooooo00Go0000ooooooooooooooooo`000006ooooo`03o`000?oo
oooooooo00Cooooo00?o0000ooooooooool00_ooool01?l0003oooooooooool00003ooooo`03o`00
0?oooooooooo00Wooooo00?o0000ooooooooool00_ooool01_l0003oooooooooool0003oooooo`00
00;ooooo00Co0000oooooooooooo00001_ooool00ol0003oooooo`00003oooooobGooooo0003oooo
o`03o`000?oooooooooo00;ooooo1Ol00002ooooo`03o`000?oooooooooo00Wooooo0ol00002oooo
o`Go00000_ooool00ol0003oooooo`000002ooooo`Go00000_ooool00ol0003oooooooooo`04oooo
o`03o`000?oooooooooo00;ooooo00?o0000ooooooooool00oooool00ol0003oooooo`00000:oooo
o`03o`000?oooooooooo00;ooooo00Ko0000oooooooooooo0000ooooool00002ooooo`03o`000?oo
oooooooo00Go00000oooool00ol0003oooooooooo`3oooooobCooooo0003ooooo`?o00000oooool0
0ol0003oooooo`000003ooooo`?o00002?ooool00ol0003oooooooooo`03ooooo`05o`000?oooooo
ooooooooool000000_ooool00ol0003oooooo`000002ooooo`05o`000?ooooooooooooooool00000
0_ooool2o`0000Gooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`03ooooo`03o`00
0?oooooo000000[ooooo00?o0000ooooooooool00_ooool01_l0003oooooooooool0003oooooo`00
00;ooooo00Co0000oooooooooooo00000oooool01_l0003oooooooooool0003oooooo`000?oooooo
9Oooool000?ooooo00?o0000ooooooooool00oooool00ol0003oooooo`000003ooooo`03o`000?oo
oooooooo00Wooooo1?l00002ooooo`?o00000_ooool2o`000003ooooool0003o000000;ooooo0ol0
0002ooooo`;o000000Coooooo`000?l0003ooooo0ol00003ooooo`Co00000_ooool2o`000003oooo
ool0003o000000Oooooo0ol00003ooooo`Co00000oooool3o`0000?ooooo0ol00002ooooo`;o0000
00?oooooo`000?l00000oooooolTooooo`000oooool01?l0003oooooooooool00003ooooo`03o`00
0?oooooooooo00;ooooo00Co0000oooooooooooo0000;?ooool00ol0003oooooooooo`0Mooooo`03
o`000?oooooooooo0?oooooo;oooool000;ooooo1Ol00002ooooo`;o00000oooool5o`0002Oooooo
00?o0000ooooooooool00_ooool00ol0003oooooooooo`0@ooooo`03o`000?oooooooooo00Wooooo
0_l0003ooooooc7ooooo003ooooooi7ooooo003ooooooi7ooooo003ooooooi7ooooo003ooooooi7o
oooo003ooooooi7ooooo003ooooooi7ooooo003ooooooi7ooooo003ooooooi7ooooo003ooooooi7o
oooo003ooooooi7ooooo003ooooooi7ooooo003ooooooi7ooooo003ooooooi7ooooo0000\
\>"],
  ImageRangeCache->{{{0, 399}, {246.188, 0}} -> {6.2621, -0.313671, \
0.0667467, 0.0126898}}]
}, Open  ]],

Cell["\<\
La descrizione degli assi pu\[OGrave] essere immessa anche senza \
influire drammaticamente sulle dimensioni del grafico prodotto:\
\>", "Text",
  PageWidth->PaperWidth],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(MultipleListPlot[untreated, treated, PlotJoined \[Rule] True, 
        SymbolShape \[Rule] {enlarge[PlotSymbol[Triangle], 2], 
            enlarge[PlotSymbol[Star], 2.5]}, 
        Frame \[Rule] {True, True, False, False}, 
        FrameLabel \[Rule] {"\<Days\>", "\<EAE severity index\>"}];\)\)], \
"Input",
  CellLabel->"In[15]:=",
  PageWidth->PaperWidth],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
%%ImageSize: 400 247.214 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.452381 0.047619 0.0147151 0.25047 [
[.02381 -0.0125 -6 -9 ]
[.02381 -0.0125 6 0 ]
[.2619 -0.0125 -6 -9 ]
[.2619 -0.0125 6 0 ]
[.5 -0.0125 -6 -9 ]
[.5 -0.0125 6 0 ]
[.7381 -0.0125 -6 -9 ]
[.7381 -0.0125 6 0 ]
[.97619 -0.0125 -6 -9 ]
[.97619 -0.0125 6 0 ]
[ 0 0 -0.125 0 ]
[.5 -0.0125 -14 -21 ]
[.5 -0.0125 14 -9 ]
[-0.0125 .01472 -6 -4.5 ]
[-0.0125 .01472 0 4.5 ]
[-0.0125 .13995 -18 -4.5 ]
[-0.0125 .13995 0 4.5 ]
[-0.0125 .26518 -6 -4.5 ]
[-0.0125 .26518 0 4.5 ]
[-0.0125 .39042 -18 -4.5 ]
[-0.0125 .39042 0 4.5 ]
[-0.0125 .51565 -6 -4.5 ]
[-0.0125 .51565 0 4.5 ]
[ 0 0 -0.125 0 ]
[-0.01875 .30902 -30 -56 ]
[-0.01875 .30902 -18 56 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 0 m
.02381 .00625 L
s
[(10)] .02381 -0.0125 0 1 Mshowa
.2619 0 m
.2619 .00625 L
s
[(15)] .2619 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(20)] .5 -0.0125 0 1 Mshowa
.7381 0 m
.7381 .00625 L
s
[(25)] .7381 -0.0125 0 1 Mshowa
.97619 0 m
.97619 .00625 L
s
[(30)] .97619 -0.0125 0 1 Mshowa
.125 Mabswid
.07143 0 m
.07143 .00375 L
s
.11905 0 m
.11905 .00375 L
s
.16667 0 m
.16667 .00375 L
s
.21429 0 m
.21429 .00375 L
s
.30952 0 m
.30952 .00375 L
s
.35714 0 m
.35714 .00375 L
s
.40476 0 m
.40476 .00375 L
s
.45238 0 m
.45238 .00375 L
s
.54762 0 m
.54762 .00375 L
s
.59524 0 m
.59524 .00375 L
s
.64286 0 m
.64286 .00375 L
s
.69048 0 m
.69048 .00375 L
s
.78571 0 m
.78571 .00375 L
s
.83333 0 m
.83333 .00375 L
s
.88095 0 m
.88095 .00375 L
s
.92857 0 m
.92857 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
gsave
.5 -0.0125 -75 -25 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Days) show
87.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 .01472 m
.00625 .01472 L
s
[(0)] -0.0125 .01472 1 0 Mshowa
0 .13995 m
.00625 .13995 L
s
[(0.5)] -0.0125 .13995 1 0 Mshowa
0 .26518 m
.00625 .26518 L
s
[(1)] -0.0125 .26518 1 0 Mshowa
0 .39042 m
.00625 .39042 L
s
[(1.5)] -0.0125 .39042 1 0 Mshowa
0 .51565 m
.00625 .51565 L
s
[(2)] -0.0125 .51565 1 0 Mshowa
.125 Mabswid
0 .03976 m
.00375 .03976 L
s
0 .06481 m
.00375 .06481 L
s
0 .08986 m
.00375 .08986 L
s
0 .1149 m
.00375 .1149 L
s
0 .165 m
.00375 .165 L
s
0 .19004 m
.00375 .19004 L
s
0 .21509 m
.00375 .21509 L
s
0 .24014 m
.00375 .24014 L
s
0 .29023 m
.00375 .29023 L
s
0 .31528 m
.00375 .31528 L
s
0 .34033 m
.00375 .34033 L
s
0 .36537 m
.00375 .36537 L
s
0 .41547 m
.00375 .41547 L
s
0 .44051 m
.00375 .44051 L
s
0 .46556 m
.00375 .46556 L
s
0 .49061 m
.00375 .49061 L
s
0 .5407 m
.00375 .5407 L
s
0 .56575 m
.00375 .56575 L
s
0 .5908 m
.00375 .5908 L
s
0 .61584 m
.00375 .61584 L
s
.25 Mabswid
0 0 m
0 .61803 L
s
gsave
-0.01875 .30902 -141 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
117 10 translate
90 rotate
-117 -10 translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(EAE) show
87.000 13.000 moveto
(severity) show
141.000 13.000 moveto
(index) show
171.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.001 w
.02381 .01472 m
.07143 .01472 L
.11905 .07483 L
.16667 .10238 L
.21429 .12743 L
.2619 .12743 L
.30952 .26518 L
.35714 .39042 L
.40476 .60332 L
.45238 .51565 L
.5 .39042 L
.54762 .35285 L
.59524 .35285 L
.64286 .35285 L
.69048 .35285 L
.7381 .35285 L
.78571 .35285 L
.83333 .35285 L
.88095 .08986 L
.92857 .01472 L
.97619 .01472 L
s
.0001 w
.02381 .01472 0 5 Mabsadd m
.02381 .01472 -4.33 -2.5 Mabsadd L
.02381 .01472 4.33 -2.5 Mabsadd L
.02381 .01472 0 5 Mabsadd L closepath F
.07143 .01472 0 5 Mabsadd m
.07143 .01472 -4.33 -2.5 Mabsadd L
.07143 .01472 4.33 -2.5 Mabsadd L
.07143 .01472 0 5 Mabsadd L closepath F
.11905 .07483 0 5 Mabsadd m
.11905 .07483 -4.33 -2.5 Mabsadd L
.11905 .07483 4.33 -2.5 Mabsadd L
.11905 .07483 0 5 Mabsadd L closepath F
.16667 .10238 0 5 Mabsadd m
.16667 .10238 -4.33 -2.5 Mabsadd L
.16667 .10238 4.33 -2.5 Mabsadd L
.16667 .10238 0 5 Mabsadd L closepath F
.21429 .12743 0 5 Mabsadd m
.21429 .12743 -4.33 -2.5 Mabsadd L
.21429 .12743 4.33 -2.5 Mabsadd L
.21429 .12743 0 5 Mabsadd L closepath F
.2619 .12743 0 5 Mabsadd m
.2619 .12743 -4.33 -2.5 Mabsadd L
.2619 .12743 4.33 -2.5 Mabsadd L
.2619 .12743 0 5 Mabsadd L closepath F
.30952 .26518 0 5 Mabsadd m
.30952 .26518 -4.33 -2.5 Mabsadd L
.30952 .26518 4.33 -2.5 Mabsadd L
.30952 .26518 0 5 Mabsadd L closepath F
.35714 .39042 0 5 Mabsadd m
.35714 .39042 -4.33 -2.5 Mabsadd L
.35714 .39042 4.33 -2.5 Mabsadd L
.35714 .39042 0 5 Mabsadd L closepath F
.40476 .60332 0 5 Mabsadd m
.40476 .60332 -4.33 -2.5 Mabsadd L
.40476 .60332 4.33 -2.5 Mabsadd L
.40476 .60332 0 5 Mabsadd L closepath F
.45238 .51565 0 5 Mabsadd m
.45238 .51565 -4.33 -2.5 Mabsadd L
.45238 .51565 4.33 -2.5 Mabsadd L
.45238 .51565 0 5 Mabsadd L closepath F
.5 .39042 0 5 Mabsadd m
.5 .39042 -4.33 -2.5 Mabsadd L
.5 .39042 4.33 -2.5 Mabsadd L
.5 .39042 0 5 Mabsadd L closepath F
.54762 .35285 0 5 Mabsadd m
.54762 .35285 -4.33 -2.5 Mabsadd L
.54762 .35285 4.33 -2.5 Mabsadd L
.54762 .35285 0 5 Mabsadd L closepath F
.59524 .35285 0 5 Mabsadd m
.59524 .35285 -4.33 -2.5 Mabsadd L
.59524 .35285 4.33 -2.5 Mabsadd L
.59524 .35285 0 5 Mabsadd L closepath F
.64286 .35285 0 5 Mabsadd m
.64286 .35285 -4.33 -2.5 Mabsadd L
.64286 .35285 4.33 -2.5 Mabsadd L
.64286 .35285 0 5 Mabsadd L closepath F
.69048 .35285 0 5 Mabsadd m
.69048 .35285 -4.33 -2.5 Mabsadd L
.69048 .35285 4.33 -2.5 Mabsadd L
.69048 .35285 0 5 Mabsadd L closepath F
.7381 .35285 0 5 Mabsadd m
.7381 .35285 -4.33 -2.5 Mabsadd L
.7381 .35285 4.33 -2.5 Mabsadd L
.7381 .35285 0 5 Mabsadd L closepath F
.78571 .35285 0 5 Mabsadd m
.78571 .35285 -4.33 -2.5 Mabsadd L
.78571 .35285 4.33 -2.5 Mabsadd L
.78571 .35285 0 5 Mabsadd L closepath F
.83333 .35285 0 5 Mabsadd m
.83333 .35285 -4.33 -2.5 Mabsadd L
.83333 .35285 4.33 -2.5 Mabsadd L
.83333 .35285 0 5 Mabsadd L closepath F
.88095 .08986 0 5 Mabsadd m
.88095 .08986 -4.33 -2.5 Mabsadd L
.88095 .08986 4.33 -2.5 Mabsadd L
.88095 .08986 0 5 Mabsadd L closepath F
.92857 .01472 0 5 Mabsadd m
.92857 .01472 -4.33 -2.5 Mabsadd L
.92857 .01472 4.33 -2.5 Mabsadd L
.92857 .01472 0 5 Mabsadd L closepath F
.97619 .01472 0 5 Mabsadd m
.97619 .01472 -4.33 -2.5 Mabsadd L
.97619 .01472 4.33 -2.5 Mabsadd L
.97619 .01472 0 5 Mabsadd L closepath F
.001 w
[ .5 3 ] 0 Mabsdash
.02381 .01472 m
.07143 .01472 L
.11905 .07483 L
.16667 .10238 L
.21429 .12743 L
.2619 .12743 L
.30952 .26518 L
.35714 .26518 L
.40476 .26518 L
.45238 .30276 L
.5 .22135 L
.54762 .13995 L
.59524 .10238 L
.64286 .06481 L
.69048 .06481 L
.7381 .06481 L
.78571 .06481 L
.83333 .01472 L
.88095 .01472 L
.92857 .01472 L
.97619 .01472 L
s
.0001 w
[ ] 0 setdash
.02381 .01472 0 6.25 Mabsadd m
.02381 .01472 -1.41294 1.94475 Mabsadd L
.02381 .01472 -5.94411 1.93136 Mabsadd L
.02381 .01472 -2.28619 -0.74283 Mabsadd L
.02381 .01472 -3.67366 -5.05636 Mabsadd L
.02381 .01472 0 -2.40384 Mabsadd L
.02381 .01472 3.67366 -5.05636 Mabsadd L
.02381 .01472 2.28619 -0.74283 Mabsadd L
.02381 .01472 5.94411 1.93136 Mabsadd L
.02381 .01472 1.41294 1.94475 Mabsadd L
.02381 .01472 0 6.25 Mabsadd L closepath F
.07143 .01472 0 6.25 Mabsadd m
.07143 .01472 -1.41294 1.94475 Mabsadd L
.07143 .01472 -5.94411 1.93136 Mabsadd L
.07143 .01472 -2.28619 -0.74283 Mabsadd L
.07143 .01472 -3.67366 -5.05636 Mabsadd L
.07143 .01472 0 -2.40384 Mabsadd L
.07143 .01472 3.67366 -5.05636 Mabsadd L
.07143 .01472 2.28619 -0.74283 Mabsadd L
.07143 .01472 5.94411 1.93136 Mabsadd L
.07143 .01472 1.41294 1.94475 Mabsadd L
.07143 .01472 0 6.25 Mabsadd L closepath F
.11905 .07483 0 6.25 Mabsadd m
.11905 .07483 -1.41294 1.94475 Mabsadd L
.11905 .07483 -5.94411 1.93136 Mabsadd L
.11905 .07483 -2.28619 -0.74283 Mabsadd L
.11905 .07483 -3.67366 -5.05636 Mabsadd L
.11905 .07483 0 -2.40384 Mabsadd L
.11905 .07483 3.67366 -5.05636 Mabsadd L
.11905 .07483 2.28619 -0.74283 Mabsadd L
.11905 .07483 5.94411 1.93136 Mabsadd L
.11905 .07483 1.41294 1.94475 Mabsadd L
.11905 .07483 0 6.25 Mabsadd L closepath F
.16667 .10238 0 6.25 Mabsadd m
.16667 .10238 -1.41294 1.94475 Mabsadd L
.16667 .10238 -5.94411 1.93136 Mabsadd L
.16667 .10238 -2.28619 -0.74283 Mabsadd L
.16667 .10238 -3.67366 -5.05636 Mabsadd L
.16667 .10238 0 -2.40384 Mabsadd L
.16667 .10238 3.67366 -5.05636 Mabsadd L
.16667 .10238 2.28619 -0.74283 Mabsadd L
.16667 .10238 5.94411 1.93136 Mabsadd L
.16667 .10238 1.41294 1.94475 Mabsadd L
.16667 .10238 0 6.25 Mabsadd L closepath F
.21429 .12743 0 6.25 Mabsadd m
.21429 .12743 -1.41294 1.94475 Mabsadd L
.21429 .12743 -5.94411 1.93136 Mabsadd L
.21429 .12743 -2.28619 -0.74283 Mabsadd L
.21429 .12743 -3.67366 -5.05636 Mabsadd L
.21429 .12743 0 -2.40384 Mabsadd L
.21429 .12743 3.67366 -5.05636 Mabsadd L
.21429 .12743 2.28619 -0.74283 Mabsadd L
.21429 .12743 5.94411 1.93136 Mabsadd L
.21429 .12743 1.41294 1.94475 Mabsadd L
.21429 .12743 0 6.25 Mabsadd L closepath F
.2619 .12743 0 6.25 Mabsadd m
.2619 .12743 -1.41294 1.94475 Mabsadd L
.2619 .12743 -5.94411 1.93136 Mabsadd L
.2619 .12743 -2.28619 -0.74283 Mabsadd L
.2619 .12743 -3.67366 -5.05636 Mabsadd L
.2619 .12743 0 -2.40384 Mabsadd L
.2619 .12743 3.67366 -5.05636 Mabsadd L
.2619 .12743 2.28619 -0.74283 Mabsadd L
.2619 .12743 5.94411 1.93136 Mabsadd L
.2619 .12743 1.41294 1.94475 Mabsadd L
.2619 .12743 0 6.25 Mabsadd L closepath F
.30952 .26518 0 6.25 Mabsadd m
.30952 .26518 -1.41294 1.94475 Mabsadd L
.30952 .26518 -5.94411 1.93136 Mabsadd L
.30952 .26518 -2.28619 -0.74283 Mabsadd L
.30952 .26518 -3.67366 -5.05636 Mabsadd L
.30952 .26518 0 -2.40384 Mabsadd L
.30952 .26518 3.67366 -5.05636 Mabsadd L
.30952 .26518 2.28619 -0.74283 Mabsadd L
.30952 .26518 5.94411 1.93136 Mabsadd L
.30952 .26518 1.41294 1.94475 Mabsadd L
.30952 .26518 0 6.25 Mabsadd L closepath F
.35714 .26518 0 6.25 Mabsadd m
.35714 .26518 -1.41294 1.94475 Mabsadd L
.35714 .26518 -5.94411 1.93136 Mabsadd L
.35714 .26518 -2.28619 -0.74283 Mabsadd L
.35714 .26518 -3.67366 -5.05636 Mabsadd L
.35714 .26518 0 -2.40384 Mabsadd L
.35714 .26518 3.67366 -5.05636 Mabsadd L
.35714 .26518 2.28619 -0.74283 Mabsadd L
.35714 .26518 5.94411 1.93136 Mabsadd L
.35714 .26518 1.41294 1.94475 Mabsadd L
.35714 .26518 0 6.25 Mabsadd L closepath F
.40476 .26518 0 6.25 Mabsadd m
.40476 .26518 -1.41294 1.94475 Mabsadd L
.40476 .26518 -5.94411 1.93136 Mabsadd L
.40476 .26518 -2.28619 -0.74283 Mabsadd L
.40476 .26518 -3.67366 -5.05636 Mabsadd L
.40476 .26518 0 -2.40384 Mabsadd L
.40476 .26518 3.67366 -5.05636 Mabsadd L
.40476 .26518 2.28619 -0.74283 Mabsadd L
.40476 .26518 5.94411 1.93136 Mabsadd L
.40476 .26518 1.41294 1.94475 Mabsadd L
.40476 .26518 0 6.25 Mabsadd L closepath F
.45238 .30276 0 6.25 Mabsadd m
.45238 .30276 -1.41294 1.94475 Mabsadd L
.45238 .30276 -5.94411 1.93136 Mabsadd L
.45238 .30276 -2.28619 -0.74283 Mabsadd L
.45238 .30276 -3.67366 -5.05636 Mabsadd L
.45238 .30276 0 -2.40384 Mabsadd L
.45238 .30276 3.67366 -5.05636 Mabsadd L
.45238 .30276 2.28619 -0.74283 Mabsadd L
.45238 .30276 5.94411 1.93136 Mabsadd L
.45238 .30276 1.41294 1.94475 Mabsadd L
.45238 .30276 0 6.25 Mabsadd L closepath F
.5 .22135 0 6.25 Mabsadd m
.5 .22135 -1.41294 1.94475 Mabsadd L
.5 .22135 -5.94411 1.93136 Mabsadd L
.5 .22135 -2.28619 -0.74283 Mabsadd L
.5 .22135 -3.67366 -5.05636 Mabsadd L
.5 .22135 0 -2.40384 Mabsadd L
.5 .22135 3.67366 -5.05636 Mabsadd L
.5 .22135 2.28619 -0.74283 Mabsadd L
.5 .22135 5.94411 1.93136 Mabsadd L
.5 .22135 1.41294 1.94475 Mabsadd L
.5 .22135 0 6.25 Mabsadd L closepath F
.54762 .13995 0 6.25 Mabsadd m
.54762 .13995 -1.41294 1.94475 Mabsadd L
.54762 .13995 -5.94411 1.93136 Mabsadd L
.54762 .13995 -2.28619 -0.74283 Mabsadd L
.54762 .13995 -3.67366 -5.05636 Mabsadd L
.54762 .13995 0 -2.40384 Mabsadd L
.54762 .13995 3.67366 -5.05636 Mabsadd L
.54762 .13995 2.28619 -0.74283 Mabsadd L
.54762 .13995 5.94411 1.93136 Mabsadd L
.54762 .13995 1.41294 1.94475 Mabsadd L
.54762 .13995 0 6.25 Mabsadd L closepath F
.59524 .10238 0 6.25 Mabsadd m
.59524 .10238 -1.41294 1.94475 Mabsadd L
.59524 .10238 -5.94411 1.93136 Mabsadd L
.59524 .10238 -2.28619 -0.74283 Mabsadd L
.59524 .10238 -3.67366 -5.05636 Mabsadd L
.59524 .10238 0 -2.40384 Mabsadd L
.59524 .10238 3.67366 -5.05636 Mabsadd L
.59524 .10238 2.28619 -0.74283 Mabsadd L
.59524 .10238 5.94411 1.93136 Mabsadd L
.59524 .10238 1.41294 1.94475 Mabsadd L
.59524 .10238 0 6.25 Mabsadd L closepath F
.64286 .06481 0 6.25 Mabsadd m
.64286 .06481 -1.41294 1.94475 Mabsadd L
.64286 .06481 -5.94411 1.93136 Mabsadd L
.64286 .06481 -2.28619 -0.74283 Mabsadd L
.64286 .06481 -3.67366 -5.05636 Mabsadd L
.64286 .06481 0 -2.40384 Mabsadd L
.64286 .06481 3.67366 -5.05636 Mabsadd L
.64286 .06481 2.28619 -0.74283 Mabsadd L
.64286 .06481 5.94411 1.93136 Mabsadd L
.64286 .06481 1.41294 1.94475 Mabsadd L
.64286 .06481 0 6.25 Mabsadd L closepath F
.69048 .06481 0 6.25 Mabsadd m
.69048 .06481 -1.41294 1.94475 Mabsadd L
.69048 .06481 -5.94411 1.93136 Mabsadd L
.69048 .06481 -2.28619 -0.74283 Mabsadd L
.69048 .06481 -3.67366 -5.05636 Mabsadd L
.69048 .06481 0 -2.40384 Mabsadd L
.69048 .06481 3.67366 -5.05636 Mabsadd L
.69048 .06481 2.28619 -0.74283 Mabsadd L
.69048 .06481 5.94411 1.93136 Mabsadd L
.69048 .06481 1.41294 1.94475 Mabsadd L
.69048 .06481 0 6.25 Mabsadd L closepath F
.7381 .06481 0 6.25 Mabsadd m
.7381 .06481 -1.41294 1.94475 Mabsadd L
.7381 .06481 -5.94411 1.93136 Mabsadd L
.7381 .06481 -2.28619 -0.74283 Mabsadd L
.7381 .06481 -3.67366 -5.05636 Mabsadd L
.7381 .06481 0 -2.40384 Mabsadd L
.7381 .06481 3.67366 -5.05636 Mabsadd L
.7381 .06481 2.28619 -0.74283 Mabsadd L
.7381 .06481 5.94411 1.93136 Mabsadd L
.7381 .06481 1.41294 1.94475 Mabsadd L
.7381 .06481 0 6.25 Mabsadd L closepath F
.78571 .06481 0 6.25 Mabsadd m
.78571 .06481 -1.41294 1.94475 Mabsadd L
.78571 .06481 -5.94411 1.93136 Mabsadd L
.78571 .06481 -2.28619 -0.74283 Mabsadd L
.78571 .06481 -3.67366 -5.05636 Mabsadd L
.78571 .06481 0 -2.40384 Mabsadd L
.78571 .06481 3.67366 -5.05636 Mabsadd L
.78571 .06481 2.28619 -0.74283 Mabsadd L
.78571 .06481 5.94411 1.93136 Mabsadd L
.78571 .06481 1.41294 1.94475 Mabsadd L
.78571 .06481 0 6.25 Mabsadd L closepath F
.83333 .01472 0 6.25 Mabsadd m
.83333 .01472 -1.41294 1.94475 Mabsadd L
.83333 .01472 -5.94411 1.93136 Mabsadd L
.83333 .01472 -2.28619 -0.74283 Mabsadd L
.83333 .01472 -3.67366 -5.05636 Mabsadd L
.83333 .01472 0 -2.40384 Mabsadd L
.83333 .01472 3.67366 -5.05636 Mabsadd L
.83333 .01472 2.28619 -0.74283 Mabsadd L
.83333 .01472 5.94411 1.93136 Mabsadd L
.83333 .01472 1.41294 1.94475 Mabsadd L
.83333 .01472 0 6.25 Mabsadd L closepath F
.88095 .01472 0 6.25 Mabsadd m
.88095 .01472 -1.41294 1.94475 Mabsadd L
.88095 .01472 -5.94411 1.93136 Mabsadd L
.88095 .01472 -2.28619 -0.74283 Mabsadd L
.88095 .01472 -3.67366 -5.05636 Mabsadd L
.88095 .01472 0 -2.40384 Mabsadd L
.88095 .01472 3.67366 -5.05636 Mabsadd L
.88095 .01472 2.28619 -0.74283 Mabsadd L
.88095 .01472 5.94411 1.93136 Mabsadd L
.88095 .01472 1.41294 1.94475 Mabsadd L
.88095 .01472 0 6.25 Mabsadd L closepath F
.92857 .01472 0 6.25 Mabsadd m
.92857 .01472 -1.41294 1.94475 Mabsadd L
.92857 .01472 -5.94411 1.93136 Mabsadd L
.92857 .01472 -2.28619 -0.74283 Mabsadd L
.92857 .01472 -3.67366 -5.05636 Mabsadd L
.92857 .01472 0 -2.40384 Mabsadd L
.92857 .01472 3.67366 -5.05636 Mabsadd L
.92857 .01472 2.28619 -0.74283 Mabsadd L
.92857 .01472 5.94411 1.93136 Mabsadd L
.92857 .01472 1.41294 1.94475 Mabsadd L
.92857 .01472 0 6.25 Mabsadd L closepath F
.97619 .01472 0 6.25 Mabsadd m
.97619 .01472 -1.41294 1.94475 Mabsadd L
.97619 .01472 -5.94411 1.93136 Mabsadd L
.97619 .01472 -2.28619 -0.74283 Mabsadd L
.97619 .01472 -3.67366 -5.05636 Mabsadd L
.97619 .01472 0 -2.40384 Mabsadd L
.97619 .01472 3.67366 -5.05636 Mabsadd L
.97619 .01472 2.28619 -0.74283 Mabsadd L
.97619 .01472 5.94411 1.93136 Mabsadd L
.97619 .01472 1.41294 1.94475 Mabsadd L
.97619 .01472 0 6.25 Mabsadd L closepath F
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[15]:=",
  ImageSize->{400, 247.188},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006@0000mb000`400?l00000o`00003ooooooonA
ooooo`00oooooonAooooo`00fOooool3o`000;Cooooo003Jooooo`03o`000?oooooooooo0;?ooooo
003=ooooo`Co00000oooool4o`0000?ooooo00Co0000oooooooooooooooo1?l0002]ooooo`00c_oo
ool01_l0003oooooooooool0003oooooo`0000;ooooo00?o0000ooooooooool00_ooool00ol0003o
ooooooooo`05ooooo`03o`000?oooooooooo0:[ooooo003>ooooo`04o`000?ooooooooooo`0000;o
oooo0ol00003ooooo`03o`000?oooooo000000?ooooo0ol0002]ooooo`00c_ooool01_l0003ooooo
ooooool0003oooooo`0000;ooooo00Oo0000ooooooooooooooooo`000?oooooo000000;ooooo00?o
0000ooooooooool0[_ooool00<kooooo00Co0000oooooooooooo00000_ooool2o`0000?ooooo0_l0
00000ooooooo0000o`000002ooooo`Co0000[?ooool00<kooooo00Co0000oooooooooooo0000__oo
ool00<gooooo1?l0002oooooo`00oooooonAooooo`00oooooonAooooo`00:_ooool3o`0000Cooooo
0_l0001<ooooo`?o00000oooool3o`0004_ooooo1Ol00003ooooo`;o0000Boooool5o`0000;ooooo
0ol0001<ooooo`?o00001?ooool2o`0000Wooooo000[ooooo`03o`000?oooooooooo00;ooooo00Co
0000oooooooooooo0000C?ooool01Ol0003ooooooooooooooooo000000?ooooo00?o0000oooooooo
ool0BOooool01?l0003oooooooooool00002ooooo`04o`000?ooooooooooo`0004_ooooo00Ko0000
oooooooooooo0000ooooool00003ooooo`03o`000?oooooooooo04Sooooo00Go0000oooooooooooo
ooooo`000002ooooo`04o`000?ooooooooooo`0000Sooooo000[ooooo`03o`000?oooooooooo00;o
oooo00Co0000oooooooooooo0000C?ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo
04[ooooo00?o0000ooooooooool00_ooool01?l0003oooooooooool0001<ooooo`03o`000?oooooo
oooo00Gooooo00?o0000ooooooooool0C?ooool01?l0003oooooooooool00002ooooo`03o`000?oo
oooooooo00Kooooo000[ooooo`03o`000?oooooooooo00;ooooo00Co0000oooooooooooo0000C?oo
ool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo04_ooooo00Go0000oooooooooooooooo
o`000002ooooo`03o`000?oooooooooo04_ooooo00?o0000ooooooooool01?ooool00ol0003ooooo
ooooo`1:ooooo`;o00000oooool01?l0003oooooooooool00008ooooo`00:oooool00ol0003ooooo
ooooo`02ooooo`04o`000?ooooooooooo`0004cooooo00Co0000oooooooooooooooo1?l0001;oooo
o`05o`000?ooooooooooooooool000000_ooool01?l0003oooooooooool0001:ooooo`06o`000?oo
ooooooooooooool0003ooooo1?l0001?ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000oooo
ooooool01_ooool002[ooooo0_l00004ooooo`04o`000?ooooooooooo`0004_ooooo0_l00003oooo
o`03o`000?oooooooooo04cooooo00Go0000ooooooooooooooooo`000002ooooo`04o`000?oooooo
ooooo`0004[ooooo00Oo0000ooooooooooooooooo`000?oooooo000004kooooo00Go0000oooooooo
ooooooooo`000002ooooo`04o`000?ooooooooooo`0000Sooooo000[ooooo`03o`000?oooooooooo
00?ooooo0_l0001=ooooo`04o`000?ooooooooooooooo`Go0000Boooool3o`0000Cooooo0_l0001<
ooooo`?o00000_ooool5o`0004_ooooo0ol00004ooooo`;o00002Oooool00?ooooooTOooool00?oo
ooooTOooool00?ooooooTOooool00?ooooooTOooool00?ooooooTOooool00?ooooooTOooool002Oo
ooooool0001Wo`0000?ooooo000Wooooo`03o`000?oooooooooo00;ooooo00Co0000oooooooooooo
00000_ooool00ol0003oooooooooo`08ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000oooo
ooooool02oooool00ol0003oooooooooo`0>ooooo`03o`000?oooooooooo00kooooo00?o0000oooo
ooooool03_ooool00ol0003oooooooooo`0>ooooo`03o`000?oooooooooo00kooooo00?o0000oooo
ooooool03_ooool00ol0003oooooooooo`0>ooooo`03o`000?oooooooooo00kooooo00?o0000oooo
ooooool03_ooool00ol0003oooooooooo`0>ooooo`03o`000?oooooooooo00kooooo00?o0000oooo
ooooool03_ooool00ol0003oooooooooo`0>ooooo`03o`000?oooooooooo00kooooo00?o0000oooo
ooooool02oooool01?l0003oooooooooool00002ooooo`03o`000?oooooooooo00Sooooo00Co0000
oooooooooooo00000_ooool00ol0003oooooooooo`08ooooo`04o`000?ooooooooooo`0000;ooooo
00?o0000ooooooooool02?ooool01?l0003oooooooooool00002ooooo`03o`000?oooooooooo00Oo
oooo000Wooooo`03o`000?oooooooooo00;ooooo0_l000000ooooooo0000ooooo`02o`0000[ooooo
0_l00003ooooo`;o0000@?ooool00ol0003oooooooooo`1Booooo`03o`000?oooooooooo05;ooooo
00?o0000ooooooooool07?ooool2o`0000?ooooo0_l0000:ooooo`;o00000oooool2o`0000[ooooo
0_l00003ooooo`;o00002_ooool2o`000003ooooool0003ooooo00;o00002Oooool001kooooo0_l0
0007ooooo`03o`000?oooooooooo00?ooooo0_l000001?oooooo0000o`000?l0000;ooooo`;o0000
00Coooooo`000?l0003o0000ooooool;ooooo`;o000000Coooooo`000?l0003o00002oooool2o`00
0004ooooool0003o0000o`0000_ooooo0_l000001?oooooo0000o`000?l0000;ooooo`;o000000Co
ooooo`000?l0003o00002Oooool001gooooo00Co0000oooooooooooo00001_ooool01?l0003ooooo
ooooooooool9o`0000Sooooo2Ol0003oooooo`[ooooo1Ol0000<ooooo`Go00002_ooool9o`0000So
oooo2Ol00008ooooo`007Oooool01?l0003oooooooooool00006ooooo`?o00000_oooolIo`000?oo
oooo2Oooool7o`000004ooooool0003oooooooooo`;o00000_ooool00ol0003oooooo`000006o`00
0003ooooool0003o000000;ooooo00?o0000ooooooooool06ol00008ooooo`007Oooool01?l0003o
ooooooooool00006ooooo`04o`000?ooooooooooooooo`Wo00002?ooool9o`000?oooooo2?ooool9
o`0000Sooooo2Ol00008ooooo`Wo00002?ooool9o`0000Sooooo000Mooooo`04o`000?oooooooooo
o`0000Kooooo00?o0000ooooooooool02ol00006ooooo`_o0000ooooool6ooooo`_o00001_ooool;
o`0000Kooooo2ol00006ooooo`_o00001oooool001gooooo00Co0000oooooooooooo00001_ooool0
0ol0003oooooooooo`04ooooo`?o00003_ooool5o`000?oooooo3?ooool3o`0000kooooo0ol0000=
ooooo`Co00003_ooool3o`0000_ooooo000Nooooo`;o00001oooool00ol0003oooooooooo`04oooo
o`?o00003_ooool3o`000003ooooool0003ooooo0?oooooo2?ooool2o`000004ooooool0003o0000
o`0000kooooo0ol0000=ooooo`Co00003_ooool3o`0000_ooooo000Wooooo`03o`000?oooooooooo
00Gooooo00?o0000ooooooooool03_ooool01?l0003oooooooooool0003oooooo`gooooo00?o0000
ooooooooool03_ooool00ol0003oooooooooo`0;ooooo`04o`000?ooooooooooo`00013ooooo00?o
0000ooooooooool02_ooool002Oooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`0>
ooooo`04o`000?ooooooooooooooo`;o0000ooooool;ooooo`03o`000?oooooooooo00kooooo00?o
0000ooooooooool02oooool01?l0003oooooooooool0000@ooooo`03o`000?oooooooooo00[ooooo
000Wooooo`03o`000?oooooooooo01_ooooo00?o0000ooooooooool0ooooool3ooooo`03o`000?oo
oooooooo027ooooo00?o0000ooooooooool07oooool002Oooooo00?o0000ooooooooool07?ooool0
0ol0003oooooooooo`3oooooobGooooo00?o0000ooooooooool08?ooool002Oooooo0_l0000Noooo
o`03o`000?oooooooooo0?gooooo0_l0000Tooooo`03o`000?oooooooooo023ooooo000Wooooo`03
o`000?oooooooooo01gooooo00?o0000ooooooooool0oooooolSooooo`03o`000?oooooooooo027o
oooo000Wooooo`03o`000?oooooooooo01kooooo0_l0003oooooob;ooooo00?o0000ooooooooool0
8_ooool002Oooooo00?o0000ooooooooool07oooool2o`000?[ooooo00?o0000ooooooooool08ooo
ool00ol0003oooooooooo`0Rooooo`009oooool00ol0003oooooooooo`0Pooooo`03o`000?oooooo
oooo0?oooooo7_ooool00ol0003oooooooooo`0Sooooo`009oooool00ol0003oooooooooo`0Poooo
o`;o0000_Oooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00Sooooo00?o0000oooo
ooooool00oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00?ooooo00?o0000oooo
ooooool02?ooool00ol0003oooooooooo`03ooooo`;o00009Oooool00ol0003oooooooooo`0Toooo
o`009oooool00ol0003oooooooooo`0Qooooo`;o0000_?ooool2o`0000?ooooo0_l0000:ooooo`;o
00000oooool2o`0000[ooooo0_l00003ooooo`;o00002_ooool2o`0000?ooooo0_l0000Vooooo`03
o`000?oooooooooo02Cooooo000Wooooo`03o`000?oooooooooo02;ooooo00?o0000ooooooooool0
^oooool2o`000004ooooool0003o0000o`0000_ooooo0_l000001?oooooo0000o`000?l0000;oooo
o`;o000000Coooooo`000?l0003o00002oooool2o`000004ooooool0003o0000o`0002Gooooo00?o
0000ooooooooool09Oooool002Oooooo00?o0000ooooooooool08oooool2o`0000Gooooo00?o0000
ooooooooool0/oooool5o`0000cooooo1Ol0000<ooooo`Go00003?ooool5o`0002Kooooo00?o0000
ooooooooool09Oooool002Oooooo0_l0000Uooooo`;o00000oooool2o`000;Cooooo2?l00002oooo
o`;o00000_ooool00ol0003oooooooooo`09o`0000;ooooo00?o0000ooooooooool00_l000000ooo
oooo0000o`000005o`000004ooooool0003oooooooooo`;o00000_ooool00ol0003oooooo`000006
o`0002Cooooo00?o0000ooooooooool09_ooool002Oooooo00?o0000ooooooooool09?ooool3o`00
0004ooooool0003o0000o`000;?ooooo2Ol00008ooooo`Wo00002?ooool9o`0000Sooooo2Ol0000R
ooooo`03o`000?oooooooooo02Oooooo000Wooooo`03o`000?oooooooooo02?ooooo2Ol0002aoooo
o`_o00001_ooool;o`0000Kooooo2ol00006ooooo`_o00008Oooool00ol0003oooooooooo`0Woooo
o`009oooool00ol0003oooooooooo`0Tooooo`So0000]Oooool3o`0000kooooo0ol0000>ooooo`?o
00003_ooool3o`0002Cooooo00?o0000ooooooooool0:?ooool002Oooooo00?o0000ooooooooool0
9?ooool8o`000;7ooooo00Co0000oooooooooooooooo0ol0000>ooooo`?o00003_ooool3o`0000ko
oooo0ol0000Sooooo`03o`000?oooooooooo02Wooooo000Wooooo`03o`000?oooooooooo02;ooooo
2ol0002eooooo`03o`000?oooooooooo00kooooo00?o0000ooooooooool03_ooool00ol0003ooooo
ooooo`0>ooooo`03o`000?oooooooooo02;ooooo00?o0000ooooooooool0:Oooool002Oooooo00?o
0000ooooooooool09Oooool5o`000003ooooool0003o00000:gooooo00?o0000ooooooooool01Ooo
ool00ol0003oooooooooo`0>ooooo`03o`000?oooooooooo00kooooo00?o0000ooooooooool03_oo
ool00ol0003oooooooooo`0Qooooo`03o`000?oooooooooo02[ooooo000Wooooo`03o`000?oooooo
oooo02Kooooo0ol00004ooooo`;o0000Zoooool00ol0003oooooooooo`1Fooooo`Wo0000:_ooool0
02Oooooo00?o0000ooooooooool09_ooool3o`0000Gooooo0ol0002Wooooo`03o`000?oooooooooo
05Wooooo2?l0000Zooooo`009oooool2o`0002Sooooo00?o0000ooooooooool01oooool01Ol0003o
oooooooooooooooo000000Gooooo00?o0000ooooooooool0T?ooool00ol0003oooooooooo`03oooo
o`04o`000?ooooooooooo`0005cooooo1ol0000[ooooo`009oooool00ol0003oooooooooo`0Woooo
o`03o`000?oooooooooo00Sooooo0_l000000ooooooo0000o`000003ooooo`;o0000T_ooool2o`00
00?ooooo0_l0001Pooooo`Go0000;?ooool002Oooooo00?o0000ooooooooool0=?ooool4o`000004
ooooool0003o0000o`0009?ooooo0_l000000ooooooo0000o`000002o`0005oooooo1Ol0000/oooo
o`009oooool00ol0003oooooooooo`0dooooo`Wo0000T_ooool5o`0006;ooooo0ol0000]ooooo`00
9oooool00ol0003oooooooooo`0eooooo`So0000T_ooool5o`0006;ooooo0ol0000]ooooo`009ooo
ool00ol0003oooooooooo`0eooooo`So0000TOooool8o`00063ooooo0_l0000^ooooo`009oooool0
0ol0003oooooooooo`0cooooo`_o0000S_ooool;o`0005oooooo00?o0000ooooooooool0;Oooool0
02Oooooo00?o0000ooooooooool0=oooool3o`0000Cooooo0_l0002@ooooo`?o0000Hoooool00ol0
003oooooooooo`0]ooooo`009oooool00ol0003oooooooooo`0gooooo`?o00001_ooool2o`0008[o
oooo0_l00002ooooo`?o0000Hoooool00ol0003oooooooooo`0]ooooo`009oooool2o`0003Wooooo
00?o0000ooooooooool01_ooool2o`0000?ooooo00?o0000ooooooooool00oooool00ol0003ooooo
ooooo`08ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool0LOooool00ol0003ooooo
ooooo`1Qooooo`03o`000?oooooooooo02kooooo000Wooooo`03o`000?oooooooooo03Sooooo00?o
0000ooooooooool02?ooool2o`000003ooooool0003o000000?ooooo0_l0000:ooooo`;o00000ooo
ool2o`0006cooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`1Qooooo`03o`000?oo
oooooooo02kooooo000Wooooo`03o`000?oooooooooo03Sooooo00?o0000ooooooooool02Oooool5
o`000004ooooool0003o0000o`0000_ooooo0_l000001?oooooo0000o`000?l0001[ooooo`03o`00
0?oooooooooo00Gooooo00?o0000ooooooooool0HOooool00ol0003oooooooooo`0^ooooo`009ooo
ool00ol0003oooooooooo`15ooooo`Wo00002?ooool9o`0006Sooooo00?o0000ooooooooool0Jooo
ool00ol0003oooooooooo`0^ooooo`009oooool00ol0003oooooooooo`16oooooaWo0000J?ooool0
0ol0003oooooooooo`1[ooooo`03o`000?oooooooooo02kooooo000Wooooo`03o`000?oooooooooo
04Kooooo2?l00009ooooo`So0000G_ooool2o`0000Cooooo00?o0000ooooooooool0Koooool00ol0
003oooooooooo`0^ooooo`004_ooool2o`0000Cooooo00?o0000ooooooooool00_ooool3o`0000Oo
oooo00?o0000ooooooooool0A?ooool;o`0000Kooooo2ol0001Mooooo`?o000000?oooooo`000?l0
00000_l0001_ooooo`03o`000?oooooooooo02oooooo000Aooooo`04o`000?ooooooooooo`0000Oo
oooo00Go0000ooooooooooooooooo`000006ooooo`03o`000?oooooooooo04Sooooo0ol0000>oooo
o`?o0000H_ooool6o`00073ooooo00?o0000ooooooooool0;oooool0017ooooo00Co0000oooooooo
oooo00002oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo04Sooooo0ol0000>oooo
o`?o0000H_ooool5o`00077ooooo00?o0000ooooooooool0;oooool0017ooooo00Co0000oooooooo
oooo00002oooool00ol0003oooooooooo`04ooooo`?o0000BOooool00ol0003oooooooooo`0>oooo
o`03o`000?oooooo0000063ooooo1ol0001`ooooo`03o`000?oooooooooo02oooooo000Aooooo`04
o`000?ooooooooooo`0000Oooooo1?l00007ooooo`03o`000?oooooooooo04Wooooo00?o0000oooo
ooooool03_ooool00ol0003oooooo`00001Oooooo`Wo0000Koooool00ol0003oooooooooo`0_oooo
o`004Oooool01?l0003oooooooooool00007ooooo`03o`000?oooooooooo00Sooooo00?o0000oooo
ooooool0BOooool00ol0003oooooooooo`0>ooooo`03o`000?oooooo000005kooooo2ol0001]oooo
o`03o`000?oooooooooo033ooooo000Booooo`;o00002?ooool5o`0000Kooooo00?o0000oooooooo
ool0GOooool00ol0003oooooooooo`1Oooooo`?o0000LOooool00ol0003oooooooooo`0`ooooo`00
9oooool00ol0003oooooooooo`1Mooooo`03o`000?oooooooooo05kooooo1?l0001aooooo`03o`00
0?oooooooooo033ooooo000Wooooo`03o`000?oooooooooo05gooooo00?o0000ooooooooool0GOoo
ool01?l0003oooooooooool0001booooo`03o`000?oooooooooo033ooooo000Wooooo`03o`000?oo
oooooooo05kooooo00?o0000ooooooooool0Goooool00ol0003oooooooooo`1`ooooo`03o`000?oo
oooooooo033ooooo000;ooooo`Go00005oooool00ol0003oooooooooo`1Nooooo`03o`000?oooooo
oooo05_ooooo00?o0000ooooooooool0M?ooool00ol0003oooooooooo`0`ooooo`003?ooool01?l0
003oooooooooool0000Gooooo`03o`000?oooooooooo05kooooo00?o0000ooooooooool0Foooool0
0ol0003oooooooooo`1cooooo`03o`000?oooooooooo037ooooo000<ooooo`03o`000?oooooooooo
01Sooooo0_l0001Pooooo`03o`000?oooooooooo0=3ooooo00?o0000ooooooooool0<Oooool000co
oooo0ol0000Hooooo`03o`000?oooooooooo05oooooo00?o0000ooooooooool0F?ooool00ol0003o
ooooooooo`1eooooo`03o`000?oooooooooo037ooooo000<ooooo`03o`000?oooooooooo01Sooooo
00?o0000ooooooooool0Goooool00ol0003oooooooooo`1Hooooo`03o`000?oooooooooo07Gooooo
00?o0000ooooooooool0<Oooool000cooooo00Co0000oooooooooooo00005oooool00ol0003ooooo
ooooo`1Pooooo`03o`000?oooooooooo0<oooooo00?o0000ooooooooool0<Oooool000_ooooo1_l0
000Fooooo`03o`000?oooooooooo063ooooo0_l0001Fooooo`03o`000?oooooooooo07Kooooo00?o
0000ooooooooool0<_ooool000_ooooo00Go0000ooooooooooooooooo`00000Gooooo`03o`000?oo
oooooooo063ooooo00?o0000ooooooooool0EOooool00ol0003oooooooooo`1fooooo`03o`000?oo
oooooooo03;ooooo000;ooooo`Go00005oooool00ol0003oooooooooo`1Qooooo`03o`000?oooooo
oooo0<gooooo00?o0000ooooooooool0<_ooool000cooooo00?o0000ooooool000006?ooool00ol0
003oooooooooo`1Qooooo`;o0000c_ooool00ol0003oooooooooo`0booooo`003?ooool00ol0003o
ooooo`00000Hooooo`03o`000?oooooooooo067ooooo0_l0001Cooooo`;o0000NOooool00ol0003o
ooooooooo`0booooo`003Oooool00ol0003oooooooooo`0Gooooo`;o0000Hoooool00ol0003ooooo
ooooo`3<ooooo`03o`000?oooooooooo03;ooooo000;ooooo`Go00005oooool00ol0003ooooooooo
o`1Rooooo`03o`000?oooooooooo0<_ooooo00?o0000ooooooooool0<oooool000cooooo00Co0000
oooooooooooo00005oooool00ol0003oooooooooo`1Sooooo`03o`000?oooooooooo04oooooo00?o
0000ooooooooool0N?ooool00ol0003oooooooooo`0cooooo`003?ooool00ol0003oooooooooo`0H
ooooo`03o`000?oooooooooo06?ooooo00?o0000ooooooooool0b_ooool00ol0003oooooooooo`0c
ooooo`003?ooool3o`0001Sooooo00?o0000ooooooooool0Hoooool00ol0003oooooooooo`3:oooo
o`03o`000?oooooooooo03?ooooo000<ooooo`03o`000?oooooooooo01Sooooo00?o0000oooooooo
ool0I?ooool00ol0003oooooooooo`1<ooooo`03o`000?oooooooooo07[ooooo00?o0000oooooooo
ool0<oooool000cooooo00Co0000oooooooooooo00005oooool00ol0003oooooooooo`1Tooooo`03
o`000?oooooooooo0<Sooooo00?o0000ooooooooool0=?ooool000_ooooo1Ol0000Gooooo`03o`00
0?oooooooooo06Cooooo00?o0000ooooooooool0AOooool2o`0000Cooooo00?o0000ooooooooool0
N_ooool00ol0003oooooooooo`0dooooo`009oooool00ol0003oooooooooo`1Uooooo`03o`000?oo
oooooooo04Cooooo0ol000001?oooooo0000o`000?l0001looooo`03o`000?oooooooooo03Cooooo
000Wooooo`;o0000I_ooool00ol0003oooooooooo`15ooooo`Ko0000O?ooool00ol0003ooooooooo
o`0dooooo`009oooool00ol0003oooooooooo`1Uooooo`03o`000?oooooooooo04Gooooo1Ol0001m
ooooo`03o`000?oooooooooo03Cooooo000Wooooo`03o`000?oooooooooo06Kooooo00?o0000oooo
ooooool0@oooool7o`0007cooooo00?o0000ooooooooool0=?ooool002Oooooo00?o0000oooooooo
ool0I_ooool00ol0003oooooooooo`12ooooo`Wo0000N_ooool00ol0003oooooooooo`0eooooo`00
2oooool4o`0001Sooooo00?o0000ooooooooool0I_ooool00ol0003oooooooooo`11ooooo`_o0000
NOooool00ol0003oooooooooo`0eooooo`003oooool00ol0003oooooooooo`0Eooooo`03o`000?oo
oooooooo06Oooooo00?o0000ooooooooool0@oooool4o`0007gooooo00?o0000ooooooooool0=Ooo
ool000cooooo0ol0000Hooooo`03o`000?oooooooooo06Oooooo00?o0000ooooooooool0A?ooool3
o`0007gooooo00?o0000ooooooooool0=Oooool000_ooooo00?o0000ooooooooool06Oooool00ol0
003oooooooooo`1Wooooo`03o`000?oooooooooo04Gooooo00?o0000ooooooooool0O?ooool00ol0
003oooooooooo`0eooooo`003?ooool4o`0001Oooooo00?o0000ooooooooool0J?ooool00ol0003o
ooooooooo`11ooooo`04o`000?ooooooooooo`0007kooooo00?o0000ooooooooool0=Oooool002Oo
oooo0_l0001Yooooo`03o`000?oooooooooo0<;ooooo00?o0000ooooooooool0=_ooool000cooooo
0ol0000Hooooo`03o`000?oooooooooo06Sooooo0_l00033ooooo`03o`000?oooooooooo03Kooooo
000;ooooo`03o`000?oooooooooo01Wooooo00?o0000ooooooooool0JOooool00ol0003ooooooooo
o`0nooooo`03o`000?oooooooooo083ooooo00?o0000ooooooooool0=_ooool000_ooooo1Ol0000G
ooooo`03o`000?oooooooooo06Wooooo0_l00032ooooo`03o`000?oooooooooo03Kooooo000;oooo
o`05o`000?ooooooooooooooool000005oooool00ol0003oooooooooo`1Xooooo`?o00000oooool0
0ol0003oooooooooo`08ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool02?ooool0
0ol0003oooooooooo`03ooooo`03o`000?oooooooooo09[ooooo00?o0000ooooooooool0=_ooool0
00cooooo0ol0000Hooooo`03o`000?oooooooooo06Sooooo0ol00002ooooo`;o00002_ooool2o`00
00?ooooo0_l0000:ooooo`;o00000oooool2o`0001Oooooo00?o0000ooooooooool0POooool00ol0
003oooooooooo`0gooooo`007Oooool3o`0000Oooooo00?o0000ooooooooool0JOooool2o`000004
ooooool0003o0000o`0000_ooooo0_l000001?oooooo0000o`000?l0000;ooooo`;o000000Cooooo
o`000?l0003o0000Voooool00ol0003oooooooooo`0gooooo`003Oooool00ol0003oooooooooo`0>
ooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool0Ioooool9o`0000[ooooo1Ol0000<
ooooo`Go0000W?ooool00ol0003oooooooooo`0gooooo`003Oooool00ol0003oooooooooo`0>oooo
o`03o`000?oooooooooo00Kooooo0ol0001Xooooo`[o00000_ooool00ol0003oooooooooo`02o`00
0003ooooool0003o000000Co00000_ooool00ol0003oooooooooo`02o`0000;ooooo00?o0000oooo
ool000001?l0000Fooooo`;o0000Q?ooool00ol0003oooooooooo`0gooooo`003?ooool00ol0003o
ooooo`00000?ooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool0J?ooool8o`0000Wo
oooo2?l00009ooooo`So0000V_ooool00ol0003oooooooooo`0gooooo`003?ooool00ol0003ooooo
o`00000?ooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool0I_ooool;o`0000Kooooo
2ol00006ooooo`_o0000VOooool00ol0003oooooooooo`0gooooo`002oooool2o`000003ooooool0
003o000000gooooo0_l00008ooooo`03o`000?oooooooooo06[ooooo0ol0000>ooooo`?o00003_oo
ool3o`0001Kooooo00?o0000ooooooooool0Poooool00ol0003oooooooooo`0hooooo`007_ooool0
0ol0003oooooooooo`06ooooo`03o`000?oooooooooo06[ooooo0ol0000>ooooo`?o00003_ooool3
o`0000?ooooo00?o0000ooooooooool0U_ooool00ol0003oooooooooo`0hooooo`003?ooool3o`00
01Sooooo00?o0000ooooooooool0Joooool00ol0003oooooo`00000>ooooo`03o`000?oooooooooo
00kooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`2Eooooo`03o`000?oooooooooo
03Sooooo000;ooooo`03o`000?oooooooooo01Wooooo00?o0000ooooooooool0Joooool00ol0003o
ooooo`00000>ooooo`03o`000?oooooooooo00kooooo00?o0000ooooooooool01Oooool00ol0003o
ooooooooo`0;ooooo`03o`000?oooooooooo08Gooooo00?o0000ooooooooool0>?ooool000_ooooo
1Ol0000Gooooo`03o`000?oooooooooo06_ooooo00?o0000ooooool000003_ooool00ol0003ooooo
ooooo`0>ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool0Toooool00ol0003ooooo
ooooo`0hooooo`002oooool01Ol0003ooooooooooooooooo000001Oooooo00?o0000ooooooooool0
K_ooool00ol0003oooooooooo`2iooooo`03o`000?oooooooooo03Wooooo000<ooooo`?o00006?oo
ool2o`0006oooooo00?o0000ooooooooool09oooool00ol0003oooooooooo`06ooooo`03o`000?oo
oooooooo08Kooooo00?o0000ooooooooool0>Oooool002Oooooo00?o0000ooooooooool0Koooool0
0ol0003oooooooooo`0Yooooo`;o00001?ooool00ol0003oooooooooo`26ooooo`03o`000?oooooo
oooo03Wooooo000;ooooo`?o00006Oooool00ol0003oooooooooo`1_ooooo`03o`000?oooooooooo
02Sooooo1?l000001?oooooo0000o`000?l00028ooooo`03o`000?oooooooooo03Wooooo000<oooo
o`03o`000?oooooooooo01Sooooo00?o0000ooooooooool0Koooool00ol0003oooooooooo`0Zoooo
o`Ko0000R?ooool00ol0003oooooooooo`0iooooo`003?ooool00ol0003oooooooooo`0Hooooo`03
o`000?oooooooooo073ooooo00?o0000ooooooooool0:Oooool5o`0008Wooooo00?o0000oooooooo
ool0>Oooool000cooooo0_l0000Iooooo`03o`000?oooooooooo073ooooo00?o0000ooooooooool0
:?ooool7o`0008Oooooo00?o0000ooooooooool0>_ooool000_ooooo0_l000000ooooooo0000o`00
000Gooooo`03o`000?oooooooooo073ooooo00?o0000ooooooooool09oooool9o`0008Kooooo00?o
0000ooooooooool0>_ooool002Oooooo00?o0000ooooooooool0LOooool00ol0003oooooooooo`0U
ooooo`_o0000QOooool00ol0003oooooooooo`0jooooo`002oooool5o`0001Oooooo00?o0000oooo
ooooool0LOooool00ol0003oooooooooo`0Yooooo`?o0000ROooool00ol0003oooooooooo`0joooo
o`003Oooool00ol0003oooooooooo`0Gooooo`;o0000Loooool00ol0003oooooooooo`0Xooooo`?o
0000ROooool00ol0003oooooooooo`0jooooo`003Oooool00ol0003oooooooooo`0Gooooo`03o`00
0?oooooooooo07;ooooo00?o0000ooooooooool0:Oooool00ol0003oooooooooo`27ooooo`03o`00
0?oooooooooo03_ooooo000=ooooo`03o`000?oooooooooo01Oooooo00?o0000ooooooooool0L_oo
ool00ol0003oooooooooo`0Yooooo`03o`000?oooooooooo08Oooooo00?o0000ooooooooool0>ooo
ool000_ooooo0ol0000Iooooo`03o`000?oooooooooo07?ooooo00?o0000ooooooooool0/_ooool0
0ol0003oooooooooo`0kooooo`009oooool00ol0003oooooooooo`1cooooo`03o`000?oooooooooo
0;;ooooo00?o0000ooooooooool0>oooool000gooooo0_l0000Hooooo`03o`000?oooooooooo07Co
oooo00?o0000ooooooooool0/Oooool00ol0003oooooooooo`0kooooo`003?ooool01?l0003ooooo
ooooool0000Gooooo`03o`000?oooooooooo07Cooooo00?o0000ooooooooool0/Oooool00ol0003o
ooooooooo`0kooooo`003?ooool00ol0003oooooooooo`0Hooooo`03o`000?oooooooooo07Cooooo
00?o0000ooooooooool0/?ooool00ol0003oooooooooo`0looooo`003?ooool00ol0003ooooooooo
o`0Hooooo`03o`000?oooooooooo07Gooooo00?o0000ooooooooool0[oooool00ol0003ooooooooo
o`0looooo`002oooool4o`0001Sooooo0_l0001fooooo`03o`000?oooooooooo0:oooooo00?o0000
ooooooooool0??ooool000cooooo00?o0000ooooooooool06?ooool00ol0003oooooooooo`1eoooo
o`03o`000?oooooooooo0:oooooo00?o0000ooooooooool0??ooool000cooooo0_l0000Iooooo`03
o`000?oooooooooo07Kooooo00?o0000ooooooooool0[_ooool00ol0003oooooooooo`0looooo`00
3Oooool00ol0003oooooooooo`0Gooooo`03o`000?oooooooooo07Kooooo00?o0000ooooooooool0
@oooool9o`0000Sooooo2Ol00008ooooo`Wo00002?ooool9o`0000Sooooo2Ol00008ooooo`Wo0000
2?ooool9o`0003_ooooo000<ooooo`03o`000?oooooo000001Sooooo00?o0000ooooooooool0Mooo
ool00ol0003oooooooooo`13ooooo`So00002Oooool8o`0000Wooooo2?l00009ooooo`So00002Ooo
ool8o`0000Wooooo2?l00009ooooo`So0000>oooool000cooooo00?o0000ooooool000006?ooool0
0ol0003oooooooooo`1gooooo`03o`000?oooooooooo04?oooooKOl0000looooo`002oooool2o`00
0003ooooool0003o000001Oooooo00?o0000ooooooooool0Moooool00ol0003oooooooooo`14oooo
o`Go00003?ooool5o`0000cooooo1Ol0000<ooooo`Go00003?ooool5o`0000cooooo1Ol0000<oooo
o`Go0000?Oooool002Oooooo00?o0000ooooooooool0N?ooool00ol0003oooooooooo`12ooooo`Ko
00003?ooool5o`0000cooooo1Ol0000<ooooo`Go00003?ooool5o`0000cooooo1Ol0000<ooooo`Go
0000?Oooool002Oooooo00?o0000ooooooooool0N?ooool00ol0003oooooooooo`10ooooo`;o0000
0_ooool3o`0000kooooo0ol0000>ooooo`?o00003_ooool3o`0000kooooo0ol0000>ooooo`?o0000
3_ooool3o`0003kooooo000Wooooo`;o0000NOooool00ol0003oooooooooo`0oooooo`03o`000?oo
oooooooo00;ooooo0ol0000>ooooo`?o00003_ooool3o`0000kooooo0ol0000>ooooo`?o00003_oo
ool3o`0000kooooo0ol0000nooooo`009oooool00ol0003oooooooooo`1iooooo`03o`000?oooooo
oooo03gooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`0>ooooo`03o`000?oooooo
oooo00kooooo00?o0000ooooooooool03_ooool00ol0003oooooooooo`0>ooooo`03o`000?oooooo
oooo00kooooo00?o0000ooooooooool03_ooool00ol0003oooooooooo`0mooooo`009oooool00ol0
003oooooooooo`1iooooo`03o`000?oooooooooo03_ooooo0_l0002]ooooo`009oooool00ol0003o
ooooooooo`1jooooo`03o`000?oooooooooo03Wooooo00?o0000ooooooooool0[Oooool002Oooooo
00?o0000ooooooooool0N_ooool00ol0003oooooooooo`0hooooo`03o`000?oooooooooo0:kooooo
000;ooooo`Go00005oooool00ol0003oooooooooo`1jooooo`03o`000?oooooooooo03Oooooo00?o
0000ooooooooool0[oooool000gooooo00?o0000ooooooooool05oooool00ol0003oooooooooo`1k
ooooo`03o`000?oooooooooo03Cooooo0_l0002booooo`003Oooool01?l0003oooooooooooooool3
o`0000Cooooo00?o0000ooooooooool00_ooool3o`0000Oooooo00?o0000ooooooooool0Noooool0
0ol0003oooooooooo`0cooooo`03o`000?oooooooooo0;;ooooo000=ooooo`03o`000?oooooooooo
00;ooooo00?o0000ooooooooool01oooool01Ol0003ooooooooooooooooo000000Kooooo00?o0000
ooooooooool0N?ooool9o`0002[ooooo2Ol0002booooo`002oooool3o`0000Cooooo00?o0000oooo
ooooool02oooool00ol0003oooooooooo`04ooooo`?o0000NOooool8o`0002_ooooo2?l0002boooo
o`004_ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00Cooooo00?o0000oooooooo
ool0NOooool7o`0002cooooo1ol0002cooooo`002oooool3o`000005ooooool0003o0000ooooool0
00002Oooool4o`0000Oooooo00?o0000ooooooooool0N_ooool5o`0002kooooo1Ol0002dooooo`00
3?ooool01Ol0003oooooooooool0003ooooo00;o00002Oooool00ol0003oooooooooo`08ooooo`03
o`000?oooooooooo07_ooooo0ol0000`ooooo`?o0000]Oooool000cooooo00Co0000oooooooooooo
00000_ooool00ol0003oooooooooo`07ooooo`Go00001_ooool00ol0003oooooooooo`1kooooo`?o
0000<?ooool3o`000;Gooooo000<ooooo`04o`000?ooooooooooo`0001Oooooo00?o0000oooooooo
ool0O?ooool2o`0002oooooo00?o0000ooooool00000]_ooool000_ooooo1?l0000Hooooo`03o`00
0?oooooooooo07gooooo00?o0000ooooooooool0;Oooool00ol0003oooooooooo`2fooooo`009ooo
ool00ol0003oooooooooo`1mooooo`03o`000?oooooooooo02gooooo00?o0000ooooooooool0]_oo
ool000cooooo1?l0000Gooooo`03o`000?oooooooooo07kooooo00?o0000ooooooooool0:oooool0
0ol0003oooooooooo`2gooooo`002oooool01?l0003oooooooooool0000Hooooo`;o0000Ooooool0
0ol0003oooooooooo`0[ooooo`03o`000?oooooooooo0;Oooooo000;ooooo`04o`000?oooooooooo
o`0001Sooooo00?o0000ooooooooool0O_ooool00ol0003oooooooooo`0Zooooo`03o`000?oooooo
oooo0;Sooooo000;ooooo`04o`000?ooooooooooo`0001Sooooo00?o0000ooooooooool0O_ooool0
0ol0003oooooooooo`0Zooooo`03o`000?oooooooooo0;Sooooo000<ooooo`?o00006?ooool00ol0
003oooooooooo`1oooooo`03o`000?oooooooooo02Wooooo00?o0000ooooooooool0^?ooool000ko
oooo00?o0000ooooooooool05_ooool00ol0003oooooooooo`1oooooo`03o`000?oooooooooo02So
oooo00?o0000ooooooooool0^Oooool000cooooo0ol0000Hooooo`03o`000?oooooooooo07oooooo
00?o0000ooooooooool0:?ooool00ol0003oooooooooo`2iooooo`002oooool00ol0003ooooooooo
o`0Iooooo`03o`000?oooooooooo07oooooo00?o0000ooooooooool0:?ooool00ol0003ooooooooo
o`2iooooo`002oooool5o`0001Oooooo00?o0000ooooooooool0Ooooool00ol0003oooooooooo`0W
ooooo`03o`000?oooooooooo0;[ooooo000;ooooo`05o`000?ooooooooooooooool000005oooool0
0ol0003oooooooooo`20ooooo`03o`000?oooooooooo02Kooooo00?o0000ooooooooool0^_ooool0
00cooooo0ol0000Hooooo`;o0000POooool00ol0003oooooooooo`0Uooooo`03o`000?oooooooooo
0;_ooooo000Wooooo`03o`000?oooooooooo083ooooo00?o0000ooooooooool09Oooool00ol0003o
ooooooooo`2kooooo`002oooool2o`000003ooooool0003o000001Oooooo00?o0000ooooooooool0
P?ooool00ol0003oooooooooo`0Uooooo`03o`000?oooooooooo0;_ooooo000<ooooo`03o`000?oo
oooo000001Sooooo00?o0000ooooooooool0POooool00ol0003oooooooooo`0Sooooo`03o`000?oo
oooooooo0;cooooo000=ooooo`03o`000?oooooooooo01Oooooo00?o0000ooooooooool0POooool0
0ol0003oooooooooo`0Sooooo`03o`000?oooooooooo0;cooooo000<ooooo`03o`000?oooooo0000
01Sooooo00?o0000ooooooooool0POooool00ol0003oooooooooo`0Rooooo`03o`000?oooooooooo
0;gooooo000;ooooo`;o000000?oooooo`000?l000005oooool00ol0003oooooooooo`21ooooo`03
o`000?oooooooooo02;ooooo00?o0000ooooooooool0_Oooool002Oooooo00?o0000ooooooooool0
POooool00ol0003oooooooooo`0Rooooo`03o`000?oooooooooo0;gooooo000Wooooo`03o`000?oo
oooooooo08;ooooo00?o0000ooooooooool08?ooool00ol0003oooooooooo`2nooooo`009oooool2
o`0008?ooooo00?o0000ooooooooool08?ooool00ol0003oooooooooo`2nooooo`009oooool00ol0
003oooooooooo`22ooooo`03o`000?oooooooooo023ooooo00?o0000ooooooooool0__ooool002Oo
oooo00?o0000ooooooooool0P_ooool00ol0003oooooooooo`0Oooooo`03o`000?oooooooooo0;oo
oooo000Wooooo`03o`000?oooooooooo08?ooooo00?o0000ooooooooool07_ooool00ol0003ooooo
ooooo`2oooooo`009oooool00ol0003oooooooooo`23ooooo`03o`000?oooooooooo01gooooo00?o
0000ooooooooool0`?ooool002Oooooo00?o0000ooooooooool0Poooool00ol0003oooooooooo`0M
ooooo`03o`000?oooooooooo0<3ooooo000Wooooo`03o`000?oooooooooo08?ooooo00?o0000oooo
ooooool07Oooool00ol0003oooooooooo`30ooooo`009oooool00ol0003oooooooooo`23ooooo`03
o`000?oooooooooo01cooooo00?o0000ooooooooool0`Oooool002Oooooo00?o0000ooooooooool0
Q?ooool00ol0003oooooooooo`0Kooooo`03o`000?oooooooooo0<7ooooo000Wooooo`;o0000QOoo
ool00ol0003oooooooooo`0Kooooo`03o`000?oooooooooo0<7ooooo000Wooooo`03o`000?oooooo
oooo08Cooooo00?o0000ooooooooool06_ooool00ol0003oooooooooo`32ooooo`009oooool00ol0
003oooooooooo`24ooooo`03o`000?oooooooooo01[ooooo00?o0000ooooooooool0`_ooool002Oo
oooo00?o0000ooooooooool0QOooool00ol0003oooooooooo`0Hooooo`03o`000?oooooooooo0<?o
oooo000Wooooo`03o`000?oooooooooo08Gooooo00?o0000ooooooooool06?ooool00ol0003ooooo
ooooo`33ooooo`009oooool00ol0003oooooooooo`25ooooo`03o`000?oooooooooo01Sooooo00?o
0000ooooooooool0`oooool001cooooo1Ol00006ooooo`03o`000?oooooooooo08Gooooo00?o0000
ooooooooool05oooool00ol0003oooooooooo`34ooooo`007Oooool01?l0003oooooooooool00006
ooooo`03o`000?oooooooooo08Kooooo00?o0000ooooooooool04Oooool9o`000<?ooooo000Noooo
o`03o`000?oooooooooo00Kooooo00?o0000ooooooooool0Q_ooool00ol0003oooooooooo`0Boooo
o`So0000`oooool001oooooo00?o0000ooooooooool01Oooool3o`0008Kooooo00?o0000oooooooo
ool04_ooool7o`000<Cooooo000Looooo`05o`000?ooooooooooooooool000001_ooool00ol0003o
ooooooooo`26ooooo`03o`000?oooooooooo01?ooooo1Ol00035ooooo`007?ooool01Ol0003ooooo
oooooooooooo000000Kooooo00?o0000ooooooooool0Q_ooool00ol0003oooooooooo`0Cooooo`Go
0000aOooool001gooooo0ol00007ooooo`03o`000?oooooooooo08Oooooo00?o0000ooooooooool0
4oooool3o`000<Kooooo000Wooooo`03o`000?oooooooooo08Oooooo00?o0000ooooooooool04_oo
ool4o`000<Kooooo000Wooooo`03o`000?oooooooooo08Oooooo00?o0000ooooooooool04_ooool0
0ol0003oooooo`000037ooooo`009oooool00ol0003oooooooooo`27ooooo`03o`000?oooooooooo
017ooooo00?o0000ooooooooool0b?ooool002Oooooo00?o0000ooooooooool0R?ooool00ol0003o
ooooooooo`0?ooooo`03o`000?oooooooooo0<Wooooo000Wooooo`03o`000?oooooooooo08Sooooo
00?o0000ooooooooool03oooool00ol0003oooooooooo`39ooooo`009oooool2o`0008Wooooo00?o
0000ooooooooool03_ooool00ol0003oooooooooo`3:ooooo`009oooool00ol0003oooooooooo`28
ooooo`03o`000?oooooooooo00kooooo00?o0000ooooooooool0b_ooool002Oooooo00?o0000oooo
ooooool0R?ooool00ol0003oooooooooo`0=ooooo`03o`000?oooooooooo0<_ooooo000Wooooo`03
o`000?oooooooooo08Wooooo00?o0000ooooooooool03?ooool00ol0003oooooooooo`3;ooooo`00
9oooool00ol0003oooooooooo`29ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool0
c?ooool002Oooooo00?o0000ooooooooool0ROooool00ol0003oooooooooo`0;ooooo`03o`000?oo
oooooooo0<cooooo000Wooooo`03o`000?oooooooooo08Wooooo00?o0000ooooooooool02_ooool0
0ol0003oooooooooo`3=ooooo`009oooool00ol0003oooooooooo`2:ooooo`03o`000?oooooooooo
00Sooooo00?o0000ooooooooool0c_ooool002Oooooo00?o0000ooooooooool0R_ooool00ol0003o
ooooooooo`08ooooo`03o`000?oooooooooo0<kooooo000Wooooo`;o0000Roooool00ol0003ooooo
ooooo`07ooooo`03o`000?oooooooooo0<oooooo000Wooooo`03o`000?oooooooooo08[ooooo00?o
0000ooooooooool01oooool00ol0003oooooooooo`3?ooooo`009oooool00ol0003oooooooooo`2:
ooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool0d?ooool002Oooooo00?o0000oooo
ooooool0Roooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo0=3ooooo000Wooooo`03
o`000?oooooooooo08_ooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`3Aooooo`00
9oooool00ol0003oooooooooo`2;ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool0
dOooool002Oooooo00?o0000ooooooooool0Roooool00ol0003oooooooooo`03ooooo`03o`000?oo
oooooooo0=;ooooo000Wooooo`03o`000?oooooooooo08cooooo00?o0000ooooooooool00_ooool0
0ol0003oooooooooo`3Booooo`009oooool00ol0003oooooooooo`2<ooooo`05o`000?oooooooooo
ooooool00000eOooool002Oooooo0_l0002=ooooo`04o`000?ooooooooooo`000=Kooooo000Woooo
o`03o`000?oooooooooo08cooooo00Co0000oooooooooooo0000e_ooool002Oooooo00?o0000oooo
ooooool0S?ooool00ol0003oooooo`00003Gooooo`009oooool00ol0003oooooooooo`29ooooo`Wo
0000e?ooool002Oooooo00?o0000ooooooooool0R_ooool8o`000=Cooooo000Wooooo`03o`000?oo
oooooooo08[ooooo1ol0003Eooooo`009oooool00ol0003oooooooooo`2;ooooo`Go0000e_ooool0
02Oooooo00?o0000ooooooooool0S?ooool3o`000=Oooooo000Wooooo`03o`000?oooooooooo08co
oooo0ol0003Gooooo`009oooool2o`0008kooooo00?o0000ooooooooool0e_ooool00001\
\>"],
  ImageRangeCache->{{{0, 399}, {246.188, 0}} -> {7.19031, -0.343432, \
0.0588011, 0.0111792}}]
}, Open  ]],

Cell[TextData[{
  "Se state eseguento ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " nella versione per Mac OS X, noterete come l'etichetta sull'asse delle \
ordinate sia di difficile lettura, in quanto i singoli caratteri non sono \
ruotati. Ci\[OGrave] \[EGrave] legato ad un bug della versione per OS X.\n\
Infine, aggiungiamo una legenda per descrivere adeguatamente le due serie:"
}], "Text",
  PageWidth->PaperWidth],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(MultipleListPlot[untreated, treated, PlotJoined \[Rule] True, 
        SymbolShape \[Rule] {enlarge[PlotSymbol[Triangle], 2], 
            enlarge[PlotSymbol[Star], 2.5]}, 
        Frame \[Rule] {True, True, False, False}, 
        FrameLabel \[Rule] {"\<Days\>", "\<EAE severity index\>"}, 
        PlotLegend \[Rule] {"\<Non trattati\>", "\<Trattati\>"}];\)\)], \
"Input",
  CellLabel->"In[16]:=",
  PageWidth->PaperWidth],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .42623 
%%ImageSize: 400 170.492 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.352217 0.328407 0.213115 0.328407 [
[ 0 0 0 0 ]
[ 1 .42623 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
% Start of sub-graphic
p
0.0238095 0.0101483 0.680624 0.416082 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.452381 0.047619 0.0147151 0.25047 [
[.02381 -0.0125 -6 -9 ]
[.02381 -0.0125 6 0 ]
[.2619 -0.0125 -6 -9 ]
[.2619 -0.0125 6 0 ]
[.5 -0.0125 -6 -9 ]
[.5 -0.0125 6 0 ]
[.7381 -0.0125 -6 -9 ]
[.7381 -0.0125 6 0 ]
[.97619 -0.0125 -6 -9 ]
[.97619 -0.0125 6 0 ]
[ 0 0 -0.125 0 ]
[.5 -0.0125 -14 -21 ]
[.5 -0.0125 14 -9 ]
[-0.0125 .01472 -6 -4.5 ]
[-0.0125 .01472 0 4.5 ]
[-0.0125 .13995 -18 -4.5 ]
[-0.0125 .13995 0 4.5 ]
[-0.0125 .26518 -6 -4.5 ]
[-0.0125 .26518 0 4.5 ]
[-0.0125 .39042 -18 -4.5 ]
[-0.0125 .39042 0 4.5 ]
[-0.0125 .51565 -6 -4.5 ]
[-0.0125 .51565 0 4.5 ]
[ 0 0 -0.125 0 ]
[-0.01875 .30902 -30 -56 ]
[-0.01875 .30902 -18 56 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 0 m
.02381 .00625 L
s
[(10)] .02381 -0.0125 0 1 Mshowa
.2619 0 m
.2619 .00625 L
s
[(15)] .2619 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(20)] .5 -0.0125 0 1 Mshowa
.7381 0 m
.7381 .00625 L
s
[(25)] .7381 -0.0125 0 1 Mshowa
.97619 0 m
.97619 .00625 L
s
[(30)] .97619 -0.0125 0 1 Mshowa
.125 Mabswid
.07143 0 m
.07143 .00375 L
s
.11905 0 m
.11905 .00375 L
s
.16667 0 m
.16667 .00375 L
s
.21429 0 m
.21429 .00375 L
s
.30952 0 m
.30952 .00375 L
s
.35714 0 m
.35714 .00375 L
s
.40476 0 m
.40476 .00375 L
s
.45238 0 m
.45238 .00375 L
s
.54762 0 m
.54762 .00375 L
s
.59524 0 m
.59524 .00375 L
s
.64286 0 m
.64286 .00375 L
s
.69048 0 m
.69048 .00375 L
s
.78571 0 m
.78571 .00375 L
s
.83333 0 m
.83333 .00375 L
s
.88095 0 m
.88095 .00375 L
s
.92857 0 m
.92857 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
gsave
.5 -0.0125 -75 -25 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Days) show
87.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 .01472 m
.00625 .01472 L
s
[(0)] -0.0125 .01472 1 0 Mshowa
0 .13995 m
.00625 .13995 L
s
[(0.5)] -0.0125 .13995 1 0 Mshowa
0 .26518 m
.00625 .26518 L
s
[(1)] -0.0125 .26518 1 0 Mshowa
0 .39042 m
.00625 .39042 L
s
[(1.5)] -0.0125 .39042 1 0 Mshowa
0 .51565 m
.00625 .51565 L
s
[(2)] -0.0125 .51565 1 0 Mshowa
.125 Mabswid
0 .03976 m
.00375 .03976 L
s
0 .06481 m
.00375 .06481 L
s
0 .08986 m
.00375 .08986 L
s
0 .1149 m
.00375 .1149 L
s
0 .165 m
.00375 .165 L
s
0 .19004 m
.00375 .19004 L
s
0 .21509 m
.00375 .21509 L
s
0 .24014 m
.00375 .24014 L
s
0 .29023 m
.00375 .29023 L
s
0 .31528 m
.00375 .31528 L
s
0 .34033 m
.00375 .34033 L
s
0 .36537 m
.00375 .36537 L
s
0 .41547 m
.00375 .41547 L
s
0 .44051 m
.00375 .44051 L
s
0 .46556 m
.00375 .46556 L
s
0 .49061 m
.00375 .49061 L
s
0 .5407 m
.00375 .5407 L
s
0 .56575 m
.00375 .56575 L
s
0 .5908 m
.00375 .5908 L
s
0 .61584 m
.00375 .61584 L
s
.25 Mabswid
0 0 m
0 .61803 L
s
gsave
-0.01875 .30902 -141 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
117 10 translate
90 rotate
-117 -10 translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(EAE) show
87.000 13.000 moveto
(severity) show
141.000 13.000 moveto
(index) show
171.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.001 w
.02381 .01472 m
.07143 .01472 L
.11905 .07483 L
.16667 .10238 L
.21429 .12743 L
.2619 .12743 L
.30952 .26518 L
.35714 .39042 L
.40476 .60332 L
.45238 .51565 L
.5 .39042 L
.54762 .35285 L
.59524 .35285 L
.64286 .35285 L
.69048 .35285 L
.7381 .35285 L
.78571 .35285 L
.83333 .35285 L
.88095 .08986 L
.92857 .01472 L
.97619 .01472 L
s
.0001 w
.02381 .01472 0 5 Mabsadd m
.02381 .01472 -4.33 -2.5 Mabsadd L
.02381 .01472 4.33 -2.5 Mabsadd L
.02381 .01472 0 5 Mabsadd L closepath F
.07143 .01472 0 5 Mabsadd m
.07143 .01472 -4.33 -2.5 Mabsadd L
.07143 .01472 4.33 -2.5 Mabsadd L
.07143 .01472 0 5 Mabsadd L closepath F
.11905 .07483 0 5 Mabsadd m
.11905 .07483 -4.33 -2.5 Mabsadd L
.11905 .07483 4.33 -2.5 Mabsadd L
.11905 .07483 0 5 Mabsadd L closepath F
.16667 .10238 0 5 Mabsadd m
.16667 .10238 -4.33 -2.5 Mabsadd L
.16667 .10238 4.33 -2.5 Mabsadd L
.16667 .10238 0 5 Mabsadd L closepath F
.21429 .12743 0 5 Mabsadd m
.21429 .12743 -4.33 -2.5 Mabsadd L
.21429 .12743 4.33 -2.5 Mabsadd L
.21429 .12743 0 5 Mabsadd L closepath F
.2619 .12743 0 5 Mabsadd m
.2619 .12743 -4.33 -2.5 Mabsadd L
.2619 .12743 4.33 -2.5 Mabsadd L
.2619 .12743 0 5 Mabsadd L closepath F
.30952 .26518 0 5 Mabsadd m
.30952 .26518 -4.33 -2.5 Mabsadd L
.30952 .26518 4.33 -2.5 Mabsadd L
.30952 .26518 0 5 Mabsadd L closepath F
.35714 .39042 0 5 Mabsadd m
.35714 .39042 -4.33 -2.5 Mabsadd L
.35714 .39042 4.33 -2.5 Mabsadd L
.35714 .39042 0 5 Mabsadd L closepath F
.40476 .60332 0 5 Mabsadd m
.40476 .60332 -4.33 -2.5 Mabsadd L
.40476 .60332 4.33 -2.5 Mabsadd L
.40476 .60332 0 5 Mabsadd L closepath F
.45238 .51565 0 5 Mabsadd m
.45238 .51565 -4.33 -2.5 Mabsadd L
.45238 .51565 4.33 -2.5 Mabsadd L
.45238 .51565 0 5 Mabsadd L closepath F
.5 .39042 0 5 Mabsadd m
.5 .39042 -4.33 -2.5 Mabsadd L
.5 .39042 4.33 -2.5 Mabsadd L
.5 .39042 0 5 Mabsadd L closepath F
.54762 .35285 0 5 Mabsadd m
.54762 .35285 -4.33 -2.5 Mabsadd L
.54762 .35285 4.33 -2.5 Mabsadd L
.54762 .35285 0 5 Mabsadd L closepath F
.59524 .35285 0 5 Mabsadd m
.59524 .35285 -4.33 -2.5 Mabsadd L
.59524 .35285 4.33 -2.5 Mabsadd L
.59524 .35285 0 5 Mabsadd L closepath F
.64286 .35285 0 5 Mabsadd m
.64286 .35285 -4.33 -2.5 Mabsadd L
.64286 .35285 4.33 -2.5 Mabsadd L
.64286 .35285 0 5 Mabsadd L closepath F
.69048 .35285 0 5 Mabsadd m
.69048 .35285 -4.33 -2.5 Mabsadd L
.69048 .35285 4.33 -2.5 Mabsadd L
.69048 .35285 0 5 Mabsadd L closepath F
.7381 .35285 0 5 Mabsadd m
.7381 .35285 -4.33 -2.5 Mabsadd L
.7381 .35285 4.33 -2.5 Mabsadd L
.7381 .35285 0 5 Mabsadd L closepath F
.78571 .35285 0 5 Mabsadd m
.78571 .35285 -4.33 -2.5 Mabsadd L
.78571 .35285 4.33 -2.5 Mabsadd L
.78571 .35285 0 5 Mabsadd L closepath F
.83333 .35285 0 5 Mabsadd m
.83333 .35285 -4.33 -2.5 Mabsadd L
.83333 .35285 4.33 -2.5 Mabsadd L
.83333 .35285 0 5 Mabsadd L closepath F
.88095 .08986 0 5 Mabsadd m
.88095 .08986 -4.33 -2.5 Mabsadd L
.88095 .08986 4.33 -2.5 Mabsadd L
.88095 .08986 0 5 Mabsadd L closepath F
.92857 .01472 0 5 Mabsadd m
.92857 .01472 -4.33 -2.5 Mabsadd L
.92857 .01472 4.33 -2.5 Mabsadd L
.92857 .01472 0 5 Mabsadd L closepath F
.97619 .01472 0 5 Mabsadd m
.97619 .01472 -4.33 -2.5 Mabsadd L
.97619 .01472 4.33 -2.5 Mabsadd L
.97619 .01472 0 5 Mabsadd L closepath F
.001 w
[ .5 3 ] 0 Mabsdash
.02381 .01472 m
.07143 .01472 L
.11905 .07483 L
.16667 .10238 L
.21429 .12743 L
.2619 .12743 L
.30952 .26518 L
.35714 .26518 L
.40476 .26518 L
.45238 .30276 L
.5 .22135 L
.54762 .13995 L
.59524 .10238 L
.64286 .06481 L
.69048 .06481 L
.7381 .06481 L
.78571 .06481 L
.83333 .01472 L
.88095 .01472 L
.92857 .01472 L
.97619 .01472 L
s
.0001 w
[ ] 0 setdash
.02381 .01472 0 6.25 Mabsadd m
.02381 .01472 -1.41294 1.94475 Mabsadd L
.02381 .01472 -5.94411 1.93136 Mabsadd L
.02381 .01472 -2.28619 -0.74283 Mabsadd L
.02381 .01472 -3.67366 -5.05636 Mabsadd L
.02381 .01472 0 -2.40384 Mabsadd L
.02381 .01472 3.67366 -5.05636 Mabsadd L
.02381 .01472 2.28619 -0.74283 Mabsadd L
.02381 .01472 5.94411 1.93136 Mabsadd L
.02381 .01472 1.41294 1.94475 Mabsadd L
.02381 .01472 0 6.25 Mabsadd L closepath F
.07143 .01472 0 6.25 Mabsadd m
.07143 .01472 -1.41294 1.94475 Mabsadd L
.07143 .01472 -5.94411 1.93136 Mabsadd L
.07143 .01472 -2.28619 -0.74283 Mabsadd L
.07143 .01472 -3.67366 -5.05636 Mabsadd L
.07143 .01472 0 -2.40384 Mabsadd L
.07143 .01472 3.67366 -5.05636 Mabsadd L
.07143 .01472 2.28619 -0.74283 Mabsadd L
.07143 .01472 5.94411 1.93136 Mabsadd L
.07143 .01472 1.41294 1.94475 Mabsadd L
.07143 .01472 0 6.25 Mabsadd L closepath F
.11905 .07483 0 6.25 Mabsadd m
.11905 .07483 -1.41294 1.94475 Mabsadd L
.11905 .07483 -5.94411 1.93136 Mabsadd L
.11905 .07483 -2.28619 -0.74283 Mabsadd L
.11905 .07483 -3.67366 -5.05636 Mabsadd L
.11905 .07483 0 -2.40384 Mabsadd L
.11905 .07483 3.67366 -5.05636 Mabsadd L
.11905 .07483 2.28619 -0.74283 Mabsadd L
.11905 .07483 5.94411 1.93136 Mabsadd L
.11905 .07483 1.41294 1.94475 Mabsadd L
.11905 .07483 0 6.25 Mabsadd L closepath F
.16667 .10238 0 6.25 Mabsadd m
.16667 .10238 -1.41294 1.94475 Mabsadd L
.16667 .10238 -5.94411 1.93136 Mabsadd L
.16667 .10238 -2.28619 -0.74283 Mabsadd L
.16667 .10238 -3.67366 -5.05636 Mabsadd L
.16667 .10238 0 -2.40384 Mabsadd L
.16667 .10238 3.67366 -5.05636 Mabsadd L
.16667 .10238 2.28619 -0.74283 Mabsadd L
.16667 .10238 5.94411 1.93136 Mabsadd L
.16667 .10238 1.41294 1.94475 Mabsadd L
.16667 .10238 0 6.25 Mabsadd L closepath F
.21429 .12743 0 6.25 Mabsadd m
.21429 .12743 -1.41294 1.94475 Mabsadd L
.21429 .12743 -5.94411 1.93136 Mabsadd L
.21429 .12743 -2.28619 -0.74283 Mabsadd L
.21429 .12743 -3.67366 -5.05636 Mabsadd L
.21429 .12743 0 -2.40384 Mabsadd L
.21429 .12743 3.67366 -5.05636 Mabsadd L
.21429 .12743 2.28619 -0.74283 Mabsadd L
.21429 .12743 5.94411 1.93136 Mabsadd L
.21429 .12743 1.41294 1.94475 Mabsadd L
.21429 .12743 0 6.25 Mabsadd L closepath F
.2619 .12743 0 6.25 Mabsadd m
.2619 .12743 -1.41294 1.94475 Mabsadd L
.2619 .12743 -5.94411 1.93136 Mabsadd L
.2619 .12743 -2.28619 -0.74283 Mabsadd L
.2619 .12743 -3.67366 -5.05636 Mabsadd L
.2619 .12743 0 -2.40384 Mabsadd L
.2619 .12743 3.67366 -5.05636 Mabsadd L
.2619 .12743 2.28619 -0.74283 Mabsadd L
.2619 .12743 5.94411 1.93136 Mabsadd L
.2619 .12743 1.41294 1.94475 Mabsadd L
.2619 .12743 0 6.25 Mabsadd L closepath F
.30952 .26518 0 6.25 Mabsadd m
.30952 .26518 -1.41294 1.94475 Mabsadd L
.30952 .26518 -5.94411 1.93136 Mabsadd L
.30952 .26518 -2.28619 -0.74283 Mabsadd L
.30952 .26518 -3.67366 -5.05636 Mabsadd L
.30952 .26518 0 -2.40384 Mabsadd L
.30952 .26518 3.67366 -5.05636 Mabsadd L
.30952 .26518 2.28619 -0.74283 Mabsadd L
.30952 .26518 5.94411 1.93136 Mabsadd L
.30952 .26518 1.41294 1.94475 Mabsadd L
.30952 .26518 0 6.25 Mabsadd L closepath F
.35714 .26518 0 6.25 Mabsadd m
.35714 .26518 -1.41294 1.94475 Mabsadd L
.35714 .26518 -5.94411 1.93136 Mabsadd L
.35714 .26518 -2.28619 -0.74283 Mabsadd L
.35714 .26518 -3.67366 -5.05636 Mabsadd L
.35714 .26518 0 -2.40384 Mabsadd L
.35714 .26518 3.67366 -5.05636 Mabsadd L
.35714 .26518 2.28619 -0.74283 Mabsadd L
.35714 .26518 5.94411 1.93136 Mabsadd L
.35714 .26518 1.41294 1.94475 Mabsadd L
.35714 .26518 0 6.25 Mabsadd L closepath F
.40476 .26518 0 6.25 Mabsadd m
.40476 .26518 -1.41294 1.94475 Mabsadd L
.40476 .26518 -5.94411 1.93136 Mabsadd L
.40476 .26518 -2.28619 -0.74283 Mabsadd L
.40476 .26518 -3.67366 -5.05636 Mabsadd L
.40476 .26518 0 -2.40384 Mabsadd L
.40476 .26518 3.67366 -5.05636 Mabsadd L
.40476 .26518 2.28619 -0.74283 Mabsadd L
.40476 .26518 5.94411 1.93136 Mabsadd L
.40476 .26518 1.41294 1.94475 Mabsadd L
.40476 .26518 0 6.25 Mabsadd L closepath F
.45238 .30276 0 6.25 Mabsadd m
.45238 .30276 -1.41294 1.94475 Mabsadd L
.45238 .30276 -5.94411 1.93136 Mabsadd L
.45238 .30276 -2.28619 -0.74283 Mabsadd L
.45238 .30276 -3.67366 -5.05636 Mabsadd L
.45238 .30276 0 -2.40384 Mabsadd L
.45238 .30276 3.67366 -5.05636 Mabsadd L
.45238 .30276 2.28619 -0.74283 Mabsadd L
.45238 .30276 5.94411 1.93136 Mabsadd L
.45238 .30276 1.41294 1.94475 Mabsadd L
.45238 .30276 0 6.25 Mabsadd L closepath F
.5 .22135 0 6.25 Mabsadd m
.5 .22135 -1.41294 1.94475 Mabsadd L
.5 .22135 -5.94411 1.93136 Mabsadd L
.5 .22135 -2.28619 -0.74283 Mabsadd L
.5 .22135 -3.67366 -5.05636 Mabsadd L
.5 .22135 0 -2.40384 Mabsadd L
.5 .22135 3.67366 -5.05636 Mabsadd L
.5 .22135 2.28619 -0.74283 Mabsadd L
.5 .22135 5.94411 1.93136 Mabsadd L
.5 .22135 1.41294 1.94475 Mabsadd L
.5 .22135 0 6.25 Mabsadd L closepath F
.54762 .13995 0 6.25 Mabsadd m
.54762 .13995 -1.41294 1.94475 Mabsadd L
.54762 .13995 -5.94411 1.93136 Mabsadd L
.54762 .13995 -2.28619 -0.74283 Mabsadd L
.54762 .13995 -3.67366 -5.05636 Mabsadd L
.54762 .13995 0 -2.40384 Mabsadd L
.54762 .13995 3.67366 -5.05636 Mabsadd L
.54762 .13995 2.28619 -0.74283 Mabsadd L
.54762 .13995 5.94411 1.93136 Mabsadd L
.54762 .13995 1.41294 1.94475 Mabsadd L
.54762 .13995 0 6.25 Mabsadd L closepath F
.59524 .10238 0 6.25 Mabsadd m
.59524 .10238 -1.41294 1.94475 Mabsadd L
.59524 .10238 -5.94411 1.93136 Mabsadd L
.59524 .10238 -2.28619 -0.74283 Mabsadd L
.59524 .10238 -3.67366 -5.05636 Mabsadd L
.59524 .10238 0 -2.40384 Mabsadd L
.59524 .10238 3.67366 -5.05636 Mabsadd L
.59524 .10238 2.28619 -0.74283 Mabsadd L
.59524 .10238 5.94411 1.93136 Mabsadd L
.59524 .10238 1.41294 1.94475 Mabsadd L
.59524 .10238 0 6.25 Mabsadd L closepath F
.64286 .06481 0 6.25 Mabsadd m
.64286 .06481 -1.41294 1.94475 Mabsadd L
.64286 .06481 -5.94411 1.93136 Mabsadd L
.64286 .06481 -2.28619 -0.74283 Mabsadd L
.64286 .06481 -3.67366 -5.05636 Mabsadd L
.64286 .06481 0 -2.40384 Mabsadd L
.64286 .06481 3.67366 -5.05636 Mabsadd L
.64286 .06481 2.28619 -0.74283 Mabsadd L
.64286 .06481 5.94411 1.93136 Mabsadd L
.64286 .06481 1.41294 1.94475 Mabsadd L
.64286 .06481 0 6.25 Mabsadd L closepath F
.69048 .06481 0 6.25 Mabsadd m
.69048 .06481 -1.41294 1.94475 Mabsadd L
.69048 .06481 -5.94411 1.93136 Mabsadd L
.69048 .06481 -2.28619 -0.74283 Mabsadd L
.69048 .06481 -3.67366 -5.05636 Mabsadd L
.69048 .06481 0 -2.40384 Mabsadd L
.69048 .06481 3.67366 -5.05636 Mabsadd L
.69048 .06481 2.28619 -0.74283 Mabsadd L
.69048 .06481 5.94411 1.93136 Mabsadd L
.69048 .06481 1.41294 1.94475 Mabsadd L
.69048 .06481 0 6.25 Mabsadd L closepath F
.7381 .06481 0 6.25 Mabsadd m
.7381 .06481 -1.41294 1.94475 Mabsadd L
.7381 .06481 -5.94411 1.93136 Mabsadd L
.7381 .06481 -2.28619 -0.74283 Mabsadd L
.7381 .06481 -3.67366 -5.05636 Mabsadd L
.7381 .06481 0 -2.40384 Mabsadd L
.7381 .06481 3.67366 -5.05636 Mabsadd L
.7381 .06481 2.28619 -0.74283 Mabsadd L
.7381 .06481 5.94411 1.93136 Mabsadd L
.7381 .06481 1.41294 1.94475 Mabsadd L
.7381 .06481 0 6.25 Mabsadd L closepath F
.78571 .06481 0 6.25 Mabsadd m
.78571 .06481 -1.41294 1.94475 Mabsadd L
.78571 .06481 -5.94411 1.93136 Mabsadd L
.78571 .06481 -2.28619 -0.74283 Mabsadd L
.78571 .06481 -3.67366 -5.05636 Mabsadd L
.78571 .06481 0 -2.40384 Mabsadd L
.78571 .06481 3.67366 -5.05636 Mabsadd L
.78571 .06481 2.28619 -0.74283 Mabsadd L
.78571 .06481 5.94411 1.93136 Mabsadd L
.78571 .06481 1.41294 1.94475 Mabsadd L
.78571 .06481 0 6.25 Mabsadd L closepath F
.83333 .01472 0 6.25 Mabsadd m
.83333 .01472 -1.41294 1.94475 Mabsadd L
.83333 .01472 -5.94411 1.93136 Mabsadd L
.83333 .01472 -2.28619 -0.74283 Mabsadd L
.83333 .01472 -3.67366 -5.05636 Mabsadd L
.83333 .01472 0 -2.40384 Mabsadd L
.83333 .01472 3.67366 -5.05636 Mabsadd L
.83333 .01472 2.28619 -0.74283 Mabsadd L
.83333 .01472 5.94411 1.93136 Mabsadd L
.83333 .01472 1.41294 1.94475 Mabsadd L
.83333 .01472 0 6.25 Mabsadd L closepath F
.88095 .01472 0 6.25 Mabsadd m
.88095 .01472 -1.41294 1.94475 Mabsadd L
.88095 .01472 -5.94411 1.93136 Mabsadd L
.88095 .01472 -2.28619 -0.74283 Mabsadd L
.88095 .01472 -3.67366 -5.05636 Mabsadd L
.88095 .01472 0 -2.40384 Mabsadd L
.88095 .01472 3.67366 -5.05636 Mabsadd L
.88095 .01472 2.28619 -0.74283 Mabsadd L
.88095 .01472 5.94411 1.93136 Mabsadd L
.88095 .01472 1.41294 1.94475 Mabsadd L
.88095 .01472 0 6.25 Mabsadd L closepath F
.92857 .01472 0 6.25 Mabsadd m
.92857 .01472 -1.41294 1.94475 Mabsadd L
.92857 .01472 -5.94411 1.93136 Mabsadd L
.92857 .01472 -2.28619 -0.74283 Mabsadd L
.92857 .01472 -3.67366 -5.05636 Mabsadd L
.92857 .01472 0 -2.40384 Mabsadd L
.92857 .01472 3.67366 -5.05636 Mabsadd L
.92857 .01472 2.28619 -0.74283 Mabsadd L
.92857 .01472 5.94411 1.93136 Mabsadd L
.92857 .01472 1.41294 1.94475 Mabsadd L
.92857 .01472 0 6.25 Mabsadd L closepath F
.97619 .01472 0 6.25 Mabsadd m
.97619 .01472 -1.41294 1.94475 Mabsadd L
.97619 .01472 -5.94411 1.93136 Mabsadd L
.97619 .01472 -2.28619 -0.74283 Mabsadd L
.97619 .01472 -3.67366 -5.05636 Mabsadd L
.97619 .01472 0 -2.40384 Mabsadd L
.97619 .01472 3.67366 -5.05636 Mabsadd L
.97619 .01472 2.28619 -0.74283 Mabsadd L
.97619 .01472 5.94411 1.93136 Mabsadd L
.97619 .01472 1.41294 1.94475 Mabsadd L
.97619 .01472 0 6.25 Mabsadd L closepath F
MathSubEnd
P
% End of sub-graphic
0 g
.71346 .08175 m
.71346 .2788 L
.97619 .2788 L
.97619 .08175 L
F
1 g
.71346 .08175 m
.71346 .2788 L
.97619 .2788 L
.97619 .08175 L
F
0 g
.001 w
[ ] 0 setdash
.71346 .08175 m
.97619 .08175 L
.97619 .2788 L
.71346 .2788 L
.71346 .08175 L
s
% Start of sub-graphic
p
0.713465 0.0817523 0.97619 0.278797 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0297619 0.297619 0.0297619 0.297619 [
[ 0 0 0 0 ]
[ 1 .75 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .75 L
0 .75 L
closepath
clip
newpath
% Start of sub-graphic
p
0.0535714 0.0535714 0.35119 0.35119 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.00468 w
[ .5 3 ] 0 Mabsdash
0 .5 m
1 .5 L
s
.00047 w
[ ] 0 setdash
.5 .5 0 6.25 Mabsadd m
.5 .5 -1.41294 1.94475 Mabsadd L
.5 .5 -5.94411 1.93136 Mabsadd L
.5 .5 -2.28619 -0.74283 Mabsadd L
.5 .5 -3.67366 -5.05636 Mabsadd L
.5 .5 0 -2.40384 Mabsadd L
.5 .5 3.67366 -5.05636 Mabsadd L
.5 .5 2.28619 -0.74283 Mabsadd L
.5 .5 5.94411 1.93136 Mabsadd L
.5 .5 1.41294 1.94475 Mabsadd L
.5 .5 0 6.25 Mabsadd L closepath F
MathSubEnd
P
% End of sub-graphic
0 g
gsave
.38988 .20238 -61 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Trattati) show
111.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
% Start of sub-graphic
p
0.0535714 0.39881 0.35119 0.696429 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.00468 w
[ ] 0 setdash
0 .5 m
1 .5 L
s
.00047 w
.5 .5 0 5 Mabsadd m
.5 .5 -4.33 -2.5 Mabsadd L
.5 .5 4.33 -2.5 Mabsadd L
.5 .5 0 5 Mabsadd L closepath F
MathSubEnd
P
% End of sub-graphic
0 g
gsave
.38988 .54762 -61 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Non) show
87.000 13.000 moveto
(trattati) show
135.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
MathSubEnd
P
% End of sub-graphic
0 0 m
1 0 L
1 .42623 L
0 .42623 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[16]:=",
  ImageSize->{400, 170.438},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006@0000ZR000`400?l00000o`00003ooooooonA
ooooo`00oooooonAooooo`00oooooonAooooo`00oooooonAooooo`00oooooonAooooo`00oooooonA
ooooo`00WOooool3o`000?3ooooo002Nooooo`03o`000?oooooooooo0>oooooo002Aooooo`Co0000
0oooool4o`0000?ooooo00Co0000oooooooooooooooo1?l0003Yooooo`00T_ooool01_l0003ooooo
ooooool0003oooooo`0000;ooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`05oooo
o`03o`000?oooooooooo0>Kooooo002Booooo`04o`000?ooooooooooo`0000;ooooo0ol00003oooo
o`03o`000?oooooo000000?ooooo0ol0003Yooooo`00T_ooool01_l0003oooooooooool0003ooooo
o`0000;ooooo00Oo0000ooooooooooooooooo`000?oooooo000000;ooooo00?o0000ooooooooool0
j_ooool009;ooooo00Co0000oooooooooooo00000_ooool2o`0000?ooooo0_l000000ooooooo0000
o`000002ooooo`Co0000j?ooool009;ooooo00Co0000oooooooooooo0000n_ooool0097ooooo1?l0
003kooooo`00oooooonAooooo`00oooooonAooooo`00;_ooool3o`0000Cooooo0_l0000/ooooo`?o
00000oooool3o`0002_ooooo1Ol00003ooooo`;o0000:oooool5o`0000;ooooo0ol0000/ooooo`?o
00001?ooool2o`0008Gooooo000_ooooo`03o`000?oooooooooo00;ooooo00Co0000oooooooooooo
0000;?ooool01Ol0003ooooooooooooooooo000000?ooooo00?o0000ooooooooool0:Oooool01?l0
003oooooooooool00002ooooo`04o`000?ooooooooooo`0002_ooooo00Ko0000oooooooooooo0000
ooooool00003ooooo`03o`000?oooooooooo02Sooooo00Go0000ooooooooooooooooo`000002oooo
o`04o`000?ooooooooooo`0008Cooooo000_ooooo`03o`000?oooooooooo00;ooooo00Co0000oooo
oooooooo0000;?ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo02[ooooo00?o0000
ooooooooool00_ooool01?l0003oooooooooool0000/ooooo`03o`000?oooooooooo00Gooooo00?o
0000ooooooooool0;?ooool01?l0003oooooooooool00002ooooo`03o`000?oooooooooo08;ooooo
000_ooooo`03o`000?oooooooooo00;ooooo00Co0000oooooooooooo0000;?ooool00ol0003ooooo
ooooo`05ooooo`03o`000?oooooooooo02_ooooo00Go0000ooooooooooooooooo`000002ooooo`03
o`000?oooooooooo02_ooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`0Zooooo`;o
00000oooool01?l0003oooooooooool00024ooooo`00;oooool00ol0003oooooooooo`02ooooo`04
o`000?ooooooooooo`0002cooooo00Co0000oooooooooooooooo1?l0000[ooooo`05o`000?oooooo
ooooooooool000000_ooool01?l0003oooooooooool0000Zooooo`06o`000?ooooooooooooooool0
003ooooo1?l0000_ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000ooooooooool0P_ooool0
02kooooo0_l00004ooooo`04o`000?ooooooooooo`0002_ooooo0_l00003ooooo`03o`000?oooooo
oooo02cooooo00Go0000ooooooooooooooooo`000002ooooo`04o`000?ooooooooooo`0002[ooooo
00Oo0000ooooooooooooooooo`000?oooooo000002kooooo00Go0000ooooooooooooooooo`000002
ooooo`04o`000?ooooooooooo`0008Cooooo000_ooooo`03o`000?oooooooooo00?ooooo0_l0000]
ooooo`04o`000?ooooooooooooooo`Go0000:oooool3o`0000Cooooo0_l0000/ooooo`?o00000_oo
ool5o`0002_ooooo0ol00004ooooo`;o0000QOooool00?ooooooTOooool00?ooooooTOooool00?oo
ooooTOooool00?ooooooTOooool002kooooogol00023ooooo`009oooool2o`0000Gooooo00?o0000
ooooool000001Ol00005ooooo`Ko00001oooool00ol0003oooooooooo`08ooooo`03o`000?oooooo
oooo00Oooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooo
oooo00Oooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`07ooooo`03o`000?oooooo
oooo00Sooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`07ooooo`03o`000?oooooo
oooo00Sooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`08ooooo`03o`000?oooooo
oooo00Sooooo00?o0000ooooooooool01?ooool6o`0000Gooooo1_l00005ooooo`Ko00001?ooool6
o`0008Kooooo000Vooooo`04o`000?ooooooooooo`0000Cooooo2Ol00002ooooo`Wo0000Xoooool5
o`0000Gooooo1Ol00004ooooo`Wo00000_ooool8o`0008Gooooo000Vooooo`04o`000?oooooooooo
o`0000Cooooo5?l0002Rooooo`Oo00000_ooool9o`0000;ooooo4ol00025ooooo`009_ooool01?l0
003oooooooooool00004ooooo`[o00000_ooool8o`000:7ooooo2Ol00002ooooo`Wo000000?ooooo
o`000?l000001ol00002ooooo`Wo0000Q?ooool002Kooooo00Co0000oooooooooooo00001?oooolE
o`0009oooooo:ol0000?ooooofWo00002oooool002Kooooo00Co0000oooooooooooo00001?ooool0
1?l0003oooooooooooooool3o`0000Oooooo1Ol0002Sooooo`03o`000?oooooo000000;o00001ooo
ool3o`0000Sooooo0ol00008ooooo`?o00004oooool00ol0003oooooooooo`1Uooooo`03o`000?oo
oooooooo00Wooooo000Wooooo`;o00001Oooool01?l0003oooooooooooooool2o`0000Wooooo0_l0
0002ooooo`03o`000?oooooooooo0:;ooooo0ol00008ooooo`;o00001oooool4o`0000Sooooo0_l0
000Dooooo`03o`000?oooooooooo06Gooooo00?o0000ooooooooool02Oooool002kooooo00?o0000
ooooooooool00_ooool00ol0003oooooooooo`07ooooo`;o00000_ooool00ol0003oooooooooo`2S
ooooo`03o`000?oooooooooo00Oooooo0_l00006ooooo`04o`000?ooooooooooo`0000[ooooo00?o
0000ooooooooool04_ooool00ol0003oooooooooo`1Uooooo`03o`000?oooooooooo00Wooooo000^
ooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool0WOooool00ol0003oooooooooo`02
ooooo`03o`000?oooooooooo00oooooo00Co0000oooooooooooo00007oooool00ol0003ooooooooo
o`1Uooooo`03o`000?oooooooooo00Wooooo000^ooooo`03o`000?oooooooooo01;ooooo00?o0000
ooooooooool0Loooool2o`0000Wooooo00?o0000ooooooooool00oooool01?l0003ooooooooooooo
ool2o`0000Gooooo00Co0000oooooooooooooooo0_l0000Mooooo`03o`000?oooooooooo027ooooo
00?o0000ooooooooool0IOooool00ol0003oooooooooo`09ooooo`00;_ooool00ol0003ooooooooo
o`0Booooo`;o0000M?ooool3o`0000?ooooo00?o0000ooooooooool00_ooool2o`0000?ooooo0_l0
0004ooooo`;o00000oooool2o`0000?ooooo0ol00003ooooo`;o00005oooool00ol0003ooooooooo
o`0Qooooo`03o`000?oooooooooo06Gooooo00?o0000ooooooooool02Oooool002kooooo00?o0000
ooooooooool04oooool00ol0003oooooooooo`1cooooo`?o000000?oooooo`000?l000001Oooool2
o`000004ooooool0003o0000o`0000Cooooo0ol000000ooooooo0000o`000005ooooo`?o000000?o
ooooo`000?l000005oooool00ol0003oooooooooo`0Rooooo`03o`000?oooooooooo06Gooooo00?o
0000ooooooooool02Oooool002kooooo00?o0000ooooooooool04oooool2o`0000Gooooo00?o0000
ooooooooool0K?ooool5o`0000Kooooo1Ol00005ooooo`Ko00001Oooool5o`0001Oooooo00?o0000
ooooooooool08oooool00ol0003oooooooooo`1Uooooo`03o`000?oooooooooo00Wooooo000^oooo
o`03o`000?oooooooooo01Cooooo0ol000001?oooooo0000o`000?l0001^ooooo`Go00000_ooool2
o`0000;ooooo1Ol00002ooooo`03o`000?oooooooooo00Ko000000?oooooo`000?l000000_ooool5
o`0001Oooooo00?o0000ooooooooool08oooool00ol0003oooooooooo`1Uooooo`03o`000?oooooo
oooo00Wooooo000^ooooo`03o`000?oooooooooo01?ooooo2?l0001]ooooo`So00000oooool8o`00
00?ooooo1ol00003ooooo`So00005?ooool00ol0003oooooooooo`0Tooooo`03o`000?oooooooooo
06Gooooo00?o0000ooooooooool02Oooool001Gooooo1Ol0000Dooooo`03o`000?oooooooooo01Co
oooo1ol0001/ooooob_o00004_ooool00ol0003oooooooooo`0Tooooo`03o`000?oooooooooo06Go
oooo00?o0000ooooooooool02Oooool001Kooooo00Co0000oooooooooooo00005?ooool00ol0003o
ooooooooo`0Dooooo`Oo0000Koooool3o`0000Sooooo0ol00008ooooo`;o00002?ooool3o`0001Ko
oooo00?o0000ooooooooool09Oooool00ol0003oooooooooo`1Uooooo`03o`000?oooooooooo00Wo
oooo000Fooooo`03o`000?oooooooooo01Gooooo00?o0000ooooooooool04_ooool;o`0006[ooooo
00Co0000oooooooooooooooo0_l00008ooooo`?o00002?ooool2o`0000Wooooo0_l0000?ooooo`Wo
00009_ooool00ol0003oooooooooo`1Uooooo`03o`000?oooooooooo00Wooooo000Fooooo`?o0000
5Oooool00ol0003oooooooooo`0Eooooo`So000000?oooooo`000?l000001?ooool00ol0003ooooo
ooooo`1Fooooo`;o00001Oooool00ol0003oooooooooo`04ooooo`;o00002Oooool00ol0003ooooo
ooooo`08ooooo`03o`000?oooooooooo00Oooooo0_l0000@ooooo`So00009_ooool00ol0003ooooo
ooooo`1Uooooo`03o`000?oooooooooo00Wooooo000Fooooo`03o`000?oooooooooo01Gooooo00?o
0000ooooooooool05_ooool3o`0000Cooooo1Ol000000ooooooo0000o`00001Iooooo`?o000000?o
ooooo`000?l000000_l00005ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool04_oo
ool00ol0003oooooooooo`0@ooooo`Ko00009oooool00ol0003oooooooooo`1Uooooo`03o`000?oo
oooooooo00Wooooo000Fooooo`04o`000?ooooooooooo`0001Cooooo00?o0000ooooooooool05_oo
ool3o`0000Cooooo2Ol0001Hooooo`Ko00004_ooool00ol0003oooooooooo`0Uooooo`Ko00009ooo
ool00ol0003oooooooooo`1Uooooo`03o`000?oooooooooo00Wooooo000Eooooo`Ko00004oooool0
0ol0003oooooooooo`0Gooooo`03o`000?oooooooooo00Cooooo2?l0001Iooooo`Go0000>oooool4
o`0002Sooooo00?o0000ooooooooool03_ooool2o`0000Gooooo00?o0000ooooooooool0COooool0
0ol0003oooooooooo`09ooooo`005Oooool01Ol0003ooooooooooooooooo000001Cooooo00?o0000
ooooooooool05oooool00ol0003oooooooooo`05ooooo`Oo0000F?ooool7o`0003[ooooo1?l0000X
ooooo`03o`000?oooooooooo00oooooo0ol000001?oooooo0000o`000?l0001?ooooo`03o`000?oo
oooooooo00Wooooo000Eooooo`Go00005?ooool00ol0003oooooooooo`0Nooooo`Wo00000_ooool0
0ol0003oooooooooo`03ooooo`04o`000?ooooooooooooooo`;o00001Oooool00ol0003ooooooooo
o`10ooooo`Wo0000>_ooool2o`0002Wooooo00?o0000ooooooooool03oooool6o`0001Cooooo0ol0
0002ooooo`?o00001?ooool4o`0000?ooooo0_l00004ooooo`;o00000oooool4o`0000?ooooo0_l0
0002ooooo`Go00003_ooool00ol0003oooooooooo`09ooooo`005_ooool00ol0003oooooo`00000E
ooooo`03o`000?oooooooooo01gooooo2ol000000ooooooo0000o`000003ooooo`;o00001?ooool2
o`0000?ooooo0_l00011ooooo`_o0000>Oooool2o`0002Wooooo00?o0000ooooooooool04?ooool5
o`0001Gooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`02ooooo`04o`000?oooooo
ooooo`0000?ooooo00Co0000oooooooooooo00000_ooool01_l0003oooooooooool0003oooooo`00
00;ooooo00Go0000ooooooooooooooooo`000002ooooo`05o`000?ooooooooooooooool000004?oo
ool00ol0003oooooooooo`09ooooo`005_ooool00ol0003oooooo`00000Eooooo`03o`000?oooooo
oooo023ooooo1?l00003ooooo`Go000000Coooooo`000?l0003o00001?ooool3o`000003ooooool0
003o000004Kooooo0ol0000mooooo`03o`000?oooooooooo02Sooooo00?o0000ooooooooool00_oo
ool2o`0000;ooooo00?o0000ooooooooool00_l00002ooooo`03o`000?oooooo000000Ko000000?o
ooooo`000?l000000_ooool00ol0003oooooooooo`02o`0000[ooooo00?o0000ooooooooool00_oo
ool00ol0003oooooooooo`03ooooo`?o00000oooool00ol0003oooooooooo`03ooooo`03o`000?oo
oooooooo00?ooooo0ol00003ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool03_oo
ool00ol0003oooooooooo`09ooooo`005oooool00ol0003oooooooooo`0Dooooo`03o`000?oooooo
oooo027ooooo0_l00005ooooo`Wo00000_ooool8o`0003Sooooo0_l00007ooooo`04o`000?oooooo
ooooooooo`?o0000?Oooool00ol0003oooooooooo`0Xooooo`03o`000?oooooooooo00kooooo2Ol0
000Cooooo`03o`000?oooooooooo00;ooooo0_l00003ooooo`04o`000?ooooooooooo`0000?ooooo
00?o0000ooooooooool00oooool00ol0003oooooooooo`02ooooo`04o`000?ooooooooooo`0000?o
oooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`0>ooooo`03o`000?oooooooooo00Wo
oooo000Eooooo`Go00005?ooool00ol0003oooooooooo`0Qooooo`;o00001_oooolBo`0003Sooooo
0ol00003ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool0??ooool00ol0003ooooo
ooooo`0Xooooo`03o`000?oooooooooo00gooooo2ol0000@ooooo`06o`000?oooooo0000ooooool0
003ooooo0_l000000ooooooo0000o`000002ooooo`;o00000oooool4o`0000;ooooo1?l00003oooo
o`;o00000oooool4o`0000;ooooo0ol0000@ooooo`03o`000?oooooooooo00Wooooo000Fooooo`05
o`000?ooooooooooo`000?ooool00_l00004ooooo`03o`000?oooooooooo00;ooooo0ol00005oooo
o`03o`000?oooooooooo02Wooooo2?l00003ooooo`Oo0000>Oooool3o`000004ooooool0003o0000
o`0000Kooooo00?o0000ooooooooool0>oooool00ol0003oooooooooo`0Yooooo`03o`000?oooooo
oooo013ooooo0ol0000Eooooo`05o`000?oooooo0000ooooool000003_ooool00ol0003ooooooooo
o`03ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool05Oooool00ol0003ooooooooo
o`09ooooo`005_ooool01Ol0003ooooooooooooooooo000000;ooooo00?o0000ooooooooool01Ooo
ool01Ol0003ooooooooooooooooo000000Cooooo00?o0000ooooooooool09ooooolFo`0003Oooooo
1Ol00016ooooo`03o`000?oooooooooo02Wooooo00?o0000ooooooooool04Oooool2o`0001Gooooo
1Ol0000>ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool02Oooool00ol0003ooooo
ooooo`04ooooo`03o`000?oooooooooo00kooooo00?o0000ooooooooool02Oooool001Kooooo0ol0
00001Ooooooo0000oooooooooooo000000_ooooo00?o0000ooooooooool00_ooool2o`0002cooooo
0ol00008ooooo`?o0000>oooool7o`0004Cooooo00?o0000ooooooooool0:Oooool00ol0003ooooo
ooooo`0Aooooo`;o0000D_ooool00ol0003oooooooooo`09ooooo`005_ooool01Ol0003ooooooooo
oooooooo000000;ooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`02ooooo`03o`00
0?oooooooooo02_ooooo0ol00008ooooo`?o0000>_ooool9o`0004?ooooo00?o0000ooooooooool0
:Oooool00ol0003oooooooooo`1Uooooo`03o`000?oooooooooo00Wooooo000Fooooo`03o`000?oo
oooooooo00;o00000_ooool00ol0003oooooooooo`05ooooo`Co00001Oooool00ol0003ooooooooo
o`0/ooooo`03o`000?oooooooooo00Sooooo0ol0000hooooo`_o0000@_ooool00ol0003ooooooooo
o`0Yooooo`03o`000?oooooooooo06Gooooo00?o0000ooooooooool02Oooool001Gooooo1_l00002
ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`0/
ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool0>Oooool3o`0004Kooooo00?o0000
ooooooooool0:_ooool00ol0003oooooooooo`1Uooooo`03o`000?oooooooooo00Wooooo000Koooo
o`;o00002?ooool5o`0000Cooooo00?o0000ooooooooool0;?ooool00ol0003oooooooooo`0:oooo
o`03o`000?oooooooooo03[ooooo0_l00016ooooo`03o`000?oooooooooo02[ooooo00?o0000oooo
ooooool0IOooool00ol0003oooooooooo`09ooooo`00;_ooool00ol0003oooooooooo`0jooooo`03
o`000?oooooooooo03Wooooo0_l00016ooooo`03o`000?oooooooooo02[ooooo00?o0000oooooooo
ool0IOooool00ol0003oooooooooo`09ooooo`00;_ooool00ol0003oooooooooo`0jooooo`03o`00
0?oooooooooo03Kooooo00?o0000ooooooooool0B?ooool00ol0003oooooooooo`0Zooooo`03o`00
0?oooooooooo06Gooooo00?o0000ooooooooool02Oooool002kooooo00?o0000ooooooooool0>_oo
ool00ol0003oooooooooo`21ooooo`03o`000?oooooooooo02[ooooo00?o0000ooooooooool0IOoo
ool00ol0003oooooooooo`09ooooo`00;_ooool00ol0003oooooooooo`0kooooo`03o`000?oooooo
oooo07oooooo00?o0000ooooooooool0:oooool00ol0003oooooooooo`1Uooooo`03o`000?oooooo
oooo00Wooooo000Eooooo`Co00005Oooool00ol0003oooooooooo`0kooooo`03o`000?oooooooooo
03?ooooo00?o0000ooooooooool0BOooool00ol0003oooooooooo`0[ooooo`03o`000?oooooooooo
06Gooooo00?o0000ooooooooool02Oooool001Wooooo00?o0000ooooooooool04_ooool00ol0003o
ooooooooo`0kooooo`03o`000?oooooooooo07oooooo00?o0000ooooooooool0:oooool00ol0003o
ooooooooo`1Uooooo`03o`000?oooooooooo00Wooooo000Fooooo`?o00005Oooool00ol0003ooooo
ooooo`0looooo`03o`000?oooooooooo07kooooo00?o0000ooooooooool0:oooool00ol0003ooooo
ooooo`1Uooooo`03o`000?oooooooooo00Wooooo000Eooooo`03o`000?oooooooooo01Kooooo00?o
0000ooooooooool0??ooool00ol0003oooooooooo`0`ooooo`;o0000C?ooool00ol0003ooooooooo
o`0[ooooo`03o`000?oooooooooo06Gooooo00?o0000ooooooooool02Oooool001Kooooo1?l0000D
ooooo`03o`000?oooooooooo03gooooo00?o0000ooooooooool0OOooool00ol0003oooooooooo`0[
ooooo`03o`000?oooooooooo06Gooooo00?o0000ooooooooool02Oooool002kooooo00?o0000oooo
ooooool0?Oooool00ol0003oooooooooo`0Xooooo`;o00001Oooool00ol0003oooooooooo`1:oooo
o`03o`000?oooooooooo02cooooo00?o0000ooooooooool0IOooool00ol0003oooooooooo`09oooo
o`005_ooool3o`0001Gooooo00?o0000ooooooooool0?Oooool00ol0003oooooooooo`0Yooooo`;o
00000oooool2o`0004cooooo00?o0000ooooooooool0;?ooool00ol0003oooooooooo`1Uooooo`03
o`000?oooooooooo00Wooooo000Eooooo`03o`000?oooooooooo01Kooooo00?o0000ooooooooool0
?_ooool00ol0003oooooooooo`0Xooooo`?o000000?oooooo`000?l00000COooool00ol0003ooooo
ooooo`0/ooooo`03o`000?oooooooooo06Gooooo00?o0000ooooooooool02Oooool001Gooooo1Ol0
000Dooooo`03o`000?oooooooooo03kooooo00?o0000ooooooooool0:Oooool5o`0004gooooo00?o
0000ooooooooool0;?ooool00ol0003oooooooooo`1Uooooo`03o`000?oooooooooo00Wooooo000E
ooooo`05o`000?ooooooooooooooool000005?ooool00ol0003oooooooooo`0nooooo`03o`000?oo
oooooooo02Sooooo1ol0001<ooooo`03o`000?oooooooooo02cooooo00?o0000ooooooooool0IOoo
ool00ol0003oooooooooo`09ooooo`005_ooool3o`0001Gooooo00?o0000ooooooooool0?oooool0
0ol0003oooooooooo`0Vooooo`Wo0000B_ooool00ol0003oooooooooo`0]ooooo`03o`000?oooooo
oooo06Gooooo00?o0000ooooooooool02Oooool002kooooo00?o0000ooooooooool0?oooool00ol0
003oooooooooo`0Uooooo`_o0000BOooool00ol0003oooooooooo`0]ooooo`03o`000?oooooooooo
06Gooooo00?o0000ooooooooool02Oooool001Oooooo00?o0000ooooooooool05?ooool00ol0003o
ooooooooo`0oooooo`03o`000?oooooooooo02Sooooo0ol0001>ooooo`03o`000?oooooooooo02go
oooo00?o0000ooooooooool0IOooool00ol0003oooooooooo`09ooooo`005oooool00ol0003ooooo
ooooo`0Dooooo`03o`000?oooooooooo043ooooo00?o0000ooooooooool0:?ooool2o`0004kooooo
00?o0000ooooooooool0;Oooool00ol0003oooooooooo`1Uooooo`03o`000?oooooooooo00Wooooo
000Fooooo`03o`000?oooooo000001Gooooo00?o0000ooooooooool0@?ooool00ol0003ooooooooo
o`0Yooooo`03o`000?oooooooooo04cooooo00?o0000ooooooooool0;Oooool00ol0003ooooooooo
o`1Uooooo`03o`000?oooooooooo00Wooooo000Fooooo`03o`000?oooooo000001Gooooo00?o0000
ooooooooool0?_ooool3o`0000Oooooo0_l00005ooooo`04o`000?ooooooooooooooo`;o00004ooo
ool2o`00053ooooo00?o0000ooooooooool0;_ooool00ol0003oooooooooo`1Uooooo`03o`000?oo
oooooooo00Wooooo000Eooooo`;o000000?oooooo`000?l000003?ooool3o`0000Gooooo00?o0000
ooooooooool0?_ooool4o`0000;ooooo00?o0000ooooooooool00_ooool2o`0000?ooooo0_l00003
ooooo`?o00000oooool00ol0003oooooooooo`1Nooooo`03o`000?oooooooooo02kooooo00?o0000
ooooooooool0IOooool00ol0003oooooooooo`09ooooo`009oooool00ol0003oooooooooo`04oooo
o`03o`000?oooooooooo03gooooo2Ol00003ooooo`?o000000?oooooo`000?l000001Oooool3o`00
0003ooooool0003o0000063ooooo00?o0000ooooooooool0;_ooool00ol0003oooooooooo`1Uoooo
o`03o`000?oooooooooo00Wooooo000Fooooo`?o00003_ooool00ol0003oooooooooo`04ooooo`03
o`000?oooooooooo03kooooo2?l00004ooooo`Go00001Oooool5o`0000kooooo00?o0000oooooooo
ool0D?ooool00ol0003oooooooooo`0^ooooo`03o`000?oooooooooo06Gooooo00?o0000oooooooo
ool02Oooool001Gooooo00?o0000ooooooooool03oooool00ol0003oooooooooo`04ooooo`;o0000
@?ooool7o`0000;ooooo2Ol00002ooooo`So0000Goooool00ol0003oooooooooo`0^ooooo`03o`00
0?oooooooooo06Gooooo00?o0000ooooooooool02Oooool001Gooooo1Ol0000=ooooo`03o`000?oo
oooooooo00Cooooo00?o0000ooooooooool0?_ooool8o`0000;ooooo2Ol00002ooooo`Wo0000G_oo
ool00ol0003oooooooooo`0^ooooo`03o`000?oooooooooo00kooooo2?l0000Booooo`?o000000Co
ooooo`000?oooooooooo0ol00002ooooo`?o000000?oooooo`000?l000002?ooool2o`0000;ooooo
0ol00004ooooo`Co00000oooool2o`0000Cooooo0_l00003ooooo`Co00000_ooool00ol0003ooooo
ooooo`09ooooo`005Oooool01Ol0003ooooooooooooooooo000000cooooo0_l00006ooooo`03o`00
0?oooooooooo03gooooo8?l00008ooooo`03o`000?oooooooooo057ooooo00?o0000ooooooooool0
;oooool00ol0003oooooooooo`0?ooooo`Oo00004oooool01_l0003oooooooooool0003oooooo`00
00?ooooo00Co0000oooooooooooo00000_ooool00ol0003oooooooooo`06ooooo`04o`000?oooooo
ooooo`0000;ooooo00?o0000ooooooooool00_ooool01?l0003oooooooooool00003ooooo`04o`00
0?ooooooooooo`0000;ooooo00Ko0000oooooooooooo0000ooooool00002ooooo`05o`000?oooooo
ooooooooool000002oooool001Kooooo0ol0000>ooooo`03o`000?oooooooooo00Cooooo00?o0000
ooooooooool0@?ooool4o`0000Oooooo0ol00007ooooo`?o0000HOooool00ol0003oooooooooo`0_
ooooo`03o`000?oooooooooo00;ooooo8?l00007ooooo`06o`000?oooooo0000o`000?oooooo0000
0oooool01?l0003oooooooooool00002ooooo`03o`000?oooooooooo00Kooooo00?o0000oooooooo
ool00oooool00ol0003oooooooooo`03ooooo`?o00000oooool00ol0003oooooooooo`03ooooo`03
o`000?oooooooooo00?ooooo0ol00003ooooo`03o`000?oooooooooo00Wooooo000^ooooo`03o`00
0?oooooooooo047ooooo0ol00007ooooo`?o00002?ooool2o`0000Cooooo00?o0000ooooool00000
1Oooool00ol0003oooooooooo`1Booooo`03o`000?oooooooooo02oooooo00?o0000ooooooooool0
4?ooool5o`0001Cooooo00Ko0000ooooool0003o0000ooooool00003ooooo`04o`000?oooooooooo
o`0000;ooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`03ooooo`;o00000oooool0
1?l0003oooooooooool00003ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool00_oo
ool01?l0003oooooooooool00003ooooo`03o`000?oooooooooo00Wooooo000Eooooo`?o00005_oo
ool00ol0003oooooooooo`11ooooo`;o000000?oooooo`000?ooool01_ooool00ol0003ooooooooo
o`07ooooo`;o00001_ooool2o`0000?ooooo0_l0001Dooooo`03o`000?oooooooooo02oooooo00?o
0000ooooooooool04?ooool4o`0001Gooooo0_l000001?oooooo0000ooooooooool3o`0000;ooooo
1?l00008ooooo`Co00000_ooool2o`000003ooooool0003o000000;ooooo0_l00003ooooo`Co0000
0_ooool4o`0000?ooooo0_l00003ooooo`;o00002oooool001Kooooo00?o0000ooooooooool05Ooo
ool00ol0003oooooooooo`14ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool03ooo
ool3o`000004ooooool0003o0000o`0005Cooooo00?o0000ooooooooool0;oooool00ol0003ooooo
ooooo`0Aooooo`?o00005Oooool2o`000003ooooool0003ooooo01?ooooo00?o0000ooooooooool0
3oooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool0
2Oooool001Kooooo00?o0000ooooooooool05Oooool00ol0003oooooooooo`14ooooo`03o`000?oo
oooooooo01Sooooo1Ol0001Dooooo`03o`000?oooooooooo033ooooo00?o0000ooooooooool04Ooo
ool2o`0001Gooooo0_l000001?oooooo0000o`000?l0000Cooooo`03o`000?oooooooooo00oooooo
00?o0000ooooooooool00oooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo00Wooooo
000Fooooo`;o00005_ooool00ol0003oooooooooo`15ooooo`03o`000?oooooooooo01Oooooo1Ol0
001Dooooo`03o`000?oooooooooo033ooooo00?o0000ooooooooool04_ooool00ol0003ooooooooo
o`1@ooooo`03o`000?oooooooooo00Wooooo000Eooooo`;o000000?oooooo`000?l000005?ooool0
0ol0003oooooooooo`15ooooo`03o`000?oooooooooo01Kooooo2?l0001Booooo`03o`000?oooooo
oooo033ooooo00?o0000ooooooooool0IOooool00ol0003oooooooooo`09ooooo`00;_ooool00ol0
003oooooooooo`15ooooo`03o`000?oooooooooo01Cooooo2ol0001Aooooo`03o`000?oooooooooo
033ooooo00?o0000ooooooooool0IOooool00ol0003oooooooooo`09ooooo`005Oooool5o`0001Co
oooo00?o0000ooooooooool0A_ooool00ol0003oooooooooo`0Gooooo`?o0000EOooool00ol0003o
ooooooooo`0`ooooo`03o`000?oooooooooo06Gooooo00?o0000ooooooooool02Oooool001Oooooo
00?o0000ooooooooool05?ooool00ol0003oooooooooo`16ooooo`03o`000?oooooooooo01Oooooo
0ol0001Dooooo`03o`000?oooooooooo037ooooo00?o0000ooooooooool0IOooool00ol0003ooooo
ooooo`09ooooo`005oooool00ol0003oooooooooo`0Dooooo`03o`000?oooooooooo04Kooooo00?o
0000ooooooooool06?ooool00ol0003oooooooooo`1Cooooo`03o`000?oooooooooo037ooooo00?o
0000ooooooooool0IOooool00ol0003oooooooooo`09ooooo`005oooool00ol0003oooooooooo`0D
ooooo`03o`000?oooooooooo04Oooooo00?o0000ooooooooool05oooool00ol0003oooooooooo`1C
ooooo`03o`000?oooooooooo037ooooo00?o0000ooooooooool0IOooool00ol0003oooooooooo`09
ooooo`005Oooool3o`0001Kooooo00?o0000ooooooooool0Aoooool00ol0003oooooooooo`0Goooo
o`03o`000?oooooooooo05?ooooo00?o0000ooooooooool0<Oooool00ol0003oooooooooo`1Uoooo
o`03o`000?oooooooooo00Wooooo000^ooooo`03o`000?oooooooooo04Sooooo00?o0000oooooooo
ool0K?ooool00ol0003oooooooooo`0aooooo`03o`000?oooooooooo06Gooooo00?o0000oooooooo
ool02Oooool001Oooooo0_l0000Eooooo`03o`000?oooooooooo04Sooooo00?o0000ooooooooool0
Joooool00ol0003oooooooooo`0booooo`03o`000?oooooooooo06Gooooo00?o0000ooooooooool0
2Oooool001Kooooo00Co0000oooooooooooo00005?ooool00ol0003oooooooooo`18ooooo`03o`00
0?oooooooooo02Oooooo2Ol00002ooooo`So00000_ooool9o`0000;ooooo2Ol00002ooooo`So0000
0_ooool9o`0000;ooooo2?l0000aooooo`03o`000?oooooooooo06Gooooo00?o0000ooooooooool0
2Oooool001Kooooo00?o0000ooooooooool05Oooool00ol0003oooooooooo`19ooooo`03o`000?oo
oooooooo02OoooooAol0000aooooo`03o`000?oooooooooo06Gooooo00?o0000ooooooooool02Ooo
ool001Kooooo00?o0000ooooooooool05Oooool00ol0003oooooooooo`19ooooo`03o`000?oooooo
oooo02Sooooo1_l00004ooooo`Ko00001Oooool6o`0000Cooooo1ol00004ooooo`Ko00001Oooool6
o`0000Cooooo1_l0000booooo`03o`000?oooooooooo06Gooooo00?o0000ooooooooool02Oooool0
01Gooooo1?l0000Eooooo`03o`000?oooooooooo04Wooooo00?o0000ooooooooool0:?ooool6o`00
00Gooooo1Ol00006ooooo`Go00001Oooool5o`0000Kooooo1Ol00006ooooo`Go00001Oooool5o`00
03;ooooo00?o0000ooooooooool0IOooool00ol0003oooooooooo`09ooooo`005_ooool00ol0003o
ooooooooo`0Eooooo`03o`000?oooooooooo04[ooooo00?o0000ooooooooool09_ooool00ol0003o
ooooo`000003o`0000Oooooo0ol00007ooooo`Co00001oooool3o`0000Sooooo0ol00007ooooo`Co
00001oooool3o`0003?ooooo00?o0000ooooooooool0IOooool00ol0003oooooooooo`09ooooo`00
5_ooool2o`0001Kooooo00?o0000ooooooooool0B_ooool00ol0003oooooooooo`0Tooooo`;o0000
0oooool2o`0000Sooooo0_l00009ooooo`;o00002?ooool3o`0000Sooooo0_l00009ooooo`;o0000
2?ooool2o`0003Cooooo00?o0000ooooooooool0IOooool00ol0003oooooooooo`09ooooo`005ooo
ool00ol0003oooooooooo`0Dooooo`03o`000?oooooooooo04[ooooo00?o0000ooooooooool08ooo
ool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02?oo
ool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02?oo
ool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo03;oooooJOl0000;ooooo`005_ooool0
1?l0003oooooo`000?ooool3o`0000Cooooo00?o0000ooooooooool00_ooool3o`0000Gooooo00?o
0000ooooooooool0Boooool00ol0003oooooooooo`0Qooooo`03o`000?oooooooooo0>gooooo000F
ooooo`03o`000?oooooo000000;ooooo00?o0000ooooooooool01oooool01Ol0003ooooooooooooo
oooo000000Cooooo00?o0000ooooooooool0B?ooool8o`0001Sooooo2?l0003_ooooo`005Oooool2
o`000005ooooool0003o0000ooooool000003Oooool00ol0003oooooooooo`02ooooo`03o`000?oo
oooooooo04Wooooo1ol0000Iooooo`Oo0000koooool001_ooooo00?o0000ooooooooool02oooool0
0ol0003oooooooooo`02ooooo`;o0000B_ooool6o`0001[ooooo1_l0003`ooooo`006oooool00ol0
003oooooooooo`07ooooo`Co00001Oooool00ol0003oooooooooo`1:ooooo`Go00006oooool5o`00
0?3ooooo000Jooooo`;o00002Oooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo04[o
oooo1?l0000Looooo`Co0000lOooool001_ooooo00?o0000ooooooooool01oooool5o`0000Cooooo
00?o0000ooooooooool0Boooool3o`0001gooooo0ol0003aooooo`00;_ooool00ol0003ooooooooo
o`1;ooooo`?o00007Oooool2o`000?;ooooo000^ooooo`03o`000?oooooooooo04cooooo0_l0000L
ooooo`03o`000?oooooo00000?;ooooo000^ooooo`03o`000?oooooooooo04gooooo00?o0000oooo
ooooool06_ooool00ol0003oooooooooo`3booooo`005Oooool5o`0001Cooooo00?o0000oooooooo
ool0C_ooool00ol0003oooooooooo`0Hooooo`03o`000?oooooooooo0??ooooo000Gooooo`03o`00
0?oooooooooo01Cooooo00?o0000ooooooooool0C_ooool00ol0003oooooooooo`0Hooooo`03o`00
0?oooooooooo0??ooooo000Gooooo`03o`000?oooooooooo01Cooooo00?o0000ooooooooool0C_oo
ool00ol0003oooooooooo`0Hooooo`03o`000?oooooooooo0??ooooo000Gooooo`03o`000?oooooo
oooo01Cooooo00?o0000ooooooooool0C_ooool00ol0003oooooooooo`0Gooooo`03o`000?oooooo
oooo0?Cooooo000Eooooo`?o00005_ooool00ol0003oooooooooo`1>ooooo`03o`000?oooooooooo
01Oooooo00?o0000ooooooooool0m?ooool002kooooo00?o0000ooooooooool0Coooool00ol0003o
ooooooooo`0Eooooo`03o`000?oooooooooo0?Gooooo000Eooooo`?o000000?oooooo`000?l00000
4oooool00ol0003oooooooooo`1?ooooo`03o`000?oooooooooo01Gooooo00?o0000ooooooooool0
mOooool001Kooooo00Co0000oooooooooooo00005?ooool00ol0003oooooooooo`1?ooooo`03o`00
0?oooooooooo01Gooooo00?o0000ooooooooool0mOooool001Kooooo00Co0000oooooooooooo0000
5?ooool00ol0003oooooooooo`1?ooooo`03o`000?oooooooooo01Cooooo00?o0000ooooooooool0
m_ooool001Kooooo00Co0000oooooooooooo00005?ooool00ol0003oooooooooo`1@ooooo`03o`00
0?oooooooooo01?ooooo00?o0000ooooooooool0m_ooool001Gooooo1?l0000Eooooo`03o`000?oo
oooooooo053ooooo00?o0000ooooooooool04oooool00ol0003oooooooooo`3fooooo`00;_ooool0
0ol0003oooooooooo`1@ooooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool0moooool0
01Kooooo1?l0000Dooooo`03o`000?oooooooooo053ooooo00?o0000ooooooooool04_ooool00ol0
003oooooooooo`3gooooo`005Oooool01?l0003oooooooooool0000Eooooo`03o`000?oooooooooo
057ooooo00?o0000ooooooooool04?ooool00ol0003oooooooooo`3hooooo`005Oooool01?l0003o
ooooooooool0000Eooooo`03o`000?oooooooooo057ooooo00?o0000ooooooooool04?ooool00ol0
003oooooooooo`3hooooo`005Oooool01?l0003oooooooooool0000Eooooo`03o`000?oooooooooo
057ooooo00?o0000ooooooooool04?ooool00ol0003oooooooooo`3hooooo`005_ooool3o`0001Go
oooo00?o0000ooooooooool0DOooool00ol0003oooooooooo`0?ooooo`03o`000?oooooooooo0?Wo
oooo000Hooooo`03o`000?oooooooooo01?ooooo00?o0000ooooooooool0D_ooool00ol0003ooooo
ooooo`0>ooooo`03o`000?oooooooooo0?Wooooo000Fooooo`?o00003?ooool5o`0000Cooooo00?o
0000ooooooooool0D_ooool00ol0003oooooooooo`0=ooooo`03o`000?oooooooooo0?[ooooo000E
ooooo`03o`000?oooooooooo00kooooo00Co0000oooooooooooo00001?ooool00ol0003ooooooooo
o`1Booooo`03o`000?oooooooooo00Sooooo2Ol0003iooooo`005Oooool5o`0000gooooo00?o0000
ooooooooool01?ooool00ol0003oooooooooo`1Booooo`03o`000?oooooooooo00Wooooo2?l0003i
ooooo`005Oooool01Ol0003ooooooooooooooooo000000kooooo00?o0000ooooooooool00oooool2
o`0005?ooooo00?o0000ooooooooool02Oooool7o`000?[ooooo000Fooooo`?o00003?ooool01Ol0
003ooooooooooooooooo000000Cooooo00?o0000ooooooooool0Doooool00ol0003oooooooooo`09
ooooo`Go0000noooool002Gooooo00Go0000ooooooooooooooooo`000004ooooo`03o`000?oooooo
oooo05?ooooo00?o0000ooooooooool02Oooool5o`000?_ooooo000Eooooo`;o000000?oooooo`00
0?l000003?ooool3o`0000Gooooo00?o0000ooooooooool0Doooool00ol0003oooooooooo`0:oooo
o`?o0000o?ooool001Kooooo00?o0000ooooool000005Oooool00ol0003oooooooooo`1Cooooo`03
o`000?oooooooooo00Wooooo1?l0003looooo`005oooool00ol0003oooooooooo`0Dooooo`03o`00
0?oooooooooo05Cooooo00?o0000ooooooooool02?ooool00ol0003oooooo`00003mooooo`005_oo
ool00ol0003oooooo`00000Eooooo`03o`000?oooooooooo05Cooooo00?o0000ooooooooool01ooo
ool00ol0003oooooooooo`3nooooo`005Oooool2o`000003ooooool0003o000001Cooooo00?o0000
ooooooooool0E?ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo0?kooooo000^oooo
o`03o`000?oooooooooo05Cooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`3ooooo
o`00;_ooool00ol0003oooooooooo`1Eooooo`03o`000?oooooooooo00Gooooo00?o0000oooooooo
ool0ooooool002kooooo00?o0000ooooooooool0EOooool00ol0003oooooooooo`04ooooo`03o`00
0?oooooooooo0?oooooo0Oooool002kooooo00?o0000ooooooooool0EOooool00ol0003ooooooooo
o`03ooooo`03o`000?oooooooooo0?oooooo0_ooool002kooooo00?o0000ooooooooool0EOooool0
0ol0003oooooooooo`03ooooo`03o`000?oooooooooo0?oooooo0_ooool002kooooo00?o0000oooo
ooooool0EOooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo0?oooooo0oooool002ko
oooo00?o0000ooooooooool0E_ooool01Ol0003ooooooooooooooooo00000?oooooo1Oooool002ko
oooo00?o0000ooooooooool0E_ooool01?l0003oooooooooool0003oooooo`Kooooo000^ooooo`03
o`000?oooooooooo05Kooooo00Co0000oooooooooooo0000ooooool6ooooo`00;_ooool00ol0003o
ooooooooo`1Fooooo`03o`000?oooooo00000?oooooo1oooool002kooooo00?o0000ooooooooool0
D_ooool9o`000?oooooo1Oooool002kooooo00?o0000ooooooooool0Doooool8o`000?oooooo1Ooo
ool002kooooo00?o0000ooooooooool0E?ooool6o`000?oooooo1_ooool002kooooo00?o0000oooo
ooooool0EOooool5o`000?oooooo1_ooool002kooooo00?o0000ooooooooool0EOooool4o`000?oo
oooo1oooool00?ooooooTOooool00?ooooooTOooool00?ooooooTOooool00?ooooooTOooool00001
\
\>"],
  ImageRangeCache->{{{0, 399}, {169.438, 0}} -> {-1.07816, -0.648942, \
0.00765996, 0.00765996}, {{10.1875, 271.25}, {165.375, 4}} -> {5.14751, \
-0.558127, 0.0943279, 0.0179335}, {{284.312, 388.75}, {136.938, 58.5625}} -> \
{-9.24711, -1.14638, 0.0321727, 0.0321727}, {{289.875, 320.938}, {131.312, \
100.188}} -> {-19.6642, -3.45677, 0.064387, 0.064387}, {{289.875, 320.938}, \
{95.25, 64.125}} -> {-19.6642, -5.77873, 0.064387, 0.064387}}]
}, Open  ]],

Cell["\<\
Fine tuning: modifichiamo l'ampiezza della legenda in modo che \
tutto il testo specificato venga visualizzato e aumentiamo il range di \
visualizzazione verticale in modo da visualizzare completamente anche il \
triangolo posizionato pi\[UGrave] in alto:\
\>", "Text",
  PageWidth->PaperWidth],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(MultipleListPlot[untreated, treated, PlotJoined \[Rule] True, 
        SymbolShape \[Rule] {enlarge[PlotSymbol[Triangle], 2], 
            enlarge[PlotSymbol[Star], 2.5]}, 
        Frame \[Rule] {True, True, False, False}, 
        FrameLabel \[Rule] {"\<Days\>", "\<EAE severity index\>"}, 
        PlotLegend \[Rule] {"\<Non trattati\>", "\<Trattati\>"}, 
        LegendSize \[Rule] 1.1, PlotRange \[Rule] All];\)\)], "Input",
  CellLabel->"In[17]:=",
  PageWidth->PaperWidth],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .38627 
%%ImageSize: 400 154.508 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.321429 0.297619 0.193136 0.297619 [
[ 0 0 0 0 ]
[ 1 .38627 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
% Start of sub-graphic
p
0.0238095 0.00919693 0.619048 0.377074 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.452381 0.047619 0.0147151 0.25047 [
[.02381 -0.0125 -6 -9 ]
[.02381 -0.0125 6 0 ]
[.2619 -0.0125 -6 -9 ]
[.2619 -0.0125 6 0 ]
[.5 -0.0125 -6 -9 ]
[.5 -0.0125 6 0 ]
[.7381 -0.0125 -6 -9 ]
[.7381 -0.0125 6 0 ]
[.97619 -0.0125 -6 -9 ]
[.97619 -0.0125 6 0 ]
[ 0 0 -0.125 0 ]
[.5 -0.0125 -14 -21 ]
[.5 -0.0125 14 -9 ]
[-0.0125 .01472 -6 -4.5 ]
[-0.0125 .01472 0 4.5 ]
[-0.0125 .13995 -18 -4.5 ]
[-0.0125 .13995 0 4.5 ]
[-0.0125 .26518 -6 -4.5 ]
[-0.0125 .26518 0 4.5 ]
[-0.0125 .39042 -18 -4.5 ]
[-0.0125 .39042 0 4.5 ]
[-0.0125 .51565 -6 -4.5 ]
[-0.0125 .51565 0 4.5 ]
[ 0 0 -0.125 0 ]
[-0.01875 .30902 -30 -56 ]
[-0.01875 .30902 -18 56 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 0 m
.02381 .00625 L
s
[(10)] .02381 -0.0125 0 1 Mshowa
.2619 0 m
.2619 .00625 L
s
[(15)] .2619 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(20)] .5 -0.0125 0 1 Mshowa
.7381 0 m
.7381 .00625 L
s
[(25)] .7381 -0.0125 0 1 Mshowa
.97619 0 m
.97619 .00625 L
s
[(30)] .97619 -0.0125 0 1 Mshowa
.125 Mabswid
.07143 0 m
.07143 .00375 L
s
.11905 0 m
.11905 .00375 L
s
.16667 0 m
.16667 .00375 L
s
.21429 0 m
.21429 .00375 L
s
.30952 0 m
.30952 .00375 L
s
.35714 0 m
.35714 .00375 L
s
.40476 0 m
.40476 .00375 L
s
.45238 0 m
.45238 .00375 L
s
.54762 0 m
.54762 .00375 L
s
.59524 0 m
.59524 .00375 L
s
.64286 0 m
.64286 .00375 L
s
.69048 0 m
.69048 .00375 L
s
.78571 0 m
.78571 .00375 L
s
.83333 0 m
.83333 .00375 L
s
.88095 0 m
.88095 .00375 L
s
.92857 0 m
.92857 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
gsave
.5 -0.0125 -75 -25 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Days) show
87.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 .01472 m
.00625 .01472 L
s
[(0)] -0.0125 .01472 1 0 Mshowa
0 .13995 m
.00625 .13995 L
s
[(0.5)] -0.0125 .13995 1 0 Mshowa
0 .26518 m
.00625 .26518 L
s
[(1)] -0.0125 .26518 1 0 Mshowa
0 .39042 m
.00625 .39042 L
s
[(1.5)] -0.0125 .39042 1 0 Mshowa
0 .51565 m
.00625 .51565 L
s
[(2)] -0.0125 .51565 1 0 Mshowa
.125 Mabswid
0 .03976 m
.00375 .03976 L
s
0 .06481 m
.00375 .06481 L
s
0 .08986 m
.00375 .08986 L
s
0 .1149 m
.00375 .1149 L
s
0 .165 m
.00375 .165 L
s
0 .19004 m
.00375 .19004 L
s
0 .21509 m
.00375 .21509 L
s
0 .24014 m
.00375 .24014 L
s
0 .29023 m
.00375 .29023 L
s
0 .31528 m
.00375 .31528 L
s
0 .34033 m
.00375 .34033 L
s
0 .36537 m
.00375 .36537 L
s
0 .41547 m
.00375 .41547 L
s
0 .44051 m
.00375 .44051 L
s
0 .46556 m
.00375 .46556 L
s
0 .49061 m
.00375 .49061 L
s
0 .5407 m
.00375 .5407 L
s
0 .56575 m
.00375 .56575 L
s
0 .5908 m
.00375 .5908 L
s
0 .61584 m
.00375 .61584 L
s
.25 Mabswid
0 0 m
0 .61803 L
s
gsave
-0.01875 .30902 -141 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
117 10 translate
90 rotate
-117 -10 translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(EAE) show
87.000 13.000 moveto
(severity) show
141.000 13.000 moveto
(index) show
171.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.001 w
.02381 .01472 m
.07143 .01472 L
.11905 .07483 L
.16667 .10238 L
.21429 .12743 L
.2619 .12743 L
.30952 .26518 L
.35714 .39042 L
.40476 .60332 L
.45238 .51565 L
.5 .39042 L
.54762 .35285 L
.59524 .35285 L
.64286 .35285 L
.69048 .35285 L
.7381 .35285 L
.78571 .35285 L
.83333 .35285 L
.88095 .08986 L
.92857 .01472 L
.97619 .01472 L
s
.0001 w
.02381 .01472 0 5 Mabsadd m
.02381 .01472 -4.33 -2.5 Mabsadd L
.02381 .01472 4.33 -2.5 Mabsadd L
.02381 .01472 0 5 Mabsadd L closepath F
.07143 .01472 0 5 Mabsadd m
.07143 .01472 -4.33 -2.5 Mabsadd L
.07143 .01472 4.33 -2.5 Mabsadd L
.07143 .01472 0 5 Mabsadd L closepath F
.11905 .07483 0 5 Mabsadd m
.11905 .07483 -4.33 -2.5 Mabsadd L
.11905 .07483 4.33 -2.5 Mabsadd L
.11905 .07483 0 5 Mabsadd L closepath F
.16667 .10238 0 5 Mabsadd m
.16667 .10238 -4.33 -2.5 Mabsadd L
.16667 .10238 4.33 -2.5 Mabsadd L
.16667 .10238 0 5 Mabsadd L closepath F
.21429 .12743 0 5 Mabsadd m
.21429 .12743 -4.33 -2.5 Mabsadd L
.21429 .12743 4.33 -2.5 Mabsadd L
.21429 .12743 0 5 Mabsadd L closepath F
.2619 .12743 0 5 Mabsadd m
.2619 .12743 -4.33 -2.5 Mabsadd L
.2619 .12743 4.33 -2.5 Mabsadd L
.2619 .12743 0 5 Mabsadd L closepath F
.30952 .26518 0 5 Mabsadd m
.30952 .26518 -4.33 -2.5 Mabsadd L
.30952 .26518 4.33 -2.5 Mabsadd L
.30952 .26518 0 5 Mabsadd L closepath F
.35714 .39042 0 5 Mabsadd m
.35714 .39042 -4.33 -2.5 Mabsadd L
.35714 .39042 4.33 -2.5 Mabsadd L
.35714 .39042 0 5 Mabsadd L closepath F
.40476 .60332 0 5 Mabsadd m
.40476 .60332 -4.33 -2.5 Mabsadd L
.40476 .60332 4.33 -2.5 Mabsadd L
.40476 .60332 0 5 Mabsadd L closepath F
.45238 .51565 0 5 Mabsadd m
.45238 .51565 -4.33 -2.5 Mabsadd L
.45238 .51565 4.33 -2.5 Mabsadd L
.45238 .51565 0 5 Mabsadd L closepath F
.5 .39042 0 5 Mabsadd m
.5 .39042 -4.33 -2.5 Mabsadd L
.5 .39042 4.33 -2.5 Mabsadd L
.5 .39042 0 5 Mabsadd L closepath F
.54762 .35285 0 5 Mabsadd m
.54762 .35285 -4.33 -2.5 Mabsadd L
.54762 .35285 4.33 -2.5 Mabsadd L
.54762 .35285 0 5 Mabsadd L closepath F
.59524 .35285 0 5 Mabsadd m
.59524 .35285 -4.33 -2.5 Mabsadd L
.59524 .35285 4.33 -2.5 Mabsadd L
.59524 .35285 0 5 Mabsadd L closepath F
.64286 .35285 0 5 Mabsadd m
.64286 .35285 -4.33 -2.5 Mabsadd L
.64286 .35285 4.33 -2.5 Mabsadd L
.64286 .35285 0 5 Mabsadd L closepath F
.69048 .35285 0 5 Mabsadd m
.69048 .35285 -4.33 -2.5 Mabsadd L
.69048 .35285 4.33 -2.5 Mabsadd L
.69048 .35285 0 5 Mabsadd L closepath F
.7381 .35285 0 5 Mabsadd m
.7381 .35285 -4.33 -2.5 Mabsadd L
.7381 .35285 4.33 -2.5 Mabsadd L
.7381 .35285 0 5 Mabsadd L closepath F
.78571 .35285 0 5 Mabsadd m
.78571 .35285 -4.33 -2.5 Mabsadd L
.78571 .35285 4.33 -2.5 Mabsadd L
.78571 .35285 0 5 Mabsadd L closepath F
.83333 .35285 0 5 Mabsadd m
.83333 .35285 -4.33 -2.5 Mabsadd L
.83333 .35285 4.33 -2.5 Mabsadd L
.83333 .35285 0 5 Mabsadd L closepath F
.88095 .08986 0 5 Mabsadd m
.88095 .08986 -4.33 -2.5 Mabsadd L
.88095 .08986 4.33 -2.5 Mabsadd L
.88095 .08986 0 5 Mabsadd L closepath F
.92857 .01472 0 5 Mabsadd m
.92857 .01472 -4.33 -2.5 Mabsadd L
.92857 .01472 4.33 -2.5 Mabsadd L
.92857 .01472 0 5 Mabsadd L closepath F
.97619 .01472 0 5 Mabsadd m
.97619 .01472 -4.33 -2.5 Mabsadd L
.97619 .01472 4.33 -2.5 Mabsadd L
.97619 .01472 0 5 Mabsadd L closepath F
.001 w
[ .5 3 ] 0 Mabsdash
.02381 .01472 m
.07143 .01472 L
.11905 .07483 L
.16667 .10238 L
.21429 .12743 L
.2619 .12743 L
.30952 .26518 L
.35714 .26518 L
.40476 .26518 L
.45238 .30276 L
.5 .22135 L
.54762 .13995 L
.59524 .10238 L
.64286 .06481 L
.69048 .06481 L
.7381 .06481 L
.78571 .06481 L
.83333 .01472 L
.88095 .01472 L
.92857 .01472 L
.97619 .01472 L
s
.0001 w
[ ] 0 setdash
.02381 .01472 0 6.25 Mabsadd m
.02381 .01472 -1.41294 1.94475 Mabsadd L
.02381 .01472 -5.94411 1.93136 Mabsadd L
.02381 .01472 -2.28619 -0.74283 Mabsadd L
.02381 .01472 -3.67366 -5.05636 Mabsadd L
.02381 .01472 0 -2.40384 Mabsadd L
.02381 .01472 3.67366 -5.05636 Mabsadd L
.02381 .01472 2.28619 -0.74283 Mabsadd L
.02381 .01472 5.94411 1.93136 Mabsadd L
.02381 .01472 1.41294 1.94475 Mabsadd L
.02381 .01472 0 6.25 Mabsadd L closepath F
.07143 .01472 0 6.25 Mabsadd m
.07143 .01472 -1.41294 1.94475 Mabsadd L
.07143 .01472 -5.94411 1.93136 Mabsadd L
.07143 .01472 -2.28619 -0.74283 Mabsadd L
.07143 .01472 -3.67366 -5.05636 Mabsadd L
.07143 .01472 0 -2.40384 Mabsadd L
.07143 .01472 3.67366 -5.05636 Mabsadd L
.07143 .01472 2.28619 -0.74283 Mabsadd L
.07143 .01472 5.94411 1.93136 Mabsadd L
.07143 .01472 1.41294 1.94475 Mabsadd L
.07143 .01472 0 6.25 Mabsadd L closepath F
.11905 .07483 0 6.25 Mabsadd m
.11905 .07483 -1.41294 1.94475 Mabsadd L
.11905 .07483 -5.94411 1.93136 Mabsadd L
.11905 .07483 -2.28619 -0.74283 Mabsadd L
.11905 .07483 -3.67366 -5.05636 Mabsadd L
.11905 .07483 0 -2.40384 Mabsadd L
.11905 .07483 3.67366 -5.05636 Mabsadd L
.11905 .07483 2.28619 -0.74283 Mabsadd L
.11905 .07483 5.94411 1.93136 Mabsadd L
.11905 .07483 1.41294 1.94475 Mabsadd L
.11905 .07483 0 6.25 Mabsadd L closepath F
.16667 .10238 0 6.25 Mabsadd m
.16667 .10238 -1.41294 1.94475 Mabsadd L
.16667 .10238 -5.94411 1.93136 Mabsadd L
.16667 .10238 -2.28619 -0.74283 Mabsadd L
.16667 .10238 -3.67366 -5.05636 Mabsadd L
.16667 .10238 0 -2.40384 Mabsadd L
.16667 .10238 3.67366 -5.05636 Mabsadd L
.16667 .10238 2.28619 -0.74283 Mabsadd L
.16667 .10238 5.94411 1.93136 Mabsadd L
.16667 .10238 1.41294 1.94475 Mabsadd L
.16667 .10238 0 6.25 Mabsadd L closepath F
.21429 .12743 0 6.25 Mabsadd m
.21429 .12743 -1.41294 1.94475 Mabsadd L
.21429 .12743 -5.94411 1.93136 Mabsadd L
.21429 .12743 -2.28619 -0.74283 Mabsadd L
.21429 .12743 -3.67366 -5.05636 Mabsadd L
.21429 .12743 0 -2.40384 Mabsadd L
.21429 .12743 3.67366 -5.05636 Mabsadd L
.21429 .12743 2.28619 -0.74283 Mabsadd L
.21429 .12743 5.94411 1.93136 Mabsadd L
.21429 .12743 1.41294 1.94475 Mabsadd L
.21429 .12743 0 6.25 Mabsadd L closepath F
.2619 .12743 0 6.25 Mabsadd m
.2619 .12743 -1.41294 1.94475 Mabsadd L
.2619 .12743 -5.94411 1.93136 Mabsadd L
.2619 .12743 -2.28619 -0.74283 Mabsadd L
.2619 .12743 -3.67366 -5.05636 Mabsadd L
.2619 .12743 0 -2.40384 Mabsadd L
.2619 .12743 3.67366 -5.05636 Mabsadd L
.2619 .12743 2.28619 -0.74283 Mabsadd L
.2619 .12743 5.94411 1.93136 Mabsadd L
.2619 .12743 1.41294 1.94475 Mabsadd L
.2619 .12743 0 6.25 Mabsadd L closepath F
.30952 .26518 0 6.25 Mabsadd m
.30952 .26518 -1.41294 1.94475 Mabsadd L
.30952 .26518 -5.94411 1.93136 Mabsadd L
.30952 .26518 -2.28619 -0.74283 Mabsadd L
.30952 .26518 -3.67366 -5.05636 Mabsadd L
.30952 .26518 0 -2.40384 Mabsadd L
.30952 .26518 3.67366 -5.05636 Mabsadd L
.30952 .26518 2.28619 -0.74283 Mabsadd L
.30952 .26518 5.94411 1.93136 Mabsadd L
.30952 .26518 1.41294 1.94475 Mabsadd L
.30952 .26518 0 6.25 Mabsadd L closepath F
.35714 .26518 0 6.25 Mabsadd m
.35714 .26518 -1.41294 1.94475 Mabsadd L
.35714 .26518 -5.94411 1.93136 Mabsadd L
.35714 .26518 -2.28619 -0.74283 Mabsadd L
.35714 .26518 -3.67366 -5.05636 Mabsadd L
.35714 .26518 0 -2.40384 Mabsadd L
.35714 .26518 3.67366 -5.05636 Mabsadd L
.35714 .26518 2.28619 -0.74283 Mabsadd L
.35714 .26518 5.94411 1.93136 Mabsadd L
.35714 .26518 1.41294 1.94475 Mabsadd L
.35714 .26518 0 6.25 Mabsadd L closepath F
.40476 .26518 0 6.25 Mabsadd m
.40476 .26518 -1.41294 1.94475 Mabsadd L
.40476 .26518 -5.94411 1.93136 Mabsadd L
.40476 .26518 -2.28619 -0.74283 Mabsadd L
.40476 .26518 -3.67366 -5.05636 Mabsadd L
.40476 .26518 0 -2.40384 Mabsadd L
.40476 .26518 3.67366 -5.05636 Mabsadd L
.40476 .26518 2.28619 -0.74283 Mabsadd L
.40476 .26518 5.94411 1.93136 Mabsadd L
.40476 .26518 1.41294 1.94475 Mabsadd L
.40476 .26518 0 6.25 Mabsadd L closepath F
.45238 .30276 0 6.25 Mabsadd m
.45238 .30276 -1.41294 1.94475 Mabsadd L
.45238 .30276 -5.94411 1.93136 Mabsadd L
.45238 .30276 -2.28619 -0.74283 Mabsadd L
.45238 .30276 -3.67366 -5.05636 Mabsadd L
.45238 .30276 0 -2.40384 Mabsadd L
.45238 .30276 3.67366 -5.05636 Mabsadd L
.45238 .30276 2.28619 -0.74283 Mabsadd L
.45238 .30276 5.94411 1.93136 Mabsadd L
.45238 .30276 1.41294 1.94475 Mabsadd L
.45238 .30276 0 6.25 Mabsadd L closepath F
.5 .22135 0 6.25 Mabsadd m
.5 .22135 -1.41294 1.94475 Mabsadd L
.5 .22135 -5.94411 1.93136 Mabsadd L
.5 .22135 -2.28619 -0.74283 Mabsadd L
.5 .22135 -3.67366 -5.05636 Mabsadd L
.5 .22135 0 -2.40384 Mabsadd L
.5 .22135 3.67366 -5.05636 Mabsadd L
.5 .22135 2.28619 -0.74283 Mabsadd L
.5 .22135 5.94411 1.93136 Mabsadd L
.5 .22135 1.41294 1.94475 Mabsadd L
.5 .22135 0 6.25 Mabsadd L closepath F
.54762 .13995 0 6.25 Mabsadd m
.54762 .13995 -1.41294 1.94475 Mabsadd L
.54762 .13995 -5.94411 1.93136 Mabsadd L
.54762 .13995 -2.28619 -0.74283 Mabsadd L
.54762 .13995 -3.67366 -5.05636 Mabsadd L
.54762 .13995 0 -2.40384 Mabsadd L
.54762 .13995 3.67366 -5.05636 Mabsadd L
.54762 .13995 2.28619 -0.74283 Mabsadd L
.54762 .13995 5.94411 1.93136 Mabsadd L
.54762 .13995 1.41294 1.94475 Mabsadd L
.54762 .13995 0 6.25 Mabsadd L closepath F
.59524 .10238 0 6.25 Mabsadd m
.59524 .10238 -1.41294 1.94475 Mabsadd L
.59524 .10238 -5.94411 1.93136 Mabsadd L
.59524 .10238 -2.28619 -0.74283 Mabsadd L
.59524 .10238 -3.67366 -5.05636 Mabsadd L
.59524 .10238 0 -2.40384 Mabsadd L
.59524 .10238 3.67366 -5.05636 Mabsadd L
.59524 .10238 2.28619 -0.74283 Mabsadd L
.59524 .10238 5.94411 1.93136 Mabsadd L
.59524 .10238 1.41294 1.94475 Mabsadd L
.59524 .10238 0 6.25 Mabsadd L closepath F
.64286 .06481 0 6.25 Mabsadd m
.64286 .06481 -1.41294 1.94475 Mabsadd L
.64286 .06481 -5.94411 1.93136 Mabsadd L
.64286 .06481 -2.28619 -0.74283 Mabsadd L
.64286 .06481 -3.67366 -5.05636 Mabsadd L
.64286 .06481 0 -2.40384 Mabsadd L
.64286 .06481 3.67366 -5.05636 Mabsadd L
.64286 .06481 2.28619 -0.74283 Mabsadd L
.64286 .06481 5.94411 1.93136 Mabsadd L
.64286 .06481 1.41294 1.94475 Mabsadd L
.64286 .06481 0 6.25 Mabsadd L closepath F
.69048 .06481 0 6.25 Mabsadd m
.69048 .06481 -1.41294 1.94475 Mabsadd L
.69048 .06481 -5.94411 1.93136 Mabsadd L
.69048 .06481 -2.28619 -0.74283 Mabsadd L
.69048 .06481 -3.67366 -5.05636 Mabsadd L
.69048 .06481 0 -2.40384 Mabsadd L
.69048 .06481 3.67366 -5.05636 Mabsadd L
.69048 .06481 2.28619 -0.74283 Mabsadd L
.69048 .06481 5.94411 1.93136 Mabsadd L
.69048 .06481 1.41294 1.94475 Mabsadd L
.69048 .06481 0 6.25 Mabsadd L closepath F
.7381 .06481 0 6.25 Mabsadd m
.7381 .06481 -1.41294 1.94475 Mabsadd L
.7381 .06481 -5.94411 1.93136 Mabsadd L
.7381 .06481 -2.28619 -0.74283 Mabsadd L
.7381 .06481 -3.67366 -5.05636 Mabsadd L
.7381 .06481 0 -2.40384 Mabsadd L
.7381 .06481 3.67366 -5.05636 Mabsadd L
.7381 .06481 2.28619 -0.74283 Mabsadd L
.7381 .06481 5.94411 1.93136 Mabsadd L
.7381 .06481 1.41294 1.94475 Mabsadd L
.7381 .06481 0 6.25 Mabsadd L closepath F
.78571 .06481 0 6.25 Mabsadd m
.78571 .06481 -1.41294 1.94475 Mabsadd L
.78571 .06481 -5.94411 1.93136 Mabsadd L
.78571 .06481 -2.28619 -0.74283 Mabsadd L
.78571 .06481 -3.67366 -5.05636 Mabsadd L
.78571 .06481 0 -2.40384 Mabsadd L
.78571 .06481 3.67366 -5.05636 Mabsadd L
.78571 .06481 2.28619 -0.74283 Mabsadd L
.78571 .06481 5.94411 1.93136 Mabsadd L
.78571 .06481 1.41294 1.94475 Mabsadd L
.78571 .06481 0 6.25 Mabsadd L closepath F
.83333 .01472 0 6.25 Mabsadd m
.83333 .01472 -1.41294 1.94475 Mabsadd L
.83333 .01472 -5.94411 1.93136 Mabsadd L
.83333 .01472 -2.28619 -0.74283 Mabsadd L
.83333 .01472 -3.67366 -5.05636 Mabsadd L
.83333 .01472 0 -2.40384 Mabsadd L
.83333 .01472 3.67366 -5.05636 Mabsadd L
.83333 .01472 2.28619 -0.74283 Mabsadd L
.83333 .01472 5.94411 1.93136 Mabsadd L
.83333 .01472 1.41294 1.94475 Mabsadd L
.83333 .01472 0 6.25 Mabsadd L closepath F
.88095 .01472 0 6.25 Mabsadd m
.88095 .01472 -1.41294 1.94475 Mabsadd L
.88095 .01472 -5.94411 1.93136 Mabsadd L
.88095 .01472 -2.28619 -0.74283 Mabsadd L
.88095 .01472 -3.67366 -5.05636 Mabsadd L
.88095 .01472 0 -2.40384 Mabsadd L
.88095 .01472 3.67366 -5.05636 Mabsadd L
.88095 .01472 2.28619 -0.74283 Mabsadd L
.88095 .01472 5.94411 1.93136 Mabsadd L
.88095 .01472 1.41294 1.94475 Mabsadd L
.88095 .01472 0 6.25 Mabsadd L closepath F
.92857 .01472 0 6.25 Mabsadd m
.92857 .01472 -1.41294 1.94475 Mabsadd L
.92857 .01472 -5.94411 1.93136 Mabsadd L
.92857 .01472 -2.28619 -0.74283 Mabsadd L
.92857 .01472 -3.67366 -5.05636 Mabsadd L
.92857 .01472 0 -2.40384 Mabsadd L
.92857 .01472 3.67366 -5.05636 Mabsadd L
.92857 .01472 2.28619 -0.74283 Mabsadd L
.92857 .01472 5.94411 1.93136 Mabsadd L
.92857 .01472 1.41294 1.94475 Mabsadd L
.92857 .01472 0 6.25 Mabsadd L closepath F
.97619 .01472 0 6.25 Mabsadd m
.97619 .01472 -1.41294 1.94475 Mabsadd L
.97619 .01472 -5.94411 1.93136 Mabsadd L
.97619 .01472 -2.28619 -0.74283 Mabsadd L
.97619 .01472 -3.67366 -5.05636 Mabsadd L
.97619 .01472 0 -2.40384 Mabsadd L
.97619 .01472 3.67366 -5.05636 Mabsadd L
.97619 .01472 2.28619 -0.74283 Mabsadd L
.97619 .01472 5.94411 1.93136 Mabsadd L
.97619 .01472 1.41294 1.94475 Mabsadd L
.97619 .01472 0 6.25 Mabsadd L closepath F
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
0 g
.64881 .02945 m
.64881 .27498 L
.97619 .27498 L
.97619 .02945 L
F
1 g
.64881 .02945 m
.64881 .27498 L
.97619 .27498 L
.97619 .02945 L
F
0 g
.001 w
[ ] 0 setdash
.64881 .02945 m
.97619 .02945 L
.97619 .27498 L
.64881 .27498 L
.64881 .02945 L
s
% Start of sub-graphic
p
0.64881 0.0294451 0.97619 0.274981 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0297619 0.297619 0.0297619 0.297619 [
[ 0 0 0 0 ]
[ 1 .75 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .75 L
0 .75 L
closepath
clip
newpath
% Start of sub-graphic
p
0.0535714 0.0535714 0.35119 0.35119 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.0034 w
[ .5 3 ] 0 Mabsdash
0 .5 m
1 .5 L
s
.00034 w
[ ] 0 setdash
.5 .5 0 6.25 Mabsadd m
.5 .5 -1.41294 1.94475 Mabsadd L
.5 .5 -5.94411 1.93136 Mabsadd L
.5 .5 -2.28619 -0.74283 Mabsadd L
.5 .5 -3.67366 -5.05636 Mabsadd L
.5 .5 0 -2.40384 Mabsadd L
.5 .5 3.67366 -5.05636 Mabsadd L
.5 .5 2.28619 -0.74283 Mabsadd L
.5 .5 5.94411 1.93136 Mabsadd L
.5 .5 1.41294 1.94475 Mabsadd L
.5 .5 0 6.25 Mabsadd L closepath F
MathSubEnd
P
% End of sub-graphic
0 g
gsave
.38988 .20238 -61 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Trattati) show
111.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
% Start of sub-graphic
p
0.0535714 0.39881 0.35119 0.696429 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.5 0.5 0.5 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 g
.0034 w
[ ] 0 setdash
0 .5 m
1 .5 L
s
.00034 w
.5 .5 0 5 Mabsadd m
.5 .5 -4.33 -2.5 Mabsadd L
.5 .5 4.33 -2.5 Mabsadd L
.5 .5 0 5 Mabsadd L closepath F
MathSubEnd
P
% End of sub-graphic
0 g
gsave
.38988 .54762 -61 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Non) show
87.000 13.000 moveto
(trattati) show
135.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
MathSubEnd
P
% End of sub-graphic
0 0 m
1 0 L
1 .38627 L
0 .38627 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[17]:=",
  ImageSize->{400, 154.5},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006@0000VR000`400?l00000o`00003ooooooonA
ooooo`00oooooonAooooo`00oooooonAooooo`00oooooonAooooo`00oooooonAooooo`00oooooonA
ooooo`00T?ooool3o`000?gooooo002Aooooo`03o`000?oooooooooo0?cooooo0024ooooo`Co0000
0oooool4o`0000?ooooo00Co0000oooooooooooooooo1?l0003fooooo`00QOooool01_l0003ooooo
ooooool0003oooooo`0000;ooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`05oooo
o`03o`000?oooooooooo0??ooooo0025ooooo`04o`000?ooooooooooo`0000;ooooo0ol00003oooo
o`03o`000?oooooo000000?ooooo0ol0003fooooo`00QOooool01_l0003oooooooooool0003ooooo
o`0000;ooooo00Oo0000ooooooooooooooooo`000?oooooo000000;ooooo00?o0000ooooooooool0
moooool008Gooooo00Co0000oooooooooooo00000_ooool2o`0000?ooooo0_l000000ooooooo0000
o`000002ooooo`Co0000Iooooon3o`0000_ooooo0025ooooo`04o`000?ooooooooooo`0007Wooooo
00?o0000ooooooooool0Ooooool00ol0003oooooooooo`09ooooo`00Q?ooool4o`0007[ooooo00?o
0000ooooooooool0Ooooool00ol0003oooooooooo`09ooooo`00ooooool3ooooo`03o`000?oooooo
oooo07oooooo00?o0000ooooooooool02Oooool00?oooooo0oooool00ol0003oooooooooo`1ooooo
o`03o`000?oooooooooo00Wooooo000]ooooo`?o00001?ooool2o`0002Kooooo0ol00003ooooo`?o
00009Oooool5o`0000?ooooo0_l0000Uooooo`Go00000_ooool3o`0002Oooooo0ol00004ooooo`;o
00003oooool00ol0003oooooooooo`1oooooo`03o`000?oooooooooo00Wooooo000^ooooo`03o`00
0?oooooooooo00;ooooo00Co0000oooooooooooo00009_ooool01Ol0003ooooooooooooooooo0000
00?ooooo00?o0000ooooooooool08oooool01?l0003oooooooooool00002ooooo`04o`000?oooooo
ooooo`0002Gooooo00Ko0000oooooooooooo0000ooooool00003ooooo`03o`000?oooooooooo02?o
oooo00Go0000ooooooooooooooooo`000002ooooo`04o`000?ooooooooooo`0000kooooo00?o0000
ooooooooool0Ooooool00ol0003oooooooooo`09ooooo`00;_ooool00ol0003oooooooooo`02oooo
o`04o`000?ooooooooooo`0002Kooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`0T
ooooo`03o`000?oooooooooo00;ooooo00Co0000oooooooooooo00009_ooool00ol0003ooooooooo
o`05ooooo`03o`000?oooooooooo02Oooooo00Co0000oooooooooooo00000_ooool00ol0003ooooo
ooooo`0<ooooo`03o`000?oooooooooo07oooooo00?o0000ooooooooool02Oooool002kooooo00?o
0000ooooooooool00_ooool01?l0003oooooooooool0000Vooooo`03o`000?oooooooooo00Gooooo
00?o0000ooooooooool09Oooool01Ol0003ooooooooooooooooo000000;ooooo00?o0000oooooooo
ool09Oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo02Gooooo0_l00003ooooo`04
o`000?ooooooooooo`0000kooooo00?o0000ooooooooool0Ooooool00ol0003oooooooooo`09oooo
o`00;_ooool00ol0003oooooooooo`02ooooo`04o`000?ooooooooooo`0002Kooooo00Co0000oooo
oooooooooooo1?l0000Uooooo`05o`000?ooooooooooooooool000000_ooool01?l0003ooooooooo
ool0000Tooooo`06o`000?ooooooooooooooool0003ooooo1?l0000Zooooo`04o`000?oooooooooo
o`0000;ooooo00?o0000ooooooooool03?ooool00ol0003oooooooooo`1oooooo`03o`000?oooooo
oooo00Wooooo000]ooooo`;o00001?ooool01?l0003oooooooooool0000Uooooo`;o00000oooool0
0ol0003oooooooooo`0Vooooo`05o`000?ooooooooooooooool000000_ooool01?l0003ooooooooo
ool0000Tooooo`07o`000?ooooooooooooooool0003oooooo`00000Yooooo`05o`000?oooooooooo
ooooool000000_ooool01?l0003oooooooooool0000>ooooo`03o`000?oooooooooo07oooooo00?o
0000ooooooooool02Oooool002kooooo00?o0000ooooooooool00oooool2o`0002Oooooo00Co0000
oooooooooooooooo1Ol0000Uooooo`?o00001?ooool2o`0002Kooooo0ol00002ooooo`Go00009_oo
ool3o`0000Cooooo0_l0000?ooooo`03o`000?oooooooooo07oooooo00?o0000ooooooooool02Ooo
ool00?oooooo0oooool00ol0003oooooooooo`1oooooo`03o`000?oooooooooo00Wooooo003ooooo
o`?ooooo00?o0000ooooooooool0Ooooool00ol0003oooooooooo`09ooooo`00;_ooool2o`0000Oo
oooo0_l00005ooooo`03o`000?oooooooooo08kooooo00?o0000ooooooooool00oooool00ol0003o
ooooooooo`02o`0000Gooooo00Co0000oooooooooooo00001Oooool00ol0003oooooooooo`02o`00
01Gooooo00?o0000ooooooooool0Ooooool00ol0003oooooooooo`09ooooo`00;Oooooo7o`0000ko
oooo00?o0000ooooooooool0Ooooool00ol0003oooooooooo`09ooooo`009_ooool2o`0000Gooooo
00?o0000ooooool000001Ol00003ooooo`Ko00001oooool00ol0003oooooooooo`06ooooo`03o`00
0?oooooooooo00Oooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`06ooooo`03o`00
0?oooooooooo00Oooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`07ooooo`03o`00
0?oooooooooo00Kooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`06ooooo`03o`00
0?oooooooooo00Oooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`06ooooo`03o`00
0?oooooooooo00Oooooo00?o0000ooooooooool01?ooool6o`0000?ooooo1_l00004ooooo`Ko0000
0oooool6o`00013ooooo00?o0000ooooooooool0Ooooool00ol0003oooooooooo`09ooooo`009Ooo
ool01?l0003oooooooooool00004ooooo`Wo000000?oooooo`000?l000001_l0002Aooooo`Go0000
1Oooool5o`0000;ooooo4_l0000?ooooo`03o`000?oooooooooo07oooooo00?o0000ooooooooool0
2Oooool002Gooooo00Co0000oooooooooooo00001?oooolBo`00093ooooo1ol000000ooooooo0000
o`000007o`0000;ooooo4Ol0000?ooooo`03o`000?oooooooooo07oooooo00?o0000ooooooooool0
2Oooool002Gooooo00Co0000oooooooooooo00001?oooolCo`0008kooooo2Ol000000ooooooo0000
o`00000@o`000003ooooool0003o000000Oo00003_ooool00ol0003oooooooooo`1oooooo`03o`00
0?oooooooooo00Wooooo000Uooooo`04o`000?ooooooooooo`0000Cooooo5?l0002<ooooobSo0000
3Oooool00ol0003oooooooooo`1oooooo`03o`000?oooooooooo00Wooooo000Uooooo`04o`000?oo
ooooooooo`0000Cooooo00?o0000ooooooooool01?l00006ooooo`Co0000Toooool3o`0000Kooooo
0ol00006ooooo`Co00001_ooool4o`00017ooooo00?o0000ooooooooool0Ooooool00ol0003ooooo
ooooo`09ooooo`009_ooool2o`0000Gooooo00Co0000oooooooooooooooo0_l00007ooooo`?o0000
00?oooooo`000?ooool0S_ooool2o`000004ooooool0003o0000o`0000Oooooo0_l00006ooooo`Co
00001oooool2o`0001;ooooo00?o0000ooooooooool05?ooool00ol0003oooooooooo`03ooooo`03
o`000?oooooooooo06;ooooo00?o0000ooooooooool02Oooool002gooooo0_l00002ooooo`;o0000
2?ooool01Ol0003ooooooooooooooooo000009;ooooo00?o0000ooooooooool01_ooool2o`0000Go
oooo00Co0000oooooooooooo00002?ooool2o`0001;ooooo00?o0000ooooooooool05?ooool2o`00
00?ooooo0_l0001Tooooo`03o`000?oooooooooo00Wooooo000Dooooo`Go00005?ooool00ol0003o
ooooooooo`0;ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0I_ooool2o`0000Oo
oooo0_l00005ooooo`04o`000?ooooooooooo`0000Gooooo00?o0000ooooooooool00_l00005oooo
o`03o`000?oooooooooo00?ooooo00?o0000ooooooooool03Oooool01?l0003oooooooooool0000L
ooooo`03o`000?oooooooooo01Gooooo0_l000001?oooooo0000o`000?l0000Hooooo`?o00000_oo
ool3o`0000Cooooo1?l00003ooooo`;o00001?ooool2o`0000?ooooo1?l00003ooooo`;o00000_oo
ool5o`0001kooooo00?o0000ooooooooool02Oooool001Gooooo00Co0000oooooooooooo00005?oo
ool00ol0003oooooooooo`0@ooooo`03o`000?oooooooooo06Kooooo0ol00003ooooo`04o`000?oo
ooooooooooooo`;o00000oooool2o`0000;ooooo0_l00003ooooo`;o00000oooool2o`0000?ooooo
0_l0000Dooooo`03o`000?oooooooooo01kooooo00?o0000ooooooooool05Oooool5o`0001[ooooo
00?o0000ooooooooool00_ooool00ol0003oooooooooo`02ooooo`04o`000?ooooooooooo`0000?o
oooo00Co0000oooooooooooo00000_ooool01_l0003oooooooooool0003oooooo`0000;ooooo00Go
0000ooooooooooooooooo`000002ooooo`05o`000?ooooooooooooooool000008?ooool00ol0003o
ooooooooo`09ooooo`005Oooool00ol0003oooooooooo`0Eooooo`03o`000?oooooooooo017ooooo
0_l0001Wooooo`?o000000?oooooo`000?l000000oooool3o`000003ooooool0003o000000Cooooo
0_l000001?oooooo0000o`000?l00003ooooo`?o000000?oooooo`000?l000005?ooool00ol0003o
ooooooooo`0Oooooo`03o`000?oooooooooo00Cooooo0_l00002ooooo`03o`000?oooooooooo00;o
00000_ooool00ol0003oooooooooo`09o`0000;ooooo00?o0000ooooooooool00_l00002ooooo`03
o`000?oooooooooo00;o00000_ooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo00;o
oooo00?o0000ooooooooool00oooool3o`0000?ooooo00?o0000ooooooooool00oooool00ol0003o
ooooooooo`03ooooo`?o00000oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo01ko
oooo00?o0000ooooooooool02Oooool001Gooooo0ol0000Eooooo`03o`000?oooooooooo017ooooo
0ol00003ooooo`03o`000?oooooooooo063ooooo1Ol00005ooooo`Go00001?ooool5o`0000Gooooo
1Ol0000Dooooo`03o`000?oooooooooo01oooooo00?o0000ooooooooool04oooool9o`0001Sooooo
00?o0000ooooooooool00_ooool2o`0000?ooooo00Co0000oooooooooooo00000oooool00ol0003o
ooooooooo`03ooooo`03o`000?oooooooooo00;ooooo00Co0000oooooooooooo00000oooool00ol0
003oooooooooo`04ooooo`03o`000?oooooooooo01kooooo00?o0000ooooooooool02Oooool001Go
oooo00?o0000ooooooooool05Oooool2o`0001?ooooo0ol000000ooooooo0000o`00001Roooooa3o
00000_ooool8o`0000;ooooo1ol0000Booooo`03o`000?oooooooooo023ooooo00?o0000oooooooo
ool04_ooool;o`0001Gooooo00Ko0000ooooool0003oooooo`000?ooool2o`000003ooooool0003o
000000;ooooo0_l00003ooooo`Co00000_ooool4o`0000?ooooo0_l00003ooooo`Co00000_ooool3
o`00023ooooo00?o0000ooooooooool02Oooool001Gooooo00Co0000oooooooooooo00005?ooool0
0ol0003oooooooooo`0@ooooo`Wo0000H?oooolBo`000003ooooool0003o000000Ko000000?ooooo
o`000?l000001ol0000Aooooo`03o`000?oooooooooo023ooooo00?o0000ooooooooool05_ooool3
o`0001Wooooo00Go0000ooooool0003oooooo`00000>ooooo`03o`000?oooooooooo00?ooooo00?o
0000ooooooooool02Oooool00ol0003oooooooooo`0Uooooo`03o`000?oooooooooo00Wooooo000D
ooooo`Ko00004oooool00ol0003oooooooooo`0Aooooo`So0000GooooolWo`0000oooooo00?o0000
ooooooooool08Oooool00ol0003oooooooooo`0Fooooo`?o00006Oooool5o`0000kooooo00?o0000
ooooooooool00oooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo00Cooooo00?o0000
ooooooooool07_ooool00ol0003oooooooooo`09ooooo`005?ooool01Ol0003ooooooooooooooooo
000001Cooooo00?o0000ooooooooool04Oooool;o`0000Gooooo00?o0000ooooooooool0Boooool2
o`0000Gooooo00?o0000ooooool000000_ooool3o`0000Oooooo0_l00007ooooo`?o00001oooool2
o`0001?ooooo00?o0000ooooooooool08_ooool00ol0003oooooooooo`0Gooooo`03o`000?oooooo
oooo06Gooooo00?o0000ooooooooool02Oooool001Cooooo1Ol0000Dooooo`03o`000?oooooooooo
013ooooo3Ol00003ooooo`;o0000C_ooool2o`0000?ooooo0_l000000ooooooo0000ooooo`02oooo
o`;o00001oooool2o`0000Oooooo0ol00007ooooo`;o00003_ooool8o`0002;ooooo00?o0000oooo
ooooool05oooool00ol0003oooooooooo`1Uooooo`03o`000?oooooooooo00Wooooo000Eooooo`03
o`000?oooooo000001Gooooo0_l0000Dooooo`Co00000oooool4o`000003ooooool0003o000004oo
oooo0ol000001?oooooo0000o`000?l00005ooooo`;o00002?ooool00ol0003oooooooooo`06oooo
o`03o`000?oooooooooo00Oooooo00?o0000ooooooooool03Oooool7o`0002;ooooo00?o0000oooo
ooooool0Ooooool00ol0003oooooooooo`09ooooo`005Oooool00ol0003oooooo`00000Eooooo`03
o`000?oooooooooo01Cooooo0_l00004ooooo`So0000C_ooool6o`0001Wooooo00?o0000oooooooo
ool05oooool6o`0002?ooooo00?o0000ooooooooool0Ooooool00ol0003oooooooooo`09ooooo`00
5_ooool00ol0003oooooooooo`0Dooooo`03o`000?oooooooooo01Cooooo0_l00005ooooo`Oo0000
Coooool5o`0003Cooooo1Ol0000Sooooo`03o`000?oooooooooo07oooooo00?o0000ooooooooool0
2Oooool001Cooooo1Ol0000Dooooo`03o`000?oooooooooo01_ooooo1ol00002ooooo`;o00001ooo
ool2o`0000Gooooo00?o0000ooooooooool0>Oooool7o`0003Cooooo0ol0000Tooooo`03o`000?oo
oooooooo07oooooo00?o0000ooooooooool02Oooool001Gooooo00Co0000oooooooooooo00005?oo
ool00ol0003oooooooooo`0Iooooo`ko00000oooool01?l0003oooooooooooooool2o`0000?ooooo
0_l0000iooooo`_o0000<_ooool2o`0002Gooooo00?o0000ooooooooool0Ooooool00ol0003ooooo
ooooo`09ooooo`005Oooool00ol0003oooooooooo`0Eooooo`;o00007_ooool3o`0000Cooooo1?l0
00000ooooooo0000o`000003ooooo`?o000000?oooooo`000?l00000??ooool00ol0003oooooo`00
0002o`0003Kooooo0_l0000Uooooo`03o`000?oooooooooo07oooooo00?o0000ooooooooool02Ooo
ool001Gooooo0ol0000Eooooo`03o`000?oooooooooo01gooooo0_l00004ooooo`Wo000000?ooooo
o`000?l000001_l0000aooooo`;o00002_ooool3o`0003Kooooo00?o0000ooooooooool09?ooool0
0ol0003oooooooooo`1oooooo`03o`000?oooooooooo00Wooooo000Eooooo`03o`000?oooooooooo
00;ooooo0_l00004ooooo`03o`000?oooooooooo00;ooooo0ol00005ooooo`03o`000?oooooooooo
01kooooo00?o0000ooooooooool00ooooolAo`00037ooooo0ol00003ooooo`;o00001Oooool00ol0
003oooooooooo`0eooooo`03o`000?oooooooooo02Cooooo00?o0000ooooooooool0Ooooool00ol0
003oooooooooo`09ooooo`005Oooool00ol0003oooooooooo`02o`0000;ooooo00?o0000oooooooo
ool01Oooool01Ol0003ooooooooooooooooo000000Cooooo00?o0000ooooooooool09?ooool8o`00
00;ooooo1ol0000booooo`?o000000?oooooo`000?l000001_ooool00ol0003oooooooooo`0eoooo
o`03o`000?oooooooooo02Cooooo00?o0000ooooooooool0Ooooool00ol0003oooooooooo`09oooo
o`005?ooool6o`0000;ooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`02ooooo`03
o`000?oooooooooo02?ooooo5?l0000`ooooo`Go00001oooool00ol0003oooooooooo`0dooooo`03
o`000?oooooooooo02Gooooo00?o0000ooooooooool0Ooooool00ol0003oooooooooo`09ooooo`00
6Oooool01?l0003oooooooooool0000;ooooo`03o`000?oooooooooo00;ooooo0_l0000Wooooo`Co
00001_ooool3o`0003Cooooo1ol0000looooo`03o`000?oooooooooo02Gooooo00?o0000oooooooo
ool0Ooooool00ol0003oooooooooo`09ooooo`006Oooool01?l0003oooooooooool00007ooooo`Co
00001Oooool00ol0003oooooooooo`0Wooooo`;o00001oooool3o`0003?ooooo2Ol0000kooooo`03
o`000?oooooooooo02Gooooo00?o0000ooooooooool0Ooooool00ol0003oooooooooo`09ooooo`00
6Oooool01?l0003oooooooooool00007ooooo`03o`000?oooooooooo00Kooooo00?o0000oooooooo
ool09oooool2o`0000Sooooo0_l0000booooo`_o0000>_ooool00ol0003oooooooooo`0Uooooo`03
o`000?oooooooooo07oooooo00?o0000ooooooooool02Oooool001[ooooo0_l00008ooooo`Go0000
1?ooool00ol0003oooooooooo`0Wooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool0
<_ooool3o`0003oooooo00?o0000ooooooooool09Oooool00ol0003oooooooooo`1oooooo`03o`00
0?oooooooooo00Wooooo000]ooooo`03o`000?oooooooooo03?ooooo00?o0000ooooooooool0<ooo
ool2o`0003kooooo00?o0000ooooooooool09_ooool00ol0003oooooooooo`1oooooo`03o`000?oo
oooooooo00Wooooo000Dooooo`Co00005Oooool2o`0003Cooooo00?o0000ooooooooool0<Oooool0
1?l0003oooooo`000?l0000nooooo`03o`000?oooooooooo02Kooooo00?o0000ooooooooool0Oooo
ool00ol0003oooooooooo`09ooooo`006?ooool00ol0003oooooooooo`0Booooo`03o`000?oooooo
oooo03Cooooo00?o0000ooooooooool0L_ooool00ol0003oooooooooo`0Vooooo`03o`000?oooooo
oooo07oooooo00?o0000ooooooooool02Oooool001Gooooo0ol0000Eooooo`03o`000?oooooooooo
03Cooooo00?o0000ooooooooool0L_ooool00ol0003oooooooooo`0Vooooo`03o`000?oooooooooo
07oooooo00?o0000ooooooooool02Oooool001Cooooo00?o0000ooooooooool05_ooool00ol0003o
ooooooooo`0dooooo`;o0000;oooool00ol0003oooooooooo`11ooooo`03o`000?oooooooooo02Ko
oooo00?o0000ooooooooool0Ooooool00ol0003oooooooooo`09ooooo`005Oooool4o`0001Cooooo
00?o0000ooooooooool0=Oooool00ol0003oooooooooo`1`ooooo`03o`000?oooooooooo02Oooooo
00?o0000ooooooooool0Ooooool00ol0003oooooooooo`09ooooo`00;Oooool2o`0003Kooooo00?o
0000ooooooooool0L?ooool00ol0003oooooooooo`0Wooooo`03o`000?oooooooooo07oooooo00?o
0000ooooooooool02Oooool001Gooooo0ol0000Eooooo`03o`000?oooooooooo03Gooooo0_l0000/
ooooo`03o`000?oooooooooo04;ooooo00?o0000ooooooooool09oooool00ol0003oooooooooo`1o
ooooo`03o`000?oooooooooo00Wooooo000Dooooo`03o`000?oooooooooo01Kooooo00?o0000oooo
ooooool0=_ooool00ol0003oooooooooo`0Tooooo`03o`000?oooooooooo00?ooooo00?o0000oooo
ooooool0@_ooool00ol0003oooooooooo`0Wooooo`03o`000?oooooooooo07oooooo00?o0000oooo
ooooool02Oooool001Cooooo1Ol0000Dooooo`03o`000?oooooooooo03Kooooo00?o0000oooooooo
ool09?ooool2o`0000?ooooo0_l00014ooooo`03o`000?oooooooooo02Oooooo00?o0000oooooooo
ool0Ooooool00ol0003oooooooooo`09ooooo`005?ooool01Ol0003ooooooooooooooooo000001Co
oooo00?o0000ooooooooool0=_ooool2o`0002Kooooo0_l000001?oooooo0000o`000?l00013oooo
o`03o`000?oooooooooo02Sooooo00?o0000ooooooooool0Ooooool00ol0003oooooooooo`09oooo
o`005Oooool3o`0001Gooooo0_l0000hooooo`03o`000?oooooooooo02Cooooo1Ol00014ooooo`03
o`000?oooooooooo02Sooooo00?o0000ooooooooool0Ooooool00ol0003oooooooooo`09ooooo`00
;Oooool00ol0003oooooooooo`0gooooo`03o`000?oooooooooo02?ooooo1ol00013ooooo`03o`00
0?oooooooooo02Sooooo00?o0000ooooooooool0Ooooool00ol0003oooooooooo`09ooooo`005_oo
ool00ol0003oooooooooo`0Dooooo`03o`000?oooooooooo03Oooooo00?o0000ooooooooool08_oo
ool9o`0004;ooooo00?o0000ooooooooool0:?ooool00ol0003oooooooooo`1oooooo`03o`000?oo
oooooooo00Wooooo000Fooooo`03o`000?oooooooooo01Cooooo00?o0000ooooooooool0>?ooool0
0ol0003oooooooooo`0Pooooo`_o0000@Oooool00ol0003oooooooooo`0Xooooo`03o`000?oooooo
oooo07oooooo00?o0000ooooooooool02Oooool001Gooooo00?o0000ooooool000005Oooool00ol0
003oooooooooo`0hooooo`03o`000?oooooooooo02Cooooo0ol00015ooooo`03o`000?oooooooooo
02Sooooo00?o0000ooooooooool0Ooooool00ol0003oooooooooo`09ooooo`005Oooool00ol0003o
ooooo`00000Eooooo`;o0000>Oooool00ol0003oooooooooo`0Sooooo`Co0000A?ooool00ol0003o
ooooooooo`0Yooooo`03o`000?oooooooooo07oooooo00?o0000ooooooooool02Oooool001Cooooo
0_l000000ooooooo0000o`00000Dooooo`03o`000?oooooooooo03Oooooo0ol00003ooooo`03o`00
0?oooooooooo00;o00001Oooool00ol0003oooooooooo`02o`0000Cooooo00?o0000ooooooooool0
3Oooool00ol0003oooooooooo`13ooooo`03o`000?oooooooooo02Wooooo00?o0000ooooooooool0
Ooooool00ol0003oooooooooo`09ooooo`009Oooool3o`0000Gooooo00?o0000ooooooooool0=ooo
ool3o`000004ooooool0003o0000o`0000?ooooo0ol000001?oooooo0000o`000?l00002ooooo`?o
000000Coooooo`000?l0003o00003oooool00ol0003oooooooooo`13ooooo`03o`000?oooooooooo
02Wooooo00?o0000ooooooooool0Ooooool00ol0003oooooooooo`09ooooo`005Oooool3o`0000ko
oooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`0fooooo`Wo00000_ooool6o`0000Co
oooo1_l0000;ooooo`03o`000?oooooooooo04Oooooo00?o0000ooooooooool0:Oooool00ol0003o
ooooooooo`1oooooo`03o`000?oooooooooo00Wooooo000Dooooo`03o`000?oooooooooo00oooooo
00?o0000ooooooooool01?ooool00ol0003oooooooooo`0gooooo`So00000oooool5o`0000Cooooo
1Ol0001Fooooo`03o`000?oooooooooo02Wooooo00?o0000ooooooooool0Ooooool00ol0003ooooo
ooooo`09ooooo`005?ooool5o`0000gooooo00?o0000ooooooooool01?ooool2o`0003Sooooo2?l0
0002ooooo`So000000?oooooo`000?l000001Ol0001Dooooo`03o`000?oooooooooo02[ooooo00?o
0000ooooooooool0Ooooool00ol0003oooooooooo`09ooooo`005?ooool01Ol0003ooooooooooooo
oooo000000gooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`0fooooo`Wo000000?o
ooooo`000?l000004?l00008ooooo`03o`000?oooooooooo04Sooooo00?o0000ooooooooool0:_oo
ool00ol0003oooooooooo`0booooo`?o000000Coooooo`000?oooooooooo0ol00002ooooo`?o0000
00?oooooo`000?l000002?ooool2o`0000;ooooo0ol00004ooooo`Co00000oooool2o`0000Cooooo
0_l00003ooooo`Co00000oooool2o`0000;ooooo1Ol00006ooooo`03o`000?oooooooooo00Wooooo
000Eooooo`?o00003Oooool2o`0000Kooooo00?o0000ooooooooool0=OoooolNo`0005;ooooo00?o
0000ooooooooool0:_ooool00ol0003oooooooooo`0Cooooo`Wo00005oooool01_l0003ooooooooo
ool0003oooooo`0000?ooooo00Co0000oooooooooooo00000_ooool00ol0003oooooooooo`06oooo
o`04o`000?ooooooooooo`0000;ooooo00?o0000ooooooooool00_ooool01?l0003oooooooooool0
0003ooooo`04o`000?ooooooooooo`0000;ooooo00Ko0000oooooooooooo0000ooooool00002oooo
o`05o`000?ooooooooooooooool000000_ooool01Ol0003ooooooooooooooooo000000Sooooo00?o
0000ooooooooool02Oooool002Kooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`0i
ooooo`?o00001_ooool3o`0000Oooooo0ol00002ooooo`04o`000?oooooo0000o`00053ooooo00?o
0000ooooooooool0:_ooool00ol0003oooooooooo`04ooooobSo00001oooool01_l0003oooooo`00
0?l0003oooooo`0000?ooooo00Co0000oooooooooooo00000_ooool00ol0003oooooooooo`06oooo
o`03o`000?oooooooooo00?ooooo00?o0000ooooooooool00oooool3o`0000?ooooo00?o0000oooo
ooooool00oooool00ol0003oooooooooo`03ooooo`?o00000oooool00ol0003oooooooooo`04oooo
o`03o`000?oooooooooo00Kooooo00?o0000ooooooooool02Oooool001Cooooo0ol0000Fooooo`03
o`000?oooooooooo03Wooooo0ol00007ooooo`;o00001oooool3o`0000Cooooo0ol00002ooooo`;o
0000Boooool00ol0003oooooooooo`0Zooooo`03o`000?oooooooooo01Cooooo1ol0000Hooooo`06
o`000?oooooo0000o`000?oooooo00000oooool01?l0003oooooooooool00002ooooo`03o`000?oo
oooooooo00Kooooo00?o0000ooooooooool00oooool2o`0000?ooooo00Co0000oooooooooooo0000
0oooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00;ooooo00Co0000oooooooooooo
00000oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Kooooo00?o0000oooooooo
ool02Oooool001Gooooo00?o0000ooooooooool05Oooool2o`0003_ooooo00?o0000ooooool00000
1_ooool2o`0000Sooooo00?o0000ooooooooool01?ooool3o`000003ooooool0003o000004[ooooo
00?o0000ooooooooool0:oooool00ol0003oooooooooo`0Eooooo`Go00006Oooool2o`000004oooo
ool0003oooooooooo`?o00000_ooool4o`0000Sooooo1?l00002ooooo`;o000000?oooooo`000?l0
00000_ooool2o`0000?ooooo1?l00002ooooo`Co00000oooool2o`0000?ooooo1?l00002ooooo`?o
00002?ooool00ol0003oooooooooo`09ooooo`005Oooool00ol0003oooooooooo`0Eooooo`03o`00
0?oooooooooo03[ooooo00?o0000ooooool000004?ooool00ol0003oooooooooo`04ooooo`Go0000
Boooool00ol0003oooooooooo`0[ooooo`03o`000?oooooooooo01Kooooo0ol0000Jooooo`;o0000
00?oooooo`000?ooool04oooool00ol0003oooooooooo`0?ooooo`03o`000?oooooooooo00?ooooo
00?o0000ooooooooool02Oooool00ol0003oooooooooo`0=ooooo`03o`000?oooooooooo00Wooooo
000Eooooo`;o00005_ooool00ol0003oooooooooo`0mooooo`03o`000?oooooooooo01Cooooo1Ol0
001;ooooo`03o`000?oooooooooo02_ooooo00?o0000ooooooooool05_ooool3o`0001Wooooo0_l0
00001?oooooo0000o`000?l0000Cooooo`03o`000?oooooooooo00oooooo00?o0000ooooooooool0
0oooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool0
1_ooool00ol0003oooooooooo`09ooooo`005?ooool2o`000003ooooool0003o000001Cooooo00?o
0000ooooooooool0?Oooool00ol0003oooooooooo`0Cooooo`So0000BOooool00ol0003ooooooooo
o`0[ooooo`03o`000?oooooooooo01Oooooo00?o0000ooooooooool0IOooool00ol0003ooooooooo
o`09ooooo`00;Oooool00ol0003oooooooooo`0mooooo`03o`000?oooooooooo01;ooooo2ol00017
ooooo`03o`000?oooooooooo02_ooooo00?o0000ooooooooool0Ooooool00ol0003oooooooooo`09
ooooo`005?ooool5o`0001Cooooo0_l0000oooooo`03o`000?oooooooooo01Cooooo0ol0001;oooo
o`03o`000?oooooooooo02cooooo00?o0000ooooooooool0Ooooool00ol0003oooooooooo`09oooo
o`005_ooool00ol0003oooooooooo`0Dooooo`03o`000?oooooooooo03kooooo00?o0000oooooooo
ool05Oooool2o`0004_ooooo00?o0000ooooooooool0;?ooool00ol0003oooooooooo`1oooooo`03
o`000?oooooooooo00Wooooo000Fooooo`03o`000?oooooooooo01Cooooo00?o0000ooooooooool0
?oooool00ol0003oooooooooo`0Dooooo`;o0000Boooool00ol0003oooooooooo`0/ooooo`03o`00
0?oooooooooo07oooooo00?o0000ooooooooool02Oooool001Kooooo00?o0000ooooooooool05?oo
ool00ol0003oooooooooo`0oooooo`03o`000?oooooooooo01Cooooo00?o0000ooooooooool0B_oo
ool00ol0003oooooooooo`0/ooooo`03o`000?oooooooooo07oooooo00?o0000ooooooooool02Ooo
ool001Cooooo0ol0000Fooooo`03o`000?oooooooooo03oooooo00?o0000ooooooooool0HOooool0
0ol0003oooooooooo`0/ooooo`03o`000?oooooooooo07oooooo00?o0000ooooooooool02Oooool0
02gooooo0_l00011ooooo`03o`000?oooooooooo05oooooo00?o0000ooooooooool0;Oooool00ol0
003oooooooooo`1oooooo`03o`000?oooooooooo00Wooooo000Fooooo`;o00005Oooool00ol0003o
ooooooooo`10ooooo`03o`000?oooooooooo02;ooooo2Ol000000ooooooo0000o`000006o`000003
ooooool0003o000000Oo000000?oooooo`000?l000001_l000000ooooooo0000o`000007o`000003
ooooool0003o000000Ko000000?oooooo`000?l000001ol0000[ooooo`03o`000?oooooooooo07oo
oooo00?o0000ooooooooool02Oooool001Gooooo00Co0000oooooooooooo00005?ooool00ol0003o
ooooooooo`11ooooo`03o`000?oooooooooo02;ooooo@Ol0000[ooooo`03o`000?oooooooooo07oo
oooo00?o0000ooooooooool02Oooool001Gooooo00?o0000ooooooooool05Oooool00ol0003ooooo
ooooo`11ooooo`03o`000?oooooooooo02?ooooo1_l00003ooooo`Ko00001?ooool6o`0000?ooooo
1_l00003ooooo`Oo00000oooool6o`0000?ooooo1ol0000/ooooo`03o`000?oooooooooo07oooooo
00?o0000ooooooooool02Oooool001Gooooo00?o0000ooooooooool05Oooool00ol0003ooooooooo
o`11ooooo`03o`000?oooooooooo02?ooooo1_l00004ooooo`Go00001Oooool5o`0000Cooooo1Ol0
0004ooooo`Go00001Oooool5o`0000Cooooo1Ol0000]ooooo`03o`000?oooooooooo07oooooo00?o
0000ooooooooool02Oooool001Cooooo1?l0000Eooooo`;o0000@oooool00ol0003oooooooooo`0Q
ooooo`03o`000?oooooo000000?o00001_ooool3o`0000Kooooo1?l00006ooooo`?o00001_ooool3
o`0000Oooooo0ol00006ooooo`?o0000;_ooool00ol0003oooooooooo`1oooooo`03o`000?oooooo
oooo00Wooooo000Eooooo`03o`000?oooooooooo01Gooooo00?o0000ooooooooool0@_ooool00ol0
003oooooooooo`0Oooooo`;o00000oooool2o`0000Oooooo0_l00008ooooo`;o00001oooool2o`00
00Oooooo0ol00007ooooo`;o00001oooool3o`0002kooooo00?o0000ooooooooool0Ooooool00ol0
003oooooooooo`09ooooo`005Oooool2o`0000;ooooo0ol00004ooooo`03o`000?oooooooooo00;o
oooo0ol00005ooooo`03o`000?oooooooooo04?ooooo00?o0000ooooooooool07Oooool00ol0003o
ooooooooo`04ooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool01oooool00ol0003o
ooooooooo`06ooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool01oooool00ol0003o
ooooooooo`06ooooo`03o`000?oooooooooo02gooooo00?o0000ooooooooool0Ooooool00ol0003o
ooooooooo`09ooooo`005_ooool01Ol0003ooooooooooooooooo000000Wooooo00Go0000oooooooo
ooooooooo`000004ooooo`03o`000?oooooooooo043ooooo2?l0000Dooooo`Wo0000KOooool00ol0
003oooooooooo`1oooooo`03o`000?oooooooooo00Wooooo000Eooooo`03o`000?oooooo000000;o
oooo00?o0000ooooooooool02oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo047o
oooo1ol0000Eooooo`So0000KOooool00ol0003oooooooooo`1oooooo`03o`000?oooooooooo00Wo
oooo000Eooooo`03o`000?oooooo000000;ooooo00?o0000ooooooooool02oooool00ol0003ooooo
ooooo`02ooooo`;o0000@_ooool6o`0001Kooooo1ol0001^ooooo`03o`000?oooooooooo07oooooo
00?o0000ooooooooool02Oooool001Cooooo0_l000001Ooooooo0000o`000?oooooo000000Wooooo
1?l00005ooooo`03o`000?oooooooooo04;ooooo1Ol0000Gooooo`Go0000Koooool00ol0003ooooo
ooooo`1oooooo`03o`000?oooooooooo00Wooooo000Iooooo`;o00002Oooool00ol0003ooooooooo
o`06ooooo`03o`000?oooooooooo04;ooooo1?l0000Hooooo`Go0000Koooool00ol0003ooooooooo
o`1oooooo`03o`000?oooooooooo00Wooooo000Jooooo`03o`000?oooooooooo00Oooooo1Ol00004
ooooo`03o`000?oooooooooo04?ooooo0ol0000Iooooo`?o0000L?ooool00ol0003oooooooooo`1o
ooooo`03o`000?oooooooooo00Wooooo000]ooooo`03o`000?oooooooooo04?ooooo0ol0000Ioooo
o`?o0000L?oooon3o`0000_ooooo000]ooooo`;o0000AOooool2o`0001Sooooo00?o0000ooooool0
0000ooooool002gooooo00?o0000ooooooooool0AOooool00ol0003oooooooooo`0Fooooo`03o`00
0?oooooooooo0?oooooo000]ooooo`03o`000?oooooooooo04Gooooo00?o0000ooooooooool05_oo
ool00ol0003oooooooooo`3oooooo`00;Oooool00ol0003oooooooooo`16ooooo`03o`000?oooooo
oooo01Cooooo00?o0000ooooooooool0ooooool1ooooo`005?ooool5o`0001Cooooo00?o0000oooo
ooooool0A_ooool00ol0003oooooooooo`0Dooooo`03o`000?oooooooooo0?oooooo0Oooool001Ko
oooo00?o0000ooooooooool05?ooool2o`0004Oooooo00?o0000ooooooooool05?ooool00ol0003o
ooooooooo`3oooooo`7ooooo000Fooooo`03o`000?oooooooooo01Cooooo00?o0000ooooooooool0
A_ooool00ol0003oooooooooo`0Cooooo`03o`000?oooooooooo0?oooooo0_ooool001Kooooo00?o
0000ooooooooool05?ooool00ol0003oooooooooo`16ooooo`03o`000?oooooooooo01?ooooo00?o
0000ooooooooool0ooooool2ooooo`005?ooool3o`0001Kooooo00?o0000ooooooooool0Aoooool0
0ol0003oooooooooo`0Aooooo`03o`000?oooooooooo0?oooooo0oooool002gooooo00?o0000oooo
ooooool0Aoooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo0?oooooo0oooool001Co
oooo0ol000000ooooooo0000o`00000Cooooo`;o0000B?ooool00ol0003oooooooooo`0Aooooo`03
o`000?oooooooooo0?oooooo0oooool001Gooooo00Co0000oooooooooooo00005?ooool00ol0003o
ooooooooo`17ooooo`03o`000?oooooooooo013ooooo00?o0000ooooooooool0ooooool4ooooo`00
5Oooool01?l0003oooooooooool0000Dooooo`03o`000?oooooooooo04Sooooo00?o0000oooooooo
ool03oooool00ol0003oooooooooo`3oooooo`Cooooo000Eooooo`04o`000?ooooooooooo`0001Co
oooo00?o0000ooooooooool0B?ooool00ol0003oooooooooo`0?ooooo`03o`000?oooooooooo0?oo
oooo1?ooool001Cooooo1?l0000Eooooo`03o`000?oooooooooo04Sooooo00?o0000ooooooooool0
3_ooool00ol0003oooooooooo`3oooooo`Gooooo000]ooooo`;o0000BOooool00ol0003ooooooooo
o`0>ooooo`03o`000?oooooooooo0?oooooo1Oooool001Gooooo1?l0000Dooooo`03o`000?oooooo
oooo04Sooooo00?o0000ooooooooool03_ooool00ol0003oooooooooo`3oooooo`Gooooo000Doooo
o`04o`000?ooooooooooo`0000cooooo1Ol00004ooooo`03o`000?oooooooooo04Wooooo00?o0000
ooooooooool03?ooool00ol0003oooooooooo`3oooooo`Kooooo000Dooooo`04o`000?oooooooooo
o`0000gooooo00Co0000oooooooooooo00001?ooool00ol0003oooooooooo`19ooooo`03o`000?oo
oooooooo00Kooooo2Ol0003oooooo`Kooooo000Dooooo`04o`000?ooooooooooo`0000kooooo00?o
0000ooooooooool01?ooool00ol0003oooooooooo`19ooooo`03o`000?oooooooooo00Oooooo2?l0
003oooooo`Kooooo000Eooooo`?o00003oooool00ol0003oooooooooo`03ooooo`;o0000B_ooool0
0ol0003oooooooooo`08ooooo`Ko0000ooooool7ooooo`005oooool00ol0003oooooooooo`0:oooo
o`05o`000?ooooooooooooooool000001?ooool00ol0003oooooooooo`19ooooo`03o`000?oooooo
oooo00Sooooo1_l0003oooooo`Oooooo000Eooooo`?o00003?ooool01Ol0003ooooooooooooooooo
000000Cooooo00?o0000ooooooooool0B_ooool00ol0003oooooooooo`08ooooo`Co0000ooooool8
ooooo`005?ooool00ol0003oooooooooo`0>ooooo`?o00001Oooool00ol0003oooooooooo`1:oooo
o`03o`000?oooooooooo00Sooooo1?l0003oooooo`Sooooo000Dooooo`Go00005?ooool00ol0003o
ooooooooo`1:ooooo`03o`000?oooooooooo00Sooooo0ol0003oooooo`Wooooo000Dooooo`05o`00
0?ooooooooooooooool000005?ooool2o`0004_ooooo00?o0000ooooooooool01oooool01?l0003o
ooooooooool0003oooooo`Wooooo000Eooooo`?o00005Oooool00ol0003oooooooooo`1;ooooo`03
o`000?oooooooooo00Kooooo00?o0000ooooooooool0ooooool:ooooo`00;Oooool00ol0003ooooo
ooooo`1;ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool0ooooool;ooooo`005?oo
ool2o`000003ooooool0003o000001Cooooo00?o0000ooooooooool0Boooool00ol0003ooooooooo
o`05ooooo`03o`000?oooooooooo0?oooooo2oooool001Gooooo00?o0000ooooool000005Oooool2
o`0004cooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`3oooooo`cooooo000Foooo
o`03o`000?oooooooooo01Cooooo00?o0000ooooooooool0Boooool00ol0003oooooooooo`03oooo
o`03o`000?oooooooooo0?oooooo3Oooool001Gooooo00?o0000ooooool000005Oooool00ol0003o
ooooooooo`1<ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0ooooool=ooooo`00
5?ooool2o`000003ooooool0003o000001Cooooo00?o0000ooooooooool0C?ooool01Ol0003ooooo
oooooooooooo00000?oooooo4?ooool002gooooo00?o0000ooooooooool0C?ooool01Ol0003ooooo
oooooooooooo00000?oooooo4?ooool002gooooo0_l0001=ooooo`04o`000?ooooooooooo`000?oo
oooo4Oooool002gooooo00?o0000ooooooooool0BOooool9o`000?oooooo3oooool002gooooo00?o
0000ooooooooool0B_ooool8o`000?oooooo3oooool002gooooo00?o0000ooooooooool0B_ooool7
o`000?oooooo4?ooool002gooooo00?o0000ooooooooool0Boooool5o`000?oooooo4Oooool002go
oooo0_l0001<ooooo`Go0000oooooolAooooo`00;Oooool00ol0003oooooooooo`1<ooooo`?o0000
oooooolBooooo`00O?ooool3o`000?oooooo4_ooool007gooooo00?o0000ooooooooool0oooooolA
ooooo`00oooooonAooooo`00\
\>"],
  ImageRangeCache->{{{0, 399}, {153.5, 0}} -> {-1.08682, -0.648944, \
0.00845525, 0.00845525}, {{10.25, 246.75}, {149.812, 3.625}} -> {4.69224, \
-0.605113, 0.105772, 0.0201091}, {{258.625, 388.688}, {141.75, 44.1875}} -> \
{-6.78133, -0.403764, 0.025834, 0.025834}, {{265.562, 304.25}, {134.75, \
96.0625}} -> {-14.7287, -1.96933, 0.0516968, 0.0516968}, {{265.562, 304.25}, \
{89.8125, 51.125}} -> {-14.7287, -4.29245, 0.0516968, 0.0516968}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Esercizio", "Section",
  PageWidth->PaperWidth],

Cell[TextData[{
  "Individuate punti forti e punti deboli dell'ultimo grafico prodotto. \
Scrivete una funzione che generi lo stesso grafico utilizzando come argomento \
solo le due componenti del dataset. Modificate questa funzione in modo che \
accetti eventuali opzioni aggiuntive di ",
  StyleBox["MultipleListPlot", "Input"],
  "."
}], "Text",
  PageWidth->PaperWidth]
}, Open  ]],

Cell[CellGroupData[{

Cell["Modificare lo stile di un grafico", "Section",
  PageWidth->PaperWidth],

Cell[TextData[{
  "Il package ",
  StyleBox["Miscellaneous`ChemicalElements`", "Input"],
  " definisce un insieme di simboli in corrispondenza di ogni elemento, e \
riunisce tutti questi simboli nella lista ",
  StyleBox["Elements", "Input"],
  ":"
}], "Text",
  PageWidth->PaperWidth],

Cell[CellGroupData[{

Cell[BoxData[{
    \(<< Miscellaneous`ChemicalElements`\), "\[IndentingNewLine]", 
    \(Elements\)}], "Input",
  CellLabel->"In[18]:=",
  PageWidth->PaperWidth],

Cell[BoxData[
    \({Hydrogen, Helium, Lithium, Beryllium, Boron, Carbon, Nitrogen, Oxygen, 
      Fluorine, Neon, Sodium, Magnesium, Aluminium, Silicon, Phosphorus, 
      Sulfur, Chlorine, Argon, Potassium, Calcium, Scandium, Titanium, 
      Vanadium, Chromium, Manganese, Iron, Cobalt, Nickel, Copper, Zinc, 
      Gallium, Germanium, Arsenic, Selenium, Bromine, Krypton, Rubidium, 
      Strontium, Yttrium, Zirconium, Niobium, Molybdenum, Technetium, 
      Ruthenium, Rhodium, Palladium, Silver, Cadmium, Indium, Tin, Antimony, 
      Tellurium, Iodine, Xenon, Caesium, Barium, Lanthanum, Cerium, 
      Praseodymium, Neodymium, Promethium, Samarium, Europium, Gadolinium, 
      Terbium, Dysprosium, Holmium, Erbium, Thulium, Ytterbium, Lutetium, 
      Hafnium, Tantalum, Tungsten, Rhenium, Osmium, Iridium, Platinum, Gold, 
      Mercury, Thallium, Lead, Bismuth, Polonium, Astatine, Radon, Francium, 
      Radium, Actinium, Thorium, Protactinium, Uranium, Neptunium, Plutonium, 
      Americium, Curium, Berkelium, Californium, Einsteinium, Fermium, 
      Mendelevium, Nobelium, Lawrencium, Rutherfordium, Dubnium, Seaborgium, 
      Bohrium, Hassium, Meitnerium, Ununnilium, Unununium, 
      Ununbium}\)], "Output",
  CellLabel->"Out[19]="]
}, Open  ]],

Cell[TextData[{
  "Tra le altre cose, \[EGrave] possibile riferirsi ad un elemento \
utilizzando il suo nome o la corrispondente abbreviazione. E' inoltre \
disponibile la funzione ",
  StyleBox["AtomicNumber", "Input"],
  ", che fornisce il numero atomico di un generico elemento;"
}], "Text",
  PageWidth->PaperWidth],

Cell[CellGroupData[{

Cell[BoxData[
    \(AtomicNumber[Potassium]\)], "Input",
  CellLabel->"In[20]:=",
  PageWidth->PaperWidth],

Cell[BoxData[
    \(19\)], "Output",
  CellLabel->"Out[20]="]
}, Open  ]],

Cell[TextData[{
  "Nel file \"Ionization.m\", contenuto nella stessa directory di questo \
notebook, \[EGrave] contenuta la definizione della funzione ",
  StyleBox["Ionization", "Input"],
  ", che fornisce l'energia di ionizzazione di un elemento:"
}], "Text",
  PageWidth->PaperWidth],

Cell[CellGroupData[{

Cell[BoxData[{
    \(<< Ionization.m\), "\[IndentingNewLine]", 
    \(Ionization[Potassium]\)}], "Input",
  CellLabel->"In[21]:=",
  PageWidth->PaperWidth],

Cell[BoxData[
    \(\(418.8`\ Joule\ Kilo\)\/Mole\)], "Output",
  CellLabel->"Out[22]="]
}, Open  ]],

Cell[TextData[{
  "Scopo dell'esercizio \[EGrave] quello di visualizzare come l'energia di \
ionizzazione varia in funzione del numero atomico.\nCostruiamo una lista di \
coppie i cui elementi siano rispettivamente il numero atomico di un elemento \
e la corrispondente energia di ionizzazione. Siccome questa lista contiene pi\
\[UGrave] di 100 elementi, la visualizziamo in modo parziale utilizzando la \
funzione ",
  StyleBox["Short", "Input"],
  ":"
}], "Text",
  PageWidth->PaperWidth],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(ion = 
        Transpose[{AtomicNumber[Elements], 
            Ionization[Elements]}];\)\), "\[IndentingNewLine]", 
    \(Short[ion, 10]\)}], "Input",
  CellLabel->"In[23]:=",
  PageWidth->PaperWidth],

Cell[BoxData[
    TagBox[\({{1, \(1312.`\ Joule\ Kilo\)\/Mole}, {2, \(2372.3`\ Joule\ \
Kilo\)\/Mole}, {3, \(513.3`\ Joule\ Kilo\)\/Mole}, {4, \(899.4`\ Joule\ \
Kilo\)\/Mole}, {5, \(800.6`\ Joule\ Kilo\)\/Mole}, {6, \(1086.2`\ Joule\ Kilo\
\)\/Mole}, {7, \(1302.3`\ Joule\ Kilo\)\/Mole}, {8, \(1313.9`\ Joule\ \
Kilo\)\/Mole}, {9, \(1681\ Joule\ Kilo\)\/Mole}, {10, \(2080.6`\ Joule\ \
Kilo\)\/Mole}, {11, \(495.8`\ Joule\ Kilo\)\/Mole}, {12, \(737.7`\ Joule\ \
Kilo\)\/Mole}, \[LeftSkeleton]89\[RightSkeleton], {102, \(1284\ Joule\ Kilo\)\
\/Mole}, {103, Unknown}, {104, Unknown}, {105, Unknown}, {106, 
          Unknown}, {107, Ionization[Bohrium]}, {108, 
          Ionization[Hassium]}, {109, Ionization[Meitnerium]}, {110, 
          Ionization[Ununnilium]}, {111, Ionization[Unununium]}, {112, 
          Ionization[Ununbium]}}\),
      (Short[ #, 10]&)]], "Output",
  CellLabel->"Out[24]//Short="]
}, Open  ]],

Cell[TextData[{
  "Nella parte finale della lista, si verifica come la funzione Ionization \
risulti non definita per gli elementi con numero atomico tra 107 e 112 (ci\
\[OGrave] accade perch\[EGrave] la versione di ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " commercializzata quando Ionization \[EGrave] stata scritta implementava \
solo i primi 106 elementi), e ritorni il simbolo Unknown per gli elementi con \
numero atomico tra 103 e 106 (perch\[EGrave] al tempo dell'implementazione \
l'energia di ionizzazione per questi elementi era sconosciuta).\nEliminiamo \
dalla lista le coppie per cui non esiste un valore dell'energia di \
ionizzazione:"
}], "Text",
  PageWidth->PaperWidth],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(ion = 
        DeleteCases[
          ion, {n_, 
            Unknown | Ionization[elem_]}];\)\), "\[IndentingNewLine]", 
    \(Short[ion, 10]\)}], "Input",
  CellLabel->"In[25]:=",
  PageWidth->PaperWidth],

Cell[BoxData[
    TagBox[\({{1, \(1312.`\ Joule\ Kilo\)\/Mole}, {2, \(2372.3`\ Joule\ \
Kilo\)\/Mole}, {3, \(513.3`\ Joule\ Kilo\)\/Mole}, {4, \(899.4`\ Joule\ \
Kilo\)\/Mole}, {5, \(800.6`\ Joule\ Kilo\)\/Mole}, {6, \(1086.2`\ Joule\ Kilo\
\)\/Mole}, {7, \(1302.3`\ Joule\ Kilo\)\/Mole}, {8, \(1313.9`\ Joule\ \
Kilo\)\/Mole}, {9, \(1681\ Joule\ Kilo\)\/Mole}, {10, \(2080.6`\ Joule\ \
Kilo\)\/Mole}, {11, \(495.8`\ Joule\ Kilo\)\/Mole}, \[LeftSkeleton]80\
\[RightSkeleton], {92, \(584\ Joule\ Kilo\)\/Mole}, {93, \(597\ Joule\ Kilo\)\
\/Mole}, {94, \(585\ Joule\ Kilo\)\/Mole}, {95, \(578.2`\ Joule\ \
Kilo\)\/Mole}, {96, \(581\ Joule\ Kilo\)\/Mole}, {97, \(601\ Joule\ \
Kilo\)\/Mole}, {98, \(608\ Joule\ Kilo\)\/Mole}, {99, \(619\ Joule\ \
Kilo\)\/Mole}, {100, \(627\ Joule\ Kilo\)\/Mole}, {101, \(635\ Joule\ \
Kilo\)\/Mole}, {102, \(1284\ Joule\ Kilo\)\/Mole}}\),
      (Short[ #, 10]&)]], "Output",
  CellLabel->"Out[26]//Short="]
}, Open  ]],

Cell[TextData[{
  "Per poter visualizzare i dati contenuti nella lista \[EGrave] necessario \
eliminare i simboli ",
  StyleBox["Joule", "Input"],
  ", ",
  StyleBox["Kilo", "Input"],
  " e ",
  StyleBox["Mole", "Input"],
  ":"
}], "Text",
  PageWidth->PaperWidth],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(ion = ion /. Kilo\ Joule/Mole \[Rule] 1;\)\), "\[IndentingNewLine]", 
    \(Short[ion]\)}], "Input",
  CellLabel->"In[27]:=",
  PageWidth->PaperWidth],

Cell[BoxData[
    TagBox[\({{1, 1312.`}, {2, 2372.3`}, {3, 
          513.3`}, \[LeftSkeleton]96\[RightSkeleton], {100, 627}, {101, 
          635}, {102, 1284}}\),
      Short]], "Output",
  CellLabel->"Out[28]//Short="]
}, Open  ]],

Cell[TextData[{
  "A questo punto la lista \[EGrave] visualizzabile utilizzando ",
  StyleBox["MultipleListPlot", "Input"],
  " (la cui definizione \[EGrave] gi\[AGrave] presente nel kernel in quanto \
abbiamo caricato il package corrispondente nel precedente esercizio -- nel \
caso eseguiate solo questo esercizio sar\[AGrave] necessario caricare \
esplicitamente il package):"
}], "Text",
  PageWidth->PaperWidth],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(MultipleListPlot[ion];\)\)], "Input",
  CellLabel->"In[29]:=",
  PageWidth->PaperWidth],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
%%ImageSize: 400 247.214 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.00933707 -0.155516 0.000453103 [
[.21055 .01323 -6 -9 ]
[.21055 .01323 6 0 ]
[.39729 .01323 -6 -9 ]
[.39729 .01323 6 0 ]
[.58403 .01323 -6 -9 ]
[.58403 .01323 6 0 ]
[.77077 .01323 -6 -9 ]
[.77077 .01323 6 0 ]
[.95752 .01323 -9 -9 ]
[.95752 .01323 9 0 ]
[.01131 .11635 -18 -4.5 ]
[.01131 .11635 0 4.5 ]
[.01131 .20697 -18 -4.5 ]
[.01131 .20697 0 4.5 ]
[.01131 .29759 -24 -4.5 ]
[.01131 .29759 0 4.5 ]
[.01131 .38821 -24 -4.5 ]
[.01131 .38821 0 4.5 ]
[.01131 .47883 -24 -4.5 ]
[.01131 .47883 0 4.5 ]
[.01131 .56945 -24 -4.5 ]
[.01131 .56945 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21055 .02573 m
.21055 .03198 L
s
[(20)] .21055 .01323 0 1 Mshowa
.39729 .02573 m
.39729 .03198 L
s
[(40)] .39729 .01323 0 1 Mshowa
.58403 .02573 m
.58403 .03198 L
s
[(60)] .58403 .01323 0 1 Mshowa
.77077 .02573 m
.77077 .03198 L
s
[(80)] .77077 .01323 0 1 Mshowa
.95752 .02573 m
.95752 .03198 L
s
[(100)] .95752 .01323 0 1 Mshowa
.125 Mabswid
.07049 .02573 m
.07049 .02948 L
s
.11718 .02573 m
.11718 .02948 L
s
.16387 .02573 m
.16387 .02948 L
s
.25724 .02573 m
.25724 .02948 L
s
.30392 .02573 m
.30392 .02948 L
s
.35061 .02573 m
.35061 .02948 L
s
.44398 .02573 m
.44398 .02948 L
s
.49066 .02573 m
.49066 .02948 L
s
.53735 .02573 m
.53735 .02948 L
s
.63072 .02573 m
.63072 .02948 L
s
.6774 .02573 m
.6774 .02948 L
s
.72409 .02573 m
.72409 .02948 L
s
.81746 .02573 m
.81746 .02948 L
s
.86415 .02573 m
.86415 .02948 L
s
.91083 .02573 m
.91083 .02948 L
s
.25 Mabswid
0 .02573 m
1 .02573 L
s
.02381 .11635 m
.03006 .11635 L
s
[(600)] .01131 .11635 1 0 Mshowa
.02381 .20697 m
.03006 .20697 L
s
[(800)] .01131 .20697 1 0 Mshowa
.02381 .29759 m
.03006 .29759 L
s
[(1000)] .01131 .29759 1 0 Mshowa
.02381 .38821 m
.03006 .38821 L
s
[(1200)] .01131 .38821 1 0 Mshowa
.02381 .47883 m
.03006 .47883 L
s
[(1400)] .01131 .47883 1 0 Mshowa
.02381 .56945 m
.03006 .56945 L
s
[(1600)] .01131 .56945 1 0 Mshowa
.125 Mabswid
.02381 .04838 m
.02756 .04838 L
s
.02381 .07104 m
.02756 .07104 L
s
.02381 .09369 m
.02756 .09369 L
s
.02381 .139 m
.02756 .139 L
s
.02381 .16166 m
.02756 .16166 L
s
.02381 .18431 m
.02756 .18431 L
s
.02381 .22962 m
.02756 .22962 L
s
.02381 .25228 m
.02756 .25228 L
s
.02381 .27493 m
.02756 .27493 L
s
.02381 .32024 m
.02756 .32024 L
s
.02381 .3429 m
.02756 .3429 L
s
.02381 .36555 m
.02756 .36555 L
s
.02381 .41086 m
.02756 .41086 L
s
.02381 .43352 m
.02756 .43352 L
s
.02381 .45617 m
.02756 .45617 L
s
.02381 .50148 m
.02756 .50148 L
s
.02381 .52414 m
.02756 .52414 L
s
.02381 .54679 m
.02756 .54679 L
s
.02381 .00307 m
.02756 .00307 L
s
.02381 .5921 m
.02756 .5921 L
s
.02381 .61476 m
.02756 .61476 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.0001 w
.03315 .43896 -1.875 0 Mabsadd m
.03315 .43896 0 2.5 Mabsadd L
.03315 .43896 1.875 0 Mabsadd L
.03315 .43896 0 -2.5 Mabsadd L
.03315 .43896 -1.875 0 Mabsadd L closepath F
.04248 .91938 -1.875 0 Mabsadd m
.04248 .91938 0 2.5 Mabsadd L
.04248 .91938 1.875 0 Mabsadd L
.04248 .91938 0 -2.5 Mabsadd L
.04248 .91938 -1.875 0 Mabsadd L closepath F
.05182 .07706 -1.875 0 Mabsadd m
.05182 .07706 0 2.5 Mabsadd L
.05182 .07706 1.875 0 Mabsadd L
.05182 .07706 0 -2.5 Mabsadd L
.05182 .07706 -1.875 0 Mabsadd L closepath F
.06116 .25201 -1.875 0 Mabsadd m
.06116 .25201 0 2.5 Mabsadd L
.06116 .25201 1.875 0 Mabsadd L
.06116 .25201 0 -2.5 Mabsadd L
.06116 .25201 -1.875 0 Mabsadd L closepath F
.07049 .20724 -1.875 0 Mabsadd m
.07049 .20724 0 2.5 Mabsadd L
.07049 .20724 1.875 0 Mabsadd L
.07049 .20724 0 -2.5 Mabsadd L
.07049 .20724 -1.875 0 Mabsadd L closepath F
.07983 .33664 -1.875 0 Mabsadd m
.07983 .33664 0 2.5 Mabsadd L
.07983 .33664 1.875 0 Mabsadd L
.07983 .33664 0 -2.5 Mabsadd L
.07983 .33664 -1.875 0 Mabsadd L closepath F
.08917 .43456 -1.875 0 Mabsadd m
.08917 .43456 0 2.5 Mabsadd L
.08917 .43456 1.875 0 Mabsadd L
.08917 .43456 0 -2.5 Mabsadd L
.08917 .43456 -1.875 0 Mabsadd L closepath F
.09851 .43982 -1.875 0 Mabsadd m
.09851 .43982 0 2.5 Mabsadd L
.09851 .43982 1.875 0 Mabsadd L
.09851 .43982 0 -2.5 Mabsadd L
.09851 .43982 -1.875 0 Mabsadd L closepath F
.10784 .60615 -1.875 0 Mabsadd m
.10784 .60615 0 2.5 Mabsadd L
.10784 .60615 1.875 0 Mabsadd L
.10784 .60615 0 -2.5 Mabsadd L
.10784 .60615 -1.875 0 Mabsadd L closepath F
.11718 .78721 -1.875 0 Mabsadd m
.11718 .78721 0 2.5 Mabsadd L
.11718 .78721 1.875 0 Mabsadd L
.11718 .78721 0 -2.5 Mabsadd L
.11718 .78721 -1.875 0 Mabsadd L closepath F
.12652 .06913 -1.875 0 Mabsadd m
.12652 .06913 0 2.5 Mabsadd L
.12652 .06913 1.875 0 Mabsadd L
.12652 .06913 0 -2.5 Mabsadd L
.12652 .06913 -1.875 0 Mabsadd L closepath F
.13585 .17874 -1.875 0 Mabsadd m
.13585 .17874 0 2.5 Mabsadd L
.13585 .17874 1.875 0 Mabsadd L
.13585 .17874 0 -2.5 Mabsadd L
.13585 .17874 -1.875 0 Mabsadd L closepath F
.14519 .10611 -1.875 0 Mabsadd m
.14519 .10611 0 2.5 Mabsadd L
.14519 .10611 1.875 0 Mabsadd L
.14519 .10611 0 -2.5 Mabsadd L
.14519 .10611 -1.875 0 Mabsadd L closepath F
.15453 .20085 -1.875 0 Mabsadd m
.15453 .20085 0 2.5 Mabsadd L
.15453 .20085 1.875 0 Mabsadd L
.15453 .20085 0 -2.5 Mabsadd L
.15453 .20085 -1.875 0 Mabsadd L closepath F
.16387 .30289 -1.875 0 Mabsadd m
.16387 .30289 0 2.5 Mabsadd L
.16387 .30289 1.875 0 Mabsadd L
.16387 .30289 0 -2.5 Mabsadd L
.16387 .30289 -1.875 0 Mabsadd L closepath F
.1732 .29741 -1.875 0 Mabsadd m
.1732 .29741 0 2.5 Mabsadd L
.1732 .29741 1.875 0 Mabsadd L
.1732 .29741 0 -2.5 Mabsadd L
.1732 .29741 -1.875 0 Mabsadd L closepath F
.18254 .41136 -1.875 0 Mabsadd m
.18254 .41136 0 2.5 Mabsadd L
.18254 .41136 1.875 0 Mabsadd L
.18254 .41136 0 -2.5 Mabsadd L
.18254 .41136 -1.875 0 Mabsadd L closepath F
.19188 .53338 -1.875 0 Mabsadd m
.19188 .53338 0 2.5 Mabsadd L
.19188 .53338 1.875 0 Mabsadd L
.19188 .53338 0 -2.5 Mabsadd L
.19188 .53338 -1.875 0 Mabsadd L closepath F
.20121 .03424 -1.875 0 Mabsadd m
.20121 .03424 0 2.5 Mabsadd L
.20121 .03424 1.875 0 Mabsadd L
.20121 .03424 0 -2.5 Mabsadd L
.20121 .03424 -1.875 0 Mabsadd L closepath F
.21055 .11168 -1.875 0 Mabsadd m
.21055 .11168 0 2.5 Mabsadd L
.21055 .11168 1.875 0 Mabsadd L
.21055 .11168 0 -2.5 Mabsadd L
.21055 .11168 -1.875 0 Mabsadd L closepath F
.21989 .13039 -1.875 0 Mabsadd m
.21989 .13039 0 2.5 Mabsadd L
.21989 .13039 1.875 0 Mabsadd L
.21989 .13039 0 -2.5 Mabsadd L
.21989 .13039 -1.875 0 Mabsadd L closepath F
.22923 .14263 -1.875 0 Mabsadd m
.22923 .14263 0 2.5 Mabsadd L
.22923 .14263 1.875 0 Mabsadd L
.22923 .14263 0 -2.5 Mabsadd L
.22923 .14263 -1.875 0 Mabsadd L closepath F
.23856 .139 -1.875 0 Mabsadd m
.23856 .139 0 2.5 Mabsadd L
.23856 .139 1.875 0 Mabsadd L
.23856 .139 0 -2.5 Mabsadd L
.23856 .139 -1.875 0 Mabsadd L closepath F
.2479 .14022 -1.875 0 Mabsadd m
.2479 .14022 0 2.5 Mabsadd L
.2479 .14022 1.875 0 Mabsadd L
.2479 .14022 0 -2.5 Mabsadd L
.2479 .14022 -1.875 0 Mabsadd L closepath F
.25724 .16954 -1.875 0 Mabsadd m
.25724 .16954 0 2.5 Mabsadd L
.25724 .16954 1.875 0 Mabsadd L
.25724 .16954 0 -2.5 Mabsadd L
.25724 .16954 -1.875 0 Mabsadd L closepath F
.26657 .18853 -1.875 0 Mabsadd m
.26657 .18853 0 2.5 Mabsadd L
.26657 .18853 1.875 0 Mabsadd L
.26657 .18853 0 -2.5 Mabsadd L
.26657 .18853 -1.875 0 Mabsadd L closepath F
.27591 .18884 -1.875 0 Mabsadd m
.27591 .18884 0 2.5 Mabsadd L
.27591 .18884 1.875 0 Mabsadd L
.27591 .18884 0 -2.5 Mabsadd L
.27591 .18884 -1.875 0 Mabsadd L closepath F
.28525 .17829 -1.875 0 Mabsadd m
.28525 .17829 0 2.5 Mabsadd L
.28525 .17829 1.875 0 Mabsadd L
.28525 .17829 0 -2.5 Mabsadd L
.28525 .17829 -1.875 0 Mabsadd L closepath F
.29458 .18223 -1.875 0 Mabsadd m
.29458 .18223 0 2.5 Mabsadd L
.29458 .18223 1.875 0 Mabsadd L
.29458 .18223 0 -2.5 Mabsadd L
.29458 .18223 -1.875 0 Mabsadd L closepath F
.30392 .25518 -1.875 0 Mabsadd m
.30392 .25518 0 2.5 Mabsadd L
.30392 .25518 1.875 0 Mabsadd L
.30392 .25518 0 -2.5 Mabsadd L
.30392 .25518 -1.875 0 Mabsadd L closepath F
.31326 .10674 -1.875 0 Mabsadd m
.31326 .10674 0 2.5 Mabsadd L
.31326 .10674 1.875 0 Mabsadd L
.31326 .10674 0 -2.5 Mabsadd L
.31326 .10674 -1.875 0 Mabsadd L closepath F
.3226 .18979 -1.875 0 Mabsadd m
.3226 .18979 0 2.5 Mabsadd L
.3226 .18979 1.875 0 Mabsadd L
.3226 .18979 0 -2.5 Mabsadd L
.3226 .18979 -1.875 0 Mabsadd L closepath F
.33193 .27357 -1.875 0 Mabsadd m
.33193 .27357 0 2.5 Mabsadd L
.33193 .27357 1.875 0 Mabsadd L
.33193 .27357 0 -2.5 Mabsadd L
.33193 .27357 -1.875 0 Mabsadd L closepath F
.34127 .27081 -1.875 0 Mabsadd m
.34127 .27081 0 2.5 Mabsadd L
.34127 .27081 1.875 0 Mabsadd L
.34127 .27081 0 -2.5 Mabsadd L
.34127 .27081 -1.875 0 Mabsadd L closepath F
.35061 .36098 -1.875 0 Mabsadd m
.35061 .36098 0 2.5 Mabsadd L
.35061 .36098 1.875 0 Mabsadd L
.35061 .36098 0 -2.5 Mabsadd L
.35061 .36098 -1.875 0 Mabsadd L closepath F
.35994 .45649 -1.875 0 Mabsadd m
.35994 .45649 0 2.5 Mabsadd L
.35994 .45649 1.875 0 Mabsadd L
.35994 .45649 0 -2.5 Mabsadd L
.35994 .45649 -1.875 0 Mabsadd L closepath F
.36928 .02708 -1.875 0 Mabsadd m
.36928 .02708 0 2.5 Mabsadd L
.36928 .02708 1.875 0 Mabsadd L
.36928 .02708 0 -2.5 Mabsadd L
.36928 .02708 -1.875 0 Mabsadd L closepath F
.37862 .09346 -1.875 0 Mabsadd m
.37862 .09346 0 2.5 Mabsadd L
.37862 .09346 1.875 0 Mabsadd L
.37862 .09346 0 -2.5 Mabsadd L
.37862 .09346 -1.875 0 Mabsadd L closepath F
.38796 .1236 -1.875 0 Mabsadd m
.38796 .1236 0 2.5 Mabsadd L
.38796 .1236 1.875 0 Mabsadd L
.38796 .1236 0 -2.5 Mabsadd L
.38796 .1236 -1.875 0 Mabsadd L closepath F
.39729 .14353 -1.875 0 Mabsadd m
.39729 .14353 0 2.5 Mabsadd L
.39729 .14353 1.875 0 Mabsadd L
.39729 .14353 0 -2.5 Mabsadd L
.39729 .14353 -1.875 0 Mabsadd L closepath F
.40663 .14534 -1.875 0 Mabsadd m
.40663 .14534 0 2.5 Mabsadd L
.40663 .14534 1.875 0 Mabsadd L
.40663 .14534 0 -2.5 Mabsadd L
.40663 .14534 -1.875 0 Mabsadd L closepath F
.41597 .15486 -1.875 0 Mabsadd m
.41597 .15486 0 2.5 Mabsadd L
.41597 .15486 1.875 0 Mabsadd L
.41597 .15486 0 -2.5 Mabsadd L
.41597 .15486 -1.875 0 Mabsadd L closepath F
.4253 .16256 -1.875 0 Mabsadd m
.4253 .16256 0 2.5 Mabsadd L
.4253 .16256 1.875 0 Mabsadd L
.4253 .16256 0 -2.5 Mabsadd L
.4253 .16256 -1.875 0 Mabsadd L closepath F
.43464 .16664 -1.875 0 Mabsadd m
.43464 .16664 0 2.5 Mabsadd L
.43464 .16664 1.875 0 Mabsadd L
.43464 .16664 0 -2.5 Mabsadd L
.43464 .16664 -1.875 0 Mabsadd L closepath F
.44398 .17072 -1.875 0 Mabsadd m
.44398 .17072 0 2.5 Mabsadd L
.44398 .17072 1.875 0 Mabsadd L
.44398 .17072 0 -2.5 Mabsadd L
.44398 .17072 -1.875 0 Mabsadd L closepath F
.45331 .20923 -1.875 0 Mabsadd m
.45331 .20923 0 2.5 Mabsadd L
.45331 .20923 1.875 0 Mabsadd L
.45331 .20923 0 -2.5 Mabsadd L
.45331 .20923 -1.875 0 Mabsadd L closepath F
.46265 .1757 -1.875 0 Mabsadd m
.46265 .1757 0 2.5 Mabsadd L
.46265 .1757 1.875 0 Mabsadd L
.46265 .1757 0 -2.5 Mabsadd L
.46265 .1757 -1.875 0 Mabsadd L closepath F
.47199 .24167 -1.875 0 Mabsadd m
.47199 .24167 0 2.5 Mabsadd L
.47199 .24167 1.875 0 Mabsadd L
.47199 .24167 0 -2.5 Mabsadd L
.47199 .24167 -1.875 0 Mabsadd L closepath F
.48133 .09745 -1.875 0 Mabsadd m
.48133 .09745 0 2.5 Mabsadd L
.48133 .09745 1.875 0 Mabsadd L
.48133 .09745 0 -2.5 Mabsadd L
.48133 .09745 -1.875 0 Mabsadd L closepath F
.49066 .16555 -1.875 0 Mabsadd m
.49066 .16555 0 2.5 Mabsadd L
.49066 .16555 1.875 0 Mabsadd L
.49066 .16555 0 -2.5 Mabsadd L
.49066 .16555 -1.875 0 Mabsadd L closepath F
.5 .22224 -1.875 0 Mabsadd m
.5 .22224 0 2.5 Mabsadd L
.5 .22224 1.875 0 Mabsadd L
.5 .22224 0 -2.5 Mabsadd L
.5 .22224 -1.875 0 Mabsadd L closepath F
.50934 .23832 -1.875 0 Mabsadd m
.50934 .23832 0 2.5 Mabsadd L
.50934 .23832 1.875 0 Mabsadd L
.50934 .23832 0 -2.5 Mabsadd L
.50934 .23832 -1.875 0 Mabsadd L closepath F
.51867 .30139 -1.875 0 Mabsadd m
.51867 .30139 0 2.5 Mabsadd L
.51867 .30139 1.875 0 Mabsadd L
.51867 .30139 0 -2.5 Mabsadd L
.51867 .30139 -1.875 0 Mabsadd L closepath F
.52801 .3748 -1.875 0 Mabsadd m
.52801 .3748 0 2.5 Mabsadd L
.52801 .3748 1.875 0 Mabsadd L
.52801 .3748 0 -2.5 Mabsadd L
.52801 .3748 -1.875 0 Mabsadd L closepath F
.53735 .01472 -1.875 0 Mabsadd m
.53735 .01472 0 2.5 Mabsadd L
.53735 .01472 1.875 0 Mabsadd L
.53735 .01472 0 -2.5 Mabsadd L
.53735 .01472 -1.875 0 Mabsadd L closepath F
.54669 .0723 -1.875 0 Mabsadd m
.54669 .0723 0 2.5 Mabsadd L
.54669 .0723 1.875 0 Mabsadd L
.54669 .0723 0 -2.5 Mabsadd L
.54669 .0723 -1.875 0 Mabsadd L closepath F
.55602 .0883 -1.875 0 Mabsadd m
.55602 .0883 0 2.5 Mabsadd L
.55602 .0883 1.875 0 Mabsadd L
.55602 .0883 0 -2.5 Mabsadd L
.55602 .0883 -1.875 0 Mabsadd L closepath F
.56536 .08345 -1.875 0 Mabsadd m
.56536 .08345 0 2.5 Mabsadd L
.56536 .08345 1.875 0 Mabsadd L
.56536 .08345 0 -2.5 Mabsadd L
.56536 .08345 -1.875 0 Mabsadd L closepath F
.5747 .0815 -1.875 0 Mabsadd m
.5747 .0815 0 2.5 Mabsadd L
.5747 .0815 1.875 0 Mabsadd L
.5747 .0815 0 -2.5 Mabsadd L
.5747 .0815 -1.875 0 Mabsadd L closepath F
.58403 .08445 -1.875 0 Mabsadd m
.58403 .08445 0 2.5 Mabsadd L
.58403 .08445 1.875 0 Mabsadd L
.58403 .08445 0 -2.5 Mabsadd L
.58403 .08445 -1.875 0 Mabsadd L closepath F
.59337 .0873 -1.875 0 Mabsadd m
.59337 .0873 0 2.5 Mabsadd L
.59337 .0873 1.875 0 Mabsadd L
.59337 .0873 0 -2.5 Mabsadd L
.59337 .0873 -1.875 0 Mabsadd L closepath F
.60271 .09066 -1.875 0 Mabsadd m
.60271 .09066 0 2.5 Mabsadd L
.60271 .09066 1.875 0 Mabsadd L
.60271 .09066 0 -2.5 Mabsadd L
.60271 .09066 -1.875 0 Mabsadd L closepath F
.61204 .0922 -1.875 0 Mabsadd m
.61204 .0922 0 2.5 Mabsadd L
.61204 .0922 1.875 0 Mabsadd L
.61204 .0922 0 -2.5 Mabsadd L
.61204 .0922 -1.875 0 Mabsadd L closepath F
.62138 .11295 -1.875 0 Mabsadd m
.62138 .11295 0 2.5 Mabsadd L
.62138 .11295 1.875 0 Mabsadd L
.62138 .11295 0 -2.5 Mabsadd L
.62138 .11295 -1.875 0 Mabsadd L closepath F
.63072 .10031 -1.875 0 Mabsadd m
.63072 .10031 0 2.5 Mabsadd L
.63072 .10031 1.875 0 Mabsadd L
.63072 .10031 0 -2.5 Mabsadd L
.63072 .10031 -1.875 0 Mabsadd L closepath F
.64006 .10361 -1.875 0 Mabsadd m
.64006 .10361 0 2.5 Mabsadd L
.64006 .10361 1.875 0 Mabsadd L
.64006 .10361 0 -2.5 Mabsadd L
.64006 .10361 -1.875 0 Mabsadd L closepath F
.64939 .1076 -1.875 0 Mabsadd m
.64939 .1076 0 2.5 Mabsadd L
.64939 .1076 1.875 0 Mabsadd L
.64939 .1076 0 -2.5 Mabsadd L
.64939 .1076 -1.875 0 Mabsadd L closepath F
.65873 .11123 -1.875 0 Mabsadd m
.65873 .11123 0 2.5 Mabsadd L
.65873 .11123 1.875 0 Mabsadd L
.65873 .11123 0 -2.5 Mabsadd L
.65873 .11123 -1.875 0 Mabsadd L closepath F
.66807 .11485 -1.875 0 Mabsadd m
.66807 .11485 0 2.5 Mabsadd L
.66807 .11485 1.875 0 Mabsadd L
.66807 .11485 0 -2.5 Mabsadd L
.66807 .11485 -1.875 0 Mabsadd L closepath F
.6774 .11789 -1.875 0 Mabsadd m
.6774 .11789 0 2.5 Mabsadd L
.6774 .11789 1.875 0 Mabsadd L
.6774 .11789 0 -2.5 Mabsadd L
.6774 .11789 -1.875 0 Mabsadd L closepath F
.68674 .08168 -1.875 0 Mabsadd m
.68674 .08168 0 2.5 Mabsadd L
.68674 .08168 1.875 0 Mabsadd L
.68674 .08168 0 -2.5 Mabsadd L
.68674 .08168 -1.875 0 Mabsadd L closepath F
.69608 .13538 -1.875 0 Mabsadd m
.69608 .13538 0 2.5 Mabsadd L
.69608 .13538 1.875 0 Mabsadd L
.69608 .13538 0 -2.5 Mabsadd L
.69608 .13538 -1.875 0 Mabsadd L closepath F
.70542 .1893 -1.875 0 Mabsadd m
.70542 .1893 0 2.5 Mabsadd L
.70542 .1893 1.875 0 Mabsadd L
.70542 .1893 0 -2.5 Mabsadd L
.70542 .1893 -1.875 0 Mabsadd L closepath F
.71475 .19337 -1.875 0 Mabsadd m
.71475 .19337 0 2.5 Mabsadd L
.71475 .19337 1.875 0 Mabsadd L
.71475 .19337 0 -2.5 Mabsadd L
.71475 .19337 -1.875 0 Mabsadd L closepath F
.72409 .18884 -1.875 0 Mabsadd m
.72409 .18884 0 2.5 Mabsadd L
.72409 .18884 1.875 0 Mabsadd L
.72409 .18884 0 -2.5 Mabsadd L
.72409 .18884 -1.875 0 Mabsadd L closepath F
.73343 .22509 -1.875 0 Mabsadd m
.73343 .22509 0 2.5 Mabsadd L
.73343 .22509 1.875 0 Mabsadd L
.73343 .22509 0 -2.5 Mabsadd L
.73343 .22509 -1.875 0 Mabsadd L closepath F
.74276 .24322 -1.875 0 Mabsadd m
.74276 .24322 0 2.5 Mabsadd L
.74276 .24322 1.875 0 Mabsadd L
.74276 .24322 0 -2.5 Mabsadd L
.74276 .24322 -1.875 0 Mabsadd L closepath F
.7521 .23868 -1.875 0 Mabsadd m
.7521 .23868 0 2.5 Mabsadd L
.7521 .23868 1.875 0 Mabsadd L
.7521 .23868 0 -2.5 Mabsadd L
.7521 .23868 -1.875 0 Mabsadd L closepath F
.76144 .24779 -1.875 0 Mabsadd m
.76144 .24779 0 2.5 Mabsadd L
.76144 .24779 1.875 0 Mabsadd L
.76144 .24779 0 -2.5 Mabsadd L
.76144 .24779 -1.875 0 Mabsadd L closepath F
.77077 .30076 -1.875 0 Mabsadd m
.77077 .30076 0 2.5 Mabsadd L
.77077 .30076 1.875 0 Mabsadd L
.77077 .30076 0 -2.5 Mabsadd L
.77077 .30076 -1.875 0 Mabsadd L closepath F
.78011 .1115 -1.875 0 Mabsadd m
.78011 .1115 0 2.5 Mabsadd L
.78011 .1115 1.875 0 Mabsadd L
.78011 .1115 0 -2.5 Mabsadd L
.78011 .1115 -1.875 0 Mabsadd L closepath F
.78945 .16868 -1.875 0 Mabsadd m
.78945 .16868 0 2.5 Mabsadd L
.78945 .16868 1.875 0 Mabsadd L
.78945 .16868 0 -2.5 Mabsadd L
.78945 .16868 -1.875 0 Mabsadd L closepath F
.79879 .16311 -1.875 0 Mabsadd m
.79879 .16311 0 2.5 Mabsadd L
.79879 .16311 1.875 0 Mabsadd L
.79879 .16311 0 -2.5 Mabsadd L
.79879 .16311 -1.875 0 Mabsadd L closepath F
.80812 .2124 -1.875 0 Mabsadd m
.80812 .2124 0 2.5 Mabsadd L
.80812 .2124 1.875 0 Mabsadd L
.80812 .2124 0 -2.5 Mabsadd L
.80812 .2124 -1.875 0 Mabsadd L closepath F
.81746 .26587 -1.875 0 Mabsadd m
.81746 .26587 0 2.5 Mabsadd L
.81746 .26587 1.875 0 Mabsadd L
.81746 .26587 0 -2.5 Mabsadd L
.81746 .26587 -1.875 0 Mabsadd L closepath F
.8268 .31435 -1.875 0 Mabsadd m
.8268 .31435 0 2.5 Mabsadd L
.8268 .31435 1.875 0 Mabsadd L
.8268 .31435 0 -2.5 Mabsadd L
.8268 .31435 -1.875 0 Mabsadd L closepath F
.83613 .02573 -1.875 0 Mabsadd m
.83613 .02573 0 2.5 Mabsadd L
.83613 .02573 1.875 0 Mabsadd L
.83613 .02573 0 -2.5 Mabsadd L
.83613 .02573 -1.875 0 Mabsadd L closepath F
.84547 .07525 -1.875 0 Mabsadd m
.84547 .07525 0 2.5 Mabsadd L
.84547 .07525 1.875 0 Mabsadd L
.84547 .07525 0 -2.5 Mabsadd L
.84547 .07525 -1.875 0 Mabsadd L closepath F
.85481 .07058 -1.875 0 Mabsadd m
.85481 .07058 0 2.5 Mabsadd L
.85481 .07058 1.875 0 Mabsadd L
.85481 .07058 0 -2.5 Mabsadd L
.85481 .07058 -1.875 0 Mabsadd L closepath F
.86415 .11046 -1.875 0 Mabsadd m
.86415 .11046 0 2.5 Mabsadd L
.86415 .11046 1.875 0 Mabsadd L
.86415 .11046 0 -2.5 Mabsadd L
.86415 .11046 -1.875 0 Mabsadd L closepath F
.87348 .10185 -1.875 0 Mabsadd m
.87348 .10185 0 2.5 Mabsadd L
.87348 .10185 1.875 0 Mabsadd L
.87348 .10185 0 -2.5 Mabsadd L
.87348 .10185 -1.875 0 Mabsadd L closepath F
.88282 .1091 -1.875 0 Mabsadd m
.88282 .1091 0 2.5 Mabsadd L
.88282 .1091 1.875 0 Mabsadd L
.88282 .1091 0 -2.5 Mabsadd L
.88282 .1091 -1.875 0 Mabsadd L closepath F
.89216 .11499 -1.875 0 Mabsadd m
.89216 .11499 0 2.5 Mabsadd L
.89216 .11499 1.875 0 Mabsadd L
.89216 .11499 0 -2.5 Mabsadd L
.89216 .11499 -1.875 0 Mabsadd L closepath F
.90149 .10955 -1.875 0 Mabsadd m
.90149 .10955 0 2.5 Mabsadd L
.90149 .10955 1.875 0 Mabsadd L
.90149 .10955 0 -2.5 Mabsadd L
.90149 .10955 -1.875 0 Mabsadd L closepath F
.91083 .10647 -1.875 0 Mabsadd m
.91083 .10647 0 2.5 Mabsadd L
.91083 .10647 1.875 0 Mabsadd L
.91083 .10647 0 -2.5 Mabsadd L
.91083 .10647 -1.875 0 Mabsadd L closepath F
.92017 .10774 -1.875 0 Mabsadd m
.92017 .10774 0 2.5 Mabsadd L
.92017 .10774 1.875 0 Mabsadd L
.92017 .10774 0 -2.5 Mabsadd L
.92017 .10774 -1.875 0 Mabsadd L closepath F
.92951 .1168 -1.875 0 Mabsadd m
.92951 .1168 0 2.5 Mabsadd L
.92951 .1168 1.875 0 Mabsadd L
.92951 .1168 0 -2.5 Mabsadd L
.92951 .1168 -1.875 0 Mabsadd L closepath F
.93884 .11997 -1.875 0 Mabsadd m
.93884 .11997 0 2.5 Mabsadd L
.93884 .11997 1.875 0 Mabsadd L
.93884 .11997 0 -2.5 Mabsadd L
.93884 .11997 -1.875 0 Mabsadd L closepath F
.94818 .12496 -1.875 0 Mabsadd m
.94818 .12496 0 2.5 Mabsadd L
.94818 .12496 1.875 0 Mabsadd L
.94818 .12496 0 -2.5 Mabsadd L
.94818 .12496 -1.875 0 Mabsadd L closepath F
.95752 .12858 -1.875 0 Mabsadd m
.95752 .12858 0 2.5 Mabsadd L
.95752 .12858 1.875 0 Mabsadd L
.95752 .12858 0 -2.5 Mabsadd L
.95752 .12858 -1.875 0 Mabsadd L closepath F
.96685 .1322 -1.875 0 Mabsadd m
.96685 .1322 0 2.5 Mabsadd L
.96685 .1322 1.875 0 Mabsadd L
.96685 .1322 0 -2.5 Mabsadd L
.96685 .1322 -1.875 0 Mabsadd L closepath F
.97619 .42627 -1.875 0 Mabsadd m
.97619 .42627 0 2.5 Mabsadd L
.97619 .42627 1.875 0 Mabsadd L
.97619 .42627 0 -2.5 Mabsadd L
.97619 .42627 -1.875 0 Mabsadd L closepath F
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[29]:=",
  ImageSize->{400, 247.188},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006@0000mb000`400?l00000o`00003ooooooonA
ooooo`00oooooonAooooo`00oooooonAooooo`00oooooonAooooo`00oooooonAooooo`00GOooool5
o`0000?ooooo0_l0000oooooo`?o00000oooool2o`0003kooooo0ol00004ooooo`;o0000?_ooool3
o`0000Cooooo0_l0000jooooo`?o00001?ooool2o`0000Cooooo0_l0000;ooooo`00G_ooool01?l0
003oooooooooool00002ooooo`04o`000?ooooooooooo`0003oooooo00Go0000oooooooooooooooo
o`000002ooooo`03o`000?oooooooooo03[ooooo00Go0000ooooooooooooooooo`000002ooooo`04
o`000?ooooooooooo`0003cooooo00Go0000ooooooooooooooooo`000002ooooo`04o`000?oooooo
ooooo`0003[ooooo00?o0000ooooooooool00_ooool01?l0003oooooooooool00002ooooo`04o`00
0?ooooooooooo`0000[ooooo001Oooooo`03o`000?oooooooooo00;ooooo00Co0000oooooooooooo
0000??ooool5o`0000;ooooo00Co0000oooooooooooo0000??ooool01Ol0003ooooooooooooooooo
000000;ooooo00Co0000oooooooooooo0000??ooool01Ol0003ooooooooooooooooo000000;ooooo
00Co0000oooooooooooo0000>_ooool00ol0003oooooooooo`02ooooo`04o`000?ooooooooooo`00
00;ooooo00Co0000oooooooooooo00002_ooool001cooooo00?o0000ooooooooool0@Oooool01Ol0
003ooooooooooooooooo000000;ooooo00?o0000ooooooooool0>_ooool01?l0003oooooooooool0
0003ooooo`04o`000?ooooooooooo`0003cooooo1?l00003ooooo`04o`000?ooooooooooo`0003go
oooo0ol00003ooooo`04o`000?ooooooooooo`0003[ooooo00?o0000ooooooooool00_ooool01?l0
003oooooooooool00002ooooo`04o`000?ooooooooooo`0000[ooooo000Looooo`?o0000?_ooool0
1Ol0003ooooooooooooooooo000000;ooooo00Co0000oooooooooooo0000?Oooool00ol0003ooooo
o`000003ooooo`04o`000?ooooooooooo`0003cooooo00?o0000ooooooooool01?ooool01?l0003o
ooooooooool0000looooo`05o`000?ooooooooooooooool000000_ooool01?l0003oooooooooool0
000jooooo`03o`000?oooooooooo00;ooooo00Co0000oooooooooooo00000_ooool01?l0003ooooo
ooooool0000:ooooo`007?ooool00ol0003oooooooooo`0nooooo`05o`000?ooooooooooooooool0
00000_ooool01?l0003oooooooooool0000nooooo`;o00000oooool01?l0003oooooooooool0000m
ooooo`03o`000?oooooooooo00?ooooo00Co0000oooooooooooo0000??ooool01Ol0003ooooooooo
oooooooo000000;ooooo00Co0000oooooooooooo0000>Oooool2o`0000Cooooo00Co0000oooooooo
oooo00000_ooool01?l0003oooooooooool0000:ooooo`007?ooool00ol0003oooooooooo`0ooooo
o`?o00001?ooool2o`00043ooooo00?o0000ooooooooool00_ooool2o`0003oooooo0_l00004oooo
o`;o0000?_ooool3o`0000Cooooo0_l0000kooooo`03o`000?oooooooooo00?ooooo0_l00004oooo
o`;o00002oooool001cooooo00?o0000ooooooooool0oooooombooooo`007?ooool00ol0003ooooo
ooooo`30ooooo`03o`000?oooooooooo0:kooooo000Looooo`03o`000?oooooooooo0;oooooo0ol0
002_ooooo`007?ooool00ol0003oooooooooo`2oooooo`?o0000[oooool001cooooo00?o0000oooo
ooooool0`?ooool00ol0003oooooooooo`2^ooooo`007?ooool00ol0003oooooooooo`20ooooo`03
o`000?oooooooooo0:kooooo00?o0000ooooooooool0?Oooool001?oooooool0001no`0000007?oo
ool00ol0003oooooooooo`0?ooooo`03o`000?oooooooooo00oooooo00?o0000ooooooooool03_oo
ool00ol0003oooooooooo`0?ooooo`03o`000?oooooooooo00oooooo00?o0000ooooooooool03_oo
ool00ol0003oooooooooo`0?ooooo`03o`000?oooooooooo00;ooooo1?l00009ooooo`03o`000?oo
oooooooo00oooooo00?o0000ooooooooool03_ooool00ol0003oooooooooo`0?ooooo`03o`000?oo
oooooooo00oooooo00?o0000ooooooooool03_ooool00ol0003oooooooooo`0?ooooo`03o`000?oo
oooooooo00oooooo00?o0000ooooooooool03oooool00ol0003oooooooooo`0>ooooo`03o`000?oo
oooooooo00?ooooo0ol00009ooooo`03o`000?oooooooooo00oooooo00?o0000ooooooooool03_oo
ool00ol0003oooooooooo`0?ooooo`007?ooool00ol0003oooooooooo`14ooooo`03o`000?oooooo
oooo03Sooooo0ol00009ooooo`03o`000?oooooooooo04Cooooo00?o0000ooooooooool0A?ooool0
0ol0003oooooooooo`0Eooooo`03o`000?oooooooooo02_ooooo00?o0000ooooooooool03oooool0
01cooooo00?o0000ooooooooool0@?ooool2o`0003kooooo00?o0000ooooooooool0k_ooool001co
oooo00?o0000ooooooooool0?oooool3o`000?oooooo<?ooool001cooooo00?o0000ooooooooool0
@?ooool2o`000?oooooo<?ooool001cooooo00?o0000ooooooooool0oooooombooooo`007?ooool0
0ol0003oooooooooo`3oooooog;ooooo000Looooo`03o`000?oooooooooo0?ooooooL_ooool001co
oooo0ol0003oooooog;ooooo000Looooo`03o`000?oooooooooo0?ooooooL_ooool001cooooo00?o
0000ooooooooool0oooooombooooo`007?ooool00ol0003oooooooooo`3oooooog;ooooo000Loooo
o`03o`000?oooooooooo0?ooooooL_ooool001cooooo00?o0000ooooooooool0oooooombooooo`00
7?ooool00ol0003oooooooooo`0Tooooo`03o`000?oooooooooo0?ooooooBoooool001cooooo00?o
0000ooooooooool08oooool3o`000?oooooo4oooool00ol0003oooooooooo`0fooooo`007?ooool3
o`0002;ooooo1?l0002Nooooo`03o`000?oooooooooo073ooooo0ol0000gooooo`007?ooool00ol0
003oooooooooo`08ooooo`03o`000?oooooooooo01Sooooo0ol0002Mooooo`;o0000L?ooool00ol0
003oooooo`000002o`0003Oooooo000Looooo`03o`000?oooooooooo00Oooooo0ol0000Jooooo`03
o`000?oooooooooo09cooooo0_l0001_ooooo`?o000000?oooooo`000?ooool0=oooool001cooooo
00?o0000ooooooooool01_ooool4o`000;[ooooo00?o0000ooooooooool01oooool00ol0003ooooo
ooooo`0Xooooo`03o`000?oooooooooo03Sooooo0ol0000jooooo`007?ooool00ol0003ooooooooo
o`07ooooo`?o0000`Oooool00ol0003oooooo`000002o`0000;ooooo00?o0000ooooooooool08ooo
ool3o`0003[ooooo00?o0000ooooooooool0>Oooool001cooooo00?o0000ooooooooool02?ooool0
0ol0003oooooooooo`2oooooo`Ko000000Koooooo`000?l0003o0000ooooool0000Qooooo`Co0000
M_ooool001cooooo00?o0000ooooooooool0aoooool00ol0003oooooooooo`0=o`00027ooooo0ol0
001fooooo`007?ooool00ol0003oooooooooo`36ooooo`?o00000_ooool01?l0003oooooooooool0
0002ooooo`Ko00000_ooool01?l0003oooooooooool0000Looooo`03o`000?oooooooooo07Gooooo
000Looooo`03o`000?oooooooooo08Cooooo00?o0000ooooooooool0?oooool3o`0000Wooooo00?o
0000ooooool000000_l000000ooooooo0000o`000004o`0009?ooooo000Looooo`?o0000Poooool3
o`0002Gooooo00?o0000ooooooooool06Oooool00ol0003oooooooooo`0;ooooo`03o`000?oooooo
oooo00Ko0000Toooool001cooooo00?o0000ooooooooool0Poooool3o`0002Cooooo0ol0000/oooo
o`03o`000?oooooo000000;o00001Oooool00ol0003oooooooooo`2;ooooo`007?ooool00ol0003o
ooooooooo`24ooooo`03o`000?oooooooooo02;ooooo1?l0000_ooooo`03o`000?oooooooooo00Co
oooo0_l00002ooooo`03o`000?oooooooooo05Kooooo00?o0000ooooooooool0;_ooool001cooooo
00?o0000ooooooooool0:oooool00ol0003oooooooooo`1looooo`?o0000=Oooool3o`000004oooo
ool0003o0000o`0005Kooooo0_l0000`ooooo`007?ooool00ol0003oooooooooo`0Zooooo`?o0000
?_ooool00ol0003oooooooooo`0mooooo`03o`000?oooooooooo03Gooooo1_l0001Fooooo`;o0000
3Oooool01?l0003oooooooooool0000Oooooo`007?ooool00ol0003oooooooooo`0Yooooo`Co0000
?Oooool3o`0007Kooooo00?o0000ooooooooool00ol000000ooooooo0000o`000002ooooo`03o`00
0?oooooooooo02_ooooo00?o0000ooooooooool07Oooool01Ol0003ooooooooooooooooo000000;o
oooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`06o`0001kooooo0007ooooo`?o0000
1?ooool2o`0000Cooooo0_l00006ooooo`03o`000?oooooooooo02[ooooo0ol0000Gooooo`03o`00
0?oooooooooo02?ooooo0ol0001cooooo`03o`000?oooooooooo00Cooooo00?o0000ooooool00000
0_l000001?oooooo0000o`000?l0000[ooooo`?o00007Oooool3o`0000Cooooo0ol00004ooooo`?o
000000?oooooo`000?l000001?l0000Nooooo`001_ooool01Ol0003ooooooooooooooooo000000;o
oooo00Co0000oooooooooooo00000_ooool01?l0003oooooooooool00005ooooo`03o`000?oooooo
oooo02_ooooo00?o0000ooooooooool05Oooool3o`0002Gooooo00?o0000ooooooooool0LOooool3
o`0000Sooooo1_l00002ooooo`03o`000?oooooooooo02Gooooo1?l0000Looooo`Co00001?ooool3
o`0000;ooooo00?o0000ooooool000000_l00002ooooo`03o`000?oooooo000000;o00000_ooool0
0ol0003oooooooooo`0Iooooo`001_ooool01Ol0003ooooooooooooooooo000000;ooooo00Co0000
oooooooooooo00000_ooool01?l0003oooooooooool00005ooooo`Co0000@_ooool3o`0009Sooooo
1?l0000;ooooo`?o000000?oooooo`000?l000000_ooool00ol0003oooooooooo`0Sooooo`?o0000
7Oooool3o`0000Gooooo00?o0000ooooooooool00_l00002ooooo`03o`000?oooooooooo00Cooooo
00?o0000ooooooooool00ol0000Jooooo`001_ooool4o`0000?ooooo00Co0000oooooooooooo0000
0_ooool01?l0003oooooooooool00005ooooo`03o`000?oooooooooo04Cooooo00?o0000oooooooo
ool0V?ooool3o`0000cooooo00?o0000ooooooooool00_l000001?oooooo0000o`000?l0000Uoooo
o`03o`000?oooooooooo01gooooo00?o0000ooooooooool01oooool2o`0000_ooooo1?l000000ooo
oooo0000ooooo`0Gooooo`001_ooool00ol0003oooooooooo`04ooooo`04o`000?ooooooooooo`00
00;ooooo00Co0000oooooooooooo00001Oooool00ol0003oooooooooo`27ooooo`03o`000?oooooo
oooo05Kooooo00?o0000ooooooooool03oooool00ol0003oooooo`000002o`00053ooooo00?o0000
ooooooooool02_ooool6o`0001Oooooo0007ooooo`03o`000?oooooooooo00?ooooo00Co0000oooo
oooooooo00000_ooool01?l0003oooooooooool00005ooooo`03o`000?oooooooooo08Kooooo0ol0
001/ooooo`03o`000?oooooooooo05gooooo00?o0000ooooool000000_l00002ooooo`03o`000?oo
oooooooo01;ooooo0008ooooo`;o00001?ooool2o`0000Cooooo0_l00006ooooo`03o`000?oooooo
oooo08Gooooo1?l0003?ooooo`03o`000?oooooooooo00?o000000?oooooo`000?ooool04?ooool0
01cooooo00?o0000ooooooooool0B?ooool00ol0003oooooooooo`0kooooo`?o0000d_ooool6o`00
00;ooooo00?o0000ooooooooool02oooool001cooooo00?o0000ooooooooool0Aoooool2o`0003ko
oooo00?o0000ooooooooool0d_ooool00ol0003oooooo`000002o`000004ooooool0003o0000o`00
00cooooo000Looooo`03o`000?oooooooooo04Oooooo0_l0002cooooo`03o`000?oooooooooo063o
oooo00?o0000ooooool000000ol0000<ooooo`007?ooool00ol0003oooooooooo`18ooooo`03o`00
0?oooooooooo00Cooooo00Co0000oooooooooooo0000Z?ooool3o`0006Cooooo0ol0000<ooooo`00
7?ooool3o`0004_ooooo00?o0000ooooooooool01_l0002Wooooo`?o0000IOooool00ol0003ooooo
ooooo`0;ooooo`007?ooool00ol0003oooooooooo`1:ooooo`?o000000?oooooo`000?l000001?l0
000gooooo`04o`000?ooooooooooo`0006gooooo00?o0000ooooooooool0L_ooool001cooooo00?o
0000ooooooooool0BOooool4o`0000;ooooo00?o0000ooooool000000_l0000fooooo`?o000000?o
ooooo`000?l00000hOooool001cooooo00?o0000ooooooooool0B_ooool3o`0000Gooooo00?o0000
ooooooooool0=Oooool6o`000>7ooooo000Looooo`03o`000?oooooooooo04_ooooo00?o0000oooo
ooooool0?Oooool00ol0003oooooooooo`02o`000>7ooooo000Looooo`03o`000?oooooooooo08ko
oooo00Go0000ooooooooooooooooo`00003Nooooo`007?ooool00ol0003oooooooooo`2Aooooo`?o
0000gOooool001cooooo00?o0000ooooooooool0TOooool3o`000=gooooo000Looooo`03o`000?oo
oooooooo09;ooooo00Go0000ooooooooooooooooo`00002<ooooo`03o`000?oooooooooo04_ooooo
000Looooo`?o0000UOooool2o`0000;ooooo00?o0000ooooooooool04_ooool00ol0003ooooooooo
o`1aooooo`?o0000C?ooool001cooooo00?o0000ooooooooool0E_ooool00ol0003oooooooooo`0l
ooooo`;o000000Coooooo`000?l0003o00004_ooool3o`00073ooooo1Ol0001<ooooo`007?ooool0
0ol0003oooooooooo`1Eooooo`?o0000?_ooool5o`0000;ooooo00?o0000ooooooooool03Oooool3
o`0006oooooo1_l0001<ooooo`007?ooool00ol0003oooooooooo`1Dooooo`Co0000@?ooool3o`00
0003ooooool0003o0000013ooooo00?o0000ooooooooool0KOooool4o`000003ooooool0003ooooo
04cooooo000Looooo`03o`000?oooooooooo05Gooooo0ol00011ooooo`03o`000?oooooooooo00;o
00001_ooool00ol0003oooooooooo`1hooooo`?o0000Coooool001cooooo00?o0000ooooooooool0
:?ooool00ol0003oooooooooo`0[ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool0
>_ooool00ol0003oooooooooo`03ooooo`?o0000N_ooool00ol0003oooooooooo`1>ooooo`007?oo
ool00ol0003oooooooooo`0Wooooo`?o0000=Oooool3o`0000;ooooo00?o0000ooooooooool0??oo
ool3o`000<_ooooo000Looooo`03o`000?oooooooooo02Oooooo0ol0000eooooo`?o000000Cooooo
o`000?l0003o0000?_ooool00ol0003oooooooooo`3:ooooo`007?ooool3o`0002Sooooo00?o0000
ooooooooool0=Oooool00ol0003oooooo`000003o`000?oooooo3?ooool001cooooo00?o0000oooo
ooooool0FOooool01Ol0003ooooooooooooooooo000000Gooooo0ol0002Jooooo`03o`000?oooooo
oooo00Cooooo00?o0000ooooooooool0Ioooool001cooooo00?o0000ooooooooool0F?ooool3o`00
0004ooooool0003o0000o`0000Gooooo00?o0000ooooooooool01oooool2o`0008oooooo0ol00004
ooooo`?o0000J?ooool001cooooo00?o0000ooooooooool0F?ooool3o`000004ooooool0003o0000
o`0000kooooo0ol0002?ooooo`?o000000Coooooo`000?oooooooooo0ol0001Xooooo`007?ooool0
0ol0003oooooooooo`1Iooooo`05o`000?ooooooooooooooool000004?ooool2o`00093ooooo00?o
0000ooooool000000_l00002ooooo`03o`000?oooooooooo06Oooooo000Looooo`03o`000?oooooo
oooo02oooooo00?o0000ooooooooool0d?ooool3o`0006cooooo0007ooooo`?o00001?ooool2o`00
00Cooooo0_l00006ooooo`03o`000?oooooooooo02kooooo0ol0003Booooo`03o`000?oooooooooo
06_ooooo0006ooooo`05o`000?ooooooooooooooool000000_ooool01?l0003oooooooooool00002
ooooo`04o`000?ooooooooooo`0000Gooooo00?o0000ooooooooool0;Oooool4o`000?oooooo@Ooo
ool000Kooooo00Go0000ooooooooooooooooo`000002ooooo`04o`000?ooooooooooo`0000;ooooo
00Co0000oooooooooooo00001Oooool00ol0003oooooooooo`0?ooooo`03o`000?oooooooooo01co
oooo0ol0003ooooood7ooooo0007ooooo`?o00000oooool01?l0003oooooooooool00002ooooo`04
o`000?ooooooooooo`0000Gooooo1?l0000=ooooo`?o00007_ooool00ol0003oooooooooo`1^oooo
o`03o`000?oooooooooo0<kooooo0006ooooo`05o`000?ooooooooooooooool000000_ooool01?l0
003oooooooooool00002ooooo`04o`000?ooooooooooo`0000Gooooo00?o0000ooooooooool03_oo
ool3o`0008kooooo0ol00025ooooo`03o`000?oooooooooo04Oooooo0006ooooo`05o`000?oooooo
ooooooooool000000_ooool01?l0003oooooooooool00002ooooo`04o`000?ooooooooooo`0000Go
oooo00?o0000ooooooooool03oooool00ol0003oooooooooo`2=ooooo`?o0000Q?ooool3o`0004So
oooo0007ooooo`?o00001?ooool2o`0000Cooooo0_l00006ooooo`03o`000?oooooooooo0:3ooooo
00?o0000ooooooooool0Poooool3o`0004Sooooo000Looooo`03o`000?oooooooooo0;;ooooo00?o
0000ooooooooool0L_ooool00ol0003oooooooooo`17ooooo`007?ooool00ol0003oooooooooo`2a
ooooo`?o0000_Oooool001cooooo00?o0000ooooooooool0/?ooool4o`0005Kooooo00?o0000oooo
ooooool0I?ooool001cooooo00?o0000ooooooooool0/Oooool3o`0005Gooooo0ol0001Uooooo`00
7?ooool3o`000;;ooooo00?o0000ooooooooool0E?ooool3o`0006Gooooo000Looooo`03o`000?oo
oooooooo0?oooooo2oooool00ol0003oooooooooo`1Tooooo`007?ooool00ol0003oooooooooo`3o
ooooog;ooooo000Looooo`03o`000?oooooooooo0;Gooooo00?o0000ooooooooool0FOooool00ol0
003oooooooooo`1Mooooo`007?ooool00ol0003oooooooooo`2Wooooo`03o`000?oooooooooo00[o
oooo0ol0001Gooooo`03o`000?oooooo000000;o0000G_ooool001cooooo00?o0000ooooooooool0
Y_ooool3o`0000_ooooo0ol0001Fooooo`Ko0000G_ooool001cooooo00?o0000ooooooooool0Y_oo
ool3o`0000cooooo00?o0000ooooooooool0E?ooool4o`000003ooooool0003ooooo00;ooooo00?o
0000ooooooooool0FOooool001cooooo00?o0000ooooooooool0Yoooool00ol0003oooooooooo`1S
ooooo`?o00001?ooool3o`0005[ooooo000Looooo`03o`000?oooooooooo00_ooooo00?o0000oooo
ooooool0ooooool1ooooo`03o`000?oooooooooo00;ooooo1?l0001Jooooo`007?ooool3o`0000[o
oooo0ol0001Jooooo`03o`000?oooooooooo0:[ooooo0ol0001Jooooo`007?ooool00ol0003ooooo
ooooo`0:ooooo`?o0000FOooool3o`000:cooooo00?o0000ooooooooool0FOooool001cooooo00?o
0000ooooooooool02oooool00ol0003oooooooooo`1Hooooo`?o0000ooooool9ooooo`007?ooool0
0ol0003oooooooooo`1Wooooo`03o`000?oooooooooo0?oooooo2?ooool001cooooo00?o0000oooo
ooooool0ooooool[ooooo`03o`000?oooooooooo04Cooooo000Looooo`03o`000?oooooooooo0?oo
oooo:_ooool3o`0004Gooooo000Looooo`03o`000?oooooooooo07Kooooo00?o0000ooooooooool0
[oooool4o`0004Gooooo000Looooo`03o`000?oooooooooo07;ooooo00?o0000ooooooooool00ol0
002aooooo`?o0000AOooool001cooooo0ol0001aooooo`?o000000Coooooo`000?l0003o0000/_oo
ool00ol0003oooooooooo`14ooooo`007?ooool00ol0003oooooooooo`1aooooo`?o00000_ooool0
0ol0003oooooooooo`3hooooo`007?ooool00ol0003oooooooooo`1booooo`03o`000?oooooooooo
0?cooooo000Looooo`03o`000?oooooooooo0?ooooooL_ooool001cooooo00?o0000ooooooooool0
oooooombooooo`007?ooool00ol0003oooooooooo`3oooooog;ooooo000Looooo`03o`000?oooooo
oooo0?ooooooL_ooool00004ooooool0003o0000o`0000Cooooo0_l00004ooooo`;o00001?ooool2
o`0000Kooooo00?o0000ooooooooool0oooooombooooo`000_ooool00ol0003oooooooooo`02oooo
o`04o`000?ooooooooooo`0000;ooooo00Co0000oooooooooooo00000_ooool01?l0003ooooooooo
ool00005ooooo`03o`000?oooooooooo03Kooooo00?o0000ooooooooool0ooooooliooooo`000_oo
ool00ol0003oooooooooo`02ooooo`04o`000?ooooooooooo`0000;ooooo00Co0000oooooooooooo
00000_ooool01?l0003oooooooooool00005ooooo`Co0000=?ooool3o`000?oooooo>_ooool000;o
oooo00?o0000ooooooooool00_ooool01?l0003oooooooooool00002ooooo`04o`000?oooooooooo
o`0000;ooooo00Co0000oooooooooooo00001Oooool00ol0003oooooooooo`0booooo`03o`000?oo
oooooooo00?o0000POooool00ol0003oooooooooo`1Looooo`;o0000Eoooool000;ooooo00?o0000
ooooooooool00_ooool01?l0003oooooooooool00002ooooo`04o`000?ooooooooooo`0000;ooooo
00Co0000oooooooooooo00001Oooool00ol0003oooooooooo`0aooooo`?o00000_ooool00ol0003o
ooooooooo`1oooooo`?o0000G?ooool3o`0005Oooooo00000ooooooo0000o`000004ooooo`04o`00
0?ooooooooooo`0000;ooooo00Co0000oooooooooooo00000_ooool01?l0003oooooooooool00005
ooooo`03o`000?oooooooooo033ooooo1?l00024ooooo`?o0000GOooool2o`0005Oooooo0002oooo
o`03o`000?oooooooooo00?ooooo0_l00004ooooo`;o00001?ooool2o`0000Kooooo00?o0000oooo
ooooool0<Oooool3o`0008Gooooo00?o0000ooooooooool0]Oooool001cooooo00?o0000oooooooo
ool0<_ooool00ol0003oooooooooo`3iooooo`03o`000?oooooooooo043ooooo000Looooo`03o`00
0?oooooooooo0?oooooo;_ooool3o`00047ooooo000Looooo`03o`000?oooooooooo0?oooooo;Ooo
ool4o`00047ooooo000Looooo`03o`000?oooooooooo0?oooooo;_ooool3o`00047ooooo000Loooo
o`?o0000ooooool_ooooo`03o`000?oooooooooo043ooooo000Looooo`03o`000?oooooooooo0?oo
ooooL_ooool001cooooo00?o0000ooooooooool0oooooombooooo`007?ooool00ol0003ooooooooo
o`3oooooog;ooooo000Looooo`03o`000?oooooooooo0?ooooooL_ooool001cooooo00?o0000oooo
ooooool04_ooool00ol0003oooooooooo`3ooooooegooooo000Looooo`03o`000?oooooooooo017o
oooo0ol0003ooooooekooooo000Looooo`03o`000?oooooooooo017ooooo0ol0003ooooooekooooo
000Looooo`?o00004_ooool00ol0003oooooooooo`3ooooooegooooo000Looooo`03o`000?oooooo
oooo0?ooooooL_ooool001cooooo00?o0000ooooooooool0oooooombooooo`007?ooool00ol0003o
ooooooooo`3oooooog;ooooo000Looooo`03o`000?oooooooooo0?ooooooL_ooool001cooooo00?o
0000ooooooooool0oooooombooooo`007?ooool00ol0003oooooooooo`1iooooo`03o`000?oooooo
oooo0?Gooooo000Looooo`03o`000?oooooooooo07Sooooo0ol0003fooooo`007?ooool00ol0003o
ooooooooo`1gooooo`Co0000m_ooool001cooooo0ol0001hooooo`?o0000m_ooool001cooooo00?o
0000ooooooooool0NOooool00ol0003oooooooooo`3eooooo`007?ooool00ol0003oooooooooo`2l
ooooo`03o`000?oooooooooo0;;ooooo000Looooo`03o`000?oooooooooo0;cooooo0_l0002coooo
o`007?ooool00ol0003oooooooooo`2kooooo`?o0000/oooool001cooooo00?o0000ooooooooool0
_?ooool2o`000;?ooooo00001?oooooo0000o`000?l00002ooooo`Go00000oooool2o`0000Cooooo
0_l00006ooooo`03o`000?oooooooooo0;cooooo00?o0000ooooooooool0/_ooool000;ooooo00?o
0000ooooooooool00_ooool01?l0003oooooooooool00002ooooo`04o`000?ooooooooooo`0000;o
oooo00Co0000oooooooooooo00001Oooool00ol0003oooooooooo`3oooooog;ooooo0002ooooo`03
o`000?oooooooooo00?ooooo00?o0000ooooooooool00_ooool01?l0003oooooooooool00002oooo
o`04o`000?ooooooooooo`0000Gooooo1?l0003oooooog7ooooo0002ooooo`03o`000?oooooooooo
00Cooooo00Go0000ooooooooooooooooo`000002ooooo`04o`000?ooooooooooo`0000;ooooo00?o
0000ooooooooool00oooool00ol0003oooooooooo`3oooooog;ooooo0002ooooo`05o`000?oooooo
ooooooooool000000oooool01?l0003oooooooooool00002ooooo`04o`000?ooooooooooo`0000;o
oooo00?o0000ooooooooool00oooool00ol0003oooooooooo`3oooooog;ooooo00000ooooooo0000
o`000003ooooo`05o`000?ooooooooooooooool000000_ooool01?l0003oooooooooool00002oooo
o`04o`000?ooooooooooo`0000Gooooo00?o0000ooooooooool0oooooombooooo`000_ooool00ol0
003oooooooooo`02ooooo`?o00001?ooool2o`0000Cooooo0_l00006ooooo`03o`000?oooooooooo
0?ooooooL_ooool001cooooo00?o0000ooooooooool0oooooombooooo`007?ooool00ol0003ooooo
ooooo`3oooooog;ooooo000Looooo`03o`000?oooooooooo0?ooooooL_ooool001cooooo00?o0000
ooooooooool0>Oooool00ol0003oooooooooo`3oooooocKooooo000Looooo`?o0000>Oooool2o`00
0?oooooo=oooool001cooooo00?o0000ooooooooool0>?ooool3o`000?oooooo=oooool001cooooo
00?o0000ooooooooool0>Oooool2o`000?oooooo=oooool001cooooo00?o0000ooooooooool0>Ooo
ool00ol0003oooooooooo`3oooooocKooooo000Looooo`03o`000?oooooooooo0?ooooooL_ooool0
01cooooo00?o0000ooooooooool0oooooomWooooo`03o`000?oooooooooo00Sooooo000Looooo`03
o`000?oooooooooo0?ooooooI_ooool3o`0000Wooooo000Looooo`03o`000?oooooooooo0?oooooo
I_ooool3o`0000Wooooo000Looooo`03o`000?oooooooooo01Kooooo00?o0000ooooooooool0oooo
oom>ooooo`03o`000?oooooooooo00Sooooo000Looooo`?o00005Oooool3o`000?ooooooF_ooool0
01cooooo00Go0000ooooooooooooooooo`00000Booooo`Co0000oooooomJooooo`007?ooool00ol0
003oooooooooo`03o`0001;ooooo0ol000000ooooooo0000o`00003ooooooeOooooo000Looooo`03
o`000?oooooooooo00?o00004oooool00ol0003oooooo`000002o`000?ooooooEoooool001cooooo
00Go0000ooooooooooooooooo`00000Gooooo`;o0000oooooomGooooo`007?ooool00ol0003ooooo
ooooo`3oooooog;ooooo000Looooo`03o`000?oooooooooo0?ooooooL_ooool001cooooo00?o0000
ooooooooool0OOooool00ol0003oooooooooo`3aooooo`007?ooool3o`0007cooooo0ol0003boooo
o`007?ooool00ol0003oooooooooo`1kooooo`Co0000l_ooool001cooooo00?o0000ooooooooool0
O?ooool3o`000?;ooooo000Looooo`03o`000?oooooooooo07gooooo00?o0000ooooooooool0lOoo
ool001cooooo00?o0000ooooooooool0oooooombooooo`007?ooool00ol0003oooooooooo`3ooooo
og;ooooo00001?oooooo0000o`000?l00004ooooo`?o00000oooool2o`0000Cooooo0_l00006oooo
o`03o`000?oooooooooo0?ooooooL_ooool000;ooooo00?o0000ooooooooool01?ooool01Ol0003o
oooooooooooooooo000000;ooooo00Co0000oooooooooooo00000_ooool00ol0003oooooooooo`03
ooooo`03o`000?oooooooooo0?ooooooL_ooool000;ooooo00Co0000oooooooooooooooo1Ol00002
ooooo`04o`000?ooooooooooo`0000;ooooo00Co0000oooooooooooo00001Oooool00ol0003ooooo
ooooo`3oooooog;ooooo0002ooooo`05o`000?ooooooooooooooool000000_ooool01Ol0003ooooo
oooooooooooo000000;ooooo00Co0000oooooooooooo00000_ooool00ol0003oooooooooo`03oooo
o`Co0000oooooomaooooo`000_ooool00ol0003oooooooooo`02ooooo`03o`000?oooooo000000?o
oooo00Co0000oooooooooooo00000_ooool01?l0003oooooooooool00005ooooo`03o`000?oooooo
oooo0?ooooooL_ooool00003ooooool0003o000000Gooooo0_l00003ooooo`04o`000?oooooooooo
o`0000;ooooo00Co0000oooooooooooo00001Oooool00ol0003oooooooooo`3oooooog;ooooo0002
ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool00_ooool2o`0000Cooooo0_l00006
ooooo`03o`000?oooooooooo0?ooooooL_ooool001cooooo00?o0000ooooooooool0oooooomboooo
o`007?ooool00ol0003oooooooooo`3oooooog;ooooo000Looooo`03o`000?oooooooooo0?oooooo
L_ooool001cooooo00?o0000ooooooooool0oooooombooooo`007?ooool3o`000?ooooooL_ooool0
01cooooo00?o0000ooooooooool0oooooombooooo`007?ooool00ol0003oooooooooo`3oooooog;o
oooo000Looooo`03o`000?oooooooooo0?ooooooL_ooool001cooooo00?o0000ooooooooool0oooo
oombooooo`007?ooool00ol0003oooooooooo`3oooooog;ooooo000Looooo`03o`000?oooooooooo
0?ooooooL_ooool001cooooo00?o0000ooooooooool0oooooombooooo`007?ooool00ol0003ooooo
ooooo`3oooooog;ooooo000Looooo`?o0000oooooombooooo`007?ooool00ol0003oooooooooo`3o
ooooog;ooooo000Looooo`03o`000?oooooooooo03gooooo00?o0000ooooooooool0oooooolboooo
o`007?ooool00ol0003oooooooooo`0looooo`?o0000oooooolcooooo`007?ooool00ol0003ooooo
ooooo`0kooooo`Co0000oooooolcooooo`007?ooool00ol0003oooooooooo`0looooo`?o0000oooo
oolcooooo`007?ooool00ol0003oooooooooo`0mooooo`03o`000?oooooooooo0?oooooo<_ooool0
01cooooo00?o0000ooooooooool0oooooombooooo`007?ooool00ol0003oooooooooo`3oooooog;o
oooo000Looooo`?o0000oooooombooooo`007?ooool00ol0003oooooooooo`3oooooog;ooooo000L
ooooo`03o`000?oooooooooo0?ooooooL_ooool001cooooo00?o0000ooooooooool0oooooomboooo
o`007?ooool00ol0003oooooooooo`3oooooog;ooooo000Looooo`03o`000?oooooooooo0?oooooo
L_ooool00004ooooool0003o0000o`0000?ooooo0ol00004ooooo`;o00001?ooool2o`0000Kooooo
00?o0000ooooooooool0oooooombooooo`000_ooool01Ol0003ooooooooooooooooo000000?ooooo
00Co0000oooooooooooo00000_ooool01?l0003oooooooooool00002ooooo`03o`000?oooooooooo
00?ooooo00?o0000ooooooooool0oooooombooooo`000_ooool01Ol0003ooooooooooooooooo0000
00?ooooo00Co0000oooooooooooo00000_ooool01?l0003oooooooooool00002ooooo`03o`000?oo
oooooooo00?ooooo1?l0003oooooog7ooooo0002ooooo`04o`000?ooooooooooooooo`Co00000ooo
ool01?l0003oooooooooool00002ooooo`04o`000?ooooooooooo`0000Gooooo00?o0000oooooooo
ool0oooooombooooo`000_ooool01Ol0003ooooooooooooooooo000000Kooooo00Co0000oooooooo
oooo00000_ooool01?l0003oooooooooool00005ooooo`03o`000?oooooooooo0?ooooooL_ooool0
0003ooooool0003o000000Cooooo00?o0000ooooooooool00oooool01?l0003oooooooooool00002
ooooo`04o`000?ooooooooooo`0000Gooooo00?o0000ooooooooool0oooooombooooo`000_ooool0
0ol0003oooooooooo`03ooooo`;o00001?ooool2o`0000Cooooo0_l00006ooooo`03o`000?oooooo
oooo0?ooooooL_ooool001cooooo00?o0000ooooooooool0oooooombooooo`007?ooool00ol0003o
ooooooooo`3oooooog;ooooo000Looooo`03o`000?oooooooooo0?ooooooL_ooool001cooooo00?o
0000ooooooooool0oooooombooooo`007?ooool3o`000?ooooooL_ooool001cooooo00?o0000oooo
ooooool0oooooombooooo`007?ooool00ol0003oooooooooo`3oooooog;ooooo000Looooo`03o`00
0?oooooooooo0?ooooooL_ooool001cooooo00?o0000ooooooooool07Oooool00ol0003ooooooooo
o`3ooooooe;ooooo000Looooo`03o`000?oooooooooo01cooooo0ol0003ooooooe?ooooo000Loooo
o`03o`000?oooooooooo01_ooooo1?l0003ooooooe?ooooo000Looooo`03o`000?oooooooooo01co
oooo0ol0003ooooooe?ooooo000Looooo`?o00007Oooool00ol0003oooooooooo`3ooooooe;ooooo
000Looooo`03o`000?oooooooooo0?ooooooL_ooool001cooooo00?o0000ooooooooool0oooooomb
ooooo`00oooooonAooooo`00oooooonAooooo`00oooooonAooooo`00\
\>"],
  ImageRangeCache->{{{0, 399}, {246.188, 0}} -> {-8.11617, 297.374, 0.282373, \
5.81884}}]
}, Open  ]],

Cell[TextData[{
  "Attenzione! Nonostante stiamo visualizzando una sola serie di dati, \
preferiamo usare ",
  StyleBox["MultipleListPlot", "Input"],
  " al posto di ",
  StyleBox["ListPlot", "Input"],
  " per poter utilizzare le caratteristiche aggiuntive della prima tra queste \
due funzioni."
}], "Text",
  PageWidth->PaperWidth],

Cell["\<\
Come nell'esempio precedente, i simboli usati per indicare i \
singoli punti (in questo caso, dei rombi) sono difficili da distinguere: \
utilizziamo quindi la funzione enlarge per migliorare la leggibilit\[AGrave] \
del grafico (come nel caso di MultipleListPlot, sar\[AGrave] necessario \
valutare la cella che definisce la funzione nel caso non fosse stato eseguito \
il codice del precedente esempio):\
\>", "Text",
  PageWidth->PaperWidth],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(MultipleListPlot[ion, 
        SymbolShape \[Rule] {enlarge[PlotSymbol[Diamond], 2]}];\)\)], "Input",\

  CellLabel->"In[30]:=",
  PageWidth->PaperWidth],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
%%ImageSize: 400 247.214 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.00933707 -0.155516 0.000453103 [
[.21055 .01323 -6 -9 ]
[.21055 .01323 6 0 ]
[.39729 .01323 -6 -9 ]
[.39729 .01323 6 0 ]
[.58403 .01323 -6 -9 ]
[.58403 .01323 6 0 ]
[.77077 .01323 -6 -9 ]
[.77077 .01323 6 0 ]
[.95752 .01323 -9 -9 ]
[.95752 .01323 9 0 ]
[.01131 .11635 -18 -4.5 ]
[.01131 .11635 0 4.5 ]
[.01131 .20697 -18 -4.5 ]
[.01131 .20697 0 4.5 ]
[.01131 .29759 -24 -4.5 ]
[.01131 .29759 0 4.5 ]
[.01131 .38821 -24 -4.5 ]
[.01131 .38821 0 4.5 ]
[.01131 .47883 -24 -4.5 ]
[.01131 .47883 0 4.5 ]
[.01131 .56945 -24 -4.5 ]
[.01131 .56945 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21055 .02573 m
.21055 .03198 L
s
[(20)] .21055 .01323 0 1 Mshowa
.39729 .02573 m
.39729 .03198 L
s
[(40)] .39729 .01323 0 1 Mshowa
.58403 .02573 m
.58403 .03198 L
s
[(60)] .58403 .01323 0 1 Mshowa
.77077 .02573 m
.77077 .03198 L
s
[(80)] .77077 .01323 0 1 Mshowa
.95752 .02573 m
.95752 .03198 L
s
[(100)] .95752 .01323 0 1 Mshowa
.125 Mabswid
.07049 .02573 m
.07049 .02948 L
s
.11718 .02573 m
.11718 .02948 L
s
.16387 .02573 m
.16387 .02948 L
s
.25724 .02573 m
.25724 .02948 L
s
.30392 .02573 m
.30392 .02948 L
s
.35061 .02573 m
.35061 .02948 L
s
.44398 .02573 m
.44398 .02948 L
s
.49066 .02573 m
.49066 .02948 L
s
.53735 .02573 m
.53735 .02948 L
s
.63072 .02573 m
.63072 .02948 L
s
.6774 .02573 m
.6774 .02948 L
s
.72409 .02573 m
.72409 .02948 L
s
.81746 .02573 m
.81746 .02948 L
s
.86415 .02573 m
.86415 .02948 L
s
.91083 .02573 m
.91083 .02948 L
s
.25 Mabswid
0 .02573 m
1 .02573 L
s
.02381 .11635 m
.03006 .11635 L
s
[(600)] .01131 .11635 1 0 Mshowa
.02381 .20697 m
.03006 .20697 L
s
[(800)] .01131 .20697 1 0 Mshowa
.02381 .29759 m
.03006 .29759 L
s
[(1000)] .01131 .29759 1 0 Mshowa
.02381 .38821 m
.03006 .38821 L
s
[(1200)] .01131 .38821 1 0 Mshowa
.02381 .47883 m
.03006 .47883 L
s
[(1400)] .01131 .47883 1 0 Mshowa
.02381 .56945 m
.03006 .56945 L
s
[(1600)] .01131 .56945 1 0 Mshowa
.125 Mabswid
.02381 .04838 m
.02756 .04838 L
s
.02381 .07104 m
.02756 .07104 L
s
.02381 .09369 m
.02756 .09369 L
s
.02381 .139 m
.02756 .139 L
s
.02381 .16166 m
.02756 .16166 L
s
.02381 .18431 m
.02756 .18431 L
s
.02381 .22962 m
.02756 .22962 L
s
.02381 .25228 m
.02756 .25228 L
s
.02381 .27493 m
.02756 .27493 L
s
.02381 .32024 m
.02756 .32024 L
s
.02381 .3429 m
.02756 .3429 L
s
.02381 .36555 m
.02756 .36555 L
s
.02381 .41086 m
.02756 .41086 L
s
.02381 .43352 m
.02756 .43352 L
s
.02381 .45617 m
.02756 .45617 L
s
.02381 .50148 m
.02756 .50148 L
s
.02381 .52414 m
.02756 .52414 L
s
.02381 .54679 m
.02756 .54679 L
s
.02381 .00307 m
.02756 .00307 L
s
.02381 .5921 m
.02756 .5921 L
s
.02381 .61476 m
.02756 .61476 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.0001 w
.03315 .43896 -3.75 0 Mabsadd m
.03315 .43896 0 5 Mabsadd L
.03315 .43896 3.75 0 Mabsadd L
.03315 .43896 0 -5 Mabsadd L
.03315 .43896 -3.75 0 Mabsadd L closepath F
.04248 .91938 -3.75 0 Mabsadd m
.04248 .91938 0 5 Mabsadd L
.04248 .91938 3.75 0 Mabsadd L
.04248 .91938 0 -5 Mabsadd L
.04248 .91938 -3.75 0 Mabsadd L closepath F
.05182 .07706 -3.75 0 Mabsadd m
.05182 .07706 0 5 Mabsadd L
.05182 .07706 3.75 0 Mabsadd L
.05182 .07706 0 -5 Mabsadd L
.05182 .07706 -3.75 0 Mabsadd L closepath F
.06116 .25201 -3.75 0 Mabsadd m
.06116 .25201 0 5 Mabsadd L
.06116 .25201 3.75 0 Mabsadd L
.06116 .25201 0 -5 Mabsadd L
.06116 .25201 -3.75 0 Mabsadd L closepath F
.07049 .20724 -3.75 0 Mabsadd m
.07049 .20724 0 5 Mabsadd L
.07049 .20724 3.75 0 Mabsadd L
.07049 .20724 0 -5 Mabsadd L
.07049 .20724 -3.75 0 Mabsadd L closepath F
.07983 .33664 -3.75 0 Mabsadd m
.07983 .33664 0 5 Mabsadd L
.07983 .33664 3.75 0 Mabsadd L
.07983 .33664 0 -5 Mabsadd L
.07983 .33664 -3.75 0 Mabsadd L closepath F
.08917 .43456 -3.75 0 Mabsadd m
.08917 .43456 0 5 Mabsadd L
.08917 .43456 3.75 0 Mabsadd L
.08917 .43456 0 -5 Mabsadd L
.08917 .43456 -3.75 0 Mabsadd L closepath F
.09851 .43982 -3.75 0 Mabsadd m
.09851 .43982 0 5 Mabsadd L
.09851 .43982 3.75 0 Mabsadd L
.09851 .43982 0 -5 Mabsadd L
.09851 .43982 -3.75 0 Mabsadd L closepath F
.10784 .60615 -3.75 0 Mabsadd m
.10784 .60615 0 5 Mabsadd L
.10784 .60615 3.75 0 Mabsadd L
.10784 .60615 0 -5 Mabsadd L
.10784 .60615 -3.75 0 Mabsadd L closepath F
.11718 .78721 -3.75 0 Mabsadd m
.11718 .78721 0 5 Mabsadd L
.11718 .78721 3.75 0 Mabsadd L
.11718 .78721 0 -5 Mabsadd L
.11718 .78721 -3.75 0 Mabsadd L closepath F
.12652 .06913 -3.75 0 Mabsadd m
.12652 .06913 0 5 Mabsadd L
.12652 .06913 3.75 0 Mabsadd L
.12652 .06913 0 -5 Mabsadd L
.12652 .06913 -3.75 0 Mabsadd L closepath F
.13585 .17874 -3.75 0 Mabsadd m
.13585 .17874 0 5 Mabsadd L
.13585 .17874 3.75 0 Mabsadd L
.13585 .17874 0 -5 Mabsadd L
.13585 .17874 -3.75 0 Mabsadd L closepath F
.14519 .10611 -3.75 0 Mabsadd m
.14519 .10611 0 5 Mabsadd L
.14519 .10611 3.75 0 Mabsadd L
.14519 .10611 0 -5 Mabsadd L
.14519 .10611 -3.75 0 Mabsadd L closepath F
.15453 .20085 -3.75 0 Mabsadd m
.15453 .20085 0 5 Mabsadd L
.15453 .20085 3.75 0 Mabsadd L
.15453 .20085 0 -5 Mabsadd L
.15453 .20085 -3.75 0 Mabsadd L closepath F
.16387 .30289 -3.75 0 Mabsadd m
.16387 .30289 0 5 Mabsadd L
.16387 .30289 3.75 0 Mabsadd L
.16387 .30289 0 -5 Mabsadd L
.16387 .30289 -3.75 0 Mabsadd L closepath F
.1732 .29741 -3.75 0 Mabsadd m
.1732 .29741 0 5 Mabsadd L
.1732 .29741 3.75 0 Mabsadd L
.1732 .29741 0 -5 Mabsadd L
.1732 .29741 -3.75 0 Mabsadd L closepath F
.18254 .41136 -3.75 0 Mabsadd m
.18254 .41136 0 5 Mabsadd L
.18254 .41136 3.75 0 Mabsadd L
.18254 .41136 0 -5 Mabsadd L
.18254 .41136 -3.75 0 Mabsadd L closepath F
.19188 .53338 -3.75 0 Mabsadd m
.19188 .53338 0 5 Mabsadd L
.19188 .53338 3.75 0 Mabsadd L
.19188 .53338 0 -5 Mabsadd L
.19188 .53338 -3.75 0 Mabsadd L closepath F
.20121 .03424 -3.75 0 Mabsadd m
.20121 .03424 0 5 Mabsadd L
.20121 .03424 3.75 0 Mabsadd L
.20121 .03424 0 -5 Mabsadd L
.20121 .03424 -3.75 0 Mabsadd L closepath F
.21055 .11168 -3.75 0 Mabsadd m
.21055 .11168 0 5 Mabsadd L
.21055 .11168 3.75 0 Mabsadd L
.21055 .11168 0 -5 Mabsadd L
.21055 .11168 -3.75 0 Mabsadd L closepath F
.21989 .13039 -3.75 0 Mabsadd m
.21989 .13039 0 5 Mabsadd L
.21989 .13039 3.75 0 Mabsadd L
.21989 .13039 0 -5 Mabsadd L
.21989 .13039 -3.75 0 Mabsadd L closepath F
.22923 .14263 -3.75 0 Mabsadd m
.22923 .14263 0 5 Mabsadd L
.22923 .14263 3.75 0 Mabsadd L
.22923 .14263 0 -5 Mabsadd L
.22923 .14263 -3.75 0 Mabsadd L closepath F
.23856 .139 -3.75 0 Mabsadd m
.23856 .139 0 5 Mabsadd L
.23856 .139 3.75 0 Mabsadd L
.23856 .139 0 -5 Mabsadd L
.23856 .139 -3.75 0 Mabsadd L closepath F
.2479 .14022 -3.75 0 Mabsadd m
.2479 .14022 0 5 Mabsadd L
.2479 .14022 3.75 0 Mabsadd L
.2479 .14022 0 -5 Mabsadd L
.2479 .14022 -3.75 0 Mabsadd L closepath F
.25724 .16954 -3.75 0 Mabsadd m
.25724 .16954 0 5 Mabsadd L
.25724 .16954 3.75 0 Mabsadd L
.25724 .16954 0 -5 Mabsadd L
.25724 .16954 -3.75 0 Mabsadd L closepath F
.26657 .18853 -3.75 0 Mabsadd m
.26657 .18853 0 5 Mabsadd L
.26657 .18853 3.75 0 Mabsadd L
.26657 .18853 0 -5 Mabsadd L
.26657 .18853 -3.75 0 Mabsadd L closepath F
.27591 .18884 -3.75 0 Mabsadd m
.27591 .18884 0 5 Mabsadd L
.27591 .18884 3.75 0 Mabsadd L
.27591 .18884 0 -5 Mabsadd L
.27591 .18884 -3.75 0 Mabsadd L closepath F
.28525 .17829 -3.75 0 Mabsadd m
.28525 .17829 0 5 Mabsadd L
.28525 .17829 3.75 0 Mabsadd L
.28525 .17829 0 -5 Mabsadd L
.28525 .17829 -3.75 0 Mabsadd L closepath F
.29458 .18223 -3.75 0 Mabsadd m
.29458 .18223 0 5 Mabsadd L
.29458 .18223 3.75 0 Mabsadd L
.29458 .18223 0 -5 Mabsadd L
.29458 .18223 -3.75 0 Mabsadd L closepath F
.30392 .25518 -3.75 0 Mabsadd m
.30392 .25518 0 5 Mabsadd L
.30392 .25518 3.75 0 Mabsadd L
.30392 .25518 0 -5 Mabsadd L
.30392 .25518 -3.75 0 Mabsadd L closepath F
.31326 .10674 -3.75 0 Mabsadd m
.31326 .10674 0 5 Mabsadd L
.31326 .10674 3.75 0 Mabsadd L
.31326 .10674 0 -5 Mabsadd L
.31326 .10674 -3.75 0 Mabsadd L closepath F
.3226 .18979 -3.75 0 Mabsadd m
.3226 .18979 0 5 Mabsadd L
.3226 .18979 3.75 0 Mabsadd L
.3226 .18979 0 -5 Mabsadd L
.3226 .18979 -3.75 0 Mabsadd L closepath F
.33193 .27357 -3.75 0 Mabsadd m
.33193 .27357 0 5 Mabsadd L
.33193 .27357 3.75 0 Mabsadd L
.33193 .27357 0 -5 Mabsadd L
.33193 .27357 -3.75 0 Mabsadd L closepath F
.34127 .27081 -3.75 0 Mabsadd m
.34127 .27081 0 5 Mabsadd L
.34127 .27081 3.75 0 Mabsadd L
.34127 .27081 0 -5 Mabsadd L
.34127 .27081 -3.75 0 Mabsadd L closepath F
.35061 .36098 -3.75 0 Mabsadd m
.35061 .36098 0 5 Mabsadd L
.35061 .36098 3.75 0 Mabsadd L
.35061 .36098 0 -5 Mabsadd L
.35061 .36098 -3.75 0 Mabsadd L closepath F
.35994 .45649 -3.75 0 Mabsadd m
.35994 .45649 0 5 Mabsadd L
.35994 .45649 3.75 0 Mabsadd L
.35994 .45649 0 -5 Mabsadd L
.35994 .45649 -3.75 0 Mabsadd L closepath F
.36928 .02708 -3.75 0 Mabsadd m
.36928 .02708 0 5 Mabsadd L
.36928 .02708 3.75 0 Mabsadd L
.36928 .02708 0 -5 Mabsadd L
.36928 .02708 -3.75 0 Mabsadd L closepath F
.37862 .09346 -3.75 0 Mabsadd m
.37862 .09346 0 5 Mabsadd L
.37862 .09346 3.75 0 Mabsadd L
.37862 .09346 0 -5 Mabsadd L
.37862 .09346 -3.75 0 Mabsadd L closepath F
.38796 .1236 -3.75 0 Mabsadd m
.38796 .1236 0 5 Mabsadd L
.38796 .1236 3.75 0 Mabsadd L
.38796 .1236 0 -5 Mabsadd L
.38796 .1236 -3.75 0 Mabsadd L closepath F
.39729 .14353 -3.75 0 Mabsadd m
.39729 .14353 0 5 Mabsadd L
.39729 .14353 3.75 0 Mabsadd L
.39729 .14353 0 -5 Mabsadd L
.39729 .14353 -3.75 0 Mabsadd L closepath F
.40663 .14534 -3.75 0 Mabsadd m
.40663 .14534 0 5 Mabsadd L
.40663 .14534 3.75 0 Mabsadd L
.40663 .14534 0 -5 Mabsadd L
.40663 .14534 -3.75 0 Mabsadd L closepath F
.41597 .15486 -3.75 0 Mabsadd m
.41597 .15486 0 5 Mabsadd L
.41597 .15486 3.75 0 Mabsadd L
.41597 .15486 0 -5 Mabsadd L
.41597 .15486 -3.75 0 Mabsadd L closepath F
.4253 .16256 -3.75 0 Mabsadd m
.4253 .16256 0 5 Mabsadd L
.4253 .16256 3.75 0 Mabsadd L
.4253 .16256 0 -5 Mabsadd L
.4253 .16256 -3.75 0 Mabsadd L closepath F
.43464 .16664 -3.75 0 Mabsadd m
.43464 .16664 0 5 Mabsadd L
.43464 .16664 3.75 0 Mabsadd L
.43464 .16664 0 -5 Mabsadd L
.43464 .16664 -3.75 0 Mabsadd L closepath F
.44398 .17072 -3.75 0 Mabsadd m
.44398 .17072 0 5 Mabsadd L
.44398 .17072 3.75 0 Mabsadd L
.44398 .17072 0 -5 Mabsadd L
.44398 .17072 -3.75 0 Mabsadd L closepath F
.45331 .20923 -3.75 0 Mabsadd m
.45331 .20923 0 5 Mabsadd L
.45331 .20923 3.75 0 Mabsadd L
.45331 .20923 0 -5 Mabsadd L
.45331 .20923 -3.75 0 Mabsadd L closepath F
.46265 .1757 -3.75 0 Mabsadd m
.46265 .1757 0 5 Mabsadd L
.46265 .1757 3.75 0 Mabsadd L
.46265 .1757 0 -5 Mabsadd L
.46265 .1757 -3.75 0 Mabsadd L closepath F
.47199 .24167 -3.75 0 Mabsadd m
.47199 .24167 0 5 Mabsadd L
.47199 .24167 3.75 0 Mabsadd L
.47199 .24167 0 -5 Mabsadd L
.47199 .24167 -3.75 0 Mabsadd L closepath F
.48133 .09745 -3.75 0 Mabsadd m
.48133 .09745 0 5 Mabsadd L
.48133 .09745 3.75 0 Mabsadd L
.48133 .09745 0 -5 Mabsadd L
.48133 .09745 -3.75 0 Mabsadd L closepath F
.49066 .16555 -3.75 0 Mabsadd m
.49066 .16555 0 5 Mabsadd L
.49066 .16555 3.75 0 Mabsadd L
.49066 .16555 0 -5 Mabsadd L
.49066 .16555 -3.75 0 Mabsadd L closepath F
.5 .22224 -3.75 0 Mabsadd m
.5 .22224 0 5 Mabsadd L
.5 .22224 3.75 0 Mabsadd L
.5 .22224 0 -5 Mabsadd L
.5 .22224 -3.75 0 Mabsadd L closepath F
.50934 .23832 -3.75 0 Mabsadd m
.50934 .23832 0 5 Mabsadd L
.50934 .23832 3.75 0 Mabsadd L
.50934 .23832 0 -5 Mabsadd L
.50934 .23832 -3.75 0 Mabsadd L closepath F
.51867 .30139 -3.75 0 Mabsadd m
.51867 .30139 0 5 Mabsadd L
.51867 .30139 3.75 0 Mabsadd L
.51867 .30139 0 -5 Mabsadd L
.51867 .30139 -3.75 0 Mabsadd L closepath F
.52801 .3748 -3.75 0 Mabsadd m
.52801 .3748 0 5 Mabsadd L
.52801 .3748 3.75 0 Mabsadd L
.52801 .3748 0 -5 Mabsadd L
.52801 .3748 -3.75 0 Mabsadd L closepath F
.53735 .01472 -3.75 0 Mabsadd m
.53735 .01472 0 5 Mabsadd L
.53735 .01472 3.75 0 Mabsadd L
.53735 .01472 0 -5 Mabsadd L
.53735 .01472 -3.75 0 Mabsadd L closepath F
.54669 .0723 -3.75 0 Mabsadd m
.54669 .0723 0 5 Mabsadd L
.54669 .0723 3.75 0 Mabsadd L
.54669 .0723 0 -5 Mabsadd L
.54669 .0723 -3.75 0 Mabsadd L closepath F
.55602 .0883 -3.75 0 Mabsadd m
.55602 .0883 0 5 Mabsadd L
.55602 .0883 3.75 0 Mabsadd L
.55602 .0883 0 -5 Mabsadd L
.55602 .0883 -3.75 0 Mabsadd L closepath F
.56536 .08345 -3.75 0 Mabsadd m
.56536 .08345 0 5 Mabsadd L
.56536 .08345 3.75 0 Mabsadd L
.56536 .08345 0 -5 Mabsadd L
.56536 .08345 -3.75 0 Mabsadd L closepath F
.5747 .0815 -3.75 0 Mabsadd m
.5747 .0815 0 5 Mabsadd L
.5747 .0815 3.75 0 Mabsadd L
.5747 .0815 0 -5 Mabsadd L
.5747 .0815 -3.75 0 Mabsadd L closepath F
.58403 .08445 -3.75 0 Mabsadd m
.58403 .08445 0 5 Mabsadd L
.58403 .08445 3.75 0 Mabsadd L
.58403 .08445 0 -5 Mabsadd L
.58403 .08445 -3.75 0 Mabsadd L closepath F
.59337 .0873 -3.75 0 Mabsadd m
.59337 .0873 0 5 Mabsadd L
.59337 .0873 3.75 0 Mabsadd L
.59337 .0873 0 -5 Mabsadd L
.59337 .0873 -3.75 0 Mabsadd L closepath F
.60271 .09066 -3.75 0 Mabsadd m
.60271 .09066 0 5 Mabsadd L
.60271 .09066 3.75 0 Mabsadd L
.60271 .09066 0 -5 Mabsadd L
.60271 .09066 -3.75 0 Mabsadd L closepath F
.61204 .0922 -3.75 0 Mabsadd m
.61204 .0922 0 5 Mabsadd L
.61204 .0922 3.75 0 Mabsadd L
.61204 .0922 0 -5 Mabsadd L
.61204 .0922 -3.75 0 Mabsadd L closepath F
.62138 .11295 -3.75 0 Mabsadd m
.62138 .11295 0 5 Mabsadd L
.62138 .11295 3.75 0 Mabsadd L
.62138 .11295 0 -5 Mabsadd L
.62138 .11295 -3.75 0 Mabsadd L closepath F
.63072 .10031 -3.75 0 Mabsadd m
.63072 .10031 0 5 Mabsadd L
.63072 .10031 3.75 0 Mabsadd L
.63072 .10031 0 -5 Mabsadd L
.63072 .10031 -3.75 0 Mabsadd L closepath F
.64006 .10361 -3.75 0 Mabsadd m
.64006 .10361 0 5 Mabsadd L
.64006 .10361 3.75 0 Mabsadd L
.64006 .10361 0 -5 Mabsadd L
.64006 .10361 -3.75 0 Mabsadd L closepath F
.64939 .1076 -3.75 0 Mabsadd m
.64939 .1076 0 5 Mabsadd L
.64939 .1076 3.75 0 Mabsadd L
.64939 .1076 0 -5 Mabsadd L
.64939 .1076 -3.75 0 Mabsadd L closepath F
.65873 .11123 -3.75 0 Mabsadd m
.65873 .11123 0 5 Mabsadd L
.65873 .11123 3.75 0 Mabsadd L
.65873 .11123 0 -5 Mabsadd L
.65873 .11123 -3.75 0 Mabsadd L closepath F
.66807 .11485 -3.75 0 Mabsadd m
.66807 .11485 0 5 Mabsadd L
.66807 .11485 3.75 0 Mabsadd L
.66807 .11485 0 -5 Mabsadd L
.66807 .11485 -3.75 0 Mabsadd L closepath F
.6774 .11789 -3.75 0 Mabsadd m
.6774 .11789 0 5 Mabsadd L
.6774 .11789 3.75 0 Mabsadd L
.6774 .11789 0 -5 Mabsadd L
.6774 .11789 -3.75 0 Mabsadd L closepath F
.68674 .08168 -3.75 0 Mabsadd m
.68674 .08168 0 5 Mabsadd L
.68674 .08168 3.75 0 Mabsadd L
.68674 .08168 0 -5 Mabsadd L
.68674 .08168 -3.75 0 Mabsadd L closepath F
.69608 .13538 -3.75 0 Mabsadd m
.69608 .13538 0 5 Mabsadd L
.69608 .13538 3.75 0 Mabsadd L
.69608 .13538 0 -5 Mabsadd L
.69608 .13538 -3.75 0 Mabsadd L closepath F
.70542 .1893 -3.75 0 Mabsadd m
.70542 .1893 0 5 Mabsadd L
.70542 .1893 3.75 0 Mabsadd L
.70542 .1893 0 -5 Mabsadd L
.70542 .1893 -3.75 0 Mabsadd L closepath F
.71475 .19337 -3.75 0 Mabsadd m
.71475 .19337 0 5 Mabsadd L
.71475 .19337 3.75 0 Mabsadd L
.71475 .19337 0 -5 Mabsadd L
.71475 .19337 -3.75 0 Mabsadd L closepath F
.72409 .18884 -3.75 0 Mabsadd m
.72409 .18884 0 5 Mabsadd L
.72409 .18884 3.75 0 Mabsadd L
.72409 .18884 0 -5 Mabsadd L
.72409 .18884 -3.75 0 Mabsadd L closepath F
.73343 .22509 -3.75 0 Mabsadd m
.73343 .22509 0 5 Mabsadd L
.73343 .22509 3.75 0 Mabsadd L
.73343 .22509 0 -5 Mabsadd L
.73343 .22509 -3.75 0 Mabsadd L closepath F
.74276 .24322 -3.75 0 Mabsadd m
.74276 .24322 0 5 Mabsadd L
.74276 .24322 3.75 0 Mabsadd L
.74276 .24322 0 -5 Mabsadd L
.74276 .24322 -3.75 0 Mabsadd L closepath F
.7521 .23868 -3.75 0 Mabsadd m
.7521 .23868 0 5 Mabsadd L
.7521 .23868 3.75 0 Mabsadd L
.7521 .23868 0 -5 Mabsadd L
.7521 .23868 -3.75 0 Mabsadd L closepath F
.76144 .24779 -3.75 0 Mabsadd m
.76144 .24779 0 5 Mabsadd L
.76144 .24779 3.75 0 Mabsadd L
.76144 .24779 0 -5 Mabsadd L
.76144 .24779 -3.75 0 Mabsadd L closepath F
.77077 .30076 -3.75 0 Mabsadd m
.77077 .30076 0 5 Mabsadd L
.77077 .30076 3.75 0 Mabsadd L
.77077 .30076 0 -5 Mabsadd L
.77077 .30076 -3.75 0 Mabsadd L closepath F
.78011 .1115 -3.75 0 Mabsadd m
.78011 .1115 0 5 Mabsadd L
.78011 .1115 3.75 0 Mabsadd L
.78011 .1115 0 -5 Mabsadd L
.78011 .1115 -3.75 0 Mabsadd L closepath F
.78945 .16868 -3.75 0 Mabsadd m
.78945 .16868 0 5 Mabsadd L
.78945 .16868 3.75 0 Mabsadd L
.78945 .16868 0 -5 Mabsadd L
.78945 .16868 -3.75 0 Mabsadd L closepath F
.79879 .16311 -3.75 0 Mabsadd m
.79879 .16311 0 5 Mabsadd L
.79879 .16311 3.75 0 Mabsadd L
.79879 .16311 0 -5 Mabsadd L
.79879 .16311 -3.75 0 Mabsadd L closepath F
.80812 .2124 -3.75 0 Mabsadd m
.80812 .2124 0 5 Mabsadd L
.80812 .2124 3.75 0 Mabsadd L
.80812 .2124 0 -5 Mabsadd L
.80812 .2124 -3.75 0 Mabsadd L closepath F
.81746 .26587 -3.75 0 Mabsadd m
.81746 .26587 0 5 Mabsadd L
.81746 .26587 3.75 0 Mabsadd L
.81746 .26587 0 -5 Mabsadd L
.81746 .26587 -3.75 0 Mabsadd L closepath F
.8268 .31435 -3.75 0 Mabsadd m
.8268 .31435 0 5 Mabsadd L
.8268 .31435 3.75 0 Mabsadd L
.8268 .31435 0 -5 Mabsadd L
.8268 .31435 -3.75 0 Mabsadd L closepath F
.83613 .02573 -3.75 0 Mabsadd m
.83613 .02573 0 5 Mabsadd L
.83613 .02573 3.75 0 Mabsadd L
.83613 .02573 0 -5 Mabsadd L
.83613 .02573 -3.75 0 Mabsadd L closepath F
.84547 .07525 -3.75 0 Mabsadd m
.84547 .07525 0 5 Mabsadd L
.84547 .07525 3.75 0 Mabsadd L
.84547 .07525 0 -5 Mabsadd L
.84547 .07525 -3.75 0 Mabsadd L closepath F
.85481 .07058 -3.75 0 Mabsadd m
.85481 .07058 0 5 Mabsadd L
.85481 .07058 3.75 0 Mabsadd L
.85481 .07058 0 -5 Mabsadd L
.85481 .07058 -3.75 0 Mabsadd L closepath F
.86415 .11046 -3.75 0 Mabsadd m
.86415 .11046 0 5 Mabsadd L
.86415 .11046 3.75 0 Mabsadd L
.86415 .11046 0 -5 Mabsadd L
.86415 .11046 -3.75 0 Mabsadd L closepath F
.87348 .10185 -3.75 0 Mabsadd m
.87348 .10185 0 5 Mabsadd L
.87348 .10185 3.75 0 Mabsadd L
.87348 .10185 0 -5 Mabsadd L
.87348 .10185 -3.75 0 Mabsadd L closepath F
.88282 .1091 -3.75 0 Mabsadd m
.88282 .1091 0 5 Mabsadd L
.88282 .1091 3.75 0 Mabsadd L
.88282 .1091 0 -5 Mabsadd L
.88282 .1091 -3.75 0 Mabsadd L closepath F
.89216 .11499 -3.75 0 Mabsadd m
.89216 .11499 0 5 Mabsadd L
.89216 .11499 3.75 0 Mabsadd L
.89216 .11499 0 -5 Mabsadd L
.89216 .11499 -3.75 0 Mabsadd L closepath F
.90149 .10955 -3.75 0 Mabsadd m
.90149 .10955 0 5 Mabsadd L
.90149 .10955 3.75 0 Mabsadd L
.90149 .10955 0 -5 Mabsadd L
.90149 .10955 -3.75 0 Mabsadd L closepath F
.91083 .10647 -3.75 0 Mabsadd m
.91083 .10647 0 5 Mabsadd L
.91083 .10647 3.75 0 Mabsadd L
.91083 .10647 0 -5 Mabsadd L
.91083 .10647 -3.75 0 Mabsadd L closepath F
.92017 .10774 -3.75 0 Mabsadd m
.92017 .10774 0 5 Mabsadd L
.92017 .10774 3.75 0 Mabsadd L
.92017 .10774 0 -5 Mabsadd L
.92017 .10774 -3.75 0 Mabsadd L closepath F
.92951 .1168 -3.75 0 Mabsadd m
.92951 .1168 0 5 Mabsadd L
.92951 .1168 3.75 0 Mabsadd L
.92951 .1168 0 -5 Mabsadd L
.92951 .1168 -3.75 0 Mabsadd L closepath F
.93884 .11997 -3.75 0 Mabsadd m
.93884 .11997 0 5 Mabsadd L
.93884 .11997 3.75 0 Mabsadd L
.93884 .11997 0 -5 Mabsadd L
.93884 .11997 -3.75 0 Mabsadd L closepath F
.94818 .12496 -3.75 0 Mabsadd m
.94818 .12496 0 5 Mabsadd L
.94818 .12496 3.75 0 Mabsadd L
.94818 .12496 0 -5 Mabsadd L
.94818 .12496 -3.75 0 Mabsadd L closepath F
.95752 .12858 -3.75 0 Mabsadd m
.95752 .12858 0 5 Mabsadd L
.95752 .12858 3.75 0 Mabsadd L
.95752 .12858 0 -5 Mabsadd L
.95752 .12858 -3.75 0 Mabsadd L closepath F
.96685 .1322 -3.75 0 Mabsadd m
.96685 .1322 0 5 Mabsadd L
.96685 .1322 3.75 0 Mabsadd L
.96685 .1322 0 -5 Mabsadd L
.96685 .1322 -3.75 0 Mabsadd L closepath F
.97619 .42627 -3.75 0 Mabsadd m
.97619 .42627 0 5 Mabsadd L
.97619 .42627 3.75 0 Mabsadd L
.97619 .42627 0 -5 Mabsadd L
.97619 .42627 -3.75 0 Mabsadd L closepath F
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[30]:=",
  ImageSize->{400, 247.188},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006@0000mb000`400?l00000o`00003ooooooonA
ooooo`00oooooonAooooo`00oooooonAooooo`00oooooonAooooo`00oooooonAooooo`00GOooool5
o`0000?ooooo0_l0000oooooo`?o00000oooool2o`0003kooooo0ol00004ooooo`;o0000?_ooool3
o`0000Cooooo0_l0000jooooo`?o00001?ooool2o`0000Cooooo0_l0000;ooooo`00G_ooool01?l0
003oooooooooool00002ooooo`04o`000?ooooooooooo`0003oooooo00Go0000oooooooooooooooo
o`000002ooooo`03o`000?oooooooooo03[ooooo00Go0000ooooooooooooooooo`000002ooooo`04
o`000?ooooooooooo`0003cooooo00Go0000ooooooooooooooooo`000002ooooo`04o`000?oooooo
ooooo`0003[ooooo00?o0000ooooooooool00_ooool01?l0003oooooooooool00002ooooo`04o`00
0?ooooooooooo`0000[ooooo001Oooooo`03o`000?oooooooooo00;ooooo00Co0000oooooooooooo
0000??ooool5o`0000;ooooo00Co0000oooooooooooo0000??ooool01Ol0003ooooooooooooooooo
000000;ooooo00Co0000oooooooooooo0000??ooool01Ol0003ooooooooooooooooo000000;ooooo
00Co0000oooooooooooo0000>_ooool00ol0003oooooooooo`02ooooo`04o`000?ooooooooooo`00
00;ooooo00Co0000oooooooooooo00002_ooool001cooooo00?o0000ooooooooool0@Oooool01Ol0
003ooooooooooooooooo000000;ooooo00?o0000ooooooooool0>_ooool01?l0003oooooooooool0
0003ooooo`04o`000?ooooooooooo`0003cooooo1?l00003ooooo`04o`000?ooooooooooo`0003go
oooo0ol00003ooooo`04o`000?ooooooooooo`0003[ooooo00?o0000ooooooooool00_ooool01?l0
003oooooooooool00002ooooo`04o`000?ooooooooooo`0000[ooooo000Looooo`?o0000?_ooool0
1Ol0003ooooooooooooooooo000000;ooooo00Co0000oooooooooooo0000?Oooool00ol0003ooooo
o`000003ooooo`04o`000?ooooooooooo`0003cooooo00?o0000ooooooooool01?ooool01?l0003o
ooooooooool0000looooo`05o`000?ooooooooooooooool000000_ooool01?l0003oooooooooool0
000jooooo`03o`000?oooooooooo00;ooooo00Co0000oooooooooooo00000_ooool01?l0003ooooo
ooooool0000:ooooo`007?ooool00ol0003oooooooooo`0nooooo`05o`000?ooooooooooooooool0
00000_ooool01?l0003oooooooooool0000nooooo`;o00000oooool01?l0003oooooooooool0000m
ooooo`03o`000?oooooooooo00?ooooo00Co0000oooooooooooo0000??ooool01Ol0003ooooooooo
oooooooo000000;ooooo00Co0000oooooooooooo0000>Oooool2o`0000Cooooo00Co0000oooooooo
oooo00000_ooool01?l0003oooooooooool0000:ooooo`007?ooool00ol0003oooooooooo`0ooooo
o`?o00001?ooool2o`00043ooooo00?o0000ooooooooool00_ooool2o`00037ooooo00?o0000oooo
ooooool02oooool2o`0000Cooooo0_l0000nooooo`?o00001?ooool2o`0003_ooooo00?o0000oooo
ooooool00oooool2o`0000Cooooo0_l0000;ooooo`007?ooool00ol0003oooooooooo`2oooooo`?o
0000[oooool001cooooo00?o0000ooooooooool0__ooool5o`000:kooooo000Looooo`03o`000?oo
oooooooo0;gooooo1ol0002]ooooo`007?ooool00ol0003oooooooooo`20ooooo`03o`000?oooooo
oooo03Wooooo2?l0001]ooooo`03o`000?oooooooooo03gooooo000Looooo`03o`000?oooooooooo
07oooooo0ol0000kooooo`Oo0000K?ooool3o`0003kooooo000Looooo`03o`000?oooooooooo07ko
oooo1Ol0000kooooo`Go0000K?ooool5o`0003gooooo000Coooooooo0000O_l0000001cooooo00?o
0000ooooooooool03oooool00ol0003oooooooooo`0?ooooo`03o`000?oooooooooo00kooooo00?o
0000ooooooooool02oooool3o`000003ooooool0003ooooo013ooooo00?o0000ooooooooool03_oo
ool00ol0003oooooooooo`0?ooooo`04o`000?ooooooooooooooo`Oo00001oooool00ol0003ooooo
ooooo`0?ooooo`03o`000?oooooooooo00kooooo00?o0000ooooooooool03oooool00ol0003ooooo
ooooo`0?ooooo`03o`000?oooooooooo00kooooo00?o0000ooooooooool03oooool00ol0003ooooo
ooooo`0?ooooo`03o`000?oooooooooo00oooooo00?o0000ooooooooool03_ooool01?l0003ooooo
ooooooooool7o`0000Oooooo00?o0000ooooooooool03oooool00ol0003oooooooooo`0>ooooo`03
o`000?oooooooooo00oooooo000Looooo`03o`000?oooooooooo03oooooo1?l000000ooooooo0000
ooooo`0hooooo`Ko00001oooool00ol0003oooooooooo`14ooooo`03o`000?oooooooooo04Cooooo
00?o0000ooooooooool04oooool6o`0002[ooooo00?o0000ooooooooool03oooool001cooooo00?o
0000ooooooooool0?_ooool6o`0003_ooooo1?l0002]ooooo`Co0000?Oooool001cooooo00?o0000
ooooooooool0?Oooool7o`0003_ooooo0ol0002^ooooo`?o0000?_ooool001cooooo00?o0000oooo
ooooool0?_ooool6o`0003cooooo00?o0000ooooooooool0[_ooool00ol0003oooooooooo`0moooo
o`007?ooool00ol0003oooooooooo`0oooooo`Co0000ooooool_ooooo`007?ooool00ol0003ooooo
ooooo`10ooooo`;o0000ooooool`ooooo`007?ooool00ol0003oooooooooo`11ooooo`03o`000?oo
oooooooo0?oooooo;_ooool001cooooo0ol0003oooooog;ooooo000Looooo`03o`000?oooooooooo
0?ooooooL_ooool001cooooo00?o0000ooooooooool0oooooombooooo`007?ooool00ol0003ooooo
ooooo`3oooooog;ooooo000Looooo`03o`000?oooooooooo02Cooooo00?o0000ooooooooool0oooo
oom;ooooo`007?ooool00ol0003oooooooooo`0Sooooo`?o0000oooooolCooooo`03o`000?oooooo
oooo03Kooooo000Looooo`03o`000?oooooooooo02;ooooo1Ol0002Mooooo`03o`000?oooooooooo
073ooooo0ol0000gooooo`007?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo01Ko
oooo1ol0002Kooooo`?o0000Koooool6o`0003Kooooo000Looooo`?o00001oooool3o`0001Kooooo
2?l0002Jooooo`Co0000K_ooool8o`0003Gooooo000Looooo`03o`000?oooooooooo00Kooooo1Ol0
000Fooooo`Oo0000VOooool6o`0000Oooooo00?o0000ooooooooool0:?ooool00ol0003ooooooooo
o`0gooooo`Wo0000=Oooool001cooooo00?o0000ooooooooool01Oooool7o`0001Kooooo1Ol0002I
ooooo`Oo00001?ooool00ol0003oooooo`000002o`0000;ooooo00?o0000ooooooooool08oooool3
o`0003Oooooo2_l0000eooooo`007?ooool00ol0003oooooooooo`04ooooo`So00005oooool3o`00
09_ooooo1_l00003ooooo`[o000000?oooooo`000?ooool08?ooool4o`0003Kooooo2_l0000foooo
o`007?ooool00ol0003oooooooooo`05ooooo`Oo00006?ooool00ol0003oooooooooo`2Kooooo`Co
000000?oooooo`000?ooool03_l0000Oooooo`Ko0000=_ooool8o`0003Oooooo000Looooo`03o`00
0?oooooooooo00Kooooo1Ol0002hooooo`;o000000?oooooo`000?l000004?l000001Ooooooo0000
oooooooooooo000001Sooooo1ol0000gooooo`Ko0000>?ooool001cooooo00?o0000ooooooooool0
1oooool3o`0007[ooooo00?o0000ooooooooool0?OoooolJo`0001Sooooo1_l0000hooooo`?o0000
>_ooool001cooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`1hooooo`?o00009Ooo
ool00ol0003oooooooooo`0Foooooa_o00006?ooool4o`0003[ooooo00?o0000ooooooooool0>Ooo
ool001cooooo00?o0000ooooooooool0P_ooool5o`0002?ooooo0ol0000Foooooago00000oooool0
0ol0003oooooooooo`0Booooo`;o0000Moooool001cooooo0ol00021ooooo`Oo00008Oooool5o`00
01Kooooo2?l00002ooooo`03o`000?oooooooooo00;o000000?oooooo`000?l000002_l00002oooo
o`?o00000_ooool00ol0003oooooooooo`0?ooooo`03o`000?oooooooooo04Cooooo00?o0000oooo
ooooool0;_ooool001cooooo00?o0000ooooooooool0:oooool00ol0003oooooooooo`1Booooo`So
00008?ooool7o`0001Kooooo1Ol000000ooooooo0000ooooo`05ooooo`03o`000?oooooo000000_o
000000?oooooo`000?l000001_l0001Fooooo`?o0000;oooool001cooooo00?o0000ooooooooool0
:_ooool3o`0003kooooo00?o0000ooooooooool04oooool7o`0001oooooo2?l0000Gooooo`?o0000
3?ooool00ol0003oooooo`000007o`0000;ooooo2Ol000000ooooooo0000ooooo`1Aooooo`Co0000
3?ooool01?l0003oooooooooool0000Oooooo`007?ooool00ol0003oooooooooo`0Yooooo`Go0000
??ooool3o`0001Gooooo1Ol0000Qooooo`Oo00006?ooool00ol0003oooooooooo`0>ooooo`Ko0000
0_ooool=o`000003ooooool0003ooooo02cooooo00?o0000ooooooooool07Oooool8o`0000Kooooo
00?o0000ooooooooool01_l0000Nooooo`007?ooool00ol0003oooooooooo`0Yooooo`Ko00005Ooo
ool00ol0003oooooooooo`0Rooooo`Go00005Oooool3o`0002?ooooo1Ol0000[ooooo`04o`000?oo
ooooooooo`0000?ooooo4?l0000[ooooo`?o00007Oooool:o`0000Cooooo2ol0000Mooooo`007?oo
ool00ol0003oooooooooo`0Xooooo`Oo00005?ooool3o`0002;ooooo1ol0000Eooooo`03o`000?oo
oooooooo02?ooooo0ol0000boooooa;o000000?oooooo`000?ooool09_ooool5o`0001_ooooo3?l0
00000ooooooo0000o`00000=o`0001_ooooo0007ooooo`?o00001?ooool2o`0000Cooooo0_l00006
ooooo`03o`000?oooooooooo02Wooooo1_l0000Cooooo`Go00008?ooool8o`0003cooooo00?o0000
ooooooooool0<?oooolFo`000003ooooool0003ooooo02;ooooo1ol0000Ioooooako00006_ooool0
00Kooooo00Go0000ooooooooooooooooo`000002ooooo`04o`000?ooooooooooo`0000;ooooo00Co
0000oooooooooooo00001Oooool00ol0003oooooooooo`0Zooooo`Co00004oooool7o`00023ooooo
1ol0001^ooooo`Oo00000_oooolAo`00027ooooo2?l0000Hooooob7o00006?ooool000Kooooo00Go
0000ooooooooooooooooo`000002ooooo`04o`000?ooooooooooo`0000;ooooo00Co0000oooooooo
oooo00001Oooool4o`0002Wooooo0ol0000Cooooo`So00008Oooool5o`0001Wooooo00?o0000oooo
ooooool0D_ooool8o`0000?ooooo00?o0000ooooool000003_l0000Qooooo`Oo00006OoooolQo`00
01Oooooo0006ooooo`Co00000oooool01?l0003oooooooooool00002ooooo`04o`000?oooooooooo
o`0000Gooooo00?o0000ooooooooool0:oooool00ol0003oooooooooo`0Cooooo`Oo00008_ooool3
o`0001Wooooo0ol0001Dooooo`Oo00001_ooool?o`00027ooooo1Ol0000Kooooo`Go00000_ooool>
o`000003ooooool0003o000000Wo000000?oooooo`000?ooool04oooool000Kooooo00?o0000oooo
ooooool01?ooool01?l0003oooooooooool00002ooooo`04o`000?ooooooooooo`0000Gooooo00?o
0000ooooooooool0@_ooool5o`0002Cooooo00?o0000ooooooooool05oooool5o`0005Cooooo1Ol0
0008ooooo`03o`000?oooooo000000_o00008_ooool3o`0001gooooo0ol00004ooooo`[o00000_oo
ool00ol0003oooooooooo`0=o`000003ooooool0003ooooo013ooooo0007ooooo`03o`000?oooooo
oooo00?ooooo00Co0000oooooooooooo00000_ooool01?l0003oooooooooool00005ooooo`03o`00
0?oooooooooo04?ooooo0ol00002ooooo`03o`000?oooooooooo03[ooooo1_l0001Dooooo`?o0000
3?ooool00ol0003oooooo`000008o`0002?ooooo00?o0000ooooooooool07Oooool00ol0003ooooo
ooooo`04ooooo`03o`000?oooooo000000?o000000?oooooo`000?ooool01oooool>o`0000;ooooo
00?o0000ooooooooool02oooool000Sooooo0_l00004ooooo`;o00001?ooool2o`0000Kooooo00?o
0000ooooooooool0A?ooool00ol0003oooooooooo`03o`0003[ooooo1ol0001Eooooo`03o`000?oo
oooooooo00kooooo1ol0001>ooooo`;o00003?oooolAo`0000cooooo000Looooo`03o`000?oooooo
oooo04Kooooo1?l0000kooooo`Ko0000Ioooool00ol0003oooooo`000002o`0000Gooooo00?o0000
ooooooooool0B?ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooo000000ko00002oooool0
01cooooo00?o0000ooooooooool0AOooool6o`0000Cooooo00Co0000oooooooooooo0000<oooool4
o`0006_ooooo00?o0000ooooooooool00oooool3o`0005Wooooo4?l0000:ooooo`007?ooool00ol0
003oooooooooo`14ooooo`So00000_ooool6o`0003;ooooo0ol0001aooooo`Go0000FOooool00ol0
003oooooo`00000<o`0000[ooooo000Looooo`03o`000?oooooooooo04Gooooo4?l0000booooo`05
o`000?ooooooooooooooool000000_ooool00ol0003oooooooooo`1Xooooo`Oo0000Foooool<o`00
00[ooooo000Looooo`?o0000A_ooool@o`0003Cooooo1_l0001Xooooo`So0000G?ooool00ol0003o
ooooo`000007o`0000_ooooo000Looooo`03o`000?oooooooooo04Oooooo3ol0000cooooo`So0000
J?ooool7o`0005oooooo00?o0000ooooooooool00ol0000<ooooo`007?ooool00ol0003ooooooooo
o`17ooooo`oo0000<_ooool:o`0006Sooooo1Ol0001Tooooo`03o`000?oooooooooo00_ooooo000L
ooooo`03o`000?oooooooooo04Sooooo3Ol0000booooo`co0000J?ooool3o`0007?ooooo000Loooo
o`03o`000?oooooooooo04Wooooo1ol000001?oooooo0000o`000?l0000dooooo`co0000J?ooool0
0ol0003oooooooooo`1booooo`007?ooool00ol0003oooooooooo`1:ooooo`?o00000_ooool01?l0
003oooooooooool0000fooooo`co0000g?ooool001cooooo00?o0000ooooooooool0Boooool00ol0
003oooooooooo`0looooo`go0000S?ooool00ol0003oooooooooo`1;ooooo`007?ooool00ol0003o
ooooooooo`2;ooooo`03o`000?oooooooooo00[o000000?oooooo`000?ooool04oooool00ol0003o
ooooooooo`1aooooo`?o0000C?ooool001cooooo00?o0000ooooooooool0E_ooool00ol0003ooooo
ooooo`0fooooo`co00004_ooool3o`00073ooooo1_l0001;ooooo`007?ooool3o`0005Gooooo0ol0
000hooooo`co000000?oooooo`000?ooool03Oooool5o`0006kooooo2?l0001:ooooo`007?ooool0
0ol0003oooooooooo`1Dooooo`Go0000>?ooool>o`0000gooooo1_l0001/ooooo`Wo0000B_ooool0
01cooooo00?o0000ooooooooool0Doooool7o`0003Sooooo3Ol00005ooooo`03o`000?oooooooooo
00Cooooo1ol0001[ooooo`[o0000B_ooool001cooooo00?o0000ooooooooool0:?ooool00ol0003o
ooooooooo`0Wooooo`So00001_ooool00ol0003oooooooooo`0aooooo`co00000oooool3o`0000Ko
oooo1_l0001Zooooo`[o0000Boooool001cooooo00?o0000ooooooooool09oooool3o`0002Wooooo
1ol00005ooooo`?o00000_ooool00ol0003oooooooooo`0^ooooo`_o00000_ooool4o`0000Oooooo
1?l0001/ooooo`So0000C?ooool001cooooo00?o0000ooooooooool09_ooool4o`0002[ooooo1Ol0
0005ooooo`So0000<?ooool00ol0003oooooo`000007o`000003ooooool0003o000000Co00001_oo
ool3o`0006kooooo1?l000000ooooooo0000ooooo`1<ooooo`007?ooool00ol0003oooooooooo`0U
ooooo`Ko0000:_ooool3o`0000Kooooo2Ol0000booooo`03o`000?oooooo000000?o000000?ooooo
o`000?l000001Ol00007ooooo`03o`000?oooooooooo06kooooo0_l0001@ooooo`007?ooool00ol0
003oooooooooo`0Tooooo`Oo0000:oooool01?l0003oooooooooool00003ooooo`_o00001oooool0
0ol0003oooooooooo`0Zooooo`;o00000oooool6o`0005Wooooo00?o0000ooooooooool01?ooool0
0ol0003oooooooooo`0Fooooo`03o`000?oooooooooo04kooooo000Looooo`?o00009Oooool6o`00
02gooooo0ol000000ooooooo0000o`00000:o`0000Kooooo0ol0000/ooooo`03o`000?oooooooooo
00;ooooo1?l0001Iooooo`?o00001?ooool3o`0006Sooooo000Looooo`03o`000?oooooooooo02Ko
oooo1?l0000]oooooa7o00001Oooool4o`0003;ooooo0_l0001Iooooo`Ko000000?oooooo`000?l0
00000ol0001Wooooo`007?ooool00ol0003oooooooooo`0Wooooo`;o0000;_ooool@o`0000Gooooo
1_l0000booooo`03o`000?oooooooooo05Kooooo3_l0001Vooooo`007?ooool00ol0003ooooooooo
o`0Xooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool09?ooool;o`0000;ooooo0ol0
0005ooooo`Oo0000R_ooool?o`0006Kooooo000Looooo`03o`000?oooooooooo02kooooo0ol0000V
ooooo`[o00000oooool00ol0003oooooooooo`05ooooo`Ko0000Roooool>o`0006Kooooo000Loooo
o`03o`000?oooooooooo02gooooo1Ol0000Vooooo`So00003Oooool4o`0008gooooo3?l0001Woooo
o`001oooool3o`0000Cooooo0_l00004ooooo`;o00001_ooool00ol0003oooooooooo`0?ooooo`03
o`000?oooooooooo01[ooooo1ol0000Uooooo`?o000000Coooooo`000?l0003o00003oooool2o`00
08oooooo2_l0001Xooooo`001_ooool01Ol0003ooooooooooooooooo000000;ooooo00Co0000oooo
oooooooo00000_ooool01?l0003oooooooooool00005ooooo`03o`000?oooooooooo00kooooo0ol0
000Jooooo`So00009_ooool01Ol0003ooooooooooooooooo0000017ooooo00?o0000ooooooooool0
;_ooool00ol0003oooooooooo`1Mooooo`03o`000?oooooo000000?o000000?oooooo`000?ooool0
J?ooool000Kooooo00Go0000ooooooooooooooooo`000002ooooo`04o`000?ooooooooooo`0000;o
oooo00Co0000oooooooooooo00001Oooool00ol0003oooooooooo`0=ooooo`Go00006_ooool7o`00
06cooooo0ol0001Pooooo`?o00008_ooool00ol0003oooooooooo`17ooooo`001oooool3o`0000?o
oooo00Co0000oooooooooooo00000_ooool01?l0003oooooooooool00005ooooo`Co00002oooool7
o`0001[ooooo1Ol0001/ooooo`Go0000H?ooool00ol0003oooooooooo`0Pooooo`?o0000B?ooool0
00Kooooo00Go0000ooooooooooooooooo`000002ooooo`04o`000?ooooooooooo`0000;ooooo00Co
0000oooooooooooo00001Oooool00ol0003oooooooooo`0;ooooo`So00006oooool3o`0006cooooo
1ol00021ooooo`Co0000B?ooool000Kooooo00Go0000ooooooooooooooooo`000002ooooo`04o`00
0?ooooooooooo`0000;ooooo00Co0000oooooooooooo00001Oooool00ol0003oooooooooo`0<oooo
o`Oo00007?ooool00ol0003oooooooooo`1Zooooo`So00003_ooool00ol0003oooooooooo`1_oooo
o`Ko0000Aoooool000Oooooo0ol00004ooooo`;o00001?ooool2o`0000Kooooo00?o0000oooooooo
ool03Oooool5o`0008_ooooo1ol0000=ooooo`?o0000Koooool7o`0004Oooooo000Looooo`03o`00
0?oooooooooo00kooooo0ol0002=ooooo`Go00003Oooool5o`0005Gooooo00?o0000ooooooooool0
5oooool6o`0004Oooooo000Looooo`03o`000?oooooooooo00oooooo00?o0000ooooooooool0SOoo
ool3o`0000gooooo1ol0001Cooooo`?o00006Oooool4o`0004Sooooo000Looooo`03o`000?oooooo
oooo0:3ooooo00?o0000ooooooooool02oooool8o`0005;ooooo1Ol0000Iooooo`;o0000BOooool0
01cooooo00?o0000ooooooooool0[oooool7o`0005;ooooo1_l0000Iooooo`03o`000?oooooooooo
04Oooooo000Looooo`?o0000/?ooool5o`0005;ooooo1ol0001Sooooo`007?ooool00ol0003ooooo
ooooo`2aooooo`?o000000?oooooo`000?ooool0DOooool6o`0000?ooooo00?o0000ooooooooool0
GOooool001cooooo00?o0000ooooooooool0Yoooool00ol0003oooooooooo`08ooooo`03o`000?oo
oooo000000;o0000D_ooool4o`000003ooooool0003ooooo00?o0000G_ooool001cooooo00?o0000
ooooooooool0Y_ooool3o`0000[ooooo1Ol0001Aooooo`?o000000?oooooo`000?l000001Ol0001M
ooooo`007?ooool00ol0003oooooooooo`2Uooooo`Go00002Oooool6o`00057ooooo00?o0000oooo
ool000002Ol0001Kooooo`007?ooool00ol0003oooooooooo`2Tooooo`Oo00001oooool7o`0005;o
oooo3?l0001Jooooo`007?ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo09Gooooo
2?l00008ooooo`Ko0000DOooool>o`0005Wooooo000Looooo`03o`000?oooooooooo00[ooooo0ol0
001Jooooo`03o`000?oooooooooo03[ooooo1ol00009ooooo`Co0000Doooool>o`0005Sooooo000L
ooooo`03o`000?oooooooooo00Wooooo1Ol0001Hooooo`?o0000??ooool5o`0000[ooooo0ol0001E
ooooo`go0000F?ooool001cooooo0ol00009ooooo`Ko0000E_ooool5o`0003cooooo0ol0000<oooo
o`03o`000?oooooooooo05Gooooo0ol000000ooooooo0000o`000006o`0005Sooooo000Looooo`03
o`000?oooooooooo00Sooooo1ol0001Fooooo`Ko0000??ooool00ol0003oooooooooo`1Tooooo`03
o`000?oooooooooo00;ooooo1Ol0001Iooooo`007?ooool00ol0003oooooooooo`09ooooo`Ko0000
EOooool7o`000:Wooooo0ol0000Cooooo`03o`000?oooooooooo04Cooooo000Looooo`03o`000?oo
oooooooo00[ooooo1?l0001Gooooo`Ko0000Z_ooool00ol0003oooooooooo`0Aooooo`?o0000AOoo
ool001cooooo00?o0000ooooooooool02_ooool3o`0005Wooooo1?l0000<ooooo`03o`000?oooooo
oooo0:oooooo1Ol00014ooooo`007?ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo
05Sooooo0ol00009ooooo`03o`000?oooooooooo00?o0000/?ooool6o`0004?ooooo000Looooo`03
o`000?oooooooooo06Oooooo00?o0000ooooooooool01oooool7o`000:oooooo1ol00013ooooo`00
7?ooool00ol0003oooooooooo`1`ooooo`Wo0000[oooool6o`0004?ooooo000Looooo`?o0000Kooo
ool:o`000;3ooooo1?l00014ooooo`007?ooool00ol0003oooooooooo`1^ooooo`_o0000/?ooool3
o`0004Gooooo000Looooo`03o`000?oooooooooo06oooooo2Ol0002booooo`03o`000?oooooooooo
04Cooooo000Looooo`03o`000?oooooooooo073ooooo1ol0003jooooo`007?ooool00ol0003ooooo
ooooo`1aooooo`?o00000_ooool00ol0003oooooooooo`3hooooo`007?ooool00ol0003ooooooooo
o`1booooo`03o`000?oooooooooo0?cooooo000Looooo`03o`000?oooooooooo03Kooooo00?o0000
ooooooooool0ooooooliooooo`0000Coooooo`000?l0003o00001?ooool2o`0000Cooooo0_l00004
ooooo`;o00001_ooool00ol0003oooooooooo`0eooooo`?o0000hOooool00ol0003oooooooooo`1E
ooooo`000_ooool00ol0003oooooooooo`02ooooo`04o`000?ooooooooooo`0000;ooooo00Co0000
oooooooooooo00000_ooool01?l0003oooooooooool00005ooooo`03o`000?oooooooooo03;ooooo
00?o0000ooooool000001?l00020ooooo`03o`000?oooooooooo05cooooo0ol0001Fooooo`000_oo
ool00ol0003oooooooooo`02ooooo`04o`000?ooooooooooo`0000;ooooo00Co0000oooooooooooo
00000_ooool01?l0003oooooooooool00005ooooo`Co0000<?ooool9o`0007kooooo0ol0001Loooo
o`Co0000E_ooool000;ooooo00?o0000ooooooooool00_ooool01?l0003oooooooooool00002oooo
o`04o`000?ooooooooooo`0000;ooooo00Co0000oooooooooooo00001Oooool00ol0003ooooooooo
o`0`ooooo`[o0000OOooool5o`0005[ooooo1_l0001Eooooo`000_ooool00ol0003oooooooooo`02
ooooo`04o`000?ooooooooooo`0000;ooooo00Co0000oooooooooooo00000_ooool01?l0003ooooo
ooooool00005ooooo`03o`000?oooooooooo033ooooo2_l0001looooo`Oo0000F?ooool7o`0005Go
oooo00000ooooooo0000o`000004ooooo`04o`000?ooooooooooo`0000;ooooo00Co0000oooooooo
oooo00000_ooool01?l0003oooooooooool00005ooooo`03o`000?oooooooooo02oooooo2_l0001l
ooooo`So0000FOooool6o`0001;ooooo00?o0000ooooooooool0@?ooool000;ooooo00?o0000oooo
ooooool00oooool2o`0000Cooooo0_l00004ooooo`;o00001_ooool00ol0003oooooooooo`0`oooo
o`So0000O_ooool7o`0005[ooooo1?l0000Booooo`?o0000@Oooool001cooooo00?o0000oooooooo
ool0<Oooool4o`000003ooooool0003ooooo07oooooo1Ol0001Looooo`;o00004_ooool5o`00043o
oooo000Looooo`03o`000?oooooooooo037ooooo0ol00024ooooo`?o0000G_ooool00ol0003ooooo
ooooo`0?ooooo`Oo0000?oooool001cooooo00?o0000ooooooooool0<_ooool00ol0003ooooooooo
o`24ooooo`03o`000?oooooooooo06kooooo2?l0000oooooo`007?ooool00ol0003oooooooooo`3o
ooooobcooooo1ol0000oooooo`007?ooool3o`000?oooooo;Oooool5o`00043ooooo000Looooo`03
o`000?oooooooooo0?oooooo;_ooool3o`00047ooooo000Looooo`03o`000?oooooooooo0?oooooo
;oooool00ol0003oooooooooo`10ooooo`007?ooool00ol0003oooooooooo`0Booooo`03o`000?oo
oooooooo0?ooooooGOooool001cooooo00?o0000ooooooooool04Oooool3o`000?ooooooG_ooool0
01cooooo00?o0000ooooooooool04?ooool5o`000?ooooooGOooool001cooooo00?o0000oooooooo
ool04?ooool6o`000?ooooooG?ooool001cooooo00?o0000ooooooooool03oooool7o`000?oooooo
G?ooool001cooooo0ol0000@ooooo`Ko0000oooooomLooooo`007?ooool00ol0003oooooooooo`0A
ooooo`Co0000oooooomMooooo`007?ooool00ol0003oooooooooo`0Aooooo`?o0000oooooomNoooo
o`007?ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo0?ooooooGOooool001cooooo
00?o0000ooooooooool0NOooool00ol0003oooooooooo`3eooooo`007?ooool00ol0003ooooooooo
o`1hooooo`?o0000m_ooool001cooooo00?o0000ooooooooool0Moooool5o`000?Gooooo000Loooo
o`03o`000?oooooooooo07Kooooo1ol0003dooooo`007?ooool00ol0003oooooooooo`1eooooo`So
0000m?ooool001cooooo0ol0001fooooo`Oo0000?oooool00ol0003oooooooooo`2booooo`007?oo
ool00ol0003oooooooooo`1gooooo`Go0000?oooool3o`000;?ooooo000Looooo`03o`000?oooooo
oooo07Sooooo0ol0000oooooo`Go0000/_ooool001cooooo00?o0000ooooooooool0NOooool00ol0
003oooooooooo`0nooooo`Ko0000/Oooool001cooooo00?o0000ooooooooool0^Oooool7o`000;7o
oooo000Looooo`03o`000?oooooooooo0;[ooooo1_l0002aooooo`0000Coooooo`000?l0003o0000
0_ooool5o`0000?ooooo0_l00004ooooo`;o00001_ooool00ol0003oooooooooo`2kooooo`Co0000
/_ooool000;ooooo00?o0000ooooooooool00_ooool01?l0003oooooooooool00002ooooo`04o`00
0?ooooooooooo`0000;ooooo00Co0000oooooooooooo00001Oooool00ol0003oooooooooo`2koooo
o`?o0000/oooool000;ooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`02ooooo`04
o`000?ooooooooooo`0000;ooooo00Co0000oooooooooooo00001Oooool4o`000;_ooooo00?o0000
ooooooooool0/_ooool000;ooooo00?o0000ooooooooool01?ooool01Ol0003ooooooooooooooooo
000000;ooooo00Co0000oooooooooooo00000_ooool00ol0003oooooooooo`03ooooo`03o`000?oo
oooooooo0?ooooooL_ooool000;ooooo00Go0000ooooooooooooooooo`000003ooooo`04o`000?oo
ooooooooo`0000;ooooo00Co0000oooooooooooo00000_ooool00ol0003oooooooooo`03ooooo`03
o`000?oooooooooo0?ooooooL_ooool00003ooooool0003o000000?ooooo00Go0000oooooooooooo
ooooo`000002ooooo`04o`000?ooooooooooo`0000;ooooo00Co0000oooooooooooo00001Oooool0
0ol0003oooooooooo`3oooooog;ooooo0002ooooo`03o`000?oooooooooo00;ooooo0ol00004oooo
o`;o00001?ooool2o`0000Kooooo00?o0000ooooooooool0oooooombooooo`007?ooool00ol0003o
ooooooooo`3oooooog;ooooo000Looooo`03o`000?oooooooooo03Wooooo00?o0000ooooooooool0
oooooolfooooo`007?ooool00ol0003oooooooooo`0hooooo`?o0000oooooolgooooo`007?ooool0
0ol0003oooooooooo`0gooooo`Go0000oooooolfooooo`007?ooool3o`0003Oooooo1_l0003ooooo
ocGooooo000Looooo`03o`000?oooooooooo03Kooooo1ol0003oooooocGooooo000Looooo`03o`00
0?oooooooooo03Oooooo1_l0003oooooocGooooo000Looooo`03o`000?oooooooooo03Sooooo1?l0
003oooooob_ooooo00?o0000ooooooooool02?ooool001cooooo00?o0000ooooooooool0>?ooool3
o`000?oooooo:oooool3o`0000Wooooo000Looooo`03o`000?oooooooooo03Wooooo00?o0000oooo
ooooool0oooooolYooooo`Go00002?ooool001cooooo00?o0000ooooooooool05_ooool00ol0003o
ooooooooo`3oooooodcooooo1_l00007ooooo`007?ooool00ol0003oooooooooo`0Eooooo`?o0000
oooooom<ooooo`Oo00001oooool001cooooo00Go0000ooooooooooooooooo`00000Booooo`Go0000
00?oooooo`000?ooool0oooooom9ooooo`Ko00001oooool001cooooo1_l0000@ooooo`Wo0000oooo
oom:ooooo`Co00002?ooool001cooooo00?o0000ooooool000001?l0000>ooooo`[o0000oooooom:
ooooo`?o00002Oooool001cooooo2?l0000>ooooo`[o0000oooooom:ooooo`03o`000?oooooooooo
00Sooooo000Looooo`So00003oooool9o`000?ooooooEOooool001cooooo2?l0000@ooooo`So0000
oooooomEooooo`007?ooool00ol0003oooooo`000004o`0001;ooooo00?o0000ooooool000000ol0
001Qooooo`03o`000?oooooooooo0?7ooooo000Looooo`03o`000?oooooooooo00?o00005_ooool2
o`00067ooooo0ol0003booooo`007?ooool01Ol0003ooooooooooooooooo000001Sooooo00?o0000
ooooooooool0G_ooool4o`000?;ooooo000Looooo`?o0000N_ooool6o`000?7ooooo000Looooo`03
o`000?oooooooooo07Wooooo1ol0003aooooo`007?ooool00ol0003oooooooooo`1jooooo`Ko0000
lOooool001cooooo00?o0000ooooooooool0Noooool4o`000?;ooooo000Looooo`03o`000?oooooo
oooo07cooooo0_l0003cooooo`007?ooool00ol0003oooooooooo`1mooooo`03o`000?oooooooooo
0?7ooooo00001?oooooo0000o`000?l00004ooooo`?o00000oooool2o`0000Cooooo0_l00006oooo
o`03o`000?oooooooooo0?ooooooL_ooool000;ooooo00?o0000ooooooooool01?ooool01Ol0003o
oooooooooooooooo000000;ooooo00Co0000oooooooooooo00000_ooool00ol0003oooooooooo`03
ooooo`03o`000?oooooooooo0?ooooooL_ooool000;ooooo00Co0000oooooooooooooooo1Ol00002
ooooo`04o`000?ooooooooooo`0000;ooooo00Co0000oooooooooooo00001Oooool00ol0003ooooo
ooooo`3oooooog;ooooo0002ooooo`05o`000?ooooooooooooooool000000_ooool01Ol0003ooooo
oooooooooooo000000;ooooo00Co0000oooooooooooo00000_ooool00ol0003oooooooooo`03oooo
o`Co0000oooooomaooooo`000_ooool00ol0003oooooooooo`02ooooo`03o`000?oooooo000000?o
oooo00Co0000oooooooooooo00000_ooool01?l0003oooooooooool00005ooooo`03o`000?oooooo
oooo0?ooooooL_ooool00003ooooool0003o000000Gooooo0_l00003ooooo`04o`000?oooooooooo
o`0000;ooooo00Co0000oooooooooooo00001Oooool00ol0003oooooooooo`3oooooog;ooooo0002
ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool00_ooool2o`0000Cooooo0_l00006
ooooo`03o`000?oooooooooo0?ooooooL_ooool001cooooo00?o0000ooooooooool0oooooomboooo
o`007?ooool00ol0003oooooooooo`3oooooog;ooooo000Looooo`03o`000?oooooooooo0?oooooo
L_ooool001cooooo00?o0000ooooooooool0oooooombooooo`007?ooool3o`000?ooooooL_ooool0
01cooooo00?o0000ooooooooool0oooooombooooo`007?ooool00ol0003oooooooooo`3oooooog;o
oooo000Looooo`03o`000?oooooooooo0?ooooooL_ooool001cooooo00?o0000ooooooooool0oooo
oombooooo`007?ooool00ol0003oooooooooo`3oooooog;ooooo000Looooo`03o`000?oooooooooo
0?ooooooL_ooool001cooooo00?o0000ooooooooool0oooooombooooo`007?ooool00ol0003ooooo
ooooo`3oooooog;ooooo000Looooo`?o0000?Oooool00ol0003oooooooooo`3ooooooc;ooooo000L
ooooo`03o`000?oooooooooo03cooooo0ol0003ooooooc?ooooo000Looooo`03o`000?oooooooooo
03_ooooo1Ol0003ooooooc;ooooo000Looooo`03o`000?oooooooooo03[ooooo1ol0003ooooooc7o
oooo000Looooo`03o`000?oooooooooo03Wooooo2?l0003ooooooc7ooooo000Looooo`03o`000?oo
oooooooo03[ooooo1ol0003ooooooc7ooooo000Looooo`03o`000?oooooooooo03_ooooo1Ol0003o
oooooc;ooooo000Looooo`03o`000?oooooooooo03cooooo0ol0003ooooooc?ooooo000Looooo`03
o`000?oooooooooo03gooooo00?o0000ooooooooool0oooooolbooooo`007?ooool3o`000?oooooo
L_ooool001cooooo00?o0000ooooooooool0oooooombooooo`007?ooool00ol0003oooooooooo`3o
ooooog;ooooo000Looooo`03o`000?oooooooooo0?ooooooL_ooool001cooooo00?o0000oooooooo
ool0oooooombooooo`007?ooool00ol0003oooooooooo`3oooooog;ooooo00001?oooooo0000o`00
0?l00003ooooo`?o00001?ooool2o`0000Cooooo0_l00006ooooo`03o`000?oooooooooo0?oooooo
L_ooool000;ooooo00Go0000ooooooooooooooooo`000003ooooo`04o`000?ooooooooooo`0000;o
oooo00Co0000oooooooooooo00000_ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo
0?ooooooL_ooool000;ooooo00Go0000ooooooooooooooooo`000003ooooo`04o`000?oooooooooo
o`0000;ooooo00Co0000oooooooooooo00000_ooool00ol0003oooooooooo`03ooooo`Co0000oooo
oomaooooo`000_ooool01?l0003oooooooooooooool4o`0000?ooooo00Co0000oooooooooooo0000
0_ooool01?l0003oooooooooool00005ooooo`03o`000?oooooooooo0?ooooooL_ooool000;ooooo
00Go0000ooooooooooooooooo`000006ooooo`04o`000?ooooooooooo`0000;ooooo00Co0000oooo
oooooooo00001Oooool00ol0003oooooooooo`3oooooog;ooooo00000ooooooo0000o`000004oooo
o`03o`000?oooooooooo00?ooooo00Co0000oooooooooooo00000_ooool01?l0003oooooooooool0
0005ooooo`03o`000?oooooooooo0?ooooooL_ooool000;ooooo00?o0000ooooooooool00oooool2
o`0000Cooooo0_l00004ooooo`;o00001_ooool00ol0003oooooooooo`3oooooog;ooooo000Loooo
o`03o`000?oooooooooo0?ooooooL_ooool001cooooo00?o0000ooooooooool0oooooombooooo`00
7?ooool00ol0003oooooooooo`3oooooog;ooooo000Looooo`03o`000?oooooooooo0?ooooooL_oo
ool001cooooo0ol0003oooooog;ooooo000Looooo`03o`000?oooooooooo0?ooooooL_ooool001co
oooo00?o0000ooooooooool07Oooool00ol0003oooooooooo`3ooooooe;ooooo000Looooo`03o`00
0?oooooooooo01cooooo0ol0003ooooooe?ooooo000Looooo`03o`000?oooooooooo01_ooooo1Ol0
003ooooooe;ooooo000Looooo`03o`000?oooooooooo01[ooooo1ol0003ooooooe7ooooo000Loooo
o`03o`000?oooooooooo01Wooooo2?l0003ooooooe7ooooo000Looooo`03o`000?oooooooooo01[o
oooo1ol0003ooooooe7ooooo000Looooo`?o00006oooool5o`000?ooooooD_ooool001cooooo00?o
0000ooooooooool07?ooool3o`000?ooooooDoooool001cooooo00?o0000ooooooooool07Oooool0
0ol0003oooooooooo`3ooooooe;ooooo003ooooooi7ooooo003ooooooi7ooooo003ooooooi7ooooo
0000\
\>"],
  ImageRangeCache->{{{0, 399}, {246.188, 0}} -> {-8.11617, 297.374, 0.282373, \
5.81884}}]
}, Open  ]],

Cell["\<\
Per enfatizzare il trend di variazione della serie \[EGrave] \
possibile unire con delle linee i singoli punti:\
\>", "Text",
  PageWidth->PaperWidth],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(MultipleListPlot[ion, 
        SymbolShape \[Rule] {enlarge[PlotSymbol[Diamond], 2]}, 
        PlotJoined \[Rule] True];\)\)], "Input",
  CellLabel->"In[31]:=",
  PageWidth->PaperWidth],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
%%ImageSize: 400 247.214 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.00933707 -0.155516 0.000453103 [
[.21055 .01323 -6 -9 ]
[.21055 .01323 6 0 ]
[.39729 .01323 -6 -9 ]
[.39729 .01323 6 0 ]
[.58403 .01323 -6 -9 ]
[.58403 .01323 6 0 ]
[.77077 .01323 -6 -9 ]
[.77077 .01323 6 0 ]
[.95752 .01323 -9 -9 ]
[.95752 .01323 9 0 ]
[.01131 .11635 -18 -4.5 ]
[.01131 .11635 0 4.5 ]
[.01131 .20697 -18 -4.5 ]
[.01131 .20697 0 4.5 ]
[.01131 .29759 -24 -4.5 ]
[.01131 .29759 0 4.5 ]
[.01131 .38821 -24 -4.5 ]
[.01131 .38821 0 4.5 ]
[.01131 .47883 -24 -4.5 ]
[.01131 .47883 0 4.5 ]
[.01131 .56945 -24 -4.5 ]
[.01131 .56945 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21055 .02573 m
.21055 .03198 L
s
[(20)] .21055 .01323 0 1 Mshowa
.39729 .02573 m
.39729 .03198 L
s
[(40)] .39729 .01323 0 1 Mshowa
.58403 .02573 m
.58403 .03198 L
s
[(60)] .58403 .01323 0 1 Mshowa
.77077 .02573 m
.77077 .03198 L
s
[(80)] .77077 .01323 0 1 Mshowa
.95752 .02573 m
.95752 .03198 L
s
[(100)] .95752 .01323 0 1 Mshowa
.125 Mabswid
.07049 .02573 m
.07049 .02948 L
s
.11718 .02573 m
.11718 .02948 L
s
.16387 .02573 m
.16387 .02948 L
s
.25724 .02573 m
.25724 .02948 L
s
.30392 .02573 m
.30392 .02948 L
s
.35061 .02573 m
.35061 .02948 L
s
.44398 .02573 m
.44398 .02948 L
s
.49066 .02573 m
.49066 .02948 L
s
.53735 .02573 m
.53735 .02948 L
s
.63072 .02573 m
.63072 .02948 L
s
.6774 .02573 m
.6774 .02948 L
s
.72409 .02573 m
.72409 .02948 L
s
.81746 .02573 m
.81746 .02948 L
s
.86415 .02573 m
.86415 .02948 L
s
.91083 .02573 m
.91083 .02948 L
s
.25 Mabswid
0 .02573 m
1 .02573 L
s
.02381 .11635 m
.03006 .11635 L
s
[(600)] .01131 .11635 1 0 Mshowa
.02381 .20697 m
.03006 .20697 L
s
[(800)] .01131 .20697 1 0 Mshowa
.02381 .29759 m
.03006 .29759 L
s
[(1000)] .01131 .29759 1 0 Mshowa
.02381 .38821 m
.03006 .38821 L
s
[(1200)] .01131 .38821 1 0 Mshowa
.02381 .47883 m
.03006 .47883 L
s
[(1400)] .01131 .47883 1 0 Mshowa
.02381 .56945 m
.03006 .56945 L
s
[(1600)] .01131 .56945 1 0 Mshowa
.125 Mabswid
.02381 .04838 m
.02756 .04838 L
s
.02381 .07104 m
.02756 .07104 L
s
.02381 .09369 m
.02756 .09369 L
s
.02381 .139 m
.02756 .139 L
s
.02381 .16166 m
.02756 .16166 L
s
.02381 .18431 m
.02756 .18431 L
s
.02381 .22962 m
.02756 .22962 L
s
.02381 .25228 m
.02756 .25228 L
s
.02381 .27493 m
.02756 .27493 L
s
.02381 .32024 m
.02756 .32024 L
s
.02381 .3429 m
.02756 .3429 L
s
.02381 .36555 m
.02756 .36555 L
s
.02381 .41086 m
.02756 .41086 L
s
.02381 .43352 m
.02756 .43352 L
s
.02381 .45617 m
.02756 .45617 L
s
.02381 .50148 m
.02756 .50148 L
s
.02381 .52414 m
.02756 .52414 L
s
.02381 .54679 m
.02756 .54679 L
s
.02381 .00307 m
.02756 .00307 L
s
.02381 .5921 m
.02756 .5921 L
s
.02381 .61476 m
.02756 .61476 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.001 w
.03315 .43896 m
0 0 rlineto s
.03315 .43896 m
.03663 .61803 L
s
.04582 .61803 m
.05182 .07706 L
.06116 .25201 L
.07049 .20724 L
.07983 .33664 L
.08917 .43456 L
.09851 .43982 L
.10784 .60615 L
s
.10784 .60615 m
.10846 .61803 L
s
.11938 .61803 m
.12652 .06913 L
.13585 .17874 L
.14519 .10611 L
.15453 .20085 L
.16387 .30289 L
.1732 .29741 L
.18254 .41136 L
.19188 .53338 L
.20121 .03424 L
.21055 .11168 L
.21989 .13039 L
.22923 .14263 L
.23856 .139 L
.2479 .14022 L
.25724 .16954 L
.26657 .18853 L
.27591 .18884 L
.28525 .17829 L
.29458 .18223 L
.30392 .25518 L
.31326 .10674 L
.3226 .18979 L
.33193 .27357 L
.34127 .27081 L
.35061 .36098 L
.35994 .45649 L
.36928 .02708 L
.37862 .09346 L
.38796 .1236 L
.39729 .14353 L
.40663 .14534 L
.41597 .15486 L
.4253 .16256 L
.43464 .16664 L
.44398 .17072 L
.45331 .20923 L
.46265 .1757 L
.47199 .24167 L
.48133 .09745 L
.49066 .16555 L
.5 .22224 L
.50934 .23832 L
.51867 .30139 L
.52801 .3748 L
.53735 .01472 L
.54669 .0723 L
.55602 .0883 L
.56536 .08345 L
.5747 .0815 L
Mistroke
.58403 .08445 L
.59337 .0873 L
.60271 .09066 L
.61204 .0922 L
.62138 .11295 L
.63072 .10031 L
.64006 .10361 L
.64939 .1076 L
.65873 .11123 L
.66807 .11485 L
.6774 .11789 L
.68674 .08168 L
.69608 .13538 L
.70542 .1893 L
.71475 .19337 L
.72409 .18884 L
.73343 .22509 L
.74276 .24322 L
.7521 .23868 L
.76144 .24779 L
.77077 .30076 L
.78011 .1115 L
.78945 .16868 L
.79879 .16311 L
.80812 .2124 L
.81746 .26587 L
.8268 .31435 L
.83613 .02573 L
.84547 .07525 L
.85481 .07058 L
.86415 .11046 L
.87348 .10185 L
.88282 .1091 L
.89216 .11499 L
.90149 .10955 L
.91083 .10647 L
.92017 .10774 L
.92951 .1168 L
.93884 .11997 L
.94818 .12496 L
.95752 .12858 L
.96685 .1322 L
.97619 .42627 L
Mfstroke
.0001 w
.03315 .43896 -3.75 0 Mabsadd m
.03315 .43896 0 5 Mabsadd L
.03315 .43896 3.75 0 Mabsadd L
.03315 .43896 0 -5 Mabsadd L
.03315 .43896 -3.75 0 Mabsadd L closepath F
.04248 .91938 -3.75 0 Mabsadd m
.04248 .91938 0 5 Mabsadd L
.04248 .91938 3.75 0 Mabsadd L
.04248 .91938 0 -5 Mabsadd L
.04248 .91938 -3.75 0 Mabsadd L closepath F
.05182 .07706 -3.75 0 Mabsadd m
.05182 .07706 0 5 Mabsadd L
.05182 .07706 3.75 0 Mabsadd L
.05182 .07706 0 -5 Mabsadd L
.05182 .07706 -3.75 0 Mabsadd L closepath F
.06116 .25201 -3.75 0 Mabsadd m
.06116 .25201 0 5 Mabsadd L
.06116 .25201 3.75 0 Mabsadd L
.06116 .25201 0 -5 Mabsadd L
.06116 .25201 -3.75 0 Mabsadd L closepath F
.07049 .20724 -3.75 0 Mabsadd m
.07049 .20724 0 5 Mabsadd L
.07049 .20724 3.75 0 Mabsadd L
.07049 .20724 0 -5 Mabsadd L
.07049 .20724 -3.75 0 Mabsadd L closepath F
.07983 .33664 -3.75 0 Mabsadd m
.07983 .33664 0 5 Mabsadd L
.07983 .33664 3.75 0 Mabsadd L
.07983 .33664 0 -5 Mabsadd L
.07983 .33664 -3.75 0 Mabsadd L closepath F
.08917 .43456 -3.75 0 Mabsadd m
.08917 .43456 0 5 Mabsadd L
.08917 .43456 3.75 0 Mabsadd L
.08917 .43456 0 -5 Mabsadd L
.08917 .43456 -3.75 0 Mabsadd L closepath F
.09851 .43982 -3.75 0 Mabsadd m
.09851 .43982 0 5 Mabsadd L
.09851 .43982 3.75 0 Mabsadd L
.09851 .43982 0 -5 Mabsadd L
.09851 .43982 -3.75 0 Mabsadd L closepath F
.10784 .60615 -3.75 0 Mabsadd m
.10784 .60615 0 5 Mabsadd L
.10784 .60615 3.75 0 Mabsadd L
.10784 .60615 0 -5 Mabsadd L
.10784 .60615 -3.75 0 Mabsadd L closepath F
.11718 .78721 -3.75 0 Mabsadd m
.11718 .78721 0 5 Mabsadd L
.11718 .78721 3.75 0 Mabsadd L
.11718 .78721 0 -5 Mabsadd L
.11718 .78721 -3.75 0 Mabsadd L closepath F
.12652 .06913 -3.75 0 Mabsadd m
.12652 .06913 0 5 Mabsadd L
.12652 .06913 3.75 0 Mabsadd L
.12652 .06913 0 -5 Mabsadd L
.12652 .06913 -3.75 0 Mabsadd L closepath F
.13585 .17874 -3.75 0 Mabsadd m
.13585 .17874 0 5 Mabsadd L
.13585 .17874 3.75 0 Mabsadd L
.13585 .17874 0 -5 Mabsadd L
.13585 .17874 -3.75 0 Mabsadd L closepath F
.14519 .10611 -3.75 0 Mabsadd m
.14519 .10611 0 5 Mabsadd L
.14519 .10611 3.75 0 Mabsadd L
.14519 .10611 0 -5 Mabsadd L
.14519 .10611 -3.75 0 Mabsadd L closepath F
.15453 .20085 -3.75 0 Mabsadd m
.15453 .20085 0 5 Mabsadd L
.15453 .20085 3.75 0 Mabsadd L
.15453 .20085 0 -5 Mabsadd L
.15453 .20085 -3.75 0 Mabsadd L closepath F
.16387 .30289 -3.75 0 Mabsadd m
.16387 .30289 0 5 Mabsadd L
.16387 .30289 3.75 0 Mabsadd L
.16387 .30289 0 -5 Mabsadd L
.16387 .30289 -3.75 0 Mabsadd L closepath F
.1732 .29741 -3.75 0 Mabsadd m
.1732 .29741 0 5 Mabsadd L
.1732 .29741 3.75 0 Mabsadd L
.1732 .29741 0 -5 Mabsadd L
.1732 .29741 -3.75 0 Mabsadd L closepath F
.18254 .41136 -3.75 0 Mabsadd m
.18254 .41136 0 5 Mabsadd L
.18254 .41136 3.75 0 Mabsadd L
.18254 .41136 0 -5 Mabsadd L
.18254 .41136 -3.75 0 Mabsadd L closepath F
.19188 .53338 -3.75 0 Mabsadd m
.19188 .53338 0 5 Mabsadd L
.19188 .53338 3.75 0 Mabsadd L
.19188 .53338 0 -5 Mabsadd L
.19188 .53338 -3.75 0 Mabsadd L closepath F
.20121 .03424 -3.75 0 Mabsadd m
.20121 .03424 0 5 Mabsadd L
.20121 .03424 3.75 0 Mabsadd L
.20121 .03424 0 -5 Mabsadd L
.20121 .03424 -3.75 0 Mabsadd L closepath F
.21055 .11168 -3.75 0 Mabsadd m
.21055 .11168 0 5 Mabsadd L
.21055 .11168 3.75 0 Mabsadd L
.21055 .11168 0 -5 Mabsadd L
.21055 .11168 -3.75 0 Mabsadd L closepath F
.21989 .13039 -3.75 0 Mabsadd m
.21989 .13039 0 5 Mabsadd L
.21989 .13039 3.75 0 Mabsadd L
.21989 .13039 0 -5 Mabsadd L
.21989 .13039 -3.75 0 Mabsadd L closepath F
.22923 .14263 -3.75 0 Mabsadd m
.22923 .14263 0 5 Mabsadd L
.22923 .14263 3.75 0 Mabsadd L
.22923 .14263 0 -5 Mabsadd L
.22923 .14263 -3.75 0 Mabsadd L closepath F
.23856 .139 -3.75 0 Mabsadd m
.23856 .139 0 5 Mabsadd L
.23856 .139 3.75 0 Mabsadd L
.23856 .139 0 -5 Mabsadd L
.23856 .139 -3.75 0 Mabsadd L closepath F
.2479 .14022 -3.75 0 Mabsadd m
.2479 .14022 0 5 Mabsadd L
.2479 .14022 3.75 0 Mabsadd L
.2479 .14022 0 -5 Mabsadd L
.2479 .14022 -3.75 0 Mabsadd L closepath F
.25724 .16954 -3.75 0 Mabsadd m
.25724 .16954 0 5 Mabsadd L
.25724 .16954 3.75 0 Mabsadd L
.25724 .16954 0 -5 Mabsadd L
.25724 .16954 -3.75 0 Mabsadd L closepath F
.26657 .18853 -3.75 0 Mabsadd m
.26657 .18853 0 5 Mabsadd L
.26657 .18853 3.75 0 Mabsadd L
.26657 .18853 0 -5 Mabsadd L
.26657 .18853 -3.75 0 Mabsadd L closepath F
.27591 .18884 -3.75 0 Mabsadd m
.27591 .18884 0 5 Mabsadd L
.27591 .18884 3.75 0 Mabsadd L
.27591 .18884 0 -5 Mabsadd L
.27591 .18884 -3.75 0 Mabsadd L closepath F
.28525 .17829 -3.75 0 Mabsadd m
.28525 .17829 0 5 Mabsadd L
.28525 .17829 3.75 0 Mabsadd L
.28525 .17829 0 -5 Mabsadd L
.28525 .17829 -3.75 0 Mabsadd L closepath F
.29458 .18223 -3.75 0 Mabsadd m
.29458 .18223 0 5 Mabsadd L
.29458 .18223 3.75 0 Mabsadd L
.29458 .18223 0 -5 Mabsadd L
.29458 .18223 -3.75 0 Mabsadd L closepath F
.30392 .25518 -3.75 0 Mabsadd m
.30392 .25518 0 5 Mabsadd L
.30392 .25518 3.75 0 Mabsadd L
.30392 .25518 0 -5 Mabsadd L
.30392 .25518 -3.75 0 Mabsadd L closepath F
.31326 .10674 -3.75 0 Mabsadd m
.31326 .10674 0 5 Mabsadd L
.31326 .10674 3.75 0 Mabsadd L
.31326 .10674 0 -5 Mabsadd L
.31326 .10674 -3.75 0 Mabsadd L closepath F
.3226 .18979 -3.75 0 Mabsadd m
.3226 .18979 0 5 Mabsadd L
.3226 .18979 3.75 0 Mabsadd L
.3226 .18979 0 -5 Mabsadd L
.3226 .18979 -3.75 0 Mabsadd L closepath F
.33193 .27357 -3.75 0 Mabsadd m
.33193 .27357 0 5 Mabsadd L
.33193 .27357 3.75 0 Mabsadd L
.33193 .27357 0 -5 Mabsadd L
.33193 .27357 -3.75 0 Mabsadd L closepath F
.34127 .27081 -3.75 0 Mabsadd m
.34127 .27081 0 5 Mabsadd L
.34127 .27081 3.75 0 Mabsadd L
.34127 .27081 0 -5 Mabsadd L
.34127 .27081 -3.75 0 Mabsadd L closepath F
.35061 .36098 -3.75 0 Mabsadd m
.35061 .36098 0 5 Mabsadd L
.35061 .36098 3.75 0 Mabsadd L
.35061 .36098 0 -5 Mabsadd L
.35061 .36098 -3.75 0 Mabsadd L closepath F
.35994 .45649 -3.75 0 Mabsadd m
.35994 .45649 0 5 Mabsadd L
.35994 .45649 3.75 0 Mabsadd L
.35994 .45649 0 -5 Mabsadd L
.35994 .45649 -3.75 0 Mabsadd L closepath F
.36928 .02708 -3.75 0 Mabsadd m
.36928 .02708 0 5 Mabsadd L
.36928 .02708 3.75 0 Mabsadd L
.36928 .02708 0 -5 Mabsadd L
.36928 .02708 -3.75 0 Mabsadd L closepath F
.37862 .09346 -3.75 0 Mabsadd m
.37862 .09346 0 5 Mabsadd L
.37862 .09346 3.75 0 Mabsadd L
.37862 .09346 0 -5 Mabsadd L
.37862 .09346 -3.75 0 Mabsadd L closepath F
.38796 .1236 -3.75 0 Mabsadd m
.38796 .1236 0 5 Mabsadd L
.38796 .1236 3.75 0 Mabsadd L
.38796 .1236 0 -5 Mabsadd L
.38796 .1236 -3.75 0 Mabsadd L closepath F
.39729 .14353 -3.75 0 Mabsadd m
.39729 .14353 0 5 Mabsadd L
.39729 .14353 3.75 0 Mabsadd L
.39729 .14353 0 -5 Mabsadd L
.39729 .14353 -3.75 0 Mabsadd L closepath F
.40663 .14534 -3.75 0 Mabsadd m
.40663 .14534 0 5 Mabsadd L
.40663 .14534 3.75 0 Mabsadd L
.40663 .14534 0 -5 Mabsadd L
.40663 .14534 -3.75 0 Mabsadd L closepath F
.41597 .15486 -3.75 0 Mabsadd m
.41597 .15486 0 5 Mabsadd L
.41597 .15486 3.75 0 Mabsadd L
.41597 .15486 0 -5 Mabsadd L
.41597 .15486 -3.75 0 Mabsadd L closepath F
.4253 .16256 -3.75 0 Mabsadd m
.4253 .16256 0 5 Mabsadd L
.4253 .16256 3.75 0 Mabsadd L
.4253 .16256 0 -5 Mabsadd L
.4253 .16256 -3.75 0 Mabsadd L closepath F
.43464 .16664 -3.75 0 Mabsadd m
.43464 .16664 0 5 Mabsadd L
.43464 .16664 3.75 0 Mabsadd L
.43464 .16664 0 -5 Mabsadd L
.43464 .16664 -3.75 0 Mabsadd L closepath F
.44398 .17072 -3.75 0 Mabsadd m
.44398 .17072 0 5 Mabsadd L
.44398 .17072 3.75 0 Mabsadd L
.44398 .17072 0 -5 Mabsadd L
.44398 .17072 -3.75 0 Mabsadd L closepath F
.45331 .20923 -3.75 0 Mabsadd m
.45331 .20923 0 5 Mabsadd L
.45331 .20923 3.75 0 Mabsadd L
.45331 .20923 0 -5 Mabsadd L
.45331 .20923 -3.75 0 Mabsadd L closepath F
.46265 .1757 -3.75 0 Mabsadd m
.46265 .1757 0 5 Mabsadd L
.46265 .1757 3.75 0 Mabsadd L
.46265 .1757 0 -5 Mabsadd L
.46265 .1757 -3.75 0 Mabsadd L closepath F
.47199 .24167 -3.75 0 Mabsadd m
.47199 .24167 0 5 Mabsadd L
.47199 .24167 3.75 0 Mabsadd L
.47199 .24167 0 -5 Mabsadd L
.47199 .24167 -3.75 0 Mabsadd L closepath F
.48133 .09745 -3.75 0 Mabsadd m
.48133 .09745 0 5 Mabsadd L
.48133 .09745 3.75 0 Mabsadd L
.48133 .09745 0 -5 Mabsadd L
.48133 .09745 -3.75 0 Mabsadd L closepath F
.49066 .16555 -3.75 0 Mabsadd m
.49066 .16555 0 5 Mabsadd L
.49066 .16555 3.75 0 Mabsadd L
.49066 .16555 0 -5 Mabsadd L
.49066 .16555 -3.75 0 Mabsadd L closepath F
.5 .22224 -3.75 0 Mabsadd m
.5 .22224 0 5 Mabsadd L
.5 .22224 3.75 0 Mabsadd L
.5 .22224 0 -5 Mabsadd L
.5 .22224 -3.75 0 Mabsadd L closepath F
.50934 .23832 -3.75 0 Mabsadd m
.50934 .23832 0 5 Mabsadd L
.50934 .23832 3.75 0 Mabsadd L
.50934 .23832 0 -5 Mabsadd L
.50934 .23832 -3.75 0 Mabsadd L closepath F
.51867 .30139 -3.75 0 Mabsadd m
.51867 .30139 0 5 Mabsadd L
.51867 .30139 3.75 0 Mabsadd L
.51867 .30139 0 -5 Mabsadd L
.51867 .30139 -3.75 0 Mabsadd L closepath F
.52801 .3748 -3.75 0 Mabsadd m
.52801 .3748 0 5 Mabsadd L
.52801 .3748 3.75 0 Mabsadd L
.52801 .3748 0 -5 Mabsadd L
.52801 .3748 -3.75 0 Mabsadd L closepath F
.53735 .01472 -3.75 0 Mabsadd m
.53735 .01472 0 5 Mabsadd L
.53735 .01472 3.75 0 Mabsadd L
.53735 .01472 0 -5 Mabsadd L
.53735 .01472 -3.75 0 Mabsadd L closepath F
.54669 .0723 -3.75 0 Mabsadd m
.54669 .0723 0 5 Mabsadd L
.54669 .0723 3.75 0 Mabsadd L
.54669 .0723 0 -5 Mabsadd L
.54669 .0723 -3.75 0 Mabsadd L closepath F
.55602 .0883 -3.75 0 Mabsadd m
.55602 .0883 0 5 Mabsadd L
.55602 .0883 3.75 0 Mabsadd L
.55602 .0883 0 -5 Mabsadd L
.55602 .0883 -3.75 0 Mabsadd L closepath F
.56536 .08345 -3.75 0 Mabsadd m
.56536 .08345 0 5 Mabsadd L
.56536 .08345 3.75 0 Mabsadd L
.56536 .08345 0 -5 Mabsadd L
.56536 .08345 -3.75 0 Mabsadd L closepath F
.5747 .0815 -3.75 0 Mabsadd m
.5747 .0815 0 5 Mabsadd L
.5747 .0815 3.75 0 Mabsadd L
.5747 .0815 0 -5 Mabsadd L
.5747 .0815 -3.75 0 Mabsadd L closepath F
.58403 .08445 -3.75 0 Mabsadd m
.58403 .08445 0 5 Mabsadd L
.58403 .08445 3.75 0 Mabsadd L
.58403 .08445 0 -5 Mabsadd L
.58403 .08445 -3.75 0 Mabsadd L closepath F
.59337 .0873 -3.75 0 Mabsadd m
.59337 .0873 0 5 Mabsadd L
.59337 .0873 3.75 0 Mabsadd L
.59337 .0873 0 -5 Mabsadd L
.59337 .0873 -3.75 0 Mabsadd L closepath F
.60271 .09066 -3.75 0 Mabsadd m
.60271 .09066 0 5 Mabsadd L
.60271 .09066 3.75 0 Mabsadd L
.60271 .09066 0 -5 Mabsadd L
.60271 .09066 -3.75 0 Mabsadd L closepath F
.61204 .0922 -3.75 0 Mabsadd m
.61204 .0922 0 5 Mabsadd L
.61204 .0922 3.75 0 Mabsadd L
.61204 .0922 0 -5 Mabsadd L
.61204 .0922 -3.75 0 Mabsadd L closepath F
.62138 .11295 -3.75 0 Mabsadd m
.62138 .11295 0 5 Mabsadd L
.62138 .11295 3.75 0 Mabsadd L
.62138 .11295 0 -5 Mabsadd L
.62138 .11295 -3.75 0 Mabsadd L closepath F
.63072 .10031 -3.75 0 Mabsadd m
.63072 .10031 0 5 Mabsadd L
.63072 .10031 3.75 0 Mabsadd L
.63072 .10031 0 -5 Mabsadd L
.63072 .10031 -3.75 0 Mabsadd L closepath F
.64006 .10361 -3.75 0 Mabsadd m
.64006 .10361 0 5 Mabsadd L
.64006 .10361 3.75 0 Mabsadd L
.64006 .10361 0 -5 Mabsadd L
.64006 .10361 -3.75 0 Mabsadd L closepath F
.64939 .1076 -3.75 0 Mabsadd m
.64939 .1076 0 5 Mabsadd L
.64939 .1076 3.75 0 Mabsadd L
.64939 .1076 0 -5 Mabsadd L
.64939 .1076 -3.75 0 Mabsadd L closepath F
.65873 .11123 -3.75 0 Mabsadd m
.65873 .11123 0 5 Mabsadd L
.65873 .11123 3.75 0 Mabsadd L
.65873 .11123 0 -5 Mabsadd L
.65873 .11123 -3.75 0 Mabsadd L closepath F
.66807 .11485 -3.75 0 Mabsadd m
.66807 .11485 0 5 Mabsadd L
.66807 .11485 3.75 0 Mabsadd L
.66807 .11485 0 -5 Mabsadd L
.66807 .11485 -3.75 0 Mabsadd L closepath F
.6774 .11789 -3.75 0 Mabsadd m
.6774 .11789 0 5 Mabsadd L
.6774 .11789 3.75 0 Mabsadd L
.6774 .11789 0 -5 Mabsadd L
.6774 .11789 -3.75 0 Mabsadd L closepath F
.68674 .08168 -3.75 0 Mabsadd m
.68674 .08168 0 5 Mabsadd L
.68674 .08168 3.75 0 Mabsadd L
.68674 .08168 0 -5 Mabsadd L
.68674 .08168 -3.75 0 Mabsadd L closepath F
.69608 .13538 -3.75 0 Mabsadd m
.69608 .13538 0 5 Mabsadd L
.69608 .13538 3.75 0 Mabsadd L
.69608 .13538 0 -5 Mabsadd L
.69608 .13538 -3.75 0 Mabsadd L closepath F
.70542 .1893 -3.75 0 Mabsadd m
.70542 .1893 0 5 Mabsadd L
.70542 .1893 3.75 0 Mabsadd L
.70542 .1893 0 -5 Mabsadd L
.70542 .1893 -3.75 0 Mabsadd L closepath F
.71475 .19337 -3.75 0 Mabsadd m
.71475 .19337 0 5 Mabsadd L
.71475 .19337 3.75 0 Mabsadd L
.71475 .19337 0 -5 Mabsadd L
.71475 .19337 -3.75 0 Mabsadd L closepath F
.72409 .18884 -3.75 0 Mabsadd m
.72409 .18884 0 5 Mabsadd L
.72409 .18884 3.75 0 Mabsadd L
.72409 .18884 0 -5 Mabsadd L
.72409 .18884 -3.75 0 Mabsadd L closepath F
.73343 .22509 -3.75 0 Mabsadd m
.73343 .22509 0 5 Mabsadd L
.73343 .22509 3.75 0 Mabsadd L
.73343 .22509 0 -5 Mabsadd L
.73343 .22509 -3.75 0 Mabsadd L closepath F
.74276 .24322 -3.75 0 Mabsadd m
.74276 .24322 0 5 Mabsadd L
.74276 .24322 3.75 0 Mabsadd L
.74276 .24322 0 -5 Mabsadd L
.74276 .24322 -3.75 0 Mabsadd L closepath F
.7521 .23868 -3.75 0 Mabsadd m
.7521 .23868 0 5 Mabsadd L
.7521 .23868 3.75 0 Mabsadd L
.7521 .23868 0 -5 Mabsadd L
.7521 .23868 -3.75 0 Mabsadd L closepath F
.76144 .24779 -3.75 0 Mabsadd m
.76144 .24779 0 5 Mabsadd L
.76144 .24779 3.75 0 Mabsadd L
.76144 .24779 0 -5 Mabsadd L
.76144 .24779 -3.75 0 Mabsadd L closepath F
.77077 .30076 -3.75 0 Mabsadd m
.77077 .30076 0 5 Mabsadd L
.77077 .30076 3.75 0 Mabsadd L
.77077 .30076 0 -5 Mabsadd L
.77077 .30076 -3.75 0 Mabsadd L closepath F
.78011 .1115 -3.75 0 Mabsadd m
.78011 .1115 0 5 Mabsadd L
.78011 .1115 3.75 0 Mabsadd L
.78011 .1115 0 -5 Mabsadd L
.78011 .1115 -3.75 0 Mabsadd L closepath F
.78945 .16868 -3.75 0 Mabsadd m
.78945 .16868 0 5 Mabsadd L
.78945 .16868 3.75 0 Mabsadd L
.78945 .16868 0 -5 Mabsadd L
.78945 .16868 -3.75 0 Mabsadd L closepath F
.79879 .16311 -3.75 0 Mabsadd m
.79879 .16311 0 5 Mabsadd L
.79879 .16311 3.75 0 Mabsadd L
.79879 .16311 0 -5 Mabsadd L
.79879 .16311 -3.75 0 Mabsadd L closepath F
.80812 .2124 -3.75 0 Mabsadd m
.80812 .2124 0 5 Mabsadd L
.80812 .2124 3.75 0 Mabsadd L
.80812 .2124 0 -5 Mabsadd L
.80812 .2124 -3.75 0 Mabsadd L closepath F
.81746 .26587 -3.75 0 Mabsadd m
.81746 .26587 0 5 Mabsadd L
.81746 .26587 3.75 0 Mabsadd L
.81746 .26587 0 -5 Mabsadd L
.81746 .26587 -3.75 0 Mabsadd L closepath F
.8268 .31435 -3.75 0 Mabsadd m
.8268 .31435 0 5 Mabsadd L
.8268 .31435 3.75 0 Mabsadd L
.8268 .31435 0 -5 Mabsadd L
.8268 .31435 -3.75 0 Mabsadd L closepath F
.83613 .02573 -3.75 0 Mabsadd m
.83613 .02573 0 5 Mabsadd L
.83613 .02573 3.75 0 Mabsadd L
.83613 .02573 0 -5 Mabsadd L
.83613 .02573 -3.75 0 Mabsadd L closepath F
.84547 .07525 -3.75 0 Mabsadd m
.84547 .07525 0 5 Mabsadd L
.84547 .07525 3.75 0 Mabsadd L
.84547 .07525 0 -5 Mabsadd L
.84547 .07525 -3.75 0 Mabsadd L closepath F
.85481 .07058 -3.75 0 Mabsadd m
.85481 .07058 0 5 Mabsadd L
.85481 .07058 3.75 0 Mabsadd L
.85481 .07058 0 -5 Mabsadd L
.85481 .07058 -3.75 0 Mabsadd L closepath F
.86415 .11046 -3.75 0 Mabsadd m
.86415 .11046 0 5 Mabsadd L
.86415 .11046 3.75 0 Mabsadd L
.86415 .11046 0 -5 Mabsadd L
.86415 .11046 -3.75 0 Mabsadd L closepath F
.87348 .10185 -3.75 0 Mabsadd m
.87348 .10185 0 5 Mabsadd L
.87348 .10185 3.75 0 Mabsadd L
.87348 .10185 0 -5 Mabsadd L
.87348 .10185 -3.75 0 Mabsadd L closepath F
.88282 .1091 -3.75 0 Mabsadd m
.88282 .1091 0 5 Mabsadd L
.88282 .1091 3.75 0 Mabsadd L
.88282 .1091 0 -5 Mabsadd L
.88282 .1091 -3.75 0 Mabsadd L closepath F
.89216 .11499 -3.75 0 Mabsadd m
.89216 .11499 0 5 Mabsadd L
.89216 .11499 3.75 0 Mabsadd L
.89216 .11499 0 -5 Mabsadd L
.89216 .11499 -3.75 0 Mabsadd L closepath F
.90149 .10955 -3.75 0 Mabsadd m
.90149 .10955 0 5 Mabsadd L
.90149 .10955 3.75 0 Mabsadd L
.90149 .10955 0 -5 Mabsadd L
.90149 .10955 -3.75 0 Mabsadd L closepath F
.91083 .10647 -3.75 0 Mabsadd m
.91083 .10647 0 5 Mabsadd L
.91083 .10647 3.75 0 Mabsadd L
.91083 .10647 0 -5 Mabsadd L
.91083 .10647 -3.75 0 Mabsadd L closepath F
.92017 .10774 -3.75 0 Mabsadd m
.92017 .10774 0 5 Mabsadd L
.92017 .10774 3.75 0 Mabsadd L
.92017 .10774 0 -5 Mabsadd L
.92017 .10774 -3.75 0 Mabsadd L closepath F
.92951 .1168 -3.75 0 Mabsadd m
.92951 .1168 0 5 Mabsadd L
.92951 .1168 3.75 0 Mabsadd L
.92951 .1168 0 -5 Mabsadd L
.92951 .1168 -3.75 0 Mabsadd L closepath F
.93884 .11997 -3.75 0 Mabsadd m
.93884 .11997 0 5 Mabsadd L
.93884 .11997 3.75 0 Mabsadd L
.93884 .11997 0 -5 Mabsadd L
.93884 .11997 -3.75 0 Mabsadd L closepath F
.94818 .12496 -3.75 0 Mabsadd m
.94818 .12496 0 5 Mabsadd L
.94818 .12496 3.75 0 Mabsadd L
.94818 .12496 0 -5 Mabsadd L
.94818 .12496 -3.75 0 Mabsadd L closepath F
.95752 .12858 -3.75 0 Mabsadd m
.95752 .12858 0 5 Mabsadd L
.95752 .12858 3.75 0 Mabsadd L
.95752 .12858 0 -5 Mabsadd L
.95752 .12858 -3.75 0 Mabsadd L closepath F
.96685 .1322 -3.75 0 Mabsadd m
.96685 .1322 0 5 Mabsadd L
.96685 .1322 3.75 0 Mabsadd L
.96685 .1322 0 -5 Mabsadd L
.96685 .1322 -3.75 0 Mabsadd L closepath F
.97619 .42627 -3.75 0 Mabsadd m
.97619 .42627 0 5 Mabsadd L
.97619 .42627 3.75 0 Mabsadd L
.97619 .42627 0 -5 Mabsadd L
.97619 .42627 -3.75 0 Mabsadd L closepath F
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[31]:=",
  ImageSize->{400, 247.188},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006@0000mb000`400?l00000o`00003ooooooonA
ooooo`00oooooonAooooo`00oooooonAooooo`00oooooonAooooo`00oooooonAooooo`00GOooool5
o`0000?ooooo0_l0000oooooo`?o00000oooool2o`0003kooooo0ol00004ooooo`;o0000?_ooool3
o`0000Cooooo0_l0000jooooo`?o00001?ooool2o`0000Cooooo0_l0000;ooooo`00G_ooool01?l0
003oooooooooool00002ooooo`04o`000?ooooooooooo`0003oooooo00Go0000oooooooooooooooo
o`000002ooooo`03o`000?oooooooooo03[ooooo00Go0000ooooooooooooooooo`000002ooooo`04
o`000?ooooooooooo`0003cooooo00Go0000ooooooooooooooooo`000002ooooo`04o`000?oooooo
ooooo`0003[ooooo00?o0000ooooooooool00_ooool01?l0003oooooooooool00002ooooo`04o`00
0?ooooooooooo`0000[ooooo001Oooooo`03o`000?oooooooooo00;ooooo00Co0000oooooooooooo
0000??ooool5o`0000;ooooo00Co0000oooooooooooo0000??ooool01Ol0003ooooooooooooooooo
000000;ooooo00Co0000oooooooooooo0000??ooool01Ol0003ooooooooooooooooo000000;ooooo
00Co0000oooooooooooo0000>_ooool00ol0003oooooooooo`02ooooo`04o`000?ooooooooooo`00
00;ooooo00Co0000oooooooooooo00002_ooool001cooooo00?o0000ooooooooool0@Oooool01Ol0
003ooooooooooooooooo000000;ooooo00?o0000ooooooooool0>_ooool01?l0003oooooooooool0
0003ooooo`04o`000?ooooooooooo`0003cooooo1?l00003ooooo`04o`000?ooooooooooo`0003go
oooo0ol00003ooooo`04o`000?ooooooooooo`0003[ooooo00?o0000ooooooooool00_ooool01?l0
003oooooooooool00002ooooo`04o`000?ooooooooooo`0000[ooooo000Looooo`?o0000?_ooool0
1Ol0003ooooooooooooooooo000000;ooooo00Co0000oooooooooooo0000?Oooool00ol0003ooooo
o`000003ooooo`04o`000?ooooooooooo`0003cooooo00?o0000ooooooooool01?ooool01?l0003o
ooooooooool0000looooo`05o`000?ooooooooooooooool000000_ooool01?l0003oooooooooool0
000jooooo`03o`000?oooooooooo00;ooooo00Co0000oooooooooooo00000_ooool01?l0003ooooo
ooooool0000:ooooo`007?ooool00ol0003oooooooooo`0nooooo`05o`000?ooooooooooooooool0
00000_ooool01?l0003oooooooooool0000nooooo`;o00000oooool01?l0003oooooooooool0000m
ooooo`03o`000?oooooooooo00?ooooo00Co0000oooooooooooo0000??ooool01Ol0003ooooooooo
oooooooo000000;ooooo00Co0000oooooooooooo0000>Oooool2o`0000Cooooo00Co0000oooooooo
oooo00000_ooool01?l0003oooooooooool0000:ooooo`007?ooool00ol0003oooooooooo`0ooooo
o`?o00001?ooool2o`00043ooooo00?o0000ooooooooool00_ooool2o`00037ooooo00?o0000oooo
ooooool02oooool2o`0000Cooooo0_l0000nooooo`?o00001?ooool2o`0003_ooooo00?o0000oooo
ooooool00oooool2o`0000Cooooo0_l0000;ooooo`007?ooool00ol0003oooooooooo`2oooooo`?o
0000[oooool001cooooo00?o0000ooooooooool0__ooool5o`000:kooooo000Looooo`03o`000?oo
oooooooo0;gooooo1ol0002]ooooo`007?ooool00ol0003oooooooooo`20ooooo`03o`000?oooooo
oooo03Wooooo2?l0001]ooooo`03o`000?oooooooooo03gooooo000Looooo`03o`000?oooooooooo
07oooooo0ol0000kooooo`Oo0000K?ooool3o`0003kooooo000Looooo`03o`000?oooooooooo07ko
oooo1Ol0000kooooo`Go0000K?ooool5o`0003gooooo000Coooooooo0000O_l0000001cooooo00?o
0000ooooooooool03oooool00ol0003oooooooooo`0?ooooo`03o`000?oooooooooo00kooooo00?o
0000ooooooooool02oooool3o`000003ooooool0003ooooo013ooooo00?o0000ooooooooool03_oo
ool00ol0003oooooooooo`0?ooooo`04o`000?ooooooooooooooo`Oo00001oooool00ol0003ooooo
ooooo`0?ooooo`03o`000?oooooooooo00kooooo00?o0000ooooooooool03oooool2o`00013ooooo
00?o0000ooooooooool03_ooool00ol0003oooooooooo`0?ooooo`03o`000?oooooooooo00oooooo
00?o0000ooooooooool03oooool00ol0003oooooooooo`0>ooooo`04o`000?ooooooooooooooo`Oo
00001oooool00ol0003oooooooooo`0?ooooo`03o`000?oooooooooo00kooooo00?o0000oooooooo
ool03oooool001cooooo00?o0000ooooooooool0?oooool4o`000003ooooool0003ooooo03Sooooo
1_l00007ooooo`03o`000?oooooooooo03;ooooo0_l0000@ooooo`03o`000?oooooooooo04Cooooo
00?o0000ooooooooool04oooool6o`0002[ooooo00?o0000ooooooooool03oooool001cooooo00?o
0000ooooooooool0?_ooool6o`0003_ooooo1?l0000mooooo`;o0000K_ooool4o`0003gooooo000L
ooooo`03o`000?oooooooooo03gooooo1ol0000kooooo`?o0000?_ooool2o`0006kooooo0ol0000n
ooooo`007?ooool00ol0003oooooooooo`0nooooo`Ko0000??ooool2o`0003kooooo00?o0000oooo
ool00000K_ooool2o`0003kooooo000Looooo`03o`000?oooooooooo03oooooo1?l0000mooooo`;o
0000?_ooool00ol0003oooooo`00001^ooooo`;o0000?_ooool001cooooo00?o0000ooooooooool0
@?ooool2o`0003kooooo0_l0000nooooo`03o`000?oooooo000006kooooo0_l0000nooooo`007?oo
ool00ol0003oooooooooo`11ooooo`03o`000?oooooooooo03cooooo0_l0000nooooo`03o`000?oo
oooo000006kooooo00?o0000ooooool00000?Oooool001cooooo0ol00011ooooo`;o0000?Oooool2
o`0003kooooo00?o0000ooooool00000K_ooool00ol0003oooooo`00000mooooo`007?ooool00ol0
003oooooooooo`11ooooo`;o0000?Oooool2o`0003kooooo00?o0000ooooool00000K_ooool00ol0
003oooooo`00000mooooo`007?ooool00ol0003oooooooooo`11ooooo`;o0000?Oooool00ol0003o
ooooo`00000mooooo`04o`000?ooooooooooo`0006gooooo00?o0000ooooool00000?Oooool001co
oooo00?o0000ooooooooool0@Oooool2o`0003gooooo00?o0000ooooool00000?Oooool01?l0003o
ooooooooool0001]ooooo`03o`000?oooooo000003gooooo000Looooo`03o`000?oooooooooo02Co
oooo00?o0000ooooooooool06_ooool2o`0003gooooo00?o0000ooooool00000?Oooool01?l0003o
ooooooooool0001]ooooo`04o`000?ooooooooooo`0003cooooo000Looooo`03o`000?oooooooooo
02?ooooo0ol0000Kooooo`;o0000?Oooool00ol0003oooooo`00000looooo`05o`000?oooooooooo
ooooool00000KOooool01?l0003oooooooooool00003ooooo`03o`000?oooooooooo03Kooooo000L
ooooo`03o`000?oooooooooo02;ooooo1Ol0000Jooooo`;o0000?Oooool00ol0003oooooo`00000l
ooooo`04o`000?ooooooooooooooo`;o0000K?ooool01?l0003oooooooooool00002ooooo`?o0000
=oooool001cooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`0Fooooo`Oo00006Ooo
ool2o`0003gooooo00?o0000ooooool00000??ooool01?l0003oooooooooooooool3o`0006_ooooo
00?o0000ooooooooool01ol0000fooooo`007?ooool3o`0000Oooooo0ol0000Fooooo`So00006Ooo
ool2o`0003gooooo00Co0000oooooooooooo0000>oooool00ol0003oooooooooo`04o`0006_ooooo
00?o0000ooooooooool02?l0000eooooo`007?ooool00ol0003oooooooooo`06ooooo`Go00005_oo
ool7o`0001Wooooo0_l0000mooooo`04o`000?ooooooooooo`0003_ooooo00?o0000ooooool00000
1Ol00007ooooo`03o`000?oooooooooo02Sooooo00?o0000ooooooooool0=Oooool00ol0003ooooo
o`000008o`0003Gooooo000Looooo`03o`000?oooooooooo00Gooooo1ol0000Fooooo`Go00006_oo
ool00ol0003oooooo`00000looooo`04o`000?ooooooooooo`0003_ooooo2?l00004ooooo`03o`00
0?oooooo000000;o00000_ooool00ol0003oooooooooo`0Sooooo`?o0000=Oooool00ol0003ooooo
o`000009o`0003Gooooo000Looooo`03o`000?oooooooooo00Cooooo2?l0000Gooooo`?o00006ooo
ool00ol0003oooooo`00000looooo`04o`000?ooooooooooo`0003_ooooo00?o0000ooooool00000
1Ol00003ooooo`[o000000?oooooo`000?ooool08?ooool4o`0003Gooooo2ol0000fooooo`007?oo
ool00ol0003oooooooooo`05ooooo`Oo00006?ooool00ol0003oooooooooo`0Jooooo`03o`000?oo
oooo000003cooooo00Co0000oooooooooooo0000>oooool00ol0003oooooooooo`04o`000003oooo
ool0003ooooo00ko00007oooool6o`0003Cooooo00?o0000ooooool000001ol0000gooooo`007?oo
ool00ol0003oooooooooo`06ooooo`Go00006Oooool2o`0001_ooooo00?o0000ooooool00000??oo
ool01?l0003oooooooooool0000kooooo`04o`000?ooooooooooooooo`;o000000?oooooo`000?l0
00004?l000001Ooooooo0000oooooooooooo000001Sooooo1ol0000dooooo`03o`000?oooooooooo
00Oo0000=oooool001cooooo00?o0000ooooooooool01oooool3o`0001[ooooo0_l0000Kooooo`03
o`000?oooooo000003cooooo00?o0000ooooooooool00_l0000jooooo`03o`000?oooooooooo00;o
oooo6_l0000Hooooo`Ko0000=?ooool01?l0003oooooooooooooool3o`0000;ooooo00?o0000oooo
ooooool0=Oooool001cooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`0Iooooo`;o
00006oooool00ol0003oooooo`00000looooo`03o`000?oooooooooo00?o00009Oooool00ol0003o
ooooooooo`0Aooooo`03o`000?oooooooooo00;ooooo6ol0000Hooooo`Co0000=Oooool00ol0003o
ooooooooo`02ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0=?ooool001cooooo
00?o0000ooooooooool02?ooool00ol0003oooooooooo`0Iooooo`;o00006oooool00ol0003ooooo
o`00000looooo`03o`000?oooooo000000Co00008oooool3o`0001;ooooo00Co0000oooooooooooo
oooo7Ol00003ooooo`03o`000?oooooooooo01;ooooo0ol0000eooooo`03o`000?oooooooooo00Oo
oooo00?o0000ooooooooool0=?ooool001cooooo0ol00008ooooo`03o`000?oooooooooo01Wooooo
0_l0000Kooooo`03o`000?oooooo000003cooooo2?l0000Qooooo`Go00004Oooool00ol0003ooooo
ooooo`02ooooo`So00000_ooool00ol0003oooooooooo`02o`000003ooooool0003o000000[o0000
0_ooool3o`0000;ooooo00?o0000ooooooooool03_ooool3o`0003Gooooo00?o0000ooooooooool0
1oooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo02kooooo000Looooo`03o`000?oo
oooooooo00Sooooo00?o0000ooooooooool06Oooool2o`0000Gooooo00?o0000ooooooooool04ooo
ool00ol0003oooooo`00000looooo`So00008?ooool7o`00013ooooo00?o0000ooooooooool00ooo
ool5o`000003ooooool0003ooooo00Gooooo00?o0000ooooool000002ol000000ooooooo0000o`00
0006o`0000kooooo00Co0000oooooooooooo0000=Oooool00ol0003oooooooooo`08ooooo`04o`00
0?ooooooooooooooo`?o0000;oooool001cooooo00?o0000ooooooooool02?ooool00ol0003ooooo
ooooo`0Iooooo`;o00001?ooool3o`0001?ooooo00Co0000oooooooooooo00009oooool00ol0003o
ooooooooo`0Aooooo`03o`000?oooooo000000Ko00007oooool8o`00013ooooo00?o0000oooooooo
ool01?ooool3o`0000cooooo00?o0000ooooool000001ol00002ooooo`Wo000000?oooooo`000?oo
ool02_ooool01?l0003oooooooooool0000eooooo`03o`000?oooooooooo00Sooooo00?o0000oooo
ooooool01?l0000<ooooo`04o`000?ooooooooooo`0001oooooo000Looooo`03o`000?oooooooooo
00Sooooo00?o0000ooooooooool06Oooool2o`0000?ooooo1Ol0000Booooo`05o`000?oooooooooo
ooooool000009Oooool3o`0001;ooooo00?o0000ooooooooool01Ol0000Qooooo`Oo00004?ooool0
0ol0003oooooooooo`05ooooo`03o`000?oooooooooo00kooooo1ol000000ooooooo0000o`00000;
o`000003ooooool0003ooooo00Oooooo00Co0000oooooooooooo00008Oooool00ol0003ooooooooo
o`0Aooooo`03o`000?oooooooooo00Sooooo2Ol00006ooooo`03o`000?oooooooooo00Ko00007_oo
ool001cooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`0Iooooo`;o00000oooool6
o`00017ooooo00Go0000ooooooooooooooooo`00000Tooooo`Go00004Oooool01?l0003ooooooooo
ooooool3o`0002?ooooo1Ol0000Aooooo`03o`000?oooooooooo01Oooooo00Oo0000oooooooooooo
0000ooooool0003ooooo013o00001oooool01?l0003oooooooooool0000Pooooo`?o00004_ooool0
0ol0003oooooooooo`08ooooo`[o00001?ooool;o`0001gooooo000Looooo`03o`000?oooooooooo
00Sooooo0_l0000Jooooo`;o00000_ooool7o`00017ooooo00?o0000ooooooooool00ol0000Roooo
o`Oo00004?ooool00ol0003oooooooooo`02ooooo`;o00009?ooool3o`0001;ooooo00?o0000oooo
ooooool07OoooolBo`000003ooooool0003ooooo00;ooooo00Go0000ooooooooooooooooo`00000O
ooooo`Go00004Oooool00ol0003oooooooooo`07ooooo`co000000?oooooo`000?l000003Ol0000K
ooooo`001oooool3o`0000Cooooo0_l00004ooooo`;o00001_ooool00ol0003oooooooooo`08oooo
o`;o00006_ooool2o`0000?ooooo1_l0000Aooooo`03o`000?oooooo000000Co00008?ooool8o`00
013ooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`0Rooooo`;o00004_ooool00ol0
003oooooooooo`0LoooooaKo000000?oooooo`000?l000001?ooool00ol0003oooooooooo`0Koooo
o`Oo00004?ooool00ol0003oooooooooo`06oooooako00006_ooool000Kooooo00Go0000oooooooo
ooooooooo`000002ooooo`04o`000?ooooooooooo`0000;ooooo00Co0000oooooooooooo00001Ooo
ool00ol0003oooooooooo`08ooooo`;o00006_ooool00ol0003oooooo`000003ooooo`Co00004_oo
ool8o`00023ooooo1ol0000@ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool08_oo
ool2o`0001;ooooo00?o0000ooooooooool06oooool7o`0000;ooooo4Ol00004ooooo`03o`000?oo
oooooooo01[ooooo2?l0000@ooooo`03o`000?oooooooooo00Gooooo8Ol0000Hooooo`001_ooool0
1Ol0003ooooooooooooooooo000000;ooooo00Co0000oooooooooooo00000_ooool01?l0003ooooo
ooooool00005ooooo`Co00001oooool2o`0001[ooooo00?o0000ooooool000000oooool3o`0001?o
oooo2?l0000Qooooo`Go00004Oooool00ol0003oooooooooo`04ooooo`;o00008oooool2o`0001;o
oooo00?o0000ooooooooool06_ooool8o`0000?ooooo00?o0000ooooool000003_l00003ooooo`03
o`000?oooooooooo01_ooooo1ol0000@ooooo`03o`000?oooooooooo00Kooooo8Ol0000Gooooo`00
1_ooool4o`0000?ooooo00Co0000oooooooooooo00000_ooool01?l0003oooooooooool00005oooo
o`03o`000?oooooooooo00Sooooo0_l0000Jooooo`03o`000?oooooo000000Cooooo0_l0000Coooo
o`So00008_ooool3o`0001;ooooo00?o0000ooooooooool01?ooool3o`00027ooooo00?o0000oooo
ool000004_ooool00ol0003oooooooooo`0Kooooo`Oo00001_ooool?o`0000;ooooo00?o0000oooo
ooooool07?ooool5o`00017ooooo00?o0000ooooooooool01oooool5o`0000;ooooo3_l000000ooo
oooo0000o`000009o`000003ooooool0003ooooo01?ooooo0006ooooo`03o`000?oooooooooo00Co
oooo00Co0000oooooooooooo00000_ooool01?l0003oooooooooool00005ooooo`03o`000?oooooo
oooo00Sooooo0_l0000Jooooo`03o`000?oooooo000000?ooooo00?o0000ooooool000004oooool0
0ol0003oooooo`000004o`0002Cooooo0_l0000Booooo`03o`000?oooooooooo00?ooooo1Ol0000P
ooooo`03o`000?oooooo000001;ooooo00?o0000ooooooooool07?ooool5o`0000Sooooo00?o0000
ooooool000002ol00002ooooo`03o`000?oooooooooo01gooooo0ol0000Booooo`03o`000?oooooo
oooo00Sooooo0ol00004ooooo`[o00000_ooool00ol0003oooooooooo`0=o`000003ooooool0003o
oooo013ooooo0007ooooo`03o`000?oooooooooo00?ooooo00Co0000oooooooooooo00000_ooool0
1?l0003oooooooooool00005ooooo`03o`000?oooooooooo00Sooooo0_l0000Jooooo`03o`000?oo
oooo000000?ooooo00?o0000ooooool000004oooool00ol0003oooooooooo`04o`000003ooooool0
003ooooo027ooooo0_l0000Booooo`03o`000?oooooooooo00?ooooo1_l0000Oooooo`03o`000?oo
oooo000001;ooooo00?o0000ooooooooool07Oooool3o`0000cooooo00?o0000ooooool000002?l0
0002ooooo`03o`000?oooooooooo01kooooo0_l0000Booooo`03o`000?oooooooooo00Wooooo00?o
0000ooooooooool01?ooool00ol0003oooooo`000003o`000003ooooool0003ooooo00Oooooo3_l0
0002ooooo`03o`000?oooooooooo00_ooooo0008ooooo`;o00001?ooool2o`0000Cooooo0_l00006
ooooo`03o`000?oooooooooo00Sooooo0_l0000Jooooo`03o`000?oooooo000000?ooooo00?o0000
ooooool000004oooool01Ol0003ooooooooooooooooo000000;ooooo0ol0000Qooooo`;o00004_oo
ool00ol0003oooooooooo`02ooooo`Oo00007oooool00ol0003oooooo`00000Booooo`03o`000?oo
oooooooo01kooooo00?o0000ooooooooool03_ooool7o`0000?ooooo00?o0000ooooooooool07_oo
ool2o`0001;ooooo00?o0000ooooooooool04oooool2o`0000cooooo4Ol0000<ooooo`007?ooool0
0ol0003oooooooooo`08ooooo`;o00006_ooool00ol0003oooooo`000003ooooo`03o`000?oooooo
000001?ooooo00?o0000ooooooooool00oooool4o`00023ooooo00?o0000ooooool000004_ooool0
0ol0003oooooooooo`03ooooo`Ko00007oooool00ol0003oooooo`00000Booooo`03o`000?oooooo
oooo033ooooo00?o0000ooooool000000_l00005ooooo`03o`000?oooooooooo01gooooo0_l0000B
ooooo`03o`000?oooooooooo01Cooooo00?o0000ooooooooool02oooool00ol0003oooooo`00000>
o`0000_ooooo000Looooo`03o`000?oooooooooo00Sooooo0_l0000Jooooo`03o`000?oooooo0000
00?ooooo00?o0000ooooool000004oooool00ol0003oooooooooo`02ooooo`Ko00001?ooool01?l0
003oooooooooool0000Gooooo`03o`000?oooooo000001;ooooo00?o0000ooooooooool01?ooool4
o`00023ooooo00?o0000ooooool000004_ooool00ol0003oooooooooo`0cooooo`03o`000?oooooo
oooo00?ooooo0ol0000Nooooo`;o00004_ooool00ol0003oooooooooo`0Toooooa3o00002_ooool0
01cooooo00?o0000ooooooooool02?ooool2o`0001[ooooo00?o0000ooooool000000oooool00ol0
003oooooo`00000Cooooo`04o`000?ooooooooooooooo`So00000_ooool6o`0001Kooooo00?o0000
ooooool000004_ooool00ol0003oooooooooo`04ooooo`Co00008?ooool01?l0003oooooooooool0
000Aooooo`03o`000?oooooooooo03Sooooo1Ol0000Mooooo`03o`000?oooooo0000017ooooo00?o
0000ooooooooool09Oooool00ol0003oooooo`00000<o`0000[ooooo000Looooo`03o`000?oooooo
oooo00Sooooo0_l0000Jooooo`03o`000?oooooo000000?ooooo00?o0000ooooool000004oooool0
0ol0003oooooooooo`02oooooa3o00005Oooool00ol0003oooooo`00000Booooo`03o`000?oooooo
oooo00Gooooo00Go0000ooooool0003oooooo`000002ooooo`03o`000?oooooooooo01Wooooo00Co
0000oooooooooooo00004Oooool00ol0003oooooooooo`0gooooo`Oo00007?ooool00ol0003ooooo
o`00000Aooooo`03o`000?oooooooooo02Sooooo3?l0000:ooooo`007?ooool3o`0000Sooooo0_l0
000Jooooo`04o`000?ooooooooooo`0000;ooooo00?o0000ooooool000004oooool00ol0003ooooo
ooooo`03oooooa3o00005?ooool00ol0003oooooo`00000Booooo`03o`000?oooooooooo00Sooooo
1_l0000Jooooo`04o`000?ooooooooooo`00017ooooo00?o0000ooooooooool0=_ooool8o`0001co
oooo00?o0000ooooool000004Oooool00ol0003oooooooooo`0Yooooo`03o`000?oooooo000000Oo
00002oooool001cooooo00?o0000ooooooooool02?ooool2o`0001[ooooo00Co0000oooooooooooo
00000_ooool01?l0003oooooooooool0000Booooo`03o`000?oooooooooo00Cooooo3ol0000Doooo
o`04o`000?ooooooooooo`00017ooooo00?o0000ooooooooool01oooool8o`0001Wooooo00Co0000
oooooooooooo00004Oooool00ol0003oooooooooo`0gooooo`Oo00007?ooool00ol0003oooooo`00
000Aooooo`03o`000?oooooooooo02cooooo00?o0000ooooooooool00ol0000<ooooo`007?ooool0
0ol0003oooooooooo`08ooooo`;o00006_ooool01_l0003oooooooooool0003oooooo`0000?ooooo
00?o0000ooooooooool04?ooool00ol0003oooooooooo`04ooooo`oo00005?ooool01?l0003ooooo
ooooool0000Aooooo`03o`000?oooooooooo00Kooooo2_l0000Hooooo`04o`000?ooooooooooo`00
017ooooo00?o0000ooooooooool0>?ooool5o`0001cooooo00Co0000oooooooooooo00004Oooool0
0ol0003oooooooooo`0`ooooo`03o`000?oooooooooo00_ooooo000Looooo`03o`000?oooooooooo
00Sooooo0_l0000Jooooo`06o`000?ooooooooooo`000?oooooo00000oooool00ol0003ooooooooo
o`0@ooooo`03o`000?oooooooooo00Gooooo3Ol0000Eooooo`04o`000?ooooooooooo`00017ooooo
00?o0000ooooooooool01Oooool<o`0001Oooooo00Co0000oooooooooooo00004Oooool00ol0003o
ooooooooo`0iooooo`?o00007Oooool01?l0003oooooooooool0000Aooooo`03o`000?oooooooooo
033ooooo00?o0000ooooooooool02oooool001cooooo00?o0000ooooooooool02?ooool2o`0001[o
oooo00Ko0000oooooooooooo0000ooooool00003ooooo`03o`000?oooooooooo013ooooo00?o0000
ooooooooool01_ooool7o`000004ooooool0003o0000o`0001Kooooo00Co0000oooooooooooo0000
4Oooool00ol0003oooooooooo`06ooooo`co00005_ooool01?l0003oooooooooool0000Aooooo`03
o`000?oooooooooo03[ooooo0_l0000Mooooo`05o`000?ooooooooooooooool000004?ooool00ol0
003oooooooooo`0`ooooo`03o`000?oooooooooo00_ooooo000Looooo`03o`000?oooooooooo00So
oooo0_l0000Jooooo`06o`000?ooooooooooo`000?oooooo00000oooool00ol0003oooooooooo`0@
ooooo`03o`000?oooooooooo00Oooooo0ol00002ooooo`06o`000?ooooooooooo`000?oooooo0000
5Oooool01?l0003oooooooooool0000Aooooo`03o`000?oooooooooo00Oooooo3?l0000Eooooo`04
o`000?ooooooooooo`00013ooooo00?o0000ooooooooool0??ooool00ol0003oooooooooo`0Koooo
o`05o`000?ooooooooooooooool000004?ooool00ol0003oooooooooo`0`ooooo`03o`000?oooooo
oooo00_ooooo000Looooo`03o`000?oooooooooo00Sooooo0_l0000Jooooo`06o`000?oooooooooo
o`000?oooooo00000oooool00ol0003oooooooooo`0@ooooo`03o`000?oooooooooo00Sooooo00?o
0000ooooooooool01_ooool00ol0003oooooooooo`0Cooooo`04o`000?ooooooooooo`00017ooooo
00?o0000ooooooooool02?ooool=o`0001;ooooo00Go0000ooooooooooooooooo`00000@ooooo`03
o`000?oooooooooo03cooooo00?o0000ooooooooool06oooool01Ol0003ooooooooooooooooo0000
00?ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0`ooooo`03o`000?oooooooooo
00_ooooo000Looooo`03o`000?oooooooooo00Sooooo0_l0000Jooooo`06o`000?ooooooooooo`00
0?oooooo00000oooool00ol0003oooooooooo`0@ooooo`03o`000?oooooooooo017ooooo00?o0000
ooooooooool04oooool01?l0003oooooooooool0000Aooooo`03o`000?oooooooooo00Wooooo00?o
0000ooooooooool02_l000000ooooooo0000ooooo`0>ooooo`03o`000?oooooooooo00;ooooo00?o
0000ooooooooool03Oooool00ol0003oooooooooo`0mooooo`03o`000?oooooooooo01[ooooo00Go
0000ooooooooooooooooo`000002ooooo`?o00002oooool00ol0003oooooooooo`0`ooooo`03o`00
0?oooooooooo00_ooooo000Looooo`03o`000?oooooooooo00Sooooo0_l0000Jooooo`06o`000?oo
ooooooooo`000?oooooo00000oooool00ol0003oooooooooo`0@ooooo`03o`000?oooooooooo01;o
oooo0_l0000Cooooo`05o`000?ooooooooooooooool000004?ooool00ol0003oooooooooo`0=oooo
o`co00003_ooool01?l0003oooooooooooooool3o`0000kooooo00?o0000ooooooooool0?Oooool0
0ol0003oooooooooo`0Jooooo`04o`000?ooooooooooooooo`Oo00002_ooool00ol0003ooooooooo
o`0`ooooo`03o`000?oooooooooo00_ooooo000Looooo`?o00002?ooool2o`0001Wooooo00Oo0000
ooooooooooooooooo`000?oooooo000000?ooooo00?o0000ooooooooool04?ooool00ol0003ooooo
ooooo`0Booooo`?o00004_ooool01Ol0003ooooooooooooooooo0000013ooooo00?o0000oooooooo
ool03_ooool<o`000003ooooool0003ooooo00[ooooo00?o0000ooooooooool01Ol0000=ooooo`03
o`000?oooooooooo03gooooo00?o0000ooooooooool06_ooool01?l0003oooooooooooooool8o`00
00Wooooo00?o0000ooooooooool0<?ooool00ol0003oooooooooo`0;ooooo`007?ooool00ol0003o
ooooooooo`08ooooo`03o`000?oooooo000001Sooooo00Oo0000ooooooooooooooooo`000?oooooo
000000Cooooo00?o0000ooooooooool03oooool00ol0003oooooooooo`0Aooooo`Go00004?ooool0
0ol0003oooooooooo`02ooooo`03o`000?oooooooooo00kooooo00?o0000ooooooooool03oooool>
o`0000[ooooo00?o0000ooooooooool01_l0000<ooooo`03o`000?oooooooooo03gooooo00?o0000
ooooooooool06_ooool00ol0003oooooooooo`09o`0000Wooooo00?o0000ooooooooool0<?ooool0
0ol0003oooooooooo`0;ooooo`007?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooo0000
01Sooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo
00oooooo00?o0000ooooooooool04?ooool7o`0000oooooo00?o0000ooooooooool00_ooool00ol0
003oooooooooo`0>ooooo`03o`000?oooooooooo013ooooo3Ol00005ooooo`03o`000?oooooooooo
00;ooooo00?o0000ooooool000001_l0000<ooooo`03o`000?oooooooooo03gooooo00?o0000oooo
ooooool06_ooool00ol0003oooooo`000009o`0000Wooooo00?o0000ooooooooool0<?ooool00ol0
003oooooooooo`0;ooooo`007?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooo000001So
oooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00oo
oooo00?o0000ooooooooool03oooool8o`0000Kooooo00?o0000ooooooooool01_ooool00ol0003o
ooooooooo`02ooooo`03o`000?oooooooooo00kooooo00?o0000ooooooooool04_ooool<o`0000?o
oooo0ol00003ooooo`03o`000?oooooooooo00Ko00003?ooool00ol0003oooooooooo`0nooooo`03
o`000?oooooooooo01Wooooo2ol00009ooooo`03o`000?oooooooooo037ooooo00?o0000oooooooo
ool02oooool001cooooo00?o0000ooooooooool02?ooool00ol0003oooooo`00000Hooooo`04o`00
0?ooooooooooooooo`?o00001?ooool00ol0003oooooooooo`0?ooooo`03o`000?oooooooooo013o
oooo1ol00005ooooo`?o00000_ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00;o
oooo00?o0000ooooooooool03_ooool00ol0003oooooooooo`0Cooooo`_o00000_ooool4o`0000?o
oooo00Co0000oooooooooooooooo1?l0000=ooooo`03o`000?oooooooooo03kooooo00?o0000oooo
ooooool06Oooool00ol0003oooooo`000007o`0000[ooooo00?o0000ooooooooool0<Oooool00ol0
003oooooooooo`0;ooooo`007?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooo000001So
oooo00?o0000ooooooooool01?l00004ooooo`03o`000?oooooooooo00oooooo00?o0000oooooooo
ool04Oooool5o`0000Gooooo2?l00003ooooo`03o`000?oooooooooo00;ooooo00?o0000oooooooo
ool03_ooool00ol0003oooooooooo`0Dooooo`03o`000?oooooo000000Oo000000?oooooo`000?l0
00001?l00002ooooo`04o`000?ooooooooooooooo`?o00003_ooool00ol0003oooooooooo`0noooo
o`03o`000?oooooooooo01Wooooo00?o0000ooooooooool01?l000000ooooooo0000o`00000:oooo
o`03o`000?oooooooooo037ooooo00?o0000ooooooooool02oooool001cooooo00?o0000oooooooo
ool02?ooool00ol0003oooooo`00000Hooooo`03o`000?oooooo000000Go00000oooool00ol0003o
ooooooooo`0?ooooo`03o`000?oooooooooo01;ooooo0ol00006ooooo`Wo00000_ooool00ol0003o
ooooooooo`02ooooo`03o`000?oooooooooo00kooooo00?o0000ooooooooool05oooool00ol0003o
ooooo`000003o`000003ooooool0003o000000Go00000_ooool00ol0003oooooooooo`02ooooo`;o
00003_ooool00ol0003oooooooooo`0nooooo`03o`000?oooooooooo01Wooooo00Co0000oooooooo
oooooooo0_l00003ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool0<Oooool00ol0
003oooooooooo`0;ooooo`007?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooo000001So
oooo2?l00003ooooo`03o`000?oooooooooo00oooooo00?o0000ooooooooool04oooool01?l0003o
ooooo`000?l00003ooooo`_o000000?oooooo`000?ooool01?ooool00ol0003oooooooooo`0=oooo
o`03o`000?oooooooooo01[ooooo0ol00002ooooo`Ko00000_ooool00ol0003oooooooooo`03oooo
o`03o`000?oooooooooo00cooooo00?o0000ooooooooool0?_ooool2o`0000Kooooo00?o0000oooo
ooooool04Oooool00ol0003oooooooooo`02ooooo`05o`000?ooooooooooooooool000002_ooool0
0ol0003oooooooooo`0aooooo`03o`000?oooooooooo00_ooooo000Looooo`?o00002?ooool00ol0
003oooooo`00000Hooooo`03o`000?oooooo000000Go00000oooool00ol0003oooooooooo`0?oooo
o`03o`000?oooooooooo01Gooooo0ol000000ooooooo0000o`00000:o`000003ooooool0003ooooo
00?ooooo0ol0000>ooooo`03o`000?oooooooooo01_ooooo0_l00003ooooo`Co00000oooool00ol0
003oooooooooo`03ooooo`03o`000?oooooooooo00cooooo00?o0000ooooooooool0?_ooool3o`00
00Cooooo0ol0000Booooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool01oooool00ol0
003oooooooooo`0booooo`03o`000?oooooooooo00[ooooo000Looooo`03o`000?oooooooooo00So
oooo00?o0000ooooool000006?ooool00ol0003oooooooooo`04o`0000Cooooo00?o0000oooooooo
ool03oooool00ol0003oooooooooo`0Doooooa7o000000?oooooo`000?ooool00_ooool4o`0000ko
oooo00?o0000ooooooooool07?ooool00ol0003oooooooooo`02ooooo`;o00001?ooool00ol0003o
ooooooooo`03ooooo`03o`000?oooooooooo00cooooo00?o0000ooooooooool0?Oooool6o`000003
ooooool0003o000000?o00004Oooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Oo
oooo00?o0000ooooooooool0<_ooool00ol0003oooooooooo`0:ooooo`007?ooool00ol0003ooooo
ooooo`08ooooo`03o`000?oooooo000001Sooooo00Co0000oooooooooooooooo0_l00006ooooo`03
o`000?oooooooooo00kooooo00?o0000ooooooooool05?ooool@o`0000;ooooo00?o0000oooooooo
ool01_l0000=ooooo`03o`000?oooooooooo01cooooo00?o0000ooooooooool00_ooool3o`0000;o
oooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo03co
oooo3_l0000@ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool01oooool00ol0003o
ooooooooo`0booooo`03o`000?oooooooooo00[ooooo000Looooo`03o`000?oooooooooo00Sooooo
00?o0000ooooool000006?ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00Cooooo
00?o0000ooooooooool03_ooool00ol0003oooooooooo`0Cooooo`_o00000_ooool3o`0000?ooooo
00?o0000ooooool000001_l0000=ooooo`03o`000?oooooooooo01gooooo00Co0000oooooooooooo
00000_ooool01?l0003oooooooooool00007ooooo`03o`000?oooooooooo00_ooooo00?o0000oooo
ooooool0>oooool?o`00013ooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`07oooo
o`03o`000?oooooooooo03;ooooo00?o0000ooooooooool02_ooool001cooooo00?o0000oooooooo
ool02?ooool00ol0003oooooo`00000Hooooo`03o`000?oooooooooo00Sooooo0ol0000?ooooo`03
o`000?oooooooooo01Cooooo2_l00003ooooo`03o`000?oooooooooo00;ooooo00?o0000oooooooo
ool01_l0000=ooooo`03o`000?oooooooooo01gooooo00Co0000oooooooooooo00000_ooool01?l0
003oooooooooool00007ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool0??ooool>
o`00013ooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`07ooooo`03o`000?oooooo
oooo03;ooooo00?o0000ooooooooool02_ooool001cooooo00?o0000ooooooooool02?ooool00ol0
003oooooo`00000Hooooo`03o`000?oooooooooo00Oooooo1Ol0000>ooooo`03o`000?oooooooooo
01Gooooo2?l00005ooooo`05o`000?ooooooooooooooool000000oooool4o`0000kooooo00?o0000
ooooooooool07Oooool01?l0003oooooooooool00002ooooo`04o`000?ooooooooooo`0000Oooooo
00?o0000ooooooooool02oooool00ol0003oooooooooo`0mooooo`co00004Oooool00ol0003ooooo
ooooo`08ooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool0<_ooool00ol0003ooooo
ooooo`0:ooooo`001oooool3o`0000Cooooo0_l00004ooooo`;o00001_ooool00ol0003ooooooooo
o`08ooooo`03o`000?oooooo000000Cooooo00?o0000ooooooooool04Oooool00ol0003ooooooooo
o`06ooooo`Oo00003Oooool00ol0003oooooooooo`0Eooooo`?o000000Coooooo`000?l0003o0000
1_ooool01Ol0003ooooooooooooooooo000000Cooooo0_l0000?ooooo`03o`000?oooooooooo01go
oooo00?o0000ooooool000000oooool01?l0003oooooooooool00007ooooo`03o`000?oooooooooo
00_ooooo00?o0000ooooooooool0?_ooool:o`0001;ooooo00?o0000ooooooooool02?ooool00ol0
003oooooooooo`06ooooo`03o`000?oooooooooo03;ooooo00?o0000ooooooooool02_ooool000Ko
oooo00Go0000ooooooooooooooooo`000002ooooo`04o`000?ooooooooooo`0000;ooooo00Co0000
oooooooooooo00001Oooool00ol0003oooooooooo`08ooooo`03o`000?oooooo000000?ooooo0ol0
000Booooo`03o`000?oooooooooo00Gooooo2?l0000=ooooo`03o`000?oooooooooo01Kooooo00Go
0000ooooooooooooooooo`000007ooooo`04o`000?ooooooooooo`0000Kooooo00?o0000oooooooo
ool03Oooool00ol0003oooooooooo`0Mooooo`?o00000oooool01?l0003oooooooooool00008oooo
o`03o`000?oooooooooo00[ooooo00?o0000ooooooooool0?oooool00ol0003oooooo`000003o`00
0003ooooool0003o000001;ooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`06oooo
o`03o`000?oooooooooo03;ooooo00?o0000ooooooooool02_ooool000Kooooo00Go0000oooooooo
ooooooooo`000002ooooo`04o`000?ooooooooooo`0000;ooooo00Co0000oooooooooooo00001Ooo
ool00ol0003oooooooooo`08ooooo`03o`000?oooooo000000;ooooo1Ol0000Aooooo`03o`000?oo
oooooooo00Kooooo1ol0000=ooooo`03o`000?oooooooooo02;ooooo00Co0000oooooooooooo0000
1oooool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo01gooooo0ol00003ooooo`04o`00
0?ooooooooooo`0000Sooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`11ooooo`?o
00000oooool00ol0003oooooooooo`0@ooooo`03o`000?oooooooooo00Sooooo0_l00007ooooo`03
o`000?oooooooooo03;ooooo00?o0000ooooooooool02_ooool000Oooooo0ol00003ooooo`04o`00
0?ooooooooooo`0000;ooooo00Co0000oooooooooooo00001Oooool4o`0000Oooooo00Co0000oooo
ool0003ooooo1ol0000@ooooo`03o`000?oooooooooo00Oooooo1Ol0000>ooooo`03o`000?oooooo
oooo02;ooooo00Co0000oooooooooooo00001oooool00ol0003oooooooooo`0<ooooo`03o`000?oo
oooooooo01cooooo1Ol00002ooooo`04o`000?ooooooooooo`0000Sooooo00?o0000ooooooooool0
2_ooool00ol0003oooooooooo`12ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0
3oooool00ol0003oooooooooo`09ooooo`?o00001_ooool00ol0003oooooooooo`0booooo`03o`00
0?oooooooooo00[ooooo0006ooooo`05o`000?ooooooooooooooool000000_ooool01?l0003ooooo
ooooool00002ooooo`04o`000?ooooooooooo`0000Gooooo00?o0000ooooooooool02?ooool00ol0
003oooooo`000008o`00013ooooo00?o0000ooooooooool02?ooool3o`0000oooooo00?o0000oooo
ooooool08_ooool01?l0003oooooooooool00007ooooo`03o`000?oooooooooo00cooooo00?o0000
ooooooooool06oooool7o`0000;ooooo00?o0000ooooool000002?ooool00ol0003oooooooooo`0:
ooooo`03o`000?oooooooooo04Sooooo00?o0000ooooooooool03_ooool00ol0003oooooooooo`08
ooooo`Co00001_ooool00ol0003oooooooooo`0booooo`03o`000?oooooooooo00[ooooo0006oooo
o`05o`000?ooooooooooooooool000000_ooool01?l0003oooooooooool00002ooooo`04o`000?oo
ooooooooo`0000Gooooo00?o0000ooooooooool01oooool01Ol0003oooooooooool0003ooooo00Oo
00004?ooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo00kooooo00?o0000oooooooo
ool08_ooool01?l0003oooooooooool00007ooooo`03o`000?oooooooooo00cooooo00?o0000oooo
ooooool06_ooool8o`0000;ooooo00?o0000ooooool000002?ooool2o`0000_ooooo00?o0000oooo
ooooool0B?ooool00ol0003oooooooooo`0>ooooo`03o`000?oooooooooo00Oooooo1_l00005oooo
o`03o`000?oooooooooo03;ooooo00?o0000ooooooooool02_ooool000Oooooo0ol00004ooooo`;o
00001?ooool2o`0000Kooooo00?o0000ooooooooool01oooool01?l0003oooooooooool00002oooo
o`Go00004Oooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo00kooooo00?o0000oooo
ooooool08_ooool01?l0003oooooooooool00007ooooo`03o`000?oooooooooo00cooooo00?o0000
ooooooooool06oooool7o`0000;ooooo00?o0000ooooool000002?ooool3o`0000[ooooo00?o0000
ooooooooool0B?ooool00ol0003oooooooooo`0>ooooo`03o`000?oooooooooo00Kooooo1ol00005
ooooo`03o`000?oooooooooo03;ooooo00?o0000ooooooooool02_ooool001cooooo00?o0000oooo
ooooool01oooool01?l0003oooooooooool00003ooooo`?o00004_ooool00ol0003oooooooooo`0:
ooooo`03o`000?oooooooooo00gooooo00?o0000ooooooooool08_ooool01?l0003oooooooooool0
0007ooooo`03o`000?oooooooooo00cooooo00?o0000ooooooooool07?ooool5o`0000?ooooo00?o
0000ooooool000001oooool5o`0000Wooooo00?o0000ooooooooool0B?ooool2o`0000oooooo00?o
0000ooooooooool01oooool6o`0000Gooooo00?o0000ooooooooool0<_ooool00ol0003ooooooooo
o`0:ooooo`007?ooool00ol0003oooooooooo`07ooooo`04o`000?ooooooooooo`0000?ooooo0_l0
000Cooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool03Oooool00ol0003ooooooooo
o`0Sooooo`03o`000?oooooo000000Oooooo00?o0000ooooooooool03?ooool00ol0003ooooooooo
o`0Mooooo`?o00001?ooool00ol0003oooooo`000006ooooo`Oo00002?ooool00ol0003ooooooooo
o`18ooooo`?o00003_ooool00ol0003oooooooooo`08ooooo`Co00001_ooool00ol0003ooooooooo
o`0booooo`03o`000?oooooooooo00[ooooo000Looooo`03o`000?oooooooooo00Oooooo00Co0000
oooooooooooo00000oooool2o`0001?ooooo00?o0000ooooooooool02_ooool00ol0003ooooooooo
o`0<ooooo`03o`000?oooooooooo02Cooooo00?o0000ooooool000001oooool00ol0003ooooooooo
o`0<ooooo`03o`000?oooooooooo01kooooo00?o0000ooooooooool00oooool00ol0003oooooo`00
0005ooooo`So00002?ooool00ol0003oooooooooo`17ooooo`Go00003Oooool00ol0003ooooooooo
o`09ooooo`?o00001_ooool00ol0003oooooooooo`0booooo`03o`000?oooooooooo00[ooooo000L
ooooo`03o`000?oooooooooo00Oooooo00Wo0000ooooooooooooooooo`000?oooooo0000ooooool0
00004oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00cooooo00?o0000oooooooo
ool09?ooool00ol0003oooooo`000007ooooo`03o`000?oooooooooo00cooooo00?o0000oooooooo
ool09?ooool2o`0000Oooooo1ol00008ooooo`03o`000?oooooooooo04Oooooo1_l0000<ooooo`03
o`000?oooooooooo00[ooooo0_l00006ooooo`03o`000?oooooooooo03;ooooo00?o0000oooooooo
ool02_ooool001cooooo0ol00007ooooo`09o`000?ooooooooooooooool0003oooooo`000?oooooo
000001?ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0<ooooo`03o`000?oooooo
oooo02Cooooo00?o0000ooooool000001oooool00ol0003oooooooooo`0<ooooo`03o`000?oooooo
oooo02Cooooo0_l00008ooooo`Go00002Oooool00ol0003oooooooooo`16ooooo`Oo00003?ooool0
0ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool0<_ooool0
0ol0003oooooooooo`0:ooooo`007?ooool00ol0003oooooooooo`07ooooo`07o`000?oooooooooo
ooooool0003oooooo`000002ooooo`03o`000?oooooooooo013ooooo00?o0000ooooooooool02_oo
ool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo02Cooooo00?o0000ooooool000001ooo
ool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo02Cooooo0_l00009ooooo`Go00002?oo
ool00ol0003oooooooooo`17ooooo`Ko00000oooool00ol0003oooooooooo`06ooooo`03o`000?oo
oooooooo00_ooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`0booooo`03o`000?oo
oooooooo00[ooooo000Looooo`03o`000?oooooooooo00Oooooo00Oo0000ooooooooooooooooo`00
0?oooooo000000;ooooo00?o0000ooooooooool04?ooool00ol0003oooooooooo`0:ooooo`03o`00
0?oooooooooo00cooooo00?o0000ooooooooool09?ooool00ol0003oooooo`000008ooooo`03o`00
0?oooooooooo00_ooooo00?o0000ooooooooool09Oooool00ol0003oooooooooo`08ooooo`03o`00
0?oooooo000000;o00001oooool00ol0003oooooooooo`18ooooo`Co000000?oooooo`000?ooool0
0ol00007ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool01?ooool00ol0003ooooo
ooooo`0booooo`03o`000?oooooooooo00[ooooo000Looooo`03o`000?oooooooooo00Oooooo00Oo
0000ooooooooooooooooo`000?oooooo000000;ooooo00?o0000ooooooooool04?ooool00ol0003o
ooooooooo`0:ooooo`03o`000?oooooooooo00cooooo00?o0000ooooooooool09?ooool00ol0003o
ooooo`000008ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool09?ooool3o`0000[o
oooo1Ol00006ooooo`03o`000?oooooooooo04Sooooo2ol00006ooooo`03o`000?oooooooooo00_o
oooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`0booooo`03o`000?oooooooooo00[o
oooo000Looooo`03o`000?oooooooooo00Oooooo00Co0000oooooooooooooooo0_l00003ooooo`03
o`000?oooooooooo013ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0<ooooo`03
o`000?oooooooooo02Cooooo0_l00009ooooo`03o`000?oooooooooo00_ooooo00?o0000oooooooo
ool08oooool5o`0000Wooooo1_l00005ooooo`03o`000?oooooooooo04Wooooo00?o0000ooooool0
00002Ol00004ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool01?ooool00ol0003o
ooooooooo`0booooo`03o`000?oooooooooo00[ooooo000Looooo`03o`000?oooooooooo00Oooooo
00Co0000oooooooooooooooo0_l00003ooooo`03o`000?oooooooooo013ooooo00?o0000oooooooo
ool02_ooool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo02Cooooo0_l00009ooooo`03
o`000?oooooooooo00[ooooo00?o0000ooooooooool08oooool7o`0000Oooooo1ol00004ooooo`03
o`000?oooooooooo04_ooooo3?l00003ooooo`03o`000?oooooooooo00cooooo00?o0000oooooooo
ool00oooool00ol0003oooooooooo`0booooo`03o`000?oooooooooo00[ooooo000Looooo`03o`00
0?oooooooooo00Oooooo00Co0000oooooooooooooooo0_l00003ooooo`03o`000?oooooooooo013o
oooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo02Go
oooo00?o0000ooooooooool01oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo02;o
oooo2?l00008ooooo`Ko00001?ooool00ol0003oooooooooo`1:ooooo`ko00000_ooool00ol0003o
ooooooooo`0<ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool0<_ooool00ol0003o
ooooooooo`0:ooooo`007?ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00?o0000
0oooool00ol0003oooooooooo`0@ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool0
3?ooool00ol0003oooooooooo`0Uooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool0
2_ooool00ol0003oooooooooo`0Sooooo`Oo00002Oooool4o`0000Gooooo00?o0000ooooooooool0
Boooool>o`000003ooooool0003ooooo00gooooo00?o0000ooooooooool00oooool00ol0003ooooo
ooooo`0booooo`03o`000?oooooooooo00[ooooo000Looooo`03o`000?oooooooooo00Oooooo00?o
0000ooooool000001?l00002ooooo`03o`000?oooooooooo013ooooo00?o0000ooooooooool02_oo
ool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo02Cooooo0ol00008ooooo`03o`000?oo
oooooooo00[ooooo00?o0000ooooooooool09?ooool5o`0000[ooooo0ol00006ooooo`03o`000?oo
oooooooo04cooooo3Ol000000ooooooo0000ooooo`0=ooooo`03o`000?oooooooooo00?ooooo00?o
0000ooooooooool0<_ooool00ol0003oooooooooo`0:ooooo`007?ooool3o`0000Oooooo00?o0000
ooooool000001Ol000000ooooooo0000ooooo`0Aooooo`03o`000?oooooooooo00_ooooo00?o0000
ooooooooool02oooool00ol0003oooooooooo`0Sooooo`Go00001oooool00ol0003oooooooooo`0:
ooooo`03o`000?oooooooooo02Gooooo0ol0000<ooooo`;o00001_ooool00ol0003oooooooooo`1=
ooooo`?o000000?oooooo`000?l000001_l000000ooooooo0000ooooo`0=ooooo`03o`000?oooooo
oooo00?ooooo00?o0000ooooooooool0<_ooool00ol0003oooooooooo`0:ooooo`007?ooool00ol0
003oooooooooo`07ooooo`So000000?oooooo`000?ooool04Oooool00ol0003oooooooooo`0;oooo
o`03o`000?oooooooooo00_ooooo00?o0000ooooooooool08oooool6o`0000Kooooo00?o0000oooo
ooooool02_ooool00ol0003oooooooooo`0Vooooo`03o`000?oooooooooo00cooooo00?o0000oooo
ooooool01?ooool00ol0003oooooooooo`1>ooooo`03o`000?oooooooooo00;ooooo1Ol00002oooo
o`03o`000?oooooooooo00cooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`0boooo
o`03o`000?oooooooooo00[ooooo000Looooo`03o`000?oooooooooo00Oooooo00?o0000ooooool0
00001Ol000000ooooooo0000ooooo`0Aooooo`03o`000?oooooooooo00_ooooo00?o0000oooooooo
ool02oooool00ol0003oooooooooo`0Rooooo`Oo00001_ooool00ol0003oooooooooo`0:ooooo`03
o`000?oooooooooo03Gooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`1Dooooo`?o
00000oooool00ol0003oooooooooo`0<ooooo`;o00001?ooool00ol0003oooooooooo`0booooo`03
o`000?oooooooooo00[ooooo000Looooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool0
1?l00002ooooo`03o`000?oooooooooo013ooooo00?o0000ooooooooool02oooool00ol0003ooooo
ooooo`0;ooooo`03o`000?oooooooooo02?ooooo1_l00006ooooo`03o`000?oooooooooo00[ooooo
00?o0000ooooooooool0=Oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo05Gooooo
0_l00003ooooo`03o`000?oooooooooo00cooooo0ol00003ooooo`03o`000?oooooooooo03;ooooo
00?o0000ooooooooool02_ooool001cooooo00?o0000ooooooooool01oooool00ol0003ooooooooo
o`03o`0000?ooooo00?o0000ooooooooool04?ooool00ol0003oooooooooo`0;ooooo`03o`000?oo
oooooooo00_ooooo00?o0000ooooooooool09?ooool4o`0000Sooooo00Go0000oooooooooooooooo
o`000007ooooo`03o`000?oooooooooo03Gooooo00?o0000ooooooooool01?ooool00ol0003ooooo
ooooo`1Fooooo`05o`000?ooooooooooooooool000003Oooool5o`0000;ooooo00?o0000oooooooo
ool0<_ooool00ol0003oooooooooo`0:ooooo`007?ooool00ol0003oooooooooo`07ooooo`05o`00
0?ooooooooooooooool000001?ooool00ol0003oooooooooo`0@ooooo`03o`000?oooooooooo00_o
oooo00?o0000ooooooooool02oooool00ol0003oooooooooo`0Tooooo`?o00002Oooool00ol0003o
ooooooooo`03o`0000Kooooo00?o0000ooooooooool0=_ooool00ol0003oooooooooo`03ooooo`03
o`000?oooooooooo05Kooooo00Go0000ooooooooooooooooo`00000=ooooo`Ko000000?oooooo`00
0?ooool0<oooool00ol0003oooooooooo`0:ooooo`007?ooool00ol0003oooooooooo`07ooooo`03
o`000?oooooooooo00Kooooo00?o0000ooooooooool04?ooool00ol0003oooooooooo`0;ooooo`03
o`000?oooooooooo00_ooooo00?o0000ooooooooool09Oooool00ol0003oooooooooo`07ooooo`Oo
00001_ooool00ol0003oooooooooo`0fooooo`03o`000?oooooooooo00?ooooo00?o0000oooooooo
ool0Eoooool01?l0003oooooooooool0000<ooooo`So0000=Oooool00ol0003oooooooooo`0:oooo
o`007?ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Kooooo00?o0000oooooooo
ool04?ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00_ooooo00?o0000oooooooo
ool0;_ooool9o`0000Gooooo00?o0000ooooooooool0=_ooool00ol0003oooooooooo`03ooooo`03
o`000?oooooooooo05Oooooo00?o0000ooooool000003_ooool7o`0003Gooooo00?o0000oooooooo
ool02_ooool001cooooo0ol00007ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool0
3oooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool0
;Oooool:o`0000Gooooo00?o0000ooooooooool0=_ooool00ol0003oooooooooo`03ooooo`03o`00
0?oooooooooo05Oooooo00?o0000ooooool000003oooool4o`000003ooooool0003ooooo03Cooooo
00?o0000ooooooooool02_ooool001cooooo00?o0000ooooooooool01oooool00ol0003ooooooooo
o`07ooooo`03o`000?oooooooooo00oooooo00?o0000ooooooooool02oooool00ol0003ooooooooo
o`0;ooooo`03o`000?oooooooooo02cooooo2ol00005ooooo`03o`000?oooooooooo03Kooooo00?o
0000ooooooooool00oooool00ol0003oooooooooo`1Gooooo`03o`000?oooooo000000oooooo0ol0
0002ooooo`03o`000?oooooooooo03?ooooo00?o0000ooooooooool02_ooool001cooooo00?o0000
ooooooooool01oooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00oooooo00?o0000
ooooooooool02oooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo02gooooo2Ol00006
ooooo`03o`000?oooooooooo03Kooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`1G
ooooo`03o`000?oooooo0000013ooooo0_l00002ooooo`03o`000?oooooooooo03?ooooo00?o0000
ooooooooool02_ooool001cooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`07oooo
o`03o`000?oooooooooo00oooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`0;oooo
o`03o`000?oooooooooo02kooooo1ol00007ooooo`03o`000?oooooooooo03Oooooo00?o0000oooo
ooooool00_ooool00ol0003oooooooooo`1Hooooo`;o00004Oooool01?l0003oooooooooool0000f
ooooo`03o`000?oooooooooo00Wooooo000Looooo`03o`000?oooooooooo00Oooooo00?o0000oooo
ooooool01oooool00ol0003oooooooooo`0?ooooo`03o`000?oooooooooo00_ooooo00?o0000oooo
ooooool02oooool00ol0003oooooooooo`0_ooooo`?o00000_ooool00ol0003oooooooooo`05oooo
o`03o`000?oooooooooo03Oooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`1Hoooo
o`;o00004Oooool01?l0003oooooooooool0000fooooo`03o`000?oooooooooo00Wooooo000Loooo
o`03o`000?oooooooooo00Oooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`0?oooo
o`03o`000?oooooooooo00cooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0`oooo
o`05o`000?ooooooooooooooool000001oooool00ol0003oooooooooo`0gooooo`03o`000?oooooo
oooo00;ooooo00?o0000ooooooooool0F?ooool2o`0001;ooooo00?o0000ooooool00000=_ooool0
0ol0003oooooooooo`09ooooo`007?ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo
00Oooooo00?o0000ooooooooool03oooool00ol0003oooooooooo`0<ooooo`05o`000?oooooooooo
ooooool000002?ooool00ol0003oooooooooo`0eooooo`03o`000?oooooooooo00Cooooo00?o0000
ooooooooool0=oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo05Sooooo0_l0000B
ooooo`03o`000?oooooo000003Kooooo00?o0000ooooooooool02Oooool00004ooooool0003o0000
o`0000Cooooo0_l00004ooooo`;o00001?ooool2o`0000Kooooo00?o0000ooooooooool01oooool0
0ol0003oooooooooo`07ooooo`03o`000?oooooooooo00oooooo00?o0000ooooooooool03?ooool0
0ol0003oooooooooo`03o`0000Oooooo00?o0000ooooooooool0=Oooool00ol0003oooooooooo`04
ooooo`03o`000?oooooooooo03Oooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`1H
ooooo`;o00004_ooool00ol0003oooooo`00000fooooo`03o`000?oooooooooo00Wooooo0002oooo
o`03o`000?oooooooooo00;ooooo00Co0000oooooooooooo00000_ooool01?l0003oooooooooool0
0002ooooo`04o`000?ooooooooooo`0000Gooooo00?o0000ooooooooool01oooool00ol0003ooooo
ooooo`07ooooo`03o`000?oooooooooo00oooooo00?o0000ooooooooool03?ooool00ol0003ooooo
o`000004o`0000Kooooo00?o0000ooooooooool0=Oooool00ol0003oooooooooo`04ooooo`03o`00
0?oooooooooo03Oooooo0_l00003ooooo`03o`000?oooooooooo05Sooooo0ol0000Aooooo`03o`00
0?oooooo000003Kooooo00?o0000ooooooooool02Oooool000;ooooo00?o0000ooooooooool00_oo
ool01?l0003oooooooooool00002ooooo`04o`000?ooooooooooo`0000;ooooo00Co0000oooooooo
oooo00001Oooool4o`0000Kooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`0?oooo
o`03o`000?oooooooooo00_ooooo2Ol00005ooooo`03o`000?oooooooooo03Gooooo00?o0000oooo
ooooool01?ooool00ol0003oooooooooo`0gooooo`?o00000_ooool00ol0003oooooooooo`1Goooo
o`Co00004_ooool2o`0003Kooooo00?o0000ooooooooool02Oooool000;ooooo00?o0000oooooooo
ool00_ooool01?l0003oooooooooool00002ooooo`04o`000?ooooooooooo`0000;ooooo00Co0000
oooooooooooo00001Oooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Oooooo00?o
0000ooooooooool03oooool00ol0003oooooooooo`0:ooooo`[o00001Oooool00ol0003ooooooooo
o`0eooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool0=_ooool5o`000003ooooool0
003ooooo05Oooooo1_l0000Aooooo`;o0000=_ooool00ol0003oooooooooo`09ooooo`000_ooool0
0ol0003oooooooooo`02ooooo`04o`000?ooooooooooo`0000;ooooo00Co0000oooooooooooo0000
0_ooool01?l0003oooooooooool00005ooooo`03o`000?oooooooooo00Oooooo00?o0000oooooooo
ool01oooool00ol0003oooooooooo`0?ooooo`03o`000?oooooooooo00[ooooo2_l00005ooooo`03
o`000?oooooooooo03Gooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`0eooooo`So
0000Eoooool7o`00017ooooo0_l0000fooooo`03o`000?oooooooooo00Wooooo00000ooooooo0000
o`000004ooooo`04o`000?ooooooooooo`0000;ooooo00Co0000oooooooooooo00000_ooool01?l0
003oooooooooool00005ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool01oooool0
0ol0003oooooooooo`0?ooooo`03o`000?oooooooooo00Wooooo2_l00006ooooo`03o`000?oooooo
oooo03Gooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`0dooooo`Wo0000F?ooool6
o`00017ooooo0_l0000fooooo`03o`000?oooooooooo00Wooooo0002ooooo`03o`000?oooooooooo
00?ooooo0_l00004ooooo`;o00001?ooool2o`0000Kooooo00?o0000ooooooooool01oooool00ol0
003oooooooooo`07ooooo`03o`000?oooooooooo00oooooo00?o0000ooooooooool02_ooool8o`00
00Oooooo00?o0000ooooooooool0=Oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo
03Gooooo2?l0001Iooooo`Co00004_ooool3o`0003Gooooo00?o0000ooooooooool02Oooool001co
oooo00?o0000ooooooooool01oooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00oo
oooo00?o0000ooooooooool02oooool4o`000003ooooool0003ooooo00Oooooo00?o0000oooooooo
ool0=Oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo03Kooooo1Ol000000ooooooo
0000ooooo`1Iooooo`;o00004_ooool5o`0003Cooooo00?o0000ooooooooool02Oooool001cooooo
00?o0000ooooooooool01oooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00oooooo
00?o0000ooooooooool02oooool3o`0000;ooooo00?o0000ooooooooool01_ooool00ol0003ooooo
ooooo`0eooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool0=oooool3o`0000;ooooo
00?o0000ooooooooool0FOooool00ol0003oooooooooo`0?ooooo`Oo0000<oooool00ol0003ooooo
ooooo`09ooooo`007?ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Oooooo00?o
0000ooooooooool03oooool00ol0003oooooooooo`0<ooooo`05o`000?ooooooooooooooool00000
2?ooool00ol0003oooooooooo`0eooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool0
>?ooool2o`0000;ooooo00?o0000ooooooooool0J_ooool8o`0003?ooooo00?o0000ooooooooool0
2Oooool001cooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`08ooooo`03o`000?oo
oooooooo00kooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`05ooooo`03o`000?oo
oooooooo03Kooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`0iooooo`04o`000?oo
ooooooooo`0006gooooo1ol0000cooooo`03o`000?oooooooooo00Wooooo000Looooo`?o00001ooo
ool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00kooooo00?o0000ooooooooool04Ooo
ool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo03Kooooo00?o0000ooooooooool00ooo
ool00ol0003oooooooooo`0iooooo`04o`000?ooooooooooo`0006kooooo1Ol0000dooooo`03o`00
0?oooooooooo00Wooooo000Looooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02?oo
ool00ol0003oooooooooo`0>ooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool01Ooo
ool00ol0003oooooooooo`0fooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool0>Ooo
ool01?l0003oooooooooool0001_ooooo`?o0000=Oooool00ol0003oooooooooo`09ooooo`007?oo
ool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool03_oo
ool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool0=_oo
ool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo03Wooooo00Co0000oooooooooooo0000
L?ooool00ol0003oooooooooo`0dooooo`03o`000?oooooooooo00Wooooo000Looooo`03o`000?oo
oooooooo00Oooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`0>ooooo`03o`000?oo
oooooooo017ooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`0fooooo`03o`000?oo
oooooooo00?ooooo00?o0000ooooooooool0>Oooool01?l0003oooooooooool0002Wooooo`03o`00
0?oooooooooo00Wooooo000Looooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool01ooo
ool3o`0000oooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`05ooooo`03o`000?oo
oooooooo03Kooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`0iooooo`03o`000?oo
oooo00000:Sooooo00?o0000ooooooooool02Oooool001cooooo00?o0000ooooooooool01oooool0
0ol0003oooooooooo`06ooooo`Go00003_ooool00ol0003oooooooooo`0Aooooo`03o`000?oooooo
oooo00Gooooo00?o0000ooooooooool0=_ooool00ol0003oooooooooo`03ooooo`03o`000?oooooo
oooo03Wooooo00?o0000ooooool00000Z?ooool00ol0003oooooooooo`09ooooo`007?ooool00ol0
003oooooooooo`07ooooo`03o`000?oooooooooo00Kooooo1_l0000=ooooo`03o`000?oooooooooo
017ooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`0fooooo`03o`000?oooooooooo
00?ooooo00?o0000ooooooooool0>Oooool00ol0003oooooo`00002Xooooo`03o`000?oooooooooo
00Wooooo000Looooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool01Oooool7o`0000go
oooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo03Ko
oooo00?o0000ooooooooool00oooool00ol0003oooooooooo`0jooooo`;o0000Z?ooool00ol0003o
ooooooooo`09ooooo`007?ooool3o`0000Oooooo00?o0000ooooooooool01_ooool6o`0000gooooo
00?o0000ooooooooool04Oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo03Kooooo
00?o0000ooooooooool00oooool00ol0003oooooooooo`0jooooo`;o0000Z?ooool00ol0003ooooo
ooooo`09ooooo`007?ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Oooooo1?l0
000=ooooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool01Oooool00ol0003ooooooooo
o`0fooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool0>_ooool2o`000:Sooooo00?o
0000ooooooooool02Oooool001cooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`07
ooooo`?o00003_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo00Cooooo00?o0000
ooooooooool0>?ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo03[ooooo0_l0002X
ooooo`03o`000?oooooooooo00Wooooo000Looooo`03o`000?oooooooooo00Oooooo00?o0000oooo
ooooool02?ooool00ol0003oooooooooo`0=ooooo`03o`000?oooooooooo01;ooooo00?o0000oooo
ooooool01?ooool00ol0003oooooooooo`0hooooo`03o`000?oooooooooo00;ooooo00?o0000oooo
ooooool0>_ooool2o`000:Sooooo00?o0000ooooooooool02Oooool001cooooo00?o0000oooooooo
ool01oooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo00cooooo00?o0000oooooooo
ool04_ooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo03Sooooo00?o0000oooooooo
ool00_ooool00ol0003oooooooooo`0jooooo`;o0000Z?ooool00ol0003oooooooooo`09ooooo`00
7?ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool0
3?ooool00ol0003oooooooooo`0Cooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool0
=oooool3o`0000?ooooo00?o0000ooooooooool0>_ooool2o`000:Sooooo00?o0000ooooooooool0
2Oooool001cooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`09ooooo`03o`000?oo
oooooooo00cooooo00?o0000ooooooooool04oooool00ol0003oooooooooo`03ooooo`03o`000?oo
oooooooo03Kooooo1Ol00002ooooo`03o`000?oooooooooo03[ooooo0_l0002Xooooo`03o`000?oo
oooooooo00Wooooo000Looooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02Oooool0
0ol0003oooooooooo`0<ooooo`03o`000?oooooooooo01?ooooo00?o0000ooooooooool00oooool0
0ol0003oooooooooo`0eooooo`Oo000000?oooooo`000?ooool0>oooool2o`000:Sooooo00?o0000
ooooooooool02Oooool001cooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`09oooo
o`03o`000?oooooooooo00cooooo00?o0000ooooooooool04oooool00ol0003oooooooooo`03oooo
o`03o`000?oooooooooo03Cooooo2?l000000ooooooo0000ooooo`0looooo`03o`000?oooooooooo
0:Kooooo00?o0000ooooooooool02Oooool001cooooo0ol00007ooooo`03o`000?oooooooooo00Wo
oooo00?o0000ooooooooool03?ooool00ol0003oooooooooo`0Cooooo`03o`000?oooooooooo00?o
oooo00?o0000ooooooooool0=Oooool7o`000003ooooool0003ooooo03cooooo00?o0000oooooooo
ool0Y_ooool00ol0003oooooooooo`09ooooo`007?ooool00ol0003oooooooooo`07ooooo`03o`00
0?oooooooooo00Wooooo00?o0000ooooooooool03?ooool00ol0003oooooooooo`0Cooooo`03o`00
0?oooooooooo00?ooooo00?o0000ooooooooool0=_ooool5o`0000;ooooo00?o0000ooooooooool0
>_ooool3o`000:Oooooo00?o0000ooooooooool02Oooool001cooooo00?o0000ooooooooool01ooo
ool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo00cooooo00?o0000ooooooooool04ooo
ool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo03Oooooo0ol00003ooooo`03o`000?oo
oooooooo03Wooooo1Ol0002Vooooo`03o`000?oooooooooo00Wooooo000Looooo`03o`000?oooooo
oooo00Oooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`0<ooooo`03o`000?oooooo
oooo01?ooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`0hooooo`;o00000oooool0
0ol0003oooooooooo`0iooooo`Ko0000YOooool00ol0003oooooooooo`09ooooo`007?ooool00ol0
003oooooooooo`07ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02oooool00ol0
003oooooooooo`0Cooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool0>Oooool01Ol0
003ooooooooooooooooo000003[ooooo1ol0002Uooooo`03o`000?oooooooooo00Wooooo000Loooo
o`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0;oooo
o`03o`000?oooooooooo01?ooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`0ioooo
o`05o`000?ooooooooooooooool00000>oooool6o`000:Kooooo00?o0000ooooooooool02?ooool0
0004ooooool0003o0000o`0000;ooooo1Ol00003ooooo`;o00001?ooool2o`0000Kooooo00?o0000
ooooooooool01oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00_ooooo00?o0000
ooooooooool04oooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo03Wooooo00Go0000
ooooooooooooooooo`00000looooo`Co0000Yoooool00ol0003oooooooooo`08ooooo`000_ooool0
0ol0003oooooooooo`02ooooo`04o`000?ooooooooooo`0000;ooooo00Co0000oooooooooooo0000
0_ooool01?l0003oooooooooool00005ooooo`03o`000?oooooooooo00Oooooo00?o0000oooooooo
ool02_ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo01?ooooo00?o0000oooooooo
ool00oooool00ol0003oooooooooo`0iooooo`05o`000?ooooooooooooooool00000??ooool3o`00
0:Sooooo00?o0000ooooooooool02?ooool000;ooooo00?o0000ooooooooool00oooool00ol0003o
ooooooooo`02ooooo`04o`000?ooooooooooo`0000;ooooo00Co0000oooooooooooo00001Oooool4
o`0000Kooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooo
oooo01?ooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`0iooooo`04o`000?oooooo
ooooo`0003kooooo00?o0000ooooooooool0Yoooool00ol0003oooooooooo`08ooooo`000_ooool0
0ol0003oooooooooo`04ooooo`05o`000?ooooooooooooooool000000_ooool01?l0003ooooooooo
ool00002ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool01oooool00ol0003ooooo
ooooo`0:ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool04oooool00ol0003ooooo
ooooo`03ooooo`03o`000?oooooooooo03Wooooo00Co0000oooooooooooo0000j?ooool00ol0003o
ooooooooo`08ooooo`000_ooool01Ol0003ooooooooooooooooo000000?ooooo00Co0000oooooooo
oooo00000_ooool01?l0003oooooooooool00002ooooo`03o`000?oooooooooo00?ooooo00?o0000
ooooooooool01oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00_ooooo00?o0000
ooooooooool04oooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo03Wooooo00Co0000
oooooooooooo0000j?ooool00ol0003oooooooooo`08ooooo`0000?oooooo`000?l000000oooool0
1Ol0003ooooooooooooooooo000000;ooooo00Co0000oooooooooooo00000_ooool01?l0003ooooo
ooooool00005ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02_ooool00ol0003o
ooooooooo`0;ooooo`03o`000?oooooooooo01Cooooo00?o0000ooooooooool00_ooool00ol0003o
ooooooooo`0iooooo`04o`000?ooooooooooo`000>Sooooo00?o0000ooooooooool02?ooool000;o
oooo00?o0000ooooooooool00_ooool3o`0000Cooooo0_l00004ooooo`;o00001_ooool00ol0003o
ooooooooo`07ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02oooool00ol0003o
ooooooooo`0Dooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0>_ooool00ol0003o
ooooo`00003Xooooo`03o`000?oooooooooo00Sooooo000Looooo`03o`000?oooooooooo00Oooooo
00?o0000ooooooooool02oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo01Cooooo
00?o0000ooooooooool00_ooool00ol0003oooooooooo`0jooooo`03o`000?oooooo00000>Sooooo
00?o0000ooooooooool02?ooool001cooooo00?o0000ooooooooool01oooool00ol0003ooooooooo
o`0;ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool05?ooool00ol0003ooooooooo
o`02ooooo`03o`000?oooooooooo03[ooooo00?o0000ooooool00000j?ooool00ol0003ooooooooo
o`08ooooo`007?ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00_ooooo00?o0000
ooooooooool02_ooool00ol0003oooooooooo`0Cooooo`?o00000oooool00ol0003oooooooooo`0j
ooooo`03o`000?oooooo00000>Sooooo00?o0000ooooooooool02?ooool001cooooo00?o0000oooo
ooooool01oooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00[ooooo00?o0000oooo
ooooool04_ooool5o`0000;ooooo00?o0000ooooooooool0>_ooool00ol0003oooooo`00003Xoooo
o`03o`000?oooooooooo00Sooooo000Looooo`?o00001oooool00ol0003oooooooooo`0;ooooo`03
o`000?oooooooooo00[ooooo00?o0000ooooooooool04_ooool6o`000003ooooool0003ooooo03_o
oooo00?o0000ooooool00000j?ooool00ol0003oooooooooo`08ooooo`007?ooool00ol0003ooooo
ooooo`07ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool02_ooool00ol0003ooooo
ooooo`0Aooooo`Oo000000?oooooo`000?ooool0>oooool00ol0003oooooo`00003Xooooo`03o`00
0?oooooooooo00Sooooo000Looooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02ooo
ool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo01;ooooo1_l000000ooooooo0000oooo
o`0kooooo`03o`000?oooooo00000>Sooooo00?o0000ooooooooool02?ooool001cooooo00?o0000
ooooooooool01oooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00[ooooo00?o0000
ooooooooool04oooool4o`0000;ooooo00?o0000ooooooooool0>_ooool00ol0003oooooo`00003X
ooooo`03o`000?oooooooooo00Sooooo000Looooo`03o`000?oooooooooo00Oooooo00?o0000oooo
ooooool02oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo01?ooooo0ol00003oooo
o`03o`000?oooooooooo03_ooooo0_l0003Wooooo`?o00002Oooool001cooooo00?o0000oooooooo
ool01oooool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo00Wooooo00?o0000oooooooo
ool05?ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo03_ooooo0_l0003Vooooo`Go
00002?ooool001cooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`0<ooooo`03o`00
0?oooooooooo00Wooooo00?o0000ooooooooool05?ooool00ol0003oooooooooo`02ooooo`03o`00
0?oooooooooo03_ooooo0_l0003Vooooo`Ko00001oooool001cooooo00?o0000ooooooooool01ooo
ool00ol0003oooooooooo`0;ooooo`?o00002_ooool00ol0003oooooooooo`0Eooooo`05o`000?oo
ooooooooooooool00000?Oooool2o`000>Gooooo1ol00007ooooo`007?ooool01Ol0003ooooooooo
oooooooo000000Gooooo00?o0000ooooooooool02_ooool5o`000003ooooool0003ooooo00Kooooo
00?o0000ooooooooool05Oooool01Ol0003ooooooooooooooooo000003gooooo0_l0003Vooooo`Ko
00001oooool001cooooo1_l00004ooooo`03o`000?oooooooooo00Wooooo2Ol00006ooooo`03o`00
0?oooooooooo01Gooooo00Go0000ooooooooooooooooo`00000mooooo`;o0000ioooool4o`0000So
oooo000Looooo`03o`000?oooooo000000Co00000oooool00ol0003oooooooooo`08ooooo`[o0000
1_ooool00ol0003oooooooooo`0Eooooo`05o`000?ooooooooooooooool00000?Oooool2o`000>Oo
oooo0ol00009ooooo`007?ooool8o`0000;ooooo00?o0000ooooooooool02Oooool:o`0000Gooooo
00?o0000ooooooooool05Oooool01Ol0003ooooooooooooooooo000003gooooo0_l0003Xooooo`03
o`000?oooooooooo00Sooooo000Looooo`So00000_ooool00ol0003oooooooooo`0:ooooo`Wo0000
1Oooool00ol0003oooooooooo`0Eooooo`05o`000?ooooooooooooooool00000?Oooool2o`000??o
oooo000Looooo`So00000_ooool00ol0003oooooooooo`0;ooooo`So00001Oooool00ol0003ooooo
ooooo`0Eooooo`05o`000?ooooooooooooooool00000?_ooool00ol0003oooooooooo`3aooooo`00
7?ooool00ol0003oooooo`000004o`0000?ooooo00?o0000ooooooooool03?ooool00ol0003ooooo
o`000003o`0000Kooooo00?o0000ooooooooool05Oooool01Ol0003ooooooooooooooooo000003ko
oooo00?o0000ooooooooool0lOooool001cooooo00?o0000ooooooooool00ol00004ooooo`03o`00
0?oooooooooo00oooooo0_l00007ooooo`03o`000?oooooooooo01Gooooo00Go0000oooooooooooo
ooooo`00000mooooo`?o0000l_ooool001cooooo00Go0000ooooooooooooooooo`000005ooooo`03
o`000?oooooooooo013ooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`0Eooooo`05
o`000?ooooooooooooooool00000??ooool4o`000?;ooooo000Looooo`?o000000?oooooo`000?oo
ool01?ooool00ol0003oooooooooo`0@ooooo`03o`000?oooooooooo00Gooooo00?o0000oooooooo
ool05Oooool01Ol0003ooooooooooooooooo000003_ooooo1_l0003aooooo`007?ooool01Ol0003o
oooooooooooooooo000000Gooooo00?o0000ooooooooool04?ooool00ol0003oooooooooo`05oooo
o`03o`000?oooooooooo01Kooooo00Co0000oooooooooooo0000>_ooool7o`000?7ooooo000Loooo
o`05o`000?ooooooooooooooool000001Oooool00ol0003oooooooooo`0@ooooo`03o`000?oooooo
oooo00Gooooo00?o0000ooooooooool05_ooool01?l0003oooooooooool0000kooooo`Ko0000lOoo
ool001cooooo00Go0000ooooooooooooooooo`000005ooooo`03o`000?oooooooooo013ooooo00?o
0000ooooooooool01Oooool00ol0003oooooooooo`0Fooooo`04o`000?ooooooooooo`0003cooooo
1?l0003booooo`007?ooool01Ol0003ooooooooooooooooo000000Gooooo00?o0000ooooooooool0
4?ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo01Kooooo00Co0000oooooooooooo
0000?Oooool2o`000??ooooo000Looooo`05o`000?ooooooooooooooool000001Oooool00ol0003o
ooooooooo`0Aooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool05_ooool01?l0003o
ooooooooool0000nooooo`03o`000?oooooooooo0?7ooooo00001?oooooo0000o`000?l00004oooo
o`?o00000oooool2o`0000Cooooo0_l00006ooooo`05o`000?ooooooooooooooool000001Oooool0
0ol0003oooooooooo`0Aooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool05_ooool0
0ol0003oooooo`00003oooooocCooooo0002ooooo`03o`000?oooooooooo00Cooooo00Go0000oooo
ooooooooooooo`000002ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000ooooooooool00ooo
ool01Ol0003ooooooooooooooooo000000Gooooo00?o0000ooooooooool04Oooool00ol0003ooooo
ooooo`04ooooo`03o`000?oooooooooo01Kooooo00?o0000ooooool00000ooooooldooooo`000_oo
ool01?l0003oooooooooooooool5o`0000;ooooo00Co0000oooooooooooo00000_ooool01?l0003o
ooooooooool00005ooooo`05o`000?ooooooooooooooool000001Oooool00ol0003oooooooooo`0A
ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool05_ooool00ol0003oooooo`00003o
ooooocCooooo0002ooooo`05o`000?ooooooooooooooool000000_ooool01Ol0003ooooooooooooo
oooo000000;ooooo00Co0000oooooooooooo00000_ooool00ol0003oooooooooo`03ooooo`Go0000
1Oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool0
5_ooool00ol0003oooooo`00003oooooocCooooo0002ooooo`03o`000?oooooooooo00;ooooo00?o
0000ooooool000000oooool01?l0003oooooooooool00002ooooo`04o`000?ooooooooooo`0000Go
oooo00Go0000ooooooooooooooooo`000005ooooo`03o`000?oooooooooo017ooooo00?o0000oooo
ooooool01?ooool00ol0003oooooooooo`0Fooooo`03o`000?oooooo00000?oooooo=?ooool00003
ooooool0003o000000Gooooo0_l00003ooooo`04o`000?ooooooooooo`0000;ooooo00Co0000oooo
oooooooo00001Oooool01Ol0003ooooooooooooooooo000000Cooooo00?o0000ooooooooool04_oo
ool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo01Kooooo00?o0000ooooool00000oooo
ooldooooo`000_ooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00;ooooo0_l00004
ooooo`;o00001_ooool01Ol0003ooooooooooooooooo000000Cooooo00?o0000ooooooooool04_oo
ool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo01Kooooo00?o0000ooooool00000oooo
ooldooooo`007?ooool01Ol0003ooooooooooooooooo000000Cooooo00?o0000ooooooooool04_oo
ool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo01Oooooo0_l0003oooooocCooooo000L
ooooo`05o`000?ooooooooooooooool000001?ooool00ol0003oooooooooo`0Booooo`03o`000?oo
oooooooo00Cooooo00?o0000ooooooooool05oooool2o`000?oooooo=?ooool001cooooo00Go0000
ooooooooooooooooo`000004ooooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool01?oo
ool00ol0003oooooooooo`0Gooooo`;o0000ooooooldooooo`007?ooool01Ol0003ooooooooooooo
oooo000000Cooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`04ooooo`03o`000?oo
oooooooo01Oooooo0_l0003oooooocCooooo000Looooo`?o000000?oooooo`000?ooool00oooool0
0ol0003oooooooooo`0Booooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool05oooool2
o`000?oooooo=?ooool001cooooo00Go0000ooooooooooooooooo`000004ooooo`03o`000?oooooo
oooo01;ooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`0Gooooo`;o0000oooooold
ooooo`007?ooool01Ol0003ooooooooooooooooo000000Cooooo00?o0000ooooooooool04_ooool0
0ol0003oooooooooo`04ooooo`03o`000?oooooooooo01Oooooo0_l0003oooooocCooooo000Loooo
o`05o`000?ooooooooooooooool000001?ooool00ol0003oooooooooo`0Booooo`03o`000?oooooo
oooo00Cooooo00?o0000ooooooooool05oooool2o`000?oooooo=?ooool001cooooo00Go0000oooo
ooooooooooooo`000004ooooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool01?ooool0
0ol0003oooooooooo`0Gooooo`;o0000ooooooldooooo`007?ooool01Ol0003ooooooooooooooooo
000000Cooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`04ooooo`03o`000?oooooo
oooo01Oooooo0_l0003oooooocCooooo000Looooo`05o`000?ooooooooooooooool000001?ooool0
0ol0003oooooooooo`0Booooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool05oooool2
o`000?oooooo=?ooool001cooooo00Go0000ooooooooooooooooo`000004ooooo`03o`000?oooooo
oooo01;ooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`0Hooooo`03o`000?oooooo
oooo0?oooooo<_ooool001cooooo00Go0000ooooooooooooooooo`000004ooooo`03o`000?oooooo
oooo01;ooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`0Hooooo`03o`000?oooooo
oooo0?oooooo<_ooool001cooooo0ol000000ooooooo0000ooooo`03ooooo`03o`000?oooooooooo
01?ooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`0Hooooo`03o`000?oooooooooo
0?oooooo<_ooool001cooooo00Go0000ooooooooooooooooo`000004ooooo`03o`000?oooooooooo
01?ooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`0Gooooo`?o0000oooooolcoooo
o`007?ooool01Ol0003ooooooooooooooooo000000Cooooo00?o0000ooooooooool04oooool00ol0
003oooooooooo`02ooooo`03o`000?oooooooooo01Oooooo1Ol0003ooooooc;ooooo000Looooo`03
o`000?oooooooooo00;ooooo00Go0000ooooooooooooooooo`00000Eooooo`03o`000?oooooooooo
00;ooooo00?o0000ooooooooool05_ooool7o`000?oooooo<Oooool001cooooo00?o0000oooooooo
ool00_ooool01Ol0003ooooooooooooooooo000001Gooooo00?o0000ooooooooool00_ooool00ol0
003oooooooooo`0Eooooo`So0000oooooolaooooo`007?ooool00ol0003oooooooooo`02ooooo`05
o`000?ooooooooooooooool000005Oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo
01Kooooo1ol0003ooooooc7ooooo000Looooo`03o`000?oooooooooo00;ooooo00Go0000oooooooo
ooooooooo`00000Eooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool05oooool5o`00
0?oooooo<_ooool001cooooo00?o0000ooooooooool00_ooool01Ol0003ooooooooooooooooo0000
01Gooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`0Hooooo`?o0000oooooolcoooo
o`007?ooool00ol0003oooooooooo`02ooooo`05o`000?ooooooooooooooool000005Oooool00ol0
003oooooooooo`02ooooo`03o`000?oooooooooo01Wooooo00?o0000ooooooooool0oooooolboooo
o`007?ooool3o`0000;ooooo00Go0000ooooooooooooooooo`00000Eooooo`03o`000?oooooooooo
00;ooooo00?o0000ooooooooool0oooooom>ooooo`007?ooool00ol0003oooooooooo`02ooooo`05
o`000?ooooooooooooooool000005Oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo
0?ooooooC_ooool001cooooo00?o0000ooooooooool00_ooool01Ol0003ooooooooooooooooo0000
01Gooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`3oooooodkooooo000Looooo`03
o`000?oooooooooo00;ooooo00Go0000ooooooooooooooooo`00000Eooooo`03o`000?oooooooooo
00;ooooo00?o0000ooooooooool0oooooom>ooooo`007?ooool00ol0003oooooooooo`02ooooo`05
o`000?ooooooooooooooool000005Oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo
0?ooooooC_ooool001cooooo00?o0000ooooooooool00_ooool01Ol0003ooooooooooooooooo0000
01Gooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`3oooooodkooooo00001?oooooo
0000o`000?l00003ooooo`?o00001?ooool2o`0000Cooooo0_l00006ooooo`03o`000?oooooooooo
00;ooooo00Go0000ooooooooooooooooo`00000Eooooo`03o`000?oooooooooo00;ooooo00?o0000
ooooooooool0oooooom>ooooo`000_ooool01Ol0003ooooooooooooooooo000000?ooooo00Co0000
oooooooooooo00000_ooool01?l0003oooooooooool00002ooooo`03o`000?oooooooooo00?ooooo
00?o0000ooooooooool00_ooool01Ol0003ooooooooooooooooo000001Gooooo00?o0000oooooooo
ool00_ooool00ol0003oooooooooo`3oooooodkooooo0002ooooo`05o`000?ooooooooooooooool0
00000oooool01?l0003oooooooooool00002ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000
ooooooooool00oooool4o`000003ooooool0003ooooo00;ooooo00?o0000ooooooooool04oooool0
0ol0003oooooooooo`02ooooo`03o`000?oooooooooo0?ooooooC_ooool000;ooooo00Co0000oooo
oooooooooooo1?l00003ooooo`04o`000?ooooooooooo`0000;ooooo00Co0000oooooooooooo0000
1Oooool00ol0003oooooooooo`02ooooo`05o`000?ooooooooooooooool000005Oooool00ol0003o
ooooooooo`02ooooo`03o`000?oooooooooo0?ooooooC_ooool000;ooooo00Go0000oooooooooooo
ooooo`000006ooooo`04o`000?ooooooooooo`0000;ooooo00Co0000oooooooooooo00001Oooool0
0ol0003oooooooooo`02ooooo`05o`000?ooooooooooooooool000005Oooool00ol0003ooooooooo
o`02ooooo`03o`000?oooooooooo0?ooooooC_ooool00003ooooool0003o000000Cooooo00?o0000
ooooooooool00oooool01?l0003oooooooooool00002ooooo`04o`000?ooooooooooo`0000Gooooo
00?o0000ooooooooool00_ooool01Ol0003ooooooooooooooooo000001Gooooo00?o0000oooooooo
ool00_ooool00ol0003oooooooooo`3oooooodkooooo0002ooooo`03o`000?oooooooooo00?ooooo
0_l00004ooooo`;o00001?ooool2o`0000Kooooo00?o0000ooooooooool00_ooool01Ol0003ooooo
oooooooooooo000001Kooooo00Go0000ooooooooooooooooo`00003ooooooe3ooooo000Looooo`03
o`000?oooooooooo00;ooooo00Go0000ooooooooooooooooo`00000Fooooo`05o`000?oooooooooo
ooooool00000oooooom@ooooo`007?ooool00ol0003oooooooooo`02ooooo`05o`000?oooooooooo
ooooool000005_ooool01Ol0003ooooooooooooooooo00000?ooooooD?ooool001cooooo00?o0000
ooooooooool00_ooool01Ol0003ooooooooooooooooo000001Kooooo00Go0000oooooooooooooooo
o`00003ooooooe3ooooo000Looooo`03o`000?oooooooooo00;ooooo00Go0000oooooooooooooooo
o`00000Fooooo`05o`000?ooooooooooooooool00000oooooom@ooooo`007?ooool3o`0000;ooooo
00Go0000ooooooooooooooooo`00000Fooooo`05o`000?ooooooooooooooool00000oooooom@oooo
o`007?ooool00ol0003oooooooooo`02ooooo`05o`000?ooooooooooooooool000005_ooool01Ol0
003ooooooooooooooooo00000?ooooooD?ooool001cooooo00?o0000ooooooooool00_ooool01Ol0
003ooooooooooooooooo000001Kooooo00Go0000ooooooooooooooooo`00003ooooooe3ooooo000L
ooooo`03o`000?oooooooooo00;ooooo00Go0000ooooooooooooooooo`00000Eooooo`?o00000_oo
ool00ol0003oooooooooo`3oooooodkooooo000Looooo`03o`000?oooooooooo00;ooooo00Go0000
ooooooooooooooooo`00000Dooooo`Go000000?oooooo`000?ooool0oooooom?ooooo`007?ooool0
0ol0003oooooooooo`02ooooo`05o`000?ooooooooooooooool000004oooool8o`000?ooooooD?oo
ool001cooooo00?o0000ooooooooool00_ooool01Ol0003ooooooooooooooooo000001;ooooo2Ol0
003ooooooe3ooooo000Looooo`03o`000?oooooooooo00;ooooo00Go0000ooooooooooooooooo`00
000Cooooo`So0000oooooom@ooooo`007?ooool3o`0000;ooooo00Go0000ooooooooooooooooo`00
000Dooooo`Go000000?oooooo`000?ooool0oooooom?ooooo`007?ooool00ol0003oooooooooo`02
ooooo`05o`000?ooooooooooooooool000005Oooool3o`0000;ooooo00?o0000ooooooooool0oooo
oom>ooooo`007?ooool00ol0003oooooooooo`02ooooo`05o`000?ooooooooooooooool000005_oo
ool01Ol0003ooooooooooooooooo00000?ooooooD?ooool00?ooooooTOooool00?ooooooTOooool0
0?ooooooTOooool00001\
\>"],
  ImageRangeCache->{{{0, 399}, {246.188, 0}} -> {-8.11617, 297.374, 0.282373, \
5.81884}}]
}, Open  ]],

Cell["\<\
Si ottiene per\[OGrave] un risultato migliore tracciando queste \
righe con uno stile tratteggiato e con uno spessore pi\[UGrave] piccolo, in \
modo da non \"affollare\" troppo il grafico:\
\>", "Text",
  PageWidth->PaperWidth],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(MultipleListPlot[ion, 
        SymbolShape \[Rule] {enlarge[PlotSymbol[Diamond], 2]}, 
        PlotJoined \[Rule] True, 
        PlotStyle \[Rule] {{AbsoluteThickness[0.25], 
              AbsoluteDashing[{5}]}}];\)\)], "Input",
  CellLabel->"In[32]:=",
  PageWidth->PaperWidth],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
%%ImageSize: 400 247.214 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.00933707 -0.155516 0.000453103 [
[.21055 .01323 -6 -9 ]
[.21055 .01323 6 0 ]
[.39729 .01323 -6 -9 ]
[.39729 .01323 6 0 ]
[.58403 .01323 -6 -9 ]
[.58403 .01323 6 0 ]
[.77077 .01323 -6 -9 ]
[.77077 .01323 6 0 ]
[.95752 .01323 -9 -9 ]
[.95752 .01323 9 0 ]
[.01131 .11635 -18 -4.5 ]
[.01131 .11635 0 4.5 ]
[.01131 .20697 -18 -4.5 ]
[.01131 .20697 0 4.5 ]
[.01131 .29759 -24 -4.5 ]
[.01131 .29759 0 4.5 ]
[.01131 .38821 -24 -4.5 ]
[.01131 .38821 0 4.5 ]
[.01131 .47883 -24 -4.5 ]
[.01131 .47883 0 4.5 ]
[.01131 .56945 -24 -4.5 ]
[.01131 .56945 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21055 .02573 m
.21055 .03198 L
s
[(20)] .21055 .01323 0 1 Mshowa
.39729 .02573 m
.39729 .03198 L
s
[(40)] .39729 .01323 0 1 Mshowa
.58403 .02573 m
.58403 .03198 L
s
[(60)] .58403 .01323 0 1 Mshowa
.77077 .02573 m
.77077 .03198 L
s
[(80)] .77077 .01323 0 1 Mshowa
.95752 .02573 m
.95752 .03198 L
s
[(100)] .95752 .01323 0 1 Mshowa
.125 Mabswid
.07049 .02573 m
.07049 .02948 L
s
.11718 .02573 m
.11718 .02948 L
s
.16387 .02573 m
.16387 .02948 L
s
.25724 .02573 m
.25724 .02948 L
s
.30392 .02573 m
.30392 .02948 L
s
.35061 .02573 m
.35061 .02948 L
s
.44398 .02573 m
.44398 .02948 L
s
.49066 .02573 m
.49066 .02948 L
s
.53735 .02573 m
.53735 .02948 L
s
.63072 .02573 m
.63072 .02948 L
s
.6774 .02573 m
.6774 .02948 L
s
.72409 .02573 m
.72409 .02948 L
s
.81746 .02573 m
.81746 .02948 L
s
.86415 .02573 m
.86415 .02948 L
s
.91083 .02573 m
.91083 .02948 L
s
.25 Mabswid
0 .02573 m
1 .02573 L
s
.02381 .11635 m
.03006 .11635 L
s
[(600)] .01131 .11635 1 0 Mshowa
.02381 .20697 m
.03006 .20697 L
s
[(800)] .01131 .20697 1 0 Mshowa
.02381 .29759 m
.03006 .29759 L
s
[(1000)] .01131 .29759 1 0 Mshowa
.02381 .38821 m
.03006 .38821 L
s
[(1200)] .01131 .38821 1 0 Mshowa
.02381 .47883 m
.03006 .47883 L
s
[(1400)] .01131 .47883 1 0 Mshowa
.02381 .56945 m
.03006 .56945 L
s
[(1600)] .01131 .56945 1 0 Mshowa
.125 Mabswid
.02381 .04838 m
.02756 .04838 L
s
.02381 .07104 m
.02756 .07104 L
s
.02381 .09369 m
.02756 .09369 L
s
.02381 .139 m
.02756 .139 L
s
.02381 .16166 m
.02756 .16166 L
s
.02381 .18431 m
.02756 .18431 L
s
.02381 .22962 m
.02756 .22962 L
s
.02381 .25228 m
.02756 .25228 L
s
.02381 .27493 m
.02756 .27493 L
s
.02381 .32024 m
.02756 .32024 L
s
.02381 .3429 m
.02756 .3429 L
s
.02381 .36555 m
.02756 .36555 L
s
.02381 .41086 m
.02756 .41086 L
s
.02381 .43352 m
.02756 .43352 L
s
.02381 .45617 m
.02756 .45617 L
s
.02381 .50148 m
.02756 .50148 L
s
.02381 .52414 m
.02756 .52414 L
s
.02381 .54679 m
.02756 .54679 L
s
.02381 .00307 m
.02756 .00307 L
s
.02381 .5921 m
.02756 .5921 L
s
.02381 .61476 m
.02756 .61476 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
[ 5 ] 0 Mabsdash
.03315 .43896 m
0 0 rlineto s
.03315 .43896 m
.03663 .61803 L
s
.04582 .61803 m
.05182 .07706 L
.06116 .25201 L
.07049 .20724 L
.07983 .33664 L
.08917 .43456 L
.09851 .43982 L
.10784 .60615 L
s
.10784 .60615 m
.10846 .61803 L
s
.11938 .61803 m
.12652 .06913 L
.13585 .17874 L
.14519 .10611 L
.15453 .20085 L
.16387 .30289 L
.1732 .29741 L
.18254 .41136 L
.19188 .53338 L
.20121 .03424 L
.21055 .11168 L
.21989 .13039 L
.22923 .14263 L
.23856 .139 L
.2479 .14022 L
.25724 .16954 L
.26657 .18853 L
.27591 .18884 L
.28525 .17829 L
.29458 .18223 L
.30392 .25518 L
.31326 .10674 L
.3226 .18979 L
.33193 .27357 L
.34127 .27081 L
.35061 .36098 L
.35994 .45649 L
.36928 .02708 L
.37862 .09346 L
.38796 .1236 L
.39729 .14353 L
.40663 .14534 L
.41597 .15486 L
.4253 .16256 L
.43464 .16664 L
.44398 .17072 L
.45331 .20923 L
.46265 .1757 L
.47199 .24167 L
.48133 .09745 L
.49066 .16555 L
.5 .22224 L
.50934 .23832 L
.51867 .30139 L
.52801 .3748 L
.53735 .01472 L
.54669 .0723 L
.55602 .0883 L
.56536 .08345 L
.5747 .0815 L
Mistroke
.58403 .08445 L
.59337 .0873 L
.60271 .09066 L
.61204 .0922 L
.62138 .11295 L
.63072 .10031 L
.64006 .10361 L
.64939 .1076 L
.65873 .11123 L
.66807 .11485 L
.6774 .11789 L
.68674 .08168 L
.69608 .13538 L
.70542 .1893 L
.71475 .19337 L
.72409 .18884 L
.73343 .22509 L
.74276 .24322 L
.7521 .23868 L
.76144 .24779 L
.77077 .30076 L
.78011 .1115 L
.78945 .16868 L
.79879 .16311 L
.80812 .2124 L
.81746 .26587 L
.8268 .31435 L
.83613 .02573 L
.84547 .07525 L
.85481 .07058 L
.86415 .11046 L
.87348 .10185 L
.88282 .1091 L
.89216 .11499 L
.90149 .10955 L
.91083 .10647 L
.92017 .10774 L
.92951 .1168 L
.93884 .11997 L
.94818 .12496 L
.95752 .12858 L
.96685 .1322 L
.97619 .42627 L
Mfstroke
.0001 w
[ ] 0 setdash
.03315 .43896 -3.75 0 Mabsadd m
.03315 .43896 0 5 Mabsadd L
.03315 .43896 3.75 0 Mabsadd L
.03315 .43896 0 -5 Mabsadd L
.03315 .43896 -3.75 0 Mabsadd L closepath F
.04248 .91938 -3.75 0 Mabsadd m
.04248 .91938 0 5 Mabsadd L
.04248 .91938 3.75 0 Mabsadd L
.04248 .91938 0 -5 Mabsadd L
.04248 .91938 -3.75 0 Mabsadd L closepath F
.05182 .07706 -3.75 0 Mabsadd m
.05182 .07706 0 5 Mabsadd L
.05182 .07706 3.75 0 Mabsadd L
.05182 .07706 0 -5 Mabsadd L
.05182 .07706 -3.75 0 Mabsadd L closepath F
.06116 .25201 -3.75 0 Mabsadd m
.06116 .25201 0 5 Mabsadd L
.06116 .25201 3.75 0 Mabsadd L
.06116 .25201 0 -5 Mabsadd L
.06116 .25201 -3.75 0 Mabsadd L closepath F
.07049 .20724 -3.75 0 Mabsadd m
.07049 .20724 0 5 Mabsadd L
.07049 .20724 3.75 0 Mabsadd L
.07049 .20724 0 -5 Mabsadd L
.07049 .20724 -3.75 0 Mabsadd L closepath F
.07983 .33664 -3.75 0 Mabsadd m
.07983 .33664 0 5 Mabsadd L
.07983 .33664 3.75 0 Mabsadd L
.07983 .33664 0 -5 Mabsadd L
.07983 .33664 -3.75 0 Mabsadd L closepath F
.08917 .43456 -3.75 0 Mabsadd m
.08917 .43456 0 5 Mabsadd L
.08917 .43456 3.75 0 Mabsadd L
.08917 .43456 0 -5 Mabsadd L
.08917 .43456 -3.75 0 Mabsadd L closepath F
.09851 .43982 -3.75 0 Mabsadd m
.09851 .43982 0 5 Mabsadd L
.09851 .43982 3.75 0 Mabsadd L
.09851 .43982 0 -5 Mabsadd L
.09851 .43982 -3.75 0 Mabsadd L closepath F
.10784 .60615 -3.75 0 Mabsadd m
.10784 .60615 0 5 Mabsadd L
.10784 .60615 3.75 0 Mabsadd L
.10784 .60615 0 -5 Mabsadd L
.10784 .60615 -3.75 0 Mabsadd L closepath F
.11718 .78721 -3.75 0 Mabsadd m
.11718 .78721 0 5 Mabsadd L
.11718 .78721 3.75 0 Mabsadd L
.11718 .78721 0 -5 Mabsadd L
.11718 .78721 -3.75 0 Mabsadd L closepath F
.12652 .06913 -3.75 0 Mabsadd m
.12652 .06913 0 5 Mabsadd L
.12652 .06913 3.75 0 Mabsadd L
.12652 .06913 0 -5 Mabsadd L
.12652 .06913 -3.75 0 Mabsadd L closepath F
.13585 .17874 -3.75 0 Mabsadd m
.13585 .17874 0 5 Mabsadd L
.13585 .17874 3.75 0 Mabsadd L
.13585 .17874 0 -5 Mabsadd L
.13585 .17874 -3.75 0 Mabsadd L closepath F
.14519 .10611 -3.75 0 Mabsadd m
.14519 .10611 0 5 Mabsadd L
.14519 .10611 3.75 0 Mabsadd L
.14519 .10611 0 -5 Mabsadd L
.14519 .10611 -3.75 0 Mabsadd L closepath F
.15453 .20085 -3.75 0 Mabsadd m
.15453 .20085 0 5 Mabsadd L
.15453 .20085 3.75 0 Mabsadd L
.15453 .20085 0 -5 Mabsadd L
.15453 .20085 -3.75 0 Mabsadd L closepath F
.16387 .30289 -3.75 0 Mabsadd m
.16387 .30289 0 5 Mabsadd L
.16387 .30289 3.75 0 Mabsadd L
.16387 .30289 0 -5 Mabsadd L
.16387 .30289 -3.75 0 Mabsadd L closepath F
.1732 .29741 -3.75 0 Mabsadd m
.1732 .29741 0 5 Mabsadd L
.1732 .29741 3.75 0 Mabsadd L
.1732 .29741 0 -5 Mabsadd L
.1732 .29741 -3.75 0 Mabsadd L closepath F
.18254 .41136 -3.75 0 Mabsadd m
.18254 .41136 0 5 Mabsadd L
.18254 .41136 3.75 0 Mabsadd L
.18254 .41136 0 -5 Mabsadd L
.18254 .41136 -3.75 0 Mabsadd L closepath F
.19188 .53338 -3.75 0 Mabsadd m
.19188 .53338 0 5 Mabsadd L
.19188 .53338 3.75 0 Mabsadd L
.19188 .53338 0 -5 Mabsadd L
.19188 .53338 -3.75 0 Mabsadd L closepath F
.20121 .03424 -3.75 0 Mabsadd m
.20121 .03424 0 5 Mabsadd L
.20121 .03424 3.75 0 Mabsadd L
.20121 .03424 0 -5 Mabsadd L
.20121 .03424 -3.75 0 Mabsadd L closepath F
.21055 .11168 -3.75 0 Mabsadd m
.21055 .11168 0 5 Mabsadd L
.21055 .11168 3.75 0 Mabsadd L
.21055 .11168 0 -5 Mabsadd L
.21055 .11168 -3.75 0 Mabsadd L closepath F
.21989 .13039 -3.75 0 Mabsadd m
.21989 .13039 0 5 Mabsadd L
.21989 .13039 3.75 0 Mabsadd L
.21989 .13039 0 -5 Mabsadd L
.21989 .13039 -3.75 0 Mabsadd L closepath F
.22923 .14263 -3.75 0 Mabsadd m
.22923 .14263 0 5 Mabsadd L
.22923 .14263 3.75 0 Mabsadd L
.22923 .14263 0 -5 Mabsadd L
.22923 .14263 -3.75 0 Mabsadd L closepath F
.23856 .139 -3.75 0 Mabsadd m
.23856 .139 0 5 Mabsadd L
.23856 .139 3.75 0 Mabsadd L
.23856 .139 0 -5 Mabsadd L
.23856 .139 -3.75 0 Mabsadd L closepath F
.2479 .14022 -3.75 0 Mabsadd m
.2479 .14022 0 5 Mabsadd L
.2479 .14022 3.75 0 Mabsadd L
.2479 .14022 0 -5 Mabsadd L
.2479 .14022 -3.75 0 Mabsadd L closepath F
.25724 .16954 -3.75 0 Mabsadd m
.25724 .16954 0 5 Mabsadd L
.25724 .16954 3.75 0 Mabsadd L
.25724 .16954 0 -5 Mabsadd L
.25724 .16954 -3.75 0 Mabsadd L closepath F
.26657 .18853 -3.75 0 Mabsadd m
.26657 .18853 0 5 Mabsadd L
.26657 .18853 3.75 0 Mabsadd L
.26657 .18853 0 -5 Mabsadd L
.26657 .18853 -3.75 0 Mabsadd L closepath F
.27591 .18884 -3.75 0 Mabsadd m
.27591 .18884 0 5 Mabsadd L
.27591 .18884 3.75 0 Mabsadd L
.27591 .18884 0 -5 Mabsadd L
.27591 .18884 -3.75 0 Mabsadd L closepath F
.28525 .17829 -3.75 0 Mabsadd m
.28525 .17829 0 5 Mabsadd L
.28525 .17829 3.75 0 Mabsadd L
.28525 .17829 0 -5 Mabsadd L
.28525 .17829 -3.75 0 Mabsadd L closepath F
.29458 .18223 -3.75 0 Mabsadd m
.29458 .18223 0 5 Mabsadd L
.29458 .18223 3.75 0 Mabsadd L
.29458 .18223 0 -5 Mabsadd L
.29458 .18223 -3.75 0 Mabsadd L closepath F
.30392 .25518 -3.75 0 Mabsadd m
.30392 .25518 0 5 Mabsadd L
.30392 .25518 3.75 0 Mabsadd L
.30392 .25518 0 -5 Mabsadd L
.30392 .25518 -3.75 0 Mabsadd L closepath F
.31326 .10674 -3.75 0 Mabsadd m
.31326 .10674 0 5 Mabsadd L
.31326 .10674 3.75 0 Mabsadd L
.31326 .10674 0 -5 Mabsadd L
.31326 .10674 -3.75 0 Mabsadd L closepath F
.3226 .18979 -3.75 0 Mabsadd m
.3226 .18979 0 5 Mabsadd L
.3226 .18979 3.75 0 Mabsadd L
.3226 .18979 0 -5 Mabsadd L
.3226 .18979 -3.75 0 Mabsadd L closepath F
.33193 .27357 -3.75 0 Mabsadd m
.33193 .27357 0 5 Mabsadd L
.33193 .27357 3.75 0 Mabsadd L
.33193 .27357 0 -5 Mabsadd L
.33193 .27357 -3.75 0 Mabsadd L closepath F
.34127 .27081 -3.75 0 Mabsadd m
.34127 .27081 0 5 Mabsadd L
.34127 .27081 3.75 0 Mabsadd L
.34127 .27081 0 -5 Mabsadd L
.34127 .27081 -3.75 0 Mabsadd L closepath F
.35061 .36098 -3.75 0 Mabsadd m
.35061 .36098 0 5 Mabsadd L
.35061 .36098 3.75 0 Mabsadd L
.35061 .36098 0 -5 Mabsadd L
.35061 .36098 -3.75 0 Mabsadd L closepath F
.35994 .45649 -3.75 0 Mabsadd m
.35994 .45649 0 5 Mabsadd L
.35994 .45649 3.75 0 Mabsadd L
.35994 .45649 0 -5 Mabsadd L
.35994 .45649 -3.75 0 Mabsadd L closepath F
.36928 .02708 -3.75 0 Mabsadd m
.36928 .02708 0 5 Mabsadd L
.36928 .02708 3.75 0 Mabsadd L
.36928 .02708 0 -5 Mabsadd L
.36928 .02708 -3.75 0 Mabsadd L closepath F
.37862 .09346 -3.75 0 Mabsadd m
.37862 .09346 0 5 Mabsadd L
.37862 .09346 3.75 0 Mabsadd L
.37862 .09346 0 -5 Mabsadd L
.37862 .09346 -3.75 0 Mabsadd L closepath F
.38796 .1236 -3.75 0 Mabsadd m
.38796 .1236 0 5 Mabsadd L
.38796 .1236 3.75 0 Mabsadd L
.38796 .1236 0 -5 Mabsadd L
.38796 .1236 -3.75 0 Mabsadd L closepath F
.39729 .14353 -3.75 0 Mabsadd m
.39729 .14353 0 5 Mabsadd L
.39729 .14353 3.75 0 Mabsadd L
.39729 .14353 0 -5 Mabsadd L
.39729 .14353 -3.75 0 Mabsadd L closepath F
.40663 .14534 -3.75 0 Mabsadd m
.40663 .14534 0 5 Mabsadd L
.40663 .14534 3.75 0 Mabsadd L
.40663 .14534 0 -5 Mabsadd L
.40663 .14534 -3.75 0 Mabsadd L closepath F
.41597 .15486 -3.75 0 Mabsadd m
.41597 .15486 0 5 Mabsadd L
.41597 .15486 3.75 0 Mabsadd L
.41597 .15486 0 -5 Mabsadd L
.41597 .15486 -3.75 0 Mabsadd L closepath F
.4253 .16256 -3.75 0 Mabsadd m
.4253 .16256 0 5 Mabsadd L
.4253 .16256 3.75 0 Mabsadd L
.4253 .16256 0 -5 Mabsadd L
.4253 .16256 -3.75 0 Mabsadd L closepath F
.43464 .16664 -3.75 0 Mabsadd m
.43464 .16664 0 5 Mabsadd L
.43464 .16664 3.75 0 Mabsadd L
.43464 .16664 0 -5 Mabsadd L
.43464 .16664 -3.75 0 Mabsadd L closepath F
.44398 .17072 -3.75 0 Mabsadd m
.44398 .17072 0 5 Mabsadd L
.44398 .17072 3.75 0 Mabsadd L
.44398 .17072 0 -5 Mabsadd L
.44398 .17072 -3.75 0 Mabsadd L closepath F
.45331 .20923 -3.75 0 Mabsadd m
.45331 .20923 0 5 Mabsadd L
.45331 .20923 3.75 0 Mabsadd L
.45331 .20923 0 -5 Mabsadd L
.45331 .20923 -3.75 0 Mabsadd L closepath F
.46265 .1757 -3.75 0 Mabsadd m
.46265 .1757 0 5 Mabsadd L
.46265 .1757 3.75 0 Mabsadd L
.46265 .1757 0 -5 Mabsadd L
.46265 .1757 -3.75 0 Mabsadd L closepath F
.47199 .24167 -3.75 0 Mabsadd m
.47199 .24167 0 5 Mabsadd L
.47199 .24167 3.75 0 Mabsadd L
.47199 .24167 0 -5 Mabsadd L
.47199 .24167 -3.75 0 Mabsadd L closepath F
.48133 .09745 -3.75 0 Mabsadd m
.48133 .09745 0 5 Mabsadd L
.48133 .09745 3.75 0 Mabsadd L
.48133 .09745 0 -5 Mabsadd L
.48133 .09745 -3.75 0 Mabsadd L closepath F
.49066 .16555 -3.75 0 Mabsadd m
.49066 .16555 0 5 Mabsadd L
.49066 .16555 3.75 0 Mabsadd L
.49066 .16555 0 -5 Mabsadd L
.49066 .16555 -3.75 0 Mabsadd L closepath F
.5 .22224 -3.75 0 Mabsadd m
.5 .22224 0 5 Mabsadd L
.5 .22224 3.75 0 Mabsadd L
.5 .22224 0 -5 Mabsadd L
.5 .22224 -3.75 0 Mabsadd L closepath F
.50934 .23832 -3.75 0 Mabsadd m
.50934 .23832 0 5 Mabsadd L
.50934 .23832 3.75 0 Mabsadd L
.50934 .23832 0 -5 Mabsadd L
.50934 .23832 -3.75 0 Mabsadd L closepath F
.51867 .30139 -3.75 0 Mabsadd m
.51867 .30139 0 5 Mabsadd L
.51867 .30139 3.75 0 Mabsadd L
.51867 .30139 0 -5 Mabsadd L
.51867 .30139 -3.75 0 Mabsadd L closepath F
.52801 .3748 -3.75 0 Mabsadd m
.52801 .3748 0 5 Mabsadd L
.52801 .3748 3.75 0 Mabsadd L
.52801 .3748 0 -5 Mabsadd L
.52801 .3748 -3.75 0 Mabsadd L closepath F
.53735 .01472 -3.75 0 Mabsadd m
.53735 .01472 0 5 Mabsadd L
.53735 .01472 3.75 0 Mabsadd L
.53735 .01472 0 -5 Mabsadd L
.53735 .01472 -3.75 0 Mabsadd L closepath F
.54669 .0723 -3.75 0 Mabsadd m
.54669 .0723 0 5 Mabsadd L
.54669 .0723 3.75 0 Mabsadd L
.54669 .0723 0 -5 Mabsadd L
.54669 .0723 -3.75 0 Mabsadd L closepath F
.55602 .0883 -3.75 0 Mabsadd m
.55602 .0883 0 5 Mabsadd L
.55602 .0883 3.75 0 Mabsadd L
.55602 .0883 0 -5 Mabsadd L
.55602 .0883 -3.75 0 Mabsadd L closepath F
.56536 .08345 -3.75 0 Mabsadd m
.56536 .08345 0 5 Mabsadd L
.56536 .08345 3.75 0 Mabsadd L
.56536 .08345 0 -5 Mabsadd L
.56536 .08345 -3.75 0 Mabsadd L closepath F
.5747 .0815 -3.75 0 Mabsadd m
.5747 .0815 0 5 Mabsadd L
.5747 .0815 3.75 0 Mabsadd L
.5747 .0815 0 -5 Mabsadd L
.5747 .0815 -3.75 0 Mabsadd L closepath F
.58403 .08445 -3.75 0 Mabsadd m
.58403 .08445 0 5 Mabsadd L
.58403 .08445 3.75 0 Mabsadd L
.58403 .08445 0 -5 Mabsadd L
.58403 .08445 -3.75 0 Mabsadd L closepath F
.59337 .0873 -3.75 0 Mabsadd m
.59337 .0873 0 5 Mabsadd L
.59337 .0873 3.75 0 Mabsadd L
.59337 .0873 0 -5 Mabsadd L
.59337 .0873 -3.75 0 Mabsadd L closepath F
.60271 .09066 -3.75 0 Mabsadd m
.60271 .09066 0 5 Mabsadd L
.60271 .09066 3.75 0 Mabsadd L
.60271 .09066 0 -5 Mabsadd L
.60271 .09066 -3.75 0 Mabsadd L closepath F
.61204 .0922 -3.75 0 Mabsadd m
.61204 .0922 0 5 Mabsadd L
.61204 .0922 3.75 0 Mabsadd L
.61204 .0922 0 -5 Mabsadd L
.61204 .0922 -3.75 0 Mabsadd L closepath F
.62138 .11295 -3.75 0 Mabsadd m
.62138 .11295 0 5 Mabsadd L
.62138 .11295 3.75 0 Mabsadd L
.62138 .11295 0 -5 Mabsadd L
.62138 .11295 -3.75 0 Mabsadd L closepath F
.63072 .10031 -3.75 0 Mabsadd m
.63072 .10031 0 5 Mabsadd L
.63072 .10031 3.75 0 Mabsadd L
.63072 .10031 0 -5 Mabsadd L
.63072 .10031 -3.75 0 Mabsadd L closepath F
.64006 .10361 -3.75 0 Mabsadd m
.64006 .10361 0 5 Mabsadd L
.64006 .10361 3.75 0 Mabsadd L
.64006 .10361 0 -5 Mabsadd L
.64006 .10361 -3.75 0 Mabsadd L closepath F
.64939 .1076 -3.75 0 Mabsadd m
.64939 .1076 0 5 Mabsadd L
.64939 .1076 3.75 0 Mabsadd L
.64939 .1076 0 -5 Mabsadd L
.64939 .1076 -3.75 0 Mabsadd L closepath F
.65873 .11123 -3.75 0 Mabsadd m
.65873 .11123 0 5 Mabsadd L
.65873 .11123 3.75 0 Mabsadd L
.65873 .11123 0 -5 Mabsadd L
.65873 .11123 -3.75 0 Mabsadd L closepath F
.66807 .11485 -3.75 0 Mabsadd m
.66807 .11485 0 5 Mabsadd L
.66807 .11485 3.75 0 Mabsadd L
.66807 .11485 0 -5 Mabsadd L
.66807 .11485 -3.75 0 Mabsadd L closepath F
.6774 .11789 -3.75 0 Mabsadd m
.6774 .11789 0 5 Mabsadd L
.6774 .11789 3.75 0 Mabsadd L
.6774 .11789 0 -5 Mabsadd L
.6774 .11789 -3.75 0 Mabsadd L closepath F
.68674 .08168 -3.75 0 Mabsadd m
.68674 .08168 0 5 Mabsadd L
.68674 .08168 3.75 0 Mabsadd L
.68674 .08168 0 -5 Mabsadd L
.68674 .08168 -3.75 0 Mabsadd L closepath F
.69608 .13538 -3.75 0 Mabsadd m
.69608 .13538 0 5 Mabsadd L
.69608 .13538 3.75 0 Mabsadd L
.69608 .13538 0 -5 Mabsadd L
.69608 .13538 -3.75 0 Mabsadd L closepath F
.70542 .1893 -3.75 0 Mabsadd m
.70542 .1893 0 5 Mabsadd L
.70542 .1893 3.75 0 Mabsadd L
.70542 .1893 0 -5 Mabsadd L
.70542 .1893 -3.75 0 Mabsadd L closepath F
.71475 .19337 -3.75 0 Mabsadd m
.71475 .19337 0 5 Mabsadd L
.71475 .19337 3.75 0 Mabsadd L
.71475 .19337 0 -5 Mabsadd L
.71475 .19337 -3.75 0 Mabsadd L closepath F
.72409 .18884 -3.75 0 Mabsadd m
.72409 .18884 0 5 Mabsadd L
.72409 .18884 3.75 0 Mabsadd L
.72409 .18884 0 -5 Mabsadd L
.72409 .18884 -3.75 0 Mabsadd L closepath F
.73343 .22509 -3.75 0 Mabsadd m
.73343 .22509 0 5 Mabsadd L
.73343 .22509 3.75 0 Mabsadd L
.73343 .22509 0 -5 Mabsadd L
.73343 .22509 -3.75 0 Mabsadd L closepath F
.74276 .24322 -3.75 0 Mabsadd m
.74276 .24322 0 5 Mabsadd L
.74276 .24322 3.75 0 Mabsadd L
.74276 .24322 0 -5 Mabsadd L
.74276 .24322 -3.75 0 Mabsadd L closepath F
.7521 .23868 -3.75 0 Mabsadd m
.7521 .23868 0 5 Mabsadd L
.7521 .23868 3.75 0 Mabsadd L
.7521 .23868 0 -5 Mabsadd L
.7521 .23868 -3.75 0 Mabsadd L closepath F
.76144 .24779 -3.75 0 Mabsadd m
.76144 .24779 0 5 Mabsadd L
.76144 .24779 3.75 0 Mabsadd L
.76144 .24779 0 -5 Mabsadd L
.76144 .24779 -3.75 0 Mabsadd L closepath F
.77077 .30076 -3.75 0 Mabsadd m
.77077 .30076 0 5 Mabsadd L
.77077 .30076 3.75 0 Mabsadd L
.77077 .30076 0 -5 Mabsadd L
.77077 .30076 -3.75 0 Mabsadd L closepath F
.78011 .1115 -3.75 0 Mabsadd m
.78011 .1115 0 5 Mabsadd L
.78011 .1115 3.75 0 Mabsadd L
.78011 .1115 0 -5 Mabsadd L
.78011 .1115 -3.75 0 Mabsadd L closepath F
.78945 .16868 -3.75 0 Mabsadd m
.78945 .16868 0 5 Mabsadd L
.78945 .16868 3.75 0 Mabsadd L
.78945 .16868 0 -5 Mabsadd L
.78945 .16868 -3.75 0 Mabsadd L closepath F
.79879 .16311 -3.75 0 Mabsadd m
.79879 .16311 0 5 Mabsadd L
.79879 .16311 3.75 0 Mabsadd L
.79879 .16311 0 -5 Mabsadd L
.79879 .16311 -3.75 0 Mabsadd L closepath F
.80812 .2124 -3.75 0 Mabsadd m
.80812 .2124 0 5 Mabsadd L
.80812 .2124 3.75 0 Mabsadd L
.80812 .2124 0 -5 Mabsadd L
.80812 .2124 -3.75 0 Mabsadd L closepath F
.81746 .26587 -3.75 0 Mabsadd m
.81746 .26587 0 5 Mabsadd L
.81746 .26587 3.75 0 Mabsadd L
.81746 .26587 0 -5 Mabsadd L
.81746 .26587 -3.75 0 Mabsadd L closepath F
.8268 .31435 -3.75 0 Mabsadd m
.8268 .31435 0 5 Mabsadd L
.8268 .31435 3.75 0 Mabsadd L
.8268 .31435 0 -5 Mabsadd L
.8268 .31435 -3.75 0 Mabsadd L closepath F
.83613 .02573 -3.75 0 Mabsadd m
.83613 .02573 0 5 Mabsadd L
.83613 .02573 3.75 0 Mabsadd L
.83613 .02573 0 -5 Mabsadd L
.83613 .02573 -3.75 0 Mabsadd L closepath F
.84547 .07525 -3.75 0 Mabsadd m
.84547 .07525 0 5 Mabsadd L
.84547 .07525 3.75 0 Mabsadd L
.84547 .07525 0 -5 Mabsadd L
.84547 .07525 -3.75 0 Mabsadd L closepath F
.85481 .07058 -3.75 0 Mabsadd m
.85481 .07058 0 5 Mabsadd L
.85481 .07058 3.75 0 Mabsadd L
.85481 .07058 0 -5 Mabsadd L
.85481 .07058 -3.75 0 Mabsadd L closepath F
.86415 .11046 -3.75 0 Mabsadd m
.86415 .11046 0 5 Mabsadd L
.86415 .11046 3.75 0 Mabsadd L
.86415 .11046 0 -5 Mabsadd L
.86415 .11046 -3.75 0 Mabsadd L closepath F
.87348 .10185 -3.75 0 Mabsadd m
.87348 .10185 0 5 Mabsadd L
.87348 .10185 3.75 0 Mabsadd L
.87348 .10185 0 -5 Mabsadd L
.87348 .10185 -3.75 0 Mabsadd L closepath F
.88282 .1091 -3.75 0 Mabsadd m
.88282 .1091 0 5 Mabsadd L
.88282 .1091 3.75 0 Mabsadd L
.88282 .1091 0 -5 Mabsadd L
.88282 .1091 -3.75 0 Mabsadd L closepath F
.89216 .11499 -3.75 0 Mabsadd m
.89216 .11499 0 5 Mabsadd L
.89216 .11499 3.75 0 Mabsadd L
.89216 .11499 0 -5 Mabsadd L
.89216 .11499 -3.75 0 Mabsadd L closepath F
.90149 .10955 -3.75 0 Mabsadd m
.90149 .10955 0 5 Mabsadd L
.90149 .10955 3.75 0 Mabsadd L
.90149 .10955 0 -5 Mabsadd L
.90149 .10955 -3.75 0 Mabsadd L closepath F
.91083 .10647 -3.75 0 Mabsadd m
.91083 .10647 0 5 Mabsadd L
.91083 .10647 3.75 0 Mabsadd L
.91083 .10647 0 -5 Mabsadd L
.91083 .10647 -3.75 0 Mabsadd L closepath F
.92017 .10774 -3.75 0 Mabsadd m
.92017 .10774 0 5 Mabsadd L
.92017 .10774 3.75 0 Mabsadd L
.92017 .10774 0 -5 Mabsadd L
.92017 .10774 -3.75 0 Mabsadd L closepath F
.92951 .1168 -3.75 0 Mabsadd m
.92951 .1168 0 5 Mabsadd L
.92951 .1168 3.75 0 Mabsadd L
.92951 .1168 0 -5 Mabsadd L
.92951 .1168 -3.75 0 Mabsadd L closepath F
.93884 .11997 -3.75 0 Mabsadd m
.93884 .11997 0 5 Mabsadd L
.93884 .11997 3.75 0 Mabsadd L
.93884 .11997 0 -5 Mabsadd L
.93884 .11997 -3.75 0 Mabsadd L closepath F
.94818 .12496 -3.75 0 Mabsadd m
.94818 .12496 0 5 Mabsadd L
.94818 .12496 3.75 0 Mabsadd L
.94818 .12496 0 -5 Mabsadd L
.94818 .12496 -3.75 0 Mabsadd L closepath F
.95752 .12858 -3.75 0 Mabsadd m
.95752 .12858 0 5 Mabsadd L
.95752 .12858 3.75 0 Mabsadd L
.95752 .12858 0 -5 Mabsadd L
.95752 .12858 -3.75 0 Mabsadd L closepath F
.96685 .1322 -3.75 0 Mabsadd m
.96685 .1322 0 5 Mabsadd L
.96685 .1322 3.75 0 Mabsadd L
.96685 .1322 0 -5 Mabsadd L
.96685 .1322 -3.75 0 Mabsadd L closepath F
.97619 .42627 -3.75 0 Mabsadd m
.97619 .42627 0 5 Mabsadd L
.97619 .42627 3.75 0 Mabsadd L
.97619 .42627 0 -5 Mabsadd L
.97619 .42627 -3.75 0 Mabsadd L closepath F
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[32]:=",
  ImageSize->{400, 247.188},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006@0000mb000`400?l00000o`00003ooooooonA
ooooo`00oooooonAooooo`00oooooonAooooo`00oooooonAooooo`00oooooonAooooo`00GOooool5
o`0000?ooooo0_l0000oooooo`?o00000oooool2o`0003kooooo0ol00004ooooo`;o0000?_ooool3
o`0000Cooooo0_l0000jooooo`?o00001?ooool2o`0000Cooooo0_l0000;ooooo`00G_ooool01?l0
003oooooooooool00002ooooo`04o`000?ooooooooooo`0003oooooo00Go0000oooooooooooooooo
o`000002ooooo`03o`000?oooooooooo03[ooooo00Go0000ooooooooooooooooo`000002ooooo`04
o`000?ooooooooooo`0003cooooo00Go0000ooooooooooooooooo`000002ooooo`04o`000?oooooo
ooooo`0003[ooooo00?o0000ooooooooool00_ooool01?l0003oooooooooool00002ooooo`04o`00
0?ooooooooooo`0000[ooooo001Oooooo`03o`000?oooooooooo00;ooooo00Co0000oooooooooooo
0000??ooool5o`0000;ooooo00Co0000oooooooooooo0000??ooool01Ol0003ooooooooooooooooo
000000;ooooo00Co0000oooooooooooo0000??ooool01Ol0003ooooooooooooooooo000000;ooooo
00Co0000oooooooooooo0000>_ooool00ol0003oooooooooo`02ooooo`04o`000?ooooooooooo`00
00;ooooo00Co0000oooooooooooo00002_ooool001cooooo00?o0000ooooooooool0@Oooool01Ol0
003ooooooooooooooooo000000;ooooo00?o0000ooooooooool0>_ooool01?l0003oooooooooool0
0003ooooo`04o`000?ooooooooooo`0003cooooo1?l00003ooooo`04o`000?ooooooooooo`0003go
oooo0ol00003ooooo`04o`000?ooooooooooo`0003[ooooo00?o0000ooooooooool00_ooool01?l0
003oooooooooool00002ooooo`04o`000?ooooooooooo`0000[ooooo000Looooo`?o0000?_ooool0
1Ol0003ooooooooooooooooo000000;ooooo00Co0000oooooooooooo0000?Oooool00ol0003ooooo
o`000003ooooo`04o`000?ooooooooooo`0003cooooo00?o0000ooooooooool01?ooool01?l0003o
ooooooooool0000looooo`05o`000?ooooooooooooooool000000_ooool01?l0003oooooooooool0
000jooooo`03o`000?oooooooooo00;ooooo00Co0000oooooooooooo00000_ooool01?l0003ooooo
ooooool0000:ooooo`007?ooool00ol0003oooooooooo`0nooooo`05o`000?ooooooooooooooool0
00000_ooool01?l0003oooooooooool0000nooooo`;o00000oooool01?l0003oooooooooool0000m
ooooo`03o`000?oooooooooo00?ooooo00Co0000oooooooooooo0000??ooool01Ol0003ooooooooo
oooooooo000000;ooooo00Co0000oooooooooooo0000>Oooool2o`0000Cooooo00Co0000oooooooo
oooo00000_ooool01?l0003oooooooooool0000:ooooo`007?ooool00ol0003oooooooooo`0ooooo
o`?o00001?ooool2o`00043ooooo00?o0000ooooooooool00_ooool2o`00037ooooo00?o0000oooo
ooooool02oooool2o`0000Cooooo0_l0000nooooo`?o00001?ooool2o`0003_ooooo00?o0000oooo
ooooool00oooool2o`0000Cooooo0_l0000;ooooo`007?ooool00ol0003oooooooooo`2oooooo`?o
0000[oooool001cooooo00?o0000ooooooooool0__ooool5o`000:kooooo000Looooo`03o`000?oo
oooooooo0;gooooo1ol0002]ooooo`007?ooool00ol0003oooooooooo`20ooooo`03o`000?oooooo
oooo03Wooooo2?l0001]ooooo`03o`000?oooooooooo03gooooo000Looooo`03o`000?oooooooooo
07oooooo0ol0000kooooo`Oo0000K?ooool3o`0003kooooo000Looooo`03o`000?oooooooooo07ko
oooo1Ol0000kooooo`Go0000K?ooool5o`0003gooooo000Coooooooo0000O_l0000001cooooo00?o
0000ooooooooool03oooool00ol0003oooooooooo`0?ooooo`03o`000?oooooooooo00kooooo00?o
0000ooooooooool02oooool3o`000003ooooool0003ooooo013ooooo00?o0000ooooooooool03_oo
ool00ol0003oooooooooo`0?ooooo`04o`000?ooooooooooooooo`Oo00001oooool00ol0003ooooo
ooooo`0?ooooo`03o`000?oooooooooo00kooooo00?o0000ooooooooool03oooool00ol0003ooooo
ooooo`0?ooooo`03o`000?oooooooooo00kooooo00?o0000ooooooooool03oooool00ol0003ooooo
ooooo`0?ooooo`03o`000?oooooooooo00oooooo00?o0000ooooooooool03_ooool01?l0003ooooo
ooooooooool7o`0000Oooooo00?o0000ooooooooool03oooool00ol0003oooooooooo`0>ooooo`03
o`000?oooooooooo00oooooo000Looooo`03o`000?oooooooooo03oooooo1?l000000ooooooo0000
ooooo`0hooooo`Ko00001oooool00ol0003oooooooooo`0cooooo`03o`000?oooooooooo00kooooo
00?o0000ooooooooool0A?ooool00ol0003oooooooooo`0Cooooo`Ko0000:_ooool00ol0003ooooo
ooooo`0?ooooo`007?ooool00ol0003oooooooooo`0nooooo`Ko0000>oooool4o`0003kooooo00?o
0000ooooooooool0K?ooool4o`0003gooooo000Looooo`03o`000?oooooooooo03gooooo1ol0000k
ooooo`?o0000?_ooool2o`0006kooooo0ol0000nooooo`007?ooool00ol0003oooooooooo`0noooo
o`Ko0000??ooool00ol0003oooooooooo`0mooooo`03o`000?oooooo000006kooooo0_l0000noooo
o`007?ooool00ol0003oooooooooo`0oooooo`Co0000?_ooool00ol0003oooooooooo`0looooo`03
o`000?oooooo000006kooooo0_l0000nooooo`007?ooool00ol0003oooooooooo`10ooooo`;o0000
?oooool00ol0003oooooooooo`0looooo`03o`000?oooooo000006kooooo00?o0000ooooooooool0
?Oooool001cooooo00?o0000ooooooooool0@?ooool2o`0003oooooo00?o0000ooooooooool0??oo
ool00ol0003oooooooooo`1^ooooo`03o`000?oooooooooo03gooooo000Looooo`?o0000@?ooool2
o`00043ooooo00?o0000ooooooooool0>oooool00ol0003oooooooooo`1^ooooo`03o`000?oooooo
oooo03gooooo000Looooo`03o`000?oooooooooo04;ooooo00?o0000ooooooooool0>oooool00ol0
003oooooo`00003^ooooo`007?ooool00ol0003oooooooooo`12ooooo`03o`000?oooooooooo03_o
oooo00?o0000ooooool00000/?ooool00ol0003oooooooooo`0kooooo`007?ooool00ol0003ooooo
ooooo`12ooooo`03o`000?oooooooooo03_ooooo00?o0000ooooooooool0@?ooool00ol0003ooooo
ooooo`1]ooooo`03o`000?oooooooooo03_ooooo000Looooo`03o`000?oooooooooo02Cooooo00?o
0000ooooooooool0FOooool00ol0003oooooooooo`10ooooo`03o`000?oooooooooo06gooooo00?o
0000ooooooooool0>oooool001cooooo00?o0000ooooooooool08oooool3o`0001[ooooo00?o0000
ooooooooool0?Oooool00ol0003oooooooooo`0mooooo`04o`000?ooooooooooo`0006gooooo00Co
0000oooooooooooo00000oooool00ol0003oooooooooo`0fooooo`007?ooool00ol0003ooooooooo
o`0Rooooo`Go00006Oooool00ol0003oooooooooo`0mooooo`03o`000?oooooooooo03gooooo00?o
0000ooooooooool00_l0001/ooooo`04o`000?ooooooooooo`0000;ooooo0ol0000gooooo`007?oo
ool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo01Kooooo1ol0000Hooooo`03o`000?oo
oooooooo03oooooo00?o0000ooooooooool0>oooool00ol0003oooooooooo`03o`0006_ooooo00?o
0000ooooooooool01ol0000fooooo`007?ooool3o`0000Oooooo0ol0000Fooooo`So00006?ooool0
0ol0003oooooo`00000oooooo`03o`000?oooooooooo03[ooooo00?o0000ooooooooool01?l0001[
ooooo`03o`000?oooooooooo00So0000=Oooool001cooooo00?o0000ooooooooool01_ooool5o`00
01Kooooo1ol0000Hooooo`03o`000?oooooo000003oooooo00?o0000ooooooooool0>_ooool00ol0
003oooooo`000005o`0000Oooooo00?o0000ooooooooool0:?ooool00ol0003oooooooooo`0eoooo
o`03o`000?oooooo000000So0000=Oooool001cooooo00?o0000ooooooooool01Oooool7o`0001Ko
oooo1Ol0000Iooooo`03o`000?oooooo0000043ooooo00?o0000ooooooooool0>Oooool8o`0000Co
oooo00?o0000ooooool000000_l00002ooooo`03o`000?oooooooooo02?ooooo0ol0000fooooo`_o
0000=Oooool001cooooo00?o0000ooooooooool01?ooool8o`0001Oooooo0ol0000Mooooo`03o`00
0?oooooooooo03[ooooo00Co0000oooooooooooo0000?Oooool6o`0000?ooooo2_l000000ooooooo
0000ooooo`0Pooooo`Co0000=_ooool:o`0003Kooooo000Looooo`03o`000?oooooooooo00Gooooo
1ol0000Hooooo`;o00007Oooool00ol0003oooooooooo`0jooooo`04o`000?ooooooooooo`0003ko
oooo1?l000000ooooooo0000ooooo`0>o`0001oooooo1_l0000fooooo`So0000=oooool001cooooo
00?o0000ooooooooool01_ooool5o`0001Wooooo0_l0000Mooooo`03o`000?oooooooooo03[ooooo
00?o0000ooooooooool0@?ooool2o`000003ooooool0003o0000013o000000Goooooo`000?oooooo
ooooo`00000Hooooo`Oo0000=oooool6o`0003Sooooo000Looooo`03o`000?oooooooooo00Oooooo
0ol0000Jooooo`;o0000F_ooool01Ol0003ooooooooooooooooo000003oooooo6_l0000Hooooo`Ko
0000>?ooool3o`0003[ooooo000Looooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool0
6Oooool00ol0003oooooooooo`0Iooooo`03o`000?oooooooooo03gooooo00?o0000ooooooooool0
0ol0000Uooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool00_oooolKo`0001Sooooo
1?l0000fooooo`05o`000?ooooooooooooooool00000>oooool001cooooo00?o0000ooooooooool0
2?ooool00ol0003oooooooooo`0Iooooo`03o`000?oooooooooo01Wooooo00?o0000ooooooooool0
?Oooool00ol0003oooooo`000004o`0002?ooooo0ol0000Booooo`04o`000?oooooooooooooooago
00000oooool00ol0003oooooooooo`0Booooo`;o0000=oooool00ol0003oooooooooo`06ooooo`03
o`000?oooooooooo03Cooooo000Looooo`?o00002?ooool00ol0003oooooooooo`0eooooo`03o`00
0?oooooooooo03kooooo1ol0000Qooooo`Go00004Oooool00ol0003oooooooooo`02ooooo`So0000
0_ooool00ol0003oooooooooo`02o`000003ooooool0003o000000[o00000_ooool3o`0000;ooooo
00?o0000ooooooooool03oooool00ol0003oooooooooo`0eooooo`03o`000?oooooooooo00Kooooo
00?o0000ooooooooool00oooool00ol0003oooooooooo`0^ooooo`007?ooool00ol0003ooooooooo
o`08ooooo`03o`000?oooooooooo023ooooo00?o0000ooooooooool04_ooool01?l0003ooooooooo
ool0000looooo`So00008?ooool7o`00013ooooo00?o0000ooooooooool00oooool5o`000003oooo
ool0003ooooo00Gooooo00?o0000ooooool000002ol000000ooooooo0000o`000006o`0004Oooooo
00?o0000ooooooooool01oooool00ol0003oooooooooo`02ooooo`?o0000;oooool001cooooo00?o
0000ooooooooool02?ooool00ol0003oooooooooo`0Jooooo`03o`000?oooooooooo00;ooooo0ol0
000Cooooo`04o`000?ooooooooooo`0002Oooooo00?o0000ooooooooool04oooool7o`0001oooooo
2?l0000@ooooo`03o`000?oooooooooo00Cooooo0ol0000<ooooo`03o`000?oooooo000000Oo0000
0_ooool9o`000003ooooool0003ooooo00gooooo00?o0000ooooooooool0<oooool00ol0003ooooo
ooooo`08ooooo`03o`000?oooooooooo00Co00003?ooool01?l0003oooooooooool0000Oooooo`00
7?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo01[ooooo00Co0000oooooooooooo
oooo1Ol0000Booooo`04o`000?ooooooooooo`0002Kooooo0ol0000Eooooo`Go00008Oooool7o`00
013ooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`0>ooooo`Ko00000_ooool=o`00
0003ooooool0003ooooo00Oooooo00Co0000oooooooooooo00008Oooool00ol0003oooooooooo`0A
ooooo`03o`000?oooooooooo00Sooooo2Ol00006ooooo`03o`000?oooooooooo00Ko00007_ooool0
01cooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`0Iooooo`;o00000oooool6o`00
01Gooooo00?o0000ooooooooool08_ooool5o`0001;ooooo00?o0000ooooooooool00ol0000Soooo
o`Go0000:oooool01ol0003oooooooooool0003oooooo`000?ooool04?l00007ooooo`04o`000?oo
ooooooooo`00023ooooo0ol0000Mooooo`[o00001?ooool;o`0001gooooo000Looooo`03o`000?oo
oooooooo00Sooooo00?o0000ooooooooool06Oooool01?l0003oooooo`000?ooool7o`0001Cooooo
0ol0000Rooooo`Oo00004Oooool01Ol0003ooooooooooooooooo000002Gooooo0ol0000aoooooa?o
000000?oooooo`000?ooool00oooool01Ol0003ooooooooooooooooo000001kooooo1Ol0000Koooo
o`co000000?oooooo`000?l000003Ol0000Kooooo`001oooool3o`0000Cooooo0_l00004ooooo`;o
00001_ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo01Wooooo00?o0000ooooool0
00000_ooool6o`0001?ooooo1Ol0000Pooooo`So00004Oooool00ol0003oooooooooo`0Wooooo`;o
0000<_oooolFo`000003ooooool0003o000000Cooooo00?o0000ooooooooool06oooool7o`0001Wo
oooo7_l0000Jooooo`001_ooool01Ol0003ooooooooooooooooo000000;ooooo00Co0000oooooooo
oooo00000_ooool01?l0003oooooooooool00005ooooo`03o`000?oooooooooo00Sooooo00?o0000
ooooooooool06Oooool00ol0003oooooo`000003ooooo`Co00004oooool7o`00023ooooo1ol0000@
ooooo`03o`000?oooooooooo02Sooooo00?o0000ooooooooool0<?ooool7o`0000;ooooo4Ol00004
ooooo`03o`000?oooooooooo01[ooooo2?l0000Hooooob7o00006?ooool000Kooooo00Go0000oooo
ooooooooooooo`000002ooooo`04o`000?ooooooooooo`0000;ooooo00Co0000oooooooooooo0000
1Oooool4o`0000Oooooo0_l0000Jooooo`03o`000?oooooooooo00?ooooo0ol0000Cooooo`So0000
8Oooool5o`00017ooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`0Pooooo`03o`00
0?oooooooooo01;ooooo00?o0000ooooooooool06_ooool8o`0000?ooooo00?o0000ooooool00000
3_l0000Qooooo`Oo00004?ooool00ol0003oooooooooo`06ooooob7o00005oooool000Kooooo1?l0
0003ooooo`04o`000?ooooooooooo`0000;ooooo00Co0000oooooooooooo00001Oooool00ol0003o
ooooooooo`08ooooo`;o00006_ooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo01;o
oooo2?l0000Rooooo`?o00004_ooool00ol0003oooooooooo`04ooooo`?o00008Oooool00ol0003o
ooooooooo`0Booooo`03o`000?oooooooooo01_ooooo1ol00006ooooo`oo00008Oooool5o`00017o
oooo00?o0000ooooooooool01oooool5o`0000;ooooo3_l000000ooooooo0000o`000009o`000003
ooooool0003ooooo01?ooooo0006ooooo`03o`000?oooooooooo00Cooooo00Co0000oooooooooooo
00000_ooool01?l0003oooooooooool00005ooooo`03o`000?oooooooooo00Wooooo00?o0000oooo
ooooool07_ooool00ol0003oooooo`00000Cooooo`03o`000?oooooo000000Co00009?ooool00ol0
003oooooooooo`0Gooooo`Go00008?ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo
01cooooo1Ol00008ooooo`03o`000?oooooo000000_o00008_ooool3o`0001;ooooo00?o0000oooo
ooooool02?ooool3o`0000Cooooo2_l00002ooooo`03o`000?oooooooooo00go000000?oooooo`00
0?ooool04?ooool000Oooooo00?o0000ooooooooool00oooool01?l0003oooooooooool00002oooo
o`04o`000?ooooooooooo`0000Gooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`0N
ooooo`03o`000?oooooo000001?ooooo00?o0000ooooooooool01?l000000ooooooo0000ooooo`0R
ooooo`03o`000?oooooooooo01Kooooo1_l0000Oooooo`03o`000?oooooo000001;ooooo00?o0000
ooooooooool07Oooool3o`0000cooooo00?o0000ooooool000002?l0000Sooooo`;o00004_ooool0
0ol0003oooooooooo`09ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooool000000ol00000
0ooooooo0000ooooo`07ooooo`ko00000_ooool00ol0003oooooooooo`0;ooooo`002?ooool2o`00
00Cooooo0_l00004ooooo`;o00001_ooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo
01[ooooo00Oo0000ooooooooooooooooo`000?oooooo000001?ooooo00Go0000oooooooooooooooo
o`000002ooooo`?o00008_ooool00ol0003oooooooooo`0Eooooo`Oo00008Oooool00ol0003ooooo
ooooo`0@ooooo`03o`000?oooooooooo01kooooo00?o0000ooooooooool03_ooool7o`0000Cooooo
00?o0000ooooooooool07_ooool00ol0003oooooooooo`0@ooooo`03o`000?oooooooooo01?ooooo
0_l0000<oooooa7o00003?ooool001cooooo00?o0000ooooooooool02Oooool00ol0003ooooooooo
o`0Jooooo`03o`000?oooooooooo01Oooooo00?o0000ooooooooool00oooool4o`00023ooooo00?o
0000ooooool000006?ooool6o`00027ooooo00?o0000ooooooooool04?ooool00ol0003ooooooooo
o`0`ooooo`03o`000?oooooo000000;o00001Oooool00ol0003oooooooooo`0Nooooo`03o`000?oo
oooooooo013ooooo00?o0000ooooooooool05?ooool00ol0003oooooooooo`0;ooooo`03o`000?oo
oooo000000ko00002oooool001cooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`0I
ooooo`03o`000?oooooo000001kooooo1_l00004ooooo`04o`000?ooooooooooo`0001Oooooo00?o
0000ooooool000004_ooool00ol0003oooooooooo`04ooooo`Co00008oooool00ol0003ooooooooo
o`15ooooo`03o`000?oooooooooo00?ooooo0ol0000Pooooo`03o`000?oooooooooo03Kooooo4?l0
000:ooooo`007?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo01Wooooo00?o0000
ooooool000007Oooool8o`0000;ooooo1_l0000Fooooo`03o`000?oooooo000001;ooooo00?o0000
ooooooooool01?ooool3o`0002Cooooo00?o0000ooooooooool0B_ooool5o`0001oooooo00?o0000
ooooooooool0=oooool00ol0003oooooo`00000<o`0000[ooooo000Looooo`03o`000?oooooooooo
00Sooooo00?o0000ooooooooool06Oooool00ol0003oooooo`00000Noooooa3o00005Oooool00ol0
003oooooo`00000Booooo`03o`000?oooooooooo00Gooooo00Go0000ooooooooooooooooo`000002
ooooo`03o`000?oooooooooo01Wooooo00Co0000oooooooooooo0000Boooool7o`0001cooooo00?o
0000ooooool00000??ooool<o`0000[ooooo000Looooo`?o00002?ooool00ol0003oooooooooo`0I
ooooo`03o`000?oooooo000000?ooooo00?o0000ooooool000006Oooool@o`0001Cooooo00?o0000
ooooooooool04_ooool00ol0003oooooooooo`08ooooo`Ko00006_ooool00ol0003oooooooooo`1;
ooooo`So00007?ooool00ol0003oooooooooo`0mooooo`03o`000?oooooo000000Oo00002oooool0
01cooooo00?o0000ooooooooool02?ooool2o`0001[ooooo00?o0000ooooooooool00oooool00ol0
003oooooo`00000Cooooo`03o`000?oooooooooo00Cooooo3ol0000Dooooo`03o`000?oooooooooo
01;ooooo00?o0000ooooooooool01oooool8o`0001Wooooo00?o0000ooooooooool04_ooool00ol0
003oooooooooo`0gooooo`Oo00007?ooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo
02cooooo00?o0000ooooooooool00ol0000<ooooo`007?ooool00ol0003oooooooooo`08ooooo`;o
00006_ooool00ol0003oooooooooo`03ooooo`03o`000?oooooo000001?ooooo00?o0000oooooooo
ool01?ooool?o`0002Wooooo00?o0000ooooooooool01_ooool:o`0001Oooooo00?o0000oooooooo
ool04oooool00ol0003oooooooooo`0hooooo`Go00007?ooool00ol0003oooooooooo`0Booooo`03
o`000?oooooooooo033ooooo00?o0000ooooooooool02oooool001cooooo00?o0000ooooooooool0
2Oooool00ol0003oooooooooo`0Mooooo`05o`000?ooooooooooooooool000004_ooool00ol0003o
ooooooooo`05ooooo`go0000<_ooool<o`0001Kooooo00?o0000ooooooooool04oooool00ol0003o
ooooooooo`0iooooo`?o00007Oooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo03ko
oooo000Looooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool07Oooool01Ol0003ooooo
oooooooooooo000001;ooooo00?o0000ooooooooool01_ooool7o`000004ooooool0003o0000o`00
01Wooooo00?o0000ooooooooool06?ooool<o`0001Gooooo00?o0000ooooooooool00_ooool00ol0
003oooooooooo`0>ooooo`03o`000?oooooooooo03[ooooo00?o0000ooooooooool07?ooool01Ol0
003ooooooooooooooooo0000013ooooo00?o0000ooooooooool0?_ooool001cooooo00?o0000oooo
ooooool02Oooool00ol0003oooooooooo`0Kooooo`03o`000?oooooo000000?ooooo00?o0000oooo
ooooool04?ooool00ol0003oooooooooo`07ooooo`?o00000_ooool01_l0003oooooooooool0003o
ooooo`0001Sooooo00?o0000ooooooooool06Oooool<o`0001Wooooo00?o0000ooooooooool03_oo
ool00ol0003oooooooooo`0kooooo`03o`000?oooooooooo01oooooo00?o0000ooooooooool03_oo
ool00ol0003oooooooooo`0`ooooo`03o`000?oooooooooo00_ooooo000Looooo`03o`000?oooooo
oooo00Wooooo00?o0000ooooooooool06oooool00ol0003oooooooooo`0Fooooo`03o`000?oooooo
oooo00Sooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`0Cooooo`04o`000?oooooo
ooooo`0001cooooo3Ol0000Gooooo`03o`000?oooooooooo00kooooo00?o0000ooooooooool0>ooo
ool00ol0003oooooooooo`0Oooooo`05o`000?ooooooooooooooool000003?ooool00ol0003ooooo
ooooo`0`ooooo`03o`000?oooooooooo00_ooooo000Looooo`03o`000?oooooooooo00Oooooo00?o
0000ooooooooool06_ooool01?l0003oooooooooool0000/ooooo`03o`000?oooooooooo01?ooooo
00Co0000oooooooooooo00004Oooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo00[o
000000?oooooo`000?ooool04oooool00ol0003oooooooooo`1<ooooo`03o`000?oooooooooo01oo
oooo00?o0000ooooooooool00ol0000nooooo`03o`000?oooooooooo00_ooooo000Looooo`03o`00
0?oooooooooo00Oooooo00?o0000ooooooooool06_ooool01?l0003oooooooooool0000]ooooo`;o
00004oooool01?l0003oooooooooool0000Aooooo`03o`000?oooooooooo00gooooo3?l0000Boooo
o`?o0000C_ooool00ol0003oooooooooo`0Nooooo`Oo0000?Oooool00ol0003oooooooooo`0;oooo
o`007?ooool3o`0000Oooooo00?o0000ooooooooool06_ooool01?l0003oooooooooool0000]oooo
o`?o00004_ooool01?l0003oooooooooool0000Aooooo`03o`000?oooooooooo00kooooo3?l00000
0ooooooo0000ooooo`0:ooooo`03o`000?oooooooooo00Go0000COooool00ol0003oooooooooo`0J
ooooo`04o`000?ooooooooooooooo`So0000??ooool00ol0003oooooooooo`0;ooooo`007?ooool0
0ol0003oooooooooo`07ooooo`03o`000?oooooooooo01[ooooo00?o0000ooooooooool00_l00004
ooooo`03o`000?oooooooooo02Cooooo1Ol0000Aooooo`03o`000?oooooooooo01;ooooo00?o0000
ooooooooool03oooool>o`0000[ooooo00?o0000ooooooooool01_l0001<ooooo`03o`000?oooooo
oooo01[ooooo00?o0000ooooooooool02Ol0000looooo`03o`000?oooooooooo00_ooooo000Loooo
o`03o`000?oooooooooo00Oooooo00Co0000oooooooooooo00006Oooool01Ol0003ooooooooooooo
oooo000000Cooooo00?o0000ooooooooool04?ooool00ol0003oooooooooo`0@ooooo`Oo00004?oo
ool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo013ooooo3Ol00005ooooo`03o`000?oo
oooooooo00;ooooo00?o0000ooooool000001_l0000<ooooo`03o`000?oooooooooo05[ooooo00?o
0000ooooool000002Ol00009ooooo`03o`000?oooooooooo03kooooo000Looooo`03o`000?oooooo
oooo00Oooooo00Co0000oooooooooooo00006Oooool01Ol0003ooooooooooooooooo000000Cooooo
00?o0000ooooooooool04?ooool00ol0003oooooooooo`0?ooooo`So00001_ooool00ol0003ooooo
ooooo`0Looooo`03o`000?oooooooooo01;ooooo3?l00003ooooo`?o00000oooool00ol0003ooooo
ooooo`06o`0000cooooo00?o0000ooooooooool0F_ooool;o`0000[ooooo00?o0000ooooooooool0
?_ooool001cooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0Jooooo`?o00001?oo
ool00ol0003oooooooooo`0?ooooo`03o`000?oooooooooo013ooooo1ol00005ooooo`?o00000_oo
ool00ol0003oooooooooo`0^ooooo`_o00000_ooool4o`0000?ooooo00Co0000oooooooooooooooo
1?l0000=ooooo`03o`000?oooooooooo05[ooooo00?o0000ooooool000001ol0000;ooooo`03o`00
0?oooooooooo03kooooo000Looooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool06Ooo
ool4o`0000Cooooo00?o0000ooooooooool03_ooool00ol0003oooooooooo`0Booooo`Go00001Ooo
ool8o`0000Sooooo00?o0000ooooooooool09Oooool00ol0003oooooo`000007o`000003ooooool0
003o000000Co00000_ooool01?l0003oooooooooooooool3o`0000kooooo00?o0000ooooooooool0
F_ooool00ol0003oooooooooo`04o`000003ooooool0003ooooo00[ooooo00?o0000ooooooooool0
?oooool001cooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0Hooooo`Ko00000ooo
ool00ol0003oooooooooo`0>ooooo`03o`000?oooooooooo01?ooooo0ol00006ooooo`Wo00001ooo
ool00ol0003oooooooooo`0Xooooo`03o`000?oooooo000000?o000000?oooooo`000?l000001Ol0
0007ooooo`;o00003_ooool00ol0003oooooooooo`0nooooo`03o`000?oooooooooo01gooooo0_l0
000>ooooo`03o`000?oooooooooo037ooooo00?o0000ooooooooool02oooool001cooooo00?o0000
ooooooooool02_ooool00ol0003oooooooooo`0Gooooo`Oo00005?ooool00ol0003oooooooooo`0D
ooooo`04o`000?oooooo0000o`0000?ooooo2ol000000ooooooo0000ooooo`03ooooo`;o0000;?oo
ool2o`0000?ooooo1_l00008ooooo`03o`000?oooooooooo00cooooo00?o0000ooooooooool0?_oo
ool2o`0000Kooooo00?o0000ooooooooool05_ooool00ol0003oooooooooo`0<ooooo`03o`000?oo
oooooooo037ooooo00?o0000ooooooooool02oooool001cooooo0ol00007ooooo`03o`000?oooooo
oooo01[ooooo1ol0000]ooooo`?o000000?oooooo`000?l000002_l000000ooooooo0000ooooo`03
ooooo`?o00003_ooool00ol0003oooooooooo`0Kooooo`03o`000?oooooooooo00;ooooo1?l0000:
ooooo`03o`000?oooooooooo04cooooo0ol00004ooooo`?o0000F_ooool00ol0003oooooooooo`0;
ooooo`007?ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo01[ooooo00?o0000oooo
ool000000ol0000]oooooa7o000000?oooooo`000?ooool00_ooool4o`0000kooooo00?o0000oooo
ooooool08?ooool3o`0000_ooooo00?o0000ooooooooool0Boooool6o`000003ooooool0003o0000
00?o00006oooool00ol0003oooooooooo`0looooo`03o`000?oooooooooo00[ooooo000Looooo`03
o`000?oooooooooo00Oooooo00?o0000ooooooooool06_ooool00ol0003oooooooooo`02o`0000Go
oooo00?o0000ooooooooool09_ooool@o`0000;ooooo00?o0000ooooooooool01_l0000=ooooo`03
o`000?oooooooooo023ooooo00?o0000ooooool000000oooool00ol0003oooooooooo`05ooooo`03
o`000?oooooooooo04[ooooo3_l0000@ooooo`03o`000?oooooooooo00Oooooo00?o0000oooooooo
ool0??ooool00ol0003oooooooooo`0:ooooo`007?ooool00ol0003oooooooooo`07ooooo`03o`00
0?oooooooooo01[ooooo00Go0000ooooooooooooooooo`000005ooooo`;o00009_ooool;o`0000;o
oooo0ol00003ooooo`03o`000?oooooo000000Ko00003Oooool00ol0003oooooooooo`0Mooooo`04
o`000?ooooooooooo`0000Gooooo00?o0000ooooooooool0DOooool?o`00013ooooo00?o0000oooo
ooooool01oooool00ol0003oooooooooo`0looooo`03o`000?oooooooooo00[ooooo000Looooo`03
o`000?oooooooooo00Oooooo00Co0000oooooooooooo00006Oooool00ol0003oooooooooo`07oooo
o`?o00003_ooool00ol0003oooooooooo`0Eooooo`[o00000oooool2o`0000?ooooo00?o0000oooo
ooooool01_l0000=ooooo`03o`000?oooooooooo01gooooo00?o0000ooooool000001_ooool00ol0
003oooooooooo`0Cooooo`03o`000?oooooooooo03cooooo3_l0000@ooooo`03o`000?oooooooooo
00Sooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`0oooooo`007?ooool00ol0003o
ooooooooo`07ooooo`04o`000?ooooooooooo`0001Wooooo00?o0000ooooooooool01_ooool5o`00
00gooooo00?o0000ooooooooool05_ooool8o`0000Gooooo00?o0000ooooooooool01Oooool4o`00
00kooooo00?o0000ooooooooool07Oooool00ol0003oooooo`000006ooooo`03o`000?oooooooooo
01?ooooo00?o0000ooooooooool0?Oooool<o`00013ooooo00?o0000ooooooooool02Oooool00ol0
003oooooooooo`06ooooo`03o`000?oooooooooo03oooooo0007ooooo`?o00001?ooool2o`0000Co
oooo0_l00006ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool00_ooool00ol0003o
ooooooooo`0Jooooo`Oo00003?ooool00ol0003oooooooooo`0Fooooo`?o000000Coooooo`000?l0
003o00003oooool2o`00033ooooo0_l00006ooooo`03o`000?oooooooooo01?ooooo00?o0000oooo
ooooool0?_ooool:o`00017ooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`06oooo
o`03o`000?oooooooooo03oooooo0006ooooo`05o`000?ooooooooooooooool000000_ooool01?l0
003oooooooooool00002ooooo`04o`000?ooooooooooo`0000Gooooo00?o0000ooooooooool02_oo
ool01?l0003oooooooooooooool3o`0001[ooooo2?l0000<ooooo`03o`000?oooooooooo01Oooooo
00Go0000ooooooooooooooooo`00000Aooooo`03o`000?oooooooooo02kooooo00?o0000oooooooo
ool00_ooool01?l0003oooooooooool00008ooooo`03o`000?oooooooooo00[ooooo00?o0000oooo
ooooool0?oooool00ol0003oooooo`000003o`000003ooooool0003ooooo017ooooo00?o0000oooo
ooooool04_ooool00ol0003oooooooooo`0oooooo`001_ooool01Ol0003ooooooooooooooooo0000
00;ooooo00Co0000oooooooooooo00000_ooool01?l0003oooooooooool00005ooooo`03o`000?oo
oooooooo00[ooooo00?o0000ooooooooool01Ol0000Jooooo`Oo00003?ooool00ol0003ooooooooo
o`0]ooooo`03o`000?oooooooooo02gooooo0ol00003ooooo`03o`000?oooooooooo00Wooooo00?o
0000ooooooooool02_ooool00ol0003oooooooooo`11ooooo`?o00008_ooool00ol0003ooooooooo
o`05ooooo`03o`000?oooooooooo03;ooooo00?o0000ooooooooool02_ooool000Oooooo0ol00003
ooooo`04o`000?ooooooooooo`0000;ooooo00Co0000oooooooooooo00001Oooool4o`0000Wooooo
00?o0000ooooool000001_l0000Jooooo`Go00003Oooool00ol0003oooooooooo`0Wooooo`03o`00
0?oooooooooo00?ooooo00?o0000ooooooooool0;?ooool5o`0000;ooooo00?o0000ooooooooool0
2Oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo04;ooooo00?o0000ooooooooool0
8?ooool3o`0000Kooooo00?o0000ooooooooool0<_ooool00ol0003oooooooooo`0:ooooo`001_oo
ool01Ol0003ooooooooooooooooo000000;ooooo00Co0000oooooooooooo00000_ooool01?l0003o
ooooooooool00005ooooo`03o`000?oooooooooo00Oooooo00Co0000oooooooooooooooo2?l0000@
ooooo`03o`000?oooooooooo00Sooooo0ol0000dooooo`05o`000?ooooooooooooooool000001_oo
ool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo01_ooooo1ol00002ooooo`03o`000?oo
oooooooo00Sooooo00?o0000ooooooooool0EOooool00ol0003oooooooooo`0Iooooo`Co0000>ooo
ool00ol0003oooooooooo`0:ooooo`001_ooool01Ol0003ooooooooooooooooo000000;ooooo00Co
0000oooooooooooo00000_ooool01?l0003oooooooooool00005ooooo`03o`000?oooooooooo00Oo
oooo00?o0000ooooooooool00_ooool7o`00013ooooo00?o0000ooooooooool02Oooool00ol0003o
ooooooooo`0cooooo`05o`000?ooooooooooooooool000001_ooool00ol0003oooooooooo`0<oooo
o`03o`000?oooooooooo01[ooooo2?l00002ooooo`03o`000?oooooooooo00Sooooo0_l0001Foooo
o`03o`000?oooooooooo01Sooooo1_l0000jooooo`03o`000?oooooooooo00[ooooo0007ooooo`?o
00001?ooool2o`0000Cooooo0_l00006ooooo`03o`000?oooooooooo00Oooooo00?o0000oooooooo
ool00oooool5o`00017ooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`0cooooo`04
o`000?ooooooooooo`0000Oooooo00?o0000ooooooooool03?ooool00ol0003oooooooooo`0Koooo
o`Oo00000_ooool00ol0003oooooo`000008ooooo`?o0000EOooool00ol0003oooooooooo`0>oooo
o`03o`000?oooooooooo00Kooooo1ol0000jooooo`03o`000?oooooooooo00[ooooo000Looooo`03
o`000?oooooooooo00Oooooo00?o0000ooooooooool01?ooool3o`0001;ooooo00?o0000oooooooo
ool02Oooool00ol0003oooooooooo`0dooooo`03o`000?oooooo000001Kooooo00?o0000oooooooo
ool07?ooool5o`0000Gooooo00?o0000ooooooooool01Oooool5o`0005Gooooo00?o0000oooooooo
ool03Oooool00ol0003oooooooooo`07ooooo`Ko0000>_ooool00ol0003oooooooooo`0:ooooo`00
7?ooool00ol0003oooooooooo`07ooooo`05o`000?ooooooooooooooool000000_ooool2o`0001?o
oooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`0=ooooo`03o`000?oooooooooo02Co
oooo00?o0000ooooool000005_ooool00ol0003oooooooooo`0Mooooo`?o00001_ooool00ol0003o
ooooooooo`04ooooo`Oo00002?ooool00ol0003oooooooooo`18ooooo`?o00003_ooool00ol0003o
ooooooooo`08ooooo`Co00001_ooool00ol0003oooooooooo`0oooooo`007?ooool00ol0003ooooo
ooooo`07ooooo`05o`000?ooooooooooooooool000000_ooool2o`0001?ooooo00?o0000oooooooo
ool02_ooool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo02Cooooo00?o0000oooooooo
ool05_ooool00ol0003oooooooooo`0Nooooo`03o`000?oooooooooo00Gooooo00?o0000oooooooo
ool00oooool8o`0000Sooooo00?o0000ooooooooool0Aoooool5o`0000gooooo00?o0000oooooooo
ool02Oooool3o`0000Kooooo00?o0000ooooooooool0?oooool001cooooo00?o0000ooooooooool0
2oooool00ol0003oooooo`00000Rooooo`03o`000?oooooooooo00cooooo00?o0000ooooooooool0
I_ooool00ol0003oooooooooo`04ooooo`Oo00002?ooool00ol0003oooooooooo`17ooooo`Ko0000
3?ooool00ol0003oooooooooo`0:ooooo`;o00001_ooool00ol0003oooooooooo`0oooooo`007?oo
ool3o`0000_ooooo00?o0000ooooool000008_ooool00ol0003oooooooooo`0<ooooo`03o`000?oo
oooooooo02kooooo00?o0000ooooooooool0=?ooool2o`0000Oooooo1Ol00009ooooo`03o`000?oo
oooooooo04Kooooo1ol0000<ooooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool0?ooo
ool001cooooo00?o0000ooooooooool02oooool00ol0003oooooo`00000aooooo`03o`000?oooooo
oooo02kooooo00?o0000ooooooooool0=?ooool00ol0003oooooooooo`07ooooo`?o000000?ooooo
o`000?ooool01oooool00ol0003oooooooooo`17ooooo`Ko00000oooool00ol0003oooooooooo`0K
ooooo`03o`000?oooooooooo03;ooooo00?o0000ooooooooool02_ooool001cooooo00?o0000oooo
ooooool02oooool00ol0003oooooooooo`0aooooo`03o`000?oooooooooo02Kooooo00?o0000oooo
ooooool01Oooool00ol0003oooooooooo`0dooooo`03o`000?oooooooooo00Sooooo00?o0000oooo
ool000000_l00007ooooo`03o`000?oooooooooo04Sooooo1?l000000ooooooo0000ooooo`03o`00
01cooooo00?o0000ooooooooool0<_ooool00ol0003oooooooooo`0:ooooo`007?ooool00ol0003o
ooooooooo`07ooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool04?ooool00ol0003o
ooooooooo`11ooooo`;o00002?ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo02Co
oooo0ol0000:ooooo`Go0000DOooool;o`00053ooooo00?o0000ooooooooool02_ooool001cooooo
00?o0000ooooooooool01oooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo013ooooo
00?o0000ooooooooool0@Oooool2o`0000Sooooo00?o0000ooooooooool02oooool00ol0003ooooo
ooooo`0Sooooo`Go00002Oooool6o`00057ooooo00?o0000ooooool000002Ol0000Booooo`03o`00
0?oooooooooo03Wooooo00?o0000ooooooooool02_ooool001cooooo00?o0000ooooooooool01ooo
ool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo013ooooo00?o0000ooooooooool02_oo
ool00ol0003oooooooooo`0dooooo`;o00002?ooool00ol0003oooooooooo`0;ooooo`03o`000?oo
oooooooo02;ooooo1ol00007ooooo`Oo0000D_ooool<o`0000?ooooo00?o0000ooooooooool02ooo
ool00ol0003oooooooooo`0iooooo`03o`000?oooooooooo00[ooooo000Looooo`03o`000?oooooo
oooo00Oooooo00Co0000oooooooooooooooo0_l00003ooooo`03o`000?oooooooooo013ooooo00?o
0000ooooooooool02_ooool00ol0003oooooooooo`0dooooo`;o00005Oooool00ol0003ooooooooo
o`0Rooooo`So00002?ooool6o`00057ooooo3_l00002ooooo`03o`000?oooooooooo00_ooooo00?o
0000ooooooooool0>Oooool00ol0003oooooooooo`0:ooooo`007?ooool00ol0003oooooooooo`07
ooooo`03o`000?oooooooooo00?o00000oooool00ol0003oooooooooo`0@ooooo`03o`000?oooooo
oooo00[ooooo00?o0000ooooooooool03?ooool00ol0003oooooooooo`0Uooooo`;o00005Oooool0
0ol0003oooooooooo`0Sooooo`Oo00002Oooool4o`0000Kooooo00?o0000ooooooooool0B_ooool>
o`000003ooooool0003ooooo00gooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`0o
ooooo`007?ooool00ol0003oooooooooo`07ooooo`03o`000?oooooo000000Co00000_ooool00ol0
003oooooooooo`0@ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool02oooool00ol0
003oooooooooo`0Tooooo`?o00005Oooool00ol0003oooooooooo`0Tooooo`Go00002_ooool3o`00
00Oooooo00?o0000ooooooooool0Boooool>o`0000oooooo00?o0000ooooooooool00oooool00ol0
003oooooooooo`0oooooo`007?ooool3o`0000Wooooo1_l0000Rooooo`03o`000?oooooooooo00_o
oooo00?o0000ooooooooool08oooool5o`0003cooooo0ol0000<ooooo`;o00001oooool00ol0003o
ooooooooo`1<ooooo`?o000000?oooooo`000?l000001ol0000Eooooo`03o`000?oooooooooo03oo
oooo000Looooo`03o`000?oooooooooo00Sooooo1ol0000Rooooo`03o`000?oooooooooo00_ooooo
00?o0000ooooooooool08oooool6o`0000Kooooo00?o0000ooooooooool0<oooool00ol0003ooooo
ooooo`0<ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool0COooool00ol0003ooooo
ooooo`02ooooo`Go000000?oooooo`000?ooool04oooool00ol0003oooooooooo`10ooooo`007?oo
ool00ol0003oooooooooo`09ooooo`Ko0000<?ooool00ol0003oooooooooo`0Rooooo`Oo00001_oo
ool00ol0003oooooooooo`12ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool0Dooo
ool3o`0001?ooooo00Go0000ooooooooooooooooo`00000eooooo`03o`000?oooooooooo00[ooooo
000Looooo`03o`000?oooooooooo00[ooooo1?l0000aooooo`03o`000?oooooooooo02?ooooo1_l0
0006ooooo`03o`000?oooooooooo04?ooooo00?o0000ooooooooool01?ooool00ol0003ooooooooo
o`1Dooooo`03o`000?oooooooooo017ooooo0ol00002ooooo`03o`000?oooooooooo03?ooooo00?o
0000ooooooooool02_ooool001cooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`03
o`0000?ooooo00?o0000ooooooooool04?ooool00ol0003oooooooooo`10ooooo`Co00002?ooool0
1Ol0003ooooooooooooooooo000000Oooooo00?o0000ooooooooool0=_ooool00ol0003ooooooooo
o`1^ooooo`Go0000=oooool00ol0003oooooooooo`0:ooooo`007?ooool00ol0003oooooooooo`07
ooooo`05o`000?ooooooooooooooool000001?ooool00ol0003oooooooooo`0@ooooo`03o`000?oo
oooooooo043ooooo0ol00009ooooo`03o`000?oooooooooo00?o00001_ooool00ol0003ooooooooo
o`0fooooo`03o`000?oooooooooo05cooooo00?o0000ooooooooool03oooool6o`0003Oooooo00?o
0000ooooooooool02Oooool001cooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`06
ooooo`03o`000?oooooooooo013ooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`0c
ooooo`03o`000?oooooooooo00Oooooo1ol00006ooooo`03o`000?oooooooooo09Gooooo00Co0000
oooooooooooo00003Oooool7o`0003Oooooo00?o0000ooooooooool02Oooool001cooooo00?o0000
ooooooooool01oooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00oooooo00?o0000
ooooooooool02oooool00ol0003oooooooooo`0looooo`Wo00001Oooool00ol0003oooooooooo`2E
ooooo`04o`000?ooooooooooo`0000kooooo1_l0000gooooo`03o`000?oooooooooo00Wooooo000L
ooooo`?o00001oooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00oooooo00?o0000
ooooooooool02oooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo02gooooo2_l00005
ooooo`03o`000?oooooooooo03cooooo00?o0000ooooooooool0Eoooool00ol0003oooooo`00000?
ooooo`Co000000?oooooo`000?ooool0@Oooool001cooooo00?o0000ooooooooool01oooool00ol0
003oooooooooo`07ooooo`03o`000?oooooooooo00oooooo00?o0000ooooooooool03?ooool00ol0
003oooooooooo`0:ooooo`03o`000?oooooooooo02cooooo2ol00005ooooo`03o`000?oooooooooo
03cooooo00?o0000ooooooooool0Eoooool00ol0003oooooo`00000?ooooo`?o00000_ooool00ol0
003oooooooooo`10ooooo`007?ooool00ol0003oooooooooo`0booooo`03o`000?oooooooooo00[o
oooo00?o0000ooooooooool0;Oooool9o`00043ooooo00?o0000ooooooooool00_ooool00ol0003o
ooooooooo`1Gooooo`03o`000?oooooo0000013ooooo00Go0000ooooooooooooooooo`000012oooo
o`007?ooool00ol0003oooooooooo`0booooo`03o`000?oooooooooo00[ooooo00?o0000oooooooo
ool0;_ooool7o`00047ooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`1Iooooo`03
o`000?oooooooooo01;ooooo00?o0000ooooooooool0@?ooool001cooooo00?o0000ooooooooool0
?oooool00ol0003oooooooooo`0_ooooo`?o00000_ooool00ol0003oooooooooo`0oooooo`03o`00
0?oooooooooo00;ooooo00?o0000ooooooooool0K_ooool00ol0003oooooooooo`0dooooo`03o`00
0?oooooooooo00Wooooo000Looooo`03o`000?oooooooooo03oooooo00?o0000ooooooooool0<?oo
ool00ol0003oooooooooo`13ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0K_oo
ool00ol0003oooooooooo`0dooooo`03o`000?oooooooooo00Wooooo000Looooo`03o`000?oooooo
oooo00Oooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`0?ooooo`03o`000?oooooo
oooo013ooooo00?o0000ooooooooool0AOooool00ol0003oooooooooo`0gooooo`03o`000?oooooo
oooo077ooooo00?o0000ooooooooool0=_ooool00ol0003oooooooooo`09ooooo`0000Coooooo`00
0?l0003o00001?ooool2o`0000Cooooo0_l00004ooooo`;o00001_ooool00ol0003oooooooooo`07
ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool03oooool00ol0003oooooooooo`0?
ooooo`?o0000A_ooool00ol0003oooooooooo`0gooooo`03o`000?oooooooooo05gooooo0_l0000B
ooooo`03o`000?oooooooooo03Kooooo00?o0000ooooooooool02Oooool000;ooooo00?o0000oooo
ooooool00_ooool01?l0003oooooooooool00002ooooo`04o`000?ooooooooooo`0000;ooooo00Co
0000oooooooooooo00001Oooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Oooooo
00?o0000ooooooooool03oooool00ol0003oooooooooo`0<ooooo`03o`000?oooooo000000Co0000
?_ooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo03Sooooo00?o0000ooooooooool0
G?ooool3o`00017ooooo00?o0000ooooooooool0=_ooool00ol0003oooooooooo`09ooooo`000_oo
ool00ol0003oooooooooo`02ooooo`04o`000?ooooooooooo`0000;ooooo00Co0000oooooooooooo
00000_ooool01?l0003oooooooooool00005ooooo`Co00001_ooool00ol0003oooooooooo`07oooo
o`03o`000?oooooooooo00oooooo00?o0000ooooooooool02oooool9o`0003gooooo00?o0000oooo
ooooool01?ooool00ol0003oooooooooo`0gooooo`?o0000G?ooool4o`0001;ooooo00?o0000oooo
ooooool0=Oooool00ol0003oooooooooo`09ooooo`000_ooool00ol0003oooooooooo`02ooooo`04
o`000?ooooooooooo`0000;ooooo00Co0000oooooooooooo00000_ooool01?l0003oooooooooool0
0005ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool01oooool00ol0003ooooooooo
o`0?ooooo`03o`000?oooooooooo00[ooooo2_l00005ooooo`03o`000?oooooooooo03Gooooo00?o
0000ooooooooool01?ooool00ol0003oooooooooo`0fooooo`Go000000?oooooo`000?ooool0Eooo
ool6o`00017ooooo0_l00012ooooo`000_ooool00ol0003oooooooooo`02ooooo`04o`000?oooooo
ooooo`0000;ooooo00Co0000oooooooooooo00000_ooool01?l0003oooooooooool00005ooooo`03
o`000?oooooooooo00Oooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`0?ooooo`03
o`000?oooooooooo00[ooooo2_l00005ooooo`03o`000?oooooooooo03Gooooo00?o0000oooooooo
ool01?ooool00ol0003oooooooooo`0eooooo`So0000Eoooool7o`00017ooooo0_l00012ooooo`00
00?oooooo`000?l000001?ooool01?l0003oooooooooool00002ooooo`04o`000?ooooooooooo`00
00;ooooo00Co0000oooooooooooo00001Oooool00ol0003oooooooooo`0_ooooo`[o00001_ooool0
0ol0003oooooooooo`0eooooo`03o`000?oooooooooo03_ooooo2Ol0001Hooooo`Ko00004_ooool0
0ol0003oooooooooo`10ooooo`000_ooool00ol0003oooooooooo`03ooooo`;o00001?ooool2o`00
00Cooooo0_l00006ooooo`03o`000?oooooooooo033ooooo2?l00007ooooo`03o`000?oooooooooo
03Gooooo00?o0000ooooooooool0??ooool8o`0005Wooooo1?l0000Booooo`?o0000@Oooool001co
oooo00?o0000ooooooooool0<Oooool4o`000003ooooool0003ooooo00Oooooo00?o0000oooooooo
ool0MOooool5o`000003ooooool0003ooooo05Wooooo0_l0000Booooo`Go0000=?ooool00ol0003o
ooooooooo`09ooooo`007?ooool00ol0003oooooooooo`0aooooo`?o00000oooool00ol0003ooooo
ooooo`05ooooo`03o`000?oooooooooo07Kooooo0ol00002ooooo`03o`000?oooooooooo05Wooooo
00?o0000ooooooooool03oooool7o`0003?ooooo00?o0000ooooooooool02Oooool001cooooo00?o
0000ooooooooool01oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00kooooo00?o
0000ooooooooool03?ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo04Cooooo00?o
0000ooooooooool0>?ooool2o`0006oooooo2?l0000cooooo`03o`000?oooooooooo00Wooooo000L
ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`0>
ooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool0A?ooool00ol0003oooooooooo`0i
ooooo`03o`000?oooooooooo06kooooo1ol0000cooooo`03o`000?oooooooooo00Wooooo000Loooo
o`?o00001oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00kooooo00?o0000oooo
ooooool0D_ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo0:_ooooo1Ol0000doooo
o`03o`000?oooooooooo00Wooooo000Looooo`03o`000?oooooooooo00Oooooo00?o0000oooooooo
ool02?ooool00ol0003oooooooooo`0>ooooo`03o`000?oooooooooo05;ooooo00?o0000oooooooo
ool00oooool00ol0003oooooooooo`2/ooooo`?o0000=Oooool00ol0003oooooooooo`09ooooo`00
7?ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool0
3_ooool00ol0003oooooooooo`0Hooooo`03o`000?oooooooooo03Oooooo00?o0000ooooooooool0
0oooool00ol0003oooooooooo`0looooo`03o`000?oooooooooo06kooooo00?o0000ooooooooool0
@?ooool001cooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`08ooooo`03o`000?oo
oooooooo00kooooo00?o0000ooooooooool06?ooool00ol0003oooooooooo`0gooooo`03o`000?oo
oooooooo00?ooooo00?o0000ooooooooool0??ooool00ol0003oooooooooo`2aooooo`007?ooool0
0ol0003oooooooooo`0Aooooo`?o00008oooool00ol0003oooooooooo`04ooooo`03o`000?oooooo
oooo03Oooooo00?o0000ooooooooool0?oooool01?l0003oooooooooool0002cooooo`007?ooool0
0ol0003oooooooooo`0@ooooo`Go00008_ooool00ol0003oooooooooo`04ooooo`03o`000?oooooo
oooo03Oooooo00?o0000ooooooooool0?oooool01?l0003oooooooooool0002cooooo`007?ooool0
0ol0003oooooooooo`0@ooooo`Ko00008Oooool00ol0003oooooooooo`04ooooo`03o`000?oooooo
oooo07Wooooo00Co0000oooooooooooo0000Yoooool00ol0003oooooooooo`09ooooo`007?ooool0
0ol0003oooooooooo`0?ooooo`Oo00008Oooool00ol0003oooooooooo`04ooooo`03o`000?oooooo
oooo07[ooooo00?o0000ooooool00000Yoooool00ol0003oooooooooo`09ooooo`007?ooool3o`00
00Oooooo00?o0000ooooooooool01_ooool6o`0000gooooo00?o0000ooooooooool04Oooool00ol0
003oooooooooo`14ooooo`03o`000?oooooooooo03[ooooo00?o0000ooooooooool0Yoooool00ol0
003oooooooooo`09ooooo`007?ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Oo
oooo1?l0000>ooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool0A?ooool00ol0003o
ooooooooo`0jooooo`03o`000?oooooooooo0:Sooooo00?o0000ooooooooool02?ooool001cooooo
00?o0000ooooooooool01oooool00ol0003oooooooooo`07ooooo`?o00003oooool00ol0003ooooo
ooooo`1Cooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0iOooool00ol0003ooooo
ooooo`08ooooo`007?ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Sooooo0_l0
000?ooooo`03o`000?oooooooooo05?ooooo00?o0000ooooooooool00_ooool00ol0003ooooooooo
o`3Uooooo`03o`000?oooooooooo00Sooooo000Looooo`03o`000?oooooooooo00Oooooo00?o0000
ooooooooool02Oooool00ol0003oooooooooo`0=ooooo`03o`000?oooooooooo01Sooooo00?o0000
ooooooooool0>?ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo03cooooo00?o0000
ooooooooool0/Oooool001cooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`09oooo
o`03o`000?oooooooooo00gooooo00?o0000ooooooooool06?ooool00ol0003oooooooooo`0goooo
o`?o00000oooool00ol0003oooooooooo`0looooo`03o`000?oooooooooo0;7ooooo000Looooo`03
o`000?oooooooooo03Sooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`0fooooo`Go
0000@?ooool2o`000;?ooooo000Looooo`03o`000?oooooooooo03Sooooo00?o0000ooooooooool0
0oooool00ol0003oooooooooo`0eooooo`Oo0000?oooool2o`000;?ooooo000Looooo`03o`000?oo
oooooooo03Sooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`0dooooo`So0000?ooo
ool2o`000:Sooooo00?o0000ooooooooool02?ooool001cooooo0ol0000hooooo`03o`000?oooooo
oooo00?ooooo00?o0000ooooooooool0=Oooool7o`0003oooooo0_l0002Xooooo`03o`000?oooooo
oooo00Sooooo000Looooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02_ooool00ol0
003oooooooooo`0<ooooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool0??ooool5o`00
0003ooooool0003ooooo03cooooo0ol0002Xooooo`03o`000?oooooooooo00Sooooo000Looooo`03
o`000?oooooooooo00Oooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0<ooooo`03
o`000?oooooooooo01;ooooo00?o0000ooooooooool0?Oooool3o`0000;ooooo00?o0000oooooooo
ool0>_ooool5o`000:Oooooo00?o0000ooooooooool02?ooool001cooooo00?o0000ooooooooool0
1oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00cooooo00?o0000ooooooooool0
Doooool2o`0000;ooooo00?o0000ooooooooool0>_ooool6o`000:Kooooo00?o0000ooooooooool0
2?ooool001cooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`0:ooooo`03o`000?oo
oooooooo00cooooo00?o0000ooooooooool0E?ooool01?l0003oooooooooool0000kooooo`Oo0000
Y_ooool00ol0003oooooooooo`08ooooo`007?ooool00ol0003oooooooooo`07ooooo`03o`000?oo
oooooooo00[ooooo00?o0000ooooooooool03?ooool00ol0003oooooooooo`0Hooooo`03o`000?oo
oooooooo03Wooooo00Co0000oooooooooooo0000??ooool6o`000;7ooooo00001?oooooo0000o`00
0?l00002ooooo`Go00000oooool2o`0000Cooooo0_l00006ooooo`03o`000?oooooooooo00Oooooo
00?o0000ooooooooool02_ooool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo01Sooooo
00?o0000ooooooooool0>Oooool01?l0003oooooooooool0000mooooo`Co0000/_ooool000;ooooo
00?o0000ooooooooool00_ooool01?l0003oooooooooool00002ooooo`04o`000?ooooooooooo`00
00;ooooo00Co0000oooooooooooo00001Oooool00ol0003oooooooooo`0iooooo`03o`000?oooooo
oooo00;ooooo00?o0000ooooooooool0>Oooool00ol0003oooooooooo`0nooooo`?o0000/oooool0
00;ooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`02ooooo`04o`000?oooooooooo
o`0000;ooooo00Co0000oooooooooooo00001Oooool4o`0003Sooooo00?o0000ooooooooool00_oo
ool00ol0003oooooooooo`0iooooo`03o`000?oooooooooo03oooooo00?o0000ooooooooool0/_oo
ool000;ooooo00?o0000ooooooooool01?ooool01Ol0003ooooooooooooooooo000000;ooooo00Co
0000oooooooooooo00000_ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo03Wooooo
00?o0000ooooooooool00_ooool00ol0003oooooooooo`3oooooobKooooo00?o0000ooooooooool0
2?ooool000;ooooo00Go0000ooooooooooooooooo`000003ooooo`04o`000?ooooooooooo`0000;o
oooo00Co0000oooooooooooo00000_ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo
03Wooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`3oooooobKooooo00?o0000oooo
ooooool02?ooool00003ooooool0003o000000?ooooo00Go0000ooooooooooooooooo`000002oooo
o`04o`000?ooooooooooo`0000;ooooo00Co0000oooooooooooo00001Oooool00ol0003ooooooooo
o`06ooooo`03o`000?oooooooooo00cooooo00?o0000ooooooooool02oooool00ol0003ooooooooo
o`0Cooooo`03o`000?oooooooooo047ooooo00?o0000ooooooooool0i_ooool00ol0003ooooooooo
o`08ooooo`000_ooool00ol0003oooooooooo`02ooooo`?o00001?ooool2o`0000Cooooo0_l00006
ooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool03?ooool00ol0003oooooooooo`0;
ooooo`03o`000?oooooooooo01?ooooo00?o0000ooooooooool0@Oooool00ol0003oooooooooo`3V
ooooo`03o`000?oooooooooo00Sooooo000Looooo`03o`000?oooooooooo00Kooooo00?o0000oooo
ooooool03?ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo05Gooooo00?o0000oooo
ool00000j?ooool00ol0003oooooooooo`08ooooo`007?ooool00ol0003oooooooooo`06ooooo`03
o`000?oooooooooo00cooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0Dooooo`03
o`000?oooooooooo03oooooo00?o0000ooooool00000j?ooool00ol0003oooooooooo`08ooooo`00
7?ooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo00cooooo00?o0000ooooooooool0
2_ooool00ol0003oooooooooo`0Cooooo`?o00000oooool00ol0003oooooooooo`0jooooo`03o`00
0?oooooo00000??ooooo000Looooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool03?oo
ool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo01;ooooo1Ol00002ooooo`03o`000?oo
oooooooo03[ooooo00?o0000ooooool00000loooool001cooooo0ol0000gooooo`Ko000000?ooooo
o`000?ooool0>oooool00ol0003oooooooooo`3cooooo`007?ooool00ol0003oooooooooo`0foooo
o`Oo000000?oooooo`000?ooool0>oooool00ol0003oooooooooo`3cooooo`007?ooool00ol0003o
ooooooooo`0gooooo`Ko000000?oooooo`000?ooool0oooooolWooooo`03o`000?oooooooooo00So
oooo000Looooo`03o`000?oooooooooo03Sooooo1?l00002ooooo`03o`000?oooooooooo0?oooooo
9_ooool00ol0003oooooooooo`08ooooo`007?ooool00ol0003oooooooooo`06ooooo`03o`000?oo
oooooooo00cooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0Cooooo`?o0000@_oo
ool00ol0003oooooooooo`3Uooooo`?o00002Oooool001cooooo00?o0000ooooooooool01_ooool0
0ol0003oooooooooo`0<ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool05?ooool2
o`0004;ooooo00?o0000ooooooooool0i?ooool5o`0000Sooooo000Looooo`03o`000?oooooooooo
00Kooooo00?o0000ooooooooool03?ooool2o`0000_ooooo00?o0000ooooooooool0Eoooool2o`00
0>Kooooo1_l00007ooooo`007?ooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo00co
oooo0ol0000:ooooo`03o`000?oooooooooo05Oooooo0_l0003Uooooo`Oo00001oooool001cooooo
00Go0000ooooooooooooooooo`000004ooooo`03o`000?oooooooooo00_ooooo1Ol000000ooooooo
0000ooooo`06ooooo`03o`000?oooooooooo01Wooooo00?o0000ooooooooool0>oooool2o`000>Ko
oooo1_l00007ooooo`007?ooool6o`0000?ooooo00?o0000ooooooooool02_ooool9o`0000Kooooo
00?o0000ooooooooool06Oooool00ol0003oooooooooo`0kooooo`;o0000ioooool4o`0000Sooooo
000Looooo`03o`000?oooooo000000Co00003_ooool:o`0001kooooo00Go0000oooooooooooooooo
o`00000mooooo`03o`000?oooooooooo0>Kooooo0ol00009ooooo`007?ooool8o`0000kooooo2_l0
000Mooooo`05o`000?ooooooooooooooool00000?Oooool00ol0003oooooooooo`3Wooooo`03o`00
0?oooooooooo00Sooooo000Looooo`So00003oooool9o`0001gooooo00Go0000oooooooooooooooo
o`00003ooooooc?ooooo000Looooo`So00004?ooool8o`0001kooooo00Co0000oooooooooooo0000
oooooolcooooo`007?ooool00ol0003oooooo`000004o`0000;ooooo00?o0000ooooooooool03Ooo
ool00ol0003oooooo`000003o`0000Kooooo00?o0000ooooooooool05_ooool00ol0003ooooooooo
o`0oooooo`03o`000?oooooooooo0?7ooooo000Looooo`03o`000?oooooooooo00?o00000oooool0
0ol0003oooooooooo`0@ooooo`;o00001oooool00ol0003oooooooooo`0Fooooo`03o`000?oooooo
oooo03kooooo0ol0003booooo`007?ooool01Ol0003ooooooooooooooooo000000Cooooo00?o0000
ooooooooool04Oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo05Kooooo1?l0003b
ooooo`007?ooool3o`0000Kooooo00?o0000ooooooooool06Oooool00ol0003oooooooooo`1Eoooo
o`Ko0000lOooool001cooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`0Iooooo`03
o`000?oooooooooo01Sooooo00?o0000ooooooooool0>Oooool7o`000?7ooooo000Looooo`03o`00
0?oooooooooo00Kooooo00?o0000ooooooooool06Oooool00ol0003oooooooooo`0Hooooo`03o`00
0?oooooooooo03[ooooo1_l0003aooooo`007?ooool00ol0003oooooooooo`0kooooo`03o`000?oo
oooo000003gooooo1?l0003booooo`007?ooool01Ol0003ooooooooooooooooo000001Sooooo00?o
0000ooooooooool07_ooool00ol0003oooooo`00000nooooo`;o0000loooool001cooooo00Go0000
ooooooooooooooooo`00000Hooooo`03o`000?oooooooooo01kooooo00?o0000ooooool00000?ooo
ool00ol0003oooooooooo`3aooooo`0000Coooooo`000?l0003o00001?ooool3o`0000?ooooo0_l0
0004ooooo`;o00001_ooool01Ol0003ooooooooooooooooo000001Sooooo00?o0000ooooooooool0
7_ooool00ol0003oooooo`00003oooooocCooooo0002ooooo`03o`000?oooooooooo00Cooooo00Go
0000ooooooooooooooooo`000002ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000oooooooo
ool00oooool01Ol0003ooooooooooooooooo000000Cooooo00?o0000ooooooooool04Oooool00ol0
003oooooooooo`05ooooo`03o`000?oooooooooo01Kooooo00?o0000ooooooooool0ooooooldoooo
o`000_ooool01?l0003oooooooooooooool5o`0000;ooooo00Co0000oooooooooooo00000_ooool0
1?l0003oooooooooool00005ooooo`05o`000?ooooooooooooooool000001?ooool00ol0003ooooo
ooooo`0Aooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool05_ooool00ol0003ooooo
ooooo`3oooooocCooooo0002ooooo`05o`000?ooooooooooooooool000000_ooool01Ol0003ooooo
oooooooooooo000000;ooooo00Co0000oooooooooooo00000_ooool00ol0003oooooooooo`03oooo
o`Go00001?ooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo00Gooooo00?o0000oooo
ooooool0oooooom=ooooo`000_ooool00ol0003oooooooooo`02ooooo`03o`000?oooooo000000?o
oooo00Co0000oooooooooooo00000_ooool01?l0003oooooooooool00005ooooo`03o`000?oooooo
oooo00Kooooo00?o0000ooooooooool06Oooool00ol0003oooooooooo`3oooooodgooooo00000ooo
oooo0000o`000005ooooo`;o00000oooool01?l0003oooooooooool00002ooooo`04o`000?oooooo
ooooo`0000Gooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`0Iooooo`03o`000?oo
oooooooo01Sooooo00?o0000ooooooooool0oooooolbooooo`000_ooool00ol0003oooooooooo`04
ooooo`03o`000?oooooooooo00;ooooo0_l00004ooooo`;o00001_ooool00ol0003oooooooooo`06
ooooo`03o`000?oooooooooo01Wooooo00?o0000ooooooooool06?ooool00ol0003oooooooooo`3o
oooooc;ooooo000Looooo`03o`000?oooooooooo03cooooo0_l0003oooooocCooooo000Looooo`05
o`000?ooooooooooooooool000006Oooool00ol0003oooooooooo`0Nooooo`;o0000ooooooldoooo
o`007?ooool01Ol0003ooooooooooooooooo000001Wooooo00?o0000ooooooooool07_ooool2o`00
0?oooooo=?ooool001cooooo00Go0000ooooooooooooooooo`00000Iooooo`03o`000?oooooooooo
01kooooo0_l0003oooooocCooooo000Looooo`?o000000?oooooo`000?ooool00oooool00ol0003o
ooooooooo`0Booooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool05oooool00ol0003o
ooooooooo`3ooooooc?ooooo000Looooo`05o`000?ooooooooooooooool000001?ooool00ol0003o
ooooooooo`0Booooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool05oooool00ol0003o
ooooooooo`3ooooooc?ooooo000Looooo`05o`000?ooooooooooooooool000001?ooool00ol0003o
ooooooooo`0Booooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool0oooooom=ooooo`00
7?ooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo01Wooooo00?o0000ooooooooool0
oooooom=ooooo`007?ooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo01Wooooo00?o
0000ooooooooool06?ooool00ol0003oooooooooo`3ooooooc;ooooo000Looooo`03o`000?oooooo
oooo00Kooooo00?o0000ooooooooool06Oooool00ol0003oooooooooo`0Hooooo`03o`000?oooooo
oooo0?oooooo<_ooool001cooooo00?o0000ooooooooool0??ooool2o`000?oooooo=?ooool001co
oooo00Go0000ooooooooooooooooo`00000Iooooo`03o`000?oooooooooo01kooooo0_l0003ooooo
ocCooooo000Looooo`05o`000?ooooooooooooooool000006Oooool00ol0003oooooooooo`0Noooo
o`;o0000ooooooldooooo`007?ooool3o`000003ooooool0003ooooo01Sooooo00?o0000oooooooo
ool07oooool00ol0003oooooooooo`3ooooooc;ooooo000Looooo`05o`000?ooooooooooooooool0
00001?ooool00ol0003oooooooooo`0Cooooo`03o`000?oooooooooo00?ooooo00?o0000oooooooo
ool05oooool3o`000?oooooo<oooool001cooooo00Go0000ooooooooooooooooo`000004ooooo`03
o`000?oooooooooo01?ooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`0Fooooo`Go
0000oooooolbooooo`007?ooool01Ol0003ooooooooooooooooo000000Cooooo00?o0000oooooooo
ool04oooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo01Gooooo1ol0003ooooooc7o
oooo000Looooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool06Oooool00ol0003ooooo
ooooo`0Dooooo`So0000oooooolaooooo`007?ooool00ol0003oooooooooo`06ooooo`03o`000?oo
oooooooo01Wooooo00?o0000ooooooooool05Oooool7o`000?oooooo<Oooool001cooooo00?o0000
ooooooooool01_ooool00ol0003oooooooooo`0Iooooo`03o`000?oooooooooo01Kooooo1Ol0003o
oooooc;ooooo000Looooo`03o`000?oooooooooo03cooooo0ol0003ooooooc?ooooo000Looooo`03
o`000?oooooooooo00;ooooo00?o0000ooooooooool05oooool00ol0003oooooooooo`0Nooooo`03
o`000?oooooooooo0?oooooo<_ooool001cooooo0ol00002ooooo`03o`000?oooooooooo01Oooooo
00?o0000ooooooooool0oooooomCooooo`007?ooool00ol0003oooooooooo`02ooooo`03o`000?oo
oooooooo01Oooooo00?o0000ooooooooool0oooooomCooooo`007?ooool00ol0003oooooooooo`02
ooooo`05o`000?ooooooooooooooool000005Oooool00ol0003oooooooooo`03ooooo`03o`000?oo
oooooooo0?ooooooCOooool001cooooo00?o0000ooooooooool00_ooool01Ol0003ooooooooooooo
oooo000001Gooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`3oooooodgooooo000L
ooooo`03o`000?oooooooooo00;ooooo00Go0000ooooooooooooooooo`00000Eooooo`03o`000?oo
oooooooo00?ooooo00?o0000ooooooooool0oooooom=ooooo`007?ooool00ol0003oooooooooo`06
ooooo`03o`000?oooooooooo01Wooooo00?o0000ooooooooool0oooooom=ooooo`0000Coooooo`00
0?l0003o00000oooool3o`0000Cooooo0_l00004ooooo`;o00001_ooool00ol0003oooooooooo`06
ooooo`03o`000?oooooooooo01Wooooo00?o0000ooooooooool0oooooom=ooooo`000_ooool01Ol0
003ooooooooooooooooo000000?ooooo00Co0000oooooooooooo00000_ooool01?l0003ooooooooo
ool00002ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool01_ooool00ol0003ooooo
ooooo`0Iooooo`03o`000?oooooooooo0?ooooooCOooool000;ooooo00Go0000oooooooooooooooo
o`000003ooooo`04o`000?ooooooooooo`0000;ooooo00Co0000oooooooooooo00000_ooool00ol0
003oooooooooo`03ooooo`Co0000oooooomaooooo`000_ooool01?l0003oooooooooooooool4o`00
00?ooooo00Co0000oooooooooooo00000_ooool01?l0003oooooooooool00005ooooo`03o`000?oo
oooooooo00;ooooo00?o0000ooooooooool05oooool00ol0003oooooooooo`3ooooooe?ooooo0002
ooooo`05o`000?ooooooooooooooool000001_ooool01?l0003oooooooooool00002ooooo`04o`00
0?ooooooooooo`0000Gooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`0Gooooo`03
o`000?oooooooooo0?ooooooDoooool00003ooooool0003o000000Cooooo00?o0000ooooooooool0
0oooool01?l0003oooooooooool00002ooooo`04o`000?ooooooooooo`0000Gooooo00?o0000oooo
ooooool00_ooool00ol0003oooooooooo`0Gooooo`03o`000?oooooooooo0?ooooooDoooool000;o
oooo00?o0000ooooooooool00oooool2o`0000Cooooo0_l00004ooooo`;o00001_ooool00ol0003o
ooooooooo`02ooooo`05o`000?ooooooooooooooool000005_ooool00ol0003oooooooooo`02oooo
o`03o`000?oooooooooo0?ooooooCOooool001cooooo00?o0000ooooooooool00_ooool01Ol0003o
oooooooooooooooo000001Kooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`3ooooo
odgooooo000Looooo`03o`000?oooooooooo00;ooooo00Go0000ooooooooooooooooo`00000Foooo
o`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0oooooom=ooooo`007?ooool00ol0003o
ooooooooo`06ooooo`03o`000?oooooooooo01Wooooo00?o0000ooooooooool0oooooom=ooooo`00
7?ooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo01Wooooo00?o0000ooooooooool0
oooooom=ooooo`007?ooool3o`0000Kooooo00?o0000ooooooooool06Oooool00ol0003ooooooooo
o`3oooooodgooooo000Looooo`03o`000?oooooooooo0?ooooooL_ooool001cooooo00?o0000oooo
ooooool00_ooool00ol0003oooooooooo`0Hooooo`03o`000?oooooooooo0?ooooooD_ooool001co
oooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`0Gooooo`?o0000oooooomCooooo`00
7?ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo01Kooooo1Ol0003ooooooe;ooooo
000Looooo`03o`000?oooooooooo00;ooooo00Go0000ooooooooooooooooo`00000Cooooo`Oo0000
00?oooooo`000?ooool0oooooom>ooooo`007?ooool00ol0003oooooooooo`02ooooo`05o`000?oo
ooooooooooooool000004_ooool8o`000003ooooool0003ooooo0?ooooooC_ooool001cooooo00?o
0000ooooooooool00_ooool01Ol0003ooooooooooooooooo000001?ooooo1ol000000ooooooo0000
ooooo`3oooooodkooooo000Looooo`?o00001_ooool00ol0003oooooooooo`0Booooo`Go000000?o
ooooo`000?ooool0oooooom?ooooo`007?ooool00ol0003oooooooooo`06ooooo`03o`000?oooooo
oooo01?ooooo0ol00002ooooo`03o`000?oooooooooo0?ooooooC_ooool001cooooo00?o0000oooo
ooooool01_ooool00ol0003oooooooooo`0Dooooo`05o`000?ooooooooooooooool00000oooooom@
ooooo`00oooooonAooooo`00oooooonAooooo`00oooooonAooooo`00\
\>"],
  ImageRangeCache->{{{0, 399}, {246.188, 0}} -> {-8.11617, 297.374, 0.282373, \
5.81884}}]
}, Open  ]],

Cell["\<\
Sempre per migliorare la leggibilit\[AGrave], si possono sostituire \
gli assi cartesiani con i corrispondenti bordi del grafico: in questo modo si \
evita che dei punti cadano su uno degli assi. Inoltre, per visualizzare \
l'informazione in modo completo, \[EGrave] opportuno settare opportunamente \
il range verticale di visualizzazione in modo da riuscire a vedere anche il \
primo picco:\
\>", "Text",
  PageWidth->PaperWidth],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(graph = 
        MultipleListPlot[ion, 
          SymbolShape \[Rule] {enlarge[PlotSymbol[Diamond], 2]}, 
          PlotJoined \[Rule] True, 
          PlotStyle \[Rule] {{AbsoluteThickness[0.25], 
                AbsoluteDashing[{5}]}}, PlotRange \[Rule] All, 
          Frame \[Rule] {True, True, False, False}];\)\)], "Input",
  CellLabel->"In[33]:=",
  PageWidth->PaperWidth],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
%%ImageSize: 400 247.214 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.01438 0.00942951 -0.0960424 0.000294803 [
[.01438 -0.0125 -3 -9 ]
[.01438 -0.0125 3 0 ]
[.20297 -0.0125 -6 -9 ]
[.20297 -0.0125 6 0 ]
[.39156 -0.0125 -6 -9 ]
[.39156 -0.0125 6 0 ]
[.58015 -0.0125 -6 -9 ]
[.58015 -0.0125 6 0 ]
[.76874 -0.0125 -6 -9 ]
[.76874 -0.0125 6 0 ]
[.95733 -0.0125 -9 -9 ]
[.95733 -0.0125 9 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .05136 -18 -4.5 ]
[-0.0125 .05136 0 4.5 ]
[-0.0125 .19876 -24 -4.5 ]
[-0.0125 .19876 0 4.5 ]
[-0.0125 .34616 -24 -4.5 ]
[-0.0125 .34616 0 4.5 ]
[-0.0125 .49356 -24 -4.5 ]
[-0.0125 .49356 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.01438 0 m
.01438 .00625 L
s
[(0)] .01438 -0.0125 0 1 Mshowa
.20297 0 m
.20297 .00625 L
s
[(20)] .20297 -0.0125 0 1 Mshowa
.39156 0 m
.39156 .00625 L
s
[(40)] .39156 -0.0125 0 1 Mshowa
.58015 0 m
.58015 .00625 L
s
[(60)] .58015 -0.0125 0 1 Mshowa
.76874 0 m
.76874 .00625 L
s
[(80)] .76874 -0.0125 0 1 Mshowa
.95733 0 m
.95733 .00625 L
s
[(100)] .95733 -0.0125 0 1 Mshowa
.125 Mabswid
.06153 0 m
.06153 .00375 L
s
.10868 0 m
.10868 .00375 L
s
.15582 0 m
.15582 .00375 L
s
.25012 0 m
.25012 .00375 L
s
.29727 0 m
.29727 .00375 L
s
.34441 0 m
.34441 .00375 L
s
.43871 0 m
.43871 .00375 L
s
.48586 0 m
.48586 .00375 L
s
.533 0 m
.533 .00375 L
s
.6273 0 m
.6273 .00375 L
s
.67445 0 m
.67445 .00375 L
s
.72159 0 m
.72159 .00375 L
s
.81589 0 m
.81589 .00375 L
s
.86304 0 m
.86304 .00375 L
s
.91018 0 m
.91018 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .05136 m
.00625 .05136 L
s
[(500)] -0.0125 .05136 1 0 Mshowa
0 .19876 m
.00625 .19876 L
s
[(1000)] -0.0125 .19876 1 0 Mshowa
0 .34616 m
.00625 .34616 L
s
[(1500)] -0.0125 .34616 1 0 Mshowa
0 .49356 m
.00625 .49356 L
s
[(2000)] -0.0125 .49356 1 0 Mshowa
.125 Mabswid
0 .08084 m
.00375 .08084 L
s
0 .11032 m
.00375 .11032 L
s
0 .1398 m
.00375 .1398 L
s
0 .16928 m
.00375 .16928 L
s
0 .22824 m
.00375 .22824 L
s
0 .25772 m
.00375 .25772 L
s
0 .2872 m
.00375 .2872 L
s
0 .31668 m
.00375 .31668 L
s
0 .37564 m
.00375 .37564 L
s
0 .40512 m
.00375 .40512 L
s
0 .4346 m
.00375 .4346 L
s
0 .46408 m
.00375 .46408 L
s
0 .02188 m
.00375 .02188 L
s
0 .52304 m
.00375 .52304 L
s
0 .55252 m
.00375 .55252 L
s
0 .582 m
.00375 .582 L
s
0 .61148 m
.00375 .61148 L
s
.25 Mabswid
0 0 m
0 .61803 L
s
[ 5 ] 0 Mabsdash
.02381 .29074 m
.03324 .60332 L
.04267 .05528 L
.0521 .1691 L
.06153 .13998 L
.07096 .22417 L
.08039 .28788 L
.08982 .2913 L
.09925 .39952 L
.10868 .51732 L
.1181 .05012 L
.12753 .12143 L
.13696 .07418 L
.14639 .13582 L
.15582 .20221 L
.16525 .19864 L
.17468 .27279 L
.18411 .35218 L
.19354 .02742 L
.20297 .0778 L
.2124 .08998 L
.22183 .09794 L
.23126 .09558 L
.24069 .09638 L
.25012 .11545 L
.25955 .1278 L
.26898 .12801 L
.27841 .12114 L
.28784 .1237 L
.29727 .17117 L
.30669 .07459 L
.31612 .12863 L
.32555 .18314 L
.33498 .18134 L
.34441 .24 L
.35384 .30215 L
.36327 .02276 L
.3727 .06595 L
.38213 .08556 L
.39156 .09853 L
.40099 .09971 L
.41042 .1059 L
.41985 .11091 L
.42928 .11356 L
.43871 .11622 L
.44814 .14127 L
.45757 .11946 L
.467 .16238 L
.47643 .06855 L
.48586 .11286 L
Mistroke
.49529 .14973 L
.50471 .1602 L
.51414 .20124 L
.52357 .249 L
.533 .01472 L
.54243 .05218 L
.55186 .06259 L
.56129 .05944 L
.57072 .05817 L
.58015 .06009 L
.58958 .06194 L
.59901 .06412 L
.60844 .06513 L
.61787 .07863 L
.6273 .0704 L
.63673 .07256 L
.64616 .07515 L
.65559 .07751 L
.66502 .07987 L
.67445 .08184 L
.68388 .05829 L
.69331 .09322 L
.70273 .1283 L
.71216 .13096 L
.72159 .12801 L
.73102 .15159 L
.74045 .16338 L
.74988 .16044 L
.75931 .16636 L
.76874 .20082 L
.77817 .07769 L
.7876 .11489 L
.79703 .11126 L
.80646 .14334 L
.81589 .17812 L
.82532 .20967 L
.83475 .02188 L
.84418 .0541 L
.85361 .05106 L
.86304 .07701 L
.87247 .07141 L
.8819 .07612 L
.89132 .07996 L
.90075 .07642 L
.91018 .07441 L
.91961 .07524 L
.92904 .08113 L
.93847 .0832 L
.9479 .08644 L
.95733 .0888 L
Mistroke
.96676 .09116 L
.97619 .28248 L
Mfstroke
.0001 w
[ ] 0 setdash
.02381 .29074 -3.75 0 Mabsadd m
.02381 .29074 0 5 Mabsadd L
.02381 .29074 3.75 0 Mabsadd L
.02381 .29074 0 -5 Mabsadd L
.02381 .29074 -3.75 0 Mabsadd L closepath F
.03324 .60332 -3.75 0 Mabsadd m
.03324 .60332 0 5 Mabsadd L
.03324 .60332 3.75 0 Mabsadd L
.03324 .60332 0 -5 Mabsadd L
.03324 .60332 -3.75 0 Mabsadd L closepath F
.04267 .05528 -3.75 0 Mabsadd m
.04267 .05528 0 5 Mabsadd L
.04267 .05528 3.75 0 Mabsadd L
.04267 .05528 0 -5 Mabsadd L
.04267 .05528 -3.75 0 Mabsadd L closepath F
.0521 .1691 -3.75 0 Mabsadd m
.0521 .1691 0 5 Mabsadd L
.0521 .1691 3.75 0 Mabsadd L
.0521 .1691 0 -5 Mabsadd L
.0521 .1691 -3.75 0 Mabsadd L closepath F
.06153 .13998 -3.75 0 Mabsadd m
.06153 .13998 0 5 Mabsadd L
.06153 .13998 3.75 0 Mabsadd L
.06153 .13998 0 -5 Mabsadd L
.06153 .13998 -3.75 0 Mabsadd L closepath F
.07096 .22417 -3.75 0 Mabsadd m
.07096 .22417 0 5 Mabsadd L
.07096 .22417 3.75 0 Mabsadd L
.07096 .22417 0 -5 Mabsadd L
.07096 .22417 -3.75 0 Mabsadd L closepath F
.08039 .28788 -3.75 0 Mabsadd m
.08039 .28788 0 5 Mabsadd L
.08039 .28788 3.75 0 Mabsadd L
.08039 .28788 0 -5 Mabsadd L
.08039 .28788 -3.75 0 Mabsadd L closepath F
.08982 .2913 -3.75 0 Mabsadd m
.08982 .2913 0 5 Mabsadd L
.08982 .2913 3.75 0 Mabsadd L
.08982 .2913 0 -5 Mabsadd L
.08982 .2913 -3.75 0 Mabsadd L closepath F
.09925 .39952 -3.75 0 Mabsadd m
.09925 .39952 0 5 Mabsadd L
.09925 .39952 3.75 0 Mabsadd L
.09925 .39952 0 -5 Mabsadd L
.09925 .39952 -3.75 0 Mabsadd L closepath F
.10868 .51732 -3.75 0 Mabsadd m
.10868 .51732 0 5 Mabsadd L
.10868 .51732 3.75 0 Mabsadd L
.10868 .51732 0 -5 Mabsadd L
.10868 .51732 -3.75 0 Mabsadd L closepath F
.1181 .05012 -3.75 0 Mabsadd m
.1181 .05012 0 5 Mabsadd L
.1181 .05012 3.75 0 Mabsadd L
.1181 .05012 0 -5 Mabsadd L
.1181 .05012 -3.75 0 Mabsadd L closepath F
.12753 .12143 -3.75 0 Mabsadd m
.12753 .12143 0 5 Mabsadd L
.12753 .12143 3.75 0 Mabsadd L
.12753 .12143 0 -5 Mabsadd L
.12753 .12143 -3.75 0 Mabsadd L closepath F
.13696 .07418 -3.75 0 Mabsadd m
.13696 .07418 0 5 Mabsadd L
.13696 .07418 3.75 0 Mabsadd L
.13696 .07418 0 -5 Mabsadd L
.13696 .07418 -3.75 0 Mabsadd L closepath F
.14639 .13582 -3.75 0 Mabsadd m
.14639 .13582 0 5 Mabsadd L
.14639 .13582 3.75 0 Mabsadd L
.14639 .13582 0 -5 Mabsadd L
.14639 .13582 -3.75 0 Mabsadd L closepath F
.15582 .20221 -3.75 0 Mabsadd m
.15582 .20221 0 5 Mabsadd L
.15582 .20221 3.75 0 Mabsadd L
.15582 .20221 0 -5 Mabsadd L
.15582 .20221 -3.75 0 Mabsadd L closepath F
.16525 .19864 -3.75 0 Mabsadd m
.16525 .19864 0 5 Mabsadd L
.16525 .19864 3.75 0 Mabsadd L
.16525 .19864 0 -5 Mabsadd L
.16525 .19864 -3.75 0 Mabsadd L closepath F
.17468 .27279 -3.75 0 Mabsadd m
.17468 .27279 0 5 Mabsadd L
.17468 .27279 3.75 0 Mabsadd L
.17468 .27279 0 -5 Mabsadd L
.17468 .27279 -3.75 0 Mabsadd L closepath F
.18411 .35218 -3.75 0 Mabsadd m
.18411 .35218 0 5 Mabsadd L
.18411 .35218 3.75 0 Mabsadd L
.18411 .35218 0 -5 Mabsadd L
.18411 .35218 -3.75 0 Mabsadd L closepath F
.19354 .02742 -3.75 0 Mabsadd m
.19354 .02742 0 5 Mabsadd L
.19354 .02742 3.75 0 Mabsadd L
.19354 .02742 0 -5 Mabsadd L
.19354 .02742 -3.75 0 Mabsadd L closepath F
.20297 .0778 -3.75 0 Mabsadd m
.20297 .0778 0 5 Mabsadd L
.20297 .0778 3.75 0 Mabsadd L
.20297 .0778 0 -5 Mabsadd L
.20297 .0778 -3.75 0 Mabsadd L closepath F
.2124 .08998 -3.75 0 Mabsadd m
.2124 .08998 0 5 Mabsadd L
.2124 .08998 3.75 0 Mabsadd L
.2124 .08998 0 -5 Mabsadd L
.2124 .08998 -3.75 0 Mabsadd L closepath F
.22183 .09794 -3.75 0 Mabsadd m
.22183 .09794 0 5 Mabsadd L
.22183 .09794 3.75 0 Mabsadd L
.22183 .09794 0 -5 Mabsadd L
.22183 .09794 -3.75 0 Mabsadd L closepath F
.23126 .09558 -3.75 0 Mabsadd m
.23126 .09558 0 5 Mabsadd L
.23126 .09558 3.75 0 Mabsadd L
.23126 .09558 0 -5 Mabsadd L
.23126 .09558 -3.75 0 Mabsadd L closepath F
.24069 .09638 -3.75 0 Mabsadd m
.24069 .09638 0 5 Mabsadd L
.24069 .09638 3.75 0 Mabsadd L
.24069 .09638 0 -5 Mabsadd L
.24069 .09638 -3.75 0 Mabsadd L closepath F
.25012 .11545 -3.75 0 Mabsadd m
.25012 .11545 0 5 Mabsadd L
.25012 .11545 3.75 0 Mabsadd L
.25012 .11545 0 -5 Mabsadd L
.25012 .11545 -3.75 0 Mabsadd L closepath F
.25955 .1278 -3.75 0 Mabsadd m
.25955 .1278 0 5 Mabsadd L
.25955 .1278 3.75 0 Mabsadd L
.25955 .1278 0 -5 Mabsadd L
.25955 .1278 -3.75 0 Mabsadd L closepath F
.26898 .12801 -3.75 0 Mabsadd m
.26898 .12801 0 5 Mabsadd L
.26898 .12801 3.75 0 Mabsadd L
.26898 .12801 0 -5 Mabsadd L
.26898 .12801 -3.75 0 Mabsadd L closepath F
.27841 .12114 -3.75 0 Mabsadd m
.27841 .12114 0 5 Mabsadd L
.27841 .12114 3.75 0 Mabsadd L
.27841 .12114 0 -5 Mabsadd L
.27841 .12114 -3.75 0 Mabsadd L closepath F
.28784 .1237 -3.75 0 Mabsadd m
.28784 .1237 0 5 Mabsadd L
.28784 .1237 3.75 0 Mabsadd L
.28784 .1237 0 -5 Mabsadd L
.28784 .1237 -3.75 0 Mabsadd L closepath F
.29727 .17117 -3.75 0 Mabsadd m
.29727 .17117 0 5 Mabsadd L
.29727 .17117 3.75 0 Mabsadd L
.29727 .17117 0 -5 Mabsadd L
.29727 .17117 -3.75 0 Mabsadd L closepath F
.30669 .07459 -3.75 0 Mabsadd m
.30669 .07459 0 5 Mabsadd L
.30669 .07459 3.75 0 Mabsadd L
.30669 .07459 0 -5 Mabsadd L
.30669 .07459 -3.75 0 Mabsadd L closepath F
.31612 .12863 -3.75 0 Mabsadd m
.31612 .12863 0 5 Mabsadd L
.31612 .12863 3.75 0 Mabsadd L
.31612 .12863 0 -5 Mabsadd L
.31612 .12863 -3.75 0 Mabsadd L closepath F
.32555 .18314 -3.75 0 Mabsadd m
.32555 .18314 0 5 Mabsadd L
.32555 .18314 3.75 0 Mabsadd L
.32555 .18314 0 -5 Mabsadd L
.32555 .18314 -3.75 0 Mabsadd L closepath F
.33498 .18134 -3.75 0 Mabsadd m
.33498 .18134 0 5 Mabsadd L
.33498 .18134 3.75 0 Mabsadd L
.33498 .18134 0 -5 Mabsadd L
.33498 .18134 -3.75 0 Mabsadd L closepath F
.34441 .24 -3.75 0 Mabsadd m
.34441 .24 0 5 Mabsadd L
.34441 .24 3.75 0 Mabsadd L
.34441 .24 0 -5 Mabsadd L
.34441 .24 -3.75 0 Mabsadd L closepath F
.35384 .30215 -3.75 0 Mabsadd m
.35384 .30215 0 5 Mabsadd L
.35384 .30215 3.75 0 Mabsadd L
.35384 .30215 0 -5 Mabsadd L
.35384 .30215 -3.75 0 Mabsadd L closepath F
.36327 .02276 -3.75 0 Mabsadd m
.36327 .02276 0 5 Mabsadd L
.36327 .02276 3.75 0 Mabsadd L
.36327 .02276 0 -5 Mabsadd L
.36327 .02276 -3.75 0 Mabsadd L closepath F
.3727 .06595 -3.75 0 Mabsadd m
.3727 .06595 0 5 Mabsadd L
.3727 .06595 3.75 0 Mabsadd L
.3727 .06595 0 -5 Mabsadd L
.3727 .06595 -3.75 0 Mabsadd L closepath F
.38213 .08556 -3.75 0 Mabsadd m
.38213 .08556 0 5 Mabsadd L
.38213 .08556 3.75 0 Mabsadd L
.38213 .08556 0 -5 Mabsadd L
.38213 .08556 -3.75 0 Mabsadd L closepath F
.39156 .09853 -3.75 0 Mabsadd m
.39156 .09853 0 5 Mabsadd L
.39156 .09853 3.75 0 Mabsadd L
.39156 .09853 0 -5 Mabsadd L
.39156 .09853 -3.75 0 Mabsadd L closepath F
.40099 .09971 -3.75 0 Mabsadd m
.40099 .09971 0 5 Mabsadd L
.40099 .09971 3.75 0 Mabsadd L
.40099 .09971 0 -5 Mabsadd L
.40099 .09971 -3.75 0 Mabsadd L closepath F
.41042 .1059 -3.75 0 Mabsadd m
.41042 .1059 0 5 Mabsadd L
.41042 .1059 3.75 0 Mabsadd L
.41042 .1059 0 -5 Mabsadd L
.41042 .1059 -3.75 0 Mabsadd L closepath F
.41985 .11091 -3.75 0 Mabsadd m
.41985 .11091 0 5 Mabsadd L
.41985 .11091 3.75 0 Mabsadd L
.41985 .11091 0 -5 Mabsadd L
.41985 .11091 -3.75 0 Mabsadd L closepath F
.42928 .11356 -3.75 0 Mabsadd m
.42928 .11356 0 5 Mabsadd L
.42928 .11356 3.75 0 Mabsadd L
.42928 .11356 0 -5 Mabsadd L
.42928 .11356 -3.75 0 Mabsadd L closepath F
.43871 .11622 -3.75 0 Mabsadd m
.43871 .11622 0 5 Mabsadd L
.43871 .11622 3.75 0 Mabsadd L
.43871 .11622 0 -5 Mabsadd L
.43871 .11622 -3.75 0 Mabsadd L closepath F
.44814 .14127 -3.75 0 Mabsadd m
.44814 .14127 0 5 Mabsadd L
.44814 .14127 3.75 0 Mabsadd L
.44814 .14127 0 -5 Mabsadd L
.44814 .14127 -3.75 0 Mabsadd L closepath F
.45757 .11946 -3.75 0 Mabsadd m
.45757 .11946 0 5 Mabsadd L
.45757 .11946 3.75 0 Mabsadd L
.45757 .11946 0 -5 Mabsadd L
.45757 .11946 -3.75 0 Mabsadd L closepath F
.467 .16238 -3.75 0 Mabsadd m
.467 .16238 0 5 Mabsadd L
.467 .16238 3.75 0 Mabsadd L
.467 .16238 0 -5 Mabsadd L
.467 .16238 -3.75 0 Mabsadd L closepath F
.47643 .06855 -3.75 0 Mabsadd m
.47643 .06855 0 5 Mabsadd L
.47643 .06855 3.75 0 Mabsadd L
.47643 .06855 0 -5 Mabsadd L
.47643 .06855 -3.75 0 Mabsadd L closepath F
.48586 .11286 -3.75 0 Mabsadd m
.48586 .11286 0 5 Mabsadd L
.48586 .11286 3.75 0 Mabsadd L
.48586 .11286 0 -5 Mabsadd L
.48586 .11286 -3.75 0 Mabsadd L closepath F
.49529 .14973 -3.75 0 Mabsadd m
.49529 .14973 0 5 Mabsadd L
.49529 .14973 3.75 0 Mabsadd L
.49529 .14973 0 -5 Mabsadd L
.49529 .14973 -3.75 0 Mabsadd L closepath F
.50471 .1602 -3.75 0 Mabsadd m
.50471 .1602 0 5 Mabsadd L
.50471 .1602 3.75 0 Mabsadd L
.50471 .1602 0 -5 Mabsadd L
.50471 .1602 -3.75 0 Mabsadd L closepath F
.51414 .20124 -3.75 0 Mabsadd m
.51414 .20124 0 5 Mabsadd L
.51414 .20124 3.75 0 Mabsadd L
.51414 .20124 0 -5 Mabsadd L
.51414 .20124 -3.75 0 Mabsadd L closepath F
.52357 .249 -3.75 0 Mabsadd m
.52357 .249 0 5 Mabsadd L
.52357 .249 3.75 0 Mabsadd L
.52357 .249 0 -5 Mabsadd L
.52357 .249 -3.75 0 Mabsadd L closepath F
.533 .01472 -3.75 0 Mabsadd m
.533 .01472 0 5 Mabsadd L
.533 .01472 3.75 0 Mabsadd L
.533 .01472 0 -5 Mabsadd L
.533 .01472 -3.75 0 Mabsadd L closepath F
.54243 .05218 -3.75 0 Mabsadd m
.54243 .05218 0 5 Mabsadd L
.54243 .05218 3.75 0 Mabsadd L
.54243 .05218 0 -5 Mabsadd L
.54243 .05218 -3.75 0 Mabsadd L closepath F
.55186 .06259 -3.75 0 Mabsadd m
.55186 .06259 0 5 Mabsadd L
.55186 .06259 3.75 0 Mabsadd L
.55186 .06259 0 -5 Mabsadd L
.55186 .06259 -3.75 0 Mabsadd L closepath F
.56129 .05944 -3.75 0 Mabsadd m
.56129 .05944 0 5 Mabsadd L
.56129 .05944 3.75 0 Mabsadd L
.56129 .05944 0 -5 Mabsadd L
.56129 .05944 -3.75 0 Mabsadd L closepath F
.57072 .05817 -3.75 0 Mabsadd m
.57072 .05817 0 5 Mabsadd L
.57072 .05817 3.75 0 Mabsadd L
.57072 .05817 0 -5 Mabsadd L
.57072 .05817 -3.75 0 Mabsadd L closepath F
.58015 .06009 -3.75 0 Mabsadd m
.58015 .06009 0 5 Mabsadd L
.58015 .06009 3.75 0 Mabsadd L
.58015 .06009 0 -5 Mabsadd L
.58015 .06009 -3.75 0 Mabsadd L closepath F
.58958 .06194 -3.75 0 Mabsadd m
.58958 .06194 0 5 Mabsadd L
.58958 .06194 3.75 0 Mabsadd L
.58958 .06194 0 -5 Mabsadd L
.58958 .06194 -3.75 0 Mabsadd L closepath F
.59901 .06412 -3.75 0 Mabsadd m
.59901 .06412 0 5 Mabsadd L
.59901 .06412 3.75 0 Mabsadd L
.59901 .06412 0 -5 Mabsadd L
.59901 .06412 -3.75 0 Mabsadd L closepath F
.60844 .06513 -3.75 0 Mabsadd m
.60844 .06513 0 5 Mabsadd L
.60844 .06513 3.75 0 Mabsadd L
.60844 .06513 0 -5 Mabsadd L
.60844 .06513 -3.75 0 Mabsadd L closepath F
.61787 .07863 -3.75 0 Mabsadd m
.61787 .07863 0 5 Mabsadd L
.61787 .07863 3.75 0 Mabsadd L
.61787 .07863 0 -5 Mabsadd L
.61787 .07863 -3.75 0 Mabsadd L closepath F
.6273 .0704 -3.75 0 Mabsadd m
.6273 .0704 0 5 Mabsadd L
.6273 .0704 3.75 0 Mabsadd L
.6273 .0704 0 -5 Mabsadd L
.6273 .0704 -3.75 0 Mabsadd L closepath F
.63673 .07256 -3.75 0 Mabsadd m
.63673 .07256 0 5 Mabsadd L
.63673 .07256 3.75 0 Mabsadd L
.63673 .07256 0 -5 Mabsadd L
.63673 .07256 -3.75 0 Mabsadd L closepath F
.64616 .07515 -3.75 0 Mabsadd m
.64616 .07515 0 5 Mabsadd L
.64616 .07515 3.75 0 Mabsadd L
.64616 .07515 0 -5 Mabsadd L
.64616 .07515 -3.75 0 Mabsadd L closepath F
.65559 .07751 -3.75 0 Mabsadd m
.65559 .07751 0 5 Mabsadd L
.65559 .07751 3.75 0 Mabsadd L
.65559 .07751 0 -5 Mabsadd L
.65559 .07751 -3.75 0 Mabsadd L closepath F
.66502 .07987 -3.75 0 Mabsadd m
.66502 .07987 0 5 Mabsadd L
.66502 .07987 3.75 0 Mabsadd L
.66502 .07987 0 -5 Mabsadd L
.66502 .07987 -3.75 0 Mabsadd L closepath F
.67445 .08184 -3.75 0 Mabsadd m
.67445 .08184 0 5 Mabsadd L
.67445 .08184 3.75 0 Mabsadd L
.67445 .08184 0 -5 Mabsadd L
.67445 .08184 -3.75 0 Mabsadd L closepath F
.68388 .05829 -3.75 0 Mabsadd m
.68388 .05829 0 5 Mabsadd L
.68388 .05829 3.75 0 Mabsadd L
.68388 .05829 0 -5 Mabsadd L
.68388 .05829 -3.75 0 Mabsadd L closepath F
.69331 .09322 -3.75 0 Mabsadd m
.69331 .09322 0 5 Mabsadd L
.69331 .09322 3.75 0 Mabsadd L
.69331 .09322 0 -5 Mabsadd L
.69331 .09322 -3.75 0 Mabsadd L closepath F
.70273 .1283 -3.75 0 Mabsadd m
.70273 .1283 0 5 Mabsadd L
.70273 .1283 3.75 0 Mabsadd L
.70273 .1283 0 -5 Mabsadd L
.70273 .1283 -3.75 0 Mabsadd L closepath F
.71216 .13096 -3.75 0 Mabsadd m
.71216 .13096 0 5 Mabsadd L
.71216 .13096 3.75 0 Mabsadd L
.71216 .13096 0 -5 Mabsadd L
.71216 .13096 -3.75 0 Mabsadd L closepath F
.72159 .12801 -3.75 0 Mabsadd m
.72159 .12801 0 5 Mabsadd L
.72159 .12801 3.75 0 Mabsadd L
.72159 .12801 0 -5 Mabsadd L
.72159 .12801 -3.75 0 Mabsadd L closepath F
.73102 .15159 -3.75 0 Mabsadd m
.73102 .15159 0 5 Mabsadd L
.73102 .15159 3.75 0 Mabsadd L
.73102 .15159 0 -5 Mabsadd L
.73102 .15159 -3.75 0 Mabsadd L closepath F
.74045 .16338 -3.75 0 Mabsadd m
.74045 .16338 0 5 Mabsadd L
.74045 .16338 3.75 0 Mabsadd L
.74045 .16338 0 -5 Mabsadd L
.74045 .16338 -3.75 0 Mabsadd L closepath F
.74988 .16044 -3.75 0 Mabsadd m
.74988 .16044 0 5 Mabsadd L
.74988 .16044 3.75 0 Mabsadd L
.74988 .16044 0 -5 Mabsadd L
.74988 .16044 -3.75 0 Mabsadd L closepath F
.75931 .16636 -3.75 0 Mabsadd m
.75931 .16636 0 5 Mabsadd L
.75931 .16636 3.75 0 Mabsadd L
.75931 .16636 0 -5 Mabsadd L
.75931 .16636 -3.75 0 Mabsadd L closepath F
.76874 .20082 -3.75 0 Mabsadd m
.76874 .20082 0 5 Mabsadd L
.76874 .20082 3.75 0 Mabsadd L
.76874 .20082 0 -5 Mabsadd L
.76874 .20082 -3.75 0 Mabsadd L closepath F
.77817 .07769 -3.75 0 Mabsadd m
.77817 .07769 0 5 Mabsadd L
.77817 .07769 3.75 0 Mabsadd L
.77817 .07769 0 -5 Mabsadd L
.77817 .07769 -3.75 0 Mabsadd L closepath F
.7876 .11489 -3.75 0 Mabsadd m
.7876 .11489 0 5 Mabsadd L
.7876 .11489 3.75 0 Mabsadd L
.7876 .11489 0 -5 Mabsadd L
.7876 .11489 -3.75 0 Mabsadd L closepath F
.79703 .11126 -3.75 0 Mabsadd m
.79703 .11126 0 5 Mabsadd L
.79703 .11126 3.75 0 Mabsadd L
.79703 .11126 0 -5 Mabsadd L
.79703 .11126 -3.75 0 Mabsadd L closepath F
.80646 .14334 -3.75 0 Mabsadd m
.80646 .14334 0 5 Mabsadd L
.80646 .14334 3.75 0 Mabsadd L
.80646 .14334 0 -5 Mabsadd L
.80646 .14334 -3.75 0 Mabsadd L closepath F
.81589 .17812 -3.75 0 Mabsadd m
.81589 .17812 0 5 Mabsadd L
.81589 .17812 3.75 0 Mabsadd L
.81589 .17812 0 -5 Mabsadd L
.81589 .17812 -3.75 0 Mabsadd L closepath F
.82532 .20967 -3.75 0 Mabsadd m
.82532 .20967 0 5 Mabsadd L
.82532 .20967 3.75 0 Mabsadd L
.82532 .20967 0 -5 Mabsadd L
.82532 .20967 -3.75 0 Mabsadd L closepath F
.83475 .02188 -3.75 0 Mabsadd m
.83475 .02188 0 5 Mabsadd L
.83475 .02188 3.75 0 Mabsadd L
.83475 .02188 0 -5 Mabsadd L
.83475 .02188 -3.75 0 Mabsadd L closepath F
.84418 .0541 -3.75 0 Mabsadd m
.84418 .0541 0 5 Mabsadd L
.84418 .0541 3.75 0 Mabsadd L
.84418 .0541 0 -5 Mabsadd L
.84418 .0541 -3.75 0 Mabsadd L closepath F
.85361 .05106 -3.75 0 Mabsadd m
.85361 .05106 0 5 Mabsadd L
.85361 .05106 3.75 0 Mabsadd L
.85361 .05106 0 -5 Mabsadd L
.85361 .05106 -3.75 0 Mabsadd L closepath F
.86304 .07701 -3.75 0 Mabsadd m
.86304 .07701 0 5 Mabsadd L
.86304 .07701 3.75 0 Mabsadd L
.86304 .07701 0 -5 Mabsadd L
.86304 .07701 -3.75 0 Mabsadd L closepath F
.87247 .07141 -3.75 0 Mabsadd m
.87247 .07141 0 5 Mabsadd L
.87247 .07141 3.75 0 Mabsadd L
.87247 .07141 0 -5 Mabsadd L
.87247 .07141 -3.75 0 Mabsadd L closepath F
.8819 .07612 -3.75 0 Mabsadd m
.8819 .07612 0 5 Mabsadd L
.8819 .07612 3.75 0 Mabsadd L
.8819 .07612 0 -5 Mabsadd L
.8819 .07612 -3.75 0 Mabsadd L closepath F
.89132 .07996 -3.75 0 Mabsadd m
.89132 .07996 0 5 Mabsadd L
.89132 .07996 3.75 0 Mabsadd L
.89132 .07996 0 -5 Mabsadd L
.89132 .07996 -3.75 0 Mabsadd L closepath F
.90075 .07642 -3.75 0 Mabsadd m
.90075 .07642 0 5 Mabsadd L
.90075 .07642 3.75 0 Mabsadd L
.90075 .07642 0 -5 Mabsadd L
.90075 .07642 -3.75 0 Mabsadd L closepath F
.91018 .07441 -3.75 0 Mabsadd m
.91018 .07441 0 5 Mabsadd L
.91018 .07441 3.75 0 Mabsadd L
.91018 .07441 0 -5 Mabsadd L
.91018 .07441 -3.75 0 Mabsadd L closepath F
.91961 .07524 -3.75 0 Mabsadd m
.91961 .07524 0 5 Mabsadd L
.91961 .07524 3.75 0 Mabsadd L
.91961 .07524 0 -5 Mabsadd L
.91961 .07524 -3.75 0 Mabsadd L closepath F
.92904 .08113 -3.75 0 Mabsadd m
.92904 .08113 0 5 Mabsadd L
.92904 .08113 3.75 0 Mabsadd L
.92904 .08113 0 -5 Mabsadd L
.92904 .08113 -3.75 0 Mabsadd L closepath F
.93847 .0832 -3.75 0 Mabsadd m
.93847 .0832 0 5 Mabsadd L
.93847 .0832 3.75 0 Mabsadd L
.93847 .0832 0 -5 Mabsadd L
.93847 .0832 -3.75 0 Mabsadd L closepath F
.9479 .08644 -3.75 0 Mabsadd m
.9479 .08644 0 5 Mabsadd L
.9479 .08644 3.75 0 Mabsadd L
.9479 .08644 0 -5 Mabsadd L
.9479 .08644 -3.75 0 Mabsadd L closepath F
.95733 .0888 -3.75 0 Mabsadd m
.95733 .0888 0 5 Mabsadd L
.95733 .0888 3.75 0 Mabsadd L
.95733 .0888 0 -5 Mabsadd L
.95733 .0888 -3.75 0 Mabsadd L closepath F
.96676 .09116 -3.75 0 Mabsadd m
.96676 .09116 0 5 Mabsadd L
.96676 .09116 3.75 0 Mabsadd L
.96676 .09116 0 -5 Mabsadd L
.96676 .09116 -3.75 0 Mabsadd L closepath F
.97619 .28248 -3.75 0 Mabsadd m
.97619 .28248 0 5 Mabsadd L
.97619 .28248 3.75 0 Mabsadd L
.97619 .28248 0 -5 Mabsadd L
.97619 .28248 -3.75 0 Mabsadd L closepath F
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[33]:=",
  ImageSize->{400, 247.188},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006@0000mb000`400?l00000o`00003ooooooonA
ooooo`00oooooonAooooo`00oooooonAooooo`008?ooool2o`0003oooooo1Ol00003ooooo`;o0000
?_ooool3o`0000?ooooo0_l0000mooooo`?o00001?ooool2o`0003gooooo0ol00004ooooo`;o0000
>_ooool3o`0000Cooooo0_l00004ooooo`;o00002_ooool001oooooo00Co0000oooooooooooo0000
?oooool01?l0003oooooooooool00002ooooo`04o`000?ooooooooooo`0003kooooo00Go0000oooo
ooooooooooooo`000002ooooo`03o`000?oooooooooo03Wooooo00Go0000ooooooooooooooooo`00
0002ooooo`04o`000?ooooooooooo`0003_ooooo00Go0000ooooooooooooooooo`000002ooooo`04
o`000?ooooooooooo`0003[ooooo00?o0000ooooooooool00_ooool01?l0003oooooooooool00002
ooooo`04o`000?ooooooooooo`0000Wooooo000Oooooo`04o`000?ooooooooooo`00043ooooo00?o
0000ooooooooool00_ooool01?l0003oooooooooool0000kooooo`Go00000_ooool01?l0003ooooo
ooooool0000kooooo`05o`000?ooooooooooooooool000000_ooool01?l0003oooooooooool0000k
ooooo`05o`000?ooooooooooooooool000000_ooool01?l0003oooooooooool0000jooooo`03o`00
0?oooooooooo00;ooooo00Co0000oooooooooooo00000_ooool01?l0003oooooooooool00009oooo
o`007oooool01?l0003oooooooooool00011ooooo`05o`000?ooooooooooooooool000000_ooool0
0ol0003oooooooooo`0iooooo`04o`000?ooooooooooo`0000?ooooo00Co0000oooooooooooo0000
>oooool4o`0000?ooooo00Co0000oooooooooooo0000??ooool3o`0000?ooooo00Co0000oooooooo
oooo0000>_ooool00ol0003oooooooooo`02ooooo`04o`000?ooooooooooo`0000;ooooo00Co0000
oooooooooooo00002Oooool001oooooo00Co0000oooooooooooo0000?_ooool01Ol0003ooooooooo
oooooooo000000;ooooo00Co0000oooooooooooo0000??ooool00ol0003oooooo`000003ooooo`04
o`000?ooooooooooo`0003_ooooo00?o0000ooooooooool01?ooool01?l0003oooooooooool0000k
ooooo`05o`000?ooooooooooooooool000000_ooool01?l0003oooooooooool0000jooooo`03o`00
0?oooooooooo00;ooooo00Co0000oooooooooooo00000_ooool01?l0003oooooooooool00009oooo
o`007oooool01?l0003oooooooooool0000nooooo`05o`000?ooooooooooooooool000000_ooool0
1?l0003oooooooooool0000mooooo`;o00000oooool01?l0003oooooooooool0000looooo`03o`00
0?oooooooooo00?ooooo00Co0000oooooooooooo0000>oooool01Ol0003ooooooooooooooooo0000
00;ooooo00Co0000oooooooooooo0000>Oooool2o`0000Cooooo00Co0000oooooooooooo00000_oo
ool01?l0003oooooooooool00009ooooo`008?ooool2o`00043ooooo0ol00004ooooo`;o0000?ooo
ool00ol0003oooooooooo`02ooooo`;o0000?_ooool2o`0000Cooooo0_l0000mooooo`?o00001?oo
ool2o`0003_ooooo00?o0000ooooooooool00oooool2o`0000Cooooo0_l0000:ooooo`00oooooonA
ooooo`00oooooonAooooo`00oooooonAooooo`00oooooonAooooo`00oooooonAooooo`00oooooonA
ooooo`007?ooooooo`0007Go0000000Looooo`03o`000?oooooooooo00;ooooo00?o0000oooooooo
ool03oooool00ol0003oooooooooo`0>ooooo`03o`000?oooooooooo00oooooo00?o0000oooooooo
ool03_ooool00ol0003oooooooooo`0?ooooo`03o`000?oooooooooo00kooooo00?o0000oooooooo
ool03oooool00ol0003oooooooooo`0>ooooo`03o`000?oooooooooo00oooooo00?o0000oooooooo
ool03_ooool00ol0003oooooooooo`0?ooooo`03o`000?oooooooooo00kooooo00?o0000oooooooo
ool03_ooool00ol0003oooooooooo`0?ooooo`03o`000?oooooooooo00kooooo00?o0000oooooooo
ool03oooool00ol0003oooooooooo`0>ooooo`03o`000?oooooooooo00oooooo00?o0000oooooooo
ool03_ooool00ol0003oooooooooo`0?ooooo`03o`000?oooooooooo00kooooo000Looooo`03o`00
0?oooooooooo00;ooooo00?o0000ooooooooool0@oooool00ol0003oooooooooo`13ooooo`03o`00
0?oooooooooo03;ooooo00?o0000ooooooooool03_ooool00ol0003oooooooooo`13ooooo`03o`00
0?oooooooooo04?ooooo00?o0000ooooooooool03_ooool001cooooo00?o0000ooooooooool0`_oo
ool3o`000:cooooo000Looooo`03o`000?oooooooooo0<7ooooo1?l0002/ooooo`007?ooool00ol0
003oooooooooo`24ooooo`03o`000?oooooooooo03Wooooo1_l0001/ooooo`03o`000?oooooooooo
03cooooo000Looooo`03o`000?oooooooooo08?ooooo0ol0000iooooo`Oo0000Joooool3o`0003go
oooo000Looooo`03o`000?oooooooooo04Gooooo00?o0000ooooooooool0>_ooool4o`0003[ooooo
1_l0001Zooooo`Go0000??ooool001cooooo0ol00014ooooo`?o0000>_ooool6o`0003[ooooo1?l0
001[ooooo`Ko0000>oooool001cooooo00?o0000ooooooooool0@oooool5o`0003Sooooo1ol0000k
ooooo`?o0000J_ooool7o`0003_ooooo000Looooo`03o`000?oooooooooo04;ooooo1ol0000hoooo
o`Ko0000??ooool2o`0006_ooooo1_l0000kooooo`007?ooool00ol0003oooooooooo`11ooooo`So
0000>Oooool4o`0003cooooo00?o0000ooooooooool0K?ooool4o`0003cooooo000Looooo`03o`00
0?oooooooooo04;ooooo1ol0000jooooo`;o0000?Oooool00ol0003oooooooooo`1/ooooo`?o0000
?Oooool001cooooo00?o0000ooooooooool0@oooool5o`0003cooooo00?o0000ooooooooool0>ooo
ool00ol0003oooooooooo`1]ooooo`03o`000?oooooooooo03cooooo000Looooo`03o`000?oooooo
oooo04Cooooo0ol0000looooo`03o`000?oooooo000003cooooo00Co0000oooooooooooo0000K?oo
ool00ol0003oooooooooo`0looooo`007?ooool00ol0003oooooooooo`0Yooooo`03o`000?oooooo
oooo01Wooooo0_l0000looooo`03o`000?oooooo000003cooooo00Co0000oooooooooooo0000K?oo
ool00ol0003oooooooooo`0looooo`001oooool3o`0000Cooooo0_l00004ooooo`;o00001_ooool0
0ol0003oooooooooo`0Xooooo`?o00006_ooool2o`0003cooooo00?o0000ooooool00000??ooool0
0ol0003oooooooooo`02o`0006_ooooo00Co0000oooooooooooo00000oooool00ol0003ooooooooo
o`0eooooo`001_ooool01Ol0003ooooooooooooooooo000000;ooooo00Co0000oooooooooooo0000
0_ooool01?l0003oooooooooool00005ooooo`03o`000?oooooooooo00gooooo00?o0000oooooooo
ool05oooool5o`0001Wooooo00?o0000ooooooooool0OOooool3o`0006[ooooo00?o0000oooooooo
ool00_l000001?oooooo0000o`000?l0000fooooo`002_ooool01?l0003oooooooooool00002oooo
o`04o`000?ooooooooooo`0000;ooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`0<
ooooo`?o00005oooool7o`0001Sooooo00?o0000ooooooooool0O?ooool5o`0000Sooooo00?o0000
ooooooooool09_ooool00ol0003oooooooooo`0eooooo`03o`000?oooooooooo00Oo0000=Oooool0
00[ooooo00Co0000oooooooooooo00000_ooool01?l0003oooooooooool00002ooooo`03o`000?oo
oooooooo00?ooooo0ol0000;ooooo`Go00005Oooool8o`0001Sooooo00?o0000ooooooooool0Nooo
ool7o`0000?ooooo00?o0000ooooooooool00ol000000ooooooo0000ooooo`0Sooooo`?o0000=_oo
ool00ol0003oooooo`000008o`0003Cooooo0006ooooo`Co00000oooool01?l0003oooooooooool0
0002ooooo`04o`000?ooooooooooo`0000Gooooo00?o0000ooooooooool02_ooool7o`0001Gooooo
1ol0002Eooooo`Wo000000?oooooo`000?l000002?l000000ooooooo0000ooooo`0Oooooo`Go0000
=_ooool:o`0003Cooooo0006ooooo`03o`000?oooooooooo00Cooooo00Co0000oooooooooooo0000
0_ooool01?l0003oooooooooool00005ooooo`03o`000?oooooooooo00Wooooo2?l0000Fooooo`Go
00006oooool00ol0003oooooooooo`0iooooo`03o`000?oooooooooo00;o0000>_oooolGo`0000;o
oooo00Co0000oooooooooooo00006Oooool6o`0003Cooooo2ol0000dooooo`001_ooool5o`0000?o
oooo0_l00004ooooo`;o00001_ooool00ol0003oooooooooo`0:ooooo`Oo00005oooool3o`0001co
oooo00?o0000ooooooooool0>Oooool00ol0003oooooooooo`03o`0002Gooooo00?o0000oooooooo
ool04Oooool00ol0003oooooo`00000Ko`0001Oooooo1ol0000eooooo`Wo0000=Oooool001cooooo
00?o0000ooooooooool02oooool5o`0001Wooooo00?o0000ooooooooool06oooool00ol0003ooooo
ooooo`0iooooo`03o`000?oooooo000000Co00008oooool3o`0001;ooooo00?o0000ooooooooool0
7?l00004ooooo`03o`000?oooooooooo013ooooo1_l0000fooooo`So00001?ooool00ol0003ooooo
ooooo`0^ooooo`007?ooool00ol0003oooooooooo`0<ooooo`?o00006_ooool00ol0003ooooooooo
o`04ooooo`03o`000?oooooooooo017ooooo00Go0000ooooooooooooooooo`00000Vooooo`03o`00
0?oooooooooo017ooooo2?l0000Qooooo`Co00004_ooool01?l0003ooooooooooooooolLo`0000;o
oooo0ol00002ooooo`03o`000?oooooooooo00gooooo1?l0000dooooo`04o`000?oooooooooooooo
o`?o000000Coooooo`000?oooooo00000oooool3o`0000cooooo00?o0000ooooooooool08?ooool0
01cooooo00?o0000ooooooooool03Oooool00ol0003oooooooooo`0Iooooo`03o`000?oooooooooo
00?ooooo0ol0000Booooo`05o`000?ooooooooooooooool000009Oooool3o`0001;ooooo2?l0000P
ooooo`Ko00004Oooool00ol0003oooooooooo`02oooooa_o000000?oooooo`000?l000001_l00000
0ooooooo0000ooooo`02ooooo`03o`000?oooooooooo00Kooooo0ol0000eooooo`03o`000?oooooo
oooo00;ooooo00?o0000ooooooooool00_ooool00ol0003oooooo`000005o`000003ooooool0003o
oooo00Gooooo00?o0000ooooool000000_l00002ooooo`03o`000?oooooooooo01cooooo000Loooo
o`03o`000?oooooooooo00gooooo00?o0000ooooooooool06_ooool01?l0003oooooooooooooool5
o`00017ooooo00Go0000ooooooooooooooooo`00000Tooooo`Co00004_ooool8o`0001oooooo1ol0
000Aooooo`03o`000?oooooooooo00?ooooo1ol00002ooooo`03o`000?oooooo000001[o000000Ko
ooooo`000?l0003o0000ooooool00005ooooo`?o00008Oooool00ol0003oooooooooo`0Aooooo`03
o`000?oooooooooo00Sooooo2_l000001?oooooo0000ooooooooool:o`0001gooooo000Looooo`03
o`000?oooooooooo00gooooo00?o0000ooooooooool06_ooool00ol0003oooooooooo`07o`00013o
oooo00?o0000ooooooooool00ol0000Rooooo`Ko00004oooool5o`00027ooooo1_l0000Hooooo`;o
00000_ooool00ol0003oooooooooo`04ooooo`03o`000?oooooo000001ko00000_ooool00ol0003o
ooooo`000002ooooo`03o`000?oooooooooo01gooooo0ol0000Booooo`03o`000?oooooooooo00Oo
oooo6Ol000000ooooooo0000ooooo`0Jooooo`007?ooool00ol0003oooooooooo`0>ooooo`03o`00
0?oooooooooo01Wooooo00?o0000ooooool000001ol0000@ooooo`03o`000?oooooo000000Co0000
8?ooool7o`0001Cooooo0ol00002ooooo`03o`000?oooooooooo01kooooo1?l0000Jooooo`03o`00
0?oooooooooo00[ooooo00?o0000ooooooooool07ol0000Rooooo`Go00004Oooool00ol0003ooooo
ooooo`06oooooago00000_ooool00ol0003oooooooooo`0Eooooo`007?ooool00ol0003ooooooooo
o`0>ooooo`03o`000?oooooooooo01Sooooo00Co0000oooooooooooooooo1ol0000@ooooo`03o`00
0?oooooo000000Go00008?ooool6o`0001Gooooo00?o0000ooooooooool00ol0000Pooooo`;o0000
;?ooool00ol0003oooooooooo`0Lo`00027ooooo1_l0000@ooooo`03o`000?oooooooooo00Gooooo
8_l000000ooooooo0000ooooo`0Cooooo`007?ooool3o`0000kooooo00?o0000ooooooooool06?oo
ool00ol0003oooooooooo`02ooooo`Go00004_ooool8o`00023ooooo1?l0000Hooooo`Co00008?oo
ool2o`0002oooooo7Ol0000Oooooo`Oo00006OoooolTo`0000;ooooo00?o0000ooooooooool03_oo
ool001cooooo00?o0000ooooooooool03Oooool00ol0003oooooooooo`0Iooooo`03o`000?oooooo
oooo00?ooooo0ol0000Dooooo`So00008?ooool2o`0001?ooooo00?o0000ooooooooool00_ooool6
o`0001oooooo0_l0000Booooo`03o`000?oooooooooo01_ooooo1ol00002oooooa?o00000_ooool2
o`0001cooooo1_l0000Jooooo`Ko000000?oooooo`000?l000007_l000000ooooooo0000ooooo`0<
ooooo`007?ooool00ol0003oooooooooo`0=ooooo`03o`000?oooooooooo01Wooooo00?o0000oooo
ooooool00oooool3o`0001Gooooo2?l00004ooooo`04o`000?ooooooooooo`0001Oooooo0_l0000C
ooooo`04o`000?ooooooooooooooo`Oo00007oooool00ol0003oooooo`00000Aooooo`03o`000?oo
oooooooo01cooooo1Ol00004ooooo`03o`000?oooooo000000;o000000?oooooo`000?l000002_l0
0002ooooo`?o00007?ooool4o`0001cooooo0ol00004ooooo`Wo00000_ooool00ol0003ooooooooo
o`0Do`0000cooooo000Looooo`03o`000?oooooooooo00gooooo00?o0000ooooooooool06Oooool0
0ol0003oooooo`000003ooooo`03o`000?oooooo000001Gooooo2Ol00002ooooo`Ko00006?ooool0
0ol0003oooooooooo`0@ooooo`03o`000?oooooooooo00;ooooo1ol0000Pooooo`03o`000?oooooo
oooo00oooooo00?o0000ooooooooool07Oooool3o`0000Sooooo00Ko0000ooooooooooooooooo`00
0?ooool8o`0000;ooooo1Ol0000Kooooo`?o00007_ooool00ol0003oooooooooo`04ooooo`03o`00
0?oooooo000000;o00000_ooool00ol0003oooooooooo`04oooooaCo00002oooool001cooooo00?o
0000ooooooooool03Oooool00ol0003oooooooooo`0Iooooo`03o`000?oooooo000000?ooooo00?o
0000ooooooooool04_ooool01?l0003ooooooooooooooolAo`0001Oooooo00?o0000ooooooooool0
4?ooool00ol0003oooooooooo`03ooooo`Oo00000_ooool00ol0003oooooooooo`0Jooooo`03o`00
0?oooooooooo00oooooo00?o0000ooooooooool07_ooool00ol0003oooooooooo`0>ooooo`03o`00
0?oooooooooo00?o00000_ooool7o`0001_ooooo0_l0000Booooo`03o`000?oooooooooo01?ooooo
00?o0000ooooooooool02_oooolCo`0000[ooooo000Looooo`03o`000?oooooooooo00gooooo0_l0
000Looooo`04o`000?ooooooooooo`0001Gooooo00?o0000ooooooooool00_oooolAo`0001Kooooo
00?o0000ooooooooool04?ooool00ol0003oooooooooo`04ooooo`[o0000;Oooool00ol0003ooooo
ooooo`0cooooo`03o`000?oooooooooo00So00007Oooool00ol0003oooooooooo`0?ooooo`03o`00
0?oooooooooo027ooooo00?o0000ooooooooool03ol0000:ooooo`007?ooool00ol0003ooooooooo
o`0=ooooo`;o00007?ooool01?l0003oooooooooool0000Eooooo`03o`000?oooooooooo00?ooooo
4?l0000Gooooo`03o`000?oooooooooo00oooooo00?o0000ooooooooool01Oooool9o`000003oooo
ool0003ooooo02[ooooo00?o0000ooooooooool0=oooool7o`0001gooooo00?o0000ooooooooool0
3oooool00ol0003oooooooooo`0Uooooo`03o`000?oooooo000000_o00002_ooool001cooooo00?o
0000ooooooooool03_ooool00ol0003oooooooooo`0Jooooo`04o`000?ooooooooooo`0001Gooooo
00?o0000ooooooooool01?ooool?o`0001Cooooo00Co0000oooooooooooo00006?ooool=o`0001Go
oooo00?o0000ooooooooool0COooool5o`0001kooooo00?o0000ooooooooool03oooool00ol0003o
ooooooooo`0Xooooo`03o`000?oooooooooo00Oo00002oooool001cooooo00?o0000ooooooooool0
3_ooool00ol0003oooooooooo`0Jooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool0
4?ooool00ol0003oooooooooo`05ooooo`go00005Oooool01?l0003oooooooooool0000Iooooo`go
000000?oooooo`000?ooool04Oooool01Ol0003ooooooooooooooooo000004cooooo0ol0000Poooo
o`05o`000?ooooooooooooooool000003?ooool00ol0003oooooooooo`0/ooooo`03o`000?oooooo
000000;o00003?ooool001cooooo00?o0000ooooooooool03_ooool00ol0003oooooooooo`0Goooo
o`03o`000?oooooooooo00Kooooo00?o0000ooooooooool04?ooool00ol0003oooooooooo`07oooo
o`[o00005_ooool00ol0003oooooooooo`0Kooooo`oo000000?oooooo`000?ooool03_ooool01?l0
003oooooooooooooool2o`0004cooooo00?o0000ooooooooool07?ooool01_l0003ooooooooooooo
oooo0000ooooo`?o00002oooool00ol0003oooooooooo`0_ooooo`03o`000?oooooooooo00_ooooo
000Looooo`03o`000?oooooooooo00kooooo00?o0000ooooooooool05oooool00ol0003ooooooooo
o`06ooooo`03o`000?oooooooooo01[ooooo0ol00002ooooo`08o`000?ooooooooooo`000?oooooo
0000ooooool0000Booooo`03o`000?oooooooooo01gooooo4Ol00002ooooo`03o`000?oooooooooo
00Wooooo00Co0000oooooooooooooooo0ol0001Zooooo`03o`000?oooooooooo00Oo0000??ooool0
0ol0003oooooooooo`0;ooooo`007?ooool3o`0000gooooo00?o0000ooooooooool06?ooool00ol0
003oooooooooo`07ooooo`03o`000?oooooooooo01[ooooo00?o0000ooooooooool01_ooool4o`00
017ooooo00?o0000ooooooooool04oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo
017o00001Oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00Go00003Oooool00ol0
003oooooooooo`0looooo`03o`000?oooooooooo01[ooooo00?o0000ooooool000002?l0000koooo
o`03o`000?oooooooooo00_ooooo000Looooo`03o`000?oooooooooo00gooooo00?o0000oooooooo
ool06?ooool01?l0003oooooooooooooool2o`0000Cooooo00?o0000ooooooooool08oooool5o`00
00Oooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`0Cooooo`03o`000?oooooooooo
00cooooo4?l00004ooooo`?o00000oooool00ol0003oooooo`000006o`0000cooooo00?o0000oooo
ooooool0??ooool00ol0003oooooooooo`0Iooooo`03o`000?oooooo000000Wo0000??ooool00ol0
003oooooooooo`0:ooooo`007?ooool00ol0003oooooooooo`0=ooooo`03o`000?oooooooooo01So
oooo00?o0000ooooooooool00ol0000Yooooo`Oo00001Oooool3o`0000;ooooo00?o0000oooooooo
ool01_ooool00ol0003oooooooooo`0?ooooo`03o`000?oooooooooo00kooooo3ol00002ooooo`Co
00001?ooool8o`0000cooooo00?o0000ooooooooool0??ooool00ol0003oooooooooo`0Iooooo`co
0000??ooool00ol0003oooooooooo`0:ooooo`007?ooool00ol0003oooooooooo`0<ooooo`03o`00
0?oooooooooo01Wooooo00?o0000ooooool000001?l0000Eooooo`03o`000?oooooooooo00oooooo
2?l00003ooooo`Wo00001oooool2o`0000oooooo00?o0000ooooooooool04?ooool00ol0003ooooo
o`00000;o`000003ooooool0003o000000Co00001?ooool7o`0000cooooo00?o0000ooooooooool0
?Oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo017ooooo00?o0000ooooool00000
2?l00009ooooo`03o`000?oooooooooo037ooooo00?o0000ooooooooool02_ooool001cooooo00?o
0000ooooooooool03?ooool01?l0003oooooooooool0000Jooooo`Ko00005?ooool00ol0003ooooo
ooooo`0@ooooo`So000000?oooooo`000?l000002?l00007ooooo`?o00003_ooool00ol0003ooooo
ooooo`0Coooooa;o00001Oooool5o`0000gooooo00?o0000ooooooooool0??ooool3o`0000;ooooo
00?o0000ooooool000000_l0000Eooooo`Oo00002_ooool00ol0003oooooooooo`0nooooo`007?oo
ool00ol0003oooooooooo`0<ooooo`04o`000?ooooooooooo`0001Wooooo1ol0000Dooooo`03o`00
0?oooooooooo017ooooo4ol00005ooooo`Go00003Oooool00ol0003oooooooooo`0Dooooo`03o`00
0?oooooo000000Ko00000_ooool6o`0000Kooooo0ol0000>ooooo`03o`000?oooooooooo03_ooooo
3?l0000Eooooo`?o000000?oooooo`000?ooool02_ooool00ol0003oooooooooo`0nooooo`007?oo
ool00ol0003oooooooooo`0?ooooo`03o`000?oooooooooo01Sooooo1_l00003ooooo`03o`000?oo
oooooooo00kooooo00?o0000ooooooooool04_oooolBo`0000;ooooo00?o0000ooooool000001_l0
000Vooooo`03o`000?oooooooooo00?o00000oooool4o`0000;ooooo00?o0000ooooooooool00ooo
ool00ol0003oooooooooo`1;ooooo`go00005Oooool00ol0003oooooooooo`02ooooo`03o`000?oo
oooooooo00Oooooo00?o0000ooooooooool0?_ooool001cooooo00?o0000ooooooooool03oooool0
0ol0003oooooooooo`0Iooooo`Co00000oooool3o`0000oooooo00?o0000ooooooooool04ooooolA
o`0000;ooooo2Ol0000Zooooo`03o`000?oooooo000000;ooooo0ol00003ooooo`03o`000?oooooo
oooo053ooooo3_l0000Jooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool0?_ooool0
01cooooo00?o0000ooooooooool03oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo
017ooooo00?o0000ooooooooool00ol00003ooooo`Go00003_ooool00ol0003oooooooooo`0Doooo
o`oo00000oooool00ol0003oooooo`000006o`0002cooooo0ol00002ooooo`;o00000_ooool00ol0
003oooooooooo`1Aooooo`go00004?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo
00Kooooo00?o0000ooooooooool0<Oooool00ol0003oooooooooo`0:ooooo`007?ooool00ol0003o
ooooooooo`0?ooooo`04o`000?ooooooooooooooo`?o00004_ooool01Ol0003ooooooooooooooooo
000000Cooooo1_l0000Uooooo`Wo00000_ooool3o`0000;ooooo00Co0000oooooooooooooooo1Ol0
000]ooooo`?o00000oooool01?l0003oooooooooool0001Dooooo`_o00004Oooool00ol0003ooooo
ooooo`08ooooo`;o0000>oooool00ol0003oooooooooo`0:ooooo`007?ooool00ol0003ooooooooo
o`0<ooooo`03o`000?oooooooooo00?ooooo1Ol0000Aooooo`03o`000?oooooooooo00Gooooo1ol0
000Uooooo`?o000000Coooooo`000?l0003o00001Oooool01Ol0003ooooooooooooooooo000000Co
oooo0ol0000>ooooo`03o`000?oooooooooo01cooooo1Ol00002ooooo`04o`000?ooooooooooo`00
00Oooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`0looooo`[o00004_ooool00ol0
003oooooooooo`08ooooo`?o0000>_ooool00ol0003oooooooooo`0:ooooo`007?ooool3o`0000co
oooo00?o0000ooooooooool00_ooool7o`00013ooooo00?o0000ooooooooool01_ooool6o`0002Ko
oooo00Go0000ooooooooooooooooo`00000:ooooo`03o`000?oooooooooo00?ooooo00?o0000oooo
ooooool03Oooool00ol0003oooooooooo`0Kooooo`Oo00000_ooool00ol0003oooooo`000007oooo
o`03o`000?oooooo000000_ooooo00?o0000ooooooooool0?Oooool00ol0003oooooooooo`03o`00
0003ooooool0003ooooo017ooooo00?o0000ooooooooool02?ooool5o`0003Wooooo00?o0000oooo
ooooool02_ooool001cooooo00?o0000ooooooooool03?ooool01?l0003oooooooooooooool8o`00
013ooooo00?o0000ooooooooool01oooool4o`0003gooooo00?o0000ooooooooool03?ooool00ol0
003oooooooooo`0Jooooo`So00000_ooool00ol0003oooooooooo`08ooooo`?o00002_ooool00ol0
003oooooooooo`11ooooo`03o`000?oooooooooo00?ooooo0_l0000>ooooo`03o`000?oooooooooo
00Oooooo1ol0000hooooo`03o`000?oooooooooo00[ooooo000Looooo`03o`000?oooooooooo00co
oooo00?o0000ooooooooool00_ooool7o`00013ooooo00?o0000ooooooooool01oooool3o`0000oo
oooo00?o0000ooooooooool0;?ooool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo01_o
oooo1ol00002ooooo`03o`000?oooooooooo00Oooooo1?l00009ooooo`03o`000?oooooooooo04So
oooo0ol0000=ooooo`03o`000?oooooooooo00Kooooo2?l00004ooooo`03o`000?oooooooooo037o
oooo00?o0000ooooooooool02_ooool001cooooo00?o0000ooooooooool03?ooool01_l0003ooooo
oooooooooooo0000ooooo`Go00007?ooool00ol0003oooooooooo`0>ooooo`03o`000?oooooooooo
02?ooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo
01cooooo1Ol0000<ooooo`Ko00002?ooool00ol0003oooooooooo`17ooooo`Go00005_ooool7o`00
00Cooooo00?o0000ooooooooool0?_ooool001cooooo00?o0000ooooooooool03?ooool01Ol0003o
oooooooooooooooo000000;ooooo0ol0000^ooooo`03o`000?oooooooooo02?ooooo00?o0000oooo
ool000001oooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo01gooooo0ol00005oooo
o`03o`000?oooooooooo00Cooooo2?l00007ooooo`03o`000?oooooooooo04Kooooo1ol00003oooo
o`03o`000?oooooooooo013ooooo1Ol00005ooooo`03o`000?oooooooooo03kooooo000Looooo`03
o`000?oooooooooo013ooooo00?o0000ooooooooool00ol0000Nooooo`03o`000?oooooooooo00co
oooo00?o0000ooooooooool09?ooool00ol0003oooooo`000007ooooo`03o`000?oooooooooo02co
oooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`05ooooo`So0000C_ooool8o`0000;o
oooo0ol0000Booooo`?o00001_ooool00ol0003oooooooooo`0nooooo`007?ooool00ol0003ooooo
ooooo`0@ooooo`03o`000?oooooo0000027ooooo00?o0000ooooooooool03?ooool00ol0003ooooo
ooooo`0Uooooo`;o00001oooool00ol0003oooooooooo`0booooo`?o00001oooool8o`0004kooooo
3_l0000Aooooo`;o00001_ooool00ol0003oooooooooo`0nooooo`007?ooool00ol0003ooooooooo
o`0@ooooo`03o`000?oooooo000001Gooooo00?o0000ooooooooool02Oooool00ol0003ooooooooo
o`0<ooooo`03o`000?oooooooooo02Gooooo00?o0000ooooooooool0>_ooool5o`0000Oooooo2?l0
001>ooooo`ko00000oooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00Cooooo00?o
0000ooooooooool0<Oooool00ol0003oooooooooo`0:ooooo`007?ooool00ol0003oooooooooo`0?
ooooo`?o00005_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo03?ooooo00?o0000
ooooooooool0>Oooool7o`0000Kooooo2?l0001?ooooo`ko00000_ooool00ol0003oooooooooo`0<
ooooo`03o`000?oooooooooo03Oooooo00?o0000ooooooooool02_ooool001cooooo00?o0000oooo
ooooool03?ooool00ol0003oooooo`000004o`0001Gooooo00?o0000ooooooooool02_ooool00ol0
003oooooooooo`0booooo`?o00005Oooool00ol0003oooooooooo`0Qooooo`So00001oooool7o`00
00Cooooo00?o0000ooooooooool0BOooool>o`000003ooooool0003ooooo00gooooo00?o0000oooo
ooooool0=oooool00ol0003oooooooooo`0:ooooo`007?ooool3o`0000cooooo00?o0000ooooool0
00001Ol000000ooooooo0000ooooo`0Aooooo`03o`000?oooooooooo00[ooooo00?o0000oooooooo
ool0<Oooool5o`0001Cooooo00?o0000ooooooooool08_ooool7o`0000Sooooo1Ol00005ooooo`03
o`000?oooooooooo04[ooooo3Ol000000ooooooo0000ooooo`0=ooooo`03o`000?oooooooooo03So
oooo00?o0000ooooooooool02Oooool001cooooo00?o0000ooooooooool03?ooool8o`000003oooo
ool0003ooooo017ooooo00?o0000ooooooooool0?Oooool7o`0000Kooooo00?o0000ooooooooool0
2_ooool00ol0003oooooooooo`0Sooooo`Go00002_ooool3o`0000Kooooo00?o0000ooooooooool0
Boooool<o`000003ooooool0003ooooo00kooooo00?o0000ooooooooool0=oooool00ol0003ooooo
ooooo`09ooooo`007?ooool00ol0003oooooooooo`0<ooooo`03o`000?oooooo000000Go000000?o
ooooo`000?ooool04Oooool00ol0003oooooooooo`0Hooooo`03o`000?oooooooooo027ooooo2?l0
0006ooooo`05o`000?ooooooooooooooool000002?ooool00ol0003oooooooooo`0Tooooo`?o0000
3?ooool2o`0000Kooooo00?o0000ooooooooool0Boooool3o`0000;ooooo00?o0000ooooool00000
0ol00002ooooo`03o`000?oooooooooo00cooooo0ol00002ooooo`03o`000?oooooooooo03?ooooo
00?o0000ooooooooool02Oooool001cooooo00?o0000ooooooooool03?ooool00ol0003ooooooooo
o`04o`0000?ooooo00?o0000ooooooooool0:_ooool00ol0003oooooooooo`0Rooooo`Oo00001_oo
ool2o`000004ooooool0003o0000o`0000Oooooo00?o0000ooooooooool09Oooool00ol0003ooooo
ooooo`0Cooooo`03o`000?oooooooooo04cooooo00?o0000ooooooooool00oooool3o`00017ooooo
1Ol000000ooooooo0000ooooo`10ooooo`007?ooool00ol0003oooooooooo`0<ooooo`03o`000?oo
oooooooo00?o00001?ooool00ol0003oooooooooo`0Zooooo`03o`000?oooooooooo02?ooooo1Ol0
0007ooooo`Oo00001_ooool00ol0003oooooooooo`0kooooo`03o`000?oooooooooo05?ooooo0_l0
000Aooooo`Oo0000@Oooool001cooooo00?o0000ooooooooool04?ooool00ol0003oooooooooo`03
ooooo`03o`000?oooooooooo01gooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0T
ooooo`?o00001oooool9o`0009_ooooo00?o0000ooooooooool03Oooool8o`00047ooooo000Loooo
o`03o`000?oooooooooo03Kooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0Uoooo
o`03o`000?oooooooooo00Gooooo2_l0002Kooooo`03o`000?oooooooooo00kooooo1ol00011oooo
o`007?ooool00ol0003oooooooooo`0Xooooo`03o`000?oooooooooo00_ooooo00?o0000oooooooo
ool02_ooool00ol0003oooooooooo`0/ooooo`_o0000?Oooool00ol0003oooooooooo`1Kooooo`03
o`000?oooooo000000oooooo1?l000000ooooooo0000ooooo`0dooooo`03o`000?oooooooooo00Wo
oooo000Looooo`03o`000?oooooooooo02Sooooo00?o0000ooooooooool02oooool01Ol0003ooooo
oooooooooooo000003Sooooo2Ol0000nooooo`03o`000?oooooooooo05cooooo0_l0000?ooooo`?o
0000>?ooool00ol0003oooooooooo`09ooooo`0000Coooooo`000?l0003o00001?ooool2o`0000Co
oooo0_l00004ooooo`;o00001_ooool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo01Wo
oooo00?o0000ooooooooool02oooool00ol0003oooooooooo`03o`0003Sooooo1ol00007ooooo`03
o`000?oooooooooo03Gooooo00?o0000ooooool000000oooool00ol0003oooooooooo`1Gooooo`03
o`000?oooooooooo00kooooo00?o0000ooooool00000=oooool00ol0003oooooooooo`09ooooo`00
0_ooool00ol0003oooooooooo`02ooooo`04o`000?ooooooooooo`0000;ooooo00Co0000oooooooo
oooo00000_ooool01?l0003oooooooooool00005ooooo`03o`000?oooooooooo00cooooo00?o0000
ooooooooool01oooool00ol0003oooooooooo`0?ooooo`03o`000?oooooooooo00_ooooo1ol0000h
ooooo`;o00000_ooool2o`0000Oooooo00?o0000ooooooooool0=_ooool3o`0000;ooooo00?o0000
ooooooooool0E_ooool3o`0004Wooooo00?o0000ooooooooool02Oooool000;ooooo00?o0000oooo
ooooool00_ooool01?l0003oooooooooool00002ooooo`04o`000?ooooooooooo`0000;ooooo00Co
0000oooooooooooo00001Oooool3o`0000cooooo00?o0000ooooooooool01oooool00ol0003ooooo
ooooo`0?ooooo`03o`000?oooooooooo00_ooooo2?l0000hooooo`05o`000?ooooooooooooooool0
00001oooool00ol0003oooooooooo`0eooooo`Co00000_ooool00ol0003oooooooooo`1Eooooo`Go
0000B?ooool00ol0003oooooooooo`09ooooo`000_ooool00ol0003oooooooooo`02ooooo`04o`00
0?ooooooooooo`0000;ooooo00Co0000oooooooooooo00000_ooool01?l0003oooooooooool00005
ooooo`03o`000?oooooooooo00cooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`0?
ooooo`03o`000?oooooooooo00[ooooo2Ol00005ooooo`03o`000?oooooooooo03_ooooo00?o0000
ooooooooool0=Oooool6o`000003ooooool0003ooooo05Gooooo1ol0000Aooooo`03o`000?oooooo
oooo03?ooooo00?o0000ooooooooool02Oooool000;ooooo00?o0000ooooooooool00_ooool01?l0
003oooooooooool00002ooooo`04o`000?ooooooooooo`0000;ooooo00Co0000oooooooooooo0000
1Oooool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool0
6_ooool:o`0000Gooooo00?o0000ooooooooool0>oooool00ol0003oooooooooo`0dooooo`Oo0000
00?oooooo`000?ooool0E?ooool8o`00013ooooo0ol00010ooooo`0000?oooooo`000?l000001?oo
ool01?l0003oooooooooool00002ooooo`04o`000?ooooooooooo`0000;ooooo00Co0000oooooooo
oooo00001Oooool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo00Sooooo00?o0000oooo
ooooool06Oooool:o`0000Kooooo00?o0000ooooooooool0>oooool00ol0003oooooooooo`0eoooo
o`Ko000000?oooooo`000?ooool0EOooool7o`0000oooooo1Ol0000oooooo`000_ooool00ol0003o
ooooooooo`03ooooo`;o00001?ooool2o`0000Cooooo0_l00006ooooo`03o`000?oooooooooo01Oo
oooo00?o0000ooooooooool06_ooool8o`0000Oooooo00?o0000ooooooooool0M?ooool4o`0005[o
oooo1Ol0000?ooooo`Oo0000?_ooool001cooooo00?o0000ooooooooool0=Oooool6o`0000Sooooo
00?o0000ooooooooool0=Oooool00ol0003oooooooooo`0mooooo`;o0000G?ooool3o`0000oooooo
2?l0000nooooo`007?ooool00ol0003oooooooooo`0Xooooo`03o`000?oooooooooo00_ooooo0ol0
000:ooooo`03o`000?oooooooooo03Gooooo00?o0000ooooooooool0?_ooool00ol0003ooooooooo
o`1Kooooo`03o`000?oooooooooo00oooooo1ol0000booooo`03o`000?oooooooooo00Wooooo000L
ooooo`03o`000?oooooooooo01Oooooo00?o0000ooooooooool03_ooool00ol0003oooooooooo`0<
ooooo`03o`000?oooooooooo047ooooo00?o0000ooooooooool0?_ooool00ol0003oooooooooo`1^
ooooo`Go0000<oooool00ol0003oooooooooo`09ooooo`007?ooool00ol0003oooooooooo`0<oooo
o`03o`000?oooooooooo00Oooooo0ol0000?ooooo`03o`000?oooooooooo057ooooo00?o0000oooo
ooooool00_ooool00ol0003oooooooooo`0hooooo`04o`000?ooooooooooo`0006kooooo0ol0000d
ooooo`03o`000?oooooooooo00Wooooo000Looooo`03o`000?oooooooooo00cooooo00?o0000oooo
ooooool01_ooool5o`0000kooooo00?o0000ooooooooool04?ooool00ol0003oooooooooo`0noooo
o`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0>Oooool00ol0003oooooo`00001_oooo
o`03o`000?oooooooooo03Cooooo00?o0000ooooooooool02?ooool001cooooo00?o0000oooooooo
ool03?ooool00ol0003oooooooooo`06ooooo`Ko00003Oooool00ol0003oooooooooo`0@ooooo`03
o`000?oooooooooo03kooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`0iooooo`03
o`000?oooooo00000:Kooooo00?o0000ooooooooool02?ooool001cooooo0ol0000<ooooo`03o`00
0?oooooooooo00Gooooo1ol0000=ooooo`03o`000?oooooooooo013ooooo00?o0000ooooooooool0
1Oooool00ol0003oooooooooo`0kooooo`03o`000?oooooooooo03Wooooo00?o0000ooooool00000
Y_ooool00ol0003oooooooooo`08ooooo`007?ooool00ol0003oooooooooo`0<ooooo`03o`000?oo
oooooooo00Kooooo1_l0000Qooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool0>ooo
ool00ol0003oooooooooo`0kooooo`03o`000?oooooooooo0:oooooo000Looooo`03o`000?oooooo
oooo00cooooo00?o0000ooooooooool01oooool4o`0002;ooooo00?o0000ooooooooool01?ooool0
0ol0003oooooooooo`0gooooo`05o`000?ooooooooooooooool00000?Oooool00ol0003ooooooooo
o`2_ooooo`007?ooool00ol0003oooooooooo`0Fooooo`?o00008oooool00ol0003oooooooooo`04
ooooo`03o`000?oooooooooo03Kooooo0ol0003booooo`007?ooool00ol0003oooooooooo`0Goooo
o`03o`000?oooooooooo02Wooooo00?o0000ooooooooool0=Oooool4o`0003oooooo00?o0000oooo
ooooool0/?ooool001cooooo00?o0000ooooooooool09oooool00ol0003oooooooooo`0Iooooo`03
o`000?oooooooooo03Cooooo1_l0000nooooo`;o0000Y_ooool00ol0003oooooooooo`08ooooo`00
7?ooool00ol0003oooooooooo`0Wooooo`03o`000?oooooooooo04oooooo1ol0000nooooo`?o0000
YOooool00ol0003oooooooooo`08ooooo`007?ooool00ol0003oooooooooo`0<ooooo`03o`000?oo
oooooooo01Sooooo00?o0000ooooooooool0D?ooool6o`000003ooooool0003ooooo03[ooooo1Ol0
002Tooooo`03o`000?oooooooooo00Sooooo000Looooo`03o`000?oooooooooo00cooooo00?o0000
ooooooooool02_ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo01?ooooo00?o0000
ooooooooool0>oooool4o`0000;ooooo00?o0000ooooooooool0>?ooool7o`000:?ooooo00?o0000
ooooooooool02?ooool001cooooo00?o0000ooooooooool03?ooool00ol0003oooooooooo`0:oooo
o`03o`000?oooooooooo00_ooooo00?o0000ooooooooool04oooool00ol0003oooooooooo`0loooo
o`;o00000oooool00ol0003oooooooooo`0gooooo`So0000Xoooool00ol0003oooooooooo`08oooo
o`007?ooool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo00[ooooo00?o0000oooooooo
ool02oooool00ol0003oooooooooo`0Cooooo`03o`000?oooooooooo00;ooooo00?o0000oooooooo
ool0>?ooool01Ol0003ooooooooooooooooo000003[ooooo1ol0002Sooooo`03o`000?oooooooooo
00Sooooo000Looooo`?o00003?ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo027o
oooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`0looooo`03o`000?oooooooooo03Wo
oooo1Ol0002_ooooo`007?ooool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo00[ooooo
00?o0000ooooooooool08Oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo03cooooo
00?o0000ooooooooool0>_ooool3o`000;3ooooo000Looooo`03o`000?oooooooooo01Wooooo00?o
0000ooooooooool08Oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo07[ooooo00?o
0000ooooooooool0[oooool001cooooo00?o0000ooooooooool0?_ooool01Ol0003ooooooooooooo
oooo000003_ooooo00?o0000ooooooooool0l?ooool001cooooo00?o0000ooooooooool09oooool0
0ol0003oooooooooo`0Cooooo`?o00000_ooool00ol0003oooooooooo`0iooooo`03o`000?oooooo
oooo0>Gooooo00?o0000ooooooooool02?ooool001cooooo00?o0000ooooooooool09oooool00ol0
003oooooooooo`0Booooo`Go0000?Oooool00ol0003oooooooooo`3Uooooo`03o`000?oooooooooo
00Sooooo000Looooo`03o`000?oooooooooo00cooooo00?o0000ooooooooool06?ooool00ol0003o
ooooooooo`0Aooooo`Oo0000?Oooool00ol0003oooooo`00003Tooooo`;o00002Oooool001cooooo
00?o0000ooooooooool03?ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00[ooooo
00?o0000ooooooooool04?ooool8o`0003gooooo00?o0000ooooool00000i?ooool3o`0000Sooooo
000Looooo`03o`000?oooooooooo00cooooo00?o0000ooooooooool02oooool2o`0000_ooooo00?o
0000ooooooooool04Oooool7o`0003gooooo00?o0000ooooool00000hoooool4o`0000Sooooo000L
ooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`0<
ooooo`?o00002_ooool00ol0003oooooooooo`0Booooo`Go000000?oooooo`000?ooool0??ooool0
0ol0003oooooooooo`3Qooooo`Ko00001oooool001cooooo00?o0000ooooooooool01Oooool3o`00
00?ooooo00?o0000ooooooooool02oooool6o`0001kooooo0ol00002ooooo`03o`000?oooooooooo
03_ooooo00?o0000ooooooooool0h?ooool7o`0000Oooooo000Looooo`?o00001?ooool5o`0000;o
oooo00?o0000ooooooooool02_ooool8o`0001kooooo0_l00002ooooo`03o`000?oooooooooo03_o
oooo00?o0000ooooooooool0hOooool6o`0000Oooooo000Looooo`03o`000?oooooooooo00?ooooo
1ol0000=ooooo`[o00007_ooool01?l0003oooooooooool0003oooooob?ooooo1?l00008ooooo`00
7?ooool00ol0003oooooooooo`02ooooo`So00003_ooool:o`00023ooooo00?o0000ooooooooool0
>oooool00ol0003oooooooooo`3Sooooo`;o00002Oooool001cooooo00?o0000ooooooooool00ooo
ool7o`0000oooooo2Ol00005ooooo`03o`000?oooooooooo01Sooooo00?o0000ooooooooool0>ooo
ool00ol0003oooooooooo`3Tooooo`03o`000?oooooooooo00Oooooo000Looooo`03o`000?oooooo
oooo00Cooooo1Ol0000Aooooo`So00001Oooool00ol0003oooooooooo`1Eooooo`?o0000koooool0
01cooooo00?o0000ooooooooool01Oooool3o`0000?ooooo00?o0000ooooooooool03Oooool00ol0
003oooooo`000003o`0000Kooooo00?o0000ooooooooool0E?ooool5o`000>kooooo000Looooo`03
o`000?oooooooooo00Kooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`0?ooooo`?o
00001oooool00ol0003oooooooooo`0Eooooo`03o`000?oooooooooo03_ooooo1ol0003]ooooo`00
7?ooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0
4?ooool2o`0000Oooooo00?o0000ooooooooool05Oooool00ol0003oooooooooo`0jooooo`So0000
kOooool001cooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`02ooooo`03o`000?oo
oooooooo017ooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`0Eooooo`04o`000?oo
ooooooooo`0003[ooooo1ol0003]ooooo`007?ooool00ol0003oooooooooo`06ooooo`03o`000?oo
oooooooo00;ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0Nooooo`03o`000?oo
oooo000003_ooooo1Ol0003^ooooo`007?ooool00ol0003oooooooooo`06ooooo`03o`000?oooooo
oooo00;ooooo00?o0000ooooooooool0<_ooool00ol0003oooooo`00000looooo`?o0000koooool0
01cooooo0ol00010ooooo`03o`000?oooooo000003gooooo00?o0000ooooooooool0k_ooool001co
oooo00?o0000ooooooooool0@_ooool00ol0003oooooooooo`3oooooobgooooo000Looooo`03o`00
0?oooooooooo01oooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`0Hooooo`03o`00
0?oooooooooo0?oooooo;Oooool001cooooo00?o0000ooooooooool07oooool00ol0003ooooooooo
o`05ooooo`03o`000?oooooooooo0?ooooooB?ooool001cooooo00?o0000ooooooooool01_ooool0
0ol0003oooooooooo`02ooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool01Oooool0
0ol0003oooooooooo`3oooooodSooooo000Looooo`03o`000?oooooooooo00Kooooo00?o0000oooo
ooooool00_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo00Cooooo00?o0000oooo
ooooool05_ooool00ol0003oooooooooo`3ooooooboooooo000Looooo`03o`000?oooooooooo00Ko
oooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo00Co
oooo00?o0000ooooooooool05_ooool00ol0003oooooooooo`3ooooooboooooo000Looooo`03o`00
0?oooooooooo00Kooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`0Booooo`03o`00
0?oooooooooo00Cooooo00?o0000ooooooooool05_ooool00ol0003oooooo`00003ooooooboooooo
00001?oooooo0000o`000?l00003ooooo`?o00001?ooool2o`0000Cooooo0_l00006ooooo`03o`00
0?oooooooooo00Kooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`0cooooo`;o0000
ooooool_ooooo`000_ooool01Ol0003ooooooooooooooooo000000?ooooo00Co0000oooooooooooo
00000_ooool01?l0003oooooooooool00002ooooo`03o`000?oooooooooo00?ooooo00?o0000oooo
ooooool01_ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo03?ooooo0_l0003ooooo
oboooooo0002ooooo`03o`000?oooooooooo00Gooooo00Co0000oooooooooooo00000_ooool01?l0
003oooooooooool00002ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool0@Oooool0
0ol0003oooooooooo`3oooooobkooooo0002ooooo`03o`000?oooooooooo00Gooooo00Co0000oooo
oooooooo00000_ooool01?l0003oooooooooool00002ooooo`03o`000?oooooooooo00?ooooo0ol0
0010ooooo`?o0000ooooool_ooooo`000_ooool01?l0003oooooooooooooool4o`0000?ooooo00Co
0000oooooooooooo00000_ooool01?l0003oooooooooool00005ooooo`03o`000?oooooooooo023o
oooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`0Eooooo`Go0000ooooool^ooooo`00
00?oooooo`000?l000000oooool00ol0003oooooooooo`04ooooo`04o`000?ooooooooooo`0000;o
oooo00Co0000oooooooooooo00001Oooool00ol0003oooooooooo`0Pooooo`03o`000?oooooooooo
00Cooooo00?o0000ooooooooool05Oooool6o`000?oooooo;Oooool000;ooooo00Co0000oooooooo
oooooooo1Ol00003ooooo`;o00001?ooool2o`0000Kooooo00?o0000ooooooooool01oooool01Ol0
003ooooooooooooooooo000001Cooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`0D
ooooo`Oo0000ooooool]ooooo`007?ooool00ol0003oooooooooo`07ooooo`05o`000?oooooooooo
ooooool000005Oooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo01Gooooo1_l0003o
ooooobgooooo000Looooo`03o`000?oooooooooo00Oooooo00Go0000ooooooooooooooooo`00000E
ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool05_ooool4o`000?oooooo;_ooool0
01cooooo00?o0000ooooooooool01oooool01Ol0003ooooooooooooooooo000001Gooooo00?o0000
ooooooooool00oooool00ol0003oooooooooo`0Fooooo`?o0000ooooool_ooooo`007?ooool00ol0
003oooooooooo`07ooooo`05o`000?ooooooooooooooool00000=Oooool00ol0003oooooooooo`3o
ooooobkooooo000Looooo`03o`000?oooooooooo00Oooooo00Go0000ooooooooooooooooo`00003o
ooooofKooooo000Looooo`03o`000?oooooooooo0?ooooooL_ooool001cooooo00?o0000oooooooo
ool0oooooombooooo`007?ooool3o`00027ooooo00?o0000ooooooooool00_ooool00ol0003ooooo
ooooo`3oooooodWooooo000Looooo`03o`000?oooooooooo027ooooo00?o0000ooooooooool00_oo
ool00ol0003oooooooooo`3oooooodWooooo000Looooo`03o`000?oooooooooo00Oooooo00Go0000
ooooooooooooooooo`00000Eooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0oooo
oom9ooooo`007?ooool00ol0003oooooooooo`07ooooo`05o`000?ooooooooooooooool000005_oo
ool01Ol0003ooooooooooooooooo00000?ooooooBoooool001cooooo00?o0000ooooooooool01ooo
ool01Ol0003ooooooooooooooooo000001Kooooo00Go0000ooooooooooooooooo`00003ooooood_o
oooo000Looooo`03o`000?oooooooooo00Oooooo00Go0000ooooooooooooooooo`00000Fooooo`05
o`000?ooooooooooooooool00000oooooom;ooooo`007?ooool00ol0003oooooooooo`07ooooo`05
o`000?ooooooooooooooool000005_ooool00ol0003oooooooooo`3oooooodgooooo000Looooo`03
o`000?oooooooooo00Oooooo00Go0000ooooooooooooooooo`00000Eooooo`?o0000oooooom>oooo
o`007?ooool00ol0003oooooooooo`0Pooooo`Go0000oooooom=ooooo`007?ooool00ol0003ooooo
ooooo`0Oooooo`Oo0000oooooom<ooooo`007?ooool00ol0003oooooooooo`0Nooooo`Wo0000oooo
oom;ooooo`007?ooool3o`0001oooooo2?l0003ooooood_ooooo000Looooo`03o`000?oooooooooo
00Oooooo00Go0000ooooooooooooooooo`00000Dooooo`Go000000?oooooo`000?ooool0oooooom:
ooooo`007?ooool00ol0003oooooooooo`07ooooo`05o`000?ooooooooooooooool000005Oooool3
o`0000;ooooo00?o0000ooooooooool0oooooom9ooooo`007?ooool00ol0003oooooooooo`07oooo
o`05o`000?ooooooooooooooool000005_ooool01Ol0003ooooooooooooooooo00000?ooooooBooo
ool001cooooo00?o0000ooooooooool01oooool01Ol0003ooooooooooooooooo000001Kooooo00Go
0000ooooooooooooooooo`00003ooooood_ooooo000Looooo`03o`000?oooooooooo00Oooooo00Go
0000ooooooooooooooooo`00003oooooofKooooo000Looooo`03o`000?oooooooooo00Oooooo00Go
0000ooooooooooooooooo`00003oooooofKooooo000Looooo`03o`000?oooooooooo0?ooooooL_oo
ool001cooooo00?o0000ooooooooool0oooooombooooo`007?ooool00ol0003oooooooooo`0Soooo
o`04o`000?ooooooooooo`000?ooooooBoooool001cooooo00?o0000ooooooooool08oooool01?l0
003oooooooooool0003ooooood_ooooo000Looooo`?o00002?ooool00ol0003oooooo`00000Hoooo
o`04o`000?ooooooooooo`000?ooooooBoooool001cooooo00?o0000ooooooooool02?ooool00ol0
003oooooo`00000Hooooo`04o`000?ooooooooooo`000?ooooooBoooool001cooooo00?o0000oooo
ooooool02?ooool00ol0003oooooo`00000Hooooo`04o`000?ooooooooooo`000?ooooooBoooool0
01cooooo00?o0000ooooooooool02?ooool00ol0003oooooo`00000Hooooo`04o`000?oooooooooo
o`000?ooooooBoooool001cooooo00?o0000ooooooooool02?ooool00ol0003oooooo`00003ooooo
ofOooooo000Looooo`03o`000?oooooooooo00Sooooo00?o0000ooooool00000oooooomWooooo`00
7?ooool00ol0003oooooooooo`3oooooog;ooooo000Looooo`03o`000?oooooooooo0?ooooooL_oo
ool001cooooo00?o0000ooooooooool09?ooool00ol0003oooooo`00003ooooood_ooooo000Loooo
o`03o`000?oooooooooo02Cooooo00?o0000ooooool00000oooooom;ooooo`007?ooool00ol0003o
ooooooooo`08ooooo`03o`000?oooooo000001Wooooo00?o0000ooooool00000oooooom;ooooo`00
7?ooool3o`0000Sooooo00?o0000ooooool000006Oooool00ol0003oooooo`00003ooooood_ooooo
000Looooo`03o`000?oooooooooo00Sooooo00?o0000ooooool000006Oooool00ol0003oooooo`00
003ooooood_ooooo000Looooo`03o`000?oooooooooo00Sooooo00?o0000ooooool000006Oooool0
0ol0003oooooo`00003ooooood_ooooo000Looooo`03o`000?oooooooooo00Sooooo00?o0000oooo
ool00000oooooomWooooo`007?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooo00000?oo
ooooIoooool001cooooo00?o0000ooooooooool0oooooombooooo`007?ooool00ol0003ooooooooo
o`3oooooog;ooooo000Looooo`03o`000?oooooooooo02Cooooo00?o0000ooooool00000oooooom;
ooooo`001Ol00003ooooo`;o00001?ooool2o`0000Cooooo0_l00006ooooo`03o`000?oooooooooo
02Cooooo00?o0000ooooool00000oooooom;ooooo`0000Goooooo`000?ooooooooooo`000002oooo
o`04o`000?ooooooooooo`0000;ooooo00Co0000oooooooooooo00000_ooool01?l0003ooooooooo
ool00005ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooool000006Oooool00ol0003ooooo
o`00003ooooood_ooooo0002ooooo`03o`000?oooooooooo00;ooooo00Co0000oooooooooooo0000
0_ooool01?l0003oooooooooool00002ooooo`04o`000?ooooooooooo`0000Gooooo00?o0000oooo
ooooool02?ooool00ol0003oooooo`00000Jooooo`;o0000oooooom;ooooo`000oooool01Ol0003o
oooooooooooooooo000000;ooooo00Co0000oooooooooooo00000_ooool01?l0003oooooooooool0
0002ooooo`03o`000?oooooooooo00?ooooo0ol00008ooooo`03o`000?oooooo000001[ooooo0_l0
003ooooood_ooooo00001Ol0003ooooooooooooooooo000000;ooooo00Co0000oooooooooooo0000
0_ooool01?l0003oooooooooool00002ooooo`04o`000?ooooooooooo`0000Gooooo00?o0000oooo
ooooool02?ooool00ol0003oooooo`00000Jooooo`03o`000?oooooooooo0?ooooooB_ooool00005
o`000?ooooooooooooooool000000_ooool01?l0003oooooooooool00002ooooo`04o`000?oooooo
ooooo`0000;ooooo00Co0000oooooooooooo00001Oooool00ol0003oooooooooo`08ooooo`03o`00
0?oooooo00000?ooooooIoooool00004ooooool0003o0000o`0000Cooooo0_l00004ooooo`;o0000
1?ooool2o`0000Kooooo00?o0000ooooooooool02?ooool00ol0003oooooo`00003oooooofOooooo
000Looooo`03o`000?oooooooooo0?ooooooL_ooool001cooooo00?o0000ooooooooool09Oooool0
0ol0003oooooooooo`3ooooood[ooooo000Looooo`03o`000?oooooooooo02Cooooo0ol0003ooooo
od_ooooo000Looooo`03o`000?oooooooooo02?ooooo1Ol0003ooooood[ooooo000Looooo`03o`00
0?oooooooooo00Sooooo00?o0000ooooool000006?ooool6o`000?ooooooBOooool001cooooo00?o
0000ooooooooool02?ooool00ol0003oooooo`00000Gooooo`Oo0000oooooom9ooooo`007?ooool3
o`0000Sooooo00?o0000ooooool000006?ooool6o`000?ooooooBOooool001cooooo00?o0000oooo
ooooool02Oooool2o`0001Wooooo1?l0003ooooood[ooooo000Looooo`03o`000?oooooooooo00Wo
oooo0_l0000Iooooo`?o0000oooooom;ooooo`007?ooool00ol0003oooooooooo`09ooooo`;o0000
6_ooool00ol0003oooooooooo`3ooooood[ooooo000Looooo`03o`000?oooooooooo0?ooooooL_oo
ool001cooooo00?o0000ooooooooool0oooooombooooo`007?ooool00ol0003oooooooooo`3ooooo
og;ooooo000Looooo`03o`000?oooooooooo0?ooooooL_ooool001cooooo00?o0000ooooooooool0
2Oooool2o`000?ooooooIoooool001cooooo00?o0000ooooooooool02Oooool2o`000?ooooooIooo
ool001cooooo00?o0000ooooooooool02Oooool2o`000?ooooooIoooool001cooooo0ol00009oooo
o`;o0000oooooomWooooo`007?ooool00ol0003oooooooooo`09ooooo`;o0000oooooomWooooo`00
7?ooool00ol0003oooooooooo`09ooooo`;o0000oooooomWooooo`007?ooool00ol0003ooooooooo
o`3oooooog;ooooo000Looooo`03o`000?oooooooooo0?ooooooL_ooool001cooooo00?o0000oooo
ooooool0oooooombooooo`007?ooool00ol0003oooooooooo`3oooooog;ooooo000Looooo`03o`00
0?oooooooooo00Wooooo0_l0003oooooofOooooo000Looooo`03o`000?oooooooooo00Wooooo0_l0
003oooooofOooooo000Looooo`03o`000?oooooooooo00Wooooo0_l0003oooooofOooooo000Loooo
o`03o`000?oooooooooo00Wooooo0_l0003oooooofOooooo000Looooo`?o00002Oooool2o`000?oo
ooooIoooool001cooooo00?o0000ooooooooool02Oooool2o`000?ooooooIoooool001cooooo00?o
0000ooooooooool0oooooombooooo`007?ooool00ol0003oooooooooo`3oooooog;ooooo000Loooo
o`03o`000?oooooooooo0?ooooooL_ooool001cooooo00?o0000ooooooooool02Oooool00ol0003o
ooooooooo`3oooooofKooooo000Looooo`03o`000?oooooooooo00Sooooo0ol0003oooooofOooooo
000Looooo`03o`000?oooooooooo00Oooooo1Ol0003oooooofKooooo000Looooo`03o`000?oooooo
oooo00Oooooo1_l0003oooooofGooooo000Looooo`03o`000?oooooooooo00Kooooo1ol0003ooooo
ofGooooo000Looooo`03o`000?oooooooooo00Oooooo1_l0003oooooofGooooo000Looooo`?o0000
2?ooool4o`000?ooooooI_ooool001cooooo00?o0000ooooooooool02?ooool3o`000?ooooooIooo
ool001cooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`3oooooofKooooo000Loooo
o`03o`000?oooooooooo0?ooooooL_ooool00?ooooooTOooool00001\
\>"],
  ImageRangeCache->{{{0, 399}, {246.188, 0}} -> {-9.72327, 184.194, 0.286338, \
9.15875}}]
}, Open  ]],

Cell["Si pu\[OGrave] anche pensare di aggiungere una griglia al grafico:", \
"Text",
  PageWidth->PaperWidth],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Show[graph, GridLines \[Rule] Automatic];\)\)], "Input",
  CellLabel->"In[34]:=",
  PageWidth->PaperWidth],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
%%ImageSize: 400 247.214 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.01438 0.00942951 -0.0960424 0.000294803 [
[.01438 -0.0125 -3 -9 ]
[.01438 -0.0125 3 0 ]
[.20297 -0.0125 -6 -9 ]
[.20297 -0.0125 6 0 ]
[.39156 -0.0125 -6 -9 ]
[.39156 -0.0125 6 0 ]
[.58015 -0.0125 -6 -9 ]
[.58015 -0.0125 6 0 ]
[.76874 -0.0125 -6 -9 ]
[.76874 -0.0125 6 0 ]
[.95733 -0.0125 -9 -9 ]
[.95733 -0.0125 9 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .05136 -18 -4.5 ]
[-0.0125 .05136 0 4.5 ]
[-0.0125 .19876 -24 -4.5 ]
[-0.0125 .19876 0 4.5 ]
[-0.0125 .34616 -24 -4.5 ]
[-0.0125 .34616 0 4.5 ]
[-0.0125 .49356 -24 -4.5 ]
[-0.0125 .49356 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 .5 r
.25 Mabswid
[ ] 0 setdash
.20297 0 m
.20297 .61803 L
s
.39156 0 m
.39156 .61803 L
s
.58015 0 m
.58015 .61803 L
s
.76874 0 m
.76874 .61803 L
s
0 .05136 m
1 .05136 L
s
0 .19876 m
1 .19876 L
s
0 .34616 m
1 .34616 L
s
0 .49356 m
1 .49356 L
s
0 g
.01438 0 m
.01438 .00625 L
s
[(0)] .01438 -0.0125 0 1 Mshowa
.20297 0 m
.20297 .00625 L
s
[(20)] .20297 -0.0125 0 1 Mshowa
.39156 0 m
.39156 .00625 L
s
[(40)] .39156 -0.0125 0 1 Mshowa
.58015 0 m
.58015 .00625 L
s
[(60)] .58015 -0.0125 0 1 Mshowa
.76874 0 m
.76874 .00625 L
s
[(80)] .76874 -0.0125 0 1 Mshowa
.95733 0 m
.95733 .00625 L
s
[(100)] .95733 -0.0125 0 1 Mshowa
.125 Mabswid
.06153 0 m
.06153 .00375 L
s
.10868 0 m
.10868 .00375 L
s
.15582 0 m
.15582 .00375 L
s
.25012 0 m
.25012 .00375 L
s
.29727 0 m
.29727 .00375 L
s
.34441 0 m
.34441 .00375 L
s
.43871 0 m
.43871 .00375 L
s
.48586 0 m
.48586 .00375 L
s
.533 0 m
.533 .00375 L
s
.6273 0 m
.6273 .00375 L
s
.67445 0 m
.67445 .00375 L
s
.72159 0 m
.72159 .00375 L
s
.81589 0 m
.81589 .00375 L
s
.86304 0 m
.86304 .00375 L
s
.91018 0 m
.91018 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .05136 m
.00625 .05136 L
s
[(500)] -0.0125 .05136 1 0 Mshowa
0 .19876 m
.00625 .19876 L
s
[(1000)] -0.0125 .19876 1 0 Mshowa
0 .34616 m
.00625 .34616 L
s
[(1500)] -0.0125 .34616 1 0 Mshowa
0 .49356 m
.00625 .49356 L
s
[(2000)] -0.0125 .49356 1 0 Mshowa
.125 Mabswid
0 .08084 m
.00375 .08084 L
s
0 .11032 m
.00375 .11032 L
s
0 .1398 m
.00375 .1398 L
s
0 .16928 m
.00375 .16928 L
s
0 .22824 m
.00375 .22824 L
s
0 .25772 m
.00375 .25772 L
s
0 .2872 m
.00375 .2872 L
s
0 .31668 m
.00375 .31668 L
s
0 .37564 m
.00375 .37564 L
s
0 .40512 m
.00375 .40512 L
s
0 .4346 m
.00375 .4346 L
s
0 .46408 m
.00375 .46408 L
s
0 .02188 m
.00375 .02188 L
s
0 .52304 m
.00375 .52304 L
s
0 .55252 m
.00375 .55252 L
s
0 .582 m
.00375 .582 L
s
0 .61148 m
.00375 .61148 L
s
.25 Mabswid
0 0 m
0 .61803 L
s
[ 5 ] 0 Mabsdash
.02381 .29074 m
.03324 .60332 L
.04267 .05528 L
.0521 .1691 L
.06153 .13998 L
.07096 .22417 L
.08039 .28788 L
.08982 .2913 L
.09925 .39952 L
.10868 .51732 L
.1181 .05012 L
.12753 .12143 L
.13696 .07418 L
.14639 .13582 L
.15582 .20221 L
.16525 .19864 L
.17468 .27279 L
.18411 .35218 L
.19354 .02742 L
.20297 .0778 L
.2124 .08998 L
.22183 .09794 L
.23126 .09558 L
.24069 .09638 L
.25012 .11545 L
.25955 .1278 L
.26898 .12801 L
.27841 .12114 L
.28784 .1237 L
.29727 .17117 L
.30669 .07459 L
.31612 .12863 L
.32555 .18314 L
.33498 .18134 L
.34441 .24 L
.35384 .30215 L
.36327 .02276 L
.3727 .06595 L
.38213 .08556 L
.39156 .09853 L
.40099 .09971 L
.41042 .1059 L
.41985 .11091 L
.42928 .11356 L
.43871 .11622 L
.44814 .14127 L
.45757 .11946 L
.467 .16238 L
.47643 .06855 L
.48586 .11286 L
Mistroke
.49529 .14973 L
.50471 .1602 L
.51414 .20124 L
.52357 .249 L
.533 .01472 L
.54243 .05218 L
.55186 .06259 L
.56129 .05944 L
.57072 .05817 L
.58015 .06009 L
.58958 .06194 L
.59901 .06412 L
.60844 .06513 L
.61787 .07863 L
.6273 .0704 L
.63673 .07256 L
.64616 .07515 L
.65559 .07751 L
.66502 .07987 L
.67445 .08184 L
.68388 .05829 L
.69331 .09322 L
.70273 .1283 L
.71216 .13096 L
.72159 .12801 L
.73102 .15159 L
.74045 .16338 L
.74988 .16044 L
.75931 .16636 L
.76874 .20082 L
.77817 .07769 L
.7876 .11489 L
.79703 .11126 L
.80646 .14334 L
.81589 .17812 L
.82532 .20967 L
.83475 .02188 L
.84418 .0541 L
.85361 .05106 L
.86304 .07701 L
.87247 .07141 L
.8819 .07612 L
.89132 .07996 L
.90075 .07642 L
.91018 .07441 L
.91961 .07524 L
.92904 .08113 L
.93847 .0832 L
.9479 .08644 L
.95733 .0888 L
Mistroke
.96676 .09116 L
.97619 .28248 L
Mfstroke
.0001 w
[ ] 0 setdash
.02381 .29074 -3.75 0 Mabsadd m
.02381 .29074 0 5 Mabsadd L
.02381 .29074 3.75 0 Mabsadd L
.02381 .29074 0 -5 Mabsadd L
.02381 .29074 -3.75 0 Mabsadd L closepath F
.03324 .60332 -3.75 0 Mabsadd m
.03324 .60332 0 5 Mabsadd L
.03324 .60332 3.75 0 Mabsadd L
.03324 .60332 0 -5 Mabsadd L
.03324 .60332 -3.75 0 Mabsadd L closepath F
.04267 .05528 -3.75 0 Mabsadd m
.04267 .05528 0 5 Mabsadd L
.04267 .05528 3.75 0 Mabsadd L
.04267 .05528 0 -5 Mabsadd L
.04267 .05528 -3.75 0 Mabsadd L closepath F
.0521 .1691 -3.75 0 Mabsadd m
.0521 .1691 0 5 Mabsadd L
.0521 .1691 3.75 0 Mabsadd L
.0521 .1691 0 -5 Mabsadd L
.0521 .1691 -3.75 0 Mabsadd L closepath F
.06153 .13998 -3.75 0 Mabsadd m
.06153 .13998 0 5 Mabsadd L
.06153 .13998 3.75 0 Mabsadd L
.06153 .13998 0 -5 Mabsadd L
.06153 .13998 -3.75 0 Mabsadd L closepath F
.07096 .22417 -3.75 0 Mabsadd m
.07096 .22417 0 5 Mabsadd L
.07096 .22417 3.75 0 Mabsadd L
.07096 .22417 0 -5 Mabsadd L
.07096 .22417 -3.75 0 Mabsadd L closepath F
.08039 .28788 -3.75 0 Mabsadd m
.08039 .28788 0 5 Mabsadd L
.08039 .28788 3.75 0 Mabsadd L
.08039 .28788 0 -5 Mabsadd L
.08039 .28788 -3.75 0 Mabsadd L closepath F
.08982 .2913 -3.75 0 Mabsadd m
.08982 .2913 0 5 Mabsadd L
.08982 .2913 3.75 0 Mabsadd L
.08982 .2913 0 -5 Mabsadd L
.08982 .2913 -3.75 0 Mabsadd L closepath F
.09925 .39952 -3.75 0 Mabsadd m
.09925 .39952 0 5 Mabsadd L
.09925 .39952 3.75 0 Mabsadd L
.09925 .39952 0 -5 Mabsadd L
.09925 .39952 -3.75 0 Mabsadd L closepath F
.10868 .51732 -3.75 0 Mabsadd m
.10868 .51732 0 5 Mabsadd L
.10868 .51732 3.75 0 Mabsadd L
.10868 .51732 0 -5 Mabsadd L
.10868 .51732 -3.75 0 Mabsadd L closepath F
.1181 .05012 -3.75 0 Mabsadd m
.1181 .05012 0 5 Mabsadd L
.1181 .05012 3.75 0 Mabsadd L
.1181 .05012 0 -5 Mabsadd L
.1181 .05012 -3.75 0 Mabsadd L closepath F
.12753 .12143 -3.75 0 Mabsadd m
.12753 .12143 0 5 Mabsadd L
.12753 .12143 3.75 0 Mabsadd L
.12753 .12143 0 -5 Mabsadd L
.12753 .12143 -3.75 0 Mabsadd L closepath F
.13696 .07418 -3.75 0 Mabsadd m
.13696 .07418 0 5 Mabsadd L
.13696 .07418 3.75 0 Mabsadd L
.13696 .07418 0 -5 Mabsadd L
.13696 .07418 -3.75 0 Mabsadd L closepath F
.14639 .13582 -3.75 0 Mabsadd m
.14639 .13582 0 5 Mabsadd L
.14639 .13582 3.75 0 Mabsadd L
.14639 .13582 0 -5 Mabsadd L
.14639 .13582 -3.75 0 Mabsadd L closepath F
.15582 .20221 -3.75 0 Mabsadd m
.15582 .20221 0 5 Mabsadd L
.15582 .20221 3.75 0 Mabsadd L
.15582 .20221 0 -5 Mabsadd L
.15582 .20221 -3.75 0 Mabsadd L closepath F
.16525 .19864 -3.75 0 Mabsadd m
.16525 .19864 0 5 Mabsadd L
.16525 .19864 3.75 0 Mabsadd L
.16525 .19864 0 -5 Mabsadd L
.16525 .19864 -3.75 0 Mabsadd L closepath F
.17468 .27279 -3.75 0 Mabsadd m
.17468 .27279 0 5 Mabsadd L
.17468 .27279 3.75 0 Mabsadd L
.17468 .27279 0 -5 Mabsadd L
.17468 .27279 -3.75 0 Mabsadd L closepath F
.18411 .35218 -3.75 0 Mabsadd m
.18411 .35218 0 5 Mabsadd L
.18411 .35218 3.75 0 Mabsadd L
.18411 .35218 0 -5 Mabsadd L
.18411 .35218 -3.75 0 Mabsadd L closepath F
.19354 .02742 -3.75 0 Mabsadd m
.19354 .02742 0 5 Mabsadd L
.19354 .02742 3.75 0 Mabsadd L
.19354 .02742 0 -5 Mabsadd L
.19354 .02742 -3.75 0 Mabsadd L closepath F
.20297 .0778 -3.75 0 Mabsadd m
.20297 .0778 0 5 Mabsadd L
.20297 .0778 3.75 0 Mabsadd L
.20297 .0778 0 -5 Mabsadd L
.20297 .0778 -3.75 0 Mabsadd L closepath F
.2124 .08998 -3.75 0 Mabsadd m
.2124 .08998 0 5 Mabsadd L
.2124 .08998 3.75 0 Mabsadd L
.2124 .08998 0 -5 Mabsadd L
.2124 .08998 -3.75 0 Mabsadd L closepath F
.22183 .09794 -3.75 0 Mabsadd m
.22183 .09794 0 5 Mabsadd L
.22183 .09794 3.75 0 Mabsadd L
.22183 .09794 0 -5 Mabsadd L
.22183 .09794 -3.75 0 Mabsadd L closepath F
.23126 .09558 -3.75 0 Mabsadd m
.23126 .09558 0 5 Mabsadd L
.23126 .09558 3.75 0 Mabsadd L
.23126 .09558 0 -5 Mabsadd L
.23126 .09558 -3.75 0 Mabsadd L closepath F
.24069 .09638 -3.75 0 Mabsadd m
.24069 .09638 0 5 Mabsadd L
.24069 .09638 3.75 0 Mabsadd L
.24069 .09638 0 -5 Mabsadd L
.24069 .09638 -3.75 0 Mabsadd L closepath F
.25012 .11545 -3.75 0 Mabsadd m
.25012 .11545 0 5 Mabsadd L
.25012 .11545 3.75 0 Mabsadd L
.25012 .11545 0 -5 Mabsadd L
.25012 .11545 -3.75 0 Mabsadd L closepath F
.25955 .1278 -3.75 0 Mabsadd m
.25955 .1278 0 5 Mabsadd L
.25955 .1278 3.75 0 Mabsadd L
.25955 .1278 0 -5 Mabsadd L
.25955 .1278 -3.75 0 Mabsadd L closepath F
.26898 .12801 -3.75 0 Mabsadd m
.26898 .12801 0 5 Mabsadd L
.26898 .12801 3.75 0 Mabsadd L
.26898 .12801 0 -5 Mabsadd L
.26898 .12801 -3.75 0 Mabsadd L closepath F
.27841 .12114 -3.75 0 Mabsadd m
.27841 .12114 0 5 Mabsadd L
.27841 .12114 3.75 0 Mabsadd L
.27841 .12114 0 -5 Mabsadd L
.27841 .12114 -3.75 0 Mabsadd L closepath F
.28784 .1237 -3.75 0 Mabsadd m
.28784 .1237 0 5 Mabsadd L
.28784 .1237 3.75 0 Mabsadd L
.28784 .1237 0 -5 Mabsadd L
.28784 .1237 -3.75 0 Mabsadd L closepath F
.29727 .17117 -3.75 0 Mabsadd m
.29727 .17117 0 5 Mabsadd L
.29727 .17117 3.75 0 Mabsadd L
.29727 .17117 0 -5 Mabsadd L
.29727 .17117 -3.75 0 Mabsadd L closepath F
.30669 .07459 -3.75 0 Mabsadd m
.30669 .07459 0 5 Mabsadd L
.30669 .07459 3.75 0 Mabsadd L
.30669 .07459 0 -5 Mabsadd L
.30669 .07459 -3.75 0 Mabsadd L closepath F
.31612 .12863 -3.75 0 Mabsadd m
.31612 .12863 0 5 Mabsadd L
.31612 .12863 3.75 0 Mabsadd L
.31612 .12863 0 -5 Mabsadd L
.31612 .12863 -3.75 0 Mabsadd L closepath F
.32555 .18314 -3.75 0 Mabsadd m
.32555 .18314 0 5 Mabsadd L
.32555 .18314 3.75 0 Mabsadd L
.32555 .18314 0 -5 Mabsadd L
.32555 .18314 -3.75 0 Mabsadd L closepath F
.33498 .18134 -3.75 0 Mabsadd m
.33498 .18134 0 5 Mabsadd L
.33498 .18134 3.75 0 Mabsadd L
.33498 .18134 0 -5 Mabsadd L
.33498 .18134 -3.75 0 Mabsadd L closepath F
.34441 .24 -3.75 0 Mabsadd m
.34441 .24 0 5 Mabsadd L
.34441 .24 3.75 0 Mabsadd L
.34441 .24 0 -5 Mabsadd L
.34441 .24 -3.75 0 Mabsadd L closepath F
.35384 .30215 -3.75 0 Mabsadd m
.35384 .30215 0 5 Mabsadd L
.35384 .30215 3.75 0 Mabsadd L
.35384 .30215 0 -5 Mabsadd L
.35384 .30215 -3.75 0 Mabsadd L closepath F
.36327 .02276 -3.75 0 Mabsadd m
.36327 .02276 0 5 Mabsadd L
.36327 .02276 3.75 0 Mabsadd L
.36327 .02276 0 -5 Mabsadd L
.36327 .02276 -3.75 0 Mabsadd L closepath F
.3727 .06595 -3.75 0 Mabsadd m
.3727 .06595 0 5 Mabsadd L
.3727 .06595 3.75 0 Mabsadd L
.3727 .06595 0 -5 Mabsadd L
.3727 .06595 -3.75 0 Mabsadd L closepath F
.38213 .08556 -3.75 0 Mabsadd m
.38213 .08556 0 5 Mabsadd L
.38213 .08556 3.75 0 Mabsadd L
.38213 .08556 0 -5 Mabsadd L
.38213 .08556 -3.75 0 Mabsadd L closepath F
.39156 .09853 -3.75 0 Mabsadd m
.39156 .09853 0 5 Mabsadd L
.39156 .09853 3.75 0 Mabsadd L
.39156 .09853 0 -5 Mabsadd L
.39156 .09853 -3.75 0 Mabsadd L closepath F
.40099 .09971 -3.75 0 Mabsadd m
.40099 .09971 0 5 Mabsadd L
.40099 .09971 3.75 0 Mabsadd L
.40099 .09971 0 -5 Mabsadd L
.40099 .09971 -3.75 0 Mabsadd L closepath F
.41042 .1059 -3.75 0 Mabsadd m
.41042 .1059 0 5 Mabsadd L
.41042 .1059 3.75 0 Mabsadd L
.41042 .1059 0 -5 Mabsadd L
.41042 .1059 -3.75 0 Mabsadd L closepath F
.41985 .11091 -3.75 0 Mabsadd m
.41985 .11091 0 5 Mabsadd L
.41985 .11091 3.75 0 Mabsadd L
.41985 .11091 0 -5 Mabsadd L
.41985 .11091 -3.75 0 Mabsadd L closepath F
.42928 .11356 -3.75 0 Mabsadd m
.42928 .11356 0 5 Mabsadd L
.42928 .11356 3.75 0 Mabsadd L
.42928 .11356 0 -5 Mabsadd L
.42928 .11356 -3.75 0 Mabsadd L closepath F
.43871 .11622 -3.75 0 Mabsadd m
.43871 .11622 0 5 Mabsadd L
.43871 .11622 3.75 0 Mabsadd L
.43871 .11622 0 -5 Mabsadd L
.43871 .11622 -3.75 0 Mabsadd L closepath F
.44814 .14127 -3.75 0 Mabsadd m
.44814 .14127 0 5 Mabsadd L
.44814 .14127 3.75 0 Mabsadd L
.44814 .14127 0 -5 Mabsadd L
.44814 .14127 -3.75 0 Mabsadd L closepath F
.45757 .11946 -3.75 0 Mabsadd m
.45757 .11946 0 5 Mabsadd L
.45757 .11946 3.75 0 Mabsadd L
.45757 .11946 0 -5 Mabsadd L
.45757 .11946 -3.75 0 Mabsadd L closepath F
.467 .16238 -3.75 0 Mabsadd m
.467 .16238 0 5 Mabsadd L
.467 .16238 3.75 0 Mabsadd L
.467 .16238 0 -5 Mabsadd L
.467 .16238 -3.75 0 Mabsadd L closepath F
.47643 .06855 -3.75 0 Mabsadd m
.47643 .06855 0 5 Mabsadd L
.47643 .06855 3.75 0 Mabsadd L
.47643 .06855 0 -5 Mabsadd L
.47643 .06855 -3.75 0 Mabsadd L closepath F
.48586 .11286 -3.75 0 Mabsadd m
.48586 .11286 0 5 Mabsadd L
.48586 .11286 3.75 0 Mabsadd L
.48586 .11286 0 -5 Mabsadd L
.48586 .11286 -3.75 0 Mabsadd L closepath F
.49529 .14973 -3.75 0 Mabsadd m
.49529 .14973 0 5 Mabsadd L
.49529 .14973 3.75 0 Mabsadd L
.49529 .14973 0 -5 Mabsadd L
.49529 .14973 -3.75 0 Mabsadd L closepath F
.50471 .1602 -3.75 0 Mabsadd m
.50471 .1602 0 5 Mabsadd L
.50471 .1602 3.75 0 Mabsadd L
.50471 .1602 0 -5 Mabsadd L
.50471 .1602 -3.75 0 Mabsadd L closepath F
.51414 .20124 -3.75 0 Mabsadd m
.51414 .20124 0 5 Mabsadd L
.51414 .20124 3.75 0 Mabsadd L
.51414 .20124 0 -5 Mabsadd L
.51414 .20124 -3.75 0 Mabsadd L closepath F
.52357 .249 -3.75 0 Mabsadd m
.52357 .249 0 5 Mabsadd L
.52357 .249 3.75 0 Mabsadd L
.52357 .249 0 -5 Mabsadd L
.52357 .249 -3.75 0 Mabsadd L closepath F
.533 .01472 -3.75 0 Mabsadd m
.533 .01472 0 5 Mabsadd L
.533 .01472 3.75 0 Mabsadd L
.533 .01472 0 -5 Mabsadd L
.533 .01472 -3.75 0 Mabsadd L closepath F
.54243 .05218 -3.75 0 Mabsadd m
.54243 .05218 0 5 Mabsadd L
.54243 .05218 3.75 0 Mabsadd L
.54243 .05218 0 -5 Mabsadd L
.54243 .05218 -3.75 0 Mabsadd L closepath F
.55186 .06259 -3.75 0 Mabsadd m
.55186 .06259 0 5 Mabsadd L
.55186 .06259 3.75 0 Mabsadd L
.55186 .06259 0 -5 Mabsadd L
.55186 .06259 -3.75 0 Mabsadd L closepath F
.56129 .05944 -3.75 0 Mabsadd m
.56129 .05944 0 5 Mabsadd L
.56129 .05944 3.75 0 Mabsadd L
.56129 .05944 0 -5 Mabsadd L
.56129 .05944 -3.75 0 Mabsadd L closepath F
.57072 .05817 -3.75 0 Mabsadd m
.57072 .05817 0 5 Mabsadd L
.57072 .05817 3.75 0 Mabsadd L
.57072 .05817 0 -5 Mabsadd L
.57072 .05817 -3.75 0 Mabsadd L closepath F
.58015 .06009 -3.75 0 Mabsadd m
.58015 .06009 0 5 Mabsadd L
.58015 .06009 3.75 0 Mabsadd L
.58015 .06009 0 -5 Mabsadd L
.58015 .06009 -3.75 0 Mabsadd L closepath F
.58958 .06194 -3.75 0 Mabsadd m
.58958 .06194 0 5 Mabsadd L
.58958 .06194 3.75 0 Mabsadd L
.58958 .06194 0 -5 Mabsadd L
.58958 .06194 -3.75 0 Mabsadd L closepath F
.59901 .06412 -3.75 0 Mabsadd m
.59901 .06412 0 5 Mabsadd L
.59901 .06412 3.75 0 Mabsadd L
.59901 .06412 0 -5 Mabsadd L
.59901 .06412 -3.75 0 Mabsadd L closepath F
.60844 .06513 -3.75 0 Mabsadd m
.60844 .06513 0 5 Mabsadd L
.60844 .06513 3.75 0 Mabsadd L
.60844 .06513 0 -5 Mabsadd L
.60844 .06513 -3.75 0 Mabsadd L closepath F
.61787 .07863 -3.75 0 Mabsadd m
.61787 .07863 0 5 Mabsadd L
.61787 .07863 3.75 0 Mabsadd L
.61787 .07863 0 -5 Mabsadd L
.61787 .07863 -3.75 0 Mabsadd L closepath F
.6273 .0704 -3.75 0 Mabsadd m
.6273 .0704 0 5 Mabsadd L
.6273 .0704 3.75 0 Mabsadd L
.6273 .0704 0 -5 Mabsadd L
.6273 .0704 -3.75 0 Mabsadd L closepath F
.63673 .07256 -3.75 0 Mabsadd m
.63673 .07256 0 5 Mabsadd L
.63673 .07256 3.75 0 Mabsadd L
.63673 .07256 0 -5 Mabsadd L
.63673 .07256 -3.75 0 Mabsadd L closepath F
.64616 .07515 -3.75 0 Mabsadd m
.64616 .07515 0 5 Mabsadd L
.64616 .07515 3.75 0 Mabsadd L
.64616 .07515 0 -5 Mabsadd L
.64616 .07515 -3.75 0 Mabsadd L closepath F
.65559 .07751 -3.75 0 Mabsadd m
.65559 .07751 0 5 Mabsadd L
.65559 .07751 3.75 0 Mabsadd L
.65559 .07751 0 -5 Mabsadd L
.65559 .07751 -3.75 0 Mabsadd L closepath F
.66502 .07987 -3.75 0 Mabsadd m
.66502 .07987 0 5 Mabsadd L
.66502 .07987 3.75 0 Mabsadd L
.66502 .07987 0 -5 Mabsadd L
.66502 .07987 -3.75 0 Mabsadd L closepath F
.67445 .08184 -3.75 0 Mabsadd m
.67445 .08184 0 5 Mabsadd L
.67445 .08184 3.75 0 Mabsadd L
.67445 .08184 0 -5 Mabsadd L
.67445 .08184 -3.75 0 Mabsadd L closepath F
.68388 .05829 -3.75 0 Mabsadd m
.68388 .05829 0 5 Mabsadd L
.68388 .05829 3.75 0 Mabsadd L
.68388 .05829 0 -5 Mabsadd L
.68388 .05829 -3.75 0 Mabsadd L closepath F
.69331 .09322 -3.75 0 Mabsadd m
.69331 .09322 0 5 Mabsadd L
.69331 .09322 3.75 0 Mabsadd L
.69331 .09322 0 -5 Mabsadd L
.69331 .09322 -3.75 0 Mabsadd L closepath F
.70273 .1283 -3.75 0 Mabsadd m
.70273 .1283 0 5 Mabsadd L
.70273 .1283 3.75 0 Mabsadd L
.70273 .1283 0 -5 Mabsadd L
.70273 .1283 -3.75 0 Mabsadd L closepath F
.71216 .13096 -3.75 0 Mabsadd m
.71216 .13096 0 5 Mabsadd L
.71216 .13096 3.75 0 Mabsadd L
.71216 .13096 0 -5 Mabsadd L
.71216 .13096 -3.75 0 Mabsadd L closepath F
.72159 .12801 -3.75 0 Mabsadd m
.72159 .12801 0 5 Mabsadd L
.72159 .12801 3.75 0 Mabsadd L
.72159 .12801 0 -5 Mabsadd L
.72159 .12801 -3.75 0 Mabsadd L closepath F
.73102 .15159 -3.75 0 Mabsadd m
.73102 .15159 0 5 Mabsadd L
.73102 .15159 3.75 0 Mabsadd L
.73102 .15159 0 -5 Mabsadd L
.73102 .15159 -3.75 0 Mabsadd L closepath F
.74045 .16338 -3.75 0 Mabsadd m
.74045 .16338 0 5 Mabsadd L
.74045 .16338 3.75 0 Mabsadd L
.74045 .16338 0 -5 Mabsadd L
.74045 .16338 -3.75 0 Mabsadd L closepath F
.74988 .16044 -3.75 0 Mabsadd m
.74988 .16044 0 5 Mabsadd L
.74988 .16044 3.75 0 Mabsadd L
.74988 .16044 0 -5 Mabsadd L
.74988 .16044 -3.75 0 Mabsadd L closepath F
.75931 .16636 -3.75 0 Mabsadd m
.75931 .16636 0 5 Mabsadd L
.75931 .16636 3.75 0 Mabsadd L
.75931 .16636 0 -5 Mabsadd L
.75931 .16636 -3.75 0 Mabsadd L closepath F
.76874 .20082 -3.75 0 Mabsadd m
.76874 .20082 0 5 Mabsadd L
.76874 .20082 3.75 0 Mabsadd L
.76874 .20082 0 -5 Mabsadd L
.76874 .20082 -3.75 0 Mabsadd L closepath F
.77817 .07769 -3.75 0 Mabsadd m
.77817 .07769 0 5 Mabsadd L
.77817 .07769 3.75 0 Mabsadd L
.77817 .07769 0 -5 Mabsadd L
.77817 .07769 -3.75 0 Mabsadd L closepath F
.7876 .11489 -3.75 0 Mabsadd m
.7876 .11489 0 5 Mabsadd L
.7876 .11489 3.75 0 Mabsadd L
.7876 .11489 0 -5 Mabsadd L
.7876 .11489 -3.75 0 Mabsadd L closepath F
.79703 .11126 -3.75 0 Mabsadd m
.79703 .11126 0 5 Mabsadd L
.79703 .11126 3.75 0 Mabsadd L
.79703 .11126 0 -5 Mabsadd L
.79703 .11126 -3.75 0 Mabsadd L closepath F
.80646 .14334 -3.75 0 Mabsadd m
.80646 .14334 0 5 Mabsadd L
.80646 .14334 3.75 0 Mabsadd L
.80646 .14334 0 -5 Mabsadd L
.80646 .14334 -3.75 0 Mabsadd L closepath F
.81589 .17812 -3.75 0 Mabsadd m
.81589 .17812 0 5 Mabsadd L
.81589 .17812 3.75 0 Mabsadd L
.81589 .17812 0 -5 Mabsadd L
.81589 .17812 -3.75 0 Mabsadd L closepath F
.82532 .20967 -3.75 0 Mabsadd m
.82532 .20967 0 5 Mabsadd L
.82532 .20967 3.75 0 Mabsadd L
.82532 .20967 0 -5 Mabsadd L
.82532 .20967 -3.75 0 Mabsadd L closepath F
.83475 .02188 -3.75 0 Mabsadd m
.83475 .02188 0 5 Mabsadd L
.83475 .02188 3.75 0 Mabsadd L
.83475 .02188 0 -5 Mabsadd L
.83475 .02188 -3.75 0 Mabsadd L closepath F
.84418 .0541 -3.75 0 Mabsadd m
.84418 .0541 0 5 Mabsadd L
.84418 .0541 3.75 0 Mabsadd L
.84418 .0541 0 -5 Mabsadd L
.84418 .0541 -3.75 0 Mabsadd L closepath F
.85361 .05106 -3.75 0 Mabsadd m
.85361 .05106 0 5 Mabsadd L
.85361 .05106 3.75 0 Mabsadd L
.85361 .05106 0 -5 Mabsadd L
.85361 .05106 -3.75 0 Mabsadd L closepath F
.86304 .07701 -3.75 0 Mabsadd m
.86304 .07701 0 5 Mabsadd L
.86304 .07701 3.75 0 Mabsadd L
.86304 .07701 0 -5 Mabsadd L
.86304 .07701 -3.75 0 Mabsadd L closepath F
.87247 .07141 -3.75 0 Mabsadd m
.87247 .07141 0 5 Mabsadd L
.87247 .07141 3.75 0 Mabsadd L
.87247 .07141 0 -5 Mabsadd L
.87247 .07141 -3.75 0 Mabsadd L closepath F
.8819 .07612 -3.75 0 Mabsadd m
.8819 .07612 0 5 Mabsadd L
.8819 .07612 3.75 0 Mabsadd L
.8819 .07612 0 -5 Mabsadd L
.8819 .07612 -3.75 0 Mabsadd L closepath F
.89132 .07996 -3.75 0 Mabsadd m
.89132 .07996 0 5 Mabsadd L
.89132 .07996 3.75 0 Mabsadd L
.89132 .07996 0 -5 Mabsadd L
.89132 .07996 -3.75 0 Mabsadd L closepath F
.90075 .07642 -3.75 0 Mabsadd m
.90075 .07642 0 5 Mabsadd L
.90075 .07642 3.75 0 Mabsadd L
.90075 .07642 0 -5 Mabsadd L
.90075 .07642 -3.75 0 Mabsadd L closepath F
.91018 .07441 -3.75 0 Mabsadd m
.91018 .07441 0 5 Mabsadd L
.91018 .07441 3.75 0 Mabsadd L
.91018 .07441 0 -5 Mabsadd L
.91018 .07441 -3.75 0 Mabsadd L closepath F
.91961 .07524 -3.75 0 Mabsadd m
.91961 .07524 0 5 Mabsadd L
.91961 .07524 3.75 0 Mabsadd L
.91961 .07524 0 -5 Mabsadd L
.91961 .07524 -3.75 0 Mabsadd L closepath F
.92904 .08113 -3.75 0 Mabsadd m
.92904 .08113 0 5 Mabsadd L
.92904 .08113 3.75 0 Mabsadd L
.92904 .08113 0 -5 Mabsadd L
.92904 .08113 -3.75 0 Mabsadd L closepath F
.93847 .0832 -3.75 0 Mabsadd m
.93847 .0832 0 5 Mabsadd L
.93847 .0832 3.75 0 Mabsadd L
.93847 .0832 0 -5 Mabsadd L
.93847 .0832 -3.75 0 Mabsadd L closepath F
.9479 .08644 -3.75 0 Mabsadd m
.9479 .08644 0 5 Mabsadd L
.9479 .08644 3.75 0 Mabsadd L
.9479 .08644 0 -5 Mabsadd L
.9479 .08644 -3.75 0 Mabsadd L closepath F
.95733 .0888 -3.75 0 Mabsadd m
.95733 .0888 0 5 Mabsadd L
.95733 .0888 3.75 0 Mabsadd L
.95733 .0888 0 -5 Mabsadd L
.95733 .0888 -3.75 0 Mabsadd L closepath F
.96676 .09116 -3.75 0 Mabsadd m
.96676 .09116 0 5 Mabsadd L
.96676 .09116 3.75 0 Mabsadd L
.96676 .09116 0 -5 Mabsadd L
.96676 .09116 -3.75 0 Mabsadd L closepath F
.97619 .28248 -3.75 0 Mabsadd m
.97619 .28248 0 5 Mabsadd L
.97619 .28248 3.75 0 Mabsadd L
.97619 .28248 0 -5 Mabsadd L
.97619 .28248 -3.75 0 Mabsadd L closepath F
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[34]:=",
  ImageSize->{400, 247.188},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006@0000mb000`400?l00000o`00003ooooooonA
ooooo`00oooooonAooooo`00oooooonAooooo`008?ooool2o`0003oooooo1Ol00003ooooo`;o0000
?_ooool3o`0000?ooooo0_l0000mooooo`?o00001?ooool2o`0003gooooo0ol00004ooooo`;o0000
>_ooool3o`0000Cooooo0_l00004ooooo`;o00002_ooool001oooooo00Co0000oooooooooooo0000
?oooool01?l0003oooooooooool00002ooooo`04o`000?ooooooooooo`0003kooooo00Go0000oooo
ooooooooooooo`000002ooooo`03o`000?oooooooooo03Wooooo00Go0000ooooooooooooooooo`00
0002ooooo`04o`000?ooooooooooo`0003_ooooo00Go0000ooooooooooooooooo`000002ooooo`04
o`000?ooooooooooo`0003[ooooo00?o0000ooooooooool00_ooool01?l0003oooooooooool00002
ooooo`04o`000?ooooooooooo`0000Wooooo000Oooooo`04o`000?ooooooooooo`00043ooooo00?o
0000ooooooooool00_ooool01?l0003oooooooooool0000kooooo`Go00000_ooool01?l0003ooooo
ooooool0000kooooo`05o`000?ooooooooooooooool000000_ooool01?l0003oooooooooool0000k
ooooo`05o`000?ooooooooooooooool000000_ooool01?l0003oooooooooool0000jooooo`03o`00
0?oooooooooo00;ooooo00Co0000oooooooooooo00000_ooool01?l0003oooooooooool00009oooo
o`007oooool01?l0003oooooooooool00011ooooo`05o`000?ooooooooooooooool000000_ooool0
0ol0003oooooooooo`0iooooo`04o`000?ooooooooooo`0000?ooooo00Co0000oooooooooooo0000
>oooool4o`0000?ooooo00Co0000oooooooooooo0000??ooool3o`0000?ooooo00Co0000oooooooo
oooo0000>_ooool00ol0003oooooooooo`02ooooo`04o`000?ooooooooooo`0000;ooooo00Co0000
oooooooooooo00002Oooool001oooooo00Co0000oooooooooooo0000?_ooool01Ol0003ooooooooo
oooooooo000000;ooooo00Co0000oooooooooooo0000??ooool00ol0003oooooo`000003ooooo`04
o`000?ooooooooooo`0003_ooooo00?o0000ooooooooool01?ooool01?l0003oooooooooool0000k
ooooo`05o`000?ooooooooooooooool000000_ooool01?l0003oooooooooool0000jooooo`03o`00
0?oooooooooo00;ooooo00Co0000oooooooooooo00000_ooool01?l0003oooooooooool00009oooo
o`007oooool01?l0003oooooooooool0000nooooo`05o`000?ooooooooooooooool000000_ooool0
1?l0003oooooooooool0000mooooo`;o00000oooool01?l0003oooooooooool0000looooo`03o`00
0?oooooooooo00?ooooo00Co0000oooooooooooo0000>oooool01Ol0003ooooooooooooooooo0000
00;ooooo00Co0000oooooooooooo0000>Oooool2o`0000Cooooo00Co0000oooooooooooo00000_oo
ool01?l0003oooooooooool00009ooooo`008?ooool2o`00043ooooo0ol00004ooooo`;o0000?ooo
ool00ol0003oooooooooo`02ooooo`;o0000?_ooool2o`0000Cooooo0_l0000mooooo`?o00001?oo
ool2o`0003_ooooo00?o0000ooooooooool00oooool2o`0000Cooooo0_l0000:ooooo`00oooooonA
ooooo`00oooooonAooooo`00oooooonAooooo`00oooooonAooooo`00oooooonAooooo`00oooooonA
ooooo`007?ooooooo`0007Go0000000Looooo`03o`000?oooooooooo00;ooooo00?o0000oooooooo
ool03oooool00ol0003oooooooooo`0>ooooo`03o`000?oooooooooo00oooooo00?o0000oooooooo
ool03_ooool00ol0003oooooooooo`0?ooooo`03o`000?oooooooooo00kooooo00?o0000oooooooo
ool03oooool00ol0003oooooooooo`0>ooooo`03o`000?oooooooooo00oooooo00?o0000oooooooo
ool03_ooool00ol0003oooooooooo`0?ooooo`03o`000?oooooooooo00kooooo00?o0000oooooooo
ool03_ooool00ol0003oooooooooo`0?ooooo`03o`000?oooooooooo00kooooo00?o0000oooooooo
ool03oooool00ol0003oooooooooo`0>ooooo`03o`000?oooooooooo00oooooo00?o0000oooooooo
ool03_ooool00ol0003oooooooooo`0?ooooo`03o`000?oooooooooo00kooooo000Looooo`03o`00
0?oooooooooo00;ooooo00?o0000ooooooooool0@oooool00ol0003oooooooooo`13ooooo`03o`00
0?oooooooooo03;ooooo00?o0000ooooooooool03_ooool00ol0003oooooooooo`13ooooo`03o`00
0?oooooooooo04?ooooo00?o0000ooooooooool03_ooool001cooooo00?o0000ooooooooool0B?oo
ool00ol007ooooooooooo`13ooooo`03o`00Oooooooooooo037ooooo0ol0000?ooooo`03o`00Oooo
oooooooo04?ooooo00?o001oooooooooool0E?ooool001cooooo00?o0000ooooooooool0B?ooool0
0ol007ooooooooooo`13ooooo`03o`00Oooooooooooo033ooooo1?l0000?ooooo`03o`00Oooooooo
oooo04?ooooo00?o001oooooooooool0E?ooool001cooooo00?o0000ooooooooool0B?ooool00ol0
07ooooooooooo`0iooooo`03o`000?oooooooooo00Oooooo00?o001oooooooooool0;oooool6o`00
00kooooo00?o001oooooooooool0@oooool00ol007ooooooooooo`0Eooooo`03o`000?oooooooooo
03cooooo000Looooo`03o`000?oooooooooo04Sooooo00?o001oooooooooool0>?ooool3o`0000So
oooo00?o001oooooooooool0;_ooool7o`0000kooooo00?o001oooooooooool0@oooool00ol007oo
ooooooooo`0Dooooo`?o0000?Oooool001cooooo00?o0000ooooooooool0AOooool01?l0003ooooo
ooooool007liooooo`Co00002?ooool00ol007ooooooooooo`0_ooooo`Ko00003_ooool00ol007oo
ooooooooo`13ooooo`03o`00Oooooooooooo01?ooooo1Ol0000looooo`007?ooool3o`0004Cooooo
0ol000000ooooooo001oooooo`0gooooo`Ko00001oooool00ol007ooooooooooo`0`ooooo`Co0000
3oooool00ol007ooooooooooo`13ooooo`03o`00Oooooooooooo01?ooooo1_l0000kooooo`007?oo
ool00ol0003oooooooooo`13ooooo`Go000000?o001oooooooooool0=Oooool7o`0000Oooooo00?o
001oooooooooool0<Oooool3o`0000oooooo00?o001oooooooooool0@oooool00ol007oooooooooo
o`0Booooo`Oo0000>oooool001cooooo00?o0000ooooooooool0@_ooool7o`0003Sooooo1_l00007
ooooo`03o`00Oooooooooooo03;ooooo0_l0000?ooooo`03o`00Oooooooooooo04?ooooo00?o001o
ooooooooool04oooool6o`0003_ooooo000Looooo`03o`000?oooooooooo047ooooo2?l0000ioooo
o`Co00002?ooool00ol007ooooooooooo`0aooooo`03o`000?oooooooooo00oooooo00?o001ooooo
ooooool0@oooool00ol007ooooooooooo`0Dooooo`Co0000??ooool001cooooo00?o0000oooooooo
ool0@_ooool7o`0003[ooooo0_l00009ooooo`03o`00Oooooooooooo037ooooo00?o0000oooooooo
ool03oooool00ol007ooooooooooo`13ooooo`03o`00Oooooooooooo01Cooooo0ol0000mooooo`00
7?ooool00ol0003oooooooooo`13ooooo`Go000000?o001oooooooooool0>Oooool00ol0003ooooo
ooooo`07ooooo`03o`00Oooooooooooo037ooooo00?o0000ooooooooool03oooool00ol007oooooo
ooooo`13ooooo`03o`00Oooooooooooo01Gooooo00?o0000ooooooooool0??ooool001cooooo00?o
0000ooooooooool0A?ooool3o`000003ooooool007oooooo03Wooooo00?o0000ooooool000002?oo
ool00ol007ooooooooooo`0aooooo`04o`000?ooooooooooo`0000kooooo00?o001oooooooooool0
@oooool00ol007ooooooooooo`0Eooooo`03o`000?oooooooooo03cooooo000Looooo`03o`000?oo
oooooooo02Wooooo00?o0000ooooooooool06Oooool2o`000003ooooool007oooooo03Wooooo00?o
0000ooooool000002?ooool00ol007ooooooooooo`0aooooo`04o`000?ooooooooooo`0000kooooo
00?o001oooooooooool0@oooool00ol007ooooooooooo`0Eooooo`03o`000?oooooooooo03cooooo
0007ooooo`?o00001?ooool2o`0000Cooooo0_l00006ooooo`03o`000?oooooooooo02Sooooo0ol0
000Jooooo`;o000000?oooooo`00Ooooool0>Oooool00ol0003oooooo`000008ooooo`03o`00Oooo
oooooooo037ooooo00?o0000ooooooooool00_l0000=ooooo`03o`00Oooooooooooo04?ooooo00?o
001oooooooooool05Oooool01?l0003oooooooooool00003ooooo`03o`000?oooooooooo03Gooooo
0006ooooo`05o`000?ooooooooooooooool000000_ooool01?l0003oooooooooool00002ooooo`04
o`000?ooooooooooo`0000Gooooo00?o0000ooooooooool03Oooool00ol0003oooooooooo`0Goooo
o`Go00006Oooool01?l0003oooooooooool007m5ooooo`03o`00Oooooooooooo03Cooooo0ol0000<
ooooo`03o`00Oooooooooooo04?ooooo00?o001oooooooooool05Oooool00ol0003oooooooooo`02
o`000004ooooool0003o0000o`0003Kooooo000:ooooo`04o`000?ooooooooooo`0000;ooooo00Co
0000oooooooooooo00000_ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00cooooo
0ol0000Gooooo`Oo00006?ooool01?l0003oooooooooool007m5ooooo`03o`00Oooooooooooo03?o
oooo1Ol00008ooooo`04o`000?ooooooooooo`00ObGooooo00?o0000ooooooooool07Oooool00ol0
07ooooooooooo`0Eooooo`03o`000?oooooooooo00Oo0000=Oooool000[ooooo00Co0000oooooooo
oooo00000_ooool01?l0003oooooooooool00002ooooo`03o`000?oooooooooo00?ooooo0ol0000;
o`00O`Go00005Ol007l8o`0001So001o00?o0000o`00Ool007l0Nol007l7o`0000?o001o00?o0000
o`00Ool007l00ol000000ol007oo0000o`00O`0So`00O`?o0000=_l007l00ol0003o001oo`000008
o`0003Co001o0006ooooo`Co00000oooool01?l0003oooooooooool00002ooooo`04o`000?oooooo
ooooo`0000Gooooo00?o0000ooooooooool02_ooool7o`0001Gooooo1ol0000Kooooo`03o`00Oooo
oooooooo04?ooooo00?o001oooooooooool0<Oooool9o`000003ooooool0003o000000So000000?o
ooooo`000?ooool07oooool5o`0001gooooo00?o001oooooooooool05_ooool:o`0003Cooooo0006
ooooo`03o`000?oooooooooo00Cooooo00Co0000oooooooooooo00000_ooool01?l0003ooooooooo
ool00005ooooo`03o`000?oooooooooo00Wooooo2?l0000Fooooo`Go00006oooool00ol0003o001o
ooooo`0iooooo`03o`000?oooooooooo00;o00001_ooool00ol007ooooooooooo`0aoooooaOo0000
0_ooool01?l0003oooooooooool0000Iooooo`Ko00007?ooool00ol007ooooooooooo`0Eooooo`_o
0000=?ooool000Kooooo1Ol00003ooooo`;o00001?ooool2o`0000Kooooo00?o0000ooooooooool0
2_ooool7o`0001Oooooo0ol0000Looooo`03o`000?l007oooooo03Wooooo00?o0000ooooooooool0
0ol00005ooooo`03o`00Oooooooooooo01gooooo00?o0000ooooooooool04Oooool00ol0003ooooo
o`00000Ko`0001Oooooo1ol0000Looooo`03o`00Oooooooooooo01Kooooo2Ol0000eooooo`007?oo
ool00ol0003oooooooooo`0;ooooo`Go00006Oooool00ol0003oooooooooo`0Kooooo`03o`000?l0
07oooooo03Wooooo00?o0000ooooool000001?l00004ooooo`03o`00Oooooooooooo01cooooo0ol0
000Booooo`03o`000?oooooooooo01co00001?ooool00ol0003oooooooooo`0@ooooo`Ko00007?oo
ool00ol007ooooooooooo`0Gooooo`So00001?ooool00ol0003oooooooooo`0^ooooo`007?ooool0
0ol0003oooooooooo`0<ooooo`?o00006_ooool00ol0003oooooooooo`04ooooo`03o`000?oooooo
oooo017ooooo00Go0000ooooooooooooooooo`00000Vooooo`03o`000?oooooooooo017ooooo2?l0
0003ooooo`03o`00Oooooooooooo01_ooooo1?l0000Booooo`04o`000?oooooooooooooooaco0000
0_ooool3o`0000;ooooo00?o0000ooooooooool03Oooool4o`0001gooooo00?o001oooooooooool0
5?ooool01?l0003oooooooooooooool3o`000004ooooool0003oooooo`0000?ooooo0ol0000<oooo
o`03o`000?oooooooooo023ooooo000Looooo`03o`000?oooooooooo00gooooo00?o0000oooooooo
ool06Oooool00ol0003oooooooooo`03ooooo`?o00004_ooool01Ol0003ooooooooooooooooo0000
02Gooooo0ol0000Booooo`So00000oooool00ol007ooooooooooo`0Jooooo`Ko00004Oooool00ol0
003oooooooooo`02oooooa_o000000?oooooo`000?l000001_l000000ooooooo0000ooooo`02oooo
o`03o`000?oooooooooo00Kooooo0ol0000Nooooo`03o`00Oooooooooooo01Cooooo00?o0000oooo
ooooool00_ooool00ol0003oooooooooo`02ooooo`03o`000?oooooo000000Go000000?oooooo`00
0?ooool01Oooool00ol0003oooooo`000002o`0000;ooooo00?o0000ooooooooool07?ooool001co
oooo00?o0000ooooooooool03Oooool00ol0003oooooooooo`0Jooooo`04o`000?oooooooooooooo
o`Go00004Oooool01Ol0003ooooooooooooooooo000002Cooooo1?l0000Booooo`So00000oooool0
0ol007ooooooooooo`0Iooooo`Oo00004Oooool00ol0003oooooooooo`03ooooo`Oo00000_ooool0
0ol0003oooooo`00000Jo`000006ooooool0003o0000o`000?oooooo00001Oooool3o`0001kooooo
00Co001ooooooooooooo00004oooool00ol0003oooooooooo`08ooooo`[o000000Coooooo`000?oo
oooooooo2_l0000Mooooo`007?ooool00ol0003oooooooooo`0=ooooo`03o`000?oooooooooo01[o
oooo00?o0000ooooooooool01ol0000@ooooo`03o`000?oooooooooo00?o00008_ooool6o`0001?o
oooo1Ol00004ooooo`03o`00Oooooooooooo01[ooooo1_l0000Hooooo`;o00000_ooool00ol0003o
ooooooooo`04ooooo`03o`000?oooooo000001ko00000_ooool00ol0003oooooo`000002ooooo`03
o`000?oooooooooo01_ooooo00?o001oooooool000000_l0000Booooo`03o`000?oooooooooo00Oo
oooo6Ol000000ooooooo0000ooooo`0Jooooo`007?ooool00ol0003oooooooooo`0>ooooo`03o`00
0?oooooooooo01Wooooo00?o0000ooooool000001ol0000@ooooo`03o`000?oooooo000000Co0000
8?ooool7o`0001Cooooo0ol00002ooooo`04o`000?ooooooooooo`00Oagooooo1?l0000Jooooo`03
o`000?oooooooooo00Oooooo00Co001ooooooooooooo00000_oooolOo`00027ooooo00?o001oo`00
0?l000000ol0000Aooooo`03o`000?oooooooooo00Kooooo7Ol00002ooooo`03o`000?oooooooooo
01Gooooo000Looooo`03o`000?oooooooooo00kooooo00?o0000ooooooooool06?ooool01?l0003o
ooooooooooooool7o`00013ooooo00?o0000ooooool000001Ol0000Pooooo`Ko00005Oooool00ol0
003oooooooooo`03o`000003ooooool007oooooo01gooooo0_l0000Uooooo`03o`00Oooooooooooo
00Cooooo00?o0000ooooooooool07?l0000Pooooo`03o`00Ool0003o000000Co00004?ooool00ol0
003oooooooooo`05ooooob;o000000?oooooo`000?ooool04oooool001cooooo0ol0000>ooooo`03
o`000?oooooooooo01Sooooo00?o0000ooooooooool00_ooool5o`0001;ooooo2?l0000Pooooo`Co
00006?ooool4o`000003ooooool007oooooo01gooooo0_l0000Uooooo`03o`00Oooooooooooo00Oo
oooo7Ol0000Oooooo`Oo00006OoooolTo`0000;ooooo00?o0000ooooooooool03_ooool001cooooo
00?o0000ooooooooool03Oooool00ol0003oooooooooo`0Iooooo`03o`000?oooooooooo00?ooooo
0ol0000Dooooo`So00008?ooool2o`0001?ooooo00?o0000ooooooooool00_ooool6o`000003o`00
Oooooooooooo01cooooo0_l0000Booooo`03o`000?oooooooooo013ooooo00?o001oooooooooool0
2?ooool7o`0000;ooooo4ol00002ooooo`;o00006oooool00ol007oo0000o`000004o`0001[ooooo
1_l000000ooooooo0000o`00000No`000003ooooool0003ooooo00cooooo000Looooo`03o`000?oo
oooooooo00gooooo00?o0000ooooooooool06Oooool00ol0003oooooooooo`03ooooo`?o00005Ooo
ool8o`0000Cooooo00Co0000oooooooooooo00005oooool2o`0001?ooooo00Co0000oooooooooooo
oooo1ol000000ol007ooooooooooo`0Looooo`03o`000?oooooo0000017ooooo00?o0000oooooooo
ool04?ooool00ol007ooooooooooo`09ooooo`Go00001?ooool00ol0003oooooo`000002o`000003
ooooool0003o000000[o00000_ooool3o`0001[ooooo00?o001oooooool000000ol0000Looooo`?o
00001?ooool9o`0000;ooooo00?o0000ooooooooool05?l0000<ooooo`007?ooool00ol0003ooooo
ooooo`0=ooooo`03o`000?oooooooooo01Wooooo00?o0000ooooool000000oooool00ol0003ooooo
o`00000Eooooo`Wo00000_ooool6o`0001Sooooo00?o0000ooooooooool04?ooool00ol0003ooooo
ooooo`02ooooo`Oo00008?ooool00ol0003oooooooooo`0?ooooo`03o`000?oooooooooo013ooooo
00?o001oooooooooool02_ooool3o`0000Sooooo00Ko0000ooooooooooooooooo`000?ooool8o`00
00;ooooo1Ol0000Iooooo`03o`00Oooooooo000000;o00007_ooool00ol0003oooooooooo`04oooo
o`03o`000?oooooo000000;o00000_ooool00ol0003oooooooooo`04oooooaCo00002oooool001co
oooo00?o0000ooooooooool03Oooool00ol0003oooooooooo`0Iooooo`03o`000?oooooo000000?o
oooo00?o0000ooooooooool04_ooool01?l0003ooooooooooooooolAo`0001Oooooo00?o0000oooo
ooooool04?ooool00ol0003oooooooooo`03ooooo`Oo00000_ooool00ol0003oooooooooo`0Joooo
o`03o`000?oooooooooo00oooooo00?o0000ooooooooool04?ooool00ol007ooooooooooo`0;oooo
o`03o`000?oooooooooo00kooooo00?o0000ooooooooool00ol00002ooooo`Oo00006?ooool00ol0
07ooooooooooo`02o`0001;ooooo00?o0000ooooooooool04oooool00ol0003oooooooooo`0:oooo
oa?o00002_ooool001cooooo00?o0000ooooooooool03Oooool2o`0001cooooo00Co0000oooooooo
oooo00005Oooool01Ol0003ooooooooooooooooo001o017o00005_ooool00ol0003oooooooooo`0@
ooooo`03o`000?oooooooooo00Cooooo2_l0000]ooooo`03o`000?oooooooooo013ooooo00?o001o
ooooooooool08?ooool00ol0003oooooooooo`08o`0001Sooooo00?o001oooooooooool00_ooool0
0ol0003oooooooooo`0?ooooo`03o`000?oooooooooo027ooooo00?o0000ooooooooool03ol0000:
ooooo`007?ooool00ol0003oooooooooo`0=ooooo`;o00007?ooool01?l0003oooooooooool0000E
ooooo`06o`000?ooooooooooooooool007oooooo4?l0000Gooooo`03o`000?oooooooooo00oooooo
00?o0000ooooooooool01Oooool9o`000003ooooool0003ooooo02[ooooo00?o0000ooooooooool0
4?ooool00ol007ooooooooooo`0Tooooo`Oo00006?ooool00ol007ooooooooooo`02ooooo`03o`00
0?oooooooooo00oooooo00?o0000ooooooooool09Oooool00ol0003oooooo`00000;o`0000[ooooo
000Looooo`03o`000?oooooooooo00kooooo00?o0000ooooooooool06_ooool01?l0003ooooooooo
ool0000Eooooo`05o`000?ooooooooooooooool007l00_ooool?o`0001Cooooo00Co0000oooooooo
oooo00006?ooool=o`0001Gooooo00?o0000ooooooooool09Oooool00ol007ooooooooooo`0Uoooo
o`Go00006Oooool00ol007ooooooooooo`02ooooo`03o`000?oooooooooo00oooooo00?o0000oooo
ooooool0:?ooool00ol0003oooooooooo`07o`0000_ooooo000Looooo`03o`000?oooooooooo00ko
oooo00?o0000ooooooooool06_ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo013o
oooo00Go0000ooooooooooooooooo`00O`03ooooo`go00005Oooool01?l0003oooooooooool0000I
ooooo`go000000?oooooo`000?ooool04Oooool01Ol0003ooooooooooooooooo000002?ooooo00?o
001oooooooooool09_ooool3o`0001[ooooo00?o001oooooooooool00oooool01Ol0003ooooooooo
oooooooo000000cooooo00?o0000ooooooooool0;?ooool00ol0003oooooo`000002o`0000cooooo
000Looooo`03o`000?oooooooooo00kooooo00?o0000ooooooooool05oooool00ol0003ooooooooo
o`06ooooo`03o`000?oooooooooo013ooooo00Go0000ooooooooooooooooo`00O`05ooooo`[o0000
5_ooool00ol0003oooooooooo`0Kooooo`oo000000?oooooo`000?ooool03_ooool01?l0003ooooo
ooooooooool2o`0002;ooooo00?o001oooooooooool09oooool00ol0003oooooooooo`0Iooooo`04
o`00Ooooooooooooo`0000?ooooo00?o0000ooooool000000_l0000;ooooo`03o`000?oooooooooo
02oooooo00?o0000ooooooooool02oooool001cooooo00?o0000ooooooooool03_ooool00ol0003o
ooooooooo`0Gooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool05?ooool00ol007oo
ooooooooo`03ooooo`?o00000_ooool02?l0003oooooooooool0003oooooo`000?oooooo00004_oo
ool00ol0003oooooooooo`0Moooooa7o00000_ooool00ol0003oooooooooo`09ooooo`04o`000?oo
ooooooooooooo`?o00008Oooool00ol007ooooooooooo`13ooooo`04o`00Ooooooooooooo`0000;o
oooo1ol0000looooo`03o`000?oooooooooo00_ooooo000Looooo`?o00003Oooool00ol0003ooooo
ooooo`0Hooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool04oooool00ol007oooooo
ooooo`04ooooo`03o`000?oooooooooo00Kooooo1?l0000Aooooo`03o`000?oooooooooo01?ooooo
00?o0000ooooooooool02?ooool00ol0003oooooooooo`0Ao`0000Gooooo00?o0000ooooooooool0
0_ooool00ol0003oooooooooo`05o`0000gooooo00?o0000ooooooooool04?ooool00ol007oooooo
ooooo`0Yooooo`03o`000?oooooooooo01Oooooo00Go001ooooooooooooo0000ooooo`09o`0003_o
oooo00?o0000ooooooooool02oooool001cooooo00?o0000ooooooooool03Oooool00ol0003ooooo
ooooo`0Hooooo`04o`000?ooooooooooooooo`;o00001?ooool00ol0003oooooooooo`0Cooooo`03
o`00Oooooooooooo00gooooo1Ol00007ooooo`03o`000?oooooooooo00Kooooo00?o0000oooooooo
ool04oooool00ol0003oooooooooo`08ooooo`04o`00Oooooooooooooooooa3o00001?ooool3o`00
00?ooooo00?o0000ooooool000001_l0000<ooooo`03o`000?oooooooooo013ooooo00?o001ooooo
ooooool0:Oooool00ol0003oooooooooo`0Gooooo`04o`00Oooooooo0000ooooo`[o0000??ooool0
0ol0003oooooooooo`0:ooooo`007?ooool00ol0003oooooooooo`0=ooooo`03o`000?oooooooooo
01Sooooo00?o0000ooooooooool00ol0000Jooooo`03o`00Oooooooooooo00cooooo1ol00005oooo
o`?o00000_ooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo00oooooo00?o0000oooo
ooooool02?ooool00ol007ooooooooooo`03ooooo`oo00000_ooool4o`0000Cooooo2?l0000<oooo
o`03o`000?oooooooooo013ooooo00?o001oooooooooool0:Oooool00ol0003oooooooooo`0Goooo
o`03o`00Oooooooo000000_o0000??ooool00ol0003oooooooooo`0:ooooo`007?ooool00ol0003o
ooooooooo`0<ooooo`03o`000?oooooooooo01Wooooo00?o0000ooooool000001?l0000Eooooo`05
o`000?ooooooooooooooool007l03Oooool8o`0000?ooooo2Ol00007ooooo`;o00003oooool00ol0
003oooooooooo`09ooooo`03o`00Oooooooooooo00Cooooo00?o0000ooooool000002ol000000ooo
oooo0000o`000004o`0000Cooooo1ol0000<ooooo`03o`000?oooooooooo013ooooo00?o001ooooo
ooooool0:_ooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00oooooo00Co001ooooo
ool0003ooooo2Ol00009ooooo`03o`000?oooooooooo037ooooo00?o0000ooooooooool02_ooool0
01cooooo00?o0000ooooooooool03?ooool01?l0003oooooooooool0000Jooooo`Ko00005?ooool0
1Ol0003ooooooooooooooooo001o00kooooo2?l000000ooooooo0000o`000008o`0000Oooooo0ol0
000>ooooo`03o`000?oooooooooo00Wooooo00?o001oooooooooool01ooooolBo`0000Gooooo1Ol0
000=ooooo`03o`000?oooooooooo013ooooo00?o001oooooooooool0:Oooool3o`0000;ooooo00?o
0000ooooool000000_l0000@ooooo`03o`00Oooooooooooo00;ooooo1ol0000:ooooo`03o`000?oo
oooooooo03kooooo000Looooo`03o`000?oooooooooo00cooooo00Co0000oooooooooooo00006Ooo
ool7o`0001Cooooo00Go0000ooooooooooooooooo`00O`0?oooooa?o00001Oooool5o`0000gooooo
00?o0000ooooooooool02Oooool00ol007ooooooooooo`08ooooo`03o`000?oooooo000000Ko0000
0_ooool6o`0000Kooooo0ol0000>ooooo`03o`000?oooooooooo013ooooo00?o001oooooooooool0
:?ooool<o`0000oooooo00?o001oooooooooool00oooool3o`000003ooooool0003ooooo00[ooooo
00?o0000ooooooooool0?_ooool001cooooo00?o0000ooooooooool03oooool00ol0003ooooooooo
o`0Hooooo`Ko00000oooool00ol0003oooooooooo`0>ooooo`05o`000?ooooooooooooooool007l0
4?oooolBo`0000;ooooo00?o0000ooooool000001_l0000Hooooo`03o`00Oooooooooooo00_ooooo
00?o0000ooooooooool00ol00003ooooo`Co00000_ooool00ol0003oooooooooo`03ooooo`03o`00
0?oooooooooo023ooooo00?o001oooooooooool0:?ooool=o`0000kooooo00?o001oooooooooool0
1?ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool0
?_ooool001cooooo00?o0000ooooooooool03oooool00ol0003oooooooooo`0Iooooo`Co00000ooo
ool3o`0000oooooo00Go0000ooooooooooooooooo`00O`0Aoooooa7o00000_ooool9o`0001Sooooo
00?o001oooooooooool03oooool00ol0003oooooo`000002ooooo`?o00000oooool00ol0003ooooo
ooooo`0Vooooo`03o`00Oooooooooooo02Oooooo3_l0000>ooooo`03o`00Oooooooooooo00Wooooo
00?o0000ooooooooool01oooool00ol0003oooooooooo`0nooooo`007?ooool00ol0003ooooooooo
o`0?ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool04Oooool00ol0003ooooooooo
o`03o`0000?ooooo1Ol0000>ooooo`05o`000?ooooooooooooooool007l04_ooool?o`0000?ooooo
00?o0000ooooool000001_l0000Hooooo`03o`00Oooooooooooo017ooooo0ol00002ooooo`;o0000
0_ooool00ol0003oooooooooo`0Vooooo`03o`00Oooooooooooo02Sooooo3Ol0000>ooooo`03o`00
Oooooooo000000[ooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`0aooooo`03o`00
0?oooooooooo00[ooooo000Looooo`03o`000?oooooooooo00oooooo00Co0000oooooooooooooooo
0ol0000Booooo`05o`000?ooooooooooooooool000001?ooool6o`00017ooooo00?o001ooooooooo
ool04Oooool9o`0000;ooooo0ol00002ooooo`04o`000?ooooooooooooooo`Go00006Oooool00ol0
07ooooooooooo`0Aooooo`?o00000oooool01?l0003oooooooooool0000Xooooo`03o`00Oooooooo
oooo02Wooooo2ol0000?ooooo`03o`00Oooooooo000000[ooooo0_l0000kooooo`03o`000?oooooo
oooo00[ooooo000Looooo`03o`000?oooooooooo00cooooo00?o0000ooooooooool00oooool5o`00
017ooooo00?o0000ooooooooool01Oooool7o`00017ooooo00?o001oooooooooool04Oooool3o`00
0004ooooool0003o0000o`0000Gooooo00Go0000ooooooooooooooooo`000004ooooo`?o00003_oo
ool00ol0003oooooooooo`09ooooo`03o`00Oooooooooooo013ooooo1Ol00002ooooo`04o`000?oo
ooooooooo`0000Oooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`0@ooooo`03o`00
Oooooooooooo02Wooooo2_l0000@ooooo`03o`00Oooooooo000000[ooooo0ol0000jooooo`03o`00
0?oooooooooo00[ooooo000Looooo`?o00003?ooool00ol0003oooooooooo`02ooooo`Oo00004?oo
ool00ol0003oooooooooo`06ooooo`Ko00004Oooool00ol007ooooooooooo`0Booooo`05o`000?oo
ooooooooooooool000002_ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00gooooo
00?o0000ooooooooool02Oooool00ol007ooooooooooo`0?ooooo`Oo00000_ooool00ol0003ooooo
o`000007ooooo`03o`000?oooooo000000_ooooo00?o0000ooooooooool04?ooool00ol007oooooo
ooooo`0Zooooo`03o`000?oooooooooo00?o000000?oooooo`000?ooool04?ooool00ol007oo0000
ooooo`09ooooo`Go0000>Oooool00ol0003oooooooooo`0:ooooo`007?ooool00ol0003ooooooooo
o`0<ooooo`04o`000?ooooooooooooooo`So00004?ooool00ol0003oooooooooo`07ooooo`Co0000
4_ooool00ol007ooooooooooo`0Xooooo`03o`000?oooooooooo00cooooo00?o0000ooooooooool0
2Oooool00ol007ooooooooooo`0>ooooo`So00000_ooool00ol0003oooooooooo`08ooooo`?o0000
2_ooool00ol0003oooooooooo`0@ooooo`03o`00Oooooooooooo02kooooo00?o0000ooooooooool0
0oooool2o`0000gooooo00?o001oo`000?ooool02?ooool7o`0003Sooooo00?o0000ooooooooool0
2_ooool001cooooo00?o0000ooooooooool03?ooool00ol0003oooooooooo`02ooooo`Oo00004?oo
ool00ol0003oooooooooo`07ooooo`?o00003oooool01Ol0003ooooooooooooooooo001o02[ooooo
00?o0000ooooooooool03?ooool00ol0003oooooooooo`09ooooo`03o`00Oooooooooooo00oooooo
1ol00002ooooo`03o`000?oooooooooo00Oooooo1?l00009ooooo`03o`000?oooooooooo017ooooo
00?o001oooooooooool0=?ooool3o`0000cooooo00?o001oo`000?ooool01oooool8o`0000Cooooo
00?o0000ooooooooool0<Oooool00ol0003oooooooooo`0:ooooo`007?ooool00ol0003ooooooooo
o`0<ooooo`06o`000?ooooooooooooooool0003ooooo1Ol0000Looooo`03o`000?oooooooooo00ko
oooo00Go0000ooooooooooooooooo`00O`0Qooooo`03o`000?oooooooooo00Kooooo00?o0000oooo
ooooool03?ooool00ol0003oooooooooo`09ooooo`03o`00Oooooooooooo013ooooo1Ol0000<oooo
o`Ko00002?ooool00ol0003oooooooooo`0Aooooo`03o`00Oooooooooooo03?ooooo1Ol0000;oooo
o`03o`00Oooooooooooo00Sooooo1ol00004ooooo`03o`000?oooooooooo03kooooo000Looooo`03
o`000?oooooooooo00cooooo00Go0000ooooooooooooooooo`000002ooooo`?o0000;_ooool01Ol0
003ooooooooooooooooo001o027ooooo00?o0000ooooool000001oooool00ol0003oooooooooo`0;
ooooo`03o`000?oooooooooo00Wooooo00?o001oooooooooool04Oooool3o`0000Gooooo00?o0000
ooooooooool01?ooool8o`0000Oooooo00?o0000ooooooooool04Oooool00ol007ooooooooooo`0b
ooooo`Oo00000oooool00ol0003oooooooooo`04ooooo`03o`00Oooooooooooo00Wooooo1Ol00005
ooooo`03o`000?oooooooooo03kooooo000Looooo`03o`000?oooooooooo013ooooo00?o0000oooo
ooooool00ol0000Nooooo`03o`000?oooooooooo00cooooo00?o0000ooooooooool00_ooool00ol0
07ooooooooooo`0Oooooo`03o`000?oooooo000000Oooooo00?o0000ooooooooool05oooool00ol0
07ooooooooooo`0Booooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool01Oooool8o`00
01[ooooo00?o001oooooooooool0<Oooool8o`0000;ooooo0ol00005ooooo`03o`00Oooooooooooo
00[ooooo0ol00006ooooo`03o`000?oooooooooo03kooooo000Looooo`03o`000?oooooooooo013o
oooo00?o0000ooooool000008Oooool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo00;o
oooo00?o001oooooooooool08?ooool2o`0000Oooooo00?o0000ooooooooool05oooool00ol007oo
ooooooooo`0Hooooo`?o00001oooool8o`0001Wooooo00?o001oooooooooool0<_ooool>o`0000?o
oooo00?o001oooooooooool02oooool2o`0000Kooooo00?o0000ooooooooool0?_ooool001cooooo
00?o0000ooooooooool04?ooool00ol0003oooooo`00000Eooooo`03o`000?oooooooooo00Wooooo
00?o0000ooooooooool03?ooool00ol0003oooooooooo`02ooooo`03o`00Oooooooooooo023ooooo
00?o0000ooooooooool08?ooool00ol007ooooooooooo`0Gooooo`Go00001oooool8o`0001Sooooo
00?o001oooooooooool0<oooool>o`0000;ooooo00?o001oo`000?ooool03?ooool00ol0003ooooo
ooooo`04ooooo`03o`000?oooooooooo037ooooo00?o0000ooooooooool02_ooool001cooooo00?o
0000ooooooooool03oooool3o`0001Kooooo00?o0000ooooooooool02_ooool00ol0003ooooooooo
o`0@ooooo`03o`00Oooooooooooo023ooooo00?o0000ooooooooool08?ooool00ol007oooooooooo
o`0Fooooo`Oo00001_ooool8o`0001Sooooo00?o001oooooooooool0=?ooool>o`000003ooooool0
07oo000000kooooo00?o0000ooooooooool0=oooool00ol0003oooooooooo`0:ooooo`007?ooool0
0ol0003oooooooooo`0<ooooo`03o`000?oooooo000000Co00005Oooool00ol0003oooooooooo`0:
ooooo`03o`000?oooooooooo013ooooo00?o001oooooooooool07oooool3o`0001Gooooo00?o0000
ooooooooool02Oooool00ol007ooooooooooo`0Eooooo`So00001oooool7o`0000Cooooo00?o0000
ooooooooool04Oooool00ol007ooooooooooo`0eooooo`ko000000?o001oo`000?ooool03Oooool0
0ol0003oooooooooo`0gooooo`03o`000?oooooooooo00[ooooo000Looooo`?o00003?ooool00ol0
003oooooo`000005o`000003ooooool0003ooooo017ooooo00?o0000ooooooooool02_ooool00ol0
003oooooooooo`0@ooooo`03o`00Oooooooooooo01kooooo1Ol0000Dooooo`03o`000?oooooooooo
00Wooooo00?o001oooooooooool05_ooool7o`0000Sooooo1Ol00005ooooo`03o`000?oooooooooo
017ooooo00?o001oooooooooool0=_ooool=o`000003o`00Ool0003ooooo00gooooo00?o0000oooo
ooooool0>?ooool00ol0003oooooooooo`09ooooo`007?ooool00ol0003oooooooooo`0<ooooo`So
000000?oooooo`000?ooool04Oooool00ol0003oooooooooo`0Mooooo`03o`00Oooooooooooo01go
oooo1ol00006ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02Oooool00ol007oo
ooooooooo`0Gooooo`Go00002_ooool3o`0000Kooooo00?o0000ooooooooool04Oooool00ol007oo
ooooooooo`0gooooo`co000000?o001oo`000?ooool03_ooool00ol0003oooooooooo`0gooooo`03
o`000?oooooooooo00Wooooo000Looooo`03o`000?oooooooooo00cooooo00?o0000ooooool00000
1Ol000000ooooooo0000ooooo`0Aooooo`03o`000?oooooooooo01Sooooo00?o0000ooooooooool0
0_ooool00ol007ooooooooooo`0Looooo`So00001_ooool01Ol0003ooooooooooooooooo000000So
oooo00?o0000ooooooooool02Oooool00ol007ooooooooooo`0Hooooo`?o00003?ooool2o`0000Ko
oooo00?o0000ooooooooool04Oooool00ol007ooooooooooo`0gooooo`?o00000_ooool00ol0003o
ooooo`000003o`000003ooooool007oo000000kooooo0ol00002ooooo`03o`000?oooooooooo03?o
oooo00?o0000ooooooooool02Oooool001cooooo00?o0000ooooooooool03?ooool00ol0003ooooo
ooooo`04o`0000?ooooo00?o0000ooooooooool0:_ooool00ol0003oooooooooo`02ooooo`03o`00
Oooooooooooo01gooooo1ol00006ooooo`;o000000Coooooo`000?l0003o00001oooool00ol0003o
ooooooooo`09ooooo`03o`00Oooooooooooo01Wooooo00?o0000ooooooooool04oooool00ol0003o
ooooooooo`0Aooooo`03o`00Oooooooooooo03Sooooo00?o0000ooooooooool00oooool3o`0000;o
oooo00?o001oooooooooool03?ooool5o`000003ooooool0003ooooo043ooooo000Looooo`03o`00
0?oooooooooo00cooooo00?o0000ooooooooool00ol00004ooooo`03o`000?oooooooooo02[ooooo
00?o0000ooooooooool00_ooool00ol007ooooooooooo`0Nooooo`Go00001oooool7o`0000Kooooo
00?o0000ooooooooool02Oooool00ol007ooooooooooo`0_ooooo`03o`000?oooooooooo017ooooo
00?o001oooooooooool0?oooool2o`0000;ooooo00?o001oooooooooool03?ooool7o`00047ooooo
000Looooo`03o`000?oooooooooo013ooooo00?o0000ooooooooool00oooool00ol0003ooooooooo
o`0Mooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool00_ooool00ol007oooooooooo
o`0Oooooo`?o00001oooool9o`00017ooooo00?o001oooooooooool0@oooool00ol007oooooooooo
o`11ooooo`03o`000?oooooo001o00gooooo2?l00011ooooo`007?ooool00ol0003oooooooooo`0f
ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool00_ooool00ol007ooooooooooo`0P
ooooo`03o`000?oooooooooo00Gooooo2_l0000Aooooo`03o`00Oooooooooooo04?ooooo00?o001o
ooooooooool0@Oooool00ol0003oooooo`00O`0>ooooo`Oo0000@Oooool001cooooo00?o0000oooo
ooooool0:?ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00[ooooo00?o0000oooo
ooooool00_ooool00ol007ooooooooooo`0Wooooo`_o00004Oooool00ol007ooooooooooo`0Yoooo
o`03o`000?oooooooooo01Oooooo00?o001oooooooooool0@Oooool00ol0003oooooo`00000?oooo
o`Co000000?oooooo`000?ooool0=?ooool00ol0003oooooooooo`09ooooo`007?ooool00ol0003o
ooooooooo`0Xooooo`03o`000?oooooooooo00_ooooo00Go0000ooooooooooooooooo`00000=oooo
o`03o`00Oooooooooooo02Sooooo2Ol0000Booooo`03o`00Oooooooooooo02Wooooo00?o0000oooo
ooooool05oooool00ol007ooooooooooo`12ooooo`;o00003oooool3o`0003Sooooo00?o0000oooo
ooooool02Oooool00004ooooool0003o0000o`0000Cooooo0_l00004ooooo`;o00001?ooool2o`00
00Kooooo00?o0000ooooooooool03?ooool00ol0003oooooooooo`0Iooooo`03o`000?oooooooooo
00_ooooo00?o0000ooooooooool00ol0000<ooooo`03o`00Oooooooooooo02Wooooo1ol00007oooo
o`03o`000?oooooooooo00Wooooo00?o001oooooooooool0:Oooool00ol0003oooooo`000003oooo
o`03o`000?oooooooooo017ooooo00?o001oooooooooool0@oooool00ol0003oooooooooo`0>oooo
o`03o`000?oooooo000003Oooooo00?o0000ooooooooool02Oooool000;ooooo00?o0000oooooooo
ool00_ooool01?l0003oooooooooool00002ooooo`04o`000?ooooooooooo`0000;ooooo00Co0000
oooooooooooo00001Oooool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo00Oooooo00?o
0000ooooooooool03oooool00ol0003oooooooooo`0;ooooo`Oo00002oooool00ol007oooooooooo
o`0Zooooo`;o00000_ooool2o`0000Oooooo00?o0000ooooooooool02Oooool00ol007oooooooooo
o`0Zooooo`?o00000_ooool00ol0003oooooooooo`0Aooooo`03o`00Oooooooooooo04;ooooo0ol0
0019ooooo`03o`000?oooooooooo00Wooooo0002ooooo`03o`000?oooooooooo00;ooooo00Co0000
oooooooooooo00000_ooool01?l0003oooooooooool00002ooooo`04o`000?ooooooooooo`0000Go
oooo0ol0000<o`00O`03o`000?l007oo001o00Oo001o00?o0000o`00Ool007l03ol007l00ol0003o
001oo`00O`0;o`00O`So0000>?l007l01Ol0003o001oo`00Ool007oo000000Oo001o00?o0000o`00
Ool007l0=Ol007l4o`0000;o001o00?o0000o`00Ool007l0EOl007l5o`0004So001o00?o0000o`00
Ool007l02Ol007l000;ooooo00?o0000ooooooooool00_ooool01?l0003oooooooooool00002oooo
o`04o`000?ooooooooooo`0000;ooooo00Co0000oooooooooooo00001Oooool00ol0003ooooooooo
o`0<ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool03oooool00ol0003ooooooooo
o`0:ooooo`Wo00001Oooool00ol0003oooooooooo`02ooooo`03o`00Oooooooooooo03Kooooo00?o
0000ooooooooool02_ooool00ol007ooooooooooo`0Xooooo`Ko000000?oooooo`000?ooool04_oo
ool00ol007ooooooooooo`10ooooo`Oo00004Oooool00ol0003oooooooooo`0cooooo`03o`000?oo
oooooooo00Wooooo0002ooooo`03o`000?oooooooooo00;ooooo00Co0000oooooooooooo00000_oo
ool01?l0003oooooooooool00002ooooo`04o`000?ooooooooooo`0000Gooooo00?o0000oooooooo
ool03?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo01[ooooo2_l00005ooooo`03
o`000?oooooooooo00;ooooo00?o001oooooooooool0=_ooool00ol0003oooooooooo`0:ooooo`03
o`00Oooooooooooo02Oooooo1ol000000ooooooo0000ooooo`0Booooo`03o`00Oooooooooooo03oo
oooo2?l0000@ooooo`?o0000@?ooool00003ooooool0003o000000Cooooo00Co0000oooooooooooo
00000_ooool01?l0003oooooooooool00002ooooo`04o`000?ooooooooooo`0000Gooooo00?o0000
ooooooooool03?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo01Wooooo2_l00006
ooooo`03o`000?oooooooooo00;ooooo00?o001oooooooooool0=_ooool00ol0003oooooooooo`0:
ooooo`03o`00Oooooooooooo02Sooooo1_l000000ooooooo0000ooooo`0Booooo`03o`00Oooooooo
oooo043ooooo1ol0000?ooooo`Go0000?oooool000;ooooo00?o0000ooooooooool00oooool2o`00
00Cooooo0_l00004ooooo`;o00001_ooool00ol0003oooooooooo`0Gooooo`03o`000?oooooooooo
01[ooooo2?l00007ooooo`03o`000?oooooooooo00;ooooo00?o001oooooooooool0@oooool00ol0
07ooooooooooo`0Yooooo`Co00005_ooool00ol007ooooooooooo`11ooooo`Go00003oooool7o`00
03kooooo000Looooo`03o`000?oooooooooo03Gooooo1_l00008ooooo`03o`000?oooooooooo00;o
oooo00?o001oooooooooool0<?ooool00ol0003oooooooooo`0@ooooo`03o`00Oooooooooooo02[o
oooo0_l0000Gooooo`03o`00Oooooooooooo04;ooooo0ol0000?ooooo`So0000?_ooool001cooooo
00?o0000ooooooooool0:?ooool00ol0003oooooooooo`0;ooooo`?o00002_ooool00ol0003ooooo
ooooo`02ooooo`03o`00Oooooooooooo033ooooo00?o0000ooooooooool04?ooool00ol007oooooo
ooooo`0[ooooo`03o`000?oooooooooo01Gooooo00?o001oooooooooool0@oooool00ol0003ooooo
ooooo`0?ooooo`Oo0000<_ooool00ol0003oooooooooo`09ooooo`007?ooool00ol0003ooooooooo
o`0Gooooo`03o`000?oooooooooo00kooooo00?o0000ooooooooool03?ooool00ol0003ooooooooo
o`0>ooooo`03o`00Oooooooooooo033ooooo00?o0000ooooooooool04?ooool00ol007oooooooooo
o`0[ooooo`03o`000?oooooooooo01Gooooo00?o001oooooooooool0@oooool00ol007oooooooooo
o`0@ooooo`Go0000<oooool00ol0003oooooooooo`09ooooo`007?ooool00ol0003oooooooooo`0<
ooooo`03o`000?oooooooooo00Oooooo0ol0000?ooooo`03o`000?oooooooooo01gooooo00?o001o
ooooooooool0<Oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00[ooooo00?o001o
ooooooooool0:oooool01?l0003oooooooooool0000Dooooo`03o`00Oooooooooooo04?ooooo00?o
001oooooooooool04Oooool3o`0003Cooooo00?o0000ooooooooool02Oooool001cooooo00?o0000
ooooooooool03?ooool00ol0003oooooooooo`06ooooo`Go00003_ooool00ol0003oooooooooo`0@
ooooo`03o`000?oooooooooo00[ooooo00?o001oooooooooool0<Oooool00ol0003oooooooooo`02
ooooo`03o`000?oooooooooo00[ooooo00?o001oooooooooool0;?ooool00ol0003oooooo`00000D
ooooo`03o`00Oooooooooooo04?ooooo00?o001oooooooooool04_ooool00ol0003oooooooooo`0d
ooooo`03o`000?oooooooooo00Sooooo000Looooo`03o`000?oooooooooo00cooooo00?o0000oooo
ooooool01_ooool6o`0000gooooo00?o0000ooooooooool04?ooool00ol0003oooooooooo`0:oooo
o`03o`00Oooooooooooo037ooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`0:oooo
o`03o`00Oooooooooooo02cooooo00?o0000ooooool000005?ooool00ol007ooooooooooo`13oooo
o`03o`00Oooooooooooo04Wooooo00?o0000ooooooooool02?ooool001cooooo0ol0000<ooooo`03
o`000?oooooooooo00Gooooo1ol0000=ooooo`03o`000?oooooooooo013ooooo00?o0000oooooooo
ool01Oooool00ol0003oooooooooo`02ooooo`03o`00Oooooooooooo03Kooooo00?o0000oooooooo
ool02_ooool00ol007ooooooooooo`0/ooooo`03o`000?oooooo000001Cooooo00?o001ooooooooo
ool0@oooool00ol007ooooooooooo`19ooooo`03o`000?oooooooooo00Sooooo000Looooo`03o`00
0?oooooooooo00cooooo00?o0000ooooooooool01_ooool6o`00027ooooo00?o0000ooooooooool0
1?ooool00ol0003oooooooooo`02ooooo`03o`00Oooooooooooo03Kooooo00?o0000ooooooooool0
2_ooool00ol007ooooooooooo`0^ooooo`03o`000?oooooooooo01;ooooo00?o001oooooooooool0
@oooool00ol007ooooooooooo`1Dooooo`007?ooool00ol0003oooooooooo`0<ooooo`03o`000?oo
oooooooo00Oooooo1?l0000Rooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool00_oo
ool00ol007ooooooooooo`0booooo`05o`000?ooooooooooooooool000003?ooool00ol007oooooo
ooooo`0^ooooo`03o`000?oooooooooo01;ooooo00?o001oooooooooool0@oooool00ol007oooooo
ooooo`1Dooooo`007?ooool00ol0003oooooooooo`0Fooooo`?o00008oooool00ol0003ooooooooo
o`04ooooo`03o`000?oooooooooo00;ooooo00?o001oooooooooool0<Oooool3o`0000oooooo00?o
001oooooooooool0@oooool00ol007ooooooooooo`13ooooo`03o`00Oooooooooooo05Cooooo000L
ooooo`03o`000?oooooooooo01Oooooo00?o0000ooooooooool0:Oooool00ol0003oooooooooo`02
ooooo`03o`00Oooooooooooo033ooooo1?l0000?ooooo`03o`00Oooooooooooo02gooooo00?o0000
ooooooooool04oooool00ol007ooooooooooo`13ooooo`03o`00Oooooooooooo05Cooooo000Loooo
o`03o`000?oooooooooo02Oooooo00?o0000ooooooooool06Oooool00ol0003oooooooooo`02oooo
o`03o`00Oooooooooooo02oooooo1_l0000>ooooo`03o`00Oooooooooooo02gooooo0_l0000Doooo
o`03o`00Oooooooooooo04?ooooo00?o001oooooooooool0BOooool00ol0003oooooooooo`08oooo
o`007?ooool00ol0003oooooooooo`0Wooooo`03o`000?oooooooooo01kooooo00?o001ooooooooo
ool0;_ooool7o`0000kooooo00?o001oooooooooool0;Oooool3o`0001?ooooo00?o001ooooooooo
ool0@oooool00ol007ooooooooooo`19ooooo`03o`000?oooooooooo00Sooooo000Looooo`03o`00
0?oooooooooo00cooooo00?o0000ooooooooool06?ooool00ol0003oooooooooo`0Nooooo`03o`00
Oooooooooooo02oooooo1_l000000ooooooo0000ooooo`0;ooooo`03o`00Oooooooooooo02cooooo
1Ol0000Booooo`03o`00Oooooooooooo04?ooooo00?o001oooooooooool0BOooool00ol0003ooooo
ooooo`08ooooo`007?ooool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo00[ooooo00?o
0000ooooooooool02oooool00ol0003oooooooooo`0Cooooo`03o`000?oooooooooo00Sooooo00?o
001oooooooooool0<?ooool4o`0000;ooooo00?o0000ooooooooool02_ooool00ol007oooooooooo
o`0[ooooo`Oo00004Oooool00ol007ooooooooooo`13ooooo`03o`00Oooooooooooo04Wooooo00?o
0000ooooooooool02?ooool001cooooo00?o0000ooooooooool03?ooool00ol0003oooooooooo`0:
ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool04oooool00ol0003oooooooooo`08
ooooo`03o`00Oooooooooooo037ooooo0_l00003ooooo`03o`000?oooooooooo00[ooooo00?o001o
ooooooooool0:_ooool8o`00017ooooo00?o001oooooooooool0@oooool00ol007ooooooooooo`19
ooooo`03o`000?oooooooooo00Sooooo000Looooo`03o`000?oooooooooo00cooooo00?o0000oooo
ooooool02_ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo01?ooooo00?o0000oooo
ooooool00_ooool00ol0003oooooooooo`03ooooo`03o`00Oooooooooooo03;ooooo00Go0000oooo
ooooooooooooo`00000<ooooo`03o`00Oooooooooooo02_ooooo1ol0000Aooooo`03o`00Oooooooo
oooo04?ooooo00?o001oooooooooool0BOooool00ol0003oooooooooo`08ooooo`007?ooool3o`00
00cooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0Qooooo`03o`000?oooooooooo
00;ooooo00?o0000ooooooooool00oooool00ol007ooooooooooo`0fooooo`03o`000?oooooooooo
00[ooooo00?o001oooooooooool0;?ooool5o`0001;ooooo00?o001oooooooooool0@oooool00ol0
07ooooooooooo`1Dooooo`007?ooool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo00[o
oooo00?o0000ooooooooool08Oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00?o
oooo00?o001oooooooooool0=_ooool00ol0003oooooooooo`0:ooooo`03o`00Oooooooooooo02go
oooo0ol0000Cooooo`03o`00Oooooooooooo04?ooooo00?o001oooooooooool0E?ooool001cooooo
00?o0000ooooooooool06Oooool00ol0003oooooooooo`0Qooooo`03o`000?oooooooooo00;ooooo
00?o0000ooooooooool00oooool00ol007ooooooooooo`13ooooo`03o`00Oooooooooooo02kooooo
00?o0000ooooooooool04_ooool00ol007ooooooooooo`13ooooo`03o`00Oooooooooooo05Cooooo
000Looooo`03o`000?oooooooooo03kooooo00Go0000ooooooooooooooooo`000005ooooo`03o`00
Oooooooooooo03?ooooo00?o0000ooooooooool03Oooool00ol007ooooooooooo`13ooooo`03o`00
Oooooooooooo04?ooooo00?o001oooooooooool0E?ooool001cooooo00?o0000ooooooooool09ooo
ool00ol0003oooooooooo`0Cooooo`?o00000_ooool00ol0003oooooooooo`03ooooo`03o`00Oooo
oooooooo03?ooooo00?o0000ooooooooool03Oooool00ol007ooooooooooo`13ooooo`03o`00Oooo
oooooooo04?ooooo00?o001oooooooooool0BOooool00ol0003oooooooooo`08ooooo`007?ooool0
0ol0003oooooooooo`0Wooooo`03o`000?oooooooooo01;ooooo1Ol00007ooooo`03o`00Oooooooo
oooo03?ooooo00?o0000ooooooooool03Oooool00ol007ooooooooooo`13ooooo`03o`00Oooooooo
oooo04?ooooo00?o001oooooooooool0BOooool00ol0003oooooooooo`08ooooo`007?ooool00ol0
003oooooooooo`0<ooooo`03o`000?oooooooooo01Sooooo00?o0000ooooooooool04Oooool7o`00
00Kooooo00?o001oooooooooool0=?ooool00ol0003oooooo`00000<ooooo`03o`00Oooooooooooo
04?ooooo00?o001oooooooooool0@oooool00ol007ooooooooooo`19ooooo`;o00002Oooool001co
oooo00?o0000ooooooooool03?ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00[o
oooo00?o0000ooooooooool04?ooool8o`0000Kooooo00?o001oooooooooool0=?ooool00ol0003o
ooooo`00000<ooooo`03o`00Oooooooooooo04?ooooo00?o001oooooooooool0@oooool00ol007oo
ooooooooo`19ooooo`?o00002?ooool001cooooo00?o0000ooooooooool03?ooool00ol0003ooooo
ooooo`0;ooooo`;o00002oooool00ol0003oooooooooo`0Aooooo`Oo00001_ooool00ol007oooooo
ooooo`0dooooo`03o`000?oooooo000000cooooo00?o001oooooooooool0@oooool00ol007oooooo
ooooo`13ooooo`03o`00Oooooooooooo04Sooooo1?l00008ooooo`007?ooool00ol0003ooooooooo
o`06ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool03?ooool3o`0000[ooooo00?o
0000ooooooooool04_ooool5o`000003ooooool0003ooooo00Cooooo00?o001oooooooooool0=Ooo
ool00ol0003oooooooooo`0;ooooo`03o`00Oooooooooooo04?ooooo00?o001oooooooooool0@ooo
ool00ol007ooooooooooo`17ooooo`Ko00001oooool001cooooo00?o0000ooooooooool01Oooool3
o`0000?ooooo00?o0000ooooooooool02oooool6o`0001kooooo0ol00002ooooo`03o`000?oooooo
oooo00?ooooo00?o001oooooooooool0=Oooool00ol0003oooooooooo`0;ooooo`03o`00Oooooooo
oooo04?ooooo00?o001oooooooooool0@oooool00ol007ooooooooooo`16ooooo`Oo00001oooool0
01cooooo0ol00004ooooo`Go00000_ooool00ol0003oooooooooo`0:ooooo`So00007_ooool2o`00
00;ooooo00?o0000ooooooooool00oooool00ol007ooooooooooo`0eooooo`03o`000?oooooooooo
00_ooooo00?o001oooooooooool0@oooool00ol007ooooooooooo`13ooooo`03o`00Oooooooooooo
04Oooooo1_l00007ooooo`007?ooool00ol0003oooooooooo`03ooooo`Oo00003Oooool:o`0001ko
oooo00Co0000oooooooooooo00001Oooool00ol007ooooooooooo`13ooooo`03o`00Oooooooooooo
04?ooooo00?o001oooooooooool0@oooool00ol007ooooooooooo`18ooooo`Co00002?ooool001co
oooo00?o0000ooooooooool00_ooool8o`0000kooooo2_l0000Pooooo`03o`000?oooooooooo00?o
oooo00?o001oooooooooool0=Oooool00ol0003oooooooooo`0;ooooo`03o`00Oooooooooooo04?o
oooo00?o001oooooooooool0@oooool00ol007ooooooooooo`19ooooo`;o00002Oooool001cooooo
00?o0000ooooooooool00oooool7o`0000oooooo2Ol00005ooooo`03o`000?oooooooooo01Sooooo
00?o0000ooooooooool00oooool00ol007ooooooooooo`0eooooo`03o`000?oooooooooo00_ooooo
00?o001oooooooooool0@oooool00ol007ooooooooooo`13ooooo`03o`00Oooooooooooo04[ooooo
00?o0000ooooooooool01oooool001cooooo00?o0000ooooooooool01?ooool5o`00017ooooo2?l0
0005ooooo`03o`000?oooooooooo01kooooo00?o001oooooooooool0=?ooool3o`0000cooooo00?o
001oooooooooool0@oooool00ol007ooooooooooo`13ooooo`03o`00Oooooooooooo05Cooooo000L
ooooo`03o`000?oooooooooo00Gooooo0ol00003ooooo`03o`000?oooooooooo00gooooo00?o0000
ooooool000000ol00006ooooo`03o`000?oooooooooo01kooooo00?o001oooooooooool0<oooool5
o`0000_ooooo00?o001oooooooooool0@oooool00ol007ooooooooooo`13ooooo`03o`00Oooooooo
oooo05Cooooo000Looooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool00_ooool00ol0
003oooooooooo`0?ooooo`?o00001oooool00ol0003oooooooooo`0Eooooo`03o`000?oooooooooo
00Kooooo00?o001oooooooooool0<_ooool7o`0000[ooooo00?o001oooooooooool0@oooool00ol0
07ooooooooooo`13ooooo`03o`00Oooooooooooo05Cooooo000Looooo`03o`000?oooooooooo00Ko
oooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`0@ooooo`;o00001oooool00ol0003o
ooooooooo`0Eooooo`03o`000?oooooooooo00Kooooo00?o001oooooooooool0<Oooool8o`0000[o
oooo00?o001oooooooooool0@oooool00ol007ooooooooooo`13ooooo`03o`00Oooooooooooo05Co
oooo000Looooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool00_ooool00ol0003ooooo
ooooo`0Aooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool05Oooool01?l0003ooooo
ooooool00005ooooo`03o`00Oooooooooooo03;ooooo1ol0000:ooooo`03o`00Oooooooooooo04?o
oooo00?o001oooooooooool0@oooool00ol007ooooooooooo`1Dooooo`007?ooool00ol0003ooooo
ooooo`06ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool04Oooool00ol0003ooooo
ooooo`0Nooooo`03o`000?oooooo000000Gooooo00?o001oooooooooool0<oooool5o`0000_ooooo
00?o001oooooooooool0@oooool00ol007ooooooooooo`13ooooo`03o`00Oooooooooooo05Cooooo
000Looooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool00_ooool00ol0003ooooooooo
o`0booooo`03o`000?oooooo000000Gooooo00?o001oooooooooool0=?ooool3o`0000cooooo00?o
001oooooooooool0@oooool00ol007ooooooooooo`13ooooo`03o`00Oooooooooooo05Cooooo000L
ooooo`?o0000@?ooool00ol0003oooooo`000005ooooo`03o`00Oooooooooooo03Gooooo00?o0000
ooooooooool02oooool00ol007ooooooooooo`13ooooo`03o`00Oooooooooooo04?ooooo00?o001o
ooooooooool0E?ooool001cooooo00?o0000ooooooooool0@_ooool00ol0003oooooooooo`03oooo
o`03o`00Oooooooooooo04?ooooo00?o001oooooooooool0@oooool00ol007ooooooooooo`13oooo
o`03o`00Oooooooooooo05Cooooo000Looooo`03o`000?oooooooooo01oooooo00?o0000oooooooo
ool01Oooool00ol0003oooooooooo`0Hooooo`03o`000?oooooooooo00?ooooo00?o001ooooooooo
ool0@oooool00ol007ooooooooooo`13ooooo`03o`00Oooooooooooo04?ooooo00?o001ooooooooo
ool0E?ooool001cooooo00?o0000ooooooooool07oooool00ol0003oooooooooo`05ooooo`03o`00
0?oooooooooo01kooooo00?o001oooooooooool0@oooool00ol007ooooooooooo`13ooooo`03o`00
Oooooooooooo04?ooooo00?o001oooooooooool0E?ooool001cooooo00?o0000ooooooooool01_oo
ool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool01Ooo
ool00ol0003oooooooooo`0Nooooo`03o`00Oooooooooooo04?ooooo00?o001oooooooooool0@ooo
ool00ol007ooooooooooo`13ooooo`03o`00Oooooooooooo05Cooooo000Looooo`03o`000?oooooo
oooo00Kooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooo
oooo00Cooooo00?o0000ooooooooool05_ooool00ol0003oooooooooo`05ooooo`03o`00Oooooooo
oooo04?ooooo00?o001oooooooooool0@oooool00ol007ooooooooooo`13ooooo`03o`00Oooooooo
oooo05Cooooo000Looooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool00_ooool00ol0
003oooooooooo`0Booooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool05_ooool00ol0
003oooooooooo`05ooooo`03o`00Oooooooooooo04?ooooo00?o001oooooooooool0@oooool00ol0
07ooooooooooo`13ooooo`03o`00Oooooooooooo05Cooooo000Looooo`03o`000?oooooooooo00Ko
oooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo00Co
oooo00?o0000ooooooooool05_ooool00ol0003oooooo`000005ooooo`03o`00Oooooooooooo04?o
oooo00?o001oooooooooool0@oooool00ol007ooooooooooo`13ooooo`03o`00Oooooooooooo05Co
oooo00001?oooooo0000o`000?l00003ooooo`?o00001?ooool2o`0000Cooooo0_l00006ooooo`03
o`000?oooooooooo00Kooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`0cooooo`;o
00001Oooool00ol007ooooooooooo`13ooooo`03o`00Oooooooooooo04?ooooo00?o001ooooooooo
ool0@oooool00ol007ooooooooooo`1Dooooo`000_ooool01Ol0003ooooooooooooooooo000000?o
oooo00Co0000oooooooooooo00000_ooool01?l0003oooooooooool00002ooooo`03o`000?oooooo
oooo00?ooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`02ooooo`03o`000?oooooo
oooo03?ooooo0_l00005ooooo`03o`00Oooooooooooo04?ooooo00?o001oooooooooool0@oooool0
0ol007ooooooooooo`13ooooo`03o`00Oooooooooooo05Cooooo0002ooooo`03o`000?oooooooooo
00Gooooo00Co0000oooooooooooo00000_ooool01?l0003oooooooooool00002ooooo`03o`000?oo
oooooooo00?ooooo00?o0000ooooooooool0@Oooool00ol0003oooooooooo`04ooooo`03o`00Oooo
oooooooo04?ooooo00?o001oooooooooool0@oooool00ol007ooooooooooo`13ooooo`03o`00Oooo
oooooooo05Cooooo0002ooooo`03o`000?oooooooooo00Gooooo00Co0000oooooooooooo00000_oo
ool01?l0003oooooooooool00002ooooo`03o`000?oooooooooo00?ooooo0ol00010o`00O`?o0000
ool007l_o`00O`000_ooool01?l0003oooooooooooooool4o`0000?ooooo00Co0000oooooooooooo
00000_ooool01?l0003oooooooooool00005ooooo`03o`000?oooooooooo023ooooo00?o0000oooo
ooooool01?ooool00ol0003oooooooooo`0Eooooo`Go00001?ooool00ol007ooooooooooo`13oooo
o`03o`00Oooooooooooo04?ooooo00?o001oooooooooool0@oooool00ol007ooooooooooo`1Doooo
o`0000?oooooo`000?l000000oooool00ol0003oooooooooo`04ooooo`04o`000?ooooooooooo`00
00;ooooo00Co0000oooooooooooo00001Oooool00ol0003oooooooooo`0Pooooo`03o`000?oooooo
oooo00Cooooo00?o0000ooooooooool05Oooool6o`0000?ooooo00?o001oooooooooool0@oooool0
0ol007ooooooooooo`13ooooo`03o`00Oooooooooooo04?ooooo00?o001oooooooooool0E?ooool0
00;ooooo00Co0000oooooooooooooooo1Ol00003ooooo`;o00001?ooool2o`0000Kooooo00?o0000
ooooooooool01oooool01Ol0003ooooooooooooooooo000001Cooooo00?o0000ooooooooool01?oo
ool00ol0003oooooooooo`0Dooooo`Oo00000oooool00ol007ooooooooooo`13ooooo`03o`00Oooo
oooooooo04?ooooo00?o001oooooooooool0@oooool00ol007ooooooooooo`1Dooooo`007?ooool0
0ol0003oooooooooo`07ooooo`05o`000?ooooooooooooooool000005Oooool00ol0003ooooooooo
o`03ooooo`03o`000?oooooooooo01Gooooo1_l00003ooooo`03o`00Oooooooooooo04?ooooo00?o
001oooooooooool0@oooool00ol007ooooooooooo`13ooooo`03o`00Oooooooooooo05Cooooo000L
ooooo`03o`000?oooooooooo00Oooooo00Go0000ooooooooooooooooo`00000Eooooo`03o`000?oo
oooooooo00?ooooo00?o0000ooooooooool05_ooool4o`0000Cooooo00?o001oooooooooool0@ooo
ool00ol007ooooooooooo`13ooooo`03o`00Oooooooooooo04?ooooo00?o001oooooooooool0E?oo
ool001cooooo00?o0000ooooooooool01oooool01Ol0003ooooooooooooooooo000001Gooooo00?o
0000ooooooooool00oooool00ol0003oooooooooo`0Fooooo`?o00001Oooool00ol007oooooooooo
o`13ooooo`03o`00Oooooooooooo04?ooooo00?o001oooooooooool0@oooool00ol007oooooooooo
o`1Dooooo`007?ooool00ol0003oooooooooo`07ooooo`05o`000?ooooooooooooooool00000=Ooo
ool00ol0003oooooooooo`04ooooo`03o`00Oooooooooooo04?ooooo00?o001oooooooooool0@ooo
ool00ol007ooooooooooo`13ooooo`03o`00Oooooooooooo05Cooooo000Looooo`03o`000?oooooo
oooo00Oooooo00Go0000ooooooooooooooooo`00000looooo`03o`00Oooooooooooo04?ooooo00?o
001oooooooooool0@oooool00ol007ooooooooooo`13ooooo`03o`00Oooooooooooo05Cooooo000L
ooooo`03o`000?oooooooooo04Sooooo00?o001oooooooooool0@oooool00ol007ooooooooooo`13
ooooo`03o`00Oooooooooooo04?ooooo00?o001oooooooooool0E?ooool001cooooo00?o0000oooo
ooooool0B?ooool00ol007ooooooooooo`13ooooo`03o`00Oooooooooooo04?ooooo00?o001ooooo
ooooool0@oooool00ol007ooooooooooo`1Dooooo`007?ooool3o`00027ooooo00?o0000oooooooo
ool00_ooool00ol0003oooooooooo`0Oooooo`03o`00Oooooooooooo04?ooooo00?o001ooooooooo
ool0@oooool00ol007ooooooooooo`13ooooo`03o`00Oooooooooooo05Cooooo000Looooo`03o`00
0?oooooooooo027ooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`0Oooooo`03o`00
Oooooooooooo04?ooooo00?o001oooooooooool0@oooool00ol007ooooooooooo`13ooooo`03o`00
Oooooooooooo05Cooooo000Looooo`03o`000?oooooooooo00Oooooo00Go0000oooooooooooooooo
o`00000Eooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool07oooool00ol007oooooo
ooooo`13ooooo`03o`00Oooooooooooo04?ooooo00?o001oooooooooool0@oooool00ol007oooooo
ooooo`1Dooooo`007?ooool00ol0003oooooooooo`07ooooo`05o`000?ooooooooooooooool00000
5_ooool01Ol0003ooooooooooooooooo0000027ooooo00?o001oooooooooool0@oooool00ol007oo
ooooooooo`13ooooo`03o`00Oooooooooooo04?ooooo00?o001oooooooooool0E?ooool001cooooo
00?o0000ooooooooool01oooool01Ol0003ooooooooooooooooo000001Kooooo00Go0000oooooooo
ooooooooo`00000Qooooo`03o`00Oooooooooooo04?ooooo00?o001oooooooooool0@oooool00ol0
07ooooooooooo`13ooooo`03o`00Oooooooooooo05Cooooo000Looooo`03o`000?oooooooooo00Oo
oooo00Go0000ooooooooooooooooo`00000Fooooo`05o`000?ooooooooooooooool000008Oooool0
0ol007ooooooooooo`13ooooo`03o`00Oooooooooooo04?ooooo00?o001oooooooooool0@oooool0
0ol007ooooooooooo`1Dooooo`007?ooool00ol0003oooooooooo`07ooooo`05o`000?oooooooooo
ooooool000005_ooool00ol0003oooooooooo`0Sooooo`03o`00Oooooooooooo04?ooooo00?o001o
ooooooooool0@oooool00ol007ooooooooooo`13ooooo`03o`00Oooooooooooo05Cooooo000Loooo
o`03o`000?oooooooooo00Oooooo00Go0000ooooooooooooooooo`00000Eooooo`?o00009?ooool0
0ol007ooooooooooo`13ooooo`03o`00Oooooooooooo04?ooooo00?o001oooooooooool0@oooool0
0ol007ooooooooooo`1Dooooo`007?ooool00ol0003oooooooooo`0Pooooo`Go00008oooool00ol0
07ooooooooooo`13ooooo`03o`00Oooooooooooo04?ooooo00?o001oooooooooool0@oooool00ol0
07ooooooooooo`1Dooooo`007?ooool00ol0003oooooooooo`0Oooooo`Oo00008_ooool00ol007oo
ooooooooo`13ooooo`03o`00Oooooooooooo04?ooooo00?o001oooooooooool0@oooool00ol007oo
ooooooooo`1Dooooo`007?ooool00ol0003oooooooooo`0Nooooo`Wo00008Oooool00ol007oooooo
ooooo`13ooooo`03o`00Oooooooooooo04?ooooo00?o001oooooooooool0@oooool00ol007oooooo
ooooo`1Dooooo`007?ooool3o`0001oooooo2?l0000Qooooo`03o`00Oooooooooooo04?ooooo00?o
001oooooooooool0@oooool00ol007ooooooooooo`13ooooo`03o`00Oooooooooooo05Cooooo000L
ooooo`03o`000?oooooooooo00Oooooo00Go0000ooooooooooooooooo`00000Dooooo`Go000000?o
ooooo`000?ooool08?ooool00ol007ooooooooooo`13ooooo`03o`00Oooooooooooo04?ooooo00?o
001oooooooooool0@oooool00ol007ooooooooooo`1Dooooo`007?ooool00ol0003oooooooooo`07
ooooo`05o`000?ooooooooooooooool000005Oooool3o`0000;ooooo00?o0000ooooooooool07ooo
ool00ol007ooooooooooo`13ooooo`03o`00Oooooooooooo04?ooooo00?o001oooooooooool0@ooo
ool00ol007ooooooooooo`1Dooooo`007?ooool00ol0003oooooooooo`07ooooo`05o`000?oooooo
ooooooooool000005_ooool01Ol0003ooooooooooooooooo0000027ooooo00?o001oooooooooool0
@oooool00ol007ooooooooooo`13ooooo`03o`00Oooooooooooo04?ooooo00?o001oooooooooool0
E?ooool001cooooo00?o0000ooooooooool01oooool01Ol0003ooooooooooooooooo000001Kooooo
00Go0000ooooooooooooooooo`00000Qooooo`03o`00Oooooooooooo04?ooooo00?o001ooooooooo
ool0@oooool00ol007ooooooooooo`13ooooo`03o`00Oooooooooooo05Cooooo000Looooo`03o`00
0?oooooooooo00Oooooo00Go0000ooooooooooooooooo`00000looooo`03o`00Oooooooooooo04?o
oooo00?o001oooooooooool0@oooool00ol007ooooooooooo`13ooooo`03o`00Oooooooooooo05Co
oooo000Looooo`03o`000?oooooooooo00Oooooo00Go0000ooooooooooooooooo`00000looooo`03
o`00Oooooooooooo04?ooooo00?o001oooooooooool0@oooool00ol007ooooooooooo`13ooooo`03
o`00Oooooooooooo05Cooooo000Looooo`03o`000?oooooooooo04Sooooo00?o001oooooooooool0
@oooool00ol007ooooooooooo`13ooooo`03o`00Oooooooooooo04?ooooo00?o001oooooooooool0
E?ooool001cooooo00?o0000ooooooooool0B?ooool00ol007ooooooooooo`13ooooo`03o`00Oooo
oooooooo04?ooooo00?o001oooooooooool0@oooool00ol007ooooooooooo`1Dooooo`007?ooool0
0ol0003oooooooooo`0Sooooo`04o`000?ooooooooooo`00027ooooo00?o001oooooooooool0@ooo
ool00ol007ooooooooooo`13ooooo`03o`00Oooooooooooo04?ooooo00?o001oooooooooool0E?oo
ool001cooooo00?o0000ooooooooool08oooool01?l0003oooooooooool0000Qooooo`03o`00Oooo
oooooooo04?ooooo00?o001oooooooooool0@oooool00ol007ooooooooooo`13ooooo`03o`00Oooo
oooooooo05Cooooo000Looooo`?o00002?ooool00ol0003oooooo`00000Hooooo`04o`000?oooooo
ooooo`00027ooooo00?o001oooooooooool0@oooool00ol007ooooooooooo`13ooooo`03o`00Oooo
oooooooo04?ooooo00?o001oooooooooool0E?ooool001cooooo00?o0000ooooooooool02?ooool0
0ol0003oooooo`00000Hooooo`04o`000?ooooooooooo`00027ooooo00?o001oooooooooool0@ooo
ool00ol007ooooooooooo`13ooooo`03o`00Oooooooooooo04?ooooo00?o001oooooooooool0E?oo
ool001cooooo00?o0000ooooooooool02?ooool00ol0003oooooo`00000Hooooo`04o`000?oooooo
ooooo`00027ooooo00?o001oooooooooool0@oooool00ol007ooooooooooo`13ooooo`03o`00Oooo
oooooooo04?ooooo00?o001oooooooooool0E?ooool001cooooo00?o0000ooooooooool02?ooool0
0ol0003oooooo`00000Hooooo`04o`000?ooooooooooo`00027ooooo00?o001oooooooooool0@ooo
ool00ol007ooooooooooo`13ooooo`03o`00Oooooooooooo04?ooooo00?o001oooooooooool0E?oo
ool001cooooo00?o0000ooooooooool02?ooool00ol0003oooooo`00000mooooo`03o`00Oooooooo
oooo04?ooooo00?o001oooooooooool0@oooool00ol007ooooooooooo`13ooooo`03o`00Oooooooo
oooo05Cooooo000Looooo`03o`000?oooooooooo00Sooooo00?o0000ooooool00000?Oooool00ol0
07ooooooooooo`13ooooo`03o`00Oooooooooooo04?ooooo00?o001oooooooooool0@oooool00ol0
07ooooooooooo`1Dooooo`007?ooool00ol0003oooooooooo`18ooooo`03o`00Oooooooooooo04?o
oooo00?o001oooooooooool0@oooool00ol007ooooooooooo`13ooooo`03o`00Oooooooooooo05Co
oooo000Looooo`03o`000?oooooooooo04Sooooo00?o001oooooooooool0@oooool00ol007oooooo
ooooo`13ooooo`03o`00Oooooooooooo04?ooooo00?o001oooooooooool0E?ooool001cooooo00?o
0000ooooooooool09?ooool00ol0003oooooo`00000Qooooo`03o`00Oooooooooooo04?ooooo00?o
001oooooooooool0@oooool00ol007ooooooooooo`13ooooo`03o`00Oooooooooooo05Cooooo000L
ooooo`03o`000?oooooooooo02Cooooo00?o0000ooooool000008Oooool00ol007ooooooooooo`13
ooooo`03o`00Oooooooooooo04?ooooo00?o001oooooooooool0@oooool00ol007ooooooooooo`1D
ooooo`007?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooo000001Wooooo00?o0000oooo
ool000008Oooool00ol007ooooooooooo`13ooooo`03o`00Oooooooooooo04?ooooo00?o001ooooo
ooooool0@oooool00ol007ooooooooooo`1Dooooo`007?ooool3o`0000Sooooo00?o0000ooooool0
00006Oooool00ol0003oooooo`00000Qooooo`03o`00Oooooooooooo04?ooooo00?o001ooooooooo
ool0@oooool00ol007ooooooooooo`13ooooo`03o`00Oooooooooooo05Cooooo000Looooo`03o`00
0?oooooooooo00Sooooo00?o0000ooooool000006Oooool00ol0003oooooo`00000Qooooo`03o`00
Oooooooooooo04?ooooo00?o001oooooooooool0@oooool00ol007ooooooooooo`13ooooo`03o`00
Oooooooooooo05Cooooo000Looooo`03o`000?oooooooooo00Sooooo00?o0000ooooool000006Ooo
ool00ol0003oooooo`00000Qooooo`03o`00Oooooooooooo04?ooooo00?o001oooooooooool0@ooo
ool00ol007ooooooooooo`13ooooo`03o`00Oooooooooooo05Cooooo000Looooo`03o`000?oooooo
oooo00Sooooo00?o0000ooooool00000?Oooool00ol007ooooooooooo`13ooooo`03o`00Oooooooo
oooo04?ooooo00?o001oooooooooool0@oooool00ol007ooooooooooo`1Dooooo`007?ooool00ol0
003oooooooooo`08ooooo`03o`000?oooooo000003gooooo00?o001oooooooooool0@oooool00ol0
07ooooooooooo`13ooooo`03o`00Oooooooooooo04?ooooo00?o001oooooooooool0E?ooool001co
oooo00?o0000ooooooooool0B?ooool00ol007ooooooooooo`13ooooo`03o`00Oooooooooooo04?o
oooo00?o001oooooooooool0@oooool00ol007ooooooooooo`1Dooooo`007?ooool00ol0003ooooo
ooooo`18ooooo`03o`00Oooooooooooo04?ooooo00?o001oooooooooool0@oooool00ol007oooooo
ooooo`13ooooo`03o`00Oooooooooooo05Cooooo000Looooo`03o`000?oooooooooo02Cooooo00?o
0000ooooool000008Oooool00ol007ooooooooooo`13ooooo`03o`00Oooooooooooo04?ooooo00?o
001oooooooooool0@oooool00ol007ooooooooooo`1Dooooo`001Ol00003ooooo`;o00001?ooool2
o`0000Cooooo0_l00006ooooo`03o`000?oooooooooo02Cooooo00?o0000ooooool000008Oooool0
0ol007ooooooooooo`13ooooo`03o`00Oooooooooooo04?ooooo00?o001oooooooooool0@oooool0
0ol007ooooooooooo`1Dooooo`0000Goooooo`000?ooooooooooo`000002ooooo`04o`000?oooooo
ooooo`0000;ooooo00Co0000oooooooooooo00000_ooool01?l0003oooooooooool00005ooooo`03
o`000?oooooooooo00Sooooo00?o0000ooooool000006Oooool00ol0003oooooo`00000Qooooo`03
o`00Oooooooooooo04?ooooo00?o001oooooooooool0@oooool00ol007ooooooooooo`13ooooo`03
o`00Oooooooooooo05Cooooo0002ooooo`03o`000?oooooooooo00;ooooo00Co0000oooooooooooo
00000_ooool01?l0003oooooooooool00002ooooo`04o`000?ooooooooooo`0000Gooooo00?o0000
ooooooooool02?ooool00ol0003oooooo`00000Jooooo`;o00008Oooool00ol007ooooooooooo`13
ooooo`03o`00Oooooooooooo04?ooooo00?o001oooooooooool0@oooool00ol007ooooooooooo`1D
ooooo`000oooool01Ol0003ooooooooooooooooo000000;ooooo00Co0000oooooooooooo00000_oo
ool01?l0003oooooooooool00002ooooo`03o`000?oooooooooo00?ooooo0ol00008o`00O`03o`00
0?l007oo000001[o001o0_l0003oo`00Od_o001o00001Ol0003ooooooooooooooooo000000;ooooo
00Co0000oooooooooooo00000_ooool01?l0003oooooooooool00002ooooo`04o`000?oooooooooo
o`0000Gooooo00?o0000ooooooooool02?ooool00ol0003oooooo`00000Jooooo`03o`000?oooooo
oooo023ooooo00?o001oooooooooool0@oooool00ol007ooooooooooo`13ooooo`03o`00Oooooooo
oooo04?ooooo00?o001oooooooooool0E?ooool00005o`000?ooooooooooooooool000000_ooool0
1?l0003oooooooooool00002ooooo`04o`000?ooooooooooo`0000;ooooo00Co0000oooooooooooo
00001Oooool00ol0003oooooooooo`08ooooo`03o`000?oooooo000003gooooo00?o001ooooooooo
ool0@oooool00ol007ooooooooooo`13ooooo`03o`00Oooooooooooo04?ooooo00?o001ooooooooo
ool0E?ooool00004ooooool0003o0000o`0000Cooooo0_l00004ooooo`;o00001?ooool2o`0000Ko
oooo00?o0000ooooooooool02?ooool00ol0003oooooo`00000mooooo`03o`00Oooooooooooo04?o
oooo00?o001oooooooooool0@oooool00ol007ooooooooooo`13ooooo`03o`00Oooooooooooo05Co
oooo000Looooo`03o`000?oooooooooo04Sooooo00?o001oooooooooool0@oooool00ol007oooooo
ooooo`13ooooo`03o`00Oooooooooooo04?ooooo00?o001oooooooooool0E?ooool001cooooo00?o
0000ooooooooool09Oooool00ol0003oooooooooo`0Pooooo`03o`00Oooooooooooo04?ooooo00?o
001oooooooooool0@oooool00ol007ooooooooooo`13ooooo`03o`00Oooooooooooo05Cooooo000L
ooooo`03o`000?oooooooooo02Cooooo0ol0000Qooooo`03o`00Oooooooooooo04?ooooo00?o001o
ooooooooool0@oooool00ol007ooooooooooo`13ooooo`03o`00Oooooooooooo05Cooooo000Loooo
o`03o`000?oooooooooo02?ooooo1Ol0000Pooooo`03o`00Oooooooooooo04?ooooo00?o001ooooo
ooooool0@oooool00ol007ooooooooooo`13ooooo`03o`00Oooooooooooo05Cooooo000Looooo`03
o`000?oooooooooo00Sooooo00?o0000ooooool000006?ooool6o`0001oooooo00?o001ooooooooo
ool0@oooool00ol007ooooooooooo`13ooooo`03o`00Oooooooooooo04?ooooo00?o001ooooooooo
ool0E?ooool001cooooo00?o0000ooooooooool02?ooool00ol0003oooooo`00000Gooooo`Oo0000
7oooool00ol007ooooooooooo`13ooooo`03o`00Oooooooooooo04?ooooo00?o001oooooooooool0
@oooool00ol007ooooooooooo`1Dooooo`007?ooool3o`0000Sooooo00?o0000ooooool000006?oo
ool6o`0001oooooo00?o001oooooooooool0@oooool00ol007ooooooooooo`13ooooo`03o`00Oooo
oooooooo04?ooooo00?o001oooooooooool0E?ooool001cooooo00?o0000ooooooooool02Oooool2
o`0001Wooooo1?l0000Pooooo`03o`00Oooooooooooo04?ooooo00?o001oooooooooool0@oooool0
0ol007ooooooooooo`13ooooo`03o`00Oooooooooooo05Cooooo000Looooo`03o`000?oooooooooo
00Wooooo0_l0000Iooooo`?o00008Oooool00ol007ooooooooooo`13ooooo`03o`00Oooooooooooo
04?ooooo00?o001oooooooooool0@oooool00ol007ooooooooooo`1Dooooo`007?ooool00ol0003o
ooooooooo`09ooooo`;o00006_ooool00ol0003oooooooooo`0Pooooo`03o`00Oooooooooooo04?o
oooo00?o001oooooooooool0@oooool00ol007ooooooooooo`13ooooo`03o`00Oooooooooooo05Co
oooo000Looooo`03o`000?oooooooooo04Sooooo00?o001oooooooooool0@oooool00ol007oooooo
ooooo`13ooooo`03o`00Oooooooooooo04?ooooo00?o001oooooooooool0E?ooool001cooooo00?o
0000ooooooooool0B?ooool00ol007ooooooooooo`13ooooo`03o`00Oooooooooooo04?ooooo00?o
001oooooooooool0@oooool00ol007ooooooooooo`1Dooooo`007?ooool00ol0003oooooooooo`18
ooooo`03o`00Oooooooooooo04?ooooo00?o001oooooooooool0@oooool00ol007ooooooooooo`13
ooooo`03o`00Oooooooooooo05Cooooo000Looooo`03o`000?oooooooooo04Sooooo00?o001ooooo
ooooool0@oooool00ol007ooooooooooo`13ooooo`03o`00Oooooooooooo04?ooooo00?o001ooooo
ooooool0E?ooool001cooooo00?o0000ooooooooool02Oooool2o`0003gooooo00?o001ooooooooo
ool0@oooool00ol007ooooooooooo`13ooooo`03o`00Oooooooooooo04?ooooo00?o001ooooooooo
ool0E?ooool001cooooo00?o0000ooooooooool02Oooool2o`0003gooooo00?o001oooooooooool0
@oooool00ol007ooooooooooo`13ooooo`03o`00Oooooooooooo04?ooooo00?o001oooooooooool0
E?ooool001cooooo00?o0000ooooooooool02Oooool2o`0003gooooo00?o001oooooooooool0@ooo
ool00ol007ooooooooooo`13ooooo`03o`00Oooooooooooo04?ooooo00?o001oooooooooool0E?oo
ool001cooooo0ol00009ooooo`;o0000?Oooool00ol007ooooooooooo`13ooooo`03o`00Oooooooo
oooo04?ooooo00?o001oooooooooool0@oooool00ol007ooooooooooo`1Dooooo`007?ooool00ol0
003oooooooooo`09ooooo`;o0000?Oooool00ol007ooooooooooo`13ooooo`03o`00Oooooooooooo
04?ooooo00?o001oooooooooool0@oooool00ol007ooooooooooo`1Dooooo`007?ooool00ol0003o
ooooooooo`09ooooo`;o0000?Oooool00ol007ooooooooooo`13ooooo`03o`00Oooooooooooo04?o
oooo00?o001oooooooooool0@oooool00ol007ooooooooooo`1Dooooo`007?ooool00ol0003ooooo
ooooo`18ooooo`03o`00Oooooooooooo04?ooooo00?o001oooooooooool0@oooool00ol007oooooo
ooooo`13ooooo`03o`00Oooooooooooo05Cooooo000Looooo`03o`000?oooooooooo04Sooooo00?o
001oooooooooool0@oooool00ol007ooooooooooo`13ooooo`03o`00Oooooooooooo04?ooooo00?o
001oooooooooool0E?ooool001cooooo00?o0000ooooooooool0B?ooool00ol007ooooooooooo`13
ooooo`03o`00Oooooooooooo04?ooooo00?o001oooooooooool0@oooool00ol007ooooooooooo`1D
ooooo`007?ooool00ol0003oooooooooo`18ooooo`03o`00Oooooooooooo04?ooooo00?o001ooooo
ooooool0@oooool00ol007ooooooooooo`13ooooo`03o`00Oooooooooooo05Cooooo000Looooo`03
o`000?oooooooooo00Wooooo0_l0000mooooo`03o`00Oooooooooooo04?ooooo00?o001ooooooooo
ool0@oooool00ol007ooooooooooo`13ooooo`03o`00Oooooooooooo05Cooooo000Looooo`03o`00
0?oooooooooo00Wooooo0_l0000mooooo`03o`00Oooooooooooo04?ooooo00?o001oooooooooool0
@oooool00ol007ooooooooooo`13ooooo`03o`00Oooooooooooo05Cooooo000Looooo`03o`000?oo
oooooooo00Wooooo0_l0000mooooo`03o`00Oooooooooooo04?ooooo00?o001oooooooooool0@ooo
ool00ol007ooooooooooo`13ooooo`03o`00Oooooooooooo05Cooooo000Looooo`03o`000?oooooo
oooo00Wooooo0_l0000mooooo`03o`00Oooooooooooo04?ooooo00?o001oooooooooool0@oooool0
0ol007ooooooooooo`13ooooo`03o`00Oooooooooooo05Cooooo000Looooo`?o00002Oooool2o`00
03gooooo00?o001oooooooooool0@oooool00ol007ooooooooooo`13ooooo`03o`00Oooooooooooo
04?ooooo00?o001oooooooooool0E?ooool001cooooo00?o0000ooooooooool02Oooool2o`0003go
oooo00?o001oooooooooool0@oooool00ol007ooooooooooo`13ooooo`03o`00Oooooooooooo04?o
oooo00?o001oooooooooool0E?ooool001cooooo00?o0000ooooooooool0B?ooool00ol007oooooo
ooooo`13ooooo`03o`00Oooooooooooo04?ooooo00?o001oooooooooool0@oooool00ol007oooooo
ooooo`1Dooooo`007?ooool00ol0003oooooooooo`18ooooo`03o`00Oooooooooooo04?ooooo00?o
001oooooooooool0@oooool00ol007ooooooooooo`13ooooo`03o`00Oooooooooooo05Cooooo000L
ooooo`03o`000?oooooooooo04Sooooo00?o001oooooooooool0@oooool00ol007ooooooooooo`13
ooooo`03o`00Oooooooooooo04?ooooo00?o001oooooooooool0E?ooool001cooooo00?o0000oooo
ooooool02Oooool00ol0003oooooooooo`0looooo`03o`00Oooooooooooo04?ooooo00?o001ooooo
ooooool0@oooool00ol007ooooooooooo`13ooooo`03o`00Oooooooooooo05Cooooo000Looooo`03
o`000?oooooooooo00Sooooo0ol0000mooooo`03o`00Oooooooooooo04?ooooo00?o001ooooooooo
ool0@oooool00ol007ooooooooooo`13ooooo`03o`00Oooooooooooo05Cooooo000Looooo`03o`00
0?oooooooooo00Oooooo1Ol0000looooo`03o`00Oooooooooooo04?ooooo00?o001oooooooooool0
@oooool00ol007ooooooooooo`13ooooo`03o`00Oooooooooooo05Cooooo000Looooo`03o`000?oo
oooooooo00Oooooo1_l0000kooooo`03o`00Oooooooooooo04?ooooo00?o001oooooooooool0@ooo
ool00ol007ooooooooooo`13ooooo`03o`00Oooooooooooo05Cooooo000Looooo`03o`000?oooooo
oooo00Kooooo1ol0000kooooo`03o`00Oooooooooooo04?ooooo00?o001oooooooooool0@oooool0
0ol007ooooooooooo`13ooooo`03o`00Oooooooooooo05Cooooo000Looooo`03o`000?oooooooooo
00Oooooo1_l0000kooooo`03o`00Oooooooooooo04?ooooo00?o001oooooooooool0@oooool00ol0
07ooooooooooo`13ooooo`03o`00Oooooooooooo05Cooooo000Looooo`?o00002?ooool4o`0003co
oooo00?o001oooooooooool0@oooool00ol007ooooooooooo`13ooooo`03o`00Oooooooooooo04?o
oooo00?o001oooooooooool0E?ooool001cooooo00?o0000ooooooooool02?ooool3o`0003gooooo
00?o001oooooooooool0@oooool00ol007ooooooooooo`13ooooo`03o`00Oooooooooooo04?ooooo
00?o001oooooooooool0E?ooool001cooooo00?o0000ooooooooool02Oooool00ol0003ooooooooo
o`0looooo`03o`00Oooooooooooo04?ooooo00?o001oooooooooool0@oooool00ol007oooooooooo
o`13ooooo`03o`00Oooooooooooo05Cooooo000Looooo`03o`000?oooooooooo04Sooooo00?o001o
ooooooooool0@oooool00ol007ooooooooooo`13ooooo`03o`00Oooooooooooo04?ooooo00?o001o
ooooooooool0E?ooool00?ooooooTOooool00001\
\>"],
  ImageRangeCache->{{{0, 399}, {246.188, 0}} -> {-9.72327, 184.194, 0.286338, \
9.15875}}]
}, Open  ]],

Cell["\<\
In realt\[AGrave] questa operazione \[EGrave] da evitare, in quanto \
aggiunge alla figura che stiamo generando degli elementi grafici che non \
apportano informazione aggiuntiva rilevante, tendendo al contrario ad \
\"affollare\" il disegno.
Un'informazione addizionale effettiva potrebbe essere inserita ad esempio \
etichettando ogni punto con l'abbreviazione del corrispondente \
elemento:\
\>", "Text",
  PageWidth->PaperWidth],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(MultipleListPlot[ion, 
        SymbolShape \[Rule] {enlarge[PlotSymbol[Diamond], 2]}, 
        PlotJoined \[Rule] True, 
        PlotStyle \[Rule] {{AbsoluteThickness[0.25], AbsoluteDashing[{5}]}}, 
        PlotRange \[Rule] All, Frame \[Rule] {True, True, False, False}, 
        SymbolLabel \[Rule] {Abbreviation[Elements]}];\)\)], "Input",
  CellLabel->"In[35]:=",
  PageWidth->PaperWidth],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
%%ImageSize: 400 247.214 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.01438 0.00942951 -0.0960424 0.000294803 [
[.01438 -0.0125 -3 -9 ]
[.01438 -0.0125 3 0 ]
[.20297 -0.0125 -6 -9 ]
[.20297 -0.0125 6 0 ]
[.39156 -0.0125 -6 -9 ]
[.39156 -0.0125 6 0 ]
[.58015 -0.0125 -6 -9 ]
[.58015 -0.0125 6 0 ]
[.76874 -0.0125 -6 -9 ]
[.76874 -0.0125 6 0 ]
[.95733 -0.0125 -9 -9 ]
[.95733 -0.0125 9 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .05136 -18 -4.5 ]
[-0.0125 .05136 0 4.5 ]
[-0.0125 .19876 -24 -4.5 ]
[-0.0125 .19876 0 4.5 ]
[-0.0125 .34616 -24 -4.5 ]
[-0.0125 .34616 0 4.5 ]
[-0.0125 .49356 -24 -4.5 ]
[-0.0125 .49356 0 4.5 ]
[ 0 0 -0.125 0 ]
[.02381 .29074 2.5 4.2 ]
[.02381 .29074 12.5 16.2 ]
[.03324 .60332 4 4.2 ]
[.03324 .60332 20 16.2 ]
[.04267 .05528 4 4.2 ]
[.04267 .05528 20 16.2 ]
[.0521 .1691 4 4.2 ]
[.0521 .1691 20 16.2 ]
[.06153 .13998 2.5 4.2 ]
[.06153 .13998 12.5 16.2 ]
[.07096 .22417 2.5 4.2 ]
[.07096 .22417 12.5 16.2 ]
[.08039 .28788 2.5 4.2 ]
[.08039 .28788 12.5 16.2 ]
[.08982 .2913 2.5 4.2 ]
[.08982 .2913 12.5 16.2 ]
[.09925 .39952 2.5 4.2 ]
[.09925 .39952 12.5 16.2 ]
[.10868 .51732 4 4.2 ]
[.10868 .51732 20 16.2 ]
[.1181 .05012 4 4.2 ]
[.1181 .05012 20 16.2 ]
[.12753 .12143 4 4.2 ]
[.12753 .12143 20 16.2 ]
[.13696 .07418 4 4.2 ]
[.13696 .07418 20 16.2 ]
[.14639 .13582 4 4.2 ]
[.14639 .13582 20 16.2 ]
[.15582 .20221 2.5 4.2 ]
[.15582 .20221 12.5 16.2 ]
[.16525 .19864 2.5 4.2 ]
[.16525 .19864 12.5 16.2 ]
[.17468 .27279 4 4.2 ]
[.17468 .27279 20 16.2 ]
[.18411 .35218 4 4.2 ]
[.18411 .35218 20 16.2 ]
[.19354 .02742 2.5 4.2 ]
[.19354 .02742 12.5 16.2 ]
[.20297 .0778 4 4.2 ]
[.20297 .0778 20 16.2 ]
[.2124 .08998 4 4.2 ]
[.2124 .08998 20 16.2 ]
[.22183 .09794 4 4.2 ]
[.22183 .09794 20 16.2 ]
[.23126 .09558 2.5 4.2 ]
[.23126 .09558 12.5 16.2 ]
[.24069 .09638 4 4.2 ]
[.24069 .09638 20 16.2 ]
[.25012 .11545 4 4.2 ]
[.25012 .11545 20 16.2 ]
[.25955 .1278 4 4.2 ]
[.25955 .1278 20 16.2 ]
[.26898 .12801 4 4.2 ]
[.26898 .12801 20 16.2 ]
[.27841 .12114 4 4.2 ]
[.27841 .12114 20 16.2 ]
[.28784 .1237 4 4.2 ]
[.28784 .1237 20 16.2 ]
[.29727 .17117 4 4.2 ]
[.29727 .17117 20 16.2 ]
[.30669 .07459 4 4.2 ]
[.30669 .07459 20 16.2 ]
[.31612 .12863 4 4.2 ]
[.31612 .12863 20 16.2 ]
[.32555 .18314 4 4.2 ]
[.32555 .18314 20 16.2 ]
[.33498 .18134 4 4.2 ]
[.33498 .18134 20 16.2 ]
[.34441 .24 4 4.2 ]
[.34441 .24 20 16.2 ]
[.35384 .30215 4 4.2 ]
[.35384 .30215 20 16.2 ]
[.36327 .02276 4 4.2 ]
[.36327 .02276 20 16.2 ]
[.3727 .06595 4 4.2 ]
[.3727 .06595 20 16.2 ]
[.38213 .08556 2.5 4.2 ]
[.38213 .08556 12.5 16.2 ]
[.39156 .09853 4 4.2 ]
[.39156 .09853 20 16.2 ]
[.40099 .09971 4 4.2 ]
[.40099 .09971 20 16.2 ]
[.41042 .1059 4 4.2 ]
[.41042 .1059 20 16.2 ]
[.41985 .11091 4 4.2 ]
[.41985 .11091 20 16.2 ]
[.42928 .11356 4 4.2 ]
[.42928 .11356 20 16.2 ]
[.43871 .11622 4 4.2 ]
[.43871 .11622 20 16.2 ]
[.44814 .14127 4 4.2 ]
[.44814 .14127 20 16.2 ]
[.45757 .11946 4 4.2 ]
[.45757 .11946 20 16.2 ]
[.467 .16238 4 4.2 ]
[.467 .16238 20 16.2 ]
[.47643 .06855 4 4.2 ]
[.47643 .06855 20 16.2 ]
[.48586 .11286 4 4.2 ]
[.48586 .11286 20 16.2 ]
[.49529 .14973 4 4.2 ]
[.49529 .14973 20 16.2 ]
[.50471 .1602 4 4.2 ]
[.50471 .1602 20 16.2 ]
[.51414 .20124 2.5 4.2 ]
[.51414 .20124 12.5 16.2 ]
[.52357 .249 4 4.2 ]
[.52357 .249 20 16.2 ]
[.533 .01472 4 4.2 ]
[.533 .01472 20 16.2 ]
[.54243 .05218 4 4.2 ]
[.54243 .05218 20 16.2 ]
[.55186 .06259 4 4.2 ]
[.55186 .06259 20 16.2 ]
[.56129 .05944 4 4.2 ]
[.56129 .05944 20 16.2 ]
[.57072 .05817 4 4.2 ]
[.57072 .05817 20 16.2 ]
[.58015 .06009 4 4.2 ]
[.58015 .06009 20 16.2 ]
[.58958 .06194 4.03125 4.2 ]
[.58958 .06194 20.1562 16.2 ]
[.59901 .06412 4.03125 4.2 ]
[.59901 .06412 20.1562 16.2 ]
[.60844 .06513 4 4.2 ]
[.60844 .06513 20 16.2 ]
[.61787 .07863 4 4.2 ]
[.61787 .07863 20 16.2 ]
[.6273 .0704 4 4.2 ]
[.6273 .0704 20 16.2 ]
[.63673 .07256 4 4.2 ]
[.63673 .07256 20 16.2 ]
[.64616 .07515 4 4.2 ]
[.64616 .07515 20 16.2 ]
[.65559 .07751 4 4.2 ]
[.65559 .07751 20 16.2 ]
[.66502 .07987 4.03125 4.2 ]
[.66502 .07987 20.1562 16.2 ]
[.67445 .08184 4 4.2 ]
[.67445 .08184 20 16.2 ]
[.68388 .05829 4 4.2 ]
[.68388 .05829 20 16.2 ]
[.69331 .09322 4 4.2 ]
[.69331 .09322 20 16.2 ]
[.70273 .1283 4 4.2 ]
[.70273 .1283 20 16.2 ]
[.71216 .13096 2.5 4.2 ]
[.71216 .13096 12.5 16.2 ]
[.72159 .12801 4 4.2 ]
[.72159 .12801 20 16.2 ]
[.73102 .15159 4 4.2 ]
[.73102 .15159 20 16.2 ]
[.74045 .16338 4 4.2 ]
[.74045 .16338 20 16.2 ]
[.74988 .16044 4 4.2 ]
[.74988 .16044 20 16.2 ]
[.75931 .16636 4 4.2 ]
[.75931 .16636 20 16.2 ]
[.76874 .20082 4 4.2 ]
[.76874 .20082 20 16.2 ]
[.77817 .07769 4 4.2 ]
[.77817 .07769 20 16.2 ]
[.7876 .11489 4 4.2 ]
[.7876 .11489 20 16.2 ]
[.79703 .11126 4 4.2 ]
[.79703 .11126 20 16.2 ]
[.80646 .14334 4 4.2 ]
[.80646 .14334 20 16.2 ]
[.81589 .17812 4 4.2 ]
[.81589 .17812 20 16.2 ]
[.82532 .20967 4 4.2 ]
[.82532 .20967 20 16.2 ]
[.83475 .02188 4 4.2 ]
[.83475 .02188 20 16.2 ]
[.84418 .0541 4 4.2 ]
[.84418 .0541 20 16.2 ]
[.85361 .05106 4 4.2 ]
[.85361 .05106 20 16.2 ]
[.86304 .07701 4 4.2 ]
[.86304 .07701 20 16.2 ]
[.87247 .07141 4 4.2 ]
[.87247 .07141 20 16.2 ]
[.8819 .07612 2.5 4.2 ]
[.8819 .07612 12.5 16.2 ]
[.89132 .07996 4 4.2 ]
[.89132 .07996 20 16.2 ]
[.90075 .07642 4 4.2 ]
[.90075 .07642 20 16.2 ]
[.91018 .07441 4.03125 4.2 ]
[.91018 .07441 20.1562 16.2 ]
[.91961 .07524 4.03125 4.2 ]
[.91961 .07524 20.1562 16.2 ]
[.92904 .08113 4 4.2 ]
[.92904 .08113 20 16.2 ]
[.93847 .0832 4 4.2 ]
[.93847 .0832 20 16.2 ]
[.9479 .08644 4 4.2 ]
[.9479 .08644 20 16.2 ]
[.95733 .0888 4.03125 4.2 ]
[.95733 .0888 20.1562 16.2 ]
[.96676 .09116 4 4.2 ]
[.96676 .09116 20 16.2 ]
[.97619 .28248 4 4.2 ]
[.97619 .28248 20 16.2 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.01438 0 m
.01438 .00625 L
s
[(0)] .01438 -0.0125 0 1 Mshowa
.20297 0 m
.20297 .00625 L
s
[(20)] .20297 -0.0125 0 1 Mshowa
.39156 0 m
.39156 .00625 L
s
[(40)] .39156 -0.0125 0 1 Mshowa
.58015 0 m
.58015 .00625 L
s
[(60)] .58015 -0.0125 0 1 Mshowa
.76874 0 m
.76874 .00625 L
s
[(80)] .76874 -0.0125 0 1 Mshowa
.95733 0 m
.95733 .00625 L
s
[(100)] .95733 -0.0125 0 1 Mshowa
.125 Mabswid
.06153 0 m
.06153 .00375 L
s
.10868 0 m
.10868 .00375 L
s
.15582 0 m
.15582 .00375 L
s
.25012 0 m
.25012 .00375 L
s
.29727 0 m
.29727 .00375 L
s
.34441 0 m
.34441 .00375 L
s
.43871 0 m
.43871 .00375 L
s
.48586 0 m
.48586 .00375 L
s
.533 0 m
.533 .00375 L
s
.6273 0 m
.6273 .00375 L
s
.67445 0 m
.67445 .00375 L
s
.72159 0 m
.72159 .00375 L
s
.81589 0 m
.81589 .00375 L
s
.86304 0 m
.86304 .00375 L
s
.91018 0 m
.91018 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .05136 m
.00625 .05136 L
s
[(500)] -0.0125 .05136 1 0 Mshowa
0 .19876 m
.00625 .19876 L
s
[(1000)] -0.0125 .19876 1 0 Mshowa
0 .34616 m
.00625 .34616 L
s
[(1500)] -0.0125 .34616 1 0 Mshowa
0 .49356 m
.00625 .49356 L
s
[(2000)] -0.0125 .49356 1 0 Mshowa
.125 Mabswid
0 .08084 m
.00375 .08084 L
s
0 .11032 m
.00375 .11032 L
s
0 .1398 m
.00375 .1398 L
s
0 .16928 m
.00375 .16928 L
s
0 .22824 m
.00375 .22824 L
s
0 .25772 m
.00375 .25772 L
s
0 .2872 m
.00375 .2872 L
s
0 .31668 m
.00375 .31668 L
s
0 .37564 m
.00375 .37564 L
s
0 .40512 m
.00375 .40512 L
s
0 .4346 m
.00375 .4346 L
s
0 .46408 m
.00375 .46408 L
s
0 .02188 m
.00375 .02188 L
s
0 .52304 m
.00375 .52304 L
s
0 .55252 m
.00375 .55252 L
s
0 .582 m
.00375 .582 L
s
0 .61148 m
.00375 .61148 L
s
.25 Mabswid
0 0 m
0 .61803 L
s
[ 5 ] 0 Mabsdash
.02381 .29074 m
.03324 .60332 L
.04267 .05528 L
.0521 .1691 L
.06153 .13998 L
.07096 .22417 L
.08039 .28788 L
.08982 .2913 L
.09925 .39952 L
.10868 .51732 L
.1181 .05012 L
.12753 .12143 L
.13696 .07418 L
.14639 .13582 L
.15582 .20221 L
.16525 .19864 L
.17468 .27279 L
.18411 .35218 L
.19354 .02742 L
.20297 .0778 L
.2124 .08998 L
.22183 .09794 L
.23126 .09558 L
.24069 .09638 L
.25012 .11545 L
.25955 .1278 L
.26898 .12801 L
.27841 .12114 L
.28784 .1237 L
.29727 .17117 L
.30669 .07459 L
.31612 .12863 L
.32555 .18314 L
.33498 .18134 L
.34441 .24 L
.35384 .30215 L
.36327 .02276 L
.3727 .06595 L
.38213 .08556 L
.39156 .09853 L
.40099 .09971 L
.41042 .1059 L
.41985 .11091 L
.42928 .11356 L
.43871 .11622 L
.44814 .14127 L
.45757 .11946 L
.467 .16238 L
.47643 .06855 L
.48586 .11286 L
Mistroke
.49529 .14973 L
.50471 .1602 L
.51414 .20124 L
.52357 .249 L
.533 .01472 L
.54243 .05218 L
.55186 .06259 L
.56129 .05944 L
.57072 .05817 L
.58015 .06009 L
.58958 .06194 L
.59901 .06412 L
.60844 .06513 L
.61787 .07863 L
.6273 .0704 L
.63673 .07256 L
.64616 .07515 L
.65559 .07751 L
.66502 .07987 L
.67445 .08184 L
.68388 .05829 L
.69331 .09322 L
.70273 .1283 L
.71216 .13096 L
.72159 .12801 L
.73102 .15159 L
.74045 .16338 L
.74988 .16044 L
.75931 .16636 L
.76874 .20082 L
.77817 .07769 L
.7876 .11489 L
.79703 .11126 L
.80646 .14334 L
.81589 .17812 L
.82532 .20967 L
.83475 .02188 L
.84418 .0541 L
.85361 .05106 L
.86304 .07701 L
.87247 .07141 L
.8819 .07612 L
.89132 .07996 L
.90075 .07642 L
.91018 .07441 L
.91961 .07524 L
.92904 .08113 L
.93847 .0832 L
.9479 .08644 L
.95733 .0888 L
Mistroke
.96676 .09116 L
.97619 .28248 L
Mfstroke
.0001 w
[ ] 0 setdash
.02381 .29074 -3.75 0 Mabsadd m
.02381 .29074 0 5 Mabsadd L
.02381 .29074 3.75 0 Mabsadd L
.02381 .29074 0 -5 Mabsadd L
.02381 .29074 -3.75 0 Mabsadd L closepath F
gsave
.02381 .29074 -58.5 .2 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(H) show
69.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.03324 .60332 -3.75 0 Mabsadd m
.03324 .60332 0 5 Mabsadd L
.03324 .60332 3.75 0 Mabsadd L
.03324 .60332 0 -5 Mabsadd L
.03324 .60332 -3.75 0 Mabsadd L closepath F
gsave
.03324 .60332 -57 .2 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(He) show
75.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.04267 .05528 -3.75 0 Mabsadd m
.04267 .05528 0 5 Mabsadd L
.04267 .05528 3.75 0 Mabsadd L
.04267 .05528 0 -5 Mabsadd L
.04267 .05528 -3.75 0 Mabsadd L closepath F
gsave
.04267 .05528 -57 .2 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Li) show
75.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.0521 .1691 -3.75 0 Mabsadd m
.0521 .1691 0 5 Mabsadd L
.0521 .1691 3.75 0 Mabsadd L
.0521 .1691 0 -5 Mabsadd L
.0521 .1691 -3.75 0 Mabsadd L closepath F
gsave
.0521 .1691 -57 .2 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Be) show
75.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.06153 .13998 -3.75 0 Mabsadd m
.06153 .13998 0 5 Mabsadd L
.06153 .13998 3.75 0 Mabsadd L
.06153 .13998 0 -5 Mabsadd L
.06153 .13998 -3.75 0 Mabsadd L closepath F
gsave
.06153 .13998 -58.5 .2 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(B) show
69.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.07096 .22417 -3.75 0 Mabsadd m
.07096 .22417 0 5 Mabsadd L
.07096 .22417 3.75 0 Mabsadd L
.07096 .22417 0 -5 Mabsadd L
.07096 .22417 -3.75 0 Mabsadd L closepath F
gsave
.07096 .22417 -58.5 .2 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(C) show
69.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.08039 .28788 -3.75 0 Mabsadd m
.08039 .28788 0 5 Mabsadd L
.08039 .28788 3.75 0 Mabsadd L
.08039 .28788 0 -5 Mabsadd L
.08039 .28788 -3.75 0 Mabsadd L closepath F
gsave
.08039 .28788 -58.5 .2 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(N) show
69.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.08982 .2913 -3.75 0 Mabsadd m
.08982 .2913 0 5 Mabsadd L
.08982 .2913 3.75 0 Mabsadd L
.08982 .2913 0 -5 Mabsadd L
.08982 .2913 -3.75 0 Mabsadd L closepath F
gsave
.08982 .2913 -58.5 .2 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(O) show
69.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.09925 .39952 -3.75 0 Mabsadd m
.09925 .39952 0 5 Mabsadd L
.09925 .39952 3.75 0 Mabsadd L
.09925 .39952 0 -5 Mabsadd L
.09925 .39952 -3.75 0 Mabsadd L closepath F
gsave
.09925 .39952 -58.5 .2 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(F) show
69.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.10868 .51732 -3.75 0 Mabsadd m
.10868 .51732 0 5 Mabsadd L
.10868 .51732 3.75 0 Mabsadd L
.10868 .51732 0 -5 Mabsadd L
.10868 .51732 -3.75 0 Mabsadd L closepath F
gsave
.10868 .51732 -57 .2 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Ne) show
75.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.1181 .05012 -3.75 0 Mabsadd m
.1181 .05012 0 5 Mabsadd L
.1181 .05012 3.75 0 Mabsadd L
.1181 .05012 0 -5 Mabsadd L
.1181 .05012 -3.75 0 Mabsadd L closepath F
gsave
.1181 .05012 -57 .2 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Na) show
75.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.12753 .12143 -3.75 0 Mabsadd m
.12753 .12143 0 5 Mabsadd L
.12753 .12143 3.75 0 Mabsadd L
.12753 .12143 0 -5 Mabsadd L
.12753 .12143 -3.75 0 Mabsadd L closepath F
gsave
.12753 .12143 -57 .2 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Mg) show
75.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.13696 .07418 -3.75 0 Mabsadd m
.13696 .07418 0 5 Mabsadd L
.13696 .07418 3.75 0 Mabsadd L
.13696 .07418 0 -5 Mabsadd L
.13696 .07418 -3.75 0 Mabsadd L closepath F
gsave
.13696 .07418 -57 .2 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Al) show
75.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.14639 .13582 -3.75 0 Mabsadd m
.14639 .13582 0 5 Mabsadd L
.14639 .13582 3.75 0 Mabsadd L
.14639 .13582 0 -5 Mabsadd L
.14639 .13582 -3.75 0 Mabsadd L closepath F
gsave
.14639 .13582 -57 .2 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Si) show
75.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.15582 .20221 -3.75 0 Mabsadd m
.15582 .20221 0 5 Mabsadd L
.15582 .20221 3.75 0 Mabsadd L
.15582 .20221 0 -5 Mabsadd L
.15582 .20221 -3.75 0 Mabsadd L closepath F
gsave
.15582 .20221 -58.5 .2 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(P) show
69.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.16525 .19864 -3.75 0 Mabsadd m
.16525 .19864 0 5 Mabsadd L
.16525 .19864 3.75 0 Mabsadd L
.16525 .19864 0 -5 Mabsadd L
.16525 .19864 -3.75 0 Mabsadd L closepath F
gsave
.16525 .19864 -58.5 .2 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(S) show
69.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.17468 .27279 -3.75 0 Mabsadd m
.17468 .27279 0 5 Mabsadd L
.17468 .27279 3.75 0 Mabsadd L
.17468 .27279 0 -5 Mabsadd L
.17468 .27279 -3.75 0 Mabsadd L closepath F
gsave
.17468 .27279 -57 .2 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Cl) show
75.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.18411 .35218 -3.75 0 Mabsadd m
.18411 .35218 0 5 Mabsadd L
.18411 .35218 3.75 0 Mabsadd L
.18411 .35218 0 -5 Mabsadd L
.18411 .35218 -3.75 0 Mabsadd L closepath F
gsave
.18411 .35218 -57 .2 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Ar) show
75.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.19354 .02742 -3.75 0 Mabsadd m
.19354 .02742 0 5 Mabsadd L
.19354 .02742 3.75 0 Mabsadd L
.19354 .02742 0 -5 Mabsadd L
.19354 .02742 -3.75 0 Mabsadd L closepath F
gsave
.19354 .02742 -58.5 .2 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(K) show
69.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.20297 .0778 -3.75 0 Mabsadd m
.20297 .0778 0 5 Mabsadd L
.20297 .0778 3.75 0 Mabsadd L
.20297 .0778 0 -5 Mabsadd L
.20297 .0778 -3.75 0 Mabsadd L closepath F
gsave
.20297 .0778 -57 .2 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Ca) show
75.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.2124 .08998 -3.75 0 Mabsadd m
.2124 .08998 0 5 Mabsadd L
.2124 .08998 3.75 0 Mabsadd L
.2124 .08998 0 -5 Mabsadd L
.2124 .08998 -3.75 0 Mabsadd L closepath F
gsave
.2124 .08998 -57 .2 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Sc) show
75.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.22183 .09794 -3.75 0 Mabsadd m
.22183 .09794 0 5 Mabsadd L
.22183 .09794 3.75 0 Mabsadd L
.22183 .09794 0 -5 Mabsadd L
.22183 .09794 -3.75 0 Mabsadd L closepath F
gsave
.22183 .09794 -57 .2 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Ti) show
75.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.23126 .09558 -3.75 0 Mabsadd m
.23126 .09558 0 5 Mabsadd L
.23126 .09558 3.75 0 Mabsadd L
.23126 .09558 0 -5 Mabsadd L
.23126 .09558 -3.75 0 Mabsadd L closepath F
gsave
.23126 .09558 -58.5 .2 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(V) show
69.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.24069 .09638 -3.75 0 Mabsadd m
.24069 .09638 0 5 Mabsadd L
.24069 .09638 3.75 0 Mabsadd L
.24069 .09638 0 -5 Mabsadd L
.24069 .09638 -3.75 0 Mabsadd L closepath F
gsave
.24069 .09638 -57 .2 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Cr) show
75.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.25012 .11545 -3.75 0 Mabsadd m
.25012 .11545 0 5 Mabsadd L
.25012 .11545 3.75 0 Mabsadd L
.25012 .11545 0 -5 Mabsadd L
.25012 .11545 -3.75 0 Mabsadd L closepath F
gsave
.25012 .11545 -57 .2 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Mn) show
75.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.25955 .1278 -3.75 0 Mabsadd m
.25955 .1278 0 5 Mabsadd L
.25955 .1278 3.75 0 Mabsadd L
.25955 .1278 0 -5 Mabsadd L
.25955 .1278 -3.75 0 Mabsadd L closepath F
gsave
.25955 .1278 -57 .2 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Fe) show
75.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.26898 .12801 -3.75 0 Mabsadd m
.26898 .12801 0 5 Mabsadd L
.26898 .12801 3.75 0 Mabsadd L
.26898 .12801 0 -5 Mabsadd L
.26898 .12801 -3.75 0 Mabsadd L closepath F
gsave
.26898 .12801 -57 .2 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Co) show
75.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.27841 .12114 -3.75 0 Mabsadd m
.27841 .12114 0 5 Mabsadd L
.27841 .12114 3.75 0 Mabsadd L
.27841 .12114 0 -5 Mabsadd L
.27841 .12114 -3.75 0 Mabsadd L closepath F
gsave
.27841 .12114 -57 .2 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Ni) show
75.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.28784 .1237 -3.75 0 Mabsadd m
.28784 .1237 0 5 Mabsadd L
.28784 .1237 3.75 0 Mabsadd L
.28784 .1237 0 -5 Mabsadd L
.28784 .1237 -3.75 0 Mabsadd L closepath F
gsave
.28784 .1237 -57 .2 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Cu) show
75.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.29727 .17117 -3.75 0 Mabsadd m
.29727 .17117 0 5 Mabsadd L
.29727 .17117 3.75 0 Mabsadd L
.29727 .17117 0 -5 Mabsadd L
.29727 .17117 -3.75 0 Mabsadd L closepath F
gsave
.29727 .17117 -57 .2 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Zn) show
75.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.30669 .07459 -3.75 0 Mabsadd m
.30669 .07459 0 5 Mabsadd L
.30669 .07459 3.75 0 Mabsadd L
.30669 .07459 0 -5 Mabsadd L
.30669 .07459 -3.75 0 Mabsadd L closepath F
gsave
.30669 .07459 -57 .2 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Ga) show
75.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.31612 .12863 -3.75 0 Mabsadd m
.31612 .12863 0 5 Mabsadd L
.31612 .12863 3.75 0 Mabsadd L
.31612 .12863 0 -5 Mabsadd L
.31612 .12863 -3.75 0 Mabsadd L closepath F
gsave
.31612 .12863 -57 .2 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Ge) show
75.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.32555 .18314 -3.75 0 Mabsadd m
.32555 .18314 0 5 Mabsadd L
.32555 .18314 3.75 0 Mabsadd L
.32555 .18314 0 -5 Mabsadd L
.32555 .18314 -3.75 0 Mabsadd L closepath F
gsave
.32555 .18314 -57 .2 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(As) show
75.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.33498 .18134 -3.75 0 Mabsadd m
.33498 .18134 0 5 Mabsadd L
.33498 .18134 3.75 0 Mabsadd L
.33498 .18134 0 -5 Mabsadd L
.33498 .18134 -3.75 0 Mabsadd L closepath F
gsave
.33498 .18134 -57 .2 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Se) show
75.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.34441 .24 -3.75 0 Mabsadd m
.34441 .24 0 5 Mabsadd L
.34441 .24 3.75 0 Mabsadd L
.34441 .24 0 -5 Mabsadd L
.34441 .24 -3.75 0 Mabsadd L closepath F
gsave
.34441 .24 -57 .2 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Br) show
75.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.35384 .30215 -3.75 0 Mabsadd m
.35384 .30215 0 5 Mabsadd L
.35384 .30215 3.75 0 Mabsadd L
.35384 .30215 0 -5 Mabsadd L
.35384 .30215 -3.75 0 Mabsadd L closepath F
gsave
.35384 .30215 -57 .2 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Kr) show
75.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.36327 .02276 -3.75 0 Mabsadd m
.36327 .02276 0 5 Mabsadd L
.36327 .02276 3.75 0 Mabsadd L
.36327 .02276 0 -5 Mabsadd L
.36327 .02276 -3.75 0 Mabsadd L closepath F
gsave
.36327 .02276 -57 .2 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Rb) show
75.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.3727 .06595 -3.75 0 Mabsadd m
.3727 .06595 0 5 Mabsadd L
.3727 .06595 3.75 0 Mabsadd L
.3727 .06595 0 -5 Mabsadd L
.3727 .06595 -3.75 0 Mabsadd L closepath F
gsave
.3727 .06595 -57 .2 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Sr) show
75.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.38213 .08556 -3.75 0 Mabsadd m
.38213 .08556 0 5 Mabsadd L
.38213 .08556 3.75 0 Mabsadd L
.38213 .08556 0 -5 Mabsadd L
.38213 .08556 -3.75 0 Mabsadd L closepath F
gsave
.38213 .08556 -58.5 .2 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Y) show
69.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.39156 .09853 -3.75 0 Mabsadd m
.39156 .09853 0 5 Mabsadd L
.39156 .09853 3.75 0 Mabsadd L
.39156 .09853 0 -5 Mabsadd L
.39156 .09853 -3.75 0 Mabsadd L closepath F
gsave
.39156 .09853 -57 .2 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Zr) show
75.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.40099 .09971 -3.75 0 Mabsadd m
.40099 .09971 0 5 Mabsadd L
.40099 .09971 3.75 0 Mabsadd L
.40099 .09971 0 -5 Mabsadd L
.40099 .09971 -3.75 0 Mabsadd L closepath F
gsave
.40099 .09971 -57 .2 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Nb) show
75.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.41042 .1059 -3.75 0 Mabsadd m
.41042 .1059 0 5 Mabsadd L
.41042 .1059 3.75 0 Mabsadd L
.41042 .1059 0 -5 Mabsadd L
.41042 .1059 -3.75 0 Mabsadd L closepath F
gsave
.41042 .1059 -57 .2 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Mo) show
75.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.41985 .11091 -3.75 0 Mabsadd m
.41985 .11091 0 5 Mabsadd L
.41985 .11091 3.75 0 Mabsadd L
.41985 .11091 0 -5 Mabsadd L
.41985 .11091 -3.75 0 Mabsadd L closepath F
gsave
.41985 .11091 -57 .2 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Tc) show
75.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.42928 .11356 -3.75 0 Mabsadd m
.42928 .11356 0 5 Mabsadd L
.42928 .11356 3.75 0 Mabsadd L
.42928 .11356 0 -5 Mabsadd L
.42928 .11356 -3.75 0 Mabsadd L closepath F
gsave
.42928 .11356 -57 .2 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Ru) show
75.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.43871 .11622 -3.75 0 Mabsadd m
.43871 .11622 0 5 Mabsadd L
.43871 .11622 3.75 0 Mabsadd L
.43871 .11622 0 -5 Mabsadd L
.43871 .11622 -3.75 0 Mabsadd L closepath F
gsave
.43871 .11622 -57 .2 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Rh) show
75.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.44814 .14127 -3.75 0 Mabsadd m
.44814 .14127 0 5 Mabsadd L
.44814 .14127 3.75 0 Mabsadd L
.44814 .14127 0 -5 Mabsadd L
.44814 .14127 -3.75 0 Mabsadd L closepath F
gsave
.44814 .14127 -57 .2 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Pd) show
75.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.45757 .11946 -3.75 0 Mabsadd m
.45757 .11946 0 5 Mabsadd L
.45757 .11946 3.75 0 Mabsadd L
.45757 .11946 0 -5 Mabsadd L
.45757 .11946 -3.75 0 Mabsadd L closepath F
gsave
.45757 .11946 -57 .2 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Ag) show
75.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.467 .16238 -3.75 0 Mabsadd m
.467 .16238 0 5 Mabsadd L
.467 .16238 3.75 0 Mabsadd L
.467 .16238 0 -5 Mabsadd L
.467 .16238 -3.75 0 Mabsadd L closepath F
gsave
.467 .16238 -57 .2 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Cd) show
75.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.47643 .06855 -3.75 0 Mabsadd m
.47643 .06855 0 5 Mabsadd L
.47643 .06855 3.75 0 Mabsadd L
.47643 .06855 0 -5 Mabsadd L
.47643 .06855 -3.75 0 Mabsadd L closepath F
gsave
.47643 .06855 -57 .2 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(In) show
75.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.48586 .11286 -3.75 0 Mabsadd m
.48586 .11286 0 5 Mabsadd L
.48586 .11286 3.75 0 Mabsadd L
.48586 .11286 0 -5 Mabsadd L
.48586 .11286 -3.75 0 Mabsadd L closepath F
gsave
.48586 .11286 -57 .2 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Sn) show
75.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.49529 .14973 -3.75 0 Mabsadd m
.49529 .14973 0 5 Mabsadd L
.49529 .14973 3.75 0 Mabsadd L
.49529 .14973 0 -5 Mabsadd L
.49529 .14973 -3.75 0 Mabsadd L closepath F
gsave
.49529 .14973 -57 .2 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Sb) show
75.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.50471 .1602 -3.75 0 Mabsadd m
.50471 .1602 0 5 Mabsadd L
.50471 .1602 3.75 0 Mabsadd L
.50471 .1602 0 -5 Mabsadd L
.50471 .1602 -3.75 0 Mabsadd L closepath F
gsave
.50471 .1602 -57 .2 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Te) show
75.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.51414 .20124 -3.75 0 Mabsadd m
.51414 .20124 0 5 Mabsadd L
.51414 .20124 3.75 0 Mabsadd L
.51414 .20124 0 -5 Mabsadd L
.51414 .20124 -3.75 0 Mabsadd L closepath F
gsave
.51414 .20124 -58.5 .2 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(I) show
69.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.52357 .249 -3.75 0 Mabsadd m
.52357 .249 0 5 Mabsadd L
.52357 .249 3.75 0 Mabsadd L
.52357 .249 0 -5 Mabsadd L
.52357 .249 -3.75 0 Mabsadd L closepath F
gsave
.52357 .249 -57 .2 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Xe) show
75.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.533 .01472 -3.75 0 Mabsadd m
.533 .01472 0 5 Mabsadd L
.533 .01472 3.75 0 Mabsadd L
.533 .01472 0 -5 Mabsadd L
.533 .01472 -3.75 0 Mabsadd L closepath F
gsave
.533 .01472 -57 .2 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Cs) show
75.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.54243 .05218 -3.75 0 Mabsadd m
.54243 .05218 0 5 Mabsadd L
.54243 .05218 3.75 0 Mabsadd L
.54243 .05218 0 -5 Mabsadd L
.54243 .05218 -3.75 0 Mabsadd L closepath F
gsave
.54243 .05218 -57 .2 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Ba) show
75.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.55186 .06259 -3.75 0 Mabsadd m
.55186 .06259 0 5 Mabsadd L
.55186 .06259 3.75 0 Mabsadd L
.55186 .06259 0 -5 Mabsadd L
.55186 .06259 -3.75 0 Mabsadd L closepath F
gsave
.55186 .06259 -57 .2 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(La) show
75.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.56129 .05944 -3.75 0 Mabsadd m
.56129 .05944 0 5 Mabsadd L
.56129 .05944 3.75 0 Mabsadd L
.56129 .05944 0 -5 Mabsadd L
.56129 .05944 -3.75 0 Mabsadd L closepath F
gsave
.56129 .05944 -57 .2 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Ce) show
75.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.57072 .05817 -3.75 0 Mabsadd m
.57072 .05817 0 5 Mabsadd L
.57072 .05817 3.75 0 Mabsadd L
.57072 .05817 0 -5 Mabsadd L
.57072 .05817 -3.75 0 Mabsadd L closepath F
gsave
.57072 .05817 -57 .2 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Pr) show
75.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.58015 .06009 -3.75 0 Mabsadd m
.58015 .06009 0 5 Mabsadd L
.58015 .06009 3.75 0 Mabsadd L
.58015 .06009 0 -5 Mabsadd L
.58015 .06009 -3.75 0 Mabsadd L closepath F
gsave
.58015 .06009 -57 .2 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Nd) show
75.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.58958 .06194 -3.75 0 Mabsadd m
.58958 .06194 0 5 Mabsadd L
.58958 .06194 3.75 0 Mabsadd L
.58958 .06194 0 -5 Mabsadd L
.58958 .06194 -3.75 0 Mabsadd L closepath F
gsave
.58958 .06194 -56.9688 .2 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Pm) show
75.125 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.59901 .06412 -3.75 0 Mabsadd m
.59901 .06412 0 5 Mabsadd L
.59901 .06412 3.75 0 Mabsadd L
.59901 .06412 0 -5 Mabsadd L
.59901 .06412 -3.75 0 Mabsadd L closepath F
gsave
.59901 .06412 -56.9688 .2 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Sm) show
75.125 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.60844 .06513 -3.75 0 Mabsadd m
.60844 .06513 0 5 Mabsadd L
.60844 .06513 3.75 0 Mabsadd L
.60844 .06513 0 -5 Mabsadd L
.60844 .06513 -3.75 0 Mabsadd L closepath F
gsave
.60844 .06513 -57 .2 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Eu) show
75.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.61787 .07863 -3.75 0 Mabsadd m
.61787 .07863 0 5 Mabsadd L
.61787 .07863 3.75 0 Mabsadd L
.61787 .07863 0 -5 Mabsadd L
.61787 .07863 -3.75 0 Mabsadd L closepath F
gsave
.61787 .07863 -57 .2 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Gd) show
75.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.6273 .0704 -3.75 0 Mabsadd m
.6273 .0704 0 5 Mabsadd L
.6273 .0704 3.75 0 Mabsadd L
.6273 .0704 0 -5 Mabsadd L
.6273 .0704 -3.75 0 Mabsadd L closepath F
gsave
.6273 .0704 -57 .2 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Tb) show
75.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.63673 .07256 -3.75 0 Mabsadd m
.63673 .07256 0 5 Mabsadd L
.63673 .07256 3.75 0 Mabsadd L
.63673 .07256 0 -5 Mabsadd L
.63673 .07256 -3.75 0 Mabsadd L closepath F
gsave
.63673 .07256 -57 .2 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Dy) show
75.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.64616 .07515 -3.75 0 Mabsadd m
.64616 .07515 0 5 Mabsadd L
.64616 .07515 3.75 0 Mabsadd L
.64616 .07515 0 -5 Mabsadd L
.64616 .07515 -3.75 0 Mabsadd L closepath F
gsave
.64616 .07515 -57 .2 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Ho) show
75.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.65559 .07751 -3.75 0 Mabsadd m
.65559 .07751 0 5 Mabsadd L
.65559 .07751 3.75 0 Mabsadd L
.65559 .07751 0 -5 Mabsadd L
.65559 .07751 -3.75 0 Mabsadd L closepath F
gsave
.65559 .07751 -57 .2 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Er) show
75.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.66502 .07987 -3.75 0 Mabsadd m
.66502 .07987 0 5 Mabsadd L
.66502 .07987 3.75 0 Mabsadd L
.66502 .07987 0 -5 Mabsadd L
.66502 .07987 -3.75 0 Mabsadd L closepath F
gsave
.66502 .07987 -56.9688 .2 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Tm) show
75.125 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.67445 .08184 -3.75 0 Mabsadd m
.67445 .08184 0 5 Mabsadd L
.67445 .08184 3.75 0 Mabsadd L
.67445 .08184 0 -5 Mabsadd L
.67445 .08184 -3.75 0 Mabsadd L closepath F
gsave
.67445 .08184 -57 .2 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Yb) show
75.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.68388 .05829 -3.75 0 Mabsadd m
.68388 .05829 0 5 Mabsadd L
.68388 .05829 3.75 0 Mabsadd L
.68388 .05829 0 -5 Mabsadd L
.68388 .05829 -3.75 0 Mabsadd L closepath F
gsave
.68388 .05829 -57 .2 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Lu) show
75.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.69331 .09322 -3.75 0 Mabsadd m
.69331 .09322 0 5 Mabsadd L
.69331 .09322 3.75 0 Mabsadd L
.69331 .09322 0 -5 Mabsadd L
.69331 .09322 -3.75 0 Mabsadd L closepath F
gsave
.69331 .09322 -57 .2 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Hf) show
75.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.70273 .1283 -3.75 0 Mabsadd m
.70273 .1283 0 5 Mabsadd L
.70273 .1283 3.75 0 Mabsadd L
.70273 .1283 0 -5 Mabsadd L
.70273 .1283 -3.75 0 Mabsadd L closepath F
gsave
.70273 .1283 -57 .2 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Ta) show
75.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.71216 .13096 -3.75 0 Mabsadd m
.71216 .13096 0 5 Mabsadd L
.71216 .13096 3.75 0 Mabsadd L
.71216 .13096 0 -5 Mabsadd L
.71216 .13096 -3.75 0 Mabsadd L closepath F
gsave
.71216 .13096 -58.5 .2 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(W) show
69.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.72159 .12801 -3.75 0 Mabsadd m
.72159 .12801 0 5 Mabsadd L
.72159 .12801 3.75 0 Mabsadd L
.72159 .12801 0 -5 Mabsadd L
.72159 .12801 -3.75 0 Mabsadd L closepath F
gsave
.72159 .12801 -57 .2 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Re) show
75.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.73102 .15159 -3.75 0 Mabsadd m
.73102 .15159 0 5 Mabsadd L
.73102 .15159 3.75 0 Mabsadd L
.73102 .15159 0 -5 Mabsadd L
.73102 .15159 -3.75 0 Mabsadd L closepath F
gsave
.73102 .15159 -57 .2 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Os) show
75.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.74045 .16338 -3.75 0 Mabsadd m
.74045 .16338 0 5 Mabsadd L
.74045 .16338 3.75 0 Mabsadd L
.74045 .16338 0 -5 Mabsadd L
.74045 .16338 -3.75 0 Mabsadd L closepath F
gsave
.74045 .16338 -57 .2 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Ir) show
75.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.74988 .16044 -3.75 0 Mabsadd m
.74988 .16044 0 5 Mabsadd L
.74988 .16044 3.75 0 Mabsadd L
.74988 .16044 0 -5 Mabsadd L
.74988 .16044 -3.75 0 Mabsadd L closepath F
gsave
.74988 .16044 -57 .2 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Pt) show
75.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.75931 .16636 -3.75 0 Mabsadd m
.75931 .16636 0 5 Mabsadd L
.75931 .16636 3.75 0 Mabsadd L
.75931 .16636 0 -5 Mabsadd L
.75931 .16636 -3.75 0 Mabsadd L closepath F
gsave
.75931 .16636 -57 .2 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Au) show
75.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.76874 .20082 -3.75 0 Mabsadd m
.76874 .20082 0 5 Mabsadd L
.76874 .20082 3.75 0 Mabsadd L
.76874 .20082 0 -5 Mabsadd L
.76874 .20082 -3.75 0 Mabsadd L closepath F
gsave
.76874 .20082 -57 .2 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Hg) show
75.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.77817 .07769 -3.75 0 Mabsadd m
.77817 .07769 0 5 Mabsadd L
.77817 .07769 3.75 0 Mabsadd L
.77817 .07769 0 -5 Mabsadd L
.77817 .07769 -3.75 0 Mabsadd L closepath F
gsave
.77817 .07769 -57 .2 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Tl) show
75.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.7876 .11489 -3.75 0 Mabsadd m
.7876 .11489 0 5 Mabsadd L
.7876 .11489 3.75 0 Mabsadd L
.7876 .11489 0 -5 Mabsadd L
.7876 .11489 -3.75 0 Mabsadd L closepath F
gsave
.7876 .11489 -57 .2 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Pb) show
75.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.79703 .11126 -3.75 0 Mabsadd m
.79703 .11126 0 5 Mabsadd L
.79703 .11126 3.75 0 Mabsadd L
.79703 .11126 0 -5 Mabsadd L
.79703 .11126 -3.75 0 Mabsadd L closepath F
gsave
.79703 .11126 -57 .2 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Bi) show
75.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.80646 .14334 -3.75 0 Mabsadd m
.80646 .14334 0 5 Mabsadd L
.80646 .14334 3.75 0 Mabsadd L
.80646 .14334 0 -5 Mabsadd L
.80646 .14334 -3.75 0 Mabsadd L closepath F
gsave
.80646 .14334 -57 .2 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Po) show
75.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.81589 .17812 -3.75 0 Mabsadd m
.81589 .17812 0 5 Mabsadd L
.81589 .17812 3.75 0 Mabsadd L
.81589 .17812 0 -5 Mabsadd L
.81589 .17812 -3.75 0 Mabsadd L closepath F
gsave
.81589 .17812 -57 .2 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(At) show
75.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.82532 .20967 -3.75 0 Mabsadd m
.82532 .20967 0 5 Mabsadd L
.82532 .20967 3.75 0 Mabsadd L
.82532 .20967 0 -5 Mabsadd L
.82532 .20967 -3.75 0 Mabsadd L closepath F
gsave
.82532 .20967 -57 .2 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Rn) show
75.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.83475 .02188 -3.75 0 Mabsadd m
.83475 .02188 0 5 Mabsadd L
.83475 .02188 3.75 0 Mabsadd L
.83475 .02188 0 -5 Mabsadd L
.83475 .02188 -3.75 0 Mabsadd L closepath F
gsave
.83475 .02188 -57 .2 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Fr) show
75.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.84418 .0541 -3.75 0 Mabsadd m
.84418 .0541 0 5 Mabsadd L
.84418 .0541 3.75 0 Mabsadd L
.84418 .0541 0 -5 Mabsadd L
.84418 .0541 -3.75 0 Mabsadd L closepath F
gsave
.84418 .0541 -57 .2 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Ra) show
75.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.85361 .05106 -3.75 0 Mabsadd m
.85361 .05106 0 5 Mabsadd L
.85361 .05106 3.75 0 Mabsadd L
.85361 .05106 0 -5 Mabsadd L
.85361 .05106 -3.75 0 Mabsadd L closepath F
gsave
.85361 .05106 -57 .2 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Ac) show
75.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.86304 .07701 -3.75 0 Mabsadd m
.86304 .07701 0 5 Mabsadd L
.86304 .07701 3.75 0 Mabsadd L
.86304 .07701 0 -5 Mabsadd L
.86304 .07701 -3.75 0 Mabsadd L closepath F
gsave
.86304 .07701 -57 .2 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Th) show
75.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.87247 .07141 -3.75 0 Mabsadd m
.87247 .07141 0 5 Mabsadd L
.87247 .07141 3.75 0 Mabsadd L
.87247 .07141 0 -5 Mabsadd L
.87247 .07141 -3.75 0 Mabsadd L closepath F
gsave
.87247 .07141 -57 .2 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Pa) show
75.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.8819 .07612 -3.75 0 Mabsadd m
.8819 .07612 0 5 Mabsadd L
.8819 .07612 3.75 0 Mabsadd L
.8819 .07612 0 -5 Mabsadd L
.8819 .07612 -3.75 0 Mabsadd L closepath F
gsave
.8819 .07612 -58.5 .2 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(U) show
69.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.89132 .07996 -3.75 0 Mabsadd m
.89132 .07996 0 5 Mabsadd L
.89132 .07996 3.75 0 Mabsadd L
.89132 .07996 0 -5 Mabsadd L
.89132 .07996 -3.75 0 Mabsadd L closepath F
gsave
.89132 .07996 -57 .2 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Np) show
75.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.90075 .07642 -3.75 0 Mabsadd m
.90075 .07642 0 5 Mabsadd L
.90075 .07642 3.75 0 Mabsadd L
.90075 .07642 0 -5 Mabsadd L
.90075 .07642 -3.75 0 Mabsadd L closepath F
gsave
.90075 .07642 -57 .2 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Pu) show
75.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.91018 .07441 -3.75 0 Mabsadd m
.91018 .07441 0 5 Mabsadd L
.91018 .07441 3.75 0 Mabsadd L
.91018 .07441 0 -5 Mabsadd L
.91018 .07441 -3.75 0 Mabsadd L closepath F
gsave
.91018 .07441 -56.9688 .2 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Am) show
75.125 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.91961 .07524 -3.75 0 Mabsadd m
.91961 .07524 0 5 Mabsadd L
.91961 .07524 3.75 0 Mabsadd L
.91961 .07524 0 -5 Mabsadd L
.91961 .07524 -3.75 0 Mabsadd L closepath F
gsave
.91961 .07524 -56.9688 .2 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Cm) show
75.125 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.92904 .08113 -3.75 0 Mabsadd m
.92904 .08113 0 5 Mabsadd L
.92904 .08113 3.75 0 Mabsadd L
.92904 .08113 0 -5 Mabsadd L
.92904 .08113 -3.75 0 Mabsadd L closepath F
gsave
.92904 .08113 -57 .2 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Bk) show
75.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.93847 .0832 -3.75 0 Mabsadd m
.93847 .0832 0 5 Mabsadd L
.93847 .0832 3.75 0 Mabsadd L
.93847 .0832 0 -5 Mabsadd L
.93847 .0832 -3.75 0 Mabsadd L closepath F
gsave
.93847 .0832 -57 .2 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Cf) show
75.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.9479 .08644 -3.75 0 Mabsadd m
.9479 .08644 0 5 Mabsadd L
.9479 .08644 3.75 0 Mabsadd L
.9479 .08644 0 -5 Mabsadd L
.9479 .08644 -3.75 0 Mabsadd L closepath F
gsave
.9479 .08644 -57 .2 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Es) show
75.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.95733 .0888 -3.75 0 Mabsadd m
.95733 .0888 0 5 Mabsadd L
.95733 .0888 3.75 0 Mabsadd L
.95733 .0888 0 -5 Mabsadd L
.95733 .0888 -3.75 0 Mabsadd L closepath F
gsave
.95733 .0888 -56.9688 .2 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Fm) show
75.125 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.96676 .09116 -3.75 0 Mabsadd m
.96676 .09116 0 5 Mabsadd L
.96676 .09116 3.75 0 Mabsadd L
.96676 .09116 0 -5 Mabsadd L
.96676 .09116 -3.75 0 Mabsadd L closepath F
gsave
.96676 .09116 -57 .2 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Md) show
75.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.97619 .28248 -3.75 0 Mabsadd m
.97619 .28248 0 5 Mabsadd L
.97619 .28248 3.75 0 Mabsadd L
.97619 .28248 0 -5 Mabsadd L
.97619 .28248 -3.75 0 Mabsadd L closepath F
gsave
.97619 .28248 -57 .2 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(No) show
75.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[35]:=",
  ImageSize->{400, 247.188},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006@0000mb000`400?l00000o`00003ooooooonA
ooooo`008?ooool2o`0003gooooo1Ol00003ooooo`;o0000??ooool3o`0000?ooooo0_l0000joooo
o`?o00001?ooool2o`0003_ooooo0ol00004ooooo`;o0000>?ooool3o`0000Cooooo0_l00004oooo
o`;o00005Oooool001oooooo00Co0000oooooooooooo0000?Oooool01?l0003oooooooooool00002
ooooo`04o`000?ooooooooooo`0003cooooo00Go0000ooooooooooooooooo`000002ooooo`03o`00
0?oooooooooo03Kooooo00Go0000ooooooooooooooooo`000002ooooo`04o`000?ooooooooooo`00
03Wooooo00Go0000ooooooooooooooooo`000002ooooo`04o`000?ooooooooooo`0003Sooooo00?o
0000ooooooooool00_ooool01?l0003oooooooooool00002ooooo`04o`000?ooooooooooo`0001Co
oooo000Oooooo`04o`000?ooooooooooo`0003kooooo00?o0000ooooooooool00_ooool01?l0003o
ooooooooool0000iooooo`Go00000_ooool01?l0003oooooooooool0000hooooo`05o`000?oooooo
ooooooooool000000_ooool01?l0003oooooooooool0000iooooo`05o`000?ooooooooooooooool0
00000_ooool01?l0003oooooooooool0000hooooo`03o`000?oooooooooo00;ooooo00Co0000oooo
oooooooo00000_ooool01?l0003oooooooooool0000Dooooo`007oooool01?l0003oooooooooool0
000oooooo`05o`000?ooooooooooooooool000000_ooool00ol0003oooooooooo`0gooooo`04o`00
0?ooooooooooo`0000?ooooo00Co0000oooooooooooo0000>?ooool4o`0000?ooooo00Co0000oooo
oooooooo0000>_ooool3o`0000?ooooo00Co0000oooooooooooo0000>?ooool00ol0003ooooooooo
o`02ooooo`04o`000?ooooooooooo`0000;ooooo00Co0000oooooooooooo00005?ooool001oooooo
00Co0000oooooooooooo0000??ooool01Ol0003ooooooooooooooooo000000;ooooo00Co0000oooo
oooooooo0000>_ooool00ol0003oooooo`000003ooooo`04o`000?ooooooooooo`0003Sooooo00?o
0000ooooooooool01?ooool01?l0003oooooooooool0000iooooo`05o`000?ooooooooooooooool0
00000_ooool01?l0003oooooooooool0000hooooo`03o`000?oooooooooo00;ooooo00Co0000oooo
oooooooo00000_ooool01?l0003oooooooooool0000Dooooo`007oooool01?l0003oooooooooool0
000looooo`05o`000?ooooooooooooooool000000_ooool01?l0003oooooooooool0000kooooo`;o
00000oooool01?l0003oooooooooool0000iooooo`03o`000?oooooooooo00?ooooo00Co0000oooo
oooooooo0000>Oooool01Ol0003ooooooooooooooooo000000;ooooo00Co0000oooooooooooo0000
=oooool2o`0000Cooooo00Co0000oooooooooooo00000_ooool01?l0003oooooooooool0000Doooo
o`008?ooool2o`0003kooooo0ol00004ooooo`;o0000?Oooool00ol0003oooooooooo`02ooooo`;o
0000>oooool2o`0000Cooooo0_l0000kooooo`?o00001?ooool2o`0003Wooooo00?o0000oooooooo
ool00oooool2o`0000Cooooo0_l0000Eooooo`00oooooonAooooo`00oooooonAooooo`00oooooonA
ooooo`00oooooonAooooo`00oooooonAooooo`00oooooonAooooo`007?ooooooo`0006Wo00003?oo
ool001cooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`0>ooooo`03o`000?oooooo
oooo00kooooo00?o0000ooooooooool03_ooool00ol0003oooooooooo`0>ooooo`03o`000?oooooo
oooo00kooooo00?o0000ooooooooool03_ooool00ol0003oooooooooo`0>ooooo`03o`000?oooooo
oooo00kooooo00?o0000ooooooooool03_ooool00ol0003oooooooooo`0=ooooo`03o`000?oooooo
oooo00kooooo00?o0000ooooooooool03_ooool00ol0003oooooooooo`0>ooooo`03o`000?oooooo
oooo00kooooo00?o0000ooooooooool03_ooool00ol0003oooooooooo`0>ooooo`03o`000?oooooo
oooo00kooooo00?o0000ooooooooool03_ooool00ol0003oooooooooo`0>ooooo`03o`000?oooooo
oooo00kooooo00?o0000ooooooooool06Oooool001cooooo00?o0000ooooooooool00_ooool00ol0
003oooooooooo`11ooooo`03o`000?oooooooooo047ooooo00?o0000ooooooooool0;oooool00ol0
003oooooooooo`0>ooooo`03o`000?oooooooooo047ooooo00?o0000ooooooooool0@Oooool00ol0
003oooooooooo`0Iooooo`007?ooool00ol0003oooooooooo`2kooooo`?o0000/oooool001cooooo
00?o0000ooooooooool0^_ooool5o`000;;ooooo000Looooo`03o`000?oooooooooo07oooooo00?o
0000ooooooooool0>?ooool6o`0006Wooooo00?o0000ooooooooool0AOooool001cooooo00?o0000
ooooooooool0O_ooool3o`0003Sooooo1ol0001Xooooo`?o0000A_ooool001cooooo00?o0000oooo
ooooool0@oooool00ol0003oooooooooo`0gooooo`Go0000>?ooool6o`0006Oooooo1?l00016oooo
o`007?ooool2o`0004?ooooo0ol0000hooooo`Ko0000>?ooool4o`0006Oooooo1_l00015ooooo`00
7?ooool00ol0003oooooooooo`11ooooo`Co0000=oooool7o`0003Sooooo0ol0001Wooooo`Oo0000
AOooool001cooooo00?o0000ooooooooool0@?ooool6o`0003Oooooo1_l0000iooooo`;o0000J?oo
ool6o`0004Gooooo000Looooo`03o`000?oooooooooo03oooooo1ol0000hooooo`Co0000>_ooool0
0ol0003oooooo`00001Xooooo`Co0000A_ooool001cooooo00?o0000ooooooooool0@?ooool6o`00
03Sooooo0ol0000mooooo`03o`000?oooooooooo06Oooooo0ol00016ooooo`007?ooool00ol0003o
ooooooooo`11ooooo`Co0000>_ooool00ol0003oooooooooo`0looooo`03o`000?oooooooooo00?o
oooo0_l00002ooooo`Co0000G?ooool3o`0004Kooooo000Looooo`03o`000?oooooooooo04;ooooo
0_l0000mooooo`03o`000?oooooooooo03_ooooo00Go0000ooooooooooooooooo`000002ooooo`03
o`000?oooooooooo00?ooooo00?o0000ooooooooool0FOooool01?l0003oooooooooool00015oooo
o`007?ooool00ol0003oooooooooo`0Wooooo`03o`000?oooooooooo01Wooooo0_l0000looooo`03
o`000?oooooooooo03kooooo00?o0000ooooooooool01?ooool3o`0005oooooo00Go0000oooooooo
ooooooooo`000011ooooo`001oooool3o`0000Cooooo0_l00004ooooo`;o00001_ooool00ol0003o
ooooooooo`0Vooooo`?o00006oooool00ol0003oooooooooo`0hooooo`03o`000?oooooo000000?o
oooo0ol00002ooooo`Go0000;Oooool01ol0003ooooooooooooooooo0000ooooool000001Oooool0
0ol0003oooooooooo`1Pooooo`;o000000?oooooo`000?l000000_l00003ooooo`?o0000>Oooool0
00Kooooo00Go0000ooooooooooooooooo`000002ooooo`04o`000?ooooooooooo`0000;ooooo00Co
0000oooooooooooo00001Oooool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo01Kooooo
1Ol0000Jooooo`03o`000?oooooooooo03Sooooo00Co0000oooooooooooo00000oooool01?l0003o
ooooooooool00002ooooo`04o`000?ooooooooooo`0002cooooo00?o0000ooooooooool01?l00006
ooooo`Co0000G_ooool7o`0000Cooooo00?o0000ooooooooool0>?ooool000[ooooo00Co0000oooo
oooooooo00000_ooool01?l0003oooooooooool00002ooooo`03o`000?oooooooooo00?ooooo0ol0
000;ooooo`?o00005oooool6o`0001Wooooo00?o0000ooooooooool00ol000000ooooooo0000o`00
000booooo`04o`000?ooooooooooo`0000?ooooo00?o0000ooooool000000oooool01?l0003ooooo
ooooool0000/ooooo`03o`000?oooooo000000?o000000Coooooo`000?oooooooooo0_l00002oooo
o`04o`000?ooooooooooo`0002Gooooo00?o0000ooooooooool0=?ooool9o`0000?ooooo00?o0000
ooooooooool0>?ooool000[ooooo00Co0000oooooooooooo00000_ooool01?l0003oooooooooool0
0002ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool02_ooool5o`0001Gooooo1ol0
000Gooooo`03o`000?oooooo000000?ooooo00Co0000oooooooooooo0000<oooool01?l0003ooooo
ooooool00003ooooo`?o00000oooool01?l0003oooooooooool0000/oooooa?o00000_ooool00ol0
003oooooooooo`0Nooooo`?o0000<oooool;o`0000?ooooo0_l0000iooooo`001_ooool4o`0000?o
oooo00Co0000oooooooooooo00000_ooool01?l0003oooooooooool00005ooooo`03o`000?oooooo
oooo00[ooooo1_l0000Eooooo`Ko00005oooool00ol0003oooooo`000003ooooo`03o`000?oooooo
000003Cooooo00Go0000ooooooooooooooooo`000002ooooo`04o`000?ooooooooooo`0000;ooooo
0ol0000]oooooaOo000000Goooooo`000?ooooooooooo`00000Iooooo`Co0000<oooool;o`0000;o
oooo0_l000000ooooooo0000o`00000gooooo`001_ooool00ol0003oooooooooo`04ooooo`04o`00
0?ooooooooooo`0000;ooooo00Co0000oooooooooooo00001Oooool00ol0003oooooooooo`09oooo
o`Oo00005_ooool4o`0001Sooooo00?o0000ooooooooool00oooool2o`0003Gooooo00?o0000oooo
ooooool00ol000001Ooooooo0000oooooooooooo000000;ooooo00?o0000ooooooooool06Oooool0
0ol0003oooooooooo`0Aoooooago00005oooool6o`0003;ooooo2_l000000ooooooo0000ooooo`0l
ooooo`001_ooool5o`0000?ooooo0_l00004ooooo`;o00001_ooool00ol0003oooooooooo`0:oooo
o`Ko00005_ooool3o`0001Wooooo00?o0000ooooooooool00oooool00ol0003oooooo`00000foooo
o`So00000_ooool2o`0001[ooooo0ol0000Doooooaco00001?ooool00ol0003oooooooooo`0>oooo
o`Oo0000<_ooool00ol0003oooooo`000009o`0000;ooooo00?o0000ooooooooool0>?ooool001co
oooo00?o0000ooooooooool02oooool4o`0001Sooooo0_l00005ooooo`03o`000?oooooooooo017o
oooo00?o0000ooooooooool00oooool01?l0003oooooooooool0000dooooo`Oo00007oooool5o`00
01Cooooo7?l00002ooooo`?o00000_ooool00ol0003oooooooooo`0;ooooo`Ko0000<_ooool00ol0
003oooooooooo`03o`000003ooooool0003ooooo00Cooooo0ol0000<ooooo`03o`000?oooooooooo
02[ooooo000Looooo`03o`000?oooooooooo00_ooooo0ol0000Iooooo`03o`000?oooooooooo00?o
oooo0ol0000Booooo`03o`000?oooooooooo00;ooooo0ol000000ooooooo0000o`00000Nooooo`03
o`000?oooooooooo017ooooo2?l0000Nooooo`Oo00005?oooolKo`000003ooooool0003o000000Ko
000000?oooooo`000?ooool02_ooool4o`0003?ooooo00Go0000ooooooooooooooooo`000006oooo
o`Ko000000?oooooo`000?ooool01?ooool00ol0003oooooooooo`03o`000003ooooool0003ooooo
02Sooooo000Looooo`03o`000?oooooooooo00cooooo00?o0000ooooooooool06?ooool00ol0003o
ooooooooo`02ooooo`Go00005?ooool2o`0002?ooooo0ol0000Cooooo`Oo00007Oooool8o`0001Go
oooo1ol000000ooooooo0000o`00000Lo`000003ooooool0003ooooo00;ooooo00?o0000oooooooo
ool00oooool2o`00023ooooo00?o0000ooooooooool06oooool:o`000003ooooool0003ooooo00[o
0000:?ooool001cooooo00?o0000ooooooooool03?ooool00ol0003oooooooooo`0Hooooo`04o`00
0?ooooooooooooooo`Oo00000_ooool4o`0000gooooo0ol0000Qooooo`Go00004Oooool00ol0003o
ooooo`000004o`0001oooooo1ol0000?ooooo`03o`000?oooooooooo00Cooooo0ol00002ooooo`04
o`000?ooooooooooo`0000;ooooo00?o0000ooooooooool06_l000001_oooooo0000o`000?l0003o
ooooo`0000?ooooo00?o0000ooooooooool07Oooool3o`0001_ooooo6_l0000Vooooo`007?ooool0
0ol0003oooooooooo`0<ooooo`03o`000?oooooooooo01Sooooo00?o0000ooooooooool02?l00000
1Ooooooo0000oooooooooooo000000gooooo1Ol0000Oooooo`Oo00004?ooool00ol0003ooooooooo
o`03o`00027ooooo1Ol0000@ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01?l0
0003ooooo`Go000000?oooooo`000?l000007?l0000Qooooo`Go00006OoooolLo`0000;ooooo00?o
0000ooooooooool08?ooool001cooooo00?o0000ooooooooool03?ooool2o`0000Cooooo1Ol00000
0ooooooo0000o`000003o`0000cooooo00?o0000ooooool000001_l00002ooooo`?o00003?ooool7
o`0001gooooo2?l0000@ooooo`04o`000?ooooooooooooooo`;o000000?oooooo`000?ooool07ooo
ool3o`00017ooooo00?o0000ooooooooool02Oooool01_l0003oooooooooool0003oooooo`0000;o
oooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`0Ko`0000;ooooo00?o0000oooooooo
ool06oooool6o`0001Oooooo8Ol000000ooooooo0000ooooo`0Nooooo`007?ooool2o`0000gooooo
0_l00005ooooo`04o`000?ooooooooooo`0000?ooooo00?o0000ooooooooool03?ooool00ol0003o
ooooooooo`06o`000005ooooool0003oooooooooool000002oooool8o`0001kooooo1ol0000@oooo
o`03o`000?oooooooooo00?ooooo0ol0000Pooooo`;o00004Oooool00ol0003oooooooooo`09oooo
o`04o`000?ooooooooooo`0000;ooooo1_l000000ooooooo0000o`00000Mo`000003ooooool0003o
oooo00?ooooo1Ol00003ooooo`;o000000?oooooo`000?ooool02oooool7o`00013ooooo00?o0000
ooooooooool01OoooolSo`0000;ooooo00?o0000ooooooooool06Oooool001cooooo00?o0000oooo
ooooool03?ooool2o`0000Gooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`0<oooo
o`04o`000?ooooooooooooooo`?o000000Coooooo`000?oooooooooo0_l0000<ooooo`Wo00007_oo
ool5o`00017ooooo00?o0000ooooooooool00_ooool5o`0001oooooo0_l0000Aooooo`03o`000?oo
oooooooo00Wooooo3ol000000ooooooo0000o`000007o`000003ooooool0003o0000013o00000_oo
ool2o`0000?ooooo00Co0000oooooooooooo00000_ooool01?l0003oooooooooool0000>ooooo`Ko
00004?ooool00ol0003oooooooooo`06ooooo`Ko000000?oooooo`000?l000007Ol000000ooooooo
0000ooooo`0Gooooo`007?ooool00ol0003oooooooooo`0<ooooo`;o00001Oooool00ol0003ooooo
ooooo`04ooooo`03o`000?oooooooooo00cooooo00?o0000ooooooooool00_ooool2o`000003oooo
ool0003ooooo00oooooo00?o0000ooooool000001ol00004ooooo`04o`000?ooooooooooo`0001Ko
oooo0ol0000Booooo`04o`000?ooooooooooooooo`Oo00007Oooool00ol0003oooooooooo`0Aoooo
o`03o`000?oooooooooo00Wooooo00Co0000oooooooooooo00000_ooool3o`000003ooooool0003o
0000013o000000?oooooo`000?l000003Ol00002ooooo`?o00000_ooool00ol0003oooooooooo`03
ooooo`04o`000?ooooooooooo`0000oooooo1?l0000Aooooo`03o`000?oooooooooo00Oooooo0ol0
00001?oooooo0000o`000?ooool9o`0000;ooooo00?o0000ooooool000004ol0000Gooooo`007?oo
ool00ol0003oooooooooo`0=ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool00_oo
ool3o`0000cooooo00?o0000ooooool000000oooool2o`000004ooooool0003o0000o`0000oooooo
00?o0000ooooooooool02Ol000000ooooooo0000o`000004o`0001Kooooo0_l0000Eooooo`_o0000
0_ooool3o`0001Gooooo00?o0000ooooooooool07Oooool01?l0003oooooooooool00002ooooo`03
o`000?oooooooooo00Go000000?oooooo`000?l000002ol000001?oooooo0000o`000?ooool3o`00
0003ooooool0003o000000Go00000_ooool5o`000003ooooool0003ooooo00Cooooo00Co0000oooo
oooooooo00003oooool3o`00017ooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`02
o`0000;ooooo00?o0000ooooool000000_l000000ooooooo0000ooooo`05ooooo`03o`000?oooooo
0000017o00005_ooool001cooooo00?o0000ooooooooool03Oooool00ol0003oooooooooo`03oooo
o`03o`000?oooooooooo017ooooo00?o0000ooooool000006?ooool01?l0003oooooooooooooool@
o`0001Gooooo00?o0000ooooool000005Oooool9o`000005ooooool0003oooooooooool000005_oo
ool00ol0003oooooooooo`04ooooo`Go000000Goooooo`000?l0003o0000ooooo`02o`0000cooooo
1Ol00002ooooo`04o`000?oooooo0000ooooo`;o000000?oooooo`000?l000003Ol000000ooooooo
0000o`000003o`000003ooooool0003o000000Go00000_ooool8o`0000Cooooo0_l000000ooooooo
0000o`00000@ooooo`03o`000?oooooo0000013ooooo00?o0000ooooooooool02?ooool4o`0000Oo
oooo00?o0000ooooooooool02OoooolCo`0001Gooooo000Looooo`03o`000?oooooooooo01;ooooo
0ol00005ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool00oooool00ol0003ooooo
o`00000Booooo`03o`000?oooooooooo00;ooooo4?l0000Fooooo`03o`000?oooooooooo01Cooooo
2ol000000ooooooo0000ooooo`0Nooooo`03o`000?oooooooooo00;ooooo00Co0000oooooooooooo
00004Oooool01_l0003ooooooooooooooooo0000ooooo`;o00000_ooool2o`000004ooooool0003o
0000ooooo`Oo000000Goooooo`000?oooooo0000ooooo`06o`0000;ooooo0ol000000ooooooo0000
o`000007o`0001_ooooo00?o0000ooooooooool03_ooool00ol0003oooooooooo`0Booooo`?o0000
1?ooool4o`0000?ooooo00?o0000ooooooooool03ol0000Eooooo`007?ooool00ol0003ooooooooo
o`0Wooooo`03o`000?oooooooooo00?ooooo00?o0000ooooool000001?ooool2o`000003ooooool0
003o000000Ko00002Oooool?o`0001Kooooo00?o0000ooooooooool00_ooool3o`0000?ooooo1?l0
0009ooooo`go00006?ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00;ooooo00Co
0000oooooooooooo00004Oooool00ol0003oooooooooo`02ooooo`Oo000000?oooooo`000?l00000
0_ooool2o`000003ooooool0003ooooo00;o000000Coooooo`000?l0003ooooo0_l000000ooooooo
0000ooooo`06o`000003ooooool0003o000000So00006_ooool00ol0003oooooooooo`0Tooooo`03
o`000?oooooooooo00?o00000_ooool7o`000003ooooool0003o000000go00005Oooool001cooooo
00?o0000ooooooooool03?ooool00ol0003oooooooooo`0Hooooo`03o`000?oooooooooo00?ooooo
00?o0000ooooool000001?ooool01Ol0003ooooooooooooooooo000000?ooooo00?o0000oooooooo
ool02Oooool?o`0001[ooooo00Oo0000ooooooooooooooooo`000?oooooo000000;ooooo00Go0000
ooooooooooooooooo`000007ooooo`ko00005_ooool00ol0003oooooooooo`03ooooo`03o`000?oo
oooooooo00;ooooo00Co0000oooooooooooo00000_ooool00ol0003oooooooooo`0;ooooo`?o0000
1oooool2o`000003ooooool0003o000000Go000000Coooooo`000?oooooooooo1?l000000ooooooo
0000ooooo`05o`000003ooooool0003o000000?o000000?oooooo`000?l000000ol0000Nooooo`04
o`000?ooooooooooooooo`?o00000_ooool5o`0001Gooooo1?l000000ooooooo0000o`000005o`00
0005ooooool0003oooooooooool000000_ooool2o`000003ooooool0003o000000Wo00005_ooool0
01cooooo00?o0000ooooooooool03?ooool00ol0003oooooooooo`0Hooooo`03o`000?oooooooooo
00;ooooo00Go0000ooooooooooooooooo`000003ooooo`Go00000oooool00ol0003oooooooooo`0:
ooooo`go00006oooool01Ol0003ooooooooooooooooo000000;ooooo0ol00003ooooo`03o`000?oo
oooooooo00Kooooo3?l000000ooooooo0000ooooo`0Dooooo`;o00001?ooool01?l0003ooooooooo
ooooool4o`0000?ooooo00?o0000ooooooooool07_ooool6o`0000;ooooo2_l000000ooooooo0000
ooooo`08o`000003ooooool0003o000000?o00005Oooool01?l0003oooooooooool00003ooooo`;o
00001Oooool00ol0003oooooooooo`0Fooooo`03o`000?oooooo000000?o000000?oooooo`000?l0
00000_l000001?oooooo0000ooooooooool5o`000003ooooool0003o000000Wo00005_ooool001co
oooo00?o0000ooooooooool03?ooool00ol0003oooooo`00000Kooooo`03o`000?oooooo000000?o
oooo00?o0000ooooooooool00_ooool00ol0003oooooo`000004ooooo`03o`000?oooooooooo00co
oooo2ol000000ooooooo0000ooooo`0Aooooo`03o`000?oooooooooo00Cooooo00?o0000ooooool0
00001?l00002ooooo`05o`000?ooooooooooooooool000002Oooool>o`000003ooooool0003ooooo
00kooooo00?o0000ooooooooool00ol00003ooooo`03o`000?oooooooooo00Sooooo00?o0000oooo
ooooool08oooool00ol0003oooooooooo`0<o`000004ooooool0003o0000ooooo`Go000000Cooooo
o`000?oooooo00000_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo00;o000000Co
ooooo`000?l0003o00001Oooool00ol0003oooooooooo`0Fooooo`04o`000?oooooo0000ooooo`;o
000000Coooooo`000?l0003o00000_ooool5o`000004ooooool0003oooooooooo`oo00004_ooool0
01cooooo0_l0000=ooooo`03o`000?oooooo000001_ooooo00?o0000ooooool000000oooool00ol0
003oooooooooo`02ooooo`03o`000?oooooo000000Cooooo00?o0000ooooooooool00oooool00ol0
003oooooooooo`07ooooo`;o00000_ooool01Ol0003oooooo`000?l0003ooooo00Co00004Oooool0
0ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Cooooo0_l00004ooooo`03o`000?oooooo
oooo00Sooooo4?l00002ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooool000002Ol00008
ooooo`03o`000?oooooooooo02?ooooo00?o0000ooooool000002Ol00002ooooo`[o000000Cooooo
o`000?oooooo00000_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo00Oo00001?oo
ool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo017ooooo00Co0000ooooool0003ooooo
0_l000001Ooooooo0000o`000?l0003ooooo00;o00000_ooool4o`000005ooooool0003o0000o`00
0?ooool03_l0000@ooooo`007?ooool00ol0003oooooooooo`0<ooooo`03o`000?oooooo000001_o
oooo0_l0000:ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool00oooool00ol0003o
ooooooooo`07ooooo`;o00000_ooool:o`0000Oooooo00?o0000ooooooooool01_ooool01?l0003o
ooooooooool00003ooooo`05o`000?ooooooooooooooool000002?ooool00ol0003oooooooooo`09
ooooo`03o`000?oooooo0000013o00001?ooool00ol0003oooooooooo`03ooooo`03o`000?oooooo
000000Go00003?ooool00ol0003oooooooooo`0Sooooo`03o`000?oooooooooo00Cooooo1Ol00002
ooooo`03o`000?oooooooooo00;ooooo0_l000001ooooooo0000o`000?oooooo0000ooooool00000
0_ooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo00Wo00000oooool00ol0003ooooo
ooooo`02ooooo`03o`000?oooooooooo00oooooo00?o0000ooooool000001ol000000ooooooo0000
ooooo`02o`0000;ooooo00?o0000ooooool000000_l00002ooooo`Co00000_ooool3o`000004oooo
ool0003o0000o`0000?ooooo00Go0000ooooool0003oooooo`00000;ooooo`007?ooool00ol0003o
ooooooooo`0<ooooo`03o`000?oooooo000001_ooooo0ol00008ooooo`;o00000oooool3o`0000Go
oooo00?o0000ooooooooool02?ooool01?l0003oooooooooool00002ooooo`So00001Oooool3o`00
0003ooooool0003ooooo00Cooooo00Co0000oooooooooooo00001?ooool3o`0000Wooooo00?o0000
ooooooooool03?ooool00ol0003oooooo`00000=o`0000?ooooo0ol00003ooooo`03o`000?oooooo
000000Ko00003?ooool00ol0003oooooooooo`0Sooooo`05o`000?ooooooooooooooool000001?oo
ool4o`00000:ooooool0003o0000ooooool0003oooooo`000?oooooo0000ooooo`;o000000?ooooo
o`000?l000000_l000000ooooooo0000o`000005o`0000cooooo00?o0000ooooool000002Ol00003
ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool03oooool01?l0003oooooo`000?oo
ool4o`000003ooooool0003o000000Wo00000_ooool3o`0000;ooooo00?o0000ooooooooool01?l0
00000ooooooo0000ooooo`06o`000003ooooool0003o000000;o00002?ooool001cooooo00?o0000
ooooooooool03_ooool00ol0003oooooooooo`0Fooooo`03o`000?oooooo000000Co00005?ooool0
0ol0003oooooooooo`09ooooo`?o00000_ooool8o`0000Cooooo1ol00004ooooo`04o`000?oooooo
ooooo`0001oooooo00?o0000ooooool000003_l000000ooooooo0000o`000003o`0000;ooooo00?o
0000ooooooooool01_l0000cooooo`?o00001?ooool2o`0000?ooooo1Ol000001_oooooo0000oooo
ool0003oooooo`0000?ooooo0_l00002ooooo`05o`000?ooooooooooooooool000003_ooool<o`00
0004ooooool0003o0000o`0000Cooooo00?o0000ooooooooool03oooool5o`000003ooooool0003o
000000?ooooo0_l000000ooooooo0000ooooo`08ooooo`04o`000?ooooooooooo`0000;ooooo2?l0
0002ooooo`Go000000?oooooo`000?ooool02?ooool001cooooo00?o0000ooooooooool03_ooool0
0ol0003oooooooooo`0Fooooo`So00004oooool00ol0003oooooooooo`0<ooooo`;o000000?ooooo
o`000?l000004Ol00003ooooo`04o`000?ooooooooooooooo`;o00007?ooool01?l0003oooooo`00
0?ooool>o`000003ooooool0003o000000Co000000?oooooo`000?ooool00_ooool4o`0004Cooooo
1Ol000001?oooooo0000o`000?ooool3o`0000;ooooo00Go0000ooooooooooooooooo`00000@oooo
o`Wo00002Oooool00ol0003oooooooooo`0Iooooo`;o000000Coooooo`000?l0003o00001oooool4
o`000003ooooool0003o000000?o00000_ooool:o`000003ooooool0003ooooo00Sooooo000Loooo
o`03o`000?oooooooooo02Oooooo2?l00002ooooo`03o`000?oooooooooo00kooooo00?o0000oooo
ooooool02oooool00ol0003oooooooooo`02ooooo`Oo000000?oooooo`000?l000002Ol00006oooo
o`?o00006oooool01Ol0003oooooo`000?oooooo000000;ooooo4_l00005ooooo`?o0000Boooool3
o`0000;ooooo1Ol00002ooooo`03o`000?oooooooooo00oooooo1ol0000:ooooo`03o`000?oooooo
oooo02cooooo1?l000000ooooooo0000o`000002o`0000;ooooo0_l000001Ooooooo0000oooooooo
oooo000000Wooooo000Looooo`03o`000?oooooooooo02Oooooo2?l00002ooooo`03o`000?oooooo
oooo01cooooo00Go0000oooooooooooo0000ooooo`0Co`0000Gooooo1?l0000Jooooo`;o000000Go
ooooo`000?l0003oooooo`000002ooooo`03o`000?oooooo000000Oo000000?oooooo`000?l00000
1?l00006ooooo`03o`000?oooooo000004Wooooo4?l0000@ooooo`;o00000_ooool00ol0003ooooo
ooooo`0iooooo`Ko000000Koooooo`000?l0003o0000ooooool00002ooooo`?o00002Oooool001co
oooo00?o0000ooooooooool03?ooool00ol0003oooooooooo`0Hooooo`03o`000?oooooo000000Co
00000oooool2o`0001kooooo0ol000000ooooooo0000o`00000Ao`0000Cooooo1_l0000<ooooo`03
o`000?oooooooooo017ooooo00Co0000ooooool0003ooooo1_l000000ooooooo0000o`000005o`00
01Oooooo00?o0000ooooooooool0>Oooool>o`0001?ooooo00?o0000ooooooooool0@?ooool5o`00
0003ooooool0003o000000Cooooo00?o0000ooooooooool01oooool001cooooo00?o0000oooooooo
ool03?ooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo017ooooo00?o0000oooooooo
ool00ol00004ooooo`?o00007oooool00ol0003oooooo`00000Ao`0000Cooooo1ol0000<ooooo`03
o`000?oooooooooo01;ooooo0_l000001?oooooo0000o`000?ooool6o`000004ooooool0003o0000
o`0001Sooooo00?o0000ooooooooool0>?ooool>o`000003ooooool0003o000000cooooo00?o0000
ooooooooool01oooool00ol0003oooooooooo`0nooooo`04o`000?ooooooooooooooo`;o00000_oo
ool2o`0000Wooooo000Looooo`03o`000?oooooooooo00cooooo00Co0000oooooooooooo00000_oo
ool3o`0001Kooooo00?o0000ooooooooool00_ooool4o`0001oooooo00?o0000ooooool000003?l0
00001?oooooo0000o`000?l00003ooooo`03o`000?oooooooooo00Ko00003?ooool00ol0003ooooo
ooooo`0?ooooo`04o`000?ooooooooooooooo`Co00000_ooool:o`0000;ooooo00?o0000oooooooo
ool02Oooool3o`0000;ooooo0ol000000ooooooo0000o`00000jooooo`go00003oooool00ol0003o
ooooooooo`07ooooo`;o00000_ooool4o`0000;ooooo1Ol00015ooooo`007?ooool00ol0003ooooo
ooooo`0<ooooo`05o`000?ooooooooooo`000?ooool01Ol0000Iooooo`Ko00003?ooool00ol0003o
ooooooooo`0?oooooa?o000000Coooooo`000?l0003o00000oooool4o`0000gooooo00?o0000oooo
ooooool03oooool8o`0000;ooooo00?o0000ooooool000001?l000000ooooooo0000ooooo`03o`00
0003ooooool0003ooooo00Cooooo0ol000001Ooooooo0000oooooooooooo000000;ooooo00Co0000
ooooool0003o0000??ooool;o`00013ooooo00?o0000ooooooooool01oooool4o`000003ooooool0
003ooooo00Co000000?oooooo`000?ooool0;_ooool00ol0003oooooooooo`0Eooooo`007?ooool2
o`0000gooooo00?o0000ooooooooool02?l0000Gooooo`Oo00000oooool3o`0000Kooooo00?o0000
ooooooooool05Oooool3o`000003ooooool0003o000000;ooooo00Go0000oooooooooooo0000oooo
o`02o`000003ooooool0003ooooo00?ooooo0_l0000>ooooo`03o`000?oooooooooo01;ooooo0_l0
00000ooooooo0000o`00000=o`000003ooooool0003o000000Go000000Goooooo`000?oooooooooo
o`000003ooooo`05o`000?ooooooooooo`000?ooool00_l0000looooo`_o00003oooool00ol0003o
ooooooooo`07ooooo`Go000000Koooooo`000?ooooooooooo`000?ooool3o`0002oooooo00?o0000
ooooooooool05Oooool001cooooo00?o0000ooooooooool03?ooool00ol0003oooooooooo`08o`00
01Sooooo1_l00006ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool05_ooool00ol0
003oooooooooo`02o`0000;ooooo00Go0000oooooooooooo0000ooooo`04o`000003ooooool0003o
oooo00Go00003?ooool00ol0003oooooooooo`0Eooooo`;o000000?oooooo`000?l000002?l00000
1?oooooo0000o`000?ooool2o`000005ooooool0003o0000o`000?ooool01?l000000ooooooo0000
o`000003ooooo`04o`000?oooooo0000o`0003gooooo00?o0000ooooooooool00_l00002ooooo`04
o`000?oooooo0000o`0000kooooo00?o0000ooooooooool01oooool:o`000004ooooool0003o0000
o`0002oooooo00?o0000ooooooooool05Oooool001cooooo00?o0000ooooooooool03oooool8o`00
013ooooo00?o0000ooooooooool01_ooool7o`000003ooooool0003o000000;o00001Oooool00ol0
003oooooooooo`0Iooooo`05o`000?ooooooooooooooool000000_ooool00ol0003oooooo`000003
o`000006ooooool0003o0000o`000?oooooo00000_ooool2o`000003ooooool0003ooooo01oooooo
00Co0000oooooooooooooooo3?l000000ooooooo0000o`000002ooooo`03o`000?oooooo000000Go
00001?ooool4o`0004;ooooo00?o0000ooooooooool00_ooool3o`0000gooooo00?o0000oooooooo
ool01_ooool8o`0000;ooooo1Ol0000_ooooo`03o`000?oooooooooo01Gooooo000Looooo`03o`00
0?oooooooooo00oooooo00?o0000ooooool000001?l0000Aooooo`03o`000?oooooooooo00Oooooo
0_l00002ooooo`03o`000?oooooo000000?ooooo00?o0000ooooooooool00oooool00ol0003ooooo
ooooo`0Iooooo`06o`000?oooooo0000ooooool0003ooooo1?l000000ooooooo0000o`000002o`00
00;ooooo1?l00002ooooo`03o`000?oooooooooo02?ooooo00?o0000ooooool000003ol000000ooo
oooo0000o`000004o`0000;ooooo00?o0000ooooooooool0BOooool5o`0001Kooooo1ol00002oooo
o`?o0000<Oooool00ol0003oooooooooo`0Eooooo`007?ooool00ol0003oooooooooo`0Booooo`?o
00004_ooool00ol0003oooooooooo`07ooooo`;o00000_ooool00ol0003oooooo`000003ooooo`03
o`000?oooooooooo00?ooooo00?o0000ooooooooool06Oooool2o`000004ooooool0003o0000o`00
00?ooooo2?l000001?oooooo0000o`000?l00002ooooo`03o`000?oooooo000000;o00000oooool3
o`0001_ooooo1_l000001?oooooo0000o`000?ooool2o`0000;ooooo0ol000000ooooooo0000o`00
0008o`0004[ooooo3?l000001?oooooo0000o`000?l0000=ooooo`[o00000_ooool00ol0003ooooo
ooooo`0]ooooo`03o`000?oooooooooo01Gooooo000Looooo`03o`000?oooooooooo01?ooooo00?o
0000ooooooooool04Oooool00ol0003oooooooooo`07ooooo`;o00000_ooool00ol0003oooooo`00
0003ooooo`03o`000?oooooooooo01oooooo00Co0000oooooooooooooooo0_l00002ooooo`;o0000
00?oooooo`000?l000000_l000000ooooooo0000o`000003o`0000;ooooo0_l00003ooooo`03o`00
0?oooooo0000027ooooo1?l000000ooooooo0000ooooo`02o`0000;ooooo00?o0000ooooool00000
2Ol0001<ooooo`go00004?ooool5o`0000;ooooo0_l0001;ooooo`007?ooool00ol0003ooooooooo
o`0<ooooo`03o`000?oooooooooo01Sooooo00?o0000ooooooooool01oooool3o`000004ooooool0
003oooooooooo`Go00009?ooool01Ol0003oooooooooool0003ooooo00Ko00000_ooool01Ol0003o
ooooo`000?l0003ooooo00?o00000oooool00ol0003oooooo`000004o`00027ooooo2Ol00002oooo
o`Wo00001Oooool00ol0003oooooooooo`14oooooa3o00003Oooool00ol0003oooooooooo`1@oooo
o`007?ooool00ol0003oooooooooo`0<ooooo`05o`000?ooooooooooooooool000000oooool00ol0
003oooooooooo`0@ooooo`03o`000?oooooooooo00Oooooo1Ol00003ooooo`?o00000_ooool5o`00
01kooooo1?l000001Ooooooo0000o`000?l0003ooooo00?o000000?oooooo`000?l000001Oooool0
0ol0003oooooo`000004o`0000;ooooo0_l0000Sooooo`Co000000?oooooo`000?l000000oooool9
o`0000Cooooo00?o0000ooooooooool0A?ooool@o`000003ooooool0003ooooo00cooooo00?o0000
ooooooooool0C_ooool001cooooo00?o0000ooooooooool03?ooool00ol0003oooooooooo`03o`00
00;ooooo00Co0000oooooooooooooooo1?l0000Eooooo`04o`000?oooooo0000ooooo`;o00000_oo
ool01?l0003oooooooooool00003ooooo`03o`000?oooooooooo01kooooo00Co0000oooooooooooo
00000_ooool3o`000003ooooool0003o000000;o00001_ooool00ol0003oooooooooo`04ooooo`?o
00008oooool6o`0000Kooooo2?l00004ooooo`03o`000?oooooooooo04;ooooo00?o0000ooooool0
00003_l00002ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool0C_ooool001cooooo
00?o0000ooooooooool03?ooool00ol0003oooooo`000004o`000003ooooool0003ooooo00?ooooo
00Co0000oooooooooooo00005_ooool00ol0003oooooooooo`06ooooo`04o`000?oooooooooooooo
o`;o00007oooool00ol0003oooooooooo`02o`000004ooooool0003o0000o`0000_ooooo00Go0000
ooooooooooooooooo`000004ooooo`03o`000?oooooooooo023ooooo1ol00003ooooo`_o00001?oo
ool00ol0003oooooooooo`12ooooo`04o`000?oooooo0000ooooo`ko000000?oooooo`000?ooool0
3?ooool01?l0003oooooooooooooool3o`0000Cooooo0ol0000[ooooo`03o`000?oooooooooo01Go
oooo000Looooo`03o`000?oooooooooo00cooooo2Ol00004ooooo`04o`000?ooooooooooo`0001go
oooo0_l00004ooooo`;o00007_ooool5o`000003ooooool0003o000000?o00001_ooool00ol0003o
ooooooooo`02ooooo`?o00001Oooool00ol0003oooooooooo`0Qooooo`Ko00000_ooool01?l0003o
ooooooooool00002ooooo`Go00001Oooool00ol0003oooooooooo`12oooooa;o000000?oooooo`00
0?ooool03Oooool01?l0003oooooooooooooool2o`0000?ooooo00Go0000ooooooooooooooooo`00
000Zooooo`03o`000?oooooooooo01Gooooo000Looooo`;o00003Oooool9o`0000Cooooo0ol0000M
ooooo`03o`000?oooooooooo00;ooooo1?l0000Sooooo`Oo00001Oooool00ol0003oooooooooo`0:
ooooo`03o`000?oooooooooo02;ooooo1?l00003ooooo`04o`000?ooooooooooo`0000?ooooo0ol0
0006ooooo`03o`000?oooooooooo04Cooooo4?l000000ooooooo0000ooooo`0=ooooo`;o00000_oo
ool2o`0000?ooooo00Go0000ooooooooooooooooo`00000Zooooo`03o`000?oooooooooo01Gooooo
000Looooo`03o`000?oooooooooo00gooooo2?l00004ooooo`04o`000?ooooooooooo`0000[ooooo
00?o0000ooooooooool03oooool01?l0003oooooooooool00004ooooo`03o`000?oooooooooo023o
oooo2?l00005ooooo`05o`000?ooooooooooooooool00000;_ooool4o`0000;ooooo00Co0000oooo
oooooooo00001?ooool2o`0000;ooooo0ol00002ooooo`Co0000Aoooool3o`000003ooooool0003o
000000Oo00003_ooool3o`000004ooooool0003o0000o`0000;ooooo00Go0000oooooooooooooooo
o`00000[ooooo`03o`000?oooooooooo01Cooooo000Looooo`03o`000?oooooooooo00kooooo1Ol0
0006ooooo`04o`000?ooooooooooo`0000[ooooo00?o0000ooooooooool04?ooool3o`0000?ooooo
0_l0000Sooooo`Oo00001_ooool00ol0003oooooo`000002o`0002kooooo00Co0000oooooooooooo
00000_ooool3o`0000Gooooo00Co0000oooooooooooo00000_ooool01?l0003oooooooooool00002
ooooo`03o`000?oooooooooo04Gooooo00?o0000ooooool000000oooool2o`0000Cooooo00?o0000
ooooooooool02_ooool7o`000004ooooool0003oooooooooo`?o0000;?ooool00ol0003ooooooooo
o`0Dooooo`007?ooool00ol0003oooooooooo`0?ooooo`?o00001_ooool4o`0000_ooooo00?o0000
ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo02;ooooo1Ol00006
ooooo`Oo0000;Oooool01?l0003oooooooooool00004ooooo`03o`000?oooooooooo00Wooooo00Co
0000oooooooooooo00000_ooool00ol0003oooooooooo`17ooooo`04o`000?ooooooooooooooo`;o
000000Coooooo`000?l0003o00003?ooool8o`000003ooooool0003ooooo033ooooo00?o0000oooo
ooooool05?ooool001cooooo00?o0000ooooooooool04?ooool00ol0003oooooooooo`0Cooooo`03
o`000?oooooooooo00_ooooo00?o0000ooooooooool0<?ooool3o`0000Kooooo2Ol0000[ooooo`Co
00001?ooool2o`0000Wooooo1_l00002ooooo`?o0000Aoooool01ol0003ooooooooooooooooo0000
ooooool000003_ooool:o`0004Wooooo000Looooo`03o`000?oooooooooo00cooooo00?o0000oooo
ooooool05oooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo037ooooo00?o0000oooo
ooooool01?ooool:o`0000Cooooo00?o0000ooooooooool0;Oooool2o`0000?ooooo1Ol00003oooo
o`03o`000?oooooo000000;o0000B_ooool01_l0003ooooooooooooooooo0000ooooo`Go00001?oo
ool2o`0000Gooooo1ol0001;ooooo`007?ooool00ol0003oooooooooo`0<ooooo`03o`000?oooooo
oooo00Kooooo00?o0000ooooooooool03_ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooo
oooo03Oooooo2ol00004ooooo`03o`000?oooooooooo02cooooo00Ko0000oooooooooooo0000oooo
ool00002ooooo`03o`000?oooooo000000;ooooo0_l000000ooooooo0000ooooo`05o`0004Kooooo
00Co0000oooooooooooooooo1Ol000001_oooooo0000o`000?l0003oooooo`0000;ooooo00?o0000
ooooooooool00oooool5o`0004cooooo000Looooo`03o`000?oooooooooo00cooooo00?o0000oooo
ooooool01_ooool00ol0003oooooooooo`0Looooo`05o`000?ooooooooooooooool00000=_ooool9
o`0000Gooooo00?o0000ooooooooool0:oooool00ol0003oooooooooo`03ooooo`03o`000?oooooo
oooo00;o000000?oooooo`000?l000001?l000000ooooooo0000ooooo`02ooooo`03o`000?oooooo
oooo04Gooooo0ol00002ooooo`03o`000?oooooo000000;ooooo0_l000001?oooooo0000o`000?l0
0002ooooo`;o000000?oooooo`000?ooool00ol0001=ooooo`0000Coooooo`000?l0003o00001?oo
ool2o`0000Cooooo0_l00004ooooo`;o00001_ooool00ol0003oooooooooo`0;ooooo`03o`000?oo
oooooooo00Oooooo1Ol00003ooooo`?o00005Oooool00ol0003oooooo`000002o`0000Oooooo00?o
0000ooooooooool0:_ooool9o`000003ooooool0003o000000?ooooo00?o0000ooooooooool0:ooo
ool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00?o000000Koooooo`000?oooooo0000
ooooool00002ooooo`?o0000COooool00ol0003oooooo`000003o`0000;ooooo0_l00002ooooo`04
o`000?ooooooooooo`0000?ooooo00Go0000ooooool0003oooooo`00000cooooo`03o`000?oooooo
oooo01Cooooo0002ooooo`03o`000?oooooooooo00;ooooo00Co0000oooooooooooo00000_ooool0
1?l0003oooooooooool00002ooooo`04o`000?ooooooooooo`0000Gooooo00?o0000ooooooooool0
2oooool00ol0003oooooooooo`08ooooo`;o00000_ooool00ol0003oooooo`00000Gooooo`Oo0000
1_ooool00ol0003oooooooooo`0Zooooo`03o`000?oooooooooo00?o000000Goooooo`000?l0003o
ooooo`000004ooooo`03o`000?oooooooooo02_ooooo00?o0000ooooooooool01?ooool7o`000004
ooooool0003oooooo`0005;ooooo1?l000000ooooooo0000o`000004o`000005ooooool0003ooooo
ooooool000001Oooool00ol0003oooooo`00000cooooo`03o`000?oooooooooo01Cooooo0002oooo
o`03o`000?oooooooooo00;ooooo00Co0000oooooooooooo00000_ooool01?l0003oooooooooool0
0002ooooo`04o`000?ooooooooooo`0000Gooooo0ol0000;ooooo`03o`000?oooooooooo00Sooooo
0_l00002ooooo`03o`000?oooooo000000Co00004_ooool9o`0000Gooooo00?o0000ooooooooool0
:oooool01?l0003oooooooooool00002ooooo`;o000000?oooooo`000?ooool00oooool00ol0003o
ooooooooo`0/ooooo`04o`000?ooooooooooo`0000Cooooo2Ol0001Booooo`Wo00000oooool01?l0
003oooooooooool00005ooooo`03o`000?oooooo000003?ooooo00?o0000ooooooooool05?ooool0
00;ooooo00?o0000ooooooooool00_ooool01?l0003oooooooooool00002ooooo`04o`000?oooooo
ooooo`0000;ooooo00Co0000oooooooooooo00001Oooool00ol0003oooooooooo`0Fooooo`Co0000
0_ooool01Ol0003ooooooooooooooooo000000Gooooo00?o0000ooooooooool02Oooool:o`0000Go
oooo00?o0000ooooooooool0;?ooool00ol0003oooooooooo`02ooooo`04o`000?ooooooooooo`00
03Cooooo0ol00003ooooo`Ko0000EOooool8o`000004ooooool0003oooooooooo`;o000000?ooooo
o`000?l000001_ooool00ol0003oooooooooo`02o`000004ooooool0003o0000o`0000;ooooo0_l0
000Xooooo`03o`000?oooooooooo01Cooooo0002ooooo`03o`000?oooooooooo00;ooooo00Co0000
oooooooooooo00000_ooool01?l0003oooooooooool00002ooooo`04o`000?ooooooooooo`0000Go
oooo00?o0000ooooooooool05oooool01?l0003oooooooooool00002ooooo`?o00001_ooool00ol0
003oooooooooo`08ooooo`_o00001Oooool00ol0003oooooooooo`0]ooooo`03o`000?oooooooooo
00Co00001?ooool3o`0000?ooooo0ol0000]ooooo`Oo0000E?ooool8o`000003ooooool0003ooooo
00cooooo0ol000000ooooooo0000ooooo`02ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000
ooooooooool09Oooool00ol0003oooooooooo`0Dooooo`0000?oooooo`000?l000001?ooool01?l0
003oooooooooool00002ooooo`04o`000?ooooooooooo`0000;ooooo00Co0000oooooooooooo0000
1Oooool00ol0003oooooooooo`0Gooooo`04o`000?ooooooooooo`0000_ooooo00?o0000oooooooo
ool02Oooool9o`0000Kooooo00?o0000ooooooooool0:_ooool01Ol0003ooooooooooooooooo0000
00Gooooo0_l000000ooooooo0000o`000005o`00037ooooo1_l0001Eooooo`Wo00003?ooool:o`00
00;ooooo00?o0000ooooooooool0:?ooool00ol0003oooooooooo`0Dooooo`000_ooool00ol0003o
ooooooooo`03ooooo`;o00001?ooool2o`0000Cooooo0_l00006ooooo`03o`000?oooooooooo01Ko
oooo1?l0000<ooooo`03o`000?oooooooooo00[ooooo1ol0000dooooo`Go00001Oooool01Ol0003o
oooooooooooooooo000000;ooooo00?o0000ooooool000001?l0000^ooooo`Co0000Eoooool5o`00
00oooooo1ol000000ooooooo0000ooooo`02ooooo`03o`000?oooooooooo03oooooo000Looooo`03
o`000?oooooooooo00_ooooo00?o0000ooooooooool06?ooool00ol0003oooooooooo`0;ooooo`?o
000000?oooooo`000?ooool0?Oooool;o`0000?ooooo00?o0000ooooooooool0;Oooool2o`0000;o
oooo00?o0000ooooooooool0E?ooool3o`0000oooooo2?l000001?oooooo0000ooooooooool4o`00
03oooooo000Looooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool02?ooool2o`0000ko
oooo00?o0000ooooooooool03?ooool00ol0003oooooooooo`0oooooo`04o`000?oooooo0000oooo
o`Co00000oooool3o`00037ooooo00Co0000oooooooooooo0000Eoooool00ol0003oooooooooo`0?
ooooo`Ko000000?oooooo`000?ooool00oooool00ol0003oooooooooo`0oooooo`007?ooool00ol0
003oooooooooo`0;ooooo`03o`000?oooooooooo00Sooooo0ol0001Nooooo`04o`000?oooooo0000
ooooo`?o000000?oooooo`000?l000000_l0000dooooo`03o`000?oooooo000006Cooooo0ol00003
ooooo`Co000000?oooooo`000?l000001?ooool00ol0003oooooooooo`0oooooo`007?ooool00ol0
003oooooooooo`0;ooooo`03o`000?oooooooooo00Oooooo1?l0000Pooooo`03o`000?oooooooooo
00;ooooo0ol0000gooooo`03o`000?oooooo000000;ooooo0ol0000gooooo`03o`000?oooooo0000
06Oooooo00?o0000ooooooooool00ol0000cooooo`03o`000?oooooooooo01Cooooo000Looooo`03
o`000?oooooooooo00_ooooo00?o0000ooooooooool01_ooool6o`0001oooooo00?o0000oooooooo
ool00_ooool01?l0003oooooo`000?l0000fooooo`?o00000_ooool00ol0003oooooooooo`0goooo
o`03o`000?oooooo000000Go0000F?ooool3o`000004ooooool0003o0000ooooo`Co00000oooool0
0ol0003oooooooooo`0booooo`03o`000?oooooooooo01Cooooo000Looooo`03o`000?oooooooooo
00_ooooo00?o0000ooooooooool01Oooool7o`0001oooooo1?l00003ooooo`;o0000>oooool00ol0
003oooooooooo`0hooooo`;o00000_ooool00ol0003oooooooooo`1Iooooo`06o`000?oooooooooo
o`000?oooooo00000oooool00ol0003oooooooooo`0fooooo`03o`000?oooooooooo01Cooooo000L
ooooo`;o00005Oooool6o`0000cooooo00?o0000ooooooooool04Oooool2o`0000?ooooo0_l0001g
ooooo`05o`000?ooooooooooooooool00000Foooool01_l0003oooooooooool0003oooooo`0000?o
oooo00?o0000ooooooooool0=oooool00ol0003oooooooooo`0Cooooo`007?ooool00ol0003ooooo
ooooo`0Eooooo`Co00003Oooool00ol0003oooooooooo`0Aooooo`;o00000_ooool00ol0003ooooo
o`00000hooooo`03o`000?oooooooooo03cooooo00Go0000ooooooooooooooooo`00001Kooooo`Co
000000?oooooo`000?ooool00_ooool00ol0003oooooooooo`07ooooo`?o00000_ooool4o`000003
ooooool0003o000002Cooooo00?o0000ooooooooool04oooool001cooooo00?o0000ooooooooool0
5_ooool2o`0000kooooo00?o0000ooooooooool04_ooool4o`000003ooooool0003o000003Kooooo
0ol00011ooooo`03o`000?oooooooooo05Wooooo00Co0000oooooooooooo00000_ooool5o`0000Wo
oooo00Co0000oooooooooooo00000_ooool01?l0003oooooooooool0000Uooooo`03o`000?oooooo
oooo01?ooooo000Looooo`03o`000?oooooooooo01Oooooo00?o0000ooooooooool03?ooool00ol0
003oooooooooo`0Booooo`03o`000?oooooooooo00Co0000=Oooool4o`00047ooooo00?o0000oooo
ooooool0FOooool01?l0003oooooooooool0000@ooooo`03o`000?oooooo000000?ooooo00Co0000
oooooooooooo0000>oooool001cooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`09
ooooo`03o`000?oooooooooo00cooooo00?o0000ooooooooool04_ooool01?l0003oooooooooool0
000gooooo`Ko000000?oooooo`000?ooool0>_ooool6o`0005Sooooo0ol000000ooooooo0000o`00
000?ooooo`?o00000oooool01?l0003oooooooooool0000kooooo`007?ooool00ol0003ooooooooo
o`0;ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool03?ooool00ol0003ooooooooo
o`0Aooooo`Co0000=oooool7o`000003ooooool0003ooooo03Wooooo0ol0001aooooo`05o`000?oo
ooooooooo`000?ooool01?l0000looooo`007?ooool00ol0003oooooooooo`0;ooooo`03o`000?oo
oooooooo00Wooooo00?o0000ooooooooool00oooool2o`0001cooooo00?o0000ooooooooool0>?oo
ool6o`000003ooooool0003ooooo03Sooooo1Ol0001`ooooo`04o`000?ooooooooooo`00047ooooo
000Looooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool02_ooool01Ol0003ooooooooo
oooooooo000000;ooooo00?o0000ooooooooool06Oooool00ol0003oooooooooo`02ooooo`03o`00
0?oooooooooo03Cooooo1?l00002ooooo`03o`000?oooooooooo03Kooooo1ol0001^ooooo`Co0000
;?ooool00ol0003oooooooooo`0Cooooo`007?ooool00ol0003oooooooooo`0;ooooo`03o`000?oo
oooooooo00[ooooo00Co0000oooooooooooo00007oooool00ol0003oooooooooo`02ooooo`03o`00
0?oooooooooo03Gooooo0_l00003ooooo`03o`000?oooooooooo03Gooooo2?l0002Nooooo`03o`00
0?oooooooooo01?ooooo000Looooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool02_oo
ool01?l0003oooooooooool0000Oooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0
=_ooool01Ol0003ooooooooooooooooo000003Sooooo1ol0002Nooooo`03o`000?oooooooooo01?o
oooo000Looooo`;o00007?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo01;ooooo
00?o0000ooooooooool00_ooool00ol0003oooooooooo`1dooooo`Go0000Woooool00ol0003ooooo
ooooo`0Cooooo`007?ooool00ol0003oooooooooo`0Looooo`04o`000?ooooooooooo`0000Kooooo
00?o0000ooooooooool04_ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo07Gooooo
0ol0002Pooooo`03o`000?oooooooooo01?ooooo000Looooo`03o`000?oooooooooo01gooooo0ol0
0006ooooo`03o`000?oooooooooo01Oooooo00?o0000ooooooooool0??ooool4o`0000;ooooo0ol0
000aooooo`03o`000?oooooooooo09oooooo00?o0000ooooooooool04oooool001cooooo00?o0000
ooooooooool09_ooool00ol0003oooooooooo`0Cooooo`03o`000?oooooooooo03_ooooo00?o0000
ooooooooool00oooool01?l0003oooooooooool00002ooooo`03o`000?oooooooooo0>Sooooo000L
ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`0:
ooooo`03o`000?oooooooooo01;ooooo0ol0000looooo`03o`000?oooooo000000?ooooo00Co0000
oooooooooooo00000_ooool00ol0003oooooooooo`3Xooooo`007?ooool00ol0003oooooooooo`0;
ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0A
ooooo`Go0000>oooool00ol0003oooooo`000003ooooo`?o00000oooool2o`0003Oooooo0_l00000
0ooooooo0000o`000002ooooo`?o0000Z?ooool001cooooo00?o0000ooooooooool02oooool00ol0
003oooooooooo`0;ooooo`03o`000?oooooooooo01gooooo1ol0000kooooo`;o00000oooool01Ol0
003oooooooooool0003ooooo00;o000000?oooooo`000?l00000=_ooool00ol0003oooooo`000002
ooooo`03o`000?oooooooooo09?ooooo00?o0000ooooooooool04oooool001cooooo00?o0000oooo
ooooool02oooool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo01_ooooo2Ol0000joooo
o`;o00000oooool01?l0003oooooooooool0000mooooo`04o`000?ooooooooooooooo`Go0000T?oo
ool3o`0001Cooooo000Looooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool03?ooool0
0ol0003oooooooooo`0Looooo`So0000>_ooool2o`0000;ooooo1?l0000nooooo`05o`000?oooooo
ooooooooool000000oooool00ol0003oooooooooo`2=ooooo`Go00004oooool001cooooo00?o0000
ooooooooool01_ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00_ooooo0ol00000
0ooooooo0000ooooo`0Kooooo`Go000000?oooooo`000?ooool0>_ooool00ol0003oooooooooo`12
ooooo`03o`000?oooooooooo00;ooooo0ol0002@ooooo`Ko00004_ooool001cooooo00?o0000oooo
ooooool01Oooool3o`00013ooooo1ol00007ooooo`03o`000?oooooooooo01;ooooo0ol00002oooo
o`03o`000?oooooooooo07gooooo00?o0000ooooool00000UOooool7o`0001;ooooo000Looooo`;o
00001Oooool4o`0000oooooo2Ol00006ooooo`03o`000?oooooooooo01?ooooo00Go0000oooooooo
ooooooooo`00001nooooo`;o000000?oooooo`000?l00000UOooool6o`0001;ooooo000Looooo`03
o`000?oooooooooo00?ooooo1_l0000=ooooo`_o00001Oooool00ol0003oooooooooo`0Gooooo`03
o`000?oooooooooo0?oooooo6?ooool4o`0001?ooooo000Looooo`03o`000?oooooooooo00;ooooo
1ol0000>ooooo`[o00001Oooool00ol0003oooooooooo`1Cooooo`03o`000?oooooooooo0=_ooooo
0ol0000Dooooo`007?ooool00ol0003oooooooooo`03ooooo`Ko00000_ooool00ol0003ooooooooo
o`0:ooooo`Wo00001Oooool00ol0003oooooooooo`0Kooooo`;o00000_ooool5o`0002kooooo0ol0
003Mooooo`03o`000?oooooooooo01?ooooo000Looooo`03o`000?oooooooooo00Cooooo1?l00003
ooooo`03o`000?oooooooooo00_ooooo1ol00006ooooo`03o`000?oooooooooo01[ooooo00Co0000
oooooooooooo00000oooool00ol0003oooooooooo`0]ooooo`Go0000l_ooool001cooooo00?o0000
ooooooooool01Oooool2o`0000Cooooo00?o0000ooooooooool03?ooool00ol0003oooooo`000002
o`0001kooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`05ooooo`03o`000?oooooo
oooo02cooooo1ol0003aooooo`007?ooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo
00;ooooo00?o0000ooooooooool03oooool2o`0001kooooo00Ko0000oooooooooooo0000ooooool0
0007ooooo`03o`000?oooooooooo02_ooooo2?l0003Qooooo`?o000000Coooooo`000?oooooooooo
0ol00006ooooo`007?ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo02oooooo00Ko
0000oooooooooooo0000ooooool00007ooooo`03o`000?oooooooooo02cooooo1ol0003Rooooo`06
o`000?ooooooooooo`000?oooooo00000oooool00ol0003oooooooooo`03ooooo`007?ooool00ol0
003oooooooooo`0;ooooo`03o`000?oooooooooo013ooooo0ol000000ooooooo0000ooooo`0Joooo
o`03o`000?oooooo000000;ooooo00Co0000oooooooooooo00000oooool00ol0003oooooooooo`0]
ooooo`Go0000hoooool01_l0003oooooo`000?l0003oooooo`0000?ooooo00?o0000ooooooooool0
0oooool001cooooo00?o0000ooooooooool01_ooool01?l0003oooooooooooooool3o`000003oooo
ool0003o000000oooooo00Co0000oooooooooooo00000oooool00ol0003oooooooooo`0Eooooo`;o
00001?ooool3o`000004ooooool0003o0000o`00033ooooo0ol0003Tooooo`06o`000?oooooo0000
o`000?oooooo00000oooool00ol0003oooooooooo`03ooooo`007?ooool2o`0000Oooooo00?o0000
ooooooooool00_ooool01?l0003oooooooooool0000@ooooo`03o`000?oooooo000000Go00005ooo
ool2o`0003cooooo00?o0000ooooooooool0hoooool2o`000004ooooool0003oooooooooo`?o0000
1_ooool001cooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`02ooooo`04o`000?oo
ooooooooo`0000oooooo0_l000000ooooooo0000o`000003ooooo`03o`000?oooooooooo01Kooooo
00?o0000ooooooooool0oooooolQooooo`;o000000?oooooo`000?ooool02_ooool001cooooo00?o
0000ooooooooool01_ooool00ol0003oooooooooo`02ooooo`Co00003oooool3o`000004ooooool0
003oooooooooo`;o0000oooooolkooooo`;o000000Coooooo`000?l0003o00002_ooool001cooooo
00?o0000ooooooooool01_ooool00ol0003oooooooooo`02ooooo`04o`000?ooooooooooo`0000oo
oooo0ol000001?oooooo0000ooooooooool2o`0005_ooooo0ol000000ooooooo0000o`000003o`00
0>Kooooo000Looooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool00_ooool01?l0003o
ooooooooool0000?ooooo`;o000000Goooooo`000?l0003o0000ooooo`02o`0005cooooo00Co0000
oooooooooooo00000_ooool00ol0003oooooooooo`3Uooooo`007?ooool00ol0003oooooooooo`0:
ooooo`?o000000?oooooo`000?l000003oooool01?l0003oooooooooool00003ooooo`03o`000?oo
oooooooo01Gooooo00?o0000ooooooooool0@_ooool00ol0003oooooo`000003ooooo`03o`000?oo
oooooooo0>Gooooo000Looooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool04Oooool0
1?l0003oooooooooooooool3o`0001Sooooo0_l00013ooooo`;o00001?ooool2o`000>Kooooo000L
ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool0<?ooool2o`0004?ooooo00?o0000
ooooool000000_ooool2o`000003ooooool0003o00000>Cooooo000Looooo`03o`000?oooooooooo
00_ooooo00?o0000ooooooooool0<Oooool00ol0003oooooooooo`11ooooo`04o`000?oooooooooo
o`000>[ooooo00001?oooooo0000o`000?l00003ooooo`?o00001?ooool2o`0000Cooooo0_l00006
ooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool07?ooool00ol0003oooooooooo`0G
ooooo`03o`000?oooooooooo043ooooo0ol000000ooooooo0000o`00003Yooooo`000_ooool01Ol0
003ooooooooooooooooo000000?ooooo00Co0000oooooooooooo00000_ooool01?l0003ooooooooo
ool00002ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool01_ooool00ol0003ooooo
ooooo`0Looooo`03o`000?oooooooooo01Oooooo00?o0000ooooooooool0ooooool`ooooo`000_oo
ool00ol0003oooooooooo`05ooooo`04o`000?ooooooooooo`0000;ooooo00Co0000oooooooooooo
00000_ooool00ol0003oooooooooo`03ooooo`?o00001_ooool00ol0003oooooooooo`0Fooooo`03
o`000?oooooooooo00?ooooo00?o0000ooooooooool05_ooool3o`000?oooooo<Oooool000;ooooo
00?o0000ooooooooool01Oooool01?l0003oooooooooool00002ooooo`04o`000?ooooooooooo`00
00;ooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo
01Kooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`0Eooooo`Go0000ooooool`oooo
o`000_ooool01?l0003oooooooooooooool4o`0000?ooooo00Co0000oooooooooooo00000_ooool0
1?l0003oooooooooool00005ooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool00_oo
ool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool05?oo
ool7o`000?oooooo;oooool00003ooooool0003o000000?ooooo00?o0000ooooooooool01?ooool0
1?l0003oooooooooool00002ooooo`04o`000?ooooooooooo`0000Gooooo00?o0000ooooooooool0
1_ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool0
0oooool00ol0003oooooooooo`0Cooooo`So0000ooooool_ooooo`000_ooool01?l0003ooooooooo
ooooool5o`0000?ooooo0_l00004ooooo`;o00001_ooool00ol0003oooooooooo`0;ooooo`03o`00
0?oooooooooo017ooooo00?o0000ooooooooool06_ooool7o`000?oooooo;oooool001cooooo00?o
0000ooooooooool02_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo01_ooooo1Ol0
003ooooooc3ooooo000Looooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool0<Oooool3
o`000?oooooo<Oooool001cooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0boooo
o`03o`000?oooooooooo0?oooooo<?ooool001cooooo00?o0000ooooooooool01_ooool00ol0003o
ooooooooo`0Looooo`03o`000?oooooooooo0?ooooooB_ooool001cooooo00?o0000ooooooooool0
1_ooool00ol0003oooooooooo`0Looooo`03o`000?oooooooooo0?ooooooB_ooool001cooooo00?o
0000ooooooooool01_ooool00ol0003oooooooooo`0Gooooo`03o`000?oooooooooo00;ooooo00?o
0000ooooooooool07Oooool2o`000003ooooool0003o000000Co0000oooooolTooooo`007?ooool2
o`0000Sooooo00?o0000ooooooooool05_ooool00ol0003oooooooooo`02ooooo`03o`000?oooooo
oooo01gooooo00Go0000ooooooooooooooooo`000002ooooo`03o`000?oooooooooo0?oooooo8ooo
ool001cooooo00?o0000ooooooooool01oooool01?l0003oooooooooool0000Eooooo`03o`000?oo
oooooooo00;ooooo00?o0000ooooooooool07Oooool5o`0000;ooooo00?o0000ooooooooool0oooo
oolSooooo`007?ooool00ol0003oooooooooo`07ooooo`04o`000?ooooooooooo`0001Gooooo00?o
0000ooooooooool00_ooool00ol0003oooooooooo`0Nooooo`03o`000?oooooo000000?ooooo0_l0
003oooooobCooooo000Looooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool04oooool0
0ol0003oooooooooo`0Sooooo`03o`000?oooooo000000;ooooo0_l000000ooooooo0000o`00003o
ooooob;ooooo000Looooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool04oooool00ol0
003oooooooooo`0Tooooo`03o`000?oooooooooo0?oooooo:?ooool001cooooo00?o0000oooooooo
ool02_ooool00ol0003oooooooooo`0Dooooo`03o`000?oooooooooo02;ooooo0_l0003oooooob[o
oooo000Looooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool04oooool3o`000?oooooo
Coooool001cooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`0Eooooo`Co00000_oo
ool00ol0003oooooooooo`3ooooood[ooooo000Looooo`03o`000?oooooooooo00Oooooo00?o0000
ooooooooool05?ooool6o`000003ooooool0003ooooo0?ooooooBoooool001cooooo00?o0000oooo
ooooool01oooool00ol0003oooooooooo`0Cooooo`Oo000000?oooooo`000?ooool0oooooom;oooo
o`007?ooool2o`0000Sooooo00?o0000ooooooooool05?ooool6o`000003ooooool0003ooooo0?oo
ooooBoooool001cooooo00?o0000ooooooooool01oooool01?l0003oooooooooool0000Dooooo`Co
00000_ooool00ol0003oooooooooo`3ooooood[ooooo000Looooo`03o`000?oooooooooo00Oooooo
00Co0000oooooooooooo00005Oooool2o`0000?ooooo00?o0000ooooooooool0oooooom:ooooo`00
7?ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo01Cooooo00?o0000ooooooooool0
oooooom>ooooo`007?ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo01Cooooo00?o
0000ooooooooool0oooooom>ooooo`007?ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooo
oooo0?ooooooIOooool001cooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0Hoooo
o`?o0000oooooom:ooooo`007?ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo01_o
oooo0_l0003ooooood_ooooo000Looooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool0
6oooool2o`000?ooooooBoooool001cooooo00?o0000ooooooooool01oooool00ol0003ooooooooo
o`0Hooooo`03o`000?oooooooooo00Co0000oooooom9ooooo`007?ooool00ol0003oooooooooo`07
ooooo`03o`000?oooooooooo01Sooooo00?o0000ooooooooool00_l0003ooooood_ooooo000Loooo
o`;o00002?ooool01?l0003oooooooooool0000Gooooo`03o`000?oooooooooo00;o00000_ooool0
0ol0003oooooooooo`3oooooodKooooo000Looooo`03o`000?oooooooooo00Oooooo00Co0000oooo
oooooooo00005oooool00ol0003oooooooooo`05o`000?ooooooB?ooool001cooooo00?o0000oooo
ooooool02_ooool00ol0003oooooooooo`0Eooooo`03o`000?oooooooooo0?ooooooCOooool001co
oooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0Eooooo`03o`000?oooooooooo0?oo
ooooCOooool001cooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`3oooooofGooooo
000Looooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool0oooooomUooooo`007?ooool0
0ol0003oooooooooo`07ooooo`03o`000?oooooooooo01_ooooo00?o0000ooooooooool0oooooom:
ooooo`007?ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo01_ooooo00?o0000oooo
ooooool0oooooom:ooooo`007?ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo01So
oooo00Co0000oooooooooooo0000oooooom<ooooo`007?ooool00ol0003oooooooooo`08ooooo`03
o`000?oooooooooo01Oooooo00?o0000ooooool00000oooooom=ooooo`007?ooool2o`0000Wooooo
00?o0000ooooool000005oooool00ol0003oooooo`00003oooooodgooooo000Looooo`03o`000?oo
oooooooo00Sooooo00?o0000ooooool000006?ooool2o`000?ooooooCOooool001cooooo00?o0000
ooooooooool02_ooool00ol0003oooooooooo`0Fooooo`03o`000?oooooooooo0?ooooooC?ooool0
01cooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0Fooooo`03o`000?oooooooooo
0?ooooooC?ooool001cooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`3oooooofGo
oooo000Looooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool0oooooomUooooo`007?oo
ool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo01Wooooo00?o0000ooooooooool0oooo
oom;ooooo`007?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo01Wooooo00?o0000
ooooooooool0oooooom;ooooo`001Ol00003ooooo`;o00001?ooool2o`0000Cooooo0_l00006oooo
o`03o`000?oooooooooo00Sooooo00?o0000ooooooooool06?ooool2o`000?ooooooCOooool00005
ooooool0003oooooooooool000000_ooool01?l0003oooooooooool00002ooooo`04o`000?oooooo
ooooo`0000;ooooo00Co0000oooooooooooo00001Oooool00ol0003oooooooooo`08ooooo`03o`00
0?oooooooooo01Sooooo0_l0003oooooodgooooo0002ooooo`03o`000?oooooooooo00;ooooo00Co
0000oooooooooooo00000_ooool01?l0003oooooooooool00002ooooo`04o`000?ooooooooooo`00
00Gooooo00?o0000ooooooooool02?ooool00ol0003oooooo`00000Hooooo`;o0000oooooom=oooo
o`000oooool01Ol0003ooooooooooooooooo000000;ooooo00Co0000oooooooooooo00000_ooool0
1?l0003oooooooooool00002ooooo`03o`000?oooooooooo00?ooooo0ol00008ooooo`03o`000?oo
oooo000001Wooooo00?o0000ooooooooool0oooooom;ooooo`0000Go0000ooooooooooooooooo`00
0002ooooo`04o`000?ooooooooooo`0000;ooooo00Co0000oooooooooooo00000_ooool01?l0003o
ooooooooool00005ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool05oooool00ol0
003oooooooooo`3ooooood_ooooo00001Ol0003ooooooooooooooooo000000;ooooo00Co0000oooo
oooooooo00000_ooool01?l0003oooooooooool00002ooooo`04o`000?ooooooooooo`0000Gooooo
00?o0000ooooooooool02_ooool00ol0003oooooooooo`0Gooooo`03o`000?oooooooooo0?oooooo
Boooool00004ooooool0003o0000o`0000Cooooo0_l00004ooooo`;o00001?ooool2o`0000Kooooo
00?o0000ooooooooool02_ooool00ol0003oooooooooo`3oooooofGooooo000Looooo`03o`000?oo
oooooooo00[ooooo00?o0000ooooooooool0oooooomUooooo`007?ooool00ol0003oooooooooo`08
ooooo`03o`000?oooooooooo01Wooooo00?o0000ooooooooool0oooooom;ooooo`007?ooool00ol0
003oooooooooo`08ooooo`03o`000?oooooooooo01Sooooo0ol0003oooooodcooooo000Looooo`03
o`000?oooooooooo00Sooooo00?o0000ooooooooool05oooool5o`000?ooooooBoooool001cooooo
00?o0000ooooooooool02?ooool00ol0003oooooooooo`0Fooooo`Oo0000oooooom:ooooo`007?oo
ool00ol0003oooooooooo`08ooooo`03o`000?oooooo000001Gooooo2?l0003ooooood[ooooo000L
ooooo`;o00002Oooool00ol0003oooooo`00000Fooooo`Oo0000oooooom:ooooo`007?ooool00ol0
003oooooooooo`0:ooooo`03o`000?oooooooooo01Gooooo1Ol0003ooooood_ooooo000Looooo`03
o`000?oooooooooo00Wooooo00?o0000ooooooooool05oooool3o`000?ooooooC?ooool001cooooo
00?o0000ooooooooool02Oooool00ol0003oooooooooo`0Hooooo`03o`000?oooooooooo0?oooooo
Boooool001cooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`3oooooofKooooo000L
ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool0oooooomWooooo`007?ooool00ol0
003oooooooooo`08ooooo`03o`000?oooooooooo0?ooooooIoooool001cooooo00?o0000oooooooo
ool02?ooool00ol0003oooooooooo`0Oooooo`?o000000Coooooo`000?oooooooooo0ol0003ooooo
ockooooo000Looooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool08?ooool01_l0003o
ooooooooool0003oooooo`000?oooooo@Oooool001cooooo00?o0000ooooooooool02?ooool2o`00
027ooooo00Go0000ooooool0003o0000ooooo`05o`000?oooooo?Oooool001cooooo00?o0000oooo
ooooool02?ooool2o`00027ooooo00Ko0000ooooool0003o0000ooooool00003ooooo`03o`000?oo
oooooooo0?oooooo>oooool001cooooo0_l0000:ooooo`03o`000?oooooooooo01oooooo0_l00000
1?oooooo0000ooooooooool3o`000?oooooo?_ooool001cooooo00?o0000ooooooooool02Oooool0
0ol0003oooooooooo`0Oooooo`;o000000?oooooo`000?ooool0oooooom2ooooo`007?ooool00ol0
003oooooooooo`09ooooo`03o`000?oooooooooo01kooooo0_l000001?oooooo0000o`000?l0003o
oooood;ooooo000Looooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool0oooooomVoooo
o`007?ooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo0?ooooooI_ooool001cooooo
00?o0000ooooooooool02Oooool00ol0003oooooooooo`3oooooofKooooo000Looooo`03o`000?oo
oooooooo00Wooooo00?o0000ooooooooool0oooooomVooooo`007?ooool00ol0003oooooooooo`09
ooooo`03o`000?oooooooooo0?ooooooI_ooool001cooooo00?o0000ooooooooool02Oooool00ol0
003oooooooooo`3oooooofKooooo000Looooo`03o`000?oooooooooo00Wooooo00?o0000oooooooo
ool0oooooomVooooo`007?ooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo0?oooooo
I_ooool001cooooo0_l0000:ooooo`03o`000?oooooooooo0?ooooooI_ooool001cooooo00?o0000
ooooooooool02Oooool00ol0003oooooooooo`3oooooofKooooo000Looooo`03o`000?oooooooooo
00Wooooo00?o0000ooooooooool0oooooomVooooo`007?ooool00ol0003oooooooooo`09ooooo`03
o`000?oooooooooo0?ooooooI_ooool001cooooo00?o0000ooooooooool02Oooool00ol0003ooooo
ooooo`3oooooofKooooo000Looooo`03o`000?oooooooooo00Sooooo0ol0003oooooofOooooo000L
ooooo`03o`000?oooooooooo00Oooooo1Ol0003oooooofKooooo000Looooo`03o`000?oooooooooo
00Kooooo1ol0003oooooofGooooo000Looooo`03o`000?oooooooooo00Gooooo2?l0003oooooofGo
oooo000Looooo`03o`000?oooooooooo00Kooooo1ol0003oooooofGooooo000Looooo`;o00002?oo
ool5o`000?ooooooI_ooool001cooooo00?o0000ooooooooool02?ooool3o`000?ooooooIoooool0
01cooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`3oooooofKooooo000Looooo`03
o`000?oooooooooo0?ooooooL_ooool00?ooooooTOooool002kooooo0ol000001?oooooo0000o`00
0?ooool3o`000?ooooooFOooool002oooooo00Ko0000oooooooooooo0000ooooool0003ooooooeco
oooo000_ooooo`05o`000?ooooooooooo`000?ooool01Ol0003ooooooeSooooo000_ooooo`Co0000
00?oooooo`000?ooool00_ooool00ol0003oooooooooo`3ooooooeKooooo000_ooooo`04o`000?oo
ooooooooo`0000;ooooo0ol0003ooooooeWooooo000_ooooo`04o`000?ooooooooooo`000?oooooo
G_ooool002kooooo0ol000000ooooooo0000o`00003ooooooegooooo003ooooooi7ooooo003ooooo
oi7ooooo0000\
\>"],
  ImageRangeCache->{{{0, 399}, {246.188, 0}} -> {-9.97457, 198.299, 0.29553, \
9.45276}}]
}, Open  ]],

Cell["\<\
Anche in questo caso per\[OGrave] l'operazione sortisce l'effetto \
opposto: i punti sono troppo vicini tra loro, e quindi le etichette risultano \
in gran parte illeggibili, confondendo il grafico piuttosto che renderlo pi\
\[UGrave] semplice da leggere. Inoltre le abbreviazioni sono poste \
leggermente a destra rispetto ai simboli corrispondenti.
Rimediamo a questi inconvenienti visualizzando solamente le abbreviazioni dei \
gas rari (in corrispondenza di cui si trovano quasi tutti i picchi del \
grafico) e inserendo \"a mano\" le componenti testuali, agendo anche sul tipo \
di font utilizzato per visualizzare i caratteri:\
\>", "Text",
  PageWidth->PaperWidth],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(txt = 
        Map[Text[#, {AtomicNumber[#], 
                Ionization[#] /. Kilo\ Joule/Mole \[Rule] 1}, 
              TextStyle \[Rule] {FontFamily -> "\<Helvetica\>"}] &, {He, Ne, 
            Ar, Kr, Xe, Rn}];\)\), "\[IndentingNewLine]", 
    \(\(Show[graph, Epilog \[Rule] txt];\)\)}], "Input",
  CellLabel->"In[36]:=",
  PageWidth->PaperWidth],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
%%ImageSize: 400 247.214 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.01438 0.00942951 -0.0960424 0.000294803 [
[.01438 -0.0125 -3 -9 ]
[.01438 -0.0125 3 0 ]
[.20297 -0.0125 -6 -9 ]
[.20297 -0.0125 6 0 ]
[.39156 -0.0125 -6 -9 ]
[.39156 -0.0125 6 0 ]
[.58015 -0.0125 -6 -9 ]
[.58015 -0.0125 6 0 ]
[.76874 -0.0125 -6 -9 ]
[.76874 -0.0125 6 0 ]
[.95733 -0.0125 -9 -9 ]
[.95733 -0.0125 9 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .05136 -18 -4.5 ]
[-0.0125 .05136 0 4.5 ]
[-0.0125 .19876 -24 -4.5 ]
[-0.0125 .19876 0 4.5 ]
[-0.0125 .34616 -24 -4.5 ]
[-0.0125 .34616 0 4.5 ]
[-0.0125 .49356 -24 -4.5 ]
[-0.0125 .49356 0 4.5 ]
[ 0 0 -0.125 0 ]
[.03324 .60332 -9.625 -7 ]
[.03324 .60332 9.625 7 ]
[.10868 .51732 -9.625 -7 ]
[.10868 .51732 9.625 7 ]
[.18411 .35218 -7.96875 -7 ]
[.18411 .35218 7.96875 7 ]
[.35384 .30215 -7.96875 -7 ]
[.35384 .30215 7.96875 7 ]
[.52357 .249 -9.3125 -7 ]
[.52357 .249 9.3125 7 ]
[.82532 .20967 -9.625 -7 ]
[.82532 .20967 9.625 7 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.01438 0 m
.01438 .00625 L
s
[(0)] .01438 -0.0125 0 1 Mshowa
.20297 0 m
.20297 .00625 L
s
[(20)] .20297 -0.0125 0 1 Mshowa
.39156 0 m
.39156 .00625 L
s
[(40)] .39156 -0.0125 0 1 Mshowa
.58015 0 m
.58015 .00625 L
s
[(60)] .58015 -0.0125 0 1 Mshowa
.76874 0 m
.76874 .00625 L
s
[(80)] .76874 -0.0125 0 1 Mshowa
.95733 0 m
.95733 .00625 L
s
[(100)] .95733 -0.0125 0 1 Mshowa
.125 Mabswid
.06153 0 m
.06153 .00375 L
s
.10868 0 m
.10868 .00375 L
s
.15582 0 m
.15582 .00375 L
s
.25012 0 m
.25012 .00375 L
s
.29727 0 m
.29727 .00375 L
s
.34441 0 m
.34441 .00375 L
s
.43871 0 m
.43871 .00375 L
s
.48586 0 m
.48586 .00375 L
s
.533 0 m
.533 .00375 L
s
.6273 0 m
.6273 .00375 L
s
.67445 0 m
.67445 .00375 L
s
.72159 0 m
.72159 .00375 L
s
.81589 0 m
.81589 .00375 L
s
.86304 0 m
.86304 .00375 L
s
.91018 0 m
.91018 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .05136 m
.00625 .05136 L
s
[(500)] -0.0125 .05136 1 0 Mshowa
0 .19876 m
.00625 .19876 L
s
[(1000)] -0.0125 .19876 1 0 Mshowa
0 .34616 m
.00625 .34616 L
s
[(1500)] -0.0125 .34616 1 0 Mshowa
0 .49356 m
.00625 .49356 L
s
[(2000)] -0.0125 .49356 1 0 Mshowa
.125 Mabswid
0 .08084 m
.00375 .08084 L
s
0 .11032 m
.00375 .11032 L
s
0 .1398 m
.00375 .1398 L
s
0 .16928 m
.00375 .16928 L
s
0 .22824 m
.00375 .22824 L
s
0 .25772 m
.00375 .25772 L
s
0 .2872 m
.00375 .2872 L
s
0 .31668 m
.00375 .31668 L
s
0 .37564 m
.00375 .37564 L
s
0 .40512 m
.00375 .40512 L
s
0 .4346 m
.00375 .4346 L
s
0 .46408 m
.00375 .46408 L
s
0 .02188 m
.00375 .02188 L
s
0 .52304 m
.00375 .52304 L
s
0 .55252 m
.00375 .55252 L
s
0 .582 m
.00375 .582 L
s
0 .61148 m
.00375 .61148 L
s
.25 Mabswid
0 0 m
0 .61803 L
s
[ 5 ] 0 Mabsdash
.02381 .29074 m
.03324 .60332 L
.04267 .05528 L
.0521 .1691 L
.06153 .13998 L
.07096 .22417 L
.08039 .28788 L
.08982 .2913 L
.09925 .39952 L
.10868 .51732 L
.1181 .05012 L
.12753 .12143 L
.13696 .07418 L
.14639 .13582 L
.15582 .20221 L
.16525 .19864 L
.17468 .27279 L
.18411 .35218 L
.19354 .02742 L
.20297 .0778 L
.2124 .08998 L
.22183 .09794 L
.23126 .09558 L
.24069 .09638 L
.25012 .11545 L
.25955 .1278 L
.26898 .12801 L
.27841 .12114 L
.28784 .1237 L
.29727 .17117 L
.30669 .07459 L
.31612 .12863 L
.32555 .18314 L
.33498 .18134 L
.34441 .24 L
.35384 .30215 L
.36327 .02276 L
.3727 .06595 L
.38213 .08556 L
.39156 .09853 L
.40099 .09971 L
.41042 .1059 L
.41985 .11091 L
.42928 .11356 L
.43871 .11622 L
.44814 .14127 L
.45757 .11946 L
.467 .16238 L
.47643 .06855 L
.48586 .11286 L
Mistroke
.49529 .14973 L
.50471 .1602 L
.51414 .20124 L
.52357 .249 L
.533 .01472 L
.54243 .05218 L
.55186 .06259 L
.56129 .05944 L
.57072 .05817 L
.58015 .06009 L
.58958 .06194 L
.59901 .06412 L
.60844 .06513 L
.61787 .07863 L
.6273 .0704 L
.63673 .07256 L
.64616 .07515 L
.65559 .07751 L
.66502 .07987 L
.67445 .08184 L
.68388 .05829 L
.69331 .09322 L
.70273 .1283 L
.71216 .13096 L
.72159 .12801 L
.73102 .15159 L
.74045 .16338 L
.74988 .16044 L
.75931 .16636 L
.76874 .20082 L
.77817 .07769 L
.7876 .11489 L
.79703 .11126 L
.80646 .14334 L
.81589 .17812 L
.82532 .20967 L
.83475 .02188 L
.84418 .0541 L
.85361 .05106 L
.86304 .07701 L
.87247 .07141 L
.8819 .07612 L
.89132 .07996 L
.90075 .07642 L
.91018 .07441 L
.91961 .07524 L
.92904 .08113 L
.93847 .0832 L
.9479 .08644 L
.95733 .0888 L
Mistroke
.96676 .09116 L
.97619 .28248 L
Mfstroke
.0001 w
[ ] 0 setdash
.02381 .29074 -3.75 0 Mabsadd m
.02381 .29074 0 5 Mabsadd L
.02381 .29074 3.75 0 Mabsadd L
.02381 .29074 0 -5 Mabsadd L
.02381 .29074 -3.75 0 Mabsadd L closepath F
.03324 .60332 -3.75 0 Mabsadd m
.03324 .60332 0 5 Mabsadd L
.03324 .60332 3.75 0 Mabsadd L
.03324 .60332 0 -5 Mabsadd L
.03324 .60332 -3.75 0 Mabsadd L closepath F
.04267 .05528 -3.75 0 Mabsadd m
.04267 .05528 0 5 Mabsadd L
.04267 .05528 3.75 0 Mabsadd L
.04267 .05528 0 -5 Mabsadd L
.04267 .05528 -3.75 0 Mabsadd L closepath F
.0521 .1691 -3.75 0 Mabsadd m
.0521 .1691 0 5 Mabsadd L
.0521 .1691 3.75 0 Mabsadd L
.0521 .1691 0 -5 Mabsadd L
.0521 .1691 -3.75 0 Mabsadd L closepath F
.06153 .13998 -3.75 0 Mabsadd m
.06153 .13998 0 5 Mabsadd L
.06153 .13998 3.75 0 Mabsadd L
.06153 .13998 0 -5 Mabsadd L
.06153 .13998 -3.75 0 Mabsadd L closepath F
.07096 .22417 -3.75 0 Mabsadd m
.07096 .22417 0 5 Mabsadd L
.07096 .22417 3.75 0 Mabsadd L
.07096 .22417 0 -5 Mabsadd L
.07096 .22417 -3.75 0 Mabsadd L closepath F
.08039 .28788 -3.75 0 Mabsadd m
.08039 .28788 0 5 Mabsadd L
.08039 .28788 3.75 0 Mabsadd L
.08039 .28788 0 -5 Mabsadd L
.08039 .28788 -3.75 0 Mabsadd L closepath F
.08982 .2913 -3.75 0 Mabsadd m
.08982 .2913 0 5 Mabsadd L
.08982 .2913 3.75 0 Mabsadd L
.08982 .2913 0 -5 Mabsadd L
.08982 .2913 -3.75 0 Mabsadd L closepath F
.09925 .39952 -3.75 0 Mabsadd m
.09925 .39952 0 5 Mabsadd L
.09925 .39952 3.75 0 Mabsadd L
.09925 .39952 0 -5 Mabsadd L
.09925 .39952 -3.75 0 Mabsadd L closepath F
.10868 .51732 -3.75 0 Mabsadd m
.10868 .51732 0 5 Mabsadd L
.10868 .51732 3.75 0 Mabsadd L
.10868 .51732 0 -5 Mabsadd L
.10868 .51732 -3.75 0 Mabsadd L closepath F
.1181 .05012 -3.75 0 Mabsadd m
.1181 .05012 0 5 Mabsadd L
.1181 .05012 3.75 0 Mabsadd L
.1181 .05012 0 -5 Mabsadd L
.1181 .05012 -3.75 0 Mabsadd L closepath F
.12753 .12143 -3.75 0 Mabsadd m
.12753 .12143 0 5 Mabsadd L
.12753 .12143 3.75 0 Mabsadd L
.12753 .12143 0 -5 Mabsadd L
.12753 .12143 -3.75 0 Mabsadd L closepath F
.13696 .07418 -3.75 0 Mabsadd m
.13696 .07418 0 5 Mabsadd L
.13696 .07418 3.75 0 Mabsadd L
.13696 .07418 0 -5 Mabsadd L
.13696 .07418 -3.75 0 Mabsadd L closepath F
.14639 .13582 -3.75 0 Mabsadd m
.14639 .13582 0 5 Mabsadd L
.14639 .13582 3.75 0 Mabsadd L
.14639 .13582 0 -5 Mabsadd L
.14639 .13582 -3.75 0 Mabsadd L closepath F
.15582 .20221 -3.75 0 Mabsadd m
.15582 .20221 0 5 Mabsadd L
.15582 .20221 3.75 0 Mabsadd L
.15582 .20221 0 -5 Mabsadd L
.15582 .20221 -3.75 0 Mabsadd L closepath F
.16525 .19864 -3.75 0 Mabsadd m
.16525 .19864 0 5 Mabsadd L
.16525 .19864 3.75 0 Mabsadd L
.16525 .19864 0 -5 Mabsadd L
.16525 .19864 -3.75 0 Mabsadd L closepath F
.17468 .27279 -3.75 0 Mabsadd m
.17468 .27279 0 5 Mabsadd L
.17468 .27279 3.75 0 Mabsadd L
.17468 .27279 0 -5 Mabsadd L
.17468 .27279 -3.75 0 Mabsadd L closepath F
.18411 .35218 -3.75 0 Mabsadd m
.18411 .35218 0 5 Mabsadd L
.18411 .35218 3.75 0 Mabsadd L
.18411 .35218 0 -5 Mabsadd L
.18411 .35218 -3.75 0 Mabsadd L closepath F
.19354 .02742 -3.75 0 Mabsadd m
.19354 .02742 0 5 Mabsadd L
.19354 .02742 3.75 0 Mabsadd L
.19354 .02742 0 -5 Mabsadd L
.19354 .02742 -3.75 0 Mabsadd L closepath F
.20297 .0778 -3.75 0 Mabsadd m
.20297 .0778 0 5 Mabsadd L
.20297 .0778 3.75 0 Mabsadd L
.20297 .0778 0 -5 Mabsadd L
.20297 .0778 -3.75 0 Mabsadd L closepath F
.2124 .08998 -3.75 0 Mabsadd m
.2124 .08998 0 5 Mabsadd L
.2124 .08998 3.75 0 Mabsadd L
.2124 .08998 0 -5 Mabsadd L
.2124 .08998 -3.75 0 Mabsadd L closepath F
.22183 .09794 -3.75 0 Mabsadd m
.22183 .09794 0 5 Mabsadd L
.22183 .09794 3.75 0 Mabsadd L
.22183 .09794 0 -5 Mabsadd L
.22183 .09794 -3.75 0 Mabsadd L closepath F
.23126 .09558 -3.75 0 Mabsadd m
.23126 .09558 0 5 Mabsadd L
.23126 .09558 3.75 0 Mabsadd L
.23126 .09558 0 -5 Mabsadd L
.23126 .09558 -3.75 0 Mabsadd L closepath F
.24069 .09638 -3.75 0 Mabsadd m
.24069 .09638 0 5 Mabsadd L
.24069 .09638 3.75 0 Mabsadd L
.24069 .09638 0 -5 Mabsadd L
.24069 .09638 -3.75 0 Mabsadd L closepath F
.25012 .11545 -3.75 0 Mabsadd m
.25012 .11545 0 5 Mabsadd L
.25012 .11545 3.75 0 Mabsadd L
.25012 .11545 0 -5 Mabsadd L
.25012 .11545 -3.75 0 Mabsadd L closepath F
.25955 .1278 -3.75 0 Mabsadd m
.25955 .1278 0 5 Mabsadd L
.25955 .1278 3.75 0 Mabsadd L
.25955 .1278 0 -5 Mabsadd L
.25955 .1278 -3.75 0 Mabsadd L closepath F
.26898 .12801 -3.75 0 Mabsadd m
.26898 .12801 0 5 Mabsadd L
.26898 .12801 3.75 0 Mabsadd L
.26898 .12801 0 -5 Mabsadd L
.26898 .12801 -3.75 0 Mabsadd L closepath F
.27841 .12114 -3.75 0 Mabsadd m
.27841 .12114 0 5 Mabsadd L
.27841 .12114 3.75 0 Mabsadd L
.27841 .12114 0 -5 Mabsadd L
.27841 .12114 -3.75 0 Mabsadd L closepath F
.28784 .1237 -3.75 0 Mabsadd m
.28784 .1237 0 5 Mabsadd L
.28784 .1237 3.75 0 Mabsadd L
.28784 .1237 0 -5 Mabsadd L
.28784 .1237 -3.75 0 Mabsadd L closepath F
.29727 .17117 -3.75 0 Mabsadd m
.29727 .17117 0 5 Mabsadd L
.29727 .17117 3.75 0 Mabsadd L
.29727 .17117 0 -5 Mabsadd L
.29727 .17117 -3.75 0 Mabsadd L closepath F
.30669 .07459 -3.75 0 Mabsadd m
.30669 .07459 0 5 Mabsadd L
.30669 .07459 3.75 0 Mabsadd L
.30669 .07459 0 -5 Mabsadd L
.30669 .07459 -3.75 0 Mabsadd L closepath F
.31612 .12863 -3.75 0 Mabsadd m
.31612 .12863 0 5 Mabsadd L
.31612 .12863 3.75 0 Mabsadd L
.31612 .12863 0 -5 Mabsadd L
.31612 .12863 -3.75 0 Mabsadd L closepath F
.32555 .18314 -3.75 0 Mabsadd m
.32555 .18314 0 5 Mabsadd L
.32555 .18314 3.75 0 Mabsadd L
.32555 .18314 0 -5 Mabsadd L
.32555 .18314 -3.75 0 Mabsadd L closepath F
.33498 .18134 -3.75 0 Mabsadd m
.33498 .18134 0 5 Mabsadd L
.33498 .18134 3.75 0 Mabsadd L
.33498 .18134 0 -5 Mabsadd L
.33498 .18134 -3.75 0 Mabsadd L closepath F
.34441 .24 -3.75 0 Mabsadd m
.34441 .24 0 5 Mabsadd L
.34441 .24 3.75 0 Mabsadd L
.34441 .24 0 -5 Mabsadd L
.34441 .24 -3.75 0 Mabsadd L closepath F
.35384 .30215 -3.75 0 Mabsadd m
.35384 .30215 0 5 Mabsadd L
.35384 .30215 3.75 0 Mabsadd L
.35384 .30215 0 -5 Mabsadd L
.35384 .30215 -3.75 0 Mabsadd L closepath F
.36327 .02276 -3.75 0 Mabsadd m
.36327 .02276 0 5 Mabsadd L
.36327 .02276 3.75 0 Mabsadd L
.36327 .02276 0 -5 Mabsadd L
.36327 .02276 -3.75 0 Mabsadd L closepath F
.3727 .06595 -3.75 0 Mabsadd m
.3727 .06595 0 5 Mabsadd L
.3727 .06595 3.75 0 Mabsadd L
.3727 .06595 0 -5 Mabsadd L
.3727 .06595 -3.75 0 Mabsadd L closepath F
.38213 .08556 -3.75 0 Mabsadd m
.38213 .08556 0 5 Mabsadd L
.38213 .08556 3.75 0 Mabsadd L
.38213 .08556 0 -5 Mabsadd L
.38213 .08556 -3.75 0 Mabsadd L closepath F
.39156 .09853 -3.75 0 Mabsadd m
.39156 .09853 0 5 Mabsadd L
.39156 .09853 3.75 0 Mabsadd L
.39156 .09853 0 -5 Mabsadd L
.39156 .09853 -3.75 0 Mabsadd L closepath F
.40099 .09971 -3.75 0 Mabsadd m
.40099 .09971 0 5 Mabsadd L
.40099 .09971 3.75 0 Mabsadd L
.40099 .09971 0 -5 Mabsadd L
.40099 .09971 -3.75 0 Mabsadd L closepath F
.41042 .1059 -3.75 0 Mabsadd m
.41042 .1059 0 5 Mabsadd L
.41042 .1059 3.75 0 Mabsadd L
.41042 .1059 0 -5 Mabsadd L
.41042 .1059 -3.75 0 Mabsadd L closepath F
.41985 .11091 -3.75 0 Mabsadd m
.41985 .11091 0 5 Mabsadd L
.41985 .11091 3.75 0 Mabsadd L
.41985 .11091 0 -5 Mabsadd L
.41985 .11091 -3.75 0 Mabsadd L closepath F
.42928 .11356 -3.75 0 Mabsadd m
.42928 .11356 0 5 Mabsadd L
.42928 .11356 3.75 0 Mabsadd L
.42928 .11356 0 -5 Mabsadd L
.42928 .11356 -3.75 0 Mabsadd L closepath F
.43871 .11622 -3.75 0 Mabsadd m
.43871 .11622 0 5 Mabsadd L
.43871 .11622 3.75 0 Mabsadd L
.43871 .11622 0 -5 Mabsadd L
.43871 .11622 -3.75 0 Mabsadd L closepath F
.44814 .14127 -3.75 0 Mabsadd m
.44814 .14127 0 5 Mabsadd L
.44814 .14127 3.75 0 Mabsadd L
.44814 .14127 0 -5 Mabsadd L
.44814 .14127 -3.75 0 Mabsadd L closepath F
.45757 .11946 -3.75 0 Mabsadd m
.45757 .11946 0 5 Mabsadd L
.45757 .11946 3.75 0 Mabsadd L
.45757 .11946 0 -5 Mabsadd L
.45757 .11946 -3.75 0 Mabsadd L closepath F
.467 .16238 -3.75 0 Mabsadd m
.467 .16238 0 5 Mabsadd L
.467 .16238 3.75 0 Mabsadd L
.467 .16238 0 -5 Mabsadd L
.467 .16238 -3.75 0 Mabsadd L closepath F
.47643 .06855 -3.75 0 Mabsadd m
.47643 .06855 0 5 Mabsadd L
.47643 .06855 3.75 0 Mabsadd L
.47643 .06855 0 -5 Mabsadd L
.47643 .06855 -3.75 0 Mabsadd L closepath F
.48586 .11286 -3.75 0 Mabsadd m
.48586 .11286 0 5 Mabsadd L
.48586 .11286 3.75 0 Mabsadd L
.48586 .11286 0 -5 Mabsadd L
.48586 .11286 -3.75 0 Mabsadd L closepath F
.49529 .14973 -3.75 0 Mabsadd m
.49529 .14973 0 5 Mabsadd L
.49529 .14973 3.75 0 Mabsadd L
.49529 .14973 0 -5 Mabsadd L
.49529 .14973 -3.75 0 Mabsadd L closepath F
.50471 .1602 -3.75 0 Mabsadd m
.50471 .1602 0 5 Mabsadd L
.50471 .1602 3.75 0 Mabsadd L
.50471 .1602 0 -5 Mabsadd L
.50471 .1602 -3.75 0 Mabsadd L closepath F
.51414 .20124 -3.75 0 Mabsadd m
.51414 .20124 0 5 Mabsadd L
.51414 .20124 3.75 0 Mabsadd L
.51414 .20124 0 -5 Mabsadd L
.51414 .20124 -3.75 0 Mabsadd L closepath F
.52357 .249 -3.75 0 Mabsadd m
.52357 .249 0 5 Mabsadd L
.52357 .249 3.75 0 Mabsadd L
.52357 .249 0 -5 Mabsadd L
.52357 .249 -3.75 0 Mabsadd L closepath F
.533 .01472 -3.75 0 Mabsadd m
.533 .01472 0 5 Mabsadd L
.533 .01472 3.75 0 Mabsadd L
.533 .01472 0 -5 Mabsadd L
.533 .01472 -3.75 0 Mabsadd L closepath F
.54243 .05218 -3.75 0 Mabsadd m
.54243 .05218 0 5 Mabsadd L
.54243 .05218 3.75 0 Mabsadd L
.54243 .05218 0 -5 Mabsadd L
.54243 .05218 -3.75 0 Mabsadd L closepath F
.55186 .06259 -3.75 0 Mabsadd m
.55186 .06259 0 5 Mabsadd L
.55186 .06259 3.75 0 Mabsadd L
.55186 .06259 0 -5 Mabsadd L
.55186 .06259 -3.75 0 Mabsadd L closepath F
.56129 .05944 -3.75 0 Mabsadd m
.56129 .05944 0 5 Mabsadd L
.56129 .05944 3.75 0 Mabsadd L
.56129 .05944 0 -5 Mabsadd L
.56129 .05944 -3.75 0 Mabsadd L closepath F
.57072 .05817 -3.75 0 Mabsadd m
.57072 .05817 0 5 Mabsadd L
.57072 .05817 3.75 0 Mabsadd L
.57072 .05817 0 -5 Mabsadd L
.57072 .05817 -3.75 0 Mabsadd L closepath F
.58015 .06009 -3.75 0 Mabsadd m
.58015 .06009 0 5 Mabsadd L
.58015 .06009 3.75 0 Mabsadd L
.58015 .06009 0 -5 Mabsadd L
.58015 .06009 -3.75 0 Mabsadd L closepath F
.58958 .06194 -3.75 0 Mabsadd m
.58958 .06194 0 5 Mabsadd L
.58958 .06194 3.75 0 Mabsadd L
.58958 .06194 0 -5 Mabsadd L
.58958 .06194 -3.75 0 Mabsadd L closepath F
.59901 .06412 -3.75 0 Mabsadd m
.59901 .06412 0 5 Mabsadd L
.59901 .06412 3.75 0 Mabsadd L
.59901 .06412 0 -5 Mabsadd L
.59901 .06412 -3.75 0 Mabsadd L closepath F
.60844 .06513 -3.75 0 Mabsadd m
.60844 .06513 0 5 Mabsadd L
.60844 .06513 3.75 0 Mabsadd L
.60844 .06513 0 -5 Mabsadd L
.60844 .06513 -3.75 0 Mabsadd L closepath F
.61787 .07863 -3.75 0 Mabsadd m
.61787 .07863 0 5 Mabsadd L
.61787 .07863 3.75 0 Mabsadd L
.61787 .07863 0 -5 Mabsadd L
.61787 .07863 -3.75 0 Mabsadd L closepath F
.6273 .0704 -3.75 0 Mabsadd m
.6273 .0704 0 5 Mabsadd L
.6273 .0704 3.75 0 Mabsadd L
.6273 .0704 0 -5 Mabsadd L
.6273 .0704 -3.75 0 Mabsadd L closepath F
.63673 .07256 -3.75 0 Mabsadd m
.63673 .07256 0 5 Mabsadd L
.63673 .07256 3.75 0 Mabsadd L
.63673 .07256 0 -5 Mabsadd L
.63673 .07256 -3.75 0 Mabsadd L closepath F
.64616 .07515 -3.75 0 Mabsadd m
.64616 .07515 0 5 Mabsadd L
.64616 .07515 3.75 0 Mabsadd L
.64616 .07515 0 -5 Mabsadd L
.64616 .07515 -3.75 0 Mabsadd L closepath F
.65559 .07751 -3.75 0 Mabsadd m
.65559 .07751 0 5 Mabsadd L
.65559 .07751 3.75 0 Mabsadd L
.65559 .07751 0 -5 Mabsadd L
.65559 .07751 -3.75 0 Mabsadd L closepath F
.66502 .07987 -3.75 0 Mabsadd m
.66502 .07987 0 5 Mabsadd L
.66502 .07987 3.75 0 Mabsadd L
.66502 .07987 0 -5 Mabsadd L
.66502 .07987 -3.75 0 Mabsadd L closepath F
.67445 .08184 -3.75 0 Mabsadd m
.67445 .08184 0 5 Mabsadd L
.67445 .08184 3.75 0 Mabsadd L
.67445 .08184 0 -5 Mabsadd L
.67445 .08184 -3.75 0 Mabsadd L closepath F
.68388 .05829 -3.75 0 Mabsadd m
.68388 .05829 0 5 Mabsadd L
.68388 .05829 3.75 0 Mabsadd L
.68388 .05829 0 -5 Mabsadd L
.68388 .05829 -3.75 0 Mabsadd L closepath F
.69331 .09322 -3.75 0 Mabsadd m
.69331 .09322 0 5 Mabsadd L
.69331 .09322 3.75 0 Mabsadd L
.69331 .09322 0 -5 Mabsadd L
.69331 .09322 -3.75 0 Mabsadd L closepath F
.70273 .1283 -3.75 0 Mabsadd m
.70273 .1283 0 5 Mabsadd L
.70273 .1283 3.75 0 Mabsadd L
.70273 .1283 0 -5 Mabsadd L
.70273 .1283 -3.75 0 Mabsadd L closepath F
.71216 .13096 -3.75 0 Mabsadd m
.71216 .13096 0 5 Mabsadd L
.71216 .13096 3.75 0 Mabsadd L
.71216 .13096 0 -5 Mabsadd L
.71216 .13096 -3.75 0 Mabsadd L closepath F
.72159 .12801 -3.75 0 Mabsadd m
.72159 .12801 0 5 Mabsadd L
.72159 .12801 3.75 0 Mabsadd L
.72159 .12801 0 -5 Mabsadd L
.72159 .12801 -3.75 0 Mabsadd L closepath F
.73102 .15159 -3.75 0 Mabsadd m
.73102 .15159 0 5 Mabsadd L
.73102 .15159 3.75 0 Mabsadd L
.73102 .15159 0 -5 Mabsadd L
.73102 .15159 -3.75 0 Mabsadd L closepath F
.74045 .16338 -3.75 0 Mabsadd m
.74045 .16338 0 5 Mabsadd L
.74045 .16338 3.75 0 Mabsadd L
.74045 .16338 0 -5 Mabsadd L
.74045 .16338 -3.75 0 Mabsadd L closepath F
.74988 .16044 -3.75 0 Mabsadd m
.74988 .16044 0 5 Mabsadd L
.74988 .16044 3.75 0 Mabsadd L
.74988 .16044 0 -5 Mabsadd L
.74988 .16044 -3.75 0 Mabsadd L closepath F
.75931 .16636 -3.75 0 Mabsadd m
.75931 .16636 0 5 Mabsadd L
.75931 .16636 3.75 0 Mabsadd L
.75931 .16636 0 -5 Mabsadd L
.75931 .16636 -3.75 0 Mabsadd L closepath F
.76874 .20082 -3.75 0 Mabsadd m
.76874 .20082 0 5 Mabsadd L
.76874 .20082 3.75 0 Mabsadd L
.76874 .20082 0 -5 Mabsadd L
.76874 .20082 -3.75 0 Mabsadd L closepath F
.77817 .07769 -3.75 0 Mabsadd m
.77817 .07769 0 5 Mabsadd L
.77817 .07769 3.75 0 Mabsadd L
.77817 .07769 0 -5 Mabsadd L
.77817 .07769 -3.75 0 Mabsadd L closepath F
.7876 .11489 -3.75 0 Mabsadd m
.7876 .11489 0 5 Mabsadd L
.7876 .11489 3.75 0 Mabsadd L
.7876 .11489 0 -5 Mabsadd L
.7876 .11489 -3.75 0 Mabsadd L closepath F
.79703 .11126 -3.75 0 Mabsadd m
.79703 .11126 0 5 Mabsadd L
.79703 .11126 3.75 0 Mabsadd L
.79703 .11126 0 -5 Mabsadd L
.79703 .11126 -3.75 0 Mabsadd L closepath F
.80646 .14334 -3.75 0 Mabsadd m
.80646 .14334 0 5 Mabsadd L
.80646 .14334 3.75 0 Mabsadd L
.80646 .14334 0 -5 Mabsadd L
.80646 .14334 -3.75 0 Mabsadd L closepath F
.81589 .17812 -3.75 0 Mabsadd m
.81589 .17812 0 5 Mabsadd L
.81589 .17812 3.75 0 Mabsadd L
.81589 .17812 0 -5 Mabsadd L
.81589 .17812 -3.75 0 Mabsadd L closepath F
.82532 .20967 -3.75 0 Mabsadd m
.82532 .20967 0 5 Mabsadd L
.82532 .20967 3.75 0 Mabsadd L
.82532 .20967 0 -5 Mabsadd L
.82532 .20967 -3.75 0 Mabsadd L closepath F
.83475 .02188 -3.75 0 Mabsadd m
.83475 .02188 0 5 Mabsadd L
.83475 .02188 3.75 0 Mabsadd L
.83475 .02188 0 -5 Mabsadd L
.83475 .02188 -3.75 0 Mabsadd L closepath F
.84418 .0541 -3.75 0 Mabsadd m
.84418 .0541 0 5 Mabsadd L
.84418 .0541 3.75 0 Mabsadd L
.84418 .0541 0 -5 Mabsadd L
.84418 .0541 -3.75 0 Mabsadd L closepath F
.85361 .05106 -3.75 0 Mabsadd m
.85361 .05106 0 5 Mabsadd L
.85361 .05106 3.75 0 Mabsadd L
.85361 .05106 0 -5 Mabsadd L
.85361 .05106 -3.75 0 Mabsadd L closepath F
.86304 .07701 -3.75 0 Mabsadd m
.86304 .07701 0 5 Mabsadd L
.86304 .07701 3.75 0 Mabsadd L
.86304 .07701 0 -5 Mabsadd L
.86304 .07701 -3.75 0 Mabsadd L closepath F
.87247 .07141 -3.75 0 Mabsadd m
.87247 .07141 0 5 Mabsadd L
.87247 .07141 3.75 0 Mabsadd L
.87247 .07141 0 -5 Mabsadd L
.87247 .07141 -3.75 0 Mabsadd L closepath F
.8819 .07612 -3.75 0 Mabsadd m
.8819 .07612 0 5 Mabsadd L
.8819 .07612 3.75 0 Mabsadd L
.8819 .07612 0 -5 Mabsadd L
.8819 .07612 -3.75 0 Mabsadd L closepath F
.89132 .07996 -3.75 0 Mabsadd m
.89132 .07996 0 5 Mabsadd L
.89132 .07996 3.75 0 Mabsadd L
.89132 .07996 0 -5 Mabsadd L
.89132 .07996 -3.75 0 Mabsadd L closepath F
.90075 .07642 -3.75 0 Mabsadd m
.90075 .07642 0 5 Mabsadd L
.90075 .07642 3.75 0 Mabsadd L
.90075 .07642 0 -5 Mabsadd L
.90075 .07642 -3.75 0 Mabsadd L closepath F
.91018 .07441 -3.75 0 Mabsadd m
.91018 .07441 0 5 Mabsadd L
.91018 .07441 3.75 0 Mabsadd L
.91018 .07441 0 -5 Mabsadd L
.91018 .07441 -3.75 0 Mabsadd L closepath F
.91961 .07524 -3.75 0 Mabsadd m
.91961 .07524 0 5 Mabsadd L
.91961 .07524 3.75 0 Mabsadd L
.91961 .07524 0 -5 Mabsadd L
.91961 .07524 -3.75 0 Mabsadd L closepath F
.92904 .08113 -3.75 0 Mabsadd m
.92904 .08113 0 5 Mabsadd L
.92904 .08113 3.75 0 Mabsadd L
.92904 .08113 0 -5 Mabsadd L
.92904 .08113 -3.75 0 Mabsadd L closepath F
.93847 .0832 -3.75 0 Mabsadd m
.93847 .0832 0 5 Mabsadd L
.93847 .0832 3.75 0 Mabsadd L
.93847 .0832 0 -5 Mabsadd L
.93847 .0832 -3.75 0 Mabsadd L closepath F
.9479 .08644 -3.75 0 Mabsadd m
.9479 .08644 0 5 Mabsadd L
.9479 .08644 3.75 0 Mabsadd L
.9479 .08644 0 -5 Mabsadd L
.9479 .08644 -3.75 0 Mabsadd L closepath F
.95733 .0888 -3.75 0 Mabsadd m
.95733 .0888 0 5 Mabsadd L
.95733 .0888 3.75 0 Mabsadd L
.95733 .0888 0 -5 Mabsadd L
.95733 .0888 -3.75 0 Mabsadd L closepath F
.96676 .09116 -3.75 0 Mabsadd m
.96676 .09116 0 5 Mabsadd L
.96676 .09116 3.75 0 Mabsadd L
.96676 .09116 0 -5 Mabsadd L
.96676 .09116 -3.75 0 Mabsadd L closepath F
.97619 .28248 -3.75 0 Mabsadd m
.97619 .28248 0 5 Mabsadd L
.97619 .28248 3.75 0 Mabsadd L
.97619 .28248 0 -5 Mabsadd L
.97619 .28248 -3.75 0 Mabsadd L closepath F
gsave
.03324 .60332 -70.625 -11 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 22 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 14.000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(He) show
1.000 setlinewidth
grestore
gsave
.10868 .51732 -70.625 -11 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 22 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 14.000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Ne) show
1.000 setlinewidth
grestore
gsave
.18411 .35218 -68.9688 -11 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 22 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 14.000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Ar) show
1.000 setlinewidth
grestore
gsave
.35384 .30215 -68.9688 -11 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 22 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 14.000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Kr) show
1.000 setlinewidth
grestore
gsave
.52357 .249 -70.3125 -11 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 22 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 14.000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Xe) show
1.000 setlinewidth
grestore
gsave
.82532 .20967 -70.625 -11 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 22 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 14.000 moveto
%%IncludeResource: font Helvetica
%%IncludeFont: Helvetica
/Helvetica findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Rn) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[36]:=",
  ImageSize->{400, 247.188},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006@0000mb000`400?l00000o`00003ooooooonA
ooooo`00oooooonAooooo`008?ooool2o`0003oooooo1Ol00003ooooo`;o0000?_ooool3o`0000?o
oooo0_l0000mooooo`?o00001?ooool2o`0003gooooo0ol00004ooooo`;o0000>_ooool3o`0000Co
oooo0_l00004ooooo`;o00002_ooool001oooooo00Co0000oooooooooooo0000?oooool01?l0003o
ooooooooool00002ooooo`04o`000?ooooooooooo`0003kooooo00Go0000ooooooooooooooooo`00
0002ooooo`03o`000?oooooooooo03Wooooo00Go0000ooooooooooooooooo`000002ooooo`04o`00
0?ooooooooooo`0003_ooooo00Go0000ooooooooooooooooo`000002ooooo`04o`000?oooooooooo
o`0003[ooooo00?o0000ooooooooool00_ooool01?l0003oooooooooool00002ooooo`04o`000?oo
ooooooooo`0000Wooooo000Oooooo`04o`000?ooooooooooo`00043ooooo00?o0000ooooooooool0
0_ooool01?l0003oooooooooool0000kooooo`Go00000_ooool01?l0003oooooooooool0000koooo
o`05o`000?ooooooooooooooool000000_ooool01?l0003oooooooooool0000kooooo`05o`000?oo
ooooooooooooool000000_ooool01?l0003oooooooooool0000jooooo`03o`000?oooooooooo00;o
oooo00Co0000oooooooooooo00000_ooool01?l0003oooooooooool00009ooooo`007oooool01?l0
003oooooooooool00011ooooo`05o`000?ooooooooooooooool000000_ooool00ol0003ooooooooo
o`0iooooo`04o`000?ooooooooooo`0000?ooooo00Co0000oooooooooooo0000>oooool4o`0000?o
oooo00Co0000oooooooooooo0000??ooool3o`0000?ooooo00Co0000oooooooooooo0000>_ooool0
0ol0003oooooooooo`02ooooo`04o`000?ooooooooooo`0000;ooooo00Co0000oooooooooooo0000
2Oooool001oooooo00Co0000oooooooooooo0000?_ooool01Ol0003ooooooooooooooooo000000;o
oooo00Co0000oooooooooooo0000??ooool00ol0003oooooo`000003ooooo`04o`000?oooooooooo
o`0003_ooooo00?o0000ooooooooool01?ooool01?l0003oooooooooool0000kooooo`05o`000?oo
ooooooooooooool000000_ooool01?l0003oooooooooool0000jooooo`03o`000?oooooooooo00;o
oooo00Co0000oooooooooooo00000_ooool01?l0003oooooooooool00009ooooo`007oooool01?l0
003oooooooooool0000nooooo`05o`000?ooooooooooooooool000000_ooool01?l0003ooooooooo
ool0000mooooo`;o00000oooool01?l0003oooooooooool0000looooo`03o`000?oooooooooo00?o
oooo00Co0000oooooooooooo0000>oooool01Ol0003ooooooooooooooooo000000;ooooo00Co0000
oooooooooooo0000>Oooool2o`0000Cooooo00Co0000oooooooooooo00000_ooool01?l0003ooooo
ooooool00009ooooo`008?ooool2o`00043ooooo0ol00004ooooo`;o0000?oooool00ol0003ooooo
ooooo`02ooooo`;o0000?_ooool2o`0000Cooooo0_l0000mooooo`?o00001?ooool2o`0003_ooooo
00?o0000ooooooooool00oooool2o`0000Cooooo0_l0000:ooooo`00oooooonAooooo`00oooooonA
ooooo`00oooooonAooooo`00oooooonAooooo`00oooooonAooooo`00oooooonAooooo`007?oooooo
o`0007Go0000000Looooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool03oooool00ol0
003oooooooooo`0>ooooo`03o`000?oooooooooo00oooooo00?o0000ooooooooool03_ooool00ol0
003oooooooooo`0?ooooo`03o`000?oooooooooo00kooooo00?o0000ooooooooool03oooool00ol0
003oooooooooo`0>ooooo`03o`000?oooooooooo00oooooo00?o0000ooooooooool03_ooool00ol0
003oooooooooo`0?ooooo`03o`000?oooooooooo00kooooo00?o0000ooooooooool03_ooool